# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper
from fdxapi.models.government_issued_party_identification_entity import GovernmentIssuedPartyIdentificationEntity
from fdxapi.models.party_group_entity import PartyGroupEntity
from fdxapi.models.payment_delivery_address_entity import PaymentDeliveryAddressEntity
from fdxapi.models.payment_initiation_party_contact_method_entity import PaymentInitiationPartyContactMethodEntity
from fdxapi.models.payment_initiation_party_name_entity_1 import PaymentInitiationPartyNameEntity1
from fdxapi.models.payment_initiation_party_to_payment_method_entity import PaymentInitiationPartyToPaymentMethodEntity


class PaymentInitiationPartyEntity(object):

    """Implementation of the 'Payment Initiation Party entity' model.

    Party details for FI payment initiation. Each payment initiation party
    will have a separate entry per FI customer, for example we
    might have multiple payment initiation parties that represent the same
    physical person; since they are registered for separate
    customers they will have separate entries.

    Attributes:
        name (str): Human recognizable common name
        mtype (PartyType): Extensible string enum identifying the type of the
            party
        home_uri (str): URI for party, where an end user could learn more
            about the company or application involved in the data sharing chain
        logo_uri (str): URI for a logo asset to be displayed to the end user
        registry (Registry): The registry containing the party's registration
            with name and id: FDX, GLEIF, ICANN, PRIVATE
        registered_entity_name (str): Registered name of party
        registered_entity_id (str): Registered id of party
        party_groups (List[PartyGroupEntity]): The PartyGroups to which this
            initiation party belongs. Optional, can be omitted if party
            belongs to no groups.
        payment_initiation_party_name (PaymentInitiationPartyNameEntity1):
            Name entity associated with the payment initiation party
        government_issued_party_ids
            (List[GovernmentIssuedPartyIdentificationEntity]):
            Government-issued identification documents that are used to
            uniquely identify this payment initiation party
        payment_methods (List[PaymentInitiationPartyToPaymentMethodEntity]):
            Registrations between this payment initiation party and its
            payment methods
        locations (List[PaymentDeliveryAddressEntity]): Delivery addresses
            associated with this payment initiation party
        expires_timestamp (datetime): Describes when the entity will be
            automatically deleted. The entity will not go into the "DELETED"
            state. If this value is null or not provided, the entity will not
            expire automatically
        status (PartyStatus1): Current status of the payment initiation party
            entry
        contact_preferences (List[PaymentInitiationPartyContactMethodEntity]):
            Contact methods for this payment initiation party
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "name": 'name',
        "mtype": 'type',
        "home_uri": 'homeUri',
        "logo_uri": 'logoUri',
        "registry": 'registry',
        "registered_entity_name": 'registeredEntityName',
        "registered_entity_id": 'registeredEntityId',
        "party_groups": 'partyGroups',
        "payment_initiation_party_name": 'paymentInitiationPartyName',
        "government_issued_party_ids": 'governmentIssuedPartyIds',
        "payment_methods": 'paymentMethods',
        "locations": 'locations',
        "expires_timestamp": 'expiresTimestamp',
        "status": 'status',
        "contact_preferences": 'contactPreferences'
    }

    _optionals = [
        'home_uri',
        'logo_uri',
        'registry',
        'registered_entity_name',
        'registered_entity_id',
        'party_groups',
        'payment_initiation_party_name',
        'government_issued_party_ids',
        'payment_methods',
        'locations',
        'expires_timestamp',
        'status',
        'contact_preferences',
    ]

    def __init__(self,
                 name=None,
                 mtype=None,
                 home_uri=APIHelper.SKIP,
                 logo_uri=APIHelper.SKIP,
                 registry=APIHelper.SKIP,
                 registered_entity_name=APIHelper.SKIP,
                 registered_entity_id=APIHelper.SKIP,
                 party_groups=APIHelper.SKIP,
                 payment_initiation_party_name=APIHelper.SKIP,
                 government_issued_party_ids=APIHelper.SKIP,
                 payment_methods=APIHelper.SKIP,
                 locations=APIHelper.SKIP,
                 expires_timestamp=APIHelper.SKIP,
                 status=APIHelper.SKIP,
                 contact_preferences=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the PaymentInitiationPartyEntity class"""

        # Initialize members of the class
        self.name = name 
        self.mtype = mtype 
        if home_uri is not APIHelper.SKIP:
            self.home_uri = home_uri 
        if logo_uri is not APIHelper.SKIP:
            self.logo_uri = logo_uri 
        if registry is not APIHelper.SKIP:
            self.registry = registry 
        if registered_entity_name is not APIHelper.SKIP:
            self.registered_entity_name = registered_entity_name 
        if registered_entity_id is not APIHelper.SKIP:
            self.registered_entity_id = registered_entity_id 
        if party_groups is not APIHelper.SKIP:
            self.party_groups = party_groups 
        if payment_initiation_party_name is not APIHelper.SKIP:
            self.payment_initiation_party_name = payment_initiation_party_name 
        if government_issued_party_ids is not APIHelper.SKIP:
            self.government_issued_party_ids = government_issued_party_ids 
        if payment_methods is not APIHelper.SKIP:
            self.payment_methods = payment_methods 
        if locations is not APIHelper.SKIP:
            self.locations = locations 
        if expires_timestamp is not APIHelper.SKIP:
            self.expires_timestamp = APIHelper.apply_datetime_converter(expires_timestamp, APIHelper.RFC3339DateTime) if expires_timestamp else None 
        if status is not APIHelper.SKIP:
            self.status = status 
        if contact_preferences is not APIHelper.SKIP:
            self.contact_preferences = contact_preferences 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        name = dictionary.get("name") if dictionary.get("name") else None
        mtype = dictionary.get("type") if dictionary.get("type") else None
        home_uri = dictionary.get("homeUri") if dictionary.get("homeUri") else APIHelper.SKIP
        logo_uri = dictionary.get("logoUri") if dictionary.get("logoUri") else APIHelper.SKIP
        registry = dictionary.get("registry") if dictionary.get("registry") else APIHelper.SKIP
        registered_entity_name = dictionary.get("registeredEntityName") if dictionary.get("registeredEntityName") else APIHelper.SKIP
        registered_entity_id = dictionary.get("registeredEntityId") if dictionary.get("registeredEntityId") else APIHelper.SKIP
        party_groups = None
        if dictionary.get('partyGroups') is not None:
            party_groups = [PartyGroupEntity.from_dictionary(x) for x in dictionary.get('partyGroups')]
        else:
            party_groups = APIHelper.SKIP
        payment_initiation_party_name = PaymentInitiationPartyNameEntity1.from_dictionary(dictionary.get('paymentInitiationPartyName')) if 'paymentInitiationPartyName' in dictionary.keys() else APIHelper.SKIP
        government_issued_party_ids = None
        if dictionary.get('governmentIssuedPartyIds') is not None:
            government_issued_party_ids = [GovernmentIssuedPartyIdentificationEntity.from_dictionary(x) for x in dictionary.get('governmentIssuedPartyIds')]
        else:
            government_issued_party_ids = APIHelper.SKIP
        payment_methods = None
        if dictionary.get('paymentMethods') is not None:
            payment_methods = [PaymentInitiationPartyToPaymentMethodEntity.from_dictionary(x) for x in dictionary.get('paymentMethods')]
        else:
            payment_methods = APIHelper.SKIP
        locations = None
        if dictionary.get('locations') is not None:
            locations = [PaymentDeliveryAddressEntity.from_dictionary(x) for x in dictionary.get('locations')]
        else:
            locations = APIHelper.SKIP
        expires_timestamp = APIHelper.RFC3339DateTime.from_value(dictionary.get("expiresTimestamp")).datetime if dictionary.get("expiresTimestamp") else APIHelper.SKIP
        status = dictionary.get("status") if dictionary.get("status") else APIHelper.SKIP
        contact_preferences = None
        if dictionary.get('contactPreferences') is not None:
            contact_preferences = [PaymentInitiationPartyContactMethodEntity.from_dictionary(x) for x in dictionary.get('contactPreferences')]
        else:
            contact_preferences = APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(name,
                   mtype,
                   home_uri,
                   logo_uri,
                   registry,
                   registered_entity_name,
                   registered_entity_id,
                   party_groups,
                   payment_initiation_party_name,
                   government_issued_party_ids,
                   payment_methods,
                   locations,
                   expires_timestamp,
                   status,
                   contact_preferences,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'name={self.name!r}, '
                f'mtype={self.mtype!r}, '
                f'home_uri={(self.home_uri if hasattr(self, "home_uri") else None)!r}, '
                f'logo_uri={(self.logo_uri if hasattr(self, "logo_uri") else None)!r}, '
                f'registry={(self.registry if hasattr(self, "registry") else None)!r}, '
                f'registered_entity_name={(self.registered_entity_name if hasattr(self, "registered_entity_name") else None)!r}, '
                f'registered_entity_id={(self.registered_entity_id if hasattr(self, "registered_entity_id") else None)!r}, '
                f'party_groups={(self.party_groups if hasattr(self, "party_groups") else None)!r}, '
                f'payment_initiation_party_name={(self.payment_initiation_party_name if hasattr(self, "payment_initiation_party_name") else None)!r}, '
                f'government_issued_party_ids={(self.government_issued_party_ids if hasattr(self, "government_issued_party_ids") else None)!r}, '
                f'payment_methods={(self.payment_methods if hasattr(self, "payment_methods") else None)!r}, '
                f'locations={(self.locations if hasattr(self, "locations") else None)!r}, '
                f'expires_timestamp={(self.expires_timestamp if hasattr(self, "expires_timestamp") else None)!r}, '
                f'status={(self.status if hasattr(self, "status") else None)!r}, '
                f'contact_preferences={(self.contact_preferences if hasattr(self, "contact_preferences") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'name={self.name!s}, '
                f'mtype={self.mtype!s}, '
                f'home_uri={(self.home_uri if hasattr(self, "home_uri") else None)!s}, '
                f'logo_uri={(self.logo_uri if hasattr(self, "logo_uri") else None)!s}, '
                f'registry={(self.registry if hasattr(self, "registry") else None)!s}, '
                f'registered_entity_name={(self.registered_entity_name if hasattr(self, "registered_entity_name") else None)!s}, '
                f'registered_entity_id={(self.registered_entity_id if hasattr(self, "registered_entity_id") else None)!s}, '
                f'party_groups={(self.party_groups if hasattr(self, "party_groups") else None)!s}, '
                f'payment_initiation_party_name={(self.payment_initiation_party_name if hasattr(self, "payment_initiation_party_name") else None)!s}, '
                f'government_issued_party_ids={(self.government_issued_party_ids if hasattr(self, "government_issued_party_ids") else None)!s}, '
                f'payment_methods={(self.payment_methods if hasattr(self, "payment_methods") else None)!s}, '
                f'locations={(self.locations if hasattr(self, "locations") else None)!s}, '
                f'expires_timestamp={(self.expires_timestamp if hasattr(self, "expires_timestamp") else None)!s}, '
                f'status={(self.status if hasattr(self, "status") else None)!s}, '
                f'contact_preferences={(self.contact_preferences if hasattr(self, "contact_preferences") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
