# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper


class PaymentInitiationPartyMethodCreateResponseEntity(object):

    """Implementation of the 'Payment Initiation Party Method Create Response entity' model.

    Registration between a payment initiation party and a Payment Method

    Attributes:
        registration_id (str): Registration identifier between a payment
            initiation party and a payment method
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "registration_id": 'registrationId'
    }

    _optionals = [
        'registration_id',
    ]

    def __init__(self,
                 registration_id=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the PaymentInitiationPartyMethodCreateResponseEntity class"""

        # Initialize members of the class
        if registration_id is not APIHelper.SKIP:
            self.registration_id = registration_id 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        registration_id = dictionary.get("registrationId") if dictionary.get("registrationId") else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(registration_id,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'registration_id={(self.registration_id if hasattr(self, "registration_id") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'registration_id={(self.registration_id if hasattr(self, "registration_id") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
