# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper


class PaymentInitiationPartyNameEntity(object):

    """Implementation of the 'Payment Initiation Party Name entity' model.

    Generic entity that stores various names associated with a payment
    initiation party

    Attributes:
        alias_name (str): Alias name
        detail (OrganizationNameEntity | IndividualName | None): Details of
            the name
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "alias_name": 'aliasName',
        "detail": 'detail'
    }

    _optionals = [
        'alias_name',
        'detail',
    ]

    def __init__(self,
                 alias_name=APIHelper.SKIP,
                 detail=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the PaymentInitiationPartyNameEntity class"""

        # Initialize members of the class
        if alias_name is not APIHelper.SKIP:
            self.alias_name = alias_name 
        if detail is not APIHelper.SKIP:
            self.detail = detail 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        from fdxapi.utilities.union_type_lookup import UnionTypeLookUp

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        alias_name = dictionary.get("aliasName") if dictionary.get("aliasName") else APIHelper.SKIP
        detail = APIHelper.deserialize_union_type(UnionTypeLookUp.get('PaymentInitiationPartyNameEntityDetail'), dictionary.get('detail'), False) if dictionary.get('detail') is not None else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(alias_name,
                   detail,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'alias_name={(self.alias_name if hasattr(self, "alias_name") else None)!r}, '
                f'detail={(self.detail if hasattr(self, "detail") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'alias_name={(self.alias_name if hasattr(self, "alias_name") else None)!s}, '
                f'detail={(self.detail if hasattr(self, "detail") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
