# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper
from fdxapi.models.payment_generic_account_entity_2 import PaymentGenericAccountEntity2


class PaymentMethodDebitAccountEntity(object):

    """Implementation of the 'Payment Method Debit Account entity' model.

    A payment initiation party's payment method that debits an account

    Attributes:
        account_registration_id (str): Unique identifier of the registration
            of the sending account to the payment method associated with a
            particular payment initiation party
        sending_account (PaymentGenericAccountEntity2): Sending account details
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "account_registration_id": 'accountRegistrationId',
        "sending_account": 'sendingAccount'
    }

    _optionals = [
        'account_registration_id',
        'sending_account',
    ]

    def __init__(self,
                 account_registration_id=APIHelper.SKIP,
                 sending_account=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the PaymentMethodDebitAccountEntity class"""

        # Initialize members of the class
        if account_registration_id is not APIHelper.SKIP:
            self.account_registration_id = account_registration_id 
        if sending_account is not APIHelper.SKIP:
            self.sending_account = sending_account 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        account_registration_id = dictionary.get("accountRegistrationId") if dictionary.get("accountRegistrationId") else APIHelper.SKIP
        sending_account = PaymentGenericAccountEntity2.from_dictionary(dictionary.get('sendingAccount')) if 'sendingAccount' in dictionary.keys() else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(account_registration_id,
                   sending_account,
                   additional_properties)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """

        if isinstance(dictionary, cls):
            return True

        if not isinstance(dictionary, dict):
            return False

        return True

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'account_registration_id={(self.account_registration_id if hasattr(self, "account_registration_id") else None)!r}, '
                f'sending_account={(self.sending_account if hasattr(self, "sending_account") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'account_registration_id={(self.account_registration_id if hasattr(self, "account_registration_id") else None)!s}, '
                f'sending_account={(self.sending_account if hasattr(self, "sending_account") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
