# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper


class PaymentMethodId(object):

    """Implementation of the 'Payment Method Id' model.

    FI's unique identifier for the method of payment

    Attributes:
        payment_method_id (str): Unique identifier of the payment method
        external_local_instrument_1_code (str): Unique identifier code of the
            payment method rail as documented internally to the FI. This is
            aligned with ISO 20022 pain.001, transaction level
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "payment_method_id": 'paymentMethodId',
        "external_local_instrument_1_code": 'externalLocalInstrument1Code'
    }

    _optionals = [
        'payment_method_id',
        'external_local_instrument_1_code',
    ]

    def __init__(self,
                 payment_method_id=APIHelper.SKIP,
                 external_local_instrument_1_code=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the PaymentMethodId class"""

        # Initialize members of the class
        if payment_method_id is not APIHelper.SKIP:
            self.payment_method_id = payment_method_id 
        if external_local_instrument_1_code is not APIHelper.SKIP:
            self.external_local_instrument_1_code = external_local_instrument_1_code 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        payment_method_id = dictionary.get("paymentMethodId") if dictionary.get("paymentMethodId") else APIHelper.SKIP
        external_local_instrument_1_code = dictionary.get("externalLocalInstrument1Code") if dictionary.get("externalLocalInstrument1Code") else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(payment_method_id,
                   external_local_instrument_1_code,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'payment_method_id={(self.payment_method_id if hasattr(self, "payment_method_id") else None)!r}, '
                f'external_local_instrument_1_code={(self.external_local_instrument_1_code if hasattr(self, "external_local_instrument_1_code") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'payment_method_id={(self.payment_method_id if hasattr(self, "payment_method_id") else None)!s}, '
                f'external_local_instrument_1_code={(self.external_local_instrument_1_code if hasattr(self, "external_local_instrument_1_code") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
