# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper


class PaymentMethodSystemProprietary(object):

    """Implementation of the 'Payment Method System Proprietary' model.

    Proprietary identifier of the external clearing system when the payment
    rail is not part of the ISO 20022 scope

    Attributes:
        external_clearing_system_identification_1_proprietary (str): For few
            examples where the payment rail is not part of the ISO 20022 scope
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "external_clearing_system_identification_1_proprietary": 'externalClearingSystemIdentification1Proprietary'
    }

    _optionals = [
        'external_clearing_system_identification_1_proprietary',
    ]

    def __init__(self,
                 external_clearing_system_identification_1_proprietary=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the PaymentMethodSystemProprietary class"""

        # Initialize members of the class
        if external_clearing_system_identification_1_proprietary is not APIHelper.SKIP:
            self.external_clearing_system_identification_1_proprietary = external_clearing_system_identification_1_proprietary 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        external_clearing_system_identification_1_proprietary = dictionary.get("externalClearingSystemIdentification1Proprietary") if dictionary.get("externalClearingSystemIdentification1Proprietary") else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(external_clearing_system_identification_1_proprietary,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'external_clearing_system_identification_1_proprietary={(self.external_clearing_system_identification_1_proprietary if hasattr(self, "external_clearing_system_identification_1_proprietary") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'external_clearing_system_identification_1_proprietary={(self.external_clearing_system_identification_1_proprietary if hasattr(self, "external_clearing_system_identification_1_proprietary") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
