# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper
from fdxapi.models.incoming_and_outgoing_transfer_limits_2 import IncomingAndOutgoingTransferLimits2


class PaymentNetworkSupportedByAccount(object):

    """Implementation of the 'Payment Network Supported by Account' model.

    This provides details required to execute a transaction against the
    account within the payment network

    Attributes:
        bank_id (str): Bank identifier used by the payment network. Typically
            the 9-digit routing transit number (RTN) associated with the
            account number at a US institution, or the 3-digit Institution
            (FID) and 5-digit Transit numbers for Canadian institutions,
            including leading zeroes
        identifier (str): The number used to identify the account within the
            payment network. If identifierType is ACCOUNT_NUMBER, this is the
            account number; if identifierType is TOKENIZED_ACCOUNT_NUMBER,
            this is a tokenized account number
        identifier_type (PaymentNetworkIdentifierType3): Type of identifier,
            ACCOUNT_NUMBER or TOKENIZED_ACCOUNT_NUMBER
        mtype (PaymentNetworkType2): Type of Canadian or U.S. payment network,
            CA_ACSS, CA_LVTS, US_ACH, US_CHIPS, US_FEDWIRE, US_RTP
        transfer_in (bool): Can transfer funds to the account using this
            information
        transfer_out (bool): Can transfer funds from the account using this
            information
        supports_request_for_payment (bool): Can receive Request for Payments
        transfer_limits (IncomingAndOutgoingTransferLimits2): The amount
            limits for transfers
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "bank_id": 'bankId',
        "identifier": 'identifier',
        "identifier_type": 'identifierType',
        "mtype": 'type',
        "transfer_in": 'transferIn',
        "transfer_out": 'transferOut',
        "supports_request_for_payment": 'supportsRequestForPayment',
        "transfer_limits": 'transferLimits'
    }

    _optionals = [
        'bank_id',
        'identifier',
        'identifier_type',
        'mtype',
        'transfer_in',
        'transfer_out',
        'supports_request_for_payment',
        'transfer_limits',
    ]

    def __init__(self,
                 bank_id=APIHelper.SKIP,
                 identifier=APIHelper.SKIP,
                 identifier_type=APIHelper.SKIP,
                 mtype=APIHelper.SKIP,
                 transfer_in=APIHelper.SKIP,
                 transfer_out=APIHelper.SKIP,
                 supports_request_for_payment=APIHelper.SKIP,
                 transfer_limits=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the PaymentNetworkSupportedByAccount class"""

        # Initialize members of the class
        if bank_id is not APIHelper.SKIP:
            self.bank_id = bank_id 
        if identifier is not APIHelper.SKIP:
            self.identifier = identifier 
        if identifier_type is not APIHelper.SKIP:
            self.identifier_type = identifier_type 
        if mtype is not APIHelper.SKIP:
            self.mtype = mtype 
        if transfer_in is not APIHelper.SKIP:
            self.transfer_in = transfer_in 
        if transfer_out is not APIHelper.SKIP:
            self.transfer_out = transfer_out 
        if supports_request_for_payment is not APIHelper.SKIP:
            self.supports_request_for_payment = supports_request_for_payment 
        if transfer_limits is not APIHelper.SKIP:
            self.transfer_limits = transfer_limits 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        bank_id = dictionary.get("bankId") if dictionary.get("bankId") else APIHelper.SKIP
        identifier = dictionary.get("identifier") if dictionary.get("identifier") else APIHelper.SKIP
        identifier_type = dictionary.get("identifierType") if dictionary.get("identifierType") else APIHelper.SKIP
        mtype = dictionary.get("type") if dictionary.get("type") else APIHelper.SKIP
        transfer_in = dictionary.get("transferIn") if "transferIn" in dictionary.keys() else APIHelper.SKIP
        transfer_out = dictionary.get("transferOut") if "transferOut" in dictionary.keys() else APIHelper.SKIP
        supports_request_for_payment = dictionary.get("supportsRequestForPayment") if "supportsRequestForPayment" in dictionary.keys() else APIHelper.SKIP
        transfer_limits = IncomingAndOutgoingTransferLimits2.from_dictionary(dictionary.get('transferLimits')) if 'transferLimits' in dictionary.keys() else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(bank_id,
                   identifier,
                   identifier_type,
                   mtype,
                   transfer_in,
                   transfer_out,
                   supports_request_for_payment,
                   transfer_limits,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'bank_id={(self.bank_id if hasattr(self, "bank_id") else None)!r}, '
                f'identifier={(self.identifier if hasattr(self, "identifier") else None)!r}, '
                f'identifier_type={(self.identifier_type if hasattr(self, "identifier_type") else None)!r}, '
                f'mtype={(self.mtype if hasattr(self, "mtype") else None)!r}, '
                f'transfer_in={(self.transfer_in if hasattr(self, "transfer_in") else None)!r}, '
                f'transfer_out={(self.transfer_out if hasattr(self, "transfer_out") else None)!r}, '
                f'supports_request_for_payment={(self.supports_request_for_payment if hasattr(self, "supports_request_for_payment") else None)!r}, '
                f'transfer_limits={(self.transfer_limits if hasattr(self, "transfer_limits") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'bank_id={(self.bank_id if hasattr(self, "bank_id") else None)!s}, '
                f'identifier={(self.identifier if hasattr(self, "identifier") else None)!s}, '
                f'identifier_type={(self.identifier_type if hasattr(self, "identifier_type") else None)!s}, '
                f'mtype={(self.mtype if hasattr(self, "mtype") else None)!s}, '
                f'transfer_in={(self.transfer_in if hasattr(self, "transfer_in") else None)!s}, '
                f'transfer_out={(self.transfer_out if hasattr(self, "transfer_out") else None)!s}, '
                f'supports_request_for_payment={(self.supports_request_for_payment if hasattr(self, "supports_request_for_payment") else None)!s}, '
                f'transfer_limits={(self.transfer_limits if hasattr(self, "transfer_limits") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
