# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
import dateutil.parser

from fdxapi.api_helper import APIHelper
from fdxapi.models.employee_entity_1 import EmployeeEntity1
from fdxapi.models.employment_1 import Employment1
from fdxapi.models.hateoas_link import HateoasLink
from fdxapi.models.income import Income


class PayrollReportEntity(object):

    """Implementation of the 'Payroll Report entity' model.

    An employee's Payroll Report

    Attributes:
        report_id (str): The report identification number
        report_type (PayrollReportType1): The type of report
        generation_date (date): The generation date of the report
        data_as_of (date): The data in the report is as of this date.
        employee (EmployeeEntity1): The employee
        employment (Employment1): The employee's employment
        incomes (List[Income]): The employee's year to date income amounts for
            current and previous years omitted for Verification of Employment
            requests (VOE), included for Verification of Income and Employment
            requests (VOI / VOIE)
        links (List[HateoasLink]): Links to retrieve this payroll report, or
            to invoke related APIs
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "report_id": 'reportId',
        "report_type": 'reportType',
        "generation_date": 'generationDate',
        "employee": 'employee',
        "employment": 'employment',
        "data_as_of": 'dataAsOf',
        "incomes": 'incomes',
        "links": 'links'
    }

    _optionals = [
        'data_as_of',
        'incomes',
        'links',
    ]

    def __init__(self,
                 report_id=None,
                 report_type=None,
                 generation_date=None,
                 employee=None,
                 employment=None,
                 data_as_of=APIHelper.SKIP,
                 incomes=APIHelper.SKIP,
                 links=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the PayrollReportEntity class"""

        # Initialize members of the class
        self.report_id = report_id 
        self.report_type = report_type 
        self.generation_date = generation_date 
        if data_as_of is not APIHelper.SKIP:
            self.data_as_of = data_as_of 
        self.employee = employee 
        self.employment = employment 
        if incomes is not APIHelper.SKIP:
            self.incomes = incomes 
        if links is not APIHelper.SKIP:
            self.links = links 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        report_id = dictionary.get("reportId") if dictionary.get("reportId") else None
        report_type = dictionary.get("reportType") if dictionary.get("reportType") else None
        generation_date = dateutil.parser.parse(dictionary.get('generationDate')).date() if dictionary.get('generationDate') else None
        employee = EmployeeEntity1.from_dictionary(dictionary.get('employee')) if dictionary.get('employee') else None
        employment = Employment1.from_dictionary(dictionary.get('employment')) if dictionary.get('employment') else None
        data_as_of = dateutil.parser.parse(dictionary.get('dataAsOf')).date() if dictionary.get('dataAsOf') else APIHelper.SKIP
        incomes = None
        if dictionary.get('incomes') is not None:
            incomes = [Income.from_dictionary(x) for x in dictionary.get('incomes')]
        else:
            incomes = APIHelper.SKIP
        links = None
        if dictionary.get('links') is not None:
            links = [HateoasLink.from_dictionary(x) for x in dictionary.get('links')]
        else:
            links = APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(report_id,
                   report_type,
                   generation_date,
                   employee,
                   employment,
                   data_as_of,
                   incomes,
                   links,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'report_id={self.report_id!r}, '
                f'report_type={self.report_type!r}, '
                f'generation_date={self.generation_date!r}, '
                f'data_as_of={(self.data_as_of if hasattr(self, "data_as_of") else None)!r}, '
                f'employee={self.employee!r}, '
                f'employment={self.employment!r}, '
                f'incomes={(self.incomes if hasattr(self, "incomes") else None)!r}, '
                f'links={(self.links if hasattr(self, "links") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'report_id={self.report_id!s}, '
                f'report_type={self.report_type!s}, '
                f'generation_date={self.generation_date!s}, '
                f'data_as_of={(self.data_as_of if hasattr(self, "data_as_of") else None)!s}, '
                f'employee={self.employee!s}, '
                f'employment={self.employment!s}, '
                f'incomes={(self.incomes if hasattr(self, "incomes") else None)!s}, '
                f'links={(self.links if hasattr(self, "links") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
