# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper
from fdxapi.models.payroll_report_entity import PayrollReportEntity
from fdxapi.models.payroll_report_summary_entity import PayrollReportSummaryEntity


class PayrollReportListEntity(object):

    """Implementation of the 'Payroll Report List entity' model.

    Response object for /payroll/report API with list of reports available

    Attributes:
        summaries (List[PayrollReportSummaryEntity]): Zero or more
            PayrollReportSummaries for lightweight response
        reports (List[PayrollReportEntity]): Zero or more PayrollReports, for
            details response
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "summaries": 'summaries',
        "reports": 'reports'
    }

    _optionals = [
        'summaries',
        'reports',
    ]

    def __init__(self,
                 summaries=APIHelper.SKIP,
                 reports=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the PayrollReportListEntity class"""

        # Initialize members of the class
        if summaries is not APIHelper.SKIP:
            self.summaries = summaries 
        if reports is not APIHelper.SKIP:
            self.reports = reports 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        summaries = None
        if dictionary.get('summaries') is not None:
            summaries = [PayrollReportSummaryEntity.from_dictionary(x) for x in dictionary.get('summaries')]
        else:
            summaries = APIHelper.SKIP
        reports = None
        if dictionary.get('reports') is not None:
            reports = [PayrollReportEntity.from_dictionary(x) for x in dictionary.get('reports')]
        else:
            reports = APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(summaries,
                   reports,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'summaries={(self.summaries if hasattr(self, "summaries") else None)!r}, '
                f'reports={(self.reports if hasattr(self, "reports") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'summaries={(self.summaries if hasattr(self, "summaries") else None)!s}, '
                f'reports={(self.reports if hasattr(self, "reports") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
