# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
import dateutil.parser

from fdxapi.api_helper import APIHelper


class PensionSourceEntity(object):

    """Implementation of the 'Pension Source entity' model.

    The source of pension funds

    Attributes:
        display_name (str): Name of the source
        amount (float): Benefit Amount
        payment_option (str): Form of payment
        as_of_date (date): Date benefit was calculated
        frequency (PaymentFrequency3): ANNUALLY, BIWEEKLY, DAILY, MONTHLY,
            SEMIANNUALLY, SEMIMONTHLY, WEEKLY
        start_date (date): Assumed retirement date. As of date amount is
            payable
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "display_name": 'displayName',
        "amount": 'amount',
        "payment_option": 'paymentOption',
        "as_of_date": 'asOfDate',
        "frequency": 'frequency',
        "start_date": 'startDate'
    }

    _optionals = [
        'display_name',
        'amount',
        'payment_option',
        'as_of_date',
        'frequency',
        'start_date',
    ]

    def __init__(self,
                 display_name=APIHelper.SKIP,
                 amount=APIHelper.SKIP,
                 payment_option=APIHelper.SKIP,
                 as_of_date=APIHelper.SKIP,
                 frequency=APIHelper.SKIP,
                 start_date=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the PensionSourceEntity class"""

        # Initialize members of the class
        if display_name is not APIHelper.SKIP:
            self.display_name = display_name 
        if amount is not APIHelper.SKIP:
            self.amount = amount 
        if payment_option is not APIHelper.SKIP:
            self.payment_option = payment_option 
        if as_of_date is not APIHelper.SKIP:
            self.as_of_date = as_of_date 
        if frequency is not APIHelper.SKIP:
            self.frequency = frequency 
        if start_date is not APIHelper.SKIP:
            self.start_date = start_date 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        display_name = dictionary.get("displayName") if dictionary.get("displayName") else APIHelper.SKIP
        amount = dictionary.get("amount") if dictionary.get("amount") else APIHelper.SKIP
        payment_option = dictionary.get("paymentOption") if dictionary.get("paymentOption") else APIHelper.SKIP
        as_of_date = dateutil.parser.parse(dictionary.get('asOfDate')).date() if dictionary.get('asOfDate') else APIHelper.SKIP
        frequency = dictionary.get("frequency") if dictionary.get("frequency") else APIHelper.SKIP
        start_date = dateutil.parser.parse(dictionary.get('startDate')).date() if dictionary.get('startDate') else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(display_name,
                   amount,
                   payment_option,
                   as_of_date,
                   frequency,
                   start_date,
                   additional_properties)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """

        if isinstance(dictionary, cls):
            return True

        if not isinstance(dictionary, dict):
            return False

        return True

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'display_name={(self.display_name if hasattr(self, "display_name") else None)!r}, '
                f'amount={(self.amount if hasattr(self, "amount") else None)!r}, '
                f'payment_option={(self.payment_option if hasattr(self, "payment_option") else None)!r}, '
                f'as_of_date={(self.as_of_date if hasattr(self, "as_of_date") else None)!r}, '
                f'frequency={(self.frequency if hasattr(self, "frequency") else None)!r}, '
                f'start_date={(self.start_date if hasattr(self, "start_date") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'display_name={(self.display_name if hasattr(self, "display_name") else None)!s}, '
                f'amount={(self.amount if hasattr(self, "amount") else None)!s}, '
                f'payment_option={(self.payment_option if hasattr(self, "payment_option") else None)!s}, '
                f'as_of_date={(self.as_of_date if hasattr(self, "as_of_date") else None)!s}, '
                f'frequency={(self.frequency if hasattr(self, "frequency") else None)!s}, '
                f'start_date={(self.start_date if hasattr(self, "start_date") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
