# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper


class PlannedAvailabilityEntity(object):

    """Implementation of the 'Planned Availability entity' model.

    Provider's plan for API availability

    Attributes:
        status (AvailabilityStatus1): API availability status for this time
            period
        description (str): Description of API availability status
        start_time (datetime): Start time for this status period
        end_time (datetime): End time for this status period
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "status": 'status',
        "description": 'description',
        "start_time": 'startTime',
        "end_time": 'endTime'
    }

    _optionals = [
        'status',
        'description',
        'start_time',
        'end_time',
    ]

    def __init__(self,
                 status=APIHelper.SKIP,
                 description=APIHelper.SKIP,
                 start_time=APIHelper.SKIP,
                 end_time=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the PlannedAvailabilityEntity class"""

        # Initialize members of the class
        if status is not APIHelper.SKIP:
            self.status = status 
        if description is not APIHelper.SKIP:
            self.description = description 
        if start_time is not APIHelper.SKIP:
            self.start_time = APIHelper.apply_datetime_converter(start_time, APIHelper.RFC3339DateTime) if start_time else None 
        if end_time is not APIHelper.SKIP:
            self.end_time = APIHelper.apply_datetime_converter(end_time, APIHelper.RFC3339DateTime) if end_time else None 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        status = dictionary.get("status") if dictionary.get("status") else APIHelper.SKIP
        description = dictionary.get("description") if dictionary.get("description") else APIHelper.SKIP
        start_time = APIHelper.RFC3339DateTime.from_value(dictionary.get("startTime")).datetime if dictionary.get("startTime") else APIHelper.SKIP
        end_time = APIHelper.RFC3339DateTime.from_value(dictionary.get("endTime")).datetime if dictionary.get("endTime") else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(status,
                   description,
                   start_time,
                   end_time,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'status={(self.status if hasattr(self, "status") else None)!r}, '
                f'description={(self.description if hasattr(self, "description") else None)!r}, '
                f'start_time={(self.start_time if hasattr(self, "start_time") else None)!r}, '
                f'end_time={(self.end_time if hasattr(self, "end_time") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'status={(self.status if hasattr(self, "status") else None)!s}, '
                f'description={(self.description if hasattr(self, "description") else None)!s}, '
                f'start_time={(self.start_time if hasattr(self, "start_time") else None)!s}, '
                f'end_time={(self.end_time if hasattr(self, "end_time") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
