# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper


class PortionEntity(object):

    """Implementation of the 'Portion entity' model.

    An asset allocation with class and percentage

    Attributes:
        asset_class (AssetClass2): The asset class for this allocation
        percent (float): The percentage of this allocation
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "asset_class": 'assetClass',
        "percent": 'percent'
    }

    _optionals = [
        'asset_class',
        'percent',
    ]

    def __init__(self,
                 asset_class=APIHelper.SKIP,
                 percent=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the PortionEntity class"""

        # Initialize members of the class
        if asset_class is not APIHelper.SKIP:
            self.asset_class = asset_class 
        if percent is not APIHelper.SKIP:
            self.percent = percent 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        asset_class = dictionary.get("assetClass") if dictionary.get("assetClass") else APIHelper.SKIP
        percent = dictionary.get("percent") if dictionary.get("percent") else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(asset_class,
                   percent,
                   additional_properties)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """

        if isinstance(dictionary, cls):
            return True

        if not isinstance(dictionary, dict):
            return False

        return True

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'asset_class={(self.asset_class if hasattr(self, "asset_class") else None)!r}, '
                f'percent={(self.percent if hasattr(self, "percent") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'asset_class={(self.asset_class if hasattr(self, "asset_class") else None)!s}, '
                f'percent={(self.percent if hasattr(self, "percent") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
