# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper


class RecurringPaymentDurationEntity(object):

    """Implementation of the 'Recurring Payment Duration entity' model.

    Describes a payment's duration

    Attributes:
        mtype (RecurringPaymentDurationType2): Type of duration
        number_of_times (float): Maximum number of times a payment is to be
            sent. Required if type is set to NUMBEROFTIMES
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "mtype": 'type',
        "number_of_times": 'numberOfTimes'
    }

    _optionals = [
        'number_of_times',
    ]

    def __init__(self,
                 mtype=None,
                 number_of_times=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the RecurringPaymentDurationEntity class"""

        # Initialize members of the class
        self.mtype = mtype 
        if number_of_times is not APIHelper.SKIP:
            self.number_of_times = number_of_times 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        mtype = dictionary.get("type") if dictionary.get("type") else None
        number_of_times = dictionary.get("numberOfTimes") if dictionary.get("numberOfTimes") else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(mtype,
                   number_of_times,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'mtype={self.mtype!r}, '
                f'number_of_times={(self.number_of_times if hasattr(self, "number_of_times") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'mtype={self.mtype!s}, '
                f'number_of_times={(self.number_of_times if hasattr(self, "number_of_times") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
