# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper
from fdxapi.models.page_metadata import PageMetadata
from fdxapi.models.recurring_payment_entity import RecurringPaymentEntity
from fdxapi.models.synchronizable_array_links_entity_2 import SynchronizableArrayLinksEntity2
from fdxapi.models.updates_metadata_entity_2 import UpdatesMetadataEntity2


class RecurringPaymentsEntity(object):

    """Implementation of the 'Recurring Payments entity' model.

    A list of recurring payments

    Attributes:
        page (PageMetadata): Offset IDs for navigating result sets
        updates (UpdatesMetadataEntity2): Update IDs for retrieving updates
            since query
        links (SynchronizableArrayLinksEntity2): Resource URLs for navigating
            result sets
        recurring_payments (List[RecurringPaymentEntity]): Recurring payments
            retrieved by the operation
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "recurring_payments": 'recurringPayments',
        "page": 'page',
        "updates": 'updates',
        "links": 'links'
    }

    _optionals = [
        'page',
        'updates',
        'links',
    ]

    def __init__(self,
                 recurring_payments=None,
                 page=APIHelper.SKIP,
                 updates=APIHelper.SKIP,
                 links=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the RecurringPaymentsEntity class"""

        # Initialize members of the class
        if page is not APIHelper.SKIP:
            self.page = page 
        if updates is not APIHelper.SKIP:
            self.updates = updates 
        if links is not APIHelper.SKIP:
            self.links = links 
        self.recurring_payments = recurring_payments 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        recurring_payments = None
        if dictionary.get('recurringPayments') is not None:
            recurring_payments = [RecurringPaymentEntity.from_dictionary(x) for x in dictionary.get('recurringPayments')]
        page = PageMetadata.from_dictionary(dictionary.get('page')) if 'page' in dictionary.keys() else APIHelper.SKIP
        updates = UpdatesMetadataEntity2.from_dictionary(dictionary.get('updates')) if 'updates' in dictionary.keys() else APIHelper.SKIP
        links = SynchronizableArrayLinksEntity2.from_dictionary(dictionary.get('links')) if 'links' in dictionary.keys() else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(recurring_payments,
                   page,
                   updates,
                   links,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'page={(self.page if hasattr(self, "page") else None)!r}, '
                f'updates={(self.updates if hasattr(self, "updates") else None)!r}, '
                f'links={(self.links if hasattr(self, "links") else None)!r}, '
                f'recurring_payments={self.recurring_payments!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'page={(self.page if hasattr(self, "page") else None)!s}, '
                f'updates={(self.updates if hasattr(self, "updates") else None)!s}, '
                f'links={(self.links if hasattr(self, "links") else None)!s}, '
                f'recurring_payments={self.recurring_payments!s}, '
                f'additional_properties={self.additional_properties!s})')
