# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper


class RegistryReference(object):

    """Implementation of the 'Registry Reference' model.

    Used for registry references. Properties in this structure use
    'snake_case' names to match the properties in [IETF RFC
    7591](https://datatracker.ietf.org/doc/rfc7591/)

    Attributes:
        registered_entity_name (str): The legal company name for the
            intermediary
        registered_entity_id (str): An ID representing the intermediary that
            can be looked up from a legal identity registry source
        registry (Registry): The Registry source
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "registered_entity_name": 'registered_entity_name',
        "registered_entity_id": 'registered_entity_id',
        "registry": 'registry'
    }

    _optionals = [
        'registered_entity_name',
        'registered_entity_id',
        'registry',
    ]

    def __init__(self,
                 registered_entity_name=APIHelper.SKIP,
                 registered_entity_id=APIHelper.SKIP,
                 registry=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the RegistryReference class"""

        # Initialize members of the class
        if registered_entity_name is not APIHelper.SKIP:
            self.registered_entity_name = registered_entity_name 
        if registered_entity_id is not APIHelper.SKIP:
            self.registered_entity_id = registered_entity_id 
        if registry is not APIHelper.SKIP:
            self.registry = registry 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        registered_entity_name = dictionary.get("registered_entity_name") if dictionary.get("registered_entity_name") else APIHelper.SKIP
        registered_entity_id = dictionary.get("registered_entity_id") if dictionary.get("registered_entity_id") else APIHelper.SKIP
        registry = dictionary.get("registry") if dictionary.get("registry") else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(registered_entity_name,
                   registered_entity_id,
                   registry,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'registered_entity_name={(self.registered_entity_name if hasattr(self, "registered_entity_name") else None)!r}, '
                f'registered_entity_id={(self.registered_entity_id if hasattr(self, "registered_entity_id") else None)!r}, '
                f'registry={(self.registry if hasattr(self, "registry") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'registered_entity_name={(self.registered_entity_name if hasattr(self, "registered_entity_name") else None)!s}, '
                f'registered_entity_id={(self.registered_entity_id if hasattr(self, "registered_entity_id") else None)!s}, '
                f'registry={(self.registry if hasattr(self, "registry") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
