# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper
from fdxapi.models.hateoas_link import HateoasLink


class ResourceEntity(object):

    """Implementation of the 'Resource entity' model.

    Details of resource entity

    Attributes:
        resource_id (str): Long-term persistent identifier for the Resource
        status (ResourceStatus2): Status of Resource
        description (str): Description of resource
        links (List[HateoasLink]): Links to retrieve this resource, or to
            invoke other APIs
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "resource_id": 'resourceId',
        "status": 'status',
        "description": 'description',
        "links": 'links'
    }

    _optionals = [
        'resource_id',
        'status',
        'description',
        'links',
    ]

    def __init__(self,
                 resource_id=APIHelper.SKIP,
                 status=APIHelper.SKIP,
                 description=APIHelper.SKIP,
                 links=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the ResourceEntity class"""

        # Initialize members of the class
        if resource_id is not APIHelper.SKIP:
            self.resource_id = resource_id 
        if status is not APIHelper.SKIP:
            self.status = status 
        if description is not APIHelper.SKIP:
            self.description = description 
        if links is not APIHelper.SKIP:
            self.links = links 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        resource_id = dictionary.get("resourceId") if dictionary.get("resourceId") else APIHelper.SKIP
        status = dictionary.get("status") if dictionary.get("status") else APIHelper.SKIP
        description = dictionary.get("description") if dictionary.get("description") else APIHelper.SKIP
        links = None
        if dictionary.get('links') is not None:
            links = [HateoasLink.from_dictionary(x) for x in dictionary.get('links')]
        else:
            links = APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(resource_id,
                   status,
                   description,
                   links,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'resource_id={(self.resource_id if hasattr(self, "resource_id") else None)!r}, '
                f'status={(self.status if hasattr(self, "status") else None)!r}, '
                f'description={(self.description if hasattr(self, "description") else None)!r}, '
                f'links={(self.links if hasattr(self, "links") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'resource_id={(self.resource_id if hasattr(self, "resource_id") else None)!s}, '
                f'status={(self.status if hasattr(self, "status") else None)!s}, '
                f'description={(self.description if hasattr(self, "description") else None)!s}, '
                f'links={(self.links if hasattr(self, "links") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
