# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper
from fdxapi.models.fi_attribute_entity import FiAttributeEntity


class RewardBalanceEntity(object):

    """Implementation of the 'Reward Balance entity' model.

    Reward program balance

    Attributes:
        name (str): Name used to denominate the balance
        mtype (RewardType2): The type of the reward balance - CASHBACK, MILES,
            POINTS
        balance (float): Total units available for redemption at time of
            download
        accrued_ytd (float): Total units accrued in the current program year
            at time of download
        redeemed_ytd (float): Total units redeemed in the current program year
            at time of download
        qualifying (bool): Balance used for qualifying purposes
        fi_attributes (List[FiAttributeEntity]): Array of FI-specific
            attributes
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "name": 'name',
        "mtype": 'type',
        "balance": 'balance',
        "accrued_ytd": 'accruedYtd',
        "redeemed_ytd": 'redeemedYtd',
        "qualifying": 'qualifying',
        "fi_attributes": 'fiAttributes'
    }

    _optionals = [
        'name',
        'mtype',
        'balance',
        'accrued_ytd',
        'redeemed_ytd',
        'qualifying',
        'fi_attributes',
    ]

    def __init__(self,
                 name=APIHelper.SKIP,
                 mtype=APIHelper.SKIP,
                 balance=APIHelper.SKIP,
                 accrued_ytd=APIHelper.SKIP,
                 redeemed_ytd=APIHelper.SKIP,
                 qualifying=False,
                 fi_attributes=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the RewardBalanceEntity class"""

        # Initialize members of the class
        if name is not APIHelper.SKIP:
            self.name = name 
        if mtype is not APIHelper.SKIP:
            self.mtype = mtype 
        if balance is not APIHelper.SKIP:
            self.balance = balance 
        if accrued_ytd is not APIHelper.SKIP:
            self.accrued_ytd = accrued_ytd 
        if redeemed_ytd is not APIHelper.SKIP:
            self.redeemed_ytd = redeemed_ytd 
        self.qualifying = qualifying 
        if fi_attributes is not APIHelper.SKIP:
            self.fi_attributes = fi_attributes 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        name = dictionary.get("name") if dictionary.get("name") else APIHelper.SKIP
        mtype = dictionary.get("type") if dictionary.get("type") else APIHelper.SKIP
        balance = dictionary.get("balance") if dictionary.get("balance") else APIHelper.SKIP
        accrued_ytd = dictionary.get("accruedYtd") if dictionary.get("accruedYtd") else APIHelper.SKIP
        redeemed_ytd = dictionary.get("redeemedYtd") if dictionary.get("redeemedYtd") else APIHelper.SKIP
        qualifying = dictionary.get("qualifying") if dictionary.get("qualifying") else False
        fi_attributes = None
        if dictionary.get('fiAttributes') is not None:
            fi_attributes = [FiAttributeEntity.from_dictionary(x) for x in dictionary.get('fiAttributes')]
        else:
            fi_attributes = APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(name,
                   mtype,
                   balance,
                   accrued_ytd,
                   redeemed_ytd,
                   qualifying,
                   fi_attributes,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'name={(self.name if hasattr(self, "name") else None)!r}, '
                f'mtype={(self.mtype if hasattr(self, "mtype") else None)!r}, '
                f'balance={(self.balance if hasattr(self, "balance") else None)!r}, '
                f'accrued_ytd={(self.accrued_ytd if hasattr(self, "accrued_ytd") else None)!r}, '
                f'redeemed_ytd={(self.redeemed_ytd if hasattr(self, "redeemed_ytd") else None)!r}, '
                f'qualifying={(self.qualifying if hasattr(self, "qualifying") else None)!r}, '
                f'fi_attributes={(self.fi_attributes if hasattr(self, "fi_attributes") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'name={(self.name if hasattr(self, "name") else None)!s}, '
                f'mtype={(self.mtype if hasattr(self, "mtype") else None)!s}, '
                f'balance={(self.balance if hasattr(self, "balance") else None)!s}, '
                f'accrued_ytd={(self.accrued_ytd if hasattr(self, "accrued_ytd") else None)!s}, '
                f'redeemed_ytd={(self.redeemed_ytd if hasattr(self, "redeemed_ytd") else None)!s}, '
                f'qualifying={(self.qualifying if hasattr(self, "qualifying") else None)!s}, '
                f'fi_attributes={(self.fi_attributes if hasattr(self, "fi_attributes") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
