# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper
from fdxapi.models.fi_attribute_entity import FiAttributeEntity
from fdxapi.models.reward_program_membership_entity import RewardProgramMembershipEntity


class RewardProgramEntity(object):

    """Implementation of the 'Reward Program entity' model.

    Reward program detail

    Attributes:
        reward_program_id (str): Long term persistent identity of the reward
            program
        program_name (str): Name of reward program
        program_url (str): URL of reward program
        memberships (List[RewardProgramMembershipEntity]): Array of reward
            memberships
        fi_attributes (List[FiAttributeEntity]): Array of FI-specific
            attributes
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "reward_program_id": 'rewardProgramId',
        "program_name": 'programName',
        "program_url": 'programUrl',
        "memberships": 'memberships',
        "fi_attributes": 'fiAttributes'
    }

    _optionals = [
        'reward_program_id',
        'program_name',
        'program_url',
        'memberships',
        'fi_attributes',
    ]

    def __init__(self,
                 reward_program_id=APIHelper.SKIP,
                 program_name=APIHelper.SKIP,
                 program_url=APIHelper.SKIP,
                 memberships=APIHelper.SKIP,
                 fi_attributes=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the RewardProgramEntity class"""

        # Initialize members of the class
        if reward_program_id is not APIHelper.SKIP:
            self.reward_program_id = reward_program_id 
        if program_name is not APIHelper.SKIP:
            self.program_name = program_name 
        if program_url is not APIHelper.SKIP:
            self.program_url = program_url 
        if memberships is not APIHelper.SKIP:
            self.memberships = memberships 
        if fi_attributes is not APIHelper.SKIP:
            self.fi_attributes = fi_attributes 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        reward_program_id = dictionary.get("rewardProgramId") if dictionary.get("rewardProgramId") else APIHelper.SKIP
        program_name = dictionary.get("programName") if dictionary.get("programName") else APIHelper.SKIP
        program_url = dictionary.get("programUrl") if dictionary.get("programUrl") else APIHelper.SKIP
        memberships = None
        if dictionary.get('memberships') is not None:
            memberships = [RewardProgramMembershipEntity.from_dictionary(x) for x in dictionary.get('memberships')]
        else:
            memberships = APIHelper.SKIP
        fi_attributes = None
        if dictionary.get('fiAttributes') is not None:
            fi_attributes = [FiAttributeEntity.from_dictionary(x) for x in dictionary.get('fiAttributes')]
        else:
            fi_attributes = APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(reward_program_id,
                   program_name,
                   program_url,
                   memberships,
                   fi_attributes,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'reward_program_id={(self.reward_program_id if hasattr(self, "reward_program_id") else None)!r}, '
                f'program_name={(self.program_name if hasattr(self, "program_name") else None)!r}, '
                f'program_url={(self.program_url if hasattr(self, "program_url") else None)!r}, '
                f'memberships={(self.memberships if hasattr(self, "memberships") else None)!r}, '
                f'fi_attributes={(self.fi_attributes if hasattr(self, "fi_attributes") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'reward_program_id={(self.reward_program_id if hasattr(self, "reward_program_id") else None)!s}, '
                f'program_name={(self.program_name if hasattr(self, "program_name") else None)!s}, '
                f'program_url={(self.program_url if hasattr(self, "program_url") else None)!s}, '
                f'memberships={(self.memberships if hasattr(self, "memberships") else None)!s}, '
                f'fi_attributes={(self.fi_attributes if hasattr(self, "fi_attributes") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
