# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
import dateutil.parser

from fdxapi.api_helper import APIHelper
from fdxapi.models.address import Address
from fdxapi.models.date_and_amount import DateAndAmount
from fdxapi.models.description_and_amount import DescriptionAndAmount
from fdxapi.models.error_1 import Error1
from fdxapi.models.hateoas_link import HateoasLink
from fdxapi.models.tax_form_attribute import TaxFormAttribute
from fdxapi.models.tax_party_1 import TaxParty1
from fdxapi.models.tax_party_8 import TaxParty8


class RoyaltyIncomeStatement(object):

    """Implementation of the 'Royalty Income Statement' model.

    Royalty Income Statement for IRS Form 1040 Schedule E

    Attributes:
        tax_year (int): Year for which taxes are being paid
        corrected (bool): True to indicate this is a corrected tax form
        account_id (str): Long-term persistent identity of the source account.
            Not the account number
        tax_form_id (str): Long-term persistent id for this tax form.
            Depending upon the data provider, this may be the same id as the
            enclosing tax statement id, or this may be a different id, or this
            id may be omitted.
        tax_form_date (date): Date of production or delivery of the tax form
        additional_information (str): Additional explanation text or content
            about this tax form
        tax_form_type (TypeFormType1): Enumerated name of the tax form entity
            e.g. "TaxW2"
        issuer (TaxParty8): Issuer's name, address, phone, and TIN. Issuer
            data need only be transmitted on enclosing TaxStatement, if it is
            the same on all its included tax forms.
        recipient (TaxParty1): Recipient's name, address, phone, and TIN.
            Recipient data need only be transmitted on enclosing TaxStatement,
            if it is the same on all its included tax forms.
        attributes (List[TaxFormAttribute]): Additional attributes for this
            tax form when defined fields are not available. Some specific
            additional attributes already defined by providers: Fields
            required by [IRS
            FIRE](https://www.irs.gov/e-file-providers/filing-information-retur
            ns-electronically-fire): Name Control, Type of Identification
            Number (EIN, SSN, ITIN, ATIN). (ATIN is tax ID number for pending
            adoptions.) Tax form provider field for taxpayer notification:
            Recipient Email Address.
        error (Error1): Present if an error was encountered while retrieving
            this form
        links (List[HateoasLink]): Links to retrieve this form as data or
            image, or to invoke other APIs
        property_address (Address): Box 1a, Physical address of property
            (street, city, state, ZIP code)
        royalties (float): Box 3, Royalties received
        advertising (float): Box 5, Advertising
        auto (float): Box 6, Auto and travel
        cleaning (float): Box 7, Cleaning and maintenance
        commissions (float): Box 8, Commissions
        insurance (float): Box 9, Insurance
        legal (float): Box 10, Legal and other professional fees
        management_fees (float): Box 11, Management fees
        mortgage_interest (float): Box 12, Mortgage interest paid to banks,
            etc.
        other_interest (float): Box 13, Other interest
        repairs (float): Box 14, Repairs
        supplies (float): Box 15, Supplies
        taxes (float): Box 16, Taxes
        utilities (float): Box 17, Utilities
        depletion_expense (float): Box 18, Depletion
        other_expenses (List[DescriptionAndAmount]): Box 19, Other expenses
        capital_expenditures (List[DateAndAmount]): Capital expenditures, for
            use in calculating Depreciation
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "tax_year": 'taxYear',
        "corrected": 'corrected',
        "account_id": 'accountId',
        "tax_form_id": 'taxFormId',
        "tax_form_date": 'taxFormDate',
        "additional_information": 'additionalInformation',
        "tax_form_type": 'taxFormType',
        "issuer": 'issuer',
        "recipient": 'recipient',
        "attributes": 'attributes',
        "error": 'error',
        "links": 'links',
        "property_address": 'propertyAddress',
        "royalties": 'royalties',
        "advertising": 'advertising',
        "auto": 'auto',
        "cleaning": 'cleaning',
        "commissions": 'commissions',
        "insurance": 'insurance',
        "legal": 'legal',
        "management_fees": 'managementFees',
        "mortgage_interest": 'mortgageInterest',
        "other_interest": 'otherInterest',
        "repairs": 'repairs',
        "supplies": 'supplies',
        "taxes": 'taxes',
        "utilities": 'utilities',
        "depletion_expense": 'depletionExpense',
        "other_expenses": 'otherExpenses',
        "capital_expenditures": 'capitalExpenditures'
    }

    _optionals = [
        'tax_year',
        'corrected',
        'account_id',
        'tax_form_id',
        'tax_form_date',
        'additional_information',
        'tax_form_type',
        'issuer',
        'recipient',
        'attributes',
        'error',
        'links',
        'property_address',
        'royalties',
        'advertising',
        'auto',
        'cleaning',
        'commissions',
        'insurance',
        'legal',
        'management_fees',
        'mortgage_interest',
        'other_interest',
        'repairs',
        'supplies',
        'taxes',
        'utilities',
        'depletion_expense',
        'other_expenses',
        'capital_expenditures',
    ]

    def __init__(self,
                 tax_year=APIHelper.SKIP,
                 corrected=APIHelper.SKIP,
                 account_id=APIHelper.SKIP,
                 tax_form_id=APIHelper.SKIP,
                 tax_form_date=APIHelper.SKIP,
                 additional_information=APIHelper.SKIP,
                 tax_form_type=APIHelper.SKIP,
                 issuer=APIHelper.SKIP,
                 recipient=APIHelper.SKIP,
                 attributes=APIHelper.SKIP,
                 error=APIHelper.SKIP,
                 links=APIHelper.SKIP,
                 property_address=APIHelper.SKIP,
                 royalties=APIHelper.SKIP,
                 advertising=APIHelper.SKIP,
                 auto=APIHelper.SKIP,
                 cleaning=APIHelper.SKIP,
                 commissions=APIHelper.SKIP,
                 insurance=APIHelper.SKIP,
                 legal=APIHelper.SKIP,
                 management_fees=APIHelper.SKIP,
                 mortgage_interest=APIHelper.SKIP,
                 other_interest=APIHelper.SKIP,
                 repairs=APIHelper.SKIP,
                 supplies=APIHelper.SKIP,
                 taxes=APIHelper.SKIP,
                 utilities=APIHelper.SKIP,
                 depletion_expense=APIHelper.SKIP,
                 other_expenses=APIHelper.SKIP,
                 capital_expenditures=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the RoyaltyIncomeStatement class"""

        # Initialize members of the class
        if tax_year is not APIHelper.SKIP:
            self.tax_year = tax_year 
        if corrected is not APIHelper.SKIP:
            self.corrected = corrected 
        if account_id is not APIHelper.SKIP:
            self.account_id = account_id 
        if tax_form_id is not APIHelper.SKIP:
            self.tax_form_id = tax_form_id 
        if tax_form_date is not APIHelper.SKIP:
            self.tax_form_date = tax_form_date 
        if additional_information is not APIHelper.SKIP:
            self.additional_information = additional_information 
        if tax_form_type is not APIHelper.SKIP:
            self.tax_form_type = tax_form_type 
        if issuer is not APIHelper.SKIP:
            self.issuer = issuer 
        if recipient is not APIHelper.SKIP:
            self.recipient = recipient 
        if attributes is not APIHelper.SKIP:
            self.attributes = attributes 
        if error is not APIHelper.SKIP:
            self.error = error 
        if links is not APIHelper.SKIP:
            self.links = links 
        if property_address is not APIHelper.SKIP:
            self.property_address = property_address 
        if royalties is not APIHelper.SKIP:
            self.royalties = royalties 
        if advertising is not APIHelper.SKIP:
            self.advertising = advertising 
        if auto is not APIHelper.SKIP:
            self.auto = auto 
        if cleaning is not APIHelper.SKIP:
            self.cleaning = cleaning 
        if commissions is not APIHelper.SKIP:
            self.commissions = commissions 
        if insurance is not APIHelper.SKIP:
            self.insurance = insurance 
        if legal is not APIHelper.SKIP:
            self.legal = legal 
        if management_fees is not APIHelper.SKIP:
            self.management_fees = management_fees 
        if mortgage_interest is not APIHelper.SKIP:
            self.mortgage_interest = mortgage_interest 
        if other_interest is not APIHelper.SKIP:
            self.other_interest = other_interest 
        if repairs is not APIHelper.SKIP:
            self.repairs = repairs 
        if supplies is not APIHelper.SKIP:
            self.supplies = supplies 
        if taxes is not APIHelper.SKIP:
            self.taxes = taxes 
        if utilities is not APIHelper.SKIP:
            self.utilities = utilities 
        if depletion_expense is not APIHelper.SKIP:
            self.depletion_expense = depletion_expense 
        if other_expenses is not APIHelper.SKIP:
            self.other_expenses = other_expenses 
        if capital_expenditures is not APIHelper.SKIP:
            self.capital_expenditures = capital_expenditures 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        tax_year = dictionary.get("taxYear") if dictionary.get("taxYear") else APIHelper.SKIP
        corrected = dictionary.get("corrected") if "corrected" in dictionary.keys() else APIHelper.SKIP
        account_id = dictionary.get("accountId") if dictionary.get("accountId") else APIHelper.SKIP
        tax_form_id = dictionary.get("taxFormId") if dictionary.get("taxFormId") else APIHelper.SKIP
        tax_form_date = dateutil.parser.parse(dictionary.get('taxFormDate')).date() if dictionary.get('taxFormDate') else APIHelper.SKIP
        additional_information = dictionary.get("additionalInformation") if dictionary.get("additionalInformation") else APIHelper.SKIP
        tax_form_type = dictionary.get("taxFormType") if dictionary.get("taxFormType") else APIHelper.SKIP
        issuer = TaxParty8.from_dictionary(dictionary.get('issuer')) if 'issuer' in dictionary.keys() else APIHelper.SKIP
        recipient = TaxParty1.from_dictionary(dictionary.get('recipient')) if 'recipient' in dictionary.keys() else APIHelper.SKIP
        attributes = None
        if dictionary.get('attributes') is not None:
            attributes = [TaxFormAttribute.from_dictionary(x) for x in dictionary.get('attributes')]
        else:
            attributes = APIHelper.SKIP
        error = Error1.from_dictionary(dictionary.get('error')) if 'error' in dictionary.keys() else APIHelper.SKIP
        links = None
        if dictionary.get('links') is not None:
            links = [HateoasLink.from_dictionary(x) for x in dictionary.get('links')]
        else:
            links = APIHelper.SKIP
        property_address = Address.from_dictionary(dictionary.get('propertyAddress')) if 'propertyAddress' in dictionary.keys() else APIHelper.SKIP
        royalties = dictionary.get("royalties") if dictionary.get("royalties") else APIHelper.SKIP
        advertising = dictionary.get("advertising") if dictionary.get("advertising") else APIHelper.SKIP
        auto = dictionary.get("auto") if dictionary.get("auto") else APIHelper.SKIP
        cleaning = dictionary.get("cleaning") if dictionary.get("cleaning") else APIHelper.SKIP
        commissions = dictionary.get("commissions") if dictionary.get("commissions") else APIHelper.SKIP
        insurance = dictionary.get("insurance") if dictionary.get("insurance") else APIHelper.SKIP
        legal = dictionary.get("legal") if dictionary.get("legal") else APIHelper.SKIP
        management_fees = dictionary.get("managementFees") if dictionary.get("managementFees") else APIHelper.SKIP
        mortgage_interest = dictionary.get("mortgageInterest") if dictionary.get("mortgageInterest") else APIHelper.SKIP
        other_interest = dictionary.get("otherInterest") if dictionary.get("otherInterest") else APIHelper.SKIP
        repairs = dictionary.get("repairs") if dictionary.get("repairs") else APIHelper.SKIP
        supplies = dictionary.get("supplies") if dictionary.get("supplies") else APIHelper.SKIP
        taxes = dictionary.get("taxes") if dictionary.get("taxes") else APIHelper.SKIP
        utilities = dictionary.get("utilities") if dictionary.get("utilities") else APIHelper.SKIP
        depletion_expense = dictionary.get("depletionExpense") if dictionary.get("depletionExpense") else APIHelper.SKIP
        other_expenses = None
        if dictionary.get('otherExpenses') is not None:
            other_expenses = [DescriptionAndAmount.from_dictionary(x) for x in dictionary.get('otherExpenses')]
        else:
            other_expenses = APIHelper.SKIP
        capital_expenditures = None
        if dictionary.get('capitalExpenditures') is not None:
            capital_expenditures = [DateAndAmount.from_dictionary(x) for x in dictionary.get('capitalExpenditures')]
        else:
            capital_expenditures = APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(tax_year,
                   corrected,
                   account_id,
                   tax_form_id,
                   tax_form_date,
                   additional_information,
                   tax_form_type,
                   issuer,
                   recipient,
                   attributes,
                   error,
                   links,
                   property_address,
                   royalties,
                   advertising,
                   auto,
                   cleaning,
                   commissions,
                   insurance,
                   legal,
                   management_fees,
                   mortgage_interest,
                   other_interest,
                   repairs,
                   supplies,
                   taxes,
                   utilities,
                   depletion_expense,
                   other_expenses,
                   capital_expenditures,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'tax_year={(self.tax_year if hasattr(self, "tax_year") else None)!r}, '
                f'corrected={(self.corrected if hasattr(self, "corrected") else None)!r}, '
                f'account_id={(self.account_id if hasattr(self, "account_id") else None)!r}, '
                f'tax_form_id={(self.tax_form_id if hasattr(self, "tax_form_id") else None)!r}, '
                f'tax_form_date={(self.tax_form_date if hasattr(self, "tax_form_date") else None)!r}, '
                f'additional_information={(self.additional_information if hasattr(self, "additional_information") else None)!r}, '
                f'tax_form_type={(self.tax_form_type if hasattr(self, "tax_form_type") else None)!r}, '
                f'issuer={(self.issuer if hasattr(self, "issuer") else None)!r}, '
                f'recipient={(self.recipient if hasattr(self, "recipient") else None)!r}, '
                f'attributes={(self.attributes if hasattr(self, "attributes") else None)!r}, '
                f'error={(self.error if hasattr(self, "error") else None)!r}, '
                f'links={(self.links if hasattr(self, "links") else None)!r}, '
                f'property_address={(self.property_address if hasattr(self, "property_address") else None)!r}, '
                f'royalties={(self.royalties if hasattr(self, "royalties") else None)!r}, '
                f'advertising={(self.advertising if hasattr(self, "advertising") else None)!r}, '
                f'auto={(self.auto if hasattr(self, "auto") else None)!r}, '
                f'cleaning={(self.cleaning if hasattr(self, "cleaning") else None)!r}, '
                f'commissions={(self.commissions if hasattr(self, "commissions") else None)!r}, '
                f'insurance={(self.insurance if hasattr(self, "insurance") else None)!r}, '
                f'legal={(self.legal if hasattr(self, "legal") else None)!r}, '
                f'management_fees={(self.management_fees if hasattr(self, "management_fees") else None)!r}, '
                f'mortgage_interest={(self.mortgage_interest if hasattr(self, "mortgage_interest") else None)!r}, '
                f'other_interest={(self.other_interest if hasattr(self, "other_interest") else None)!r}, '
                f'repairs={(self.repairs if hasattr(self, "repairs") else None)!r}, '
                f'supplies={(self.supplies if hasattr(self, "supplies") else None)!r}, '
                f'taxes={(self.taxes if hasattr(self, "taxes") else None)!r}, '
                f'utilities={(self.utilities if hasattr(self, "utilities") else None)!r}, '
                f'depletion_expense={(self.depletion_expense if hasattr(self, "depletion_expense") else None)!r}, '
                f'other_expenses={(self.other_expenses if hasattr(self, "other_expenses") else None)!r}, '
                f'capital_expenditures={(self.capital_expenditures if hasattr(self, "capital_expenditures") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'tax_year={(self.tax_year if hasattr(self, "tax_year") else None)!s}, '
                f'corrected={(self.corrected if hasattr(self, "corrected") else None)!s}, '
                f'account_id={(self.account_id if hasattr(self, "account_id") else None)!s}, '
                f'tax_form_id={(self.tax_form_id if hasattr(self, "tax_form_id") else None)!s}, '
                f'tax_form_date={(self.tax_form_date if hasattr(self, "tax_form_date") else None)!s}, '
                f'additional_information={(self.additional_information if hasattr(self, "additional_information") else None)!s}, '
                f'tax_form_type={(self.tax_form_type if hasattr(self, "tax_form_type") else None)!s}, '
                f'issuer={(self.issuer if hasattr(self, "issuer") else None)!s}, '
                f'recipient={(self.recipient if hasattr(self, "recipient") else None)!s}, '
                f'attributes={(self.attributes if hasattr(self, "attributes") else None)!s}, '
                f'error={(self.error if hasattr(self, "error") else None)!s}, '
                f'links={(self.links if hasattr(self, "links") else None)!s}, '
                f'property_address={(self.property_address if hasattr(self, "property_address") else None)!s}, '
                f'royalties={(self.royalties if hasattr(self, "royalties") else None)!s}, '
                f'advertising={(self.advertising if hasattr(self, "advertising") else None)!s}, '
                f'auto={(self.auto if hasattr(self, "auto") else None)!s}, '
                f'cleaning={(self.cleaning if hasattr(self, "cleaning") else None)!s}, '
                f'commissions={(self.commissions if hasattr(self, "commissions") else None)!s}, '
                f'insurance={(self.insurance if hasattr(self, "insurance") else None)!s}, '
                f'legal={(self.legal if hasattr(self, "legal") else None)!s}, '
                f'management_fees={(self.management_fees if hasattr(self, "management_fees") else None)!s}, '
                f'mortgage_interest={(self.mortgage_interest if hasattr(self, "mortgage_interest") else None)!s}, '
                f'other_interest={(self.other_interest if hasattr(self, "other_interest") else None)!s}, '
                f'repairs={(self.repairs if hasattr(self, "repairs") else None)!s}, '
                f'supplies={(self.supplies if hasattr(self, "supplies") else None)!s}, '
                f'taxes={(self.taxes if hasattr(self, "taxes") else None)!s}, '
                f'utilities={(self.utilities if hasattr(self, "utilities") else None)!s}, '
                f'depletion_expense={(self.depletion_expense if hasattr(self, "depletion_expense") else None)!s}, '
                f'other_expenses={(self.other_expenses if hasattr(self, "other_expenses") else None)!s}, '
                f'capital_expenditures={(self.capital_expenditures if hasattr(self, "capital_expenditures") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
