# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper
from fdxapi.models.fi_attribute_entity import FiAttributeEntity
from fdxapi.models.party_entity import PartyEntity


class SuspectedFraudIncidentEntity(object):

    """Implementation of the 'Suspected Fraud Incident entity' model.

    Notification of suspected fraud

    Attributes:
        mtype (str): Extensible string enum identifying the type of suspected
            fraud. Initially this will always be set to "ACCOUNT_TAKEOVER".
            Additional values may be defined in the future
        suspected_incident_id (str): Unique identifier for the suspected fraud
            incident
        reason (str): Free text justification for suspecting fraud
        fi_attributes (List[FiAttributeEntity]): Array of financial
            institution-specific attributes. Can be used to provide additional
            structured context on the suspected fraud for the FI to use in
            determining a resolution
        reporter (PartyEntity): Identity of the party responsible for
            identifying and reporting the suspected fraud. This might be the
            DP, DAP, a vendor, a payment network, or other entity
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "mtype": 'type',
        "suspected_incident_id": 'suspectedIncidentId',
        "reason": 'reason',
        "fi_attributes": 'fiAttributes',
        "reporter": 'reporter'
    }

    _optionals = [
        'mtype',
        'suspected_incident_id',
        'reason',
        'fi_attributes',
        'reporter',
    ]

    def __init__(self,
                 mtype=APIHelper.SKIP,
                 suspected_incident_id=APIHelper.SKIP,
                 reason=APIHelper.SKIP,
                 fi_attributes=APIHelper.SKIP,
                 reporter=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the SuspectedFraudIncidentEntity class"""

        # Initialize members of the class
        if mtype is not APIHelper.SKIP:
            self.mtype = mtype 
        if suspected_incident_id is not APIHelper.SKIP:
            self.suspected_incident_id = suspected_incident_id 
        if reason is not APIHelper.SKIP:
            self.reason = reason 
        if fi_attributes is not APIHelper.SKIP:
            self.fi_attributes = fi_attributes 
        if reporter is not APIHelper.SKIP:
            self.reporter = reporter 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        mtype = dictionary.get("type") if dictionary.get("type") else APIHelper.SKIP
        suspected_incident_id = dictionary.get("suspectedIncidentId") if dictionary.get("suspectedIncidentId") else APIHelper.SKIP
        reason = dictionary.get("reason") if dictionary.get("reason") else APIHelper.SKIP
        fi_attributes = None
        if dictionary.get('fiAttributes') is not None:
            fi_attributes = [FiAttributeEntity.from_dictionary(x) for x in dictionary.get('fiAttributes')]
        else:
            fi_attributes = APIHelper.SKIP
        reporter = PartyEntity.from_dictionary(dictionary.get('reporter')) if 'reporter' in dictionary.keys() else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(mtype,
                   suspected_incident_id,
                   reason,
                   fi_attributes,
                   reporter,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'mtype={(self.mtype if hasattr(self, "mtype") else None)!r}, '
                f'suspected_incident_id={(self.suspected_incident_id if hasattr(self, "suspected_incident_id") else None)!r}, '
                f'reason={(self.reason if hasattr(self, "reason") else None)!r}, '
                f'fi_attributes={(self.fi_attributes if hasattr(self, "fi_attributes") else None)!r}, '
                f'reporter={(self.reporter if hasattr(self, "reporter") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'mtype={(self.mtype if hasattr(self, "mtype") else None)!s}, '
                f'suspected_incident_id={(self.suspected_incident_id if hasattr(self, "suspected_incident_id") else None)!s}, '
                f'reason={(self.reason if hasattr(self, "reason") else None)!s}, '
                f'fi_attributes={(self.fi_attributes if hasattr(self, "fi_attributes") else None)!s}, '
                f'reporter={(self.reporter if hasattr(self, "reporter") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
