# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper
from fdxapi.models.hateoas_link import HateoasLink


class SynchronizableArrayLinksEntity(object):

    """Implementation of the 'Synchronizable Array Links entity' model.

    Resource URLs for retrieving changes, next or previous datasets

    Attributes:
        next (HateoasLink): Resource URL for retrieving next dataset
        prev (HateoasLink): Resource URL for retrieving previous dataset
        updates (HateoasLink): Resource URL for retrieving updates since last
            request
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "next": 'next',
        "prev": 'prev',
        "updates": 'updates'
    }

    _optionals = [
        'next',
        'prev',
        'updates',
    ]

    def __init__(self,
                 next=APIHelper.SKIP,
                 prev=APIHelper.SKIP,
                 updates=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the SynchronizableArrayLinksEntity class"""

        # Initialize members of the class
        if next is not APIHelper.SKIP:
            self.next = next 
        if prev is not APIHelper.SKIP:
            self.prev = prev 
        if updates is not APIHelper.SKIP:
            self.updates = updates 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        next = HateoasLink.from_dictionary(dictionary.get('next')) if 'next' in dictionary.keys() else APIHelper.SKIP
        prev = HateoasLink.from_dictionary(dictionary.get('prev')) if 'prev' in dictionary.keys() else APIHelper.SKIP
        updates = HateoasLink.from_dictionary(dictionary.get('updates')) if 'updates' in dictionary.keys() else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(next,
                   prev,
                   updates,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'next={(self.next if hasattr(self, "next") else None)!r}, '
                f'prev={(self.prev if hasattr(self, "prev") else None)!r}, '
                f'updates={(self.updates if hasattr(self, "updates") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'next={(self.next if hasattr(self, "next") else None)!s}, '
                f'prev={(self.prev if hasattr(self, "prev") else None)!s}, '
                f'updates={(self.updates if hasattr(self, "updates") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
