# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
import dateutil.parser

from fdxapi.api_helper import APIHelper


class TaxLotEntity(object):

    """Implementation of the 'Tax Lot entity' model.

    Block of securities receiving the same tax treatment

    Attributes:
        original_purchase_date (date): Lot acquired date
        quantity (float): Lot quantity
        purchased_price (float): Original purchase price
        cost_basis (float): Total amount of money spent acquiring this lot
            including any fees or commission expenses incurred
        current_value (float): Lot market value
        position_type (PositionType1): LONG, SHORT
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "original_purchase_date": 'originalPurchaseDate',
        "quantity": 'quantity',
        "purchased_price": 'purchasedPrice',
        "cost_basis": 'costBasis',
        "current_value": 'currentValue',
        "position_type": 'positionType'
    }

    _optionals = [
        'original_purchase_date',
        'quantity',
        'purchased_price',
        'cost_basis',
        'current_value',
        'position_type',
    ]

    def __init__(self,
                 original_purchase_date=APIHelper.SKIP,
                 quantity=APIHelper.SKIP,
                 purchased_price=APIHelper.SKIP,
                 cost_basis=APIHelper.SKIP,
                 current_value=APIHelper.SKIP,
                 position_type=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the TaxLotEntity class"""

        # Initialize members of the class
        if original_purchase_date is not APIHelper.SKIP:
            self.original_purchase_date = original_purchase_date 
        if quantity is not APIHelper.SKIP:
            self.quantity = quantity 
        if purchased_price is not APIHelper.SKIP:
            self.purchased_price = purchased_price 
        if cost_basis is not APIHelper.SKIP:
            self.cost_basis = cost_basis 
        if current_value is not APIHelper.SKIP:
            self.current_value = current_value 
        if position_type is not APIHelper.SKIP:
            self.position_type = position_type 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        original_purchase_date = dateutil.parser.parse(dictionary.get('originalPurchaseDate')).date() if dictionary.get('originalPurchaseDate') else APIHelper.SKIP
        quantity = dictionary.get("quantity") if dictionary.get("quantity") else APIHelper.SKIP
        purchased_price = dictionary.get("purchasedPrice") if dictionary.get("purchasedPrice") else APIHelper.SKIP
        cost_basis = dictionary.get("costBasis") if dictionary.get("costBasis") else APIHelper.SKIP
        current_value = dictionary.get("currentValue") if dictionary.get("currentValue") else APIHelper.SKIP
        position_type = dictionary.get("positionType") if dictionary.get("positionType") else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(original_purchase_date,
                   quantity,
                   purchased_price,
                   cost_basis,
                   current_value,
                   position_type,
                   additional_properties)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """

        if isinstance(dictionary, cls):
            return True

        if not isinstance(dictionary, dict):
            return False

        return True

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'original_purchase_date={(self.original_purchase_date if hasattr(self, "original_purchase_date") else None)!r}, '
                f'quantity={(self.quantity if hasattr(self, "quantity") else None)!r}, '
                f'purchased_price={(self.purchased_price if hasattr(self, "purchased_price") else None)!r}, '
                f'cost_basis={(self.cost_basis if hasattr(self, "cost_basis") else None)!r}, '
                f'current_value={(self.current_value if hasattr(self, "current_value") else None)!r}, '
                f'position_type={(self.position_type if hasattr(self, "position_type") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'original_purchase_date={(self.original_purchase_date if hasattr(self, "original_purchase_date") else None)!s}, '
                f'quantity={(self.quantity if hasattr(self, "quantity") else None)!s}, '
                f'purchased_price={(self.purchased_price if hasattr(self, "purchased_price") else None)!s}, '
                f'cost_basis={(self.cost_basis if hasattr(self, "cost_basis") else None)!s}, '
                f'current_value={(self.current_value if hasattr(self, "current_value") else None)!s}, '
                f'position_type={(self.position_type if hasattr(self, "position_type") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
