# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper


class TaxRefundDirectDeposit2(object):

    """Implementation of the 'Tax Refund Direct Deposit2' model.

    Tax refund direct deposit information

    Attributes:
        institution_name (str): Name of institution
        rtn (str): Routing transit number
        account_number (str): Account number
        account_nick_name (str): Account nickname
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "institution_name": 'institutionName',
        "rtn": 'rtn',
        "account_number": 'accountNumber',
        "account_nick_name": 'accountNickName'
    }

    _optionals = [
        'institution_name',
        'rtn',
        'account_number',
        'account_nick_name',
    ]

    def __init__(self,
                 institution_name=APIHelper.SKIP,
                 rtn=APIHelper.SKIP,
                 account_number=APIHelper.SKIP,
                 account_nick_name=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the TaxRefundDirectDeposit2 class"""

        # Initialize members of the class
        if institution_name is not APIHelper.SKIP:
            self.institution_name = institution_name 
        if rtn is not APIHelper.SKIP:
            self.rtn = rtn 
        if account_number is not APIHelper.SKIP:
            self.account_number = account_number 
        if account_nick_name is not APIHelper.SKIP:
            self.account_nick_name = account_nick_name 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        institution_name = dictionary.get("institutionName") if dictionary.get("institutionName") else APIHelper.SKIP
        rtn = dictionary.get("rtn") if dictionary.get("rtn") else APIHelper.SKIP
        account_number = dictionary.get("accountNumber") if dictionary.get("accountNumber") else APIHelper.SKIP
        account_nick_name = dictionary.get("accountNickName") if dictionary.get("accountNickName") else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(institution_name,
                   rtn,
                   account_number,
                   account_nick_name,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'institution_name={(self.institution_name if hasattr(self, "institution_name") else None)!r}, '
                f'rtn={(self.rtn if hasattr(self, "rtn") else None)!r}, '
                f'account_number={(self.account_number if hasattr(self, "account_number") else None)!r}, '
                f'account_nick_name={(self.account_nick_name if hasattr(self, "account_nick_name") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'institution_name={(self.institution_name if hasattr(self, "institution_name") else None)!s}, '
                f'rtn={(self.rtn if hasattr(self, "rtn") else None)!s}, '
                f'account_number={(self.account_number if hasattr(self, "account_number") else None)!s}, '
                f'account_nick_name={(self.account_nick_name if hasattr(self, "account_nick_name") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
