# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper
from fdxapi.models.fi_attribute_entity import FiAttributeEntity
from fdxapi.models.tax_data import TaxData
from fdxapi.models.tax_party_6 import TaxParty6
from fdxapi.models.tax_party_7 import TaxParty7


class TaxStatement6(object):

    """Implementation of the 'Tax Statement6' model.

    The full data contents of the document and all its contained forms
    including the indexing metadata values

    Attributes:
        tax_year (int): Year for which taxes are being paid
        tax_statement_id (str): Long-term persistent id for the tax statement.
            Depending upon the data provider, this may be the same id as the
            id on the enclosed tax form(s), or this may be a different id
        issuer (TaxParty6): Issuer's name, address, phone, and TIN. Issuer
            data need only be transmittted on TaxStatement, 'JSON' data type
            responses if it is the same on all included tax forms
        recipient (TaxParty7): Recipient's name, address, phone, and TIN.
            Recipient data need only be transmittted on TaxStatement, 'JSON'
            data type responses if it is the same on all included tax forms
        tax_data_type (TypeDataType2): Whether this `application/json` tax
            form response contains data in `forms` property (as 'JSON' format)
            or `pdf` property (as 'BASE64_PDF' format)
        forms (List[TaxData]): The list of data contents for all included tax
            forms, response should include one of `forms` or `pdf`
        pdf (binary): PDF version of the tax statement containing all form
            pages, binary encoded as Base64, response should include one of
            `pdf` or `forms`
        attributes (List[FiAttributeEntity]): Additional tax statement
            attributes that the provider wishes to include
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "tax_year": 'taxYear',
        "tax_statement_id": 'taxStatementId',
        "issuer": 'issuer',
        "recipient": 'recipient',
        "tax_data_type": 'taxDataType',
        "forms": 'forms',
        "pdf": 'pdf',
        "attributes": 'attributes'
    }

    _optionals = [
        'tax_year',
        'tax_statement_id',
        'issuer',
        'recipient',
        'tax_data_type',
        'forms',
        'pdf',
        'attributes',
    ]

    def __init__(self,
                 tax_year=APIHelper.SKIP,
                 tax_statement_id=APIHelper.SKIP,
                 issuer=APIHelper.SKIP,
                 recipient=APIHelper.SKIP,
                 tax_data_type=APIHelper.SKIP,
                 forms=APIHelper.SKIP,
                 pdf=APIHelper.SKIP,
                 attributes=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the TaxStatement6 class"""

        # Initialize members of the class
        if tax_year is not APIHelper.SKIP:
            self.tax_year = tax_year 
        if tax_statement_id is not APIHelper.SKIP:
            self.tax_statement_id = tax_statement_id 
        if issuer is not APIHelper.SKIP:
            self.issuer = issuer 
        if recipient is not APIHelper.SKIP:
            self.recipient = recipient 
        if tax_data_type is not APIHelper.SKIP:
            self.tax_data_type = tax_data_type 
        if forms is not APIHelper.SKIP:
            self.forms = forms 
        if pdf is not APIHelper.SKIP:
            self.pdf = pdf 
        if attributes is not APIHelper.SKIP:
            self.attributes = attributes 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        tax_year = dictionary.get("taxYear") if dictionary.get("taxYear") else APIHelper.SKIP
        tax_statement_id = dictionary.get("taxStatementId") if dictionary.get("taxStatementId") else APIHelper.SKIP
        issuer = TaxParty6.from_dictionary(dictionary.get('issuer')) if 'issuer' in dictionary.keys() else APIHelper.SKIP
        recipient = TaxParty7.from_dictionary(dictionary.get('recipient')) if 'recipient' in dictionary.keys() else APIHelper.SKIP
        tax_data_type = dictionary.get("taxDataType") if dictionary.get("taxDataType") else APIHelper.SKIP
        forms = None
        if dictionary.get('forms') is not None:
            forms = [TaxData.from_dictionary(x) for x in dictionary.get('forms')]
        else:
            forms = APIHelper.SKIP
        pdf = dictionary.get("pdf") if dictionary.get("pdf") else APIHelper.SKIP
        attributes = None
        if dictionary.get('attributes') is not None:
            attributes = [FiAttributeEntity.from_dictionary(x) for x in dictionary.get('attributes')]
        else:
            attributes = APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(tax_year,
                   tax_statement_id,
                   issuer,
                   recipient,
                   tax_data_type,
                   forms,
                   pdf,
                   attributes,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'tax_year={(self.tax_year if hasattr(self, "tax_year") else None)!r}, '
                f'tax_statement_id={(self.tax_statement_id if hasattr(self, "tax_statement_id") else None)!r}, '
                f'issuer={(self.issuer if hasattr(self, "issuer") else None)!r}, '
                f'recipient={(self.recipient if hasattr(self, "recipient") else None)!r}, '
                f'tax_data_type={(self.tax_data_type if hasattr(self, "tax_data_type") else None)!r}, '
                f'forms={(self.forms if hasattr(self, "forms") else None)!r}, '
                f'pdf={(self.pdf if hasattr(self, "pdf") else None)!r}, '
                f'attributes={(self.attributes if hasattr(self, "attributes") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'tax_year={(self.tax_year if hasattr(self, "tax_year") else None)!s}, '
                f'tax_statement_id={(self.tax_statement_id if hasattr(self, "tax_statement_id") else None)!s}, '
                f'issuer={(self.issuer if hasattr(self, "issuer") else None)!s}, '
                f'recipient={(self.recipient if hasattr(self, "recipient") else None)!s}, '
                f'tax_data_type={(self.tax_data_type if hasattr(self, "tax_data_type") else None)!s}, '
                f'forms={(self.forms if hasattr(self, "forms") else None)!s}, '
                f'pdf={(self.pdf if hasattr(self, "pdf") else None)!s}, '
                f'attributes={(self.attributes if hasattr(self, "attributes") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
