# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper


class TimeframeBasedLimitsForAPaymentNetwork2(object):

    """Implementation of the 'Timeframe based limits for a Payment Network2' model.

    The transfer limits for the current month

    Attributes:
        resets_on (datetime): Date/time at which this timeframe will reset next
        transfer_max_amount (float): Maximum limit of funds that can be
            transferred to/from the account in this timeframe
        transfer_remaining_amount (float): Remaining value of the maximum
            limit of funds that can be transferred to/from the account in this
            timeframe
        max_occurrence (int): Maximum number of transfers that can be made in
            this direction for this timeframe
        remaining_occurrence (int): Remaining number of transfers that can be
            made in this direction for this timeframe
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "resets_on": 'resetsOn',
        "transfer_max_amount": 'transferMaxAmount',
        "transfer_remaining_amount": 'transferRemainingAmount',
        "max_occurrence": 'maxOccurrence',
        "remaining_occurrence": 'remainingOccurrence'
    }

    _optionals = [
        'resets_on',
        'transfer_max_amount',
        'transfer_remaining_amount',
        'max_occurrence',
        'remaining_occurrence',
    ]

    def __init__(self,
                 resets_on=APIHelper.SKIP,
                 transfer_max_amount=APIHelper.SKIP,
                 transfer_remaining_amount=APIHelper.SKIP,
                 max_occurrence=APIHelper.SKIP,
                 remaining_occurrence=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the TimeframeBasedLimitsForAPaymentNetwork2 class"""

        # Initialize members of the class
        if resets_on is not APIHelper.SKIP:
            self.resets_on = APIHelper.apply_datetime_converter(resets_on, APIHelper.RFC3339DateTime) if resets_on else None 
        if transfer_max_amount is not APIHelper.SKIP:
            self.transfer_max_amount = transfer_max_amount 
        if transfer_remaining_amount is not APIHelper.SKIP:
            self.transfer_remaining_amount = transfer_remaining_amount 
        if max_occurrence is not APIHelper.SKIP:
            self.max_occurrence = max_occurrence 
        if remaining_occurrence is not APIHelper.SKIP:
            self.remaining_occurrence = remaining_occurrence 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        resets_on = APIHelper.RFC3339DateTime.from_value(dictionary.get("resetsOn")).datetime if dictionary.get("resetsOn") else APIHelper.SKIP
        transfer_max_amount = dictionary.get("transferMaxAmount") if dictionary.get("transferMaxAmount") else APIHelper.SKIP
        transfer_remaining_amount = dictionary.get("transferRemainingAmount") if dictionary.get("transferRemainingAmount") else APIHelper.SKIP
        max_occurrence = dictionary.get("maxOccurrence") if dictionary.get("maxOccurrence") else APIHelper.SKIP
        remaining_occurrence = dictionary.get("remainingOccurrence") if dictionary.get("remainingOccurrence") else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(resets_on,
                   transfer_max_amount,
                   transfer_remaining_amount,
                   max_occurrence,
                   remaining_occurrence,
                   additional_properties)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'resets_on={(self.resets_on if hasattr(self, "resets_on") else None)!r}, '
                f'transfer_max_amount={(self.transfer_max_amount if hasattr(self, "transfer_max_amount") else None)!r}, '
                f'transfer_remaining_amount={(self.transfer_remaining_amount if hasattr(self, "transfer_remaining_amount") else None)!r}, '
                f'max_occurrence={(self.max_occurrence if hasattr(self, "max_occurrence") else None)!r}, '
                f'remaining_occurrence={(self.remaining_occurrence if hasattr(self, "remaining_occurrence") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'resets_on={(self.resets_on if hasattr(self, "resets_on") else None)!s}, '
                f'transfer_max_amount={(self.transfer_max_amount if hasattr(self, "transfer_max_amount") else None)!s}, '
                f'transfer_remaining_amount={(self.transfer_remaining_amount if hasattr(self, "transfer_remaining_amount") else None)!s}, '
                f'max_occurrence={(self.max_occurrence if hasattr(self, "max_occurrence") else None)!s}, '
                f'remaining_occurrence={(self.remaining_occurrence if hasattr(self, "remaining_occurrence") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
