# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from fdxapi.api_helper import APIHelper


class TransactionRewardEntity2(object):

    """Implementation of the 'Transaction Reward entity2' model.

    Rewards earned with this transaction

    Attributes:
        category_id (str): Long term persistent identity of the reward
            category. This ID is mapped to a category definition returned by
            calling the getRewardProgramCategories operation
        accrued (float): Reward units accrued on this transaction
        adjusted (float): Reward units adjusted on this transaction
        additional_properties (Dict[str, Any]): The additional properties for
            the model.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "category_id": 'categoryId',
        "accrued": 'accrued',
        "adjusted": 'adjusted'
    }

    _optionals = [
        'category_id',
        'accrued',
        'adjusted',
    ]

    def __init__(self,
                 category_id=APIHelper.SKIP,
                 accrued=APIHelper.SKIP,
                 adjusted=APIHelper.SKIP,
                 additional_properties=None):
        """Constructor for the TransactionRewardEntity2 class"""

        # Initialize members of the class
        if category_id is not APIHelper.SKIP:
            self.category_id = category_id 
        if accrued is not APIHelper.SKIP:
            self.accrued = accrued 
        if adjusted is not APIHelper.SKIP:
            self.adjusted = adjusted 

        # Add additional model properties to the instance
        if additional_properties is None:
            additional_properties = {}
        self.additional_properties = additional_properties

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        category_id = dictionary.get("categoryId") if dictionary.get("categoryId") else APIHelper.SKIP
        accrued = dictionary.get("accrued") if dictionary.get("accrued") else APIHelper.SKIP
        adjusted = dictionary.get("adjusted") if dictionary.get("adjusted") else APIHelper.SKIP
        additional_properties = APIHelper.get_additional_properties(
            dictionary={k: v for k, v in dictionary.items() if k not in cls._names.values()},
            unboxing_function=lambda value: value)
        # Return an object of this model
        return cls(category_id,
                   accrued,
                   adjusted,
                   additional_properties)

    @classmethod
    def validate(cls, dictionary):
        """Validates dictionary against class required properties

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            boolean : if dictionary is valid contains required properties.

        """

        if isinstance(dictionary, cls):
            return True

        if not isinstance(dictionary, dict):
            return False

        return True

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'category_id={(self.category_id if hasattr(self, "category_id") else None)!r}, '
                f'accrued={(self.accrued if hasattr(self, "accrued") else None)!r}, '
                f'adjusted={(self.adjusted if hasattr(self, "adjusted") else None)!r}, '
                f'additional_properties={self.additional_properties!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'category_id={(self.category_id if hasattr(self, "category_id") else None)!s}, '
                f'accrued={(self.accrued if hasattr(self, "accrued") else None)!s}, '
                f'adjusted={(self.adjusted if hasattr(self, "adjusted") else None)!s}, '
                f'additional_properties={self.additional_properties!s})')
