# -*- coding: utf-8 -*-

"""
fdxapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from apimatic_core.types.union_types.any_of import AnyOf
from apimatic_core.types.union_types.leaf_type import LeafType
from apimatic_core.types.union_types.union_type_context import UnionTypeContext as Context
from fdxapi.models.account_descriptor_entity import AnnuityAccountEntity
from fdxapi.models.account_descriptor_entity import CommercialAccountEntity
from fdxapi.models.account_descriptor_entity import DepositAccountEntity
from fdxapi.models.account_descriptor_entity import DigitalWalletAccountEntity
from fdxapi.models.account_descriptor_entity import InsuranceAccountEntity
from fdxapi.models.account_descriptor_entity import InvestmentAccountEntity
from fdxapi.models.account_descriptor_entity import LineOfCreditAccountEntity
from fdxapi.models.account_descriptor_entity import LoanAccountEntity
from fdxapi.models.address import Address
from fdxapi.models.electronic_address_entity import ElectronicAddressEntity
from fdxapi.models.external_account_id_scheme_entity import ExternalAccountIdSchemeEntity
from fdxapi.models.external_financial_institution_id_scheme_entity import ExternalFinancialInstitutionIdSchemeEntity
from fdxapi.models.generic_account_identification_entity import GenericAccountIdentificationEntity
from fdxapi.models.generic_financial_institution_id_entity import GenericFinancialInstitutionIdEntity
from fdxapi.models.iban_2007_identifier_entity import Iban2007IdentifierEntity
from fdxapi.models.individual_name import IndividualName
from fdxapi.models.iso_93622014_business_identifier_code_entity import Iso93622014BusinessIdentifierCodeEntity
from fdxapi.models.iso_93622022_business_identifier_code_entity import Iso93622022BusinessIdentifierCodeEntity
from fdxapi.models.organization_name_entity import OrganizationNameEntity
from fdxapi.models.payment_method_credit_account_entity import PaymentMethodCreditAccountEntity
from fdxapi.models.payment_method_debit_account_entity import PaymentMethodDebitAccountEntity
from fdxapi.models.proprietary_account_id_scheme_entity import ProprietaryAccountIdSchemeEntity
from fdxapi.models.proprietary_financial_institution_id_scheme_entity import ProprietaryFinancialInstitutionIdSchemeEntity
from fdxapi.models.security_entity import DebtSecurityEntity
from fdxapi.models.security_entity import MutualFundSecurityEntity
from fdxapi.models.security_entity import OptionSecurityEntity
from fdxapi.models.security_entity import OtherSecurityEntity
from fdxapi.models.security_entity import StockSecurityEntity
from fdxapi.models.security_entity import SweepSecurityEntity
from fdxapi.models.telephone_number import TelephoneNumber
from fdxapi.models.transaction import CommercialTransactionEntity
from fdxapi.models.transaction import DepositTransactionEntity
from fdxapi.models.transaction import DigitalWalletTransactionEntity
from fdxapi.models.transaction import InsuranceTransactionEntity
from fdxapi.models.transaction import InvestmentTransactionEntity
from fdxapi.models.transaction import LineOfCreditTransactionEntity
from fdxapi.models.transaction import LoanTransactionEntity


class UnionTypeLookUp:

    """The `UnionTypeLookUp` class serves as a utility class for 
    storing and managing type combinator templates.It acts as a container for the templates 
    used in handling various data types within the application.

    """
    _templates = {
        'AccountWithDetails': lambda: AnyOf(
            [
                LeafType(AnnuityAccountEntity,
                         Context.create(
                             discriminator_value='ANNUITY_ACCOUNT',
                             discriminator='accountCategory'
                         )),
                LeafType(CommercialAccountEntity,
                         Context.create(
                             discriminator_value='COMMERCIAL_ACCOUNT',
                             discriminator='accountCategory'
                         )),
                LeafType(DepositAccountEntity,
                         Context.create(
                             discriminator_value='DEPOSIT_ACCOUNT',
                             discriminator='accountCategory'
                         )),
                LeafType(DigitalWalletAccountEntity,
                         Context.create(
                             discriminator_value='DIGITAL_WALLET',
                             discriminator='accountCategory'
                         )),
                LeafType(InsuranceAccountEntity,
                         Context.create(
                             discriminator_value='INSURANCE_ACCOUNT',
                             discriminator='accountCategory'
                         )),
                LeafType(InvestmentAccountEntity,
                         Context.create(
                             discriminator_value='INVESTMENT_ACCOUNT',
                             discriminator='accountCategory'
                         )),
                LeafType(LineOfCreditAccountEntity,
                         Context.create(
                             discriminator_value='LOC_ACCOUNT',
                             discriminator='accountCategory'
                         )),
                LeafType(LoanAccountEntity,
                         Context.create(
                             discriminator_value='LOAN_ACCOUNT',
                             discriminator='accountCategory'
                         ))
            ]
        ),
        'AccountsEntityAccounts': lambda: AnyOf(
            [
                LeafType(AnnuityAccountEntity),
                LeafType(CommercialAccountEntity),
                LeafType(DepositAccountEntity),
                LeafType(DigitalWalletAccountEntity),
                LeafType(InsuranceAccountEntity),
                LeafType(InvestmentAccountEntity),
                LeafType(LineOfCreditAccountEntity),
                LeafType(LoanAccountEntity)
            ],
            Context.create(
               is_array=True,
               is_optional=True
            )
        ),
        'HoldingEntitySecurity': lambda: AnyOf(
            [
                LeafType(DebtSecurityEntity),
                LeafType(MutualFundSecurityEntity),
                LeafType(OptionSecurityEntity),
                LeafType(OtherSecurityEntity),
                LeafType(StockSecurityEntity),
                LeafType(SweepSecurityEntity)
            ],
            Context.create(
               is_optional=True
            )
        ),
        'TransactionsEntityTransactions': lambda: AnyOf(
            [
                LeafType(CommercialTransactionEntity),
                LeafType(DepositTransactionEntity),
                LeafType(DigitalWalletTransactionEntity),
                LeafType(InsuranceTransactionEntity),
                LeafType(InvestmentTransactionEntity),
                LeafType(LineOfCreditTransactionEntity),
                LeafType(LoanTransactionEntity)
            ],
            Context.create(
               is_array=True,
               is_optional=True
            )
        ),
        'FinancialInstitutionEntityFiId': lambda: AnyOf(
            [
                LeafType(Iso93622014BusinessIdentifierCodeEntity),
                LeafType(Iso93622022BusinessIdentifierCodeEntity),
                LeafType(GenericFinancialInstitutionIdEntity)
            ],
            Context.create(
               is_optional=True
            )
        ),
        'GenericAccountIdentificationEntityIdScheme': lambda: AnyOf(
            [
                LeafType(ExternalAccountIdSchemeEntity),
                LeafType(ProprietaryAccountIdSchemeEntity)
            ],
            Context.create(
               is_optional=True
            )
        ),
        'GenericFinancialInstitutionIdEntityIdScheme': lambda: AnyOf(
            [
                LeafType(ExternalFinancialInstitutionIdSchemeEntity),
                LeafType(ProprietaryFinancialInstitutionIdSchemeEntity)
            ],
            Context.create(
               is_optional=True
            )
        ),
        'PaymentDeliveryAddressEntityAddress': lambda: AnyOf(
            [
                LeafType(ElectronicAddressEntity),
                LeafType(TelephoneNumber),
                LeafType(Address)
            ],
            Context.create(
               is_optional=True
            )
        ),
        'PaymentGenericAccountEntityId': lambda: AnyOf(
            [
                LeafType(Iban2007IdentifierEntity),
                LeafType(GenericAccountIdentificationEntity)
            ],
            Context.create(
               is_optional=True
            )
        ),
        'PaymentInitiationPartyContactMethodEntityAddress': lambda: AnyOf(
            [
                LeafType(ElectronicAddressEntity),
                LeafType(TelephoneNumber),
                LeafType(Address)
            ],
            Context.create(
               is_optional=True
            )
        ),
        'PaymentInitiationPartyNameEntityDetail': lambda: AnyOf(
            [
                LeafType(OrganizationNameEntity),
                LeafType(IndividualName)
            ],
            Context.create(
               is_optional=True
            )
        ),
        'PaymentInitiationPartyToPaymentMethodEntityAccount': lambda: AnyOf(
            [
                LeafType(PaymentMethodCreditAccountEntity),
                LeafType(PaymentMethodDebitAccountEntity)
            ],
            Context.create(
               is_optional=True
            )
        ),
        'FinancialInstitutionEntity2FiId': lambda: AnyOf(
            [
                LeafType(Iso93622014BusinessIdentifierCodeEntity),
                LeafType(Iso93622022BusinessIdentifierCodeEntity),
                LeafType(GenericFinancialInstitutionIdEntity)
            ],
            Context.create(
               is_optional=True
            )
        ),
        'PaymentGenericAccountEntity1Id': lambda: AnyOf(
            [
                LeafType(Iban2007IdentifierEntity),
                LeafType(GenericAccountIdentificationEntity)
            ],
            Context.create(
               is_optional=True
            )
        ),
        'PaymentGenericAccountEntity2Id': lambda: AnyOf(
            [
                LeafType(Iban2007IdentifierEntity),
                LeafType(GenericAccountIdentificationEntity)
            ],
            Context.create(
               is_optional=True
            )
        ),
        'PaymentInitiationPartyNameEntity1Detail': lambda: AnyOf(
            [
                LeafType(OrganizationNameEntity),
                LeafType(IndividualName)
            ],
            Context.create(
               is_optional=True
            )
        ),
        'PaymentInitiationPartyNameEntity3Detail': lambda: AnyOf(
            [
                LeafType(OrganizationNameEntity),
                LeafType(IndividualName)
            ],
            Context.create(
               is_optional=True
            )
        )
    }

    @staticmethod
    def get(name):
        return UnionTypeLookUp._templates[name]()

