import { CdkCustomResourceResponse, CloudFormationCustomResourceCreateEvent, CloudFormationCustomResourceDeleteEvent, CloudFormationCustomResourceEvent, CloudFormationCustomResourceUpdateEvent, Context } from 'aws-lambda';
export declare const handler: (event: CloudFormationCustomResourceEvent, context: Context) => Promise<CdkCustomResourceResponse>;
/**
 * Executes the create event for a CloudFormation custom resource.
 * @param {CdkCustomResourceResponse} response - The custom resource response object.
 * @param {CloudFormationCustomResourceCreateEvent} event - The create event object.
 * @param {Context} context - The AWS Lambda context object.
 * @return {Promise<CdkCustomResourceResponse>} - A promise that resolves to the custom resource response object.
 */
export declare function onCreate(response: CdkCustomResourceResponse, event: CloudFormationCustomResourceCreateEvent, context: Context): Promise<CdkCustomResourceResponse>;
/**
 * Handles delete event for a cloud formation custom resource.
 *
 * @param {CdkCustomResourceResponse} response - The custom resource response object.
 * @param {CloudFormationCustomResourceDeleteEvent} event - The delete event object.
 * @param {Context} context - The AWS lambda context object.
 * @returns {Promise<CdkCustomResourceResponse>} - The updated custom resource response object.
 */
export declare function onDelete(response: CdkCustomResourceResponse, event: CloudFormationCustomResourceDeleteEvent, context: Context): Promise<CdkCustomResourceResponse>;
/**
 * Executes the onUpdate logic for a CloudFormation custom resource.
 *
 * @param {CdkCustomResourceResponse} response - The response object for the custom resource.
 * @param {CloudFormationCustomResourceUpdateEvent} event - The update event object from CloudFormation.
 * @param {Context} context - The execution context object.
 * @returns {Promise<CdkCustomResourceResponse>} A promise that resolves to the updated response object.
 */
export declare function onUpdate(response: CdkCustomResourceResponse, event: CloudFormationCustomResourceUpdateEvent, context: Context): Promise<CdkCustomResourceResponse>;
