import { SENSITIVE_STRING } from "@smithy/smithy-client";
import { BundleTaskFilterSensitiveLog, VerifiedAccessTrustProviderFilterSensitiveLog, } from "./models_0";
export const State = {
    Available: "Available",
    Deleted: "Deleted",
    Deleting: "Deleting",
    Expired: "Expired",
    Failed: "Failed",
    Partial: "Partial",
    Pending: "Pending",
    PendingAcceptance: "PendingAcceptance",
    Rejected: "Rejected",
};
export const ConnectionNotificationState = {
    Disabled: "Disabled",
    Enabled: "Enabled",
};
export const ConnectionNotificationType = {
    Topic: "Topic",
};
export const PayerResponsibility = {
    ServiceOwner: "ServiceOwner",
};
export const DnsNameState = {
    Failed: "failed",
    PendingVerification: "pendingVerification",
    Verified: "verified",
};
export const ServiceState = {
    Available: "Available",
    Deleted: "Deleted",
    Deleting: "Deleting",
    Failed: "Failed",
    Pending: "Pending",
};
export const ServiceType = {
    Gateway: "Gateway",
    GatewayLoadBalancer: "GatewayLoadBalancer",
    Interface: "Interface",
};
export const ServiceConnectivityType = {
    ipv4: "ipv4",
    ipv6: "ipv6",
};
export const TunnelInsideIpVersion = {
    ipv4: "ipv4",
    ipv6: "ipv6",
};
export const GatewayAssociationState = {
    associated: "associated",
    associating: "associating",
    disassociating: "disassociating",
    not_associated: "not-associated",
};
export const VpnStaticRouteSource = {
    Static: "Static",
};
export const VpnState = {
    available: "available",
    deleted: "deleted",
    deleting: "deleting",
    pending: "pending",
};
export const TelemetryStatus = {
    DOWN: "DOWN",
    UP: "UP",
};
export const FleetStateCode = {
    ACTIVE: "active",
    DELETED: "deleted",
    DELETED_RUNNING: "deleted_running",
    DELETED_TERMINATING_INSTANCES: "deleted_terminating",
    FAILED: "failed",
    MODIFYING: "modifying",
    SUBMITTED: "submitted",
};
export const DeleteFleetErrorCode = {
    FLEET_ID_DOES_NOT_EXIST: "fleetIdDoesNotExist",
    FLEET_ID_MALFORMED: "fleetIdMalformed",
    FLEET_NOT_IN_DELETABLE_STATE: "fleetNotInDeletableState",
    UNEXPECTED_ERROR: "unexpectedError",
};
export const LaunchTemplateErrorCode = {
    LAUNCH_TEMPLATE_ID_DOES_NOT_EXIST: "launchTemplateIdDoesNotExist",
    LAUNCH_TEMPLATE_ID_MALFORMED: "launchTemplateIdMalformed",
    LAUNCH_TEMPLATE_NAME_DOES_NOT_EXIST: "launchTemplateNameDoesNotExist",
    LAUNCH_TEMPLATE_NAME_MALFORMED: "launchTemplateNameMalformed",
    LAUNCH_TEMPLATE_VERSION_DOES_NOT_EXIST: "launchTemplateVersionDoesNotExist",
    UNEXPECTED_ERROR: "unexpectedError",
};
export const DeleteQueuedReservedInstancesErrorCode = {
    RESERVED_INSTANCES_ID_INVALID: "reserved-instances-id-invalid",
    RESERVED_INSTANCES_NOT_IN_QUEUED_STATE: "reserved-instances-not-in-queued-state",
    UNEXPECTED_ERROR: "unexpected-error",
};
export const AsnState = {
    deprovisioned: "deprovisioned",
    failed_deprovision: "failed-deprovision",
    failed_provision: "failed-provision",
    pending_deprovision: "pending-deprovision",
    pending_provision: "pending-provision",
    provisioned: "provisioned",
};
export const IpamPoolCidrFailureCode = {
    cidr_not_available: "cidr-not-available",
    limit_exceeded: "limit-exceeded",
};
export const IpamPoolCidrState = {
    deprovisioned: "deprovisioned",
    failed_deprovision: "failed-deprovision",
    failed_import: "failed-import",
    failed_provision: "failed-provision",
    pending_deprovision: "pending-deprovision",
    pending_import: "pending-import",
    pending_provision: "pending-provision",
    provisioned: "provisioned",
};
export const SnapshotReturnCodes = {
    ERROR_CODE_CLIENT_ERROR: "client-error",
    ERROR_CODE_INTERNAL_ERROR: "internal-error",
    ERROR_MISSING_PERMISSIONS: "missing-permissions",
    SUCCESS: "success",
    WARN_SKIPPED: "skipped",
};
export const AvailabilityZoneOptInStatus = {
    not_opted_in: "not-opted-in",
    opt_in_not_required: "opt-in-not-required",
    opted_in: "opted-in",
};
export const AvailabilityZoneState = {
    available: "available",
    constrained: "constrained",
    impaired: "impaired",
    information: "information",
    unavailable: "unavailable",
};
export const MetricType = {
    aggregate_latency: "aggregate-latency",
};
export const PeriodType = {
    fifteen_minutes: "fifteen-minutes",
    five_minutes: "five-minutes",
    one_day: "one-day",
    one_hour: "one-hour",
    one_week: "one-week",
    three_hours: "three-hours",
};
export const StatisticType = {
    p50: "p50",
};
export const CapacityBlockExtensionStatus = {
    PAYMENT_FAILED: "payment-failed",
    PAYMENT_PENDING: "payment-pending",
    PAYMENT_SUCCEEDED: "payment-succeeded",
};
export const CapacityBlockResourceState = {
    active: "active",
    cancelled: "cancelled",
    expired: "expired",
    failed: "failed",
    payment_failed: "payment-failed",
    payment_pending: "payment-pending",
    scheduled: "scheduled",
    unavailable: "unavailable",
};
export const CapacityBlockInterconnectStatus = {
    impaired: "impaired",
    insufficient_data: "insufficient-data",
    ok: "ok",
};
export const CallerRole = {
    odcr_owner: "odcr-owner",
    unused_reservation_billing_owner: "unused-reservation-billing-owner",
};
export const VpnTunnelOptionsSpecificationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.PreSharedKey && { PreSharedKey: SENSITIVE_STRING }),
});
export const VpnConnectionOptionsSpecificationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.TunnelOptions && {
        TunnelOptions: obj.TunnelOptions.map((item) => VpnTunnelOptionsSpecificationFilterSensitiveLog(item)),
    }),
});
export const CreateVpnConnectionRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Options && { Options: VpnConnectionOptionsSpecificationFilterSensitiveLog(obj.Options) }),
});
export const TunnelOptionFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.PreSharedKey && { PreSharedKey: SENSITIVE_STRING }),
});
export const VpnConnectionOptionsFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.TunnelOptions && { TunnelOptions: obj.TunnelOptions.map((item) => TunnelOptionFilterSensitiveLog(item)) }),
});
export const VpnConnectionFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Options && { Options: VpnConnectionOptionsFilterSensitiveLog(obj.Options) }),
    ...(obj.CustomerGatewayConfiguration && { CustomerGatewayConfiguration: SENSITIVE_STRING }),
});
export const CreateVpnConnectionResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.VpnConnection && { VpnConnection: VpnConnectionFilterSensitiveLog(obj.VpnConnection) }),
});
export const DeleteVerifiedAccessTrustProviderResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.VerifiedAccessTrustProvider && {
        VerifiedAccessTrustProvider: VerifiedAccessTrustProviderFilterSensitiveLog(obj.VerifiedAccessTrustProvider),
    }),
});
export const DescribeBundleTasksResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.BundleTasks && { BundleTasks: obj.BundleTasks.map((item) => BundleTaskFilterSensitiveLog(item)) }),
});
