import { SENSITIVE_STRING } from "@smithy/smithy-client";
import { SpotFleetRequestConfigDataFilterSensitiveLog, SpotInstanceRequestFilterSensitiveLog, } from "./models_5";
export const VerificationMethod = {
    dns_token: "dns-token",
    remarks_x509: "remarks-x509",
};
export const ReportInstanceReasonCodes = {
    instance_stuck_in_state: "instance-stuck-in-state",
    not_accepting_credentials: "not-accepting-credentials",
    other: "other",
    password_not_available: "password-not-available",
    performance_ebs_volume: "performance-ebs-volume",
    performance_instance_store: "performance-instance-store",
    performance_network: "performance-network",
    performance_other: "performance-other",
    unresponsive: "unresponsive",
};
export const ReportStatusType = {
    impaired: "impaired",
    ok: "ok",
};
export const ResetFpgaImageAttributeName = {
    loadPermission: "loadPermission",
};
export const ResetImageAttributeName = {
    launchPermission: "launchPermission",
};
export const MembershipType = {
    igmp: "igmp",
    static: "static",
};
export const ReportInstanceStatusRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Description && { Description: SENSITIVE_STRING }),
});
export const RequestSpotFleetRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.SpotFleetRequestConfig && {
        SpotFleetRequestConfig: SpotFleetRequestConfigDataFilterSensitiveLog(obj.SpotFleetRequestConfig),
    }),
});
export const RequestSpotLaunchSpecificationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.UserData && { UserData: SENSITIVE_STRING }),
});
export const RequestSpotInstancesRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.LaunchSpecification && {
        LaunchSpecification: RequestSpotLaunchSpecificationFilterSensitiveLog(obj.LaunchSpecification),
    }),
});
export const RequestSpotInstancesResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.SpotInstanceRequests && {
        SpotInstanceRequests: obj.SpotInstanceRequests.map((item) => SpotInstanceRequestFilterSensitiveLog(item)),
    }),
});
export const RunInstancesRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.UserData && { UserData: SENSITIVE_STRING }),
});
export const ScheduledInstancesLaunchSpecificationFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const RunScheduledInstancesRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.LaunchSpecification && { LaunchSpecification: SENSITIVE_STRING }),
});
