import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { EnableVolumeIORequest } from "../models/models_6";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link EnableVolumeIOCommand}.
 */
export interface EnableVolumeIOCommandInput extends EnableVolumeIORequest {
}
/**
 * @public
 *
 * The output of {@link EnableVolumeIOCommand}.
 */
export interface EnableVolumeIOCommandOutput extends __MetadataBearer {
}
declare const EnableVolumeIOCommand_base: {
    new (input: EnableVolumeIOCommandInput): import("@smithy/smithy-client").CommandImpl<EnableVolumeIOCommandInput, EnableVolumeIOCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (input: EnableVolumeIOCommandInput): import("@smithy/smithy-client").CommandImpl<EnableVolumeIOCommandInput, EnableVolumeIOCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Enables I/O operations for a volume that had I/O operations disabled because the data on
 *       the volume was potentially inconsistent.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, EnableVolumeIOCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, EnableVolumeIOCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * // import type { EC2ClientConfig } from "@aws-sdk/client-ec2";
 * const config = {}; // type is EC2ClientConfig
 * const client = new EC2Client(config);
 * const input = { // EnableVolumeIORequest
 *   DryRun: true || false,
 *   VolumeId: "STRING_VALUE", // required
 * };
 * const command = new EnableVolumeIOCommand(input);
 * const response = await client.send(command);
 * // {};
 *
 * ```
 *
 * @param EnableVolumeIOCommandInput - {@link EnableVolumeIOCommandInput}
 * @returns {@link EnableVolumeIOCommandOutput}
 * @see {@link EnableVolumeIOCommandInput} for command's `input` shape.
 * @see {@link EnableVolumeIOCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 *
 * @example To enable I/O for a volume
 * ```javascript
 * // This example enables I/O on volume ``vol-1234567890abcdef0``.
 * const input = {
 *   VolumeId: "vol-1234567890abcdef0"
 * };
 * const command = new EnableVolumeIOCommand(input);
 * const response = await client.send(command);
 * /* response is
 * { /* metadata only *\/ }
 * *\/
 * ```
 *
 * @public
 */
export declare class EnableVolumeIOCommand extends EnableVolumeIOCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: EnableVolumeIORequest;
            output: {};
        };
        sdk: {
            input: EnableVolumeIOCommandInput;
            output: EnableVolumeIOCommandOutput;
        };
    };
}
