import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { ExportClientVpnClientConfigurationRequest, ExportClientVpnClientConfigurationResult } from "../models/models_6";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link ExportClientVpnClientConfigurationCommand}.
 */
export interface ExportClientVpnClientConfigurationCommandInput extends ExportClientVpnClientConfigurationRequest {
}
/**
 * @public
 *
 * The output of {@link ExportClientVpnClientConfigurationCommand}.
 */
export interface ExportClientVpnClientConfigurationCommandOutput extends ExportClientVpnClientConfigurationResult, __MetadataBearer {
}
declare const ExportClientVpnClientConfigurationCommand_base: {
    new (input: ExportClientVpnClientConfigurationCommandInput): import("@smithy/smithy-client").CommandImpl<ExportClientVpnClientConfigurationCommandInput, ExportClientVpnClientConfigurationCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (input: ExportClientVpnClientConfigurationCommandInput): import("@smithy/smithy-client").CommandImpl<ExportClientVpnClientConfigurationCommandInput, ExportClientVpnClientConfigurationCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Downloads the contents of the Client VPN endpoint configuration file for the specified Client VPN endpoint. The Client VPN endpoint configuration
 * 			file includes the Client VPN endpoint and certificate information clients need to establish a connection
 * 			with the Client VPN endpoint.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, ExportClientVpnClientConfigurationCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, ExportClientVpnClientConfigurationCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * // import type { EC2ClientConfig } from "@aws-sdk/client-ec2";
 * const config = {}; // type is EC2ClientConfig
 * const client = new EC2Client(config);
 * const input = { // ExportClientVpnClientConfigurationRequest
 *   ClientVpnEndpointId: "STRING_VALUE", // required
 *   DryRun: true || false,
 * };
 * const command = new ExportClientVpnClientConfigurationCommand(input);
 * const response = await client.send(command);
 * // { // ExportClientVpnClientConfigurationResult
 * //   ClientConfiguration: "STRING_VALUE",
 * // };
 *
 * ```
 *
 * @param ExportClientVpnClientConfigurationCommandInput - {@link ExportClientVpnClientConfigurationCommandInput}
 * @returns {@link ExportClientVpnClientConfigurationCommandOutput}
 * @see {@link ExportClientVpnClientConfigurationCommandInput} for command's `input` shape.
 * @see {@link ExportClientVpnClientConfigurationCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 *
 * @public
 */
export declare class ExportClientVpnClientConfigurationCommand extends ExportClientVpnClientConfigurationCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: ExportClientVpnClientConfigurationRequest;
            output: ExportClientVpnClientConfigurationResult;
        };
        sdk: {
            input: ExportClientVpnClientConfigurationCommandInput;
            output: ExportClientVpnClientConfigurationCommandOutput;
        };
    };
}
