import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { RejectCapacityReservationBillingOwnershipRequest, RejectCapacityReservationBillingOwnershipResult } from "../models/models_8";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link RejectCapacityReservationBillingOwnershipCommand}.
 */
export interface RejectCapacityReservationBillingOwnershipCommandInput extends RejectCapacityReservationBillingOwnershipRequest {
}
/**
 * @public
 *
 * The output of {@link RejectCapacityReservationBillingOwnershipCommand}.
 */
export interface RejectCapacityReservationBillingOwnershipCommandOutput extends RejectCapacityReservationBillingOwnershipResult, __MetadataBearer {
}
declare const RejectCapacityReservationBillingOwnershipCommand_base: {
    new (input: RejectCapacityReservationBillingOwnershipCommandInput): import("@smithy/smithy-client").CommandImpl<RejectCapacityReservationBillingOwnershipCommandInput, RejectCapacityReservationBillingOwnershipCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (input: RejectCapacityReservationBillingOwnershipCommandInput): import("@smithy/smithy-client").CommandImpl<RejectCapacityReservationBillingOwnershipCommandInput, RejectCapacityReservationBillingOwnershipCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Rejects a request to assign billing of the available capacity of a shared Capacity
 * 			Reservation to your account. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/assign-billing.html"> Billing assignment for shared
 * 					Amazon EC2 Capacity Reservations</a>.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, RejectCapacityReservationBillingOwnershipCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, RejectCapacityReservationBillingOwnershipCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * // import type { EC2ClientConfig } from "@aws-sdk/client-ec2";
 * const config = {}; // type is EC2ClientConfig
 * const client = new EC2Client(config);
 * const input = { // RejectCapacityReservationBillingOwnershipRequest
 *   DryRun: true || false,
 *   CapacityReservationId: "STRING_VALUE", // required
 * };
 * const command = new RejectCapacityReservationBillingOwnershipCommand(input);
 * const response = await client.send(command);
 * // { // RejectCapacityReservationBillingOwnershipResult
 * //   Return: true || false,
 * // };
 *
 * ```
 *
 * @param RejectCapacityReservationBillingOwnershipCommandInput - {@link RejectCapacityReservationBillingOwnershipCommandInput}
 * @returns {@link RejectCapacityReservationBillingOwnershipCommandOutput}
 * @see {@link RejectCapacityReservationBillingOwnershipCommandInput} for command's `input` shape.
 * @see {@link RejectCapacityReservationBillingOwnershipCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 *
 * @public
 */
export declare class RejectCapacityReservationBillingOwnershipCommand extends RejectCapacityReservationBillingOwnershipCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: RejectCapacityReservationBillingOwnershipRequest;
            output: RejectCapacityReservationBillingOwnershipResult;
        };
        sdk: {
            input: RejectCapacityReservationBillingOwnershipCommandInput;
            output: RejectCapacityReservationBillingOwnershipCommandOutput;
        };
    };
}
