/**
 * <fullname>Amazon Elastic Compute Cloud</fullname>
 *          <p>You can access the features of Amazon Elastic Compute Cloud (Amazon EC2) programmatically. For more information,
 *         see the <a href="https://docs.aws.amazon.com/ec2/latest/devguide">Amazon EC2 Developer Guide</a>.</p>
 *
 * @packageDocumentation
 */
export * from "./EC2Client";
export * from "./EC2";
export { ClientInputEndpointParameters } from "./endpoint/EndpointParameters";
export type { RuntimeExtension } from "./runtimeExtensions";
export type { EC2ExtensionConfiguration } from "./extensionConfiguration";
export * from "./commands";
export * from "./pagination";
export * from "./waiters";
export * from "./models";
export { EC2ServiceException } from "./models/EC2ServiceException";
