import {
  AccessScopeAnalysisFinding,
  AddedPrincipal,
  AddIpamOperatingRegion,
  AddIpamOrganizationalUnitExclusion,
  AddPrefixListEntry,
  AddressAttribute,
  Affinity,
  ApplianceModeSupportValue,
  AutoPlacement,
  ByoipCidr,
  DnsSupportValue,
  EnaSrdSpecification,
  HostMaintenance,
  HostRecovery,
  InstanceEventWindow,
  Ipv6SupportValue,
  RouteServerAssociation,
  SecurityGroupReferencingSupportValue,
  SubnetAssociation,
  Tag,
  TagSpecification,
  TargetConfigurationRequest,
  TransitGatewayAssociationState,
  TransitGatewayAttachmentResourceType,
  TransitGatewayPolicyTableAssociation,
  TransitGatewayVpcAttachment,
  UnsuccessfulItem,
  VerifiedAccessInstance,
  VerifiedAccessSseSpecificationResponse,
  VerifiedAccessTrustProvider,
} from "./models_0";
import {
  _InstanceType,
  AttributeValue,
  CapacityReservation,
  CapacityReservationPreference,
  CapacityReservationTarget,
  ClientConnectOptions,
  ClientLoginBannerOptions,
  ClientRouteEnforcementOptions,
  ConnectionLogOptions,
  ConnectionTrackingSpecificationRequest,
  DiskImageFormat,
  EndDateType,
  FleetExcessCapacityTerminationPolicy,
  FleetLaunchTemplateConfigRequest,
  HostnameType,
  InstanceBandwidthWeighting,
  InstanceEventWindowTimeRangeRequest,
  InstanceMatchCriteria,
  InstanceRequirementsRequest,
  IpAddressType,
  Ipam,
  IpamMeteredAccount,
  IpamPool,
  IpamResourceDiscovery,
  IpamScope,
  IpamTier,
  LaunchTemplate,
  Placement,
  PlatformValues,
  RequestIpamResourceTag,
  SelfServicePortal,
  ShutdownBehavior,
  TargetCapacitySpecificationRequest,
  TargetCapacityUnitType,
  VolumeType,
} from "./models_1";
import {
  AutoAcceptSharedAttachmentsValue,
  DefaultRouteTableAssociationValue,
  DefaultRouteTablePropagationValue,
  DnsOptionsSpecification,
  InternetGatewayExclusionMode,
  LocalGatewayRoute,
  ManagedPrefixList,
  NetworkInsightsAccessScopeContent,
  RouteServer,
  RouteServerPersistRoutesAction,
  SubnetCidrReservation,
  SubnetConfiguration,
  TrafficDirection,
  TrafficMirrorFilter,
  TrafficMirrorFilterRule,
  TrafficMirrorNetworkService,
  TrafficMirrorPortRangeRequest,
  TrafficMirrorRuleAction,
  TrafficMirrorSession,
  TransitGateway,
  TransitGatewayPrefixListReference,
  VerifiedAccessEndpoint,
  VerifiedAccessEndpointProtocol,
  VerifiedAccessGroup,
  VerifiedAccessSseSpecificationRequest,
  VpcBlockPublicAccessExclusion,
  VpnEcmpSupportValue,
} from "./models_2";
import {
  Byoasn,
  Filter,
  IKEVersionsRequestListValue,
  PayerResponsibility,
  Phase1DHGroupNumbersRequestListValue,
  Phase1EncryptionAlgorithmsRequestListValue,
  Phase1IntegrityAlgorithmsRequestListValue,
  Phase2DHGroupNumbersRequestListValue,
  Phase2EncryptionAlgorithmsRequestListValue,
  Phase2IntegrityAlgorithmsRequestListValue,
  VpnConnection,
  VpnTunnelLogOptionsSpecification,
} from "./models_3";
import {
  ArchitectureValues,
  AttributeBooleanValue,
  BootModeValues,
  ConversionTask,
  FpgaImageAttribute,
  FpgaImageAttributeName,
  HttpTokensState,
  ImportImageLicenseConfigurationResponse,
  InstanceAttributeName,
  InstanceAutoRecoveryState,
  InstanceMetadataEndpointState,
  InstanceMetadataOptionsResponse,
  InstanceMetadataProtocolState,
  InstanceMetadataTagsState,
  InstanceRebootMigrationState,
  InstanceStatusEvent,
  LaunchPermission,
  Monitoring,
  PermissionGroup,
  SnapshotDetail,
  SnapshotTaskDetail,
  VirtualizationType,
} from "./models_4";
import {
  AnalysisStatus,
  ArchitectureType,
  CreateVolumePermission,
  ExcessCapacityTerminationPolicy,
  LaunchTemplateConfig,
  LockState,
  ReservedInstancesConfiguration,
  SnapshotAttributeName,
  VerifiedAccessInstanceLoggingConfiguration,
  VolumeModification,
} from "./models_5";
import {
  InstanceFamilyCreditSpecification,
  InternetGatewayBlockMode,
  IpamResourceCidr,
  ManagedBy,
  RouteServerPropagation,
  SnapshotBlockPublicAccessState,
  TransitGatewayPropagationState,
  UnlimitedSupportedInstanceFamily,
  VpcBlockPublicAccessOptions,
} from "./models_6";
export interface GetNetworkInsightsAccessScopeAnalysisFindingsResult {
  NetworkInsightsAccessScopeAnalysisId?: string | undefined;
  AnalysisStatus?: AnalysisStatus | undefined;
  AnalysisFindings?: AccessScopeAnalysisFinding[] | undefined;
  NextToken?: string | undefined;
}
export interface GetNetworkInsightsAccessScopeContentRequest {
  NetworkInsightsAccessScopeId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface GetNetworkInsightsAccessScopeContentResult {
  NetworkInsightsAccessScopeContent?:
    | NetworkInsightsAccessScopeContent
    | undefined;
}
export interface GetPasswordDataRequest {
  InstanceId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface GetPasswordDataResult {
  InstanceId?: string | undefined;
  Timestamp?: Date | undefined;
  PasswordData?: string | undefined;
}
export interface GetReservedInstancesExchangeQuoteRequest {
  DryRun?: boolean | undefined;
  ReservedInstanceIds: string[] | undefined;
  TargetConfigurations?: TargetConfigurationRequest[] | undefined;
}
export interface ReservationValue {
  HourlyPrice?: string | undefined;
  RemainingTotalValue?: string | undefined;
  RemainingUpfrontValue?: string | undefined;
}
export interface ReservedInstanceReservationValue {
  ReservationValue?: ReservationValue | undefined;
  ReservedInstanceId?: string | undefined;
}
export interface TargetConfiguration {
  InstanceCount?: number | undefined;
  OfferingId?: string | undefined;
}
export interface TargetReservationValue {
  ReservationValue?: ReservationValue | undefined;
  TargetConfiguration?: TargetConfiguration | undefined;
}
export interface GetReservedInstancesExchangeQuoteResult {
  CurrencyCode?: string | undefined;
  IsValidExchange?: boolean | undefined;
  OutputReservedInstancesWillExpireAt?: Date | undefined;
  PaymentDue?: string | undefined;
  ReservedInstanceValueRollup?: ReservationValue | undefined;
  ReservedInstanceValueSet?: ReservedInstanceReservationValue[] | undefined;
  TargetConfigurationValueRollup?: ReservationValue | undefined;
  TargetConfigurationValueSet?: TargetReservationValue[] | undefined;
  ValidationFailureReason?: string | undefined;
}
export interface GetRouteServerAssociationsRequest {
  RouteServerId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface GetRouteServerAssociationsResult {
  RouteServerAssociations?: RouteServerAssociation[] | undefined;
}
export interface GetRouteServerPropagationsRequest {
  RouteServerId: string | undefined;
  RouteTableId?: string | undefined;
  DryRun?: boolean | undefined;
}
export interface GetRouteServerPropagationsResult {
  RouteServerPropagations?: RouteServerPropagation[] | undefined;
}
export interface GetRouteServerRoutingDatabaseRequest {
  RouteServerId: string | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
  DryRun?: boolean | undefined;
  Filters?: Filter[] | undefined;
}
export declare const RouteServerRouteInstallationStatus: {
  readonly INSTALLED: "installed";
  readonly REJECTED: "rejected";
};
export type RouteServerRouteInstallationStatus =
  (typeof RouteServerRouteInstallationStatus)[keyof typeof RouteServerRouteInstallationStatus];
export interface RouteServerRouteInstallationDetail {
  RouteTableId?: string | undefined;
  RouteInstallationStatus?: RouteServerRouteInstallationStatus | undefined;
  RouteInstallationStatusReason?: string | undefined;
}
export declare const RouteServerRouteStatus: {
  readonly IN_FIB: "in-fib";
  readonly IN_RIB: "in-rib";
};
export type RouteServerRouteStatus =
  (typeof RouteServerRouteStatus)[keyof typeof RouteServerRouteStatus];
export interface RouteServerRoute {
  RouteServerEndpointId?: string | undefined;
  RouteServerPeerId?: string | undefined;
  RouteInstallationDetails?: RouteServerRouteInstallationDetail[] | undefined;
  RouteStatus?: RouteServerRouteStatus | undefined;
  Prefix?: string | undefined;
  AsPaths?: string[] | undefined;
  Med?: number | undefined;
  NextHopIp?: string | undefined;
}
export interface GetRouteServerRoutingDatabaseResult {
  AreRoutesPersisted?: boolean | undefined;
  Routes?: RouteServerRoute[] | undefined;
  NextToken?: string | undefined;
}
export interface GetSecurityGroupsForVpcRequest {
  VpcId: string | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
  Filters?: Filter[] | undefined;
  DryRun?: boolean | undefined;
}
export interface SecurityGroupForVpc {
  Description?: string | undefined;
  GroupName?: string | undefined;
  OwnerId?: string | undefined;
  GroupId?: string | undefined;
  Tags?: Tag[] | undefined;
  PrimaryVpcId?: string | undefined;
}
export interface GetSecurityGroupsForVpcResult {
  NextToken?: string | undefined;
  SecurityGroupForVpcs?: SecurityGroupForVpc[] | undefined;
}
export interface GetSerialConsoleAccessStatusRequest {
  DryRun?: boolean | undefined;
}
export interface GetSerialConsoleAccessStatusResult {
  SerialConsoleAccessEnabled?: boolean | undefined;
  ManagedBy?: ManagedBy | undefined;
}
export interface GetSnapshotBlockPublicAccessStateRequest {
  DryRun?: boolean | undefined;
}
export interface GetSnapshotBlockPublicAccessStateResult {
  State?: SnapshotBlockPublicAccessState | undefined;
  ManagedBy?: ManagedBy | undefined;
}
export interface InstanceRequirementsWithMetadataRequest {
  ArchitectureTypes?: ArchitectureType[] | undefined;
  VirtualizationTypes?: VirtualizationType[] | undefined;
  InstanceRequirements?: InstanceRequirementsRequest | undefined;
}
export interface GetSpotPlacementScoresRequest {
  InstanceTypes?: string[] | undefined;
  TargetCapacity: number | undefined;
  TargetCapacityUnitType?: TargetCapacityUnitType | undefined;
  SingleAvailabilityZone?: boolean | undefined;
  RegionNames?: string[] | undefined;
  InstanceRequirementsWithMetadata?:
    | InstanceRequirementsWithMetadataRequest
    | undefined;
  DryRun?: boolean | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
}
export interface SpotPlacementScore {
  Region?: string | undefined;
  AvailabilityZoneId?: string | undefined;
  Score?: number | undefined;
}
export interface GetSpotPlacementScoresResult {
  SpotPlacementScores?: SpotPlacementScore[] | undefined;
  NextToken?: string | undefined;
}
export interface GetSubnetCidrReservationsRequest {
  Filters?: Filter[] | undefined;
  SubnetId: string | undefined;
  DryRun?: boolean | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
}
export interface GetSubnetCidrReservationsResult {
  SubnetIpv4CidrReservations?: SubnetCidrReservation[] | undefined;
  SubnetIpv6CidrReservations?: SubnetCidrReservation[] | undefined;
  NextToken?: string | undefined;
}
export interface GetTransitGatewayAttachmentPropagationsRequest {
  TransitGatewayAttachmentId: string | undefined;
  Filters?: Filter[] | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
  DryRun?: boolean | undefined;
}
export interface TransitGatewayAttachmentPropagation {
  TransitGatewayRouteTableId?: string | undefined;
  State?: TransitGatewayPropagationState | undefined;
}
export interface GetTransitGatewayAttachmentPropagationsResult {
  TransitGatewayAttachmentPropagations?:
    | TransitGatewayAttachmentPropagation[]
    | undefined;
  NextToken?: string | undefined;
}
export interface GetTransitGatewayMulticastDomainAssociationsRequest {
  TransitGatewayMulticastDomainId: string | undefined;
  Filters?: Filter[] | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
  DryRun?: boolean | undefined;
}
export interface TransitGatewayMulticastDomainAssociation {
  TransitGatewayAttachmentId?: string | undefined;
  ResourceId?: string | undefined;
  ResourceType?: TransitGatewayAttachmentResourceType | undefined;
  ResourceOwnerId?: string | undefined;
  Subnet?: SubnetAssociation | undefined;
}
export interface GetTransitGatewayMulticastDomainAssociationsResult {
  MulticastDomainAssociations?:
    | TransitGatewayMulticastDomainAssociation[]
    | undefined;
  NextToken?: string | undefined;
}
export interface GetTransitGatewayPolicyTableAssociationsRequest {
  TransitGatewayPolicyTableId: string | undefined;
  Filters?: Filter[] | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
  DryRun?: boolean | undefined;
}
export interface GetTransitGatewayPolicyTableAssociationsResult {
  Associations?: TransitGatewayPolicyTableAssociation[] | undefined;
  NextToken?: string | undefined;
}
export interface GetTransitGatewayPolicyTableEntriesRequest {
  TransitGatewayPolicyTableId: string | undefined;
  Filters?: Filter[] | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
  DryRun?: boolean | undefined;
}
export interface TransitGatewayPolicyRuleMetaData {
  MetaDataKey?: string | undefined;
  MetaDataValue?: string | undefined;
}
export interface TransitGatewayPolicyRule {
  SourceCidrBlock?: string | undefined;
  SourcePortRange?: string | undefined;
  DestinationCidrBlock?: string | undefined;
  DestinationPortRange?: string | undefined;
  Protocol?: string | undefined;
  MetaData?: TransitGatewayPolicyRuleMetaData | undefined;
}
export interface TransitGatewayPolicyTableEntry {
  PolicyRuleNumber?: string | undefined;
  PolicyRule?: TransitGatewayPolicyRule | undefined;
  TargetRouteTableId?: string | undefined;
}
export interface GetTransitGatewayPolicyTableEntriesResult {
  TransitGatewayPolicyTableEntries?:
    | TransitGatewayPolicyTableEntry[]
    | undefined;
}
export interface GetTransitGatewayPrefixListReferencesRequest {
  TransitGatewayRouteTableId: string | undefined;
  Filters?: Filter[] | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
  DryRun?: boolean | undefined;
}
export interface GetTransitGatewayPrefixListReferencesResult {
  TransitGatewayPrefixListReferences?:
    | TransitGatewayPrefixListReference[]
    | undefined;
  NextToken?: string | undefined;
}
export interface GetTransitGatewayRouteTableAssociationsRequest {
  TransitGatewayRouteTableId: string | undefined;
  Filters?: Filter[] | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
  DryRun?: boolean | undefined;
}
export interface TransitGatewayRouteTableAssociation {
  TransitGatewayAttachmentId?: string | undefined;
  ResourceId?: string | undefined;
  ResourceType?: TransitGatewayAttachmentResourceType | undefined;
  State?: TransitGatewayAssociationState | undefined;
}
export interface GetTransitGatewayRouteTableAssociationsResult {
  Associations?: TransitGatewayRouteTableAssociation[] | undefined;
  NextToken?: string | undefined;
}
export interface GetTransitGatewayRouteTablePropagationsRequest {
  TransitGatewayRouteTableId: string | undefined;
  Filters?: Filter[] | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
  DryRun?: boolean | undefined;
}
export interface TransitGatewayRouteTablePropagation {
  TransitGatewayAttachmentId?: string | undefined;
  ResourceId?: string | undefined;
  ResourceType?: TransitGatewayAttachmentResourceType | undefined;
  State?: TransitGatewayPropagationState | undefined;
  TransitGatewayRouteTableAnnouncementId?: string | undefined;
}
export interface GetTransitGatewayRouteTablePropagationsResult {
  TransitGatewayRouteTablePropagations?:
    | TransitGatewayRouteTablePropagation[]
    | undefined;
  NextToken?: string | undefined;
}
export interface GetVerifiedAccessEndpointPolicyRequest {
  VerifiedAccessEndpointId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface GetVerifiedAccessEndpointPolicyResult {
  PolicyEnabled?: boolean | undefined;
  PolicyDocument?: string | undefined;
}
export interface GetVerifiedAccessEndpointTargetsRequest {
  VerifiedAccessEndpointId: string | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
  DryRun?: boolean | undefined;
}
export interface VerifiedAccessEndpointTarget {
  VerifiedAccessEndpointId?: string | undefined;
  VerifiedAccessEndpointTargetIpAddress?: string | undefined;
  VerifiedAccessEndpointTargetDns?: string | undefined;
}
export interface GetVerifiedAccessEndpointTargetsResult {
  VerifiedAccessEndpointTargets?: VerifiedAccessEndpointTarget[] | undefined;
  NextToken?: string | undefined;
}
export interface GetVerifiedAccessGroupPolicyRequest {
  VerifiedAccessGroupId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface GetVerifiedAccessGroupPolicyResult {
  PolicyEnabled?: boolean | undefined;
  PolicyDocument?: string | undefined;
}
export interface GetVpnConnectionDeviceSampleConfigurationRequest {
  VpnConnectionId: string | undefined;
  VpnConnectionDeviceTypeId: string | undefined;
  InternetKeyExchangeVersion?: string | undefined;
  SampleType?: string | undefined;
  DryRun?: boolean | undefined;
}
export interface GetVpnConnectionDeviceSampleConfigurationResult {
  VpnConnectionDeviceSampleConfiguration?: string | undefined;
}
export interface GetVpnConnectionDeviceTypesRequest {
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
  DryRun?: boolean | undefined;
}
export interface VpnConnectionDeviceType {
  VpnConnectionDeviceTypeId?: string | undefined;
  Vendor?: string | undefined;
  Platform?: string | undefined;
  Software?: string | undefined;
}
export interface GetVpnConnectionDeviceTypesResult {
  VpnConnectionDeviceTypes?: VpnConnectionDeviceType[] | undefined;
  NextToken?: string | undefined;
}
export interface GetVpnTunnelReplacementStatusRequest {
  VpnConnectionId: string | undefined;
  VpnTunnelOutsideIpAddress: string | undefined;
  DryRun?: boolean | undefined;
}
export interface MaintenanceDetails {
  PendingMaintenance?: string | undefined;
  MaintenanceAutoAppliedAfter?: Date | undefined;
  LastMaintenanceApplied?: Date | undefined;
}
export interface GetVpnTunnelReplacementStatusResult {
  VpnConnectionId?: string | undefined;
  TransitGatewayId?: string | undefined;
  CustomerGatewayId?: string | undefined;
  VpnGatewayId?: string | undefined;
  VpnTunnelOutsideIpAddress?: string | undefined;
  MaintenanceDetails?: MaintenanceDetails | undefined;
}
export interface ImportClientVpnClientCertificateRevocationListRequest {
  ClientVpnEndpointId: string | undefined;
  CertificateRevocationList: string | undefined;
  DryRun?: boolean | undefined;
}
export interface ImportClientVpnClientCertificateRevocationListResult {
  Return?: boolean | undefined;
}
export interface ClientData {
  Comment?: string | undefined;
  UploadEnd?: Date | undefined;
  UploadSize?: number | undefined;
  UploadStart?: Date | undefined;
}
export interface UserBucket {
  S3Bucket?: string | undefined;
  S3Key?: string | undefined;
}
export interface ImageDiskContainer {
  Description?: string | undefined;
  DeviceName?: string | undefined;
  Format?: string | undefined;
  SnapshotId?: string | undefined;
  Url?: string | undefined;
  UserBucket?: UserBucket | undefined;
}
export interface ImportImageLicenseConfigurationRequest {
  LicenseConfigurationArn?: string | undefined;
}
export interface ImportImageRequest {
  Architecture?: string | undefined;
  ClientData?: ClientData | undefined;
  ClientToken?: string | undefined;
  Description?: string | undefined;
  DiskContainers?: ImageDiskContainer[] | undefined;
  DryRun?: boolean | undefined;
  Encrypted?: boolean | undefined;
  Hypervisor?: string | undefined;
  KmsKeyId?: string | undefined;
  LicenseType?: string | undefined;
  Platform?: string | undefined;
  RoleName?: string | undefined;
  LicenseSpecifications?: ImportImageLicenseConfigurationRequest[] | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
  UsageOperation?: string | undefined;
  BootMode?: BootModeValues | undefined;
}
export interface ImportImageResult {
  Architecture?: string | undefined;
  Description?: string | undefined;
  Encrypted?: boolean | undefined;
  Hypervisor?: string | undefined;
  ImageId?: string | undefined;
  ImportTaskId?: string | undefined;
  KmsKeyId?: string | undefined;
  LicenseType?: string | undefined;
  Platform?: string | undefined;
  Progress?: string | undefined;
  SnapshotDetails?: SnapshotDetail[] | undefined;
  Status?: string | undefined;
  StatusMessage?: string | undefined;
  LicenseSpecifications?: ImportImageLicenseConfigurationResponse[] | undefined;
  Tags?: Tag[] | undefined;
  UsageOperation?: string | undefined;
}
export interface DiskImageDetail {
  Format: DiskImageFormat | undefined;
  Bytes: number | undefined;
  ImportManifestUrl: string | undefined;
}
export interface VolumeDetail {
  Size: number | undefined;
}
export interface DiskImage {
  Description?: string | undefined;
  Image?: DiskImageDetail | undefined;
  Volume?: VolumeDetail | undefined;
}
export interface UserData {
  Data?: string | undefined;
}
export interface ImportInstanceLaunchSpecification {
  Architecture?: ArchitectureValues | undefined;
  GroupNames?: string[] | undefined;
  GroupIds?: string[] | undefined;
  AdditionalInfo?: string | undefined;
  UserData?: UserData | undefined;
  InstanceType?: _InstanceType | undefined;
  Placement?: Placement | undefined;
  Monitoring?: boolean | undefined;
  SubnetId?: string | undefined;
  InstanceInitiatedShutdownBehavior?: ShutdownBehavior | undefined;
  PrivateIpAddress?: string | undefined;
}
export interface ImportInstanceRequest {
  DryRun?: boolean | undefined;
  Description?: string | undefined;
  LaunchSpecification?: ImportInstanceLaunchSpecification | undefined;
  DiskImages?: DiskImage[] | undefined;
  Platform: PlatformValues | undefined;
}
export interface ImportInstanceResult {
  ConversionTask?: ConversionTask | undefined;
}
export interface ImportKeyPairRequest {
  TagSpecifications?: TagSpecification[] | undefined;
  DryRun?: boolean | undefined;
  KeyName: string | undefined;
  PublicKeyMaterial: Uint8Array | undefined;
}
export interface ImportKeyPairResult {
  KeyFingerprint?: string | undefined;
  KeyName?: string | undefined;
  KeyPairId?: string | undefined;
  Tags?: Tag[] | undefined;
}
export interface SnapshotDiskContainer {
  Description?: string | undefined;
  Format?: string | undefined;
  Url?: string | undefined;
  UserBucket?: UserBucket | undefined;
}
export interface ImportSnapshotRequest {
  ClientData?: ClientData | undefined;
  ClientToken?: string | undefined;
  Description?: string | undefined;
  DiskContainer?: SnapshotDiskContainer | undefined;
  DryRun?: boolean | undefined;
  Encrypted?: boolean | undefined;
  KmsKeyId?: string | undefined;
  RoleName?: string | undefined;
  TagSpecifications?: TagSpecification[] | undefined;
}
export interface ImportSnapshotResult {
  Description?: string | undefined;
  ImportTaskId?: string | undefined;
  SnapshotTaskDetail?: SnapshotTaskDetail | undefined;
  Tags?: Tag[] | undefined;
}
export interface ImportVolumeRequest {
  AvailabilityZoneId?: string | undefined;
  DryRun?: boolean | undefined;
  AvailabilityZone?: string | undefined;
  Image: DiskImageDetail | undefined;
  Description?: string | undefined;
  Volume: VolumeDetail | undefined;
}
export interface ImportVolumeResult {
  ConversionTask?: ConversionTask | undefined;
}
export interface ListImagesInRecycleBinRequest {
  ImageIds?: string[] | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
  DryRun?: boolean | undefined;
}
export interface ImageRecycleBinInfo {
  ImageId?: string | undefined;
  Name?: string | undefined;
  Description?: string | undefined;
  RecycleBinEnterTime?: Date | undefined;
  RecycleBinExitTime?: Date | undefined;
}
export interface ListImagesInRecycleBinResult {
  Images?: ImageRecycleBinInfo[] | undefined;
  NextToken?: string | undefined;
}
export interface ListSnapshotsInRecycleBinRequest {
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
  SnapshotIds?: string[] | undefined;
  DryRun?: boolean | undefined;
}
export interface SnapshotRecycleBinInfo {
  SnapshotId?: string | undefined;
  RecycleBinEnterTime?: Date | undefined;
  RecycleBinExitTime?: Date | undefined;
  Description?: string | undefined;
  VolumeId?: string | undefined;
}
export interface ListSnapshotsInRecycleBinResult {
  Snapshots?: SnapshotRecycleBinInfo[] | undefined;
  NextToken?: string | undefined;
}
export declare const LockMode: {
  readonly compliance: "compliance";
  readonly governance: "governance";
};
export type LockMode = (typeof LockMode)[keyof typeof LockMode];
export interface LockSnapshotRequest {
  SnapshotId: string | undefined;
  DryRun?: boolean | undefined;
  LockMode: LockMode | undefined;
  CoolOffPeriod?: number | undefined;
  LockDuration?: number | undefined;
  ExpirationDate?: Date | undefined;
}
export interface LockSnapshotResult {
  SnapshotId?: string | undefined;
  LockState?: LockState | undefined;
  LockDuration?: number | undefined;
  CoolOffPeriod?: number | undefined;
  CoolOffPeriodExpiresOn?: Date | undefined;
  LockCreatedOn?: Date | undefined;
  LockExpiresOn?: Date | undefined;
  LockDurationStartTime?: Date | undefined;
}
export interface ModifyAddressAttributeRequest {
  AllocationId: string | undefined;
  DomainName?: string | undefined;
  DryRun?: boolean | undefined;
}
export interface ModifyAddressAttributeResult {
  Address?: AddressAttribute | undefined;
}
export declare const ModifyAvailabilityZoneOptInStatus: {
  readonly not_opted_in: "not-opted-in";
  readonly opted_in: "opted-in";
};
export type ModifyAvailabilityZoneOptInStatus =
  (typeof ModifyAvailabilityZoneOptInStatus)[keyof typeof ModifyAvailabilityZoneOptInStatus];
export interface ModifyAvailabilityZoneGroupRequest {
  GroupName: string | undefined;
  OptInStatus: ModifyAvailabilityZoneOptInStatus | undefined;
  DryRun?: boolean | undefined;
}
export interface ModifyAvailabilityZoneGroupResult {
  Return?: boolean | undefined;
}
export interface ModifyCapacityReservationRequest {
  CapacityReservationId: string | undefined;
  InstanceCount?: number | undefined;
  EndDate?: Date | undefined;
  EndDateType?: EndDateType | undefined;
  Accept?: boolean | undefined;
  DryRun?: boolean | undefined;
  AdditionalInfo?: string | undefined;
  InstanceMatchCriteria?: InstanceMatchCriteria | undefined;
}
export interface ModifyCapacityReservationResult {
  Return?: boolean | undefined;
}
export interface ModifyCapacityReservationFleetRequest {
  CapacityReservationFleetId: string | undefined;
  TotalTargetCapacity?: number | undefined;
  EndDate?: Date | undefined;
  DryRun?: boolean | undefined;
  RemoveEndDate?: boolean | undefined;
}
export interface ModifyCapacityReservationFleetResult {
  Return?: boolean | undefined;
}
export interface DnsServersOptionsModifyStructure {
  CustomDnsServers?: string[] | undefined;
  Enabled?: boolean | undefined;
}
export interface ModifyClientVpnEndpointRequest {
  ClientVpnEndpointId: string | undefined;
  ServerCertificateArn?: string | undefined;
  ConnectionLogOptions?: ConnectionLogOptions | undefined;
  DnsServers?: DnsServersOptionsModifyStructure | undefined;
  VpnPort?: number | undefined;
  Description?: string | undefined;
  SplitTunnel?: boolean | undefined;
  DryRun?: boolean | undefined;
  SecurityGroupIds?: string[] | undefined;
  VpcId?: string | undefined;
  SelfServicePortal?: SelfServicePortal | undefined;
  ClientConnectOptions?: ClientConnectOptions | undefined;
  SessionTimeoutHours?: number | undefined;
  ClientLoginBannerOptions?: ClientLoginBannerOptions | undefined;
  ClientRouteEnforcementOptions?: ClientRouteEnforcementOptions | undefined;
  DisconnectOnSessionTimeout?: boolean | undefined;
}
export interface ModifyClientVpnEndpointResult {
  Return?: boolean | undefined;
}
export interface ModifyDefaultCreditSpecificationRequest {
  DryRun?: boolean | undefined;
  InstanceFamily: UnlimitedSupportedInstanceFamily | undefined;
  CpuCredits: string | undefined;
}
export interface ModifyDefaultCreditSpecificationResult {
  InstanceFamilyCreditSpecification?:
    | InstanceFamilyCreditSpecification
    | undefined;
}
export interface ModifyEbsDefaultKmsKeyIdRequest {
  KmsKeyId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface ModifyEbsDefaultKmsKeyIdResult {
  KmsKeyId?: string | undefined;
}
export interface ModifyFleetRequest {
  DryRun?: boolean | undefined;
  ExcessCapacityTerminationPolicy?:
    | FleetExcessCapacityTerminationPolicy
    | undefined;
  LaunchTemplateConfigs?: FleetLaunchTemplateConfigRequest[] | undefined;
  FleetId: string | undefined;
  TargetCapacitySpecification?: TargetCapacitySpecificationRequest | undefined;
  Context?: string | undefined;
}
export interface ModifyFleetResult {
  Return?: boolean | undefined;
}
export interface LoadPermissionRequest {
  Group?: PermissionGroup | undefined;
  UserId?: string | undefined;
}
export interface LoadPermissionModifications {
  Add?: LoadPermissionRequest[] | undefined;
  Remove?: LoadPermissionRequest[] | undefined;
}
export declare const OperationType: {
  readonly add: "add";
  readonly remove: "remove";
};
export type OperationType = (typeof OperationType)[keyof typeof OperationType];
export interface ModifyFpgaImageAttributeRequest {
  DryRun?: boolean | undefined;
  FpgaImageId: string | undefined;
  Attribute?: FpgaImageAttributeName | undefined;
  OperationType?: OperationType | undefined;
  UserIds?: string[] | undefined;
  UserGroups?: string[] | undefined;
  ProductCodes?: string[] | undefined;
  LoadPermission?: LoadPermissionModifications | undefined;
  Description?: string | undefined;
  Name?: string | undefined;
}
export interface ModifyFpgaImageAttributeResult {
  FpgaImageAttribute?: FpgaImageAttribute | undefined;
}
export interface ModifyHostsRequest {
  HostRecovery?: HostRecovery | undefined;
  InstanceType?: string | undefined;
  InstanceFamily?: string | undefined;
  HostMaintenance?: HostMaintenance | undefined;
  HostIds: string[] | undefined;
  AutoPlacement?: AutoPlacement | undefined;
}
export interface ModifyHostsResult {
  Successful?: string[] | undefined;
  Unsuccessful?: UnsuccessfulItem[] | undefined;
}
export interface ModifyIdentityIdFormatRequest {
  Resource: string | undefined;
  UseLongIds: boolean | undefined;
  PrincipalArn: string | undefined;
}
export interface ModifyIdFormatRequest {
  Resource: string | undefined;
  UseLongIds: boolean | undefined;
}
export interface LaunchPermissionModifications {
  Add?: LaunchPermission[] | undefined;
  Remove?: LaunchPermission[] | undefined;
}
export interface ModifyImageAttributeRequest {
  Attribute?: string | undefined;
  Description?: AttributeValue | undefined;
  ImageId: string | undefined;
  LaunchPermission?: LaunchPermissionModifications | undefined;
  OperationType?: OperationType | undefined;
  ProductCodes?: string[] | undefined;
  UserGroups?: string[] | undefined;
  UserIds?: string[] | undefined;
  Value?: string | undefined;
  OrganizationArns?: string[] | undefined;
  OrganizationalUnitArns?: string[] | undefined;
  ImdsSupport?: AttributeValue | undefined;
  DryRun?: boolean | undefined;
}
export interface EbsInstanceBlockDeviceSpecification {
  VolumeId?: string | undefined;
  DeleteOnTermination?: boolean | undefined;
}
export interface InstanceBlockDeviceMappingSpecification {
  DeviceName?: string | undefined;
  Ebs?: EbsInstanceBlockDeviceSpecification | undefined;
  VirtualName?: string | undefined;
  NoDevice?: string | undefined;
}
export interface BlobAttributeValue {
  Value?: Uint8Array | undefined;
}
export interface ModifyInstanceAttributeRequest {
  SourceDestCheck?: AttributeBooleanValue | undefined;
  DisableApiStop?: AttributeBooleanValue | undefined;
  DryRun?: boolean | undefined;
  InstanceId: string | undefined;
  Attribute?: InstanceAttributeName | undefined;
  Value?: string | undefined;
  BlockDeviceMappings?: InstanceBlockDeviceMappingSpecification[] | undefined;
  DisableApiTermination?: AttributeBooleanValue | undefined;
  InstanceType?: AttributeValue | undefined;
  Kernel?: AttributeValue | undefined;
  Ramdisk?: AttributeValue | undefined;
  UserData?: BlobAttributeValue | undefined;
  InstanceInitiatedShutdownBehavior?: AttributeValue | undefined;
  Groups?: string[] | undefined;
  EbsOptimized?: AttributeBooleanValue | undefined;
  SriovNetSupport?: AttributeValue | undefined;
  EnaSupport?: AttributeBooleanValue | undefined;
}
export interface CapacityReservationSpecification {
  CapacityReservationPreference?: CapacityReservationPreference | undefined;
  CapacityReservationTarget?: CapacityReservationTarget | undefined;
}
export interface ModifyInstanceCapacityReservationAttributesRequest {
  InstanceId: string | undefined;
  CapacityReservationSpecification:
    | CapacityReservationSpecification
    | undefined;
  DryRun?: boolean | undefined;
}
export interface ModifyInstanceCapacityReservationAttributesResult {
  Return?: boolean | undefined;
}
export interface ModifyInstanceConnectEndpointRequest {
  DryRun?: boolean | undefined;
  InstanceConnectEndpointId: string | undefined;
  IpAddressType?: IpAddressType | undefined;
  SecurityGroupIds?: string[] | undefined;
  PreserveClientIp?: boolean | undefined;
}
export interface ModifyInstanceConnectEndpointResult {
  Return?: boolean | undefined;
}
export interface ModifyInstanceCpuOptionsRequest {
  InstanceId: string | undefined;
  CoreCount: number | undefined;
  ThreadsPerCore: number | undefined;
  DryRun?: boolean | undefined;
}
export interface ModifyInstanceCpuOptionsResult {
  InstanceId?: string | undefined;
  CoreCount?: number | undefined;
  ThreadsPerCore?: number | undefined;
}
export interface InstanceCreditSpecificationRequest {
  InstanceId: string | undefined;
  CpuCredits?: string | undefined;
}
export interface ModifyInstanceCreditSpecificationRequest {
  DryRun?: boolean | undefined;
  ClientToken?: string | undefined;
  InstanceCreditSpecifications:
    | InstanceCreditSpecificationRequest[]
    | undefined;
}
export interface SuccessfulInstanceCreditSpecificationItem {
  InstanceId?: string | undefined;
}
export declare const UnsuccessfulInstanceCreditSpecificationErrorCode: {
  readonly INCORRECT_INSTANCE_STATE: "IncorrectInstanceState";
  readonly INSTANCE_CREDIT_SPECIFICATION_NOT_SUPPORTED: "InstanceCreditSpecification.NotSupported";
  readonly INSTANCE_NOT_FOUND: "InvalidInstanceID.NotFound";
  readonly INVALID_INSTANCE_ID: "InvalidInstanceID.Malformed";
};
export type UnsuccessfulInstanceCreditSpecificationErrorCode =
  (typeof UnsuccessfulInstanceCreditSpecificationErrorCode)[keyof typeof UnsuccessfulInstanceCreditSpecificationErrorCode];
export interface UnsuccessfulInstanceCreditSpecificationItemError {
  Code?: UnsuccessfulInstanceCreditSpecificationErrorCode | undefined;
  Message?: string | undefined;
}
export interface UnsuccessfulInstanceCreditSpecificationItem {
  InstanceId?: string | undefined;
  Error?: UnsuccessfulInstanceCreditSpecificationItemError | undefined;
}
export interface ModifyInstanceCreditSpecificationResult {
  SuccessfulInstanceCreditSpecifications?:
    | SuccessfulInstanceCreditSpecificationItem[]
    | undefined;
  UnsuccessfulInstanceCreditSpecifications?:
    | UnsuccessfulInstanceCreditSpecificationItem[]
    | undefined;
}
export interface ModifyInstanceEventStartTimeRequest {
  DryRun?: boolean | undefined;
  InstanceId: string | undefined;
  InstanceEventId: string | undefined;
  NotBefore: Date | undefined;
}
export interface ModifyInstanceEventStartTimeResult {
  Event?: InstanceStatusEvent | undefined;
}
export interface ModifyInstanceEventWindowRequest {
  DryRun?: boolean | undefined;
  Name?: string | undefined;
  InstanceEventWindowId: string | undefined;
  TimeRanges?: InstanceEventWindowTimeRangeRequest[] | undefined;
  CronExpression?: string | undefined;
}
export interface ModifyInstanceEventWindowResult {
  InstanceEventWindow?: InstanceEventWindow | undefined;
}
export interface ModifyInstanceMaintenanceOptionsRequest {
  InstanceId: string | undefined;
  AutoRecovery?: InstanceAutoRecoveryState | undefined;
  RebootMigration?: InstanceRebootMigrationState | undefined;
  DryRun?: boolean | undefined;
}
export interface ModifyInstanceMaintenanceOptionsResult {
  InstanceId?: string | undefined;
  AutoRecovery?: InstanceAutoRecoveryState | undefined;
  RebootMigration?: InstanceRebootMigrationState | undefined;
}
export declare const DefaultInstanceMetadataEndpointState: {
  readonly disabled: "disabled";
  readonly enabled: "enabled";
  readonly no_preference: "no-preference";
};
export type DefaultInstanceMetadataEndpointState =
  (typeof DefaultInstanceMetadataEndpointState)[keyof typeof DefaultInstanceMetadataEndpointState];
export declare const MetadataDefaultHttpTokensState: {
  readonly no_preference: "no-preference";
  readonly optional: "optional";
  readonly required: "required";
};
export type MetadataDefaultHttpTokensState =
  (typeof MetadataDefaultHttpTokensState)[keyof typeof MetadataDefaultHttpTokensState];
export declare const DefaultInstanceMetadataTagsState: {
  readonly disabled: "disabled";
  readonly enabled: "enabled";
  readonly no_preference: "no-preference";
};
export type DefaultInstanceMetadataTagsState =
  (typeof DefaultInstanceMetadataTagsState)[keyof typeof DefaultInstanceMetadataTagsState];
export interface ModifyInstanceMetadataDefaultsRequest {
  HttpTokens?: MetadataDefaultHttpTokensState | undefined;
  HttpPutResponseHopLimit?: number | undefined;
  HttpEndpoint?: DefaultInstanceMetadataEndpointState | undefined;
  InstanceMetadataTags?: DefaultInstanceMetadataTagsState | undefined;
  DryRun?: boolean | undefined;
}
export interface ModifyInstanceMetadataDefaultsResult {
  Return?: boolean | undefined;
}
export interface ModifyInstanceMetadataOptionsRequest {
  InstanceId: string | undefined;
  HttpTokens?: HttpTokensState | undefined;
  HttpPutResponseHopLimit?: number | undefined;
  HttpEndpoint?: InstanceMetadataEndpointState | undefined;
  DryRun?: boolean | undefined;
  HttpProtocolIpv6?: InstanceMetadataProtocolState | undefined;
  InstanceMetadataTags?: InstanceMetadataTagsState | undefined;
}
export interface ModifyInstanceMetadataOptionsResult {
  InstanceId?: string | undefined;
  InstanceMetadataOptions?: InstanceMetadataOptionsResponse | undefined;
}
export interface ModifyInstanceNetworkPerformanceRequest {
  InstanceId: string | undefined;
  BandwidthWeighting: InstanceBandwidthWeighting | undefined;
  DryRun?: boolean | undefined;
}
export interface ModifyInstanceNetworkPerformanceResult {
  InstanceId?: string | undefined;
  BandwidthWeighting?: InstanceBandwidthWeighting | undefined;
}
export declare const HostTenancy: {
  readonly dedicated: "dedicated";
  readonly default: "default";
  readonly host: "host";
};
export type HostTenancy = (typeof HostTenancy)[keyof typeof HostTenancy];
export interface ModifyInstancePlacementRequest {
  GroupName?: string | undefined;
  PartitionNumber?: number | undefined;
  HostResourceGroupArn?: string | undefined;
  GroupId?: string | undefined;
  InstanceId: string | undefined;
  Tenancy?: HostTenancy | undefined;
  Affinity?: Affinity | undefined;
  HostId?: string | undefined;
}
export interface ModifyInstancePlacementResult {
  Return?: boolean | undefined;
}
export interface RemoveIpamOperatingRegion {
  RegionName?: string | undefined;
}
export interface ModifyIpamRequest {
  DryRun?: boolean | undefined;
  IpamId: string | undefined;
  Description?: string | undefined;
  AddOperatingRegions?: AddIpamOperatingRegion[] | undefined;
  RemoveOperatingRegions?: RemoveIpamOperatingRegion[] | undefined;
  Tier?: IpamTier | undefined;
  EnablePrivateGua?: boolean | undefined;
  MeteredAccount?: IpamMeteredAccount | undefined;
}
export interface ModifyIpamResult {
  Ipam?: Ipam | undefined;
}
export interface ModifyIpamPoolRequest {
  DryRun?: boolean | undefined;
  IpamPoolId: string | undefined;
  Description?: string | undefined;
  AutoImport?: boolean | undefined;
  AllocationMinNetmaskLength?: number | undefined;
  AllocationMaxNetmaskLength?: number | undefined;
  AllocationDefaultNetmaskLength?: number | undefined;
  ClearAllocationDefaultNetmaskLength?: boolean | undefined;
  AddAllocationResourceTags?: RequestIpamResourceTag[] | undefined;
  RemoveAllocationResourceTags?: RequestIpamResourceTag[] | undefined;
}
export interface ModifyIpamPoolResult {
  IpamPool?: IpamPool | undefined;
}
export interface ModifyIpamResourceCidrRequest {
  DryRun?: boolean | undefined;
  ResourceId: string | undefined;
  ResourceCidr: string | undefined;
  ResourceRegion: string | undefined;
  CurrentIpamScopeId: string | undefined;
  DestinationIpamScopeId?: string | undefined;
  Monitored: boolean | undefined;
}
export interface ModifyIpamResourceCidrResult {
  IpamResourceCidr?: IpamResourceCidr | undefined;
}
export interface RemoveIpamOrganizationalUnitExclusion {
  OrganizationsEntityPath?: string | undefined;
}
export interface ModifyIpamResourceDiscoveryRequest {
  DryRun?: boolean | undefined;
  IpamResourceDiscoveryId: string | undefined;
  Description?: string | undefined;
  AddOperatingRegions?: AddIpamOperatingRegion[] | undefined;
  RemoveOperatingRegions?: RemoveIpamOperatingRegion[] | undefined;
  AddOrganizationalUnitExclusions?:
    | AddIpamOrganizationalUnitExclusion[]
    | undefined;
  RemoveOrganizationalUnitExclusions?:
    | RemoveIpamOrganizationalUnitExclusion[]
    | undefined;
}
export interface ModifyIpamResourceDiscoveryResult {
  IpamResourceDiscovery?: IpamResourceDiscovery | undefined;
}
export interface ModifyIpamScopeRequest {
  DryRun?: boolean | undefined;
  IpamScopeId: string | undefined;
  Description?: string | undefined;
}
export interface ModifyIpamScopeResult {
  IpamScope?: IpamScope | undefined;
}
export interface ModifyLaunchTemplateRequest {
  DryRun?: boolean | undefined;
  ClientToken?: string | undefined;
  LaunchTemplateId?: string | undefined;
  LaunchTemplateName?: string | undefined;
  DefaultVersion?: string | undefined;
}
export interface ModifyLaunchTemplateResult {
  LaunchTemplate?: LaunchTemplate | undefined;
}
export interface ModifyLocalGatewayRouteRequest {
  DestinationCidrBlock?: string | undefined;
  LocalGatewayRouteTableId: string | undefined;
  LocalGatewayVirtualInterfaceGroupId?: string | undefined;
  NetworkInterfaceId?: string | undefined;
  DryRun?: boolean | undefined;
  DestinationPrefixListId?: string | undefined;
}
export interface ModifyLocalGatewayRouteResult {
  Route?: LocalGatewayRoute | undefined;
}
export interface RemovePrefixListEntry {
  Cidr: string | undefined;
}
export interface ModifyManagedPrefixListRequest {
  DryRun?: boolean | undefined;
  PrefixListId: string | undefined;
  CurrentVersion?: number | undefined;
  PrefixListName?: string | undefined;
  AddEntries?: AddPrefixListEntry[] | undefined;
  RemoveEntries?: RemovePrefixListEntry[] | undefined;
  MaxEntries?: number | undefined;
}
export interface ModifyManagedPrefixListResult {
  PrefixList?: ManagedPrefixList | undefined;
}
export interface NetworkInterfaceAttachmentChanges {
  DefaultEnaQueueCount?: boolean | undefined;
  EnaQueueCount?: number | undefined;
  AttachmentId?: string | undefined;
  DeleteOnTermination?: boolean | undefined;
}
export interface ModifyNetworkInterfaceAttributeRequest {
  EnaSrdSpecification?: EnaSrdSpecification | undefined;
  EnablePrimaryIpv6?: boolean | undefined;
  ConnectionTrackingSpecification?:
    | ConnectionTrackingSpecificationRequest
    | undefined;
  AssociatePublicIpAddress?: boolean | undefined;
  AssociatedSubnetIds?: string[] | undefined;
  DryRun?: boolean | undefined;
  NetworkInterfaceId: string | undefined;
  Description?: AttributeValue | undefined;
  SourceDestCheck?: AttributeBooleanValue | undefined;
  Groups?: string[] | undefined;
  Attachment?: NetworkInterfaceAttachmentChanges | undefined;
}
export interface ModifyPrivateDnsNameOptionsRequest {
  DryRun?: boolean | undefined;
  InstanceId: string | undefined;
  PrivateDnsHostnameType?: HostnameType | undefined;
  EnableResourceNameDnsARecord?: boolean | undefined;
  EnableResourceNameDnsAAAARecord?: boolean | undefined;
}
export interface ModifyPrivateDnsNameOptionsResult {
  Return?: boolean | undefined;
}
export declare const PublicIpDnsOption: {
  readonly public_dual_stack_dns_name: "public-dual-stack-dns-name";
  readonly public_ipv4_dns_name: "public-ipv4-dns-name";
  readonly public_ipv6_dns_name: "public-ipv6-dns-name";
};
export type PublicIpDnsOption =
  (typeof PublicIpDnsOption)[keyof typeof PublicIpDnsOption];
export interface ModifyPublicIpDnsNameOptionsRequest {
  NetworkInterfaceId: string | undefined;
  HostnameType: PublicIpDnsOption | undefined;
  DryRun?: boolean | undefined;
}
export interface ModifyPublicIpDnsNameOptionsResult {
  Successful?: boolean | undefined;
}
export interface ModifyReservedInstancesRequest {
  ReservedInstancesIds: string[] | undefined;
  ClientToken?: string | undefined;
  TargetConfigurations: ReservedInstancesConfiguration[] | undefined;
}
export interface ModifyReservedInstancesResult {
  ReservedInstancesModificationId?: string | undefined;
}
export interface ModifyRouteServerRequest {
  RouteServerId: string | undefined;
  PersistRoutes?: RouteServerPersistRoutesAction | undefined;
  PersistRoutesDuration?: number | undefined;
  SnsNotificationsEnabled?: boolean | undefined;
  DryRun?: boolean | undefined;
}
export interface ModifyRouteServerResult {
  RouteServer?: RouteServer | undefined;
}
export interface SecurityGroupRuleRequest {
  IpProtocol?: string | undefined;
  FromPort?: number | undefined;
  ToPort?: number | undefined;
  CidrIpv4?: string | undefined;
  CidrIpv6?: string | undefined;
  PrefixListId?: string | undefined;
  ReferencedGroupId?: string | undefined;
  Description?: string | undefined;
}
export interface SecurityGroupRuleUpdate {
  SecurityGroupRuleId: string | undefined;
  SecurityGroupRule?: SecurityGroupRuleRequest | undefined;
}
export interface ModifySecurityGroupRulesRequest {
  GroupId: string | undefined;
  SecurityGroupRules: SecurityGroupRuleUpdate[] | undefined;
  DryRun?: boolean | undefined;
}
export interface ModifySecurityGroupRulesResult {
  Return?: boolean | undefined;
}
export interface CreateVolumePermissionModifications {
  Add?: CreateVolumePermission[] | undefined;
  Remove?: CreateVolumePermission[] | undefined;
}
export interface ModifySnapshotAttributeRequest {
  Attribute?: SnapshotAttributeName | undefined;
  CreateVolumePermission?: CreateVolumePermissionModifications | undefined;
  GroupNames?: string[] | undefined;
  OperationType?: OperationType | undefined;
  SnapshotId: string | undefined;
  UserIds?: string[] | undefined;
  DryRun?: boolean | undefined;
}
export declare const TargetStorageTier: {
  readonly archive: "archive";
};
export type TargetStorageTier =
  (typeof TargetStorageTier)[keyof typeof TargetStorageTier];
export interface ModifySnapshotTierRequest {
  SnapshotId: string | undefined;
  StorageTier?: TargetStorageTier | undefined;
  DryRun?: boolean | undefined;
}
export interface ModifySnapshotTierResult {
  SnapshotId?: string | undefined;
  TieringStartTime?: Date | undefined;
}
export interface ModifySpotFleetRequestRequest {
  LaunchTemplateConfigs?: LaunchTemplateConfig[] | undefined;
  OnDemandTargetCapacity?: number | undefined;
  Context?: string | undefined;
  SpotFleetRequestId: string | undefined;
  TargetCapacity?: number | undefined;
  ExcessCapacityTerminationPolicy?: ExcessCapacityTerminationPolicy | undefined;
}
export interface ModifySpotFleetRequestResponse {
  Return?: boolean | undefined;
}
export interface ModifySubnetAttributeRequest {
  AssignIpv6AddressOnCreation?: AttributeBooleanValue | undefined;
  MapPublicIpOnLaunch?: AttributeBooleanValue | undefined;
  SubnetId: string | undefined;
  MapCustomerOwnedIpOnLaunch?: AttributeBooleanValue | undefined;
  CustomerOwnedIpv4Pool?: string | undefined;
  EnableDns64?: AttributeBooleanValue | undefined;
  PrivateDnsHostnameTypeOnLaunch?: HostnameType | undefined;
  EnableResourceNameDnsARecordOnLaunch?: AttributeBooleanValue | undefined;
  EnableResourceNameDnsAAAARecordOnLaunch?: AttributeBooleanValue | undefined;
  EnableLniAtDeviceIndex?: number | undefined;
  DisableLniAtDeviceIndex?: AttributeBooleanValue | undefined;
}
export interface ModifyTrafficMirrorFilterNetworkServicesRequest {
  TrafficMirrorFilterId: string | undefined;
  AddNetworkServices?: TrafficMirrorNetworkService[] | undefined;
  RemoveNetworkServices?: TrafficMirrorNetworkService[] | undefined;
  DryRun?: boolean | undefined;
}
export interface ModifyTrafficMirrorFilterNetworkServicesResult {
  TrafficMirrorFilter?: TrafficMirrorFilter | undefined;
}
export declare const TrafficMirrorFilterRuleField: {
  readonly description: "description";
  readonly destination_port_range: "destination-port-range";
  readonly protocol: "protocol";
  readonly source_port_range: "source-port-range";
};
export type TrafficMirrorFilterRuleField =
  (typeof TrafficMirrorFilterRuleField)[keyof typeof TrafficMirrorFilterRuleField];
export interface ModifyTrafficMirrorFilterRuleRequest {
  TrafficMirrorFilterRuleId: string | undefined;
  TrafficDirection?: TrafficDirection | undefined;
  RuleNumber?: number | undefined;
  RuleAction?: TrafficMirrorRuleAction | undefined;
  DestinationPortRange?: TrafficMirrorPortRangeRequest | undefined;
  SourcePortRange?: TrafficMirrorPortRangeRequest | undefined;
  Protocol?: number | undefined;
  DestinationCidrBlock?: string | undefined;
  SourceCidrBlock?: string | undefined;
  Description?: string | undefined;
  RemoveFields?: TrafficMirrorFilterRuleField[] | undefined;
  DryRun?: boolean | undefined;
}
export interface ModifyTrafficMirrorFilterRuleResult {
  TrafficMirrorFilterRule?: TrafficMirrorFilterRule | undefined;
}
export declare const TrafficMirrorSessionField: {
  readonly description: "description";
  readonly packet_length: "packet-length";
  readonly virtual_network_id: "virtual-network-id";
};
export type TrafficMirrorSessionField =
  (typeof TrafficMirrorSessionField)[keyof typeof TrafficMirrorSessionField];
export interface ModifyTrafficMirrorSessionRequest {
  TrafficMirrorSessionId: string | undefined;
  TrafficMirrorTargetId?: string | undefined;
  TrafficMirrorFilterId?: string | undefined;
  PacketLength?: number | undefined;
  SessionNumber?: number | undefined;
  VirtualNetworkId?: number | undefined;
  Description?: string | undefined;
  RemoveFields?: TrafficMirrorSessionField[] | undefined;
  DryRun?: boolean | undefined;
}
export interface ModifyTrafficMirrorSessionResult {
  TrafficMirrorSession?: TrafficMirrorSession | undefined;
}
export interface ModifyTransitGatewayOptions {
  AddTransitGatewayCidrBlocks?: string[] | undefined;
  RemoveTransitGatewayCidrBlocks?: string[] | undefined;
  VpnEcmpSupport?: VpnEcmpSupportValue | undefined;
  DnsSupport?: DnsSupportValue | undefined;
  SecurityGroupReferencingSupport?:
    | SecurityGroupReferencingSupportValue
    | undefined;
  AutoAcceptSharedAttachments?: AutoAcceptSharedAttachmentsValue | undefined;
  DefaultRouteTableAssociation?: DefaultRouteTableAssociationValue | undefined;
  AssociationDefaultRouteTableId?: string | undefined;
  DefaultRouteTablePropagation?: DefaultRouteTablePropagationValue | undefined;
  PropagationDefaultRouteTableId?: string | undefined;
  AmazonSideAsn?: number | undefined;
}
export interface ModifyTransitGatewayRequest {
  TransitGatewayId: string | undefined;
  Description?: string | undefined;
  Options?: ModifyTransitGatewayOptions | undefined;
  DryRun?: boolean | undefined;
}
export interface ModifyTransitGatewayResult {
  TransitGateway?: TransitGateway | undefined;
}
export interface ModifyTransitGatewayPrefixListReferenceRequest {
  TransitGatewayRouteTableId: string | undefined;
  PrefixListId: string | undefined;
  TransitGatewayAttachmentId?: string | undefined;
  Blackhole?: boolean | undefined;
  DryRun?: boolean | undefined;
}
export interface ModifyTransitGatewayPrefixListReferenceResult {
  TransitGatewayPrefixListReference?:
    | TransitGatewayPrefixListReference
    | undefined;
}
export interface ModifyTransitGatewayVpcAttachmentRequestOptions {
  DnsSupport?: DnsSupportValue | undefined;
  SecurityGroupReferencingSupport?:
    | SecurityGroupReferencingSupportValue
    | undefined;
  Ipv6Support?: Ipv6SupportValue | undefined;
  ApplianceModeSupport?: ApplianceModeSupportValue | undefined;
}
export interface ModifyTransitGatewayVpcAttachmentRequest {
  TransitGatewayAttachmentId: string | undefined;
  AddSubnetIds?: string[] | undefined;
  RemoveSubnetIds?: string[] | undefined;
  Options?: ModifyTransitGatewayVpcAttachmentRequestOptions | undefined;
  DryRun?: boolean | undefined;
}
export interface ModifyTransitGatewayVpcAttachmentResult {
  TransitGatewayVpcAttachment?: TransitGatewayVpcAttachment | undefined;
}
export interface ModifyVerifiedAccessEndpointPortRange {
  FromPort?: number | undefined;
  ToPort?: number | undefined;
}
export interface ModifyVerifiedAccessEndpointCidrOptions {
  PortRanges?: ModifyVerifiedAccessEndpointPortRange[] | undefined;
}
export interface ModifyVerifiedAccessEndpointLoadBalancerOptions {
  SubnetIds?: string[] | undefined;
  Protocol?: VerifiedAccessEndpointProtocol | undefined;
  Port?: number | undefined;
  PortRanges?: ModifyVerifiedAccessEndpointPortRange[] | undefined;
}
export interface ModifyVerifiedAccessEndpointEniOptions {
  Protocol?: VerifiedAccessEndpointProtocol | undefined;
  Port?: number | undefined;
  PortRanges?: ModifyVerifiedAccessEndpointPortRange[] | undefined;
}
export interface ModifyVerifiedAccessEndpointRdsOptions {
  SubnetIds?: string[] | undefined;
  Port?: number | undefined;
  RdsEndpoint?: string | undefined;
}
export interface ModifyVerifiedAccessEndpointRequest {
  VerifiedAccessEndpointId: string | undefined;
  VerifiedAccessGroupId?: string | undefined;
  LoadBalancerOptions?:
    | ModifyVerifiedAccessEndpointLoadBalancerOptions
    | undefined;
  NetworkInterfaceOptions?: ModifyVerifiedAccessEndpointEniOptions | undefined;
  Description?: string | undefined;
  ClientToken?: string | undefined;
  DryRun?: boolean | undefined;
  RdsOptions?: ModifyVerifiedAccessEndpointRdsOptions | undefined;
  CidrOptions?: ModifyVerifiedAccessEndpointCidrOptions | undefined;
}
export interface ModifyVerifiedAccessEndpointResult {
  VerifiedAccessEndpoint?: VerifiedAccessEndpoint | undefined;
}
export interface ModifyVerifiedAccessEndpointPolicyRequest {
  VerifiedAccessEndpointId: string | undefined;
  PolicyEnabled?: boolean | undefined;
  PolicyDocument?: string | undefined;
  ClientToken?: string | undefined;
  DryRun?: boolean | undefined;
  SseSpecification?: VerifiedAccessSseSpecificationRequest | undefined;
}
export interface ModifyVerifiedAccessEndpointPolicyResult {
  PolicyEnabled?: boolean | undefined;
  PolicyDocument?: string | undefined;
  SseSpecification?: VerifiedAccessSseSpecificationResponse | undefined;
}
export interface ModifyVerifiedAccessGroupRequest {
  VerifiedAccessGroupId: string | undefined;
  VerifiedAccessInstanceId?: string | undefined;
  Description?: string | undefined;
  ClientToken?: string | undefined;
  DryRun?: boolean | undefined;
}
export interface ModifyVerifiedAccessGroupResult {
  VerifiedAccessGroup?: VerifiedAccessGroup | undefined;
}
export interface ModifyVerifiedAccessGroupPolicyRequest {
  VerifiedAccessGroupId: string | undefined;
  PolicyEnabled?: boolean | undefined;
  PolicyDocument?: string | undefined;
  ClientToken?: string | undefined;
  DryRun?: boolean | undefined;
  SseSpecification?: VerifiedAccessSseSpecificationRequest | undefined;
}
export interface ModifyVerifiedAccessGroupPolicyResult {
  PolicyEnabled?: boolean | undefined;
  PolicyDocument?: string | undefined;
  SseSpecification?: VerifiedAccessSseSpecificationResponse | undefined;
}
export interface ModifyVerifiedAccessInstanceRequest {
  VerifiedAccessInstanceId: string | undefined;
  Description?: string | undefined;
  DryRun?: boolean | undefined;
  ClientToken?: string | undefined;
  CidrEndpointsCustomSubDomain?: string | undefined;
}
export interface ModifyVerifiedAccessInstanceResult {
  VerifiedAccessInstance?: VerifiedAccessInstance | undefined;
}
export interface VerifiedAccessLogCloudWatchLogsDestinationOptions {
  Enabled: boolean | undefined;
  LogGroup?: string | undefined;
}
export interface VerifiedAccessLogKinesisDataFirehoseDestinationOptions {
  Enabled: boolean | undefined;
  DeliveryStream?: string | undefined;
}
export interface VerifiedAccessLogS3DestinationOptions {
  Enabled: boolean | undefined;
  BucketName?: string | undefined;
  Prefix?: string | undefined;
  BucketOwner?: string | undefined;
}
export interface VerifiedAccessLogOptions {
  S3?: VerifiedAccessLogS3DestinationOptions | undefined;
  CloudWatchLogs?:
    | VerifiedAccessLogCloudWatchLogsDestinationOptions
    | undefined;
  KinesisDataFirehose?:
    | VerifiedAccessLogKinesisDataFirehoseDestinationOptions
    | undefined;
  LogVersion?: string | undefined;
  IncludeTrustContext?: boolean | undefined;
}
export interface ModifyVerifiedAccessInstanceLoggingConfigurationRequest {
  VerifiedAccessInstanceId: string | undefined;
  AccessLogs: VerifiedAccessLogOptions | undefined;
  DryRun?: boolean | undefined;
  ClientToken?: string | undefined;
}
export interface ModifyVerifiedAccessInstanceLoggingConfigurationResult {
  LoggingConfiguration?: VerifiedAccessInstanceLoggingConfiguration | undefined;
}
export interface ModifyVerifiedAccessTrustProviderDeviceOptions {
  PublicSigningKeyUrl?: string | undefined;
}
export interface ModifyVerifiedAccessNativeApplicationOidcOptions {
  PublicSigningKeyEndpoint?: string | undefined;
  Issuer?: string | undefined;
  AuthorizationEndpoint?: string | undefined;
  TokenEndpoint?: string | undefined;
  UserInfoEndpoint?: string | undefined;
  ClientId?: string | undefined;
  ClientSecret?: string | undefined;
  Scope?: string | undefined;
}
export interface ModifyVerifiedAccessTrustProviderOidcOptions {
  Issuer?: string | undefined;
  AuthorizationEndpoint?: string | undefined;
  TokenEndpoint?: string | undefined;
  UserInfoEndpoint?: string | undefined;
  ClientId?: string | undefined;
  ClientSecret?: string | undefined;
  Scope?: string | undefined;
}
export interface ModifyVerifiedAccessTrustProviderRequest {
  VerifiedAccessTrustProviderId: string | undefined;
  OidcOptions?: ModifyVerifiedAccessTrustProviderOidcOptions | undefined;
  DeviceOptions?: ModifyVerifiedAccessTrustProviderDeviceOptions | undefined;
  Description?: string | undefined;
  DryRun?: boolean | undefined;
  ClientToken?: string | undefined;
  SseSpecification?: VerifiedAccessSseSpecificationRequest | undefined;
  NativeApplicationOidcOptions?:
    | ModifyVerifiedAccessNativeApplicationOidcOptions
    | undefined;
}
export interface ModifyVerifiedAccessTrustProviderResult {
  VerifiedAccessTrustProvider?: VerifiedAccessTrustProvider | undefined;
}
export interface ModifyVolumeRequest {
  DryRun?: boolean | undefined;
  VolumeId: string | undefined;
  Size?: number | undefined;
  VolumeType?: VolumeType | undefined;
  Iops?: number | undefined;
  Throughput?: number | undefined;
  MultiAttachEnabled?: boolean | undefined;
}
export interface ModifyVolumeResult {
  VolumeModification?: VolumeModification | undefined;
}
export interface ModifyVolumeAttributeRequest {
  AutoEnableIO?: AttributeBooleanValue | undefined;
  VolumeId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface ModifyVpcAttributeRequest {
  EnableDnsHostnames?: AttributeBooleanValue | undefined;
  EnableDnsSupport?: AttributeBooleanValue | undefined;
  VpcId: string | undefined;
  EnableNetworkAddressUsageMetrics?: AttributeBooleanValue | undefined;
}
export interface ModifyVpcBlockPublicAccessExclusionRequest {
  DryRun?: boolean | undefined;
  ExclusionId: string | undefined;
  InternetGatewayExclusionMode: InternetGatewayExclusionMode | undefined;
}
export interface ModifyVpcBlockPublicAccessExclusionResult {
  VpcBlockPublicAccessExclusion?: VpcBlockPublicAccessExclusion | undefined;
}
export interface ModifyVpcBlockPublicAccessOptionsRequest {
  DryRun?: boolean | undefined;
  InternetGatewayBlockMode: InternetGatewayBlockMode | undefined;
}
export interface ModifyVpcBlockPublicAccessOptionsResult {
  VpcBlockPublicAccessOptions?: VpcBlockPublicAccessOptions | undefined;
}
export interface ModifyVpcEndpointRequest {
  DryRun?: boolean | undefined;
  VpcEndpointId: string | undefined;
  ResetPolicy?: boolean | undefined;
  PolicyDocument?: string | undefined;
  AddRouteTableIds?: string[] | undefined;
  RemoveRouteTableIds?: string[] | undefined;
  AddSubnetIds?: string[] | undefined;
  RemoveSubnetIds?: string[] | undefined;
  AddSecurityGroupIds?: string[] | undefined;
  RemoveSecurityGroupIds?: string[] | undefined;
  IpAddressType?: IpAddressType | undefined;
  DnsOptions?: DnsOptionsSpecification | undefined;
  PrivateDnsEnabled?: boolean | undefined;
  SubnetConfigurations?: SubnetConfiguration[] | undefined;
}
export interface ModifyVpcEndpointResult {
  Return?: boolean | undefined;
}
export interface ModifyVpcEndpointConnectionNotificationRequest {
  DryRun?: boolean | undefined;
  ConnectionNotificationId: string | undefined;
  ConnectionNotificationArn?: string | undefined;
  ConnectionEvents?: string[] | undefined;
}
export interface ModifyVpcEndpointConnectionNotificationResult {
  ReturnValue?: boolean | undefined;
}
export interface ModifyVpcEndpointServiceConfigurationRequest {
  DryRun?: boolean | undefined;
  ServiceId: string | undefined;
  PrivateDnsName?: string | undefined;
  RemovePrivateDnsName?: boolean | undefined;
  AcceptanceRequired?: boolean | undefined;
  AddNetworkLoadBalancerArns?: string[] | undefined;
  RemoveNetworkLoadBalancerArns?: string[] | undefined;
  AddGatewayLoadBalancerArns?: string[] | undefined;
  RemoveGatewayLoadBalancerArns?: string[] | undefined;
  AddSupportedIpAddressTypes?: string[] | undefined;
  RemoveSupportedIpAddressTypes?: string[] | undefined;
  AddSupportedRegions?: string[] | undefined;
  RemoveSupportedRegions?: string[] | undefined;
}
export interface ModifyVpcEndpointServiceConfigurationResult {
  Return?: boolean | undefined;
}
export interface ModifyVpcEndpointServicePayerResponsibilityRequest {
  DryRun?: boolean | undefined;
  ServiceId: string | undefined;
  PayerResponsibility: PayerResponsibility | undefined;
}
export interface ModifyVpcEndpointServicePayerResponsibilityResult {
  ReturnValue?: boolean | undefined;
}
export interface ModifyVpcEndpointServicePermissionsRequest {
  DryRun?: boolean | undefined;
  ServiceId: string | undefined;
  AddAllowedPrincipals?: string[] | undefined;
  RemoveAllowedPrincipals?: string[] | undefined;
}
export interface ModifyVpcEndpointServicePermissionsResult {
  AddedPrincipals?: AddedPrincipal[] | undefined;
  ReturnValue?: boolean | undefined;
}
export interface PeeringConnectionOptionsRequest {
  AllowDnsResolutionFromRemoteVpc?: boolean | undefined;
  AllowEgressFromLocalClassicLinkToRemoteVpc?: boolean | undefined;
  AllowEgressFromLocalVpcToRemoteClassicLink?: boolean | undefined;
}
export interface ModifyVpcPeeringConnectionOptionsRequest {
  AccepterPeeringConnectionOptions?:
    | PeeringConnectionOptionsRequest
    | undefined;
  DryRun?: boolean | undefined;
  RequesterPeeringConnectionOptions?:
    | PeeringConnectionOptionsRequest
    | undefined;
  VpcPeeringConnectionId: string | undefined;
}
export interface PeeringConnectionOptions {
  AllowDnsResolutionFromRemoteVpc?: boolean | undefined;
  AllowEgressFromLocalClassicLinkToRemoteVpc?: boolean | undefined;
  AllowEgressFromLocalVpcToRemoteClassicLink?: boolean | undefined;
}
export interface ModifyVpcPeeringConnectionOptionsResult {
  AccepterPeeringConnectionOptions?: PeeringConnectionOptions | undefined;
  RequesterPeeringConnectionOptions?: PeeringConnectionOptions | undefined;
}
export declare const VpcTenancy: {
  readonly default: "default";
};
export type VpcTenancy = (typeof VpcTenancy)[keyof typeof VpcTenancy];
export interface ModifyVpcTenancyRequest {
  VpcId: string | undefined;
  InstanceTenancy: VpcTenancy | undefined;
  DryRun?: boolean | undefined;
}
export interface ModifyVpcTenancyResult {
  ReturnValue?: boolean | undefined;
}
export interface ModifyVpnConnectionRequest {
  VpnConnectionId: string | undefined;
  TransitGatewayId?: string | undefined;
  CustomerGatewayId?: string | undefined;
  VpnGatewayId?: string | undefined;
  DryRun?: boolean | undefined;
}
export interface ModifyVpnConnectionResult {
  VpnConnection?: VpnConnection | undefined;
}
export interface ModifyVpnConnectionOptionsRequest {
  VpnConnectionId: string | undefined;
  LocalIpv4NetworkCidr?: string | undefined;
  RemoteIpv4NetworkCidr?: string | undefined;
  LocalIpv6NetworkCidr?: string | undefined;
  RemoteIpv6NetworkCidr?: string | undefined;
  DryRun?: boolean | undefined;
}
export interface ModifyVpnConnectionOptionsResult {
  VpnConnection?: VpnConnection | undefined;
}
export interface ModifyVpnTunnelCertificateRequest {
  VpnConnectionId: string | undefined;
  VpnTunnelOutsideIpAddress: string | undefined;
  DryRun?: boolean | undefined;
}
export interface ModifyVpnTunnelCertificateResult {
  VpnConnection?: VpnConnection | undefined;
}
export interface ModifyVpnTunnelOptionsSpecification {
  TunnelInsideCidr?: string | undefined;
  TunnelInsideIpv6Cidr?: string | undefined;
  PreSharedKey?: string | undefined;
  Phase1LifetimeSeconds?: number | undefined;
  Phase2LifetimeSeconds?: number | undefined;
  RekeyMarginTimeSeconds?: number | undefined;
  RekeyFuzzPercentage?: number | undefined;
  ReplayWindowSize?: number | undefined;
  DPDTimeoutSeconds?: number | undefined;
  DPDTimeoutAction?: string | undefined;
  Phase1EncryptionAlgorithms?:
    | Phase1EncryptionAlgorithmsRequestListValue[]
    | undefined;
  Phase2EncryptionAlgorithms?:
    | Phase2EncryptionAlgorithmsRequestListValue[]
    | undefined;
  Phase1IntegrityAlgorithms?:
    | Phase1IntegrityAlgorithmsRequestListValue[]
    | undefined;
  Phase2IntegrityAlgorithms?:
    | Phase2IntegrityAlgorithmsRequestListValue[]
    | undefined;
  Phase1DHGroupNumbers?: Phase1DHGroupNumbersRequestListValue[] | undefined;
  Phase2DHGroupNumbers?: Phase2DHGroupNumbersRequestListValue[] | undefined;
  IKEVersions?: IKEVersionsRequestListValue[] | undefined;
  StartupAction?: string | undefined;
  LogOptions?: VpnTunnelLogOptionsSpecification | undefined;
  EnableTunnelLifecycleControl?: boolean | undefined;
}
export interface ModifyVpnTunnelOptionsRequest {
  VpnConnectionId: string | undefined;
  VpnTunnelOutsideIpAddress: string | undefined;
  TunnelOptions: ModifyVpnTunnelOptionsSpecification | undefined;
  DryRun?: boolean | undefined;
  SkipTunnelReplacement?: boolean | undefined;
  PreSharedKeyStorage?: string | undefined;
}
export interface ModifyVpnTunnelOptionsResult {
  VpnConnection?: VpnConnection | undefined;
}
export interface MonitorInstancesRequest {
  InstanceIds: string[] | undefined;
  DryRun?: boolean | undefined;
}
export interface InstanceMonitoring {
  InstanceId?: string | undefined;
  Monitoring?: Monitoring | undefined;
}
export interface MonitorInstancesResult {
  InstanceMonitorings?: InstanceMonitoring[] | undefined;
}
export interface MoveAddressToVpcRequest {
  DryRun?: boolean | undefined;
  PublicIp: string | undefined;
}
export declare const Status: {
  readonly inClassic: "InClassic";
  readonly inVpc: "InVpc";
  readonly moveInProgress: "MoveInProgress";
};
export type Status = (typeof Status)[keyof typeof Status];
export interface MoveAddressToVpcResult {
  AllocationId?: string | undefined;
  Status?: Status | undefined;
}
export interface MoveByoipCidrToIpamRequest {
  DryRun?: boolean | undefined;
  Cidr: string | undefined;
  IpamPoolId: string | undefined;
  IpamPoolOwner: string | undefined;
}
export interface MoveByoipCidrToIpamResult {
  ByoipCidr?: ByoipCidr | undefined;
}
export interface MoveCapacityReservationInstancesRequest {
  DryRun?: boolean | undefined;
  ClientToken?: string | undefined;
  SourceCapacityReservationId: string | undefined;
  DestinationCapacityReservationId: string | undefined;
  InstanceCount: number | undefined;
}
export interface MoveCapacityReservationInstancesResult {
  SourceCapacityReservation?: CapacityReservation | undefined;
  DestinationCapacityReservation?: CapacityReservation | undefined;
  InstanceCount?: number | undefined;
}
export interface CidrAuthorizationContext {
  Message: string | undefined;
  Signature: string | undefined;
}
export interface ProvisionByoipCidrRequest {
  Cidr: string | undefined;
  CidrAuthorizationContext?: CidrAuthorizationContext | undefined;
  PubliclyAdvertisable?: boolean | undefined;
  Description?: string | undefined;
  DryRun?: boolean | undefined;
  PoolTagSpecifications?: TagSpecification[] | undefined;
  MultiRegion?: boolean | undefined;
  NetworkBorderGroup?: string | undefined;
}
export interface ProvisionByoipCidrResult {
  ByoipCidr?: ByoipCidr | undefined;
}
export interface AsnAuthorizationContext {
  Message: string | undefined;
  Signature: string | undefined;
}
export interface ProvisionIpamByoasnRequest {
  DryRun?: boolean | undefined;
  IpamId: string | undefined;
  Asn: string | undefined;
  AsnAuthorizationContext: AsnAuthorizationContext | undefined;
}
export interface ProvisionIpamByoasnResult {
  Byoasn?: Byoasn | undefined;
}
export declare const GetPasswordDataResultFilterSensitiveLog: (
  obj: GetPasswordDataResult
) => any;
export declare const GetVpnConnectionDeviceSampleConfigurationResultFilterSensitiveLog: (
  obj: GetVpnConnectionDeviceSampleConfigurationResult
) => any;
export declare const ImageDiskContainerFilterSensitiveLog: (
  obj: ImageDiskContainer
) => any;
export declare const ImportImageRequestFilterSensitiveLog: (
  obj: ImportImageRequest
) => any;
export declare const ImportImageResultFilterSensitiveLog: (
  obj: ImportImageResult
) => any;
export declare const DiskImageDetailFilterSensitiveLog: (
  obj: DiskImageDetail
) => any;
export declare const DiskImageFilterSensitiveLog: (obj: DiskImage) => any;
export declare const UserDataFilterSensitiveLog: (obj: UserData) => any;
export declare const ImportInstanceLaunchSpecificationFilterSensitiveLog: (
  obj: ImportInstanceLaunchSpecification
) => any;
export declare const ImportInstanceRequestFilterSensitiveLog: (
  obj: ImportInstanceRequest
) => any;
export declare const ImportInstanceResultFilterSensitiveLog: (
  obj: ImportInstanceResult
) => any;
export declare const SnapshotDiskContainerFilterSensitiveLog: (
  obj: SnapshotDiskContainer
) => any;
export declare const ImportSnapshotRequestFilterSensitiveLog: (
  obj: ImportSnapshotRequest
) => any;
export declare const ImportSnapshotResultFilterSensitiveLog: (
  obj: ImportSnapshotResult
) => any;
export declare const ImportVolumeRequestFilterSensitiveLog: (
  obj: ImportVolumeRequest
) => any;
export declare const ImportVolumeResultFilterSensitiveLog: (
  obj: ImportVolumeResult
) => any;
export declare const ModifyVerifiedAccessNativeApplicationOidcOptionsFilterSensitiveLog: (
  obj: ModifyVerifiedAccessNativeApplicationOidcOptions
) => any;
export declare const ModifyVerifiedAccessTrustProviderOidcOptionsFilterSensitiveLog: (
  obj: ModifyVerifiedAccessTrustProviderOidcOptions
) => any;
export declare const ModifyVerifiedAccessTrustProviderRequestFilterSensitiveLog: (
  obj: ModifyVerifiedAccessTrustProviderRequest
) => any;
export declare const ModifyVerifiedAccessTrustProviderResultFilterSensitiveLog: (
  obj: ModifyVerifiedAccessTrustProviderResult
) => any;
export declare const ModifyVpnConnectionResultFilterSensitiveLog: (
  obj: ModifyVpnConnectionResult
) => any;
export declare const ModifyVpnConnectionOptionsResultFilterSensitiveLog: (
  obj: ModifyVpnConnectionOptionsResult
) => any;
export declare const ModifyVpnTunnelCertificateResultFilterSensitiveLog: (
  obj: ModifyVpnTunnelCertificateResult
) => any;
export declare const ModifyVpnTunnelOptionsSpecificationFilterSensitiveLog: (
  obj: ModifyVpnTunnelOptionsSpecification
) => any;
export declare const ModifyVpnTunnelOptionsRequestFilterSensitiveLog: (
  obj: ModifyVpnTunnelOptionsRequest
) => any;
export declare const ModifyVpnTunnelOptionsResultFilterSensitiveLog: (
  obj: ModifyVpnTunnelOptionsResult
) => any;
