"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/index.ts
var index_exports = {};
__export(index_exports, {
  AcceleratorManufacturer: () => AcceleratorManufacturer,
  AcceleratorName: () => AcceleratorName,
  AcceleratorType: () => AcceleratorType,
  AccessDeniedException: () => AccessDeniedException,
  AgentUpdateStatus: () => AgentUpdateStatus,
  ApplicationProtocol: () => ApplicationProtocol,
  AssignPublicIp: () => AssignPublicIp,
  AttributeLimitExceededException: () => AttributeLimitExceededException,
  AvailabilityZoneRebalancing: () => AvailabilityZoneRebalancing,
  BareMetal: () => BareMetal,
  BlockedException: () => BlockedException,
  BurstablePerformance: () => BurstablePerformance,
  CPUArchitecture: () => CPUArchitecture,
  CapacityProviderField: () => CapacityProviderField,
  CapacityProviderStatus: () => CapacityProviderStatus,
  CapacityProviderType: () => CapacityProviderType,
  CapacityProviderUpdateStatus: () => CapacityProviderUpdateStatus,
  ClientException: () => ClientException,
  ClusterContainsCapacityProviderException: () => ClusterContainsCapacityProviderException,
  ClusterContainsContainerInstancesException: () => ClusterContainsContainerInstancesException,
  ClusterContainsServicesException: () => ClusterContainsServicesException,
  ClusterContainsTasksException: () => ClusterContainsTasksException,
  ClusterField: () => ClusterField,
  ClusterNotFoundException: () => ClusterNotFoundException,
  ClusterSettingName: () => ClusterSettingName,
  Compatibility: () => Compatibility,
  ConflictException: () => ConflictException,
  Connectivity: () => Connectivity,
  ContainerCondition: () => ContainerCondition,
  ContainerInstanceField: () => ContainerInstanceField,
  ContainerInstanceStatus: () => ContainerInstanceStatus,
  CpuManufacturer: () => CpuManufacturer,
  CreateCapacityProviderCommand: () => CreateCapacityProviderCommand,
  CreateClusterCommand: () => CreateClusterCommand,
  CreateServiceCommand: () => CreateServiceCommand,
  CreateTaskSetCommand: () => CreateTaskSetCommand,
  DeleteAccountSettingCommand: () => DeleteAccountSettingCommand,
  DeleteAttributesCommand: () => DeleteAttributesCommand,
  DeleteCapacityProviderCommand: () => DeleteCapacityProviderCommand,
  DeleteClusterCommand: () => DeleteClusterCommand,
  DeleteServiceCommand: () => DeleteServiceCommand,
  DeleteTaskDefinitionsCommand: () => DeleteTaskDefinitionsCommand,
  DeleteTaskSetCommand: () => DeleteTaskSetCommand,
  DeploymentControllerType: () => DeploymentControllerType,
  DeploymentLifecycleHookStage: () => DeploymentLifecycleHookStage,
  DeploymentRolloutState: () => DeploymentRolloutState,
  DeploymentStrategy: () => DeploymentStrategy,
  DeregisterContainerInstanceCommand: () => DeregisterContainerInstanceCommand,
  DeregisterTaskDefinitionCommand: () => DeregisterTaskDefinitionCommand,
  DescribeCapacityProvidersCommand: () => DescribeCapacityProvidersCommand,
  DescribeClustersCommand: () => DescribeClustersCommand,
  DescribeContainerInstancesCommand: () => DescribeContainerInstancesCommand,
  DescribeServiceDeploymentsCommand: () => DescribeServiceDeploymentsCommand,
  DescribeServiceRevisionsCommand: () => DescribeServiceRevisionsCommand,
  DescribeServicesCommand: () => DescribeServicesCommand,
  DescribeTaskDefinitionCommand: () => DescribeTaskDefinitionCommand,
  DescribeTaskSetsCommand: () => DescribeTaskSetsCommand,
  DescribeTasksCommand: () => DescribeTasksCommand,
  DesiredStatus: () => DesiredStatus,
  DeviceCgroupPermission: () => DeviceCgroupPermission,
  DiscoverPollEndpointCommand: () => DiscoverPollEndpointCommand,
  EBSResourceType: () => EBSResourceType,
  ECS: () => ECS,
  ECSClient: () => ECSClient,
  ECSServiceException: () => ECSServiceException,
  EFSAuthorizationConfigIAM: () => EFSAuthorizationConfigIAM,
  EFSTransitEncryption: () => EFSTransitEncryption,
  EnvironmentFileType: () => EnvironmentFileType,
  ExecuteCommandCommand: () => ExecuteCommandCommand,
  ExecuteCommandLogging: () => ExecuteCommandLogging,
  ExecuteCommandResponseFilterSensitiveLog: () => ExecuteCommandResponseFilterSensitiveLog,
  FirelensConfigurationType: () => FirelensConfigurationType,
  GetTaskProtectionCommand: () => GetTaskProtectionCommand,
  HealthStatus: () => HealthStatus,
  InstanceGeneration: () => InstanceGeneration,
  InstanceHealthCheckState: () => InstanceHealthCheckState,
  InstanceHealthCheckType: () => InstanceHealthCheckType,
  InvalidParameterException: () => InvalidParameterException,
  IpcMode: () => IpcMode,
  LaunchType: () => LaunchType,
  LimitExceededException: () => LimitExceededException,
  ListAccountSettingsCommand: () => ListAccountSettingsCommand,
  ListAttributesCommand: () => ListAttributesCommand,
  ListClustersCommand: () => ListClustersCommand,
  ListContainerInstancesCommand: () => ListContainerInstancesCommand,
  ListServiceDeploymentsCommand: () => ListServiceDeploymentsCommand,
  ListServicesByNamespaceCommand: () => ListServicesByNamespaceCommand,
  ListServicesCommand: () => ListServicesCommand,
  ListTagsForResourceCommand: () => ListTagsForResourceCommand,
  ListTaskDefinitionFamiliesCommand: () => ListTaskDefinitionFamiliesCommand,
  ListTaskDefinitionsCommand: () => ListTaskDefinitionsCommand,
  ListTasksCommand: () => ListTasksCommand,
  LocalStorage: () => LocalStorage,
  LocalStorageType: () => LocalStorageType,
  LogDriver: () => LogDriver,
  ManagedAgentName: () => ManagedAgentName,
  ManagedDraining: () => ManagedDraining,
  ManagedInstancesMonitoringOptions: () => ManagedInstancesMonitoringOptions,
  ManagedScalingStatus: () => ManagedScalingStatus,
  ManagedTerminationProtection: () => ManagedTerminationProtection,
  MissingVersionException: () => MissingVersionException,
  NamespaceNotFoundException: () => NamespaceNotFoundException,
  NetworkMode: () => NetworkMode,
  NoUpdateAvailableException: () => NoUpdateAvailableException,
  OSFamily: () => OSFamily,
  PidMode: () => PidMode,
  PlacementConstraintType: () => PlacementConstraintType,
  PlacementStrategyType: () => PlacementStrategyType,
  PlatformDeviceType: () => PlatformDeviceType,
  PlatformTaskDefinitionIncompatibilityException: () => PlatformTaskDefinitionIncompatibilityException,
  PlatformUnknownException: () => PlatformUnknownException,
  PropagateMITags: () => PropagateMITags,
  PropagateTags: () => PropagateTags,
  ProxyConfigurationType: () => ProxyConfigurationType,
  PutAccountSettingCommand: () => PutAccountSettingCommand,
  PutAccountSettingDefaultCommand: () => PutAccountSettingDefaultCommand,
  PutAttributesCommand: () => PutAttributesCommand,
  PutClusterCapacityProvidersCommand: () => PutClusterCapacityProvidersCommand,
  RegisterContainerInstanceCommand: () => RegisterContainerInstanceCommand,
  RegisterTaskDefinitionCommand: () => RegisterTaskDefinitionCommand,
  ResourceInUseException: () => ResourceInUseException,
  ResourceNotFoundException: () => ResourceNotFoundException,
  ResourceType: () => ResourceType,
  RunTaskCommand: () => RunTaskCommand,
  ScaleUnit: () => ScaleUnit,
  SchedulingStrategy: () => SchedulingStrategy,
  Scope: () => Scope,
  ServerException: () => ServerException,
  ServiceDeploymentLifecycleStage: () => ServiceDeploymentLifecycleStage,
  ServiceDeploymentNotFoundException: () => ServiceDeploymentNotFoundException,
  ServiceDeploymentRollbackMonitorsStatus: () => ServiceDeploymentRollbackMonitorsStatus,
  ServiceDeploymentStatus: () => ServiceDeploymentStatus,
  ServiceField: () => ServiceField,
  ServiceNotActiveException: () => ServiceNotActiveException,
  ServiceNotFoundException: () => ServiceNotFoundException,
  SessionFilterSensitiveLog: () => SessionFilterSensitiveLog,
  SettingName: () => SettingName,
  SettingType: () => SettingType,
  SortOrder: () => SortOrder,
  StabilityStatus: () => StabilityStatus,
  StartTaskCommand: () => StartTaskCommand,
  StopServiceDeploymentCommand: () => StopServiceDeploymentCommand,
  StopServiceDeploymentStopType: () => StopServiceDeploymentStopType,
  StopTaskCommand: () => StopTaskCommand,
  SubmitAttachmentStateChangesCommand: () => SubmitAttachmentStateChangesCommand,
  SubmitContainerStateChangeCommand: () => SubmitContainerStateChangeCommand,
  SubmitTaskStateChangeCommand: () => SubmitTaskStateChangeCommand,
  TagResourceCommand: () => TagResourceCommand,
  TargetNotConnectedException: () => TargetNotConnectedException,
  TargetNotFoundException: () => TargetNotFoundException,
  TargetType: () => TargetType,
  TaskDefinitionFamilyStatus: () => TaskDefinitionFamilyStatus,
  TaskDefinitionField: () => TaskDefinitionField,
  TaskDefinitionPlacementConstraintType: () => TaskDefinitionPlacementConstraintType,
  TaskDefinitionStatus: () => TaskDefinitionStatus,
  TaskField: () => TaskField,
  TaskFilesystemType: () => TaskFilesystemType,
  TaskSetField: () => TaskSetField,
  TaskSetNotFoundException: () => TaskSetNotFoundException,
  TaskStopCode: () => TaskStopCode,
  TransportProtocol: () => TransportProtocol,
  UlimitName: () => UlimitName,
  UnsupportedFeatureException: () => UnsupportedFeatureException,
  UntagResourceCommand: () => UntagResourceCommand,
  UpdateCapacityProviderCommand: () => UpdateCapacityProviderCommand,
  UpdateClusterCommand: () => UpdateClusterCommand,
  UpdateClusterSettingsCommand: () => UpdateClusterSettingsCommand,
  UpdateContainerAgentCommand: () => UpdateContainerAgentCommand,
  UpdateContainerInstancesStateCommand: () => UpdateContainerInstancesStateCommand,
  UpdateInProgressException: () => UpdateInProgressException,
  UpdateServiceCommand: () => UpdateServiceCommand,
  UpdateServicePrimaryTaskSetCommand: () => UpdateServicePrimaryTaskSetCommand,
  UpdateTaskProtectionCommand: () => UpdateTaskProtectionCommand,
  UpdateTaskSetCommand: () => UpdateTaskSetCommand,
  VersionConsistency: () => VersionConsistency,
  __Client: () => import_smithy_client.Client,
  paginateListAccountSettings: () => paginateListAccountSettings,
  paginateListAttributes: () => paginateListAttributes,
  paginateListClusters: () => paginateListClusters,
  paginateListContainerInstances: () => paginateListContainerInstances,
  paginateListServices: () => paginateListServices,
  paginateListServicesByNamespace: () => paginateListServicesByNamespace,
  paginateListTaskDefinitionFamilies: () => paginateListTaskDefinitionFamilies,
  paginateListTaskDefinitions: () => paginateListTaskDefinitions,
  paginateListTasks: () => paginateListTasks,
  waitForServicesInactive: () => waitForServicesInactive,
  waitForServicesStable: () => waitForServicesStable,
  waitForTasksRunning: () => waitForTasksRunning,
  waitForTasksStopped: () => waitForTasksStopped,
  waitUntilServicesInactive: () => waitUntilServicesInactive,
  waitUntilServicesStable: () => waitUntilServicesStable,
  waitUntilTasksRunning: () => waitUntilTasksRunning,
  waitUntilTasksStopped: () => waitUntilTasksStopped
});
module.exports = __toCommonJS(index_exports);

// src/ECSClient.ts
var import_middleware_host_header = require("@aws-sdk/middleware-host-header");
var import_middleware_logger = require("@aws-sdk/middleware-logger");
var import_middleware_recursion_detection = require("@aws-sdk/middleware-recursion-detection");
var import_middleware_user_agent = require("@aws-sdk/middleware-user-agent");
var import_config_resolver = require("@smithy/config-resolver");
var import_core = require("@smithy/core");
var import_middleware_content_length = require("@smithy/middleware-content-length");
var import_middleware_endpoint = require("@smithy/middleware-endpoint");
var import_middleware_retry = require("@smithy/middleware-retry");

var import_httpAuthSchemeProvider = require("./auth/httpAuthSchemeProvider");

// src/endpoint/EndpointParameters.ts
var resolveClientEndpointParameters = /* @__PURE__ */ __name((options) => {
  return Object.assign(options, {
    useDualstackEndpoint: options.useDualstackEndpoint ?? false,
    useFipsEndpoint: options.useFipsEndpoint ?? false,
    defaultSigningName: "ecs"
  });
}, "resolveClientEndpointParameters");
var commonParams = {
  UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
  Endpoint: { type: "builtInParams", name: "endpoint" },
  Region: { type: "builtInParams", name: "region" },
  UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" }
};

// src/ECSClient.ts
var import_runtimeConfig = require("././runtimeConfig");

// src/runtimeExtensions.ts
var import_region_config_resolver = require("@aws-sdk/region-config-resolver");
var import_protocol_http = require("@smithy/protocol-http");
var import_smithy_client = require("@smithy/smithy-client");

// src/auth/httpAuthExtensionConfiguration.ts
var getHttpAuthExtensionConfiguration = /* @__PURE__ */ __name((runtimeConfig) => {
  const _httpAuthSchemes = runtimeConfig.httpAuthSchemes;
  let _httpAuthSchemeProvider = runtimeConfig.httpAuthSchemeProvider;
  let _credentials = runtimeConfig.credentials;
  return {
    setHttpAuthScheme(httpAuthScheme) {
      const index = _httpAuthSchemes.findIndex((scheme) => scheme.schemeId === httpAuthScheme.schemeId);
      if (index === -1) {
        _httpAuthSchemes.push(httpAuthScheme);
      } else {
        _httpAuthSchemes.splice(index, 1, httpAuthScheme);
      }
    },
    httpAuthSchemes() {
      return _httpAuthSchemes;
    },
    setHttpAuthSchemeProvider(httpAuthSchemeProvider) {
      _httpAuthSchemeProvider = httpAuthSchemeProvider;
    },
    httpAuthSchemeProvider() {
      return _httpAuthSchemeProvider;
    },
    setCredentials(credentials) {
      _credentials = credentials;
    },
    credentials() {
      return _credentials;
    }
  };
}, "getHttpAuthExtensionConfiguration");
var resolveHttpAuthRuntimeConfig = /* @__PURE__ */ __name((config) => {
  return {
    httpAuthSchemes: config.httpAuthSchemes(),
    httpAuthSchemeProvider: config.httpAuthSchemeProvider(),
    credentials: config.credentials()
  };
}, "resolveHttpAuthRuntimeConfig");

// src/runtimeExtensions.ts
var resolveRuntimeExtensions = /* @__PURE__ */ __name((runtimeConfig, extensions) => {
  const extensionConfiguration = Object.assign(
    (0, import_region_config_resolver.getAwsRegionExtensionConfiguration)(runtimeConfig),
    (0, import_smithy_client.getDefaultExtensionConfiguration)(runtimeConfig),
    (0, import_protocol_http.getHttpHandlerExtensionConfiguration)(runtimeConfig),
    getHttpAuthExtensionConfiguration(runtimeConfig)
  );
  extensions.forEach((extension) => extension.configure(extensionConfiguration));
  return Object.assign(
    runtimeConfig,
    (0, import_region_config_resolver.resolveAwsRegionExtensionConfiguration)(extensionConfiguration),
    (0, import_smithy_client.resolveDefaultRuntimeConfig)(extensionConfiguration),
    (0, import_protocol_http.resolveHttpHandlerRuntimeConfig)(extensionConfiguration),
    resolveHttpAuthRuntimeConfig(extensionConfiguration)
  );
}, "resolveRuntimeExtensions");

// src/ECSClient.ts
var ECSClient = class extends import_smithy_client.Client {
  static {
    __name(this, "ECSClient");
  }
  /**
   * The resolved configuration of ECSClient class. This is resolved and normalized from the {@link ECSClientConfig | constructor configuration interface}.
   */
  config;
  constructor(...[configuration]) {
    const _config_0 = (0, import_runtimeConfig.getRuntimeConfig)(configuration || {});
    super(_config_0);
    this.initConfig = _config_0;
    const _config_1 = resolveClientEndpointParameters(_config_0);
    const _config_2 = (0, import_middleware_user_agent.resolveUserAgentConfig)(_config_1);
    const _config_3 = (0, import_middleware_retry.resolveRetryConfig)(_config_2);
    const _config_4 = (0, import_config_resolver.resolveRegionConfig)(_config_3);
    const _config_5 = (0, import_middleware_host_header.resolveHostHeaderConfig)(_config_4);
    const _config_6 = (0, import_middleware_endpoint.resolveEndpointConfig)(_config_5);
    const _config_7 = (0, import_httpAuthSchemeProvider.resolveHttpAuthSchemeConfig)(_config_6);
    const _config_8 = resolveRuntimeExtensions(_config_7, configuration?.extensions || []);
    this.config = _config_8;
    this.middlewareStack.use((0, import_middleware_user_agent.getUserAgentPlugin)(this.config));
    this.middlewareStack.use((0, import_middleware_retry.getRetryPlugin)(this.config));
    this.middlewareStack.use((0, import_middleware_content_length.getContentLengthPlugin)(this.config));
    this.middlewareStack.use((0, import_middleware_host_header.getHostHeaderPlugin)(this.config));
    this.middlewareStack.use((0, import_middleware_logger.getLoggerPlugin)(this.config));
    this.middlewareStack.use((0, import_middleware_recursion_detection.getRecursionDetectionPlugin)(this.config));
    this.middlewareStack.use(
      (0, import_core.getHttpAuthSchemeEndpointRuleSetPlugin)(this.config, {
        httpAuthSchemeParametersProvider: import_httpAuthSchemeProvider.defaultECSHttpAuthSchemeParametersProvider,
        identityProviderConfigProvider: /* @__PURE__ */ __name(async (config) => new import_core.DefaultIdentityProviderConfig({
          "aws.auth#sigv4": config.credentials
        }), "identityProviderConfigProvider")
      })
    );
    this.middlewareStack.use((0, import_core.getHttpSigningPlugin)(this.config));
  }
  /**
   * Destroy underlying resources, like sockets. It's usually not necessary to do this.
   * However in Node.js, it's best to explicitly shut down the client's agent when it is no longer needed.
   * Otherwise, sockets might stay open for quite a long time before the server terminates them.
   */
  destroy() {
    super.destroy();
  }
};

// src/ECS.ts


// src/commands/CreateCapacityProviderCommand.ts

var import_middleware_serde = require("@smithy/middleware-serde");


// src/protocols/Aws_json1_1.ts
var import_core2 = require("@aws-sdk/core");


var import_uuid = require("@smithy/uuid");

// src/models/ECSServiceException.ts

var ECSServiceException = class _ECSServiceException extends import_smithy_client.ServiceException {
  static {
    __name(this, "ECSServiceException");
  }
  /**
   * @internal
   */
  constructor(options) {
    super(options);
    Object.setPrototypeOf(this, _ECSServiceException.prototype);
  }
};

// src/models/models_0.ts

var AcceleratorManufacturer = {
  AMAZON_WEB_SERVICES: "amazon-web-services",
  AMD: "amd",
  HABANA: "habana",
  NVIDIA: "nvidia",
  XILINX: "xilinx"
};
var AcceleratorName = {
  A100: "a100",
  A10G: "a10g",
  H100: "h100",
  INFERENTIA: "inferentia",
  K520: "k520",
  K80: "k80",
  M60: "m60",
  RADEON_PRO_V520: "radeon-pro-v520",
  T4: "t4",
  T4G: "t4g",
  V100: "v100",
  VU9P: "vu9p"
};
var AcceleratorType = {
  FPGA: "fpga",
  GPU: "gpu",
  INFERENCE: "inference"
};
var AccessDeniedException = class _AccessDeniedException extends ECSServiceException {
  static {
    __name(this, "AccessDeniedException");
  }
  name = "AccessDeniedException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "AccessDeniedException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _AccessDeniedException.prototype);
  }
};
var AgentUpdateStatus = {
  FAILED: "FAILED",
  PENDING: "PENDING",
  STAGED: "STAGED",
  STAGING: "STAGING",
  UPDATED: "UPDATED",
  UPDATING: "UPDATING"
};
var ClientException = class _ClientException extends ECSServiceException {
  static {
    __name(this, "ClientException");
  }
  name = "ClientException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ClientException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ClientException.prototype);
  }
};
var ClusterNotFoundException = class _ClusterNotFoundException extends ECSServiceException {
  static {
    __name(this, "ClusterNotFoundException");
  }
  name = "ClusterNotFoundException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ClusterNotFoundException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ClusterNotFoundException.prototype);
  }
};
var ManagedDraining = {
  DISABLED: "DISABLED",
  ENABLED: "ENABLED"
};
var ManagedScalingStatus = {
  DISABLED: "DISABLED",
  ENABLED: "ENABLED"
};
var ManagedTerminationProtection = {
  DISABLED: "DISABLED",
  ENABLED: "ENABLED"
};
var BareMetal = {
  EXCLUDED: "excluded",
  INCLUDED: "included",
  REQUIRED: "required"
};
var BurstablePerformance = {
  EXCLUDED: "excluded",
  INCLUDED: "included",
  REQUIRED: "required"
};
var CpuManufacturer = {
  AMAZON_WEB_SERVICES: "amazon-web-services",
  AMD: "amd",
  INTEL: "intel"
};
var InstanceGeneration = {
  CURRENT: "current",
  PREVIOUS: "previous"
};
var LocalStorage = {
  EXCLUDED: "excluded",
  INCLUDED: "included",
  REQUIRED: "required"
};
var LocalStorageType = {
  HDD: "hdd",
  SSD: "ssd"
};
var ManagedInstancesMonitoringOptions = {
  BASIC: "BASIC",
  DETAILED: "DETAILED"
};
var PropagateMITags = {
  CAPACITY_PROVIDER: "CAPACITY_PROVIDER",
  NONE: "NONE"
};
var CapacityProviderStatus = {
  ACTIVE: "ACTIVE",
  DEPROVISIONING: "DEPROVISIONING",
  INACTIVE: "INACTIVE",
  PROVISIONING: "PROVISIONING"
};
var CapacityProviderType = {
  EC2_AUTOSCALING: "EC2_AUTOSCALING",
  FARGATE: "FARGATE",
  FARGATE_SPOT: "FARGATE_SPOT",
  MANAGED_INSTANCES: "MANAGED_INSTANCES"
};
var CapacityProviderUpdateStatus = {
  CREATE_COMPLETE: "CREATE_COMPLETE",
  CREATE_FAILED: "CREATE_FAILED",
  CREATE_IN_PROGRESS: "CREATE_IN_PROGRESS",
  DELETE_COMPLETE: "DELETE_COMPLETE",
  DELETE_FAILED: "DELETE_FAILED",
  DELETE_IN_PROGRESS: "DELETE_IN_PROGRESS",
  UPDATE_COMPLETE: "UPDATE_COMPLETE",
  UPDATE_FAILED: "UPDATE_FAILED",
  UPDATE_IN_PROGRESS: "UPDATE_IN_PROGRESS"
};
var InvalidParameterException = class _InvalidParameterException extends ECSServiceException {
  static {
    __name(this, "InvalidParameterException");
  }
  name = "InvalidParameterException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidParameterException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidParameterException.prototype);
  }
};
var LimitExceededException = class _LimitExceededException extends ECSServiceException {
  static {
    __name(this, "LimitExceededException");
  }
  name = "LimitExceededException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "LimitExceededException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _LimitExceededException.prototype);
  }
};
var ServerException = class _ServerException extends ECSServiceException {
  static {
    __name(this, "ServerException");
  }
  name = "ServerException";
  $fault = "server";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ServerException",
      $fault: "server",
      ...opts
    });
    Object.setPrototypeOf(this, _ServerException.prototype);
  }
};
var UnsupportedFeatureException = class _UnsupportedFeatureException extends ECSServiceException {
  static {
    __name(this, "UnsupportedFeatureException");
  }
  name = "UnsupportedFeatureException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "UnsupportedFeatureException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _UnsupportedFeatureException.prototype);
  }
};
var UpdateInProgressException = class _UpdateInProgressException extends ECSServiceException {
  static {
    __name(this, "UpdateInProgressException");
  }
  name = "UpdateInProgressException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "UpdateInProgressException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _UpdateInProgressException.prototype);
  }
};
var ExecuteCommandLogging = {
  DEFAULT: "DEFAULT",
  NONE: "NONE",
  OVERRIDE: "OVERRIDE"
};
var ClusterSettingName = {
  CONTAINER_INSIGHTS: "containerInsights"
};
var NamespaceNotFoundException = class _NamespaceNotFoundException extends ECSServiceException {
  static {
    __name(this, "NamespaceNotFoundException");
  }
  name = "NamespaceNotFoundException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "NamespaceNotFoundException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _NamespaceNotFoundException.prototype);
  }
};
var AvailabilityZoneRebalancing = {
  DISABLED: "DISABLED",
  ENABLED: "ENABLED"
};
var DeploymentLifecycleHookStage = {
  POST_PRODUCTION_TRAFFIC_SHIFT: "POST_PRODUCTION_TRAFFIC_SHIFT",
  POST_SCALE_UP: "POST_SCALE_UP",
  POST_TEST_TRAFFIC_SHIFT: "POST_TEST_TRAFFIC_SHIFT",
  PRE_SCALE_UP: "PRE_SCALE_UP",
  PRODUCTION_TRAFFIC_SHIFT: "PRODUCTION_TRAFFIC_SHIFT",
  RECONCILE_SERVICE: "RECONCILE_SERVICE",
  TEST_TRAFFIC_SHIFT: "TEST_TRAFFIC_SHIFT"
};
var DeploymentStrategy = {
  BLUE_GREEN: "BLUE_GREEN",
  ROLLING: "ROLLING"
};
var DeploymentControllerType = {
  CODE_DEPLOY: "CODE_DEPLOY",
  ECS: "ECS",
  EXTERNAL: "EXTERNAL"
};
var LaunchType = {
  EC2: "EC2",
  EXTERNAL: "EXTERNAL",
  FARGATE: "FARGATE",
  MANAGED_INSTANCES: "MANAGED_INSTANCES"
};
var AssignPublicIp = {
  DISABLED: "DISABLED",
  ENABLED: "ENABLED"
};
var PlacementConstraintType = {
  DISTINCT_INSTANCE: "distinctInstance",
  MEMBER_OF: "memberOf"
};
var PlacementStrategyType = {
  BINPACK: "binpack",
  RANDOM: "random",
  SPREAD: "spread"
};
var PropagateTags = {
  NONE: "NONE",
  SERVICE: "SERVICE",
  TASK_DEFINITION: "TASK_DEFINITION"
};
var SchedulingStrategy = {
  DAEMON: "DAEMON",
  REPLICA: "REPLICA"
};
var LogDriver = {
  AWSFIRELENS: "awsfirelens",
  AWSLOGS: "awslogs",
  FLUENTD: "fluentd",
  GELF: "gelf",
  JOURNALD: "journald",
  JSON_FILE: "json-file",
  SPLUNK: "splunk",
  SYSLOG: "syslog"
};
var TaskFilesystemType = {
  EXT3: "ext3",
  EXT4: "ext4",
  NTFS: "ntfs",
  XFS: "xfs"
};
var EBSResourceType = {
  VOLUME: "volume"
};
var DeploymentRolloutState = {
  COMPLETED: "COMPLETED",
  FAILED: "FAILED",
  IN_PROGRESS: "IN_PROGRESS"
};
var ScaleUnit = {
  PERCENT: "PERCENT"
};
var StabilityStatus = {
  STABILIZING: "STABILIZING",
  STEADY_STATE: "STEADY_STATE"
};
var PlatformTaskDefinitionIncompatibilityException = class _PlatformTaskDefinitionIncompatibilityException extends ECSServiceException {
  static {
    __name(this, "PlatformTaskDefinitionIncompatibilityException");
  }
  name = "PlatformTaskDefinitionIncompatibilityException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "PlatformTaskDefinitionIncompatibilityException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _PlatformTaskDefinitionIncompatibilityException.prototype);
  }
};
var PlatformUnknownException = class _PlatformUnknownException extends ECSServiceException {
  static {
    __name(this, "PlatformUnknownException");
  }
  name = "PlatformUnknownException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "PlatformUnknownException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _PlatformUnknownException.prototype);
  }
};
var ServiceNotActiveException = class _ServiceNotActiveException extends ECSServiceException {
  static {
    __name(this, "ServiceNotActiveException");
  }
  name = "ServiceNotActiveException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ServiceNotActiveException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ServiceNotActiveException.prototype);
  }
};
var ServiceNotFoundException = class _ServiceNotFoundException extends ECSServiceException {
  static {
    __name(this, "ServiceNotFoundException");
  }
  name = "ServiceNotFoundException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ServiceNotFoundException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ServiceNotFoundException.prototype);
  }
};
var SettingName = {
  AWSVPC_TRUNKING: "awsvpcTrunking",
  CONTAINER_INSIGHTS: "containerInsights",
  CONTAINER_INSTANCE_LONG_ARN_FORMAT: "containerInstanceLongArnFormat",
  DEFAULT_LOG_DRIVER_MODE: "defaultLogDriverMode",
  FARGATE_FIPS_MODE: "fargateFIPSMode",
  FARGATE_TASK_RETIREMENT_WAIT_PERIOD: "fargateTaskRetirementWaitPeriod",
  GUARD_DUTY_ACTIVATE: "guardDutyActivate",
  SERVICE_LONG_ARN_FORMAT: "serviceLongArnFormat",
  TAG_RESOURCE_AUTHORIZATION: "tagResourceAuthorization",
  TASK_LONG_ARN_FORMAT: "taskLongArnFormat"
};
var SettingType = {
  AWS_MANAGED: "aws_managed",
  USER: "user"
};
var TargetType = {
  CONTAINER_INSTANCE: "container-instance"
};
var TargetNotFoundException = class _TargetNotFoundException extends ECSServiceException {
  static {
    __name(this, "TargetNotFoundException");
  }
  name = "TargetNotFoundException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TargetNotFoundException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TargetNotFoundException.prototype);
  }
};
var ClusterContainsCapacityProviderException = class _ClusterContainsCapacityProviderException extends ECSServiceException {
  static {
    __name(this, "ClusterContainsCapacityProviderException");
  }
  name = "ClusterContainsCapacityProviderException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ClusterContainsCapacityProviderException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ClusterContainsCapacityProviderException.prototype);
  }
};
var ClusterContainsContainerInstancesException = class _ClusterContainsContainerInstancesException extends ECSServiceException {
  static {
    __name(this, "ClusterContainsContainerInstancesException");
  }
  name = "ClusterContainsContainerInstancesException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ClusterContainsContainerInstancesException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ClusterContainsContainerInstancesException.prototype);
  }
};
var ClusterContainsServicesException = class _ClusterContainsServicesException extends ECSServiceException {
  static {
    __name(this, "ClusterContainsServicesException");
  }
  name = "ClusterContainsServicesException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ClusterContainsServicesException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ClusterContainsServicesException.prototype);
  }
};
var ClusterContainsTasksException = class _ClusterContainsTasksException extends ECSServiceException {
  static {
    __name(this, "ClusterContainsTasksException");
  }
  name = "ClusterContainsTasksException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ClusterContainsTasksException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ClusterContainsTasksException.prototype);
  }
};
var Compatibility = {
  EC2: "EC2",
  EXTERNAL: "EXTERNAL",
  FARGATE: "FARGATE",
  MANAGED_INSTANCES: "MANAGED_INSTANCES"
};
var ContainerCondition = {
  COMPLETE: "COMPLETE",
  HEALTHY: "HEALTHY",
  START: "START",
  SUCCESS: "SUCCESS"
};
var EnvironmentFileType = {
  S3: "s3"
};
var FirelensConfigurationType = {
  FLUENTBIT: "fluentbit",
  FLUENTD: "fluentd"
};
var DeviceCgroupPermission = {
  MKNOD: "mknod",
  READ: "read",
  WRITE: "write"
};
var ApplicationProtocol = {
  GRPC: "grpc",
  HTTP: "http",
  HTTP2: "http2"
};
var TransportProtocol = {
  TCP: "tcp",
  UDP: "udp"
};
var ResourceType = {
  GPU: "GPU",
  INFERENCE_ACCELERATOR: "InferenceAccelerator"
};
var UlimitName = {
  CORE: "core",
  CPU: "cpu",
  DATA: "data",
  FSIZE: "fsize",
  LOCKS: "locks",
  MEMLOCK: "memlock",
  MSGQUEUE: "msgqueue",
  NICE: "nice",
  NOFILE: "nofile",
  NPROC: "nproc",
  RSS: "rss",
  RTPRIO: "rtprio",
  RTTIME: "rttime",
  SIGPENDING: "sigpending",
  STACK: "stack"
};
var VersionConsistency = {
  DISABLED: "disabled",
  ENABLED: "enabled"
};
var IpcMode = {
  HOST: "host",
  NONE: "none",
  TASK: "task"
};
var NetworkMode = {
  AWSVPC: "awsvpc",
  BRIDGE: "bridge",
  HOST: "host",
  NONE: "none"
};
var PidMode = {
  HOST: "host",
  TASK: "task"
};
var TaskDefinitionPlacementConstraintType = {
  MEMBER_OF: "memberOf"
};
var ProxyConfigurationType = {
  APPMESH: "APPMESH"
};
var CPUArchitecture = {
  ARM64: "ARM64",
  X86_64: "X86_64"
};
var OSFamily = {
  LINUX: "LINUX",
  WINDOWS_SERVER_2004_CORE: "WINDOWS_SERVER_2004_CORE",
  WINDOWS_SERVER_2016_FULL: "WINDOWS_SERVER_2016_FULL",
  WINDOWS_SERVER_2019_CORE: "WINDOWS_SERVER_2019_CORE",
  WINDOWS_SERVER_2019_FULL: "WINDOWS_SERVER_2019_FULL",
  WINDOWS_SERVER_2022_CORE: "WINDOWS_SERVER_2022_CORE",
  WINDOWS_SERVER_2022_FULL: "WINDOWS_SERVER_2022_FULL",
  WINDOWS_SERVER_2025_CORE: "WINDOWS_SERVER_2025_CORE",
  WINDOWS_SERVER_2025_FULL: "WINDOWS_SERVER_2025_FULL",
  WINDOWS_SERVER_20H2_CORE: "WINDOWS_SERVER_20H2_CORE"
};
var TaskDefinitionStatus = {
  ACTIVE: "ACTIVE",
  DELETE_IN_PROGRESS: "DELETE_IN_PROGRESS",
  INACTIVE: "INACTIVE"
};
var Scope = {
  SHARED: "shared",
  TASK: "task"
};
var EFSAuthorizationConfigIAM = {
  DISABLED: "DISABLED",
  ENABLED: "ENABLED"
};
var EFSTransitEncryption = {
  DISABLED: "DISABLED",
  ENABLED: "ENABLED"
};
var TaskSetNotFoundException = class _TaskSetNotFoundException extends ECSServiceException {
  static {
    __name(this, "TaskSetNotFoundException");
  }
  name = "TaskSetNotFoundException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TaskSetNotFoundException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TaskSetNotFoundException.prototype);
  }
};
var InstanceHealthCheckState = {
  IMPAIRED: "IMPAIRED",
  INITIALIZING: "INITIALIZING",
  INSUFFICIENT_DATA: "INSUFFICIENT_DATA",
  OK: "OK"
};
var InstanceHealthCheckType = {
  CONTAINER_RUNTIME: "CONTAINER_RUNTIME"
};
var CapacityProviderField = {
  TAGS: "TAGS"
};
var ClusterField = {
  ATTACHMENTS: "ATTACHMENTS",
  CONFIGURATIONS: "CONFIGURATIONS",
  SETTINGS: "SETTINGS",
  STATISTICS: "STATISTICS",
  TAGS: "TAGS"
};
var ContainerInstanceField = {
  CONTAINER_INSTANCE_HEALTH: "CONTAINER_INSTANCE_HEALTH",
  TAGS: "TAGS"
};
var ServiceDeploymentRollbackMonitorsStatus = {
  DISABLED: "DISABLED",
  MONITORING: "MONITORING",
  MONITORING_COMPLETE: "MONITORING_COMPLETE",
  TRIGGERED: "TRIGGERED"
};
var ServiceDeploymentLifecycleStage = {
  BAKE_TIME: "BAKE_TIME",
  CLEAN_UP: "CLEAN_UP",
  POST_PRODUCTION_TRAFFIC_SHIFT: "POST_PRODUCTION_TRAFFIC_SHIFT",
  POST_SCALE_UP: "POST_SCALE_UP",
  POST_TEST_TRAFFIC_SHIFT: "POST_TEST_TRAFFIC_SHIFT",
  PRE_SCALE_UP: "PRE_SCALE_UP",
  PRODUCTION_TRAFFIC_SHIFT: "PRODUCTION_TRAFFIC_SHIFT",
  RECONCILE_SERVICE: "RECONCILE_SERVICE",
  SCALE_UP: "SCALE_UP",
  TEST_TRAFFIC_SHIFT: "TEST_TRAFFIC_SHIFT"
};
var ServiceDeploymentStatus = {
  IN_PROGRESS: "IN_PROGRESS",
  PENDING: "PENDING",
  ROLLBACK_FAILED: "ROLLBACK_FAILED",
  ROLLBACK_IN_PROGRESS: "ROLLBACK_IN_PROGRESS",
  ROLLBACK_REQUESTED: "ROLLBACK_REQUESTED",
  ROLLBACK_SUCCESSFUL: "ROLLBACK_SUCCESSFUL",
  STOPPED: "STOPPED",
  STOP_REQUESTED: "STOP_REQUESTED",
  SUCCESSFUL: "SUCCESSFUL"
};
var ServiceField = {
  TAGS: "TAGS"
};
var TaskDefinitionField = {
  TAGS: "TAGS"
};
var TaskField = {
  TAGS: "TAGS"
};
var Connectivity = {
  CONNECTED: "CONNECTED",
  DISCONNECTED: "DISCONNECTED"
};
var HealthStatus = {
  HEALTHY: "HEALTHY",
  UNHEALTHY: "UNHEALTHY",
  UNKNOWN: "UNKNOWN"
};
var ManagedAgentName = {
  ExecuteCommandAgent: "ExecuteCommandAgent"
};
var TaskStopCode = {
  ESSENTIAL_CONTAINER_EXITED: "EssentialContainerExited",
  SERVICE_SCHEDULER_INITIATED: "ServiceSchedulerInitiated",
  SPOT_INTERRUPTION: "SpotInterruption",
  TASK_FAILED_TO_START: "TaskFailedToStart",
  TERMINATION_NOTICE: "TerminationNotice",
  USER_INITIATED: "UserInitiated"
};
var TaskSetField = {
  TAGS: "TAGS"
};
var TargetNotConnectedException = class _TargetNotConnectedException extends ECSServiceException {
  static {
    __name(this, "TargetNotConnectedException");
  }
  name = "TargetNotConnectedException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TargetNotConnectedException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TargetNotConnectedException.prototype);
  }
};
var ResourceNotFoundException = class _ResourceNotFoundException extends ECSServiceException {
  static {
    __name(this, "ResourceNotFoundException");
  }
  name = "ResourceNotFoundException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ResourceNotFoundException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ResourceNotFoundException.prototype);
  }
};
var ContainerInstanceStatus = {
  ACTIVE: "ACTIVE",
  DEREGISTERING: "DEREGISTERING",
  DRAINING: "DRAINING",
  REGISTERING: "REGISTERING",
  REGISTRATION_FAILED: "REGISTRATION_FAILED"
};
var TaskDefinitionFamilyStatus = {
  ACTIVE: "ACTIVE",
  ALL: "ALL",
  INACTIVE: "INACTIVE"
};
var SortOrder = {
  ASC: "ASC",
  DESC: "DESC"
};
var DesiredStatus = {
  PENDING: "PENDING",
  RUNNING: "RUNNING",
  STOPPED: "STOPPED"
};
var SessionFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.tokenValue && { tokenValue: import_smithy_client.SENSITIVE_STRING }
}), "SessionFilterSensitiveLog");
var ExecuteCommandResponseFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.session && { session: SessionFilterSensitiveLog(obj.session) }
}), "ExecuteCommandResponseFilterSensitiveLog");

// src/models/models_1.ts
var AttributeLimitExceededException = class _AttributeLimitExceededException extends ECSServiceException {
  static {
    __name(this, "AttributeLimitExceededException");
  }
  name = "AttributeLimitExceededException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "AttributeLimitExceededException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _AttributeLimitExceededException.prototype);
  }
};
var ResourceInUseException = class _ResourceInUseException extends ECSServiceException {
  static {
    __name(this, "ResourceInUseException");
  }
  name = "ResourceInUseException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ResourceInUseException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ResourceInUseException.prototype);
  }
};
var PlatformDeviceType = {
  GPU: "GPU"
};
var BlockedException = class _BlockedException extends ECSServiceException {
  static {
    __name(this, "BlockedException");
  }
  name = "BlockedException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "BlockedException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _BlockedException.prototype);
  }
};
var ConflictException = class _ConflictException extends ECSServiceException {
  static {
    __name(this, "ConflictException");
  }
  name = "ConflictException";
  $fault = "client";
  /**
   * <p>The existing task ARNs which are already associated with the
   * 				<code>clientToken</code>.</p>
   * @public
   */
  resourceIds;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ConflictException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ConflictException.prototype);
    this.resourceIds = opts.resourceIds;
  }
};
var ServiceDeploymentNotFoundException = class _ServiceDeploymentNotFoundException extends ECSServiceException {
  static {
    __name(this, "ServiceDeploymentNotFoundException");
  }
  name = "ServiceDeploymentNotFoundException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ServiceDeploymentNotFoundException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ServiceDeploymentNotFoundException.prototype);
  }
};
var StopServiceDeploymentStopType = {
  ABORT: "ABORT",
  ROLLBACK: "ROLLBACK"
};
var MissingVersionException = class _MissingVersionException extends ECSServiceException {
  static {
    __name(this, "MissingVersionException");
  }
  name = "MissingVersionException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "MissingVersionException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _MissingVersionException.prototype);
  }
};
var NoUpdateAvailableException = class _NoUpdateAvailableException extends ECSServiceException {
  static {
    __name(this, "NoUpdateAvailableException");
  }
  name = "NoUpdateAvailableException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "NoUpdateAvailableException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _NoUpdateAvailableException.prototype);
  }
};

// src/protocols/Aws_json1_1.ts
var se_CreateCapacityProviderCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("CreateCapacityProvider");
  let body;
  body = JSON.stringify(se_CreateCapacityProviderRequest(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CreateCapacityProviderCommand");
var se_CreateClusterCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("CreateCluster");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CreateClusterCommand");
var se_CreateServiceCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("CreateService");
  let body;
  body = JSON.stringify(se_CreateServiceRequest(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CreateServiceCommand");
var se_CreateTaskSetCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("CreateTaskSet");
  let body;
  body = JSON.stringify(se_CreateTaskSetRequest(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CreateTaskSetCommand");
var se_DeleteAccountSettingCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DeleteAccountSetting");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeleteAccountSettingCommand");
var se_DeleteAttributesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DeleteAttributes");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeleteAttributesCommand");
var se_DeleteCapacityProviderCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DeleteCapacityProvider");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeleteCapacityProviderCommand");
var se_DeleteClusterCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DeleteCluster");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeleteClusterCommand");
var se_DeleteServiceCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DeleteService");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeleteServiceCommand");
var se_DeleteTaskDefinitionsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DeleteTaskDefinitions");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeleteTaskDefinitionsCommand");
var se_DeleteTaskSetCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DeleteTaskSet");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeleteTaskSetCommand");
var se_DeregisterContainerInstanceCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DeregisterContainerInstance");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeregisterContainerInstanceCommand");
var se_DeregisterTaskDefinitionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DeregisterTaskDefinition");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeregisterTaskDefinitionCommand");
var se_DescribeCapacityProvidersCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DescribeCapacityProviders");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeCapacityProvidersCommand");
var se_DescribeClustersCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DescribeClusters");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeClustersCommand");
var se_DescribeContainerInstancesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DescribeContainerInstances");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeContainerInstancesCommand");
var se_DescribeServiceDeploymentsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DescribeServiceDeployments");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeServiceDeploymentsCommand");
var se_DescribeServiceRevisionsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DescribeServiceRevisions");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeServiceRevisionsCommand");
var se_DescribeServicesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DescribeServices");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeServicesCommand");
var se_DescribeTaskDefinitionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DescribeTaskDefinition");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeTaskDefinitionCommand");
var se_DescribeTasksCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DescribeTasks");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeTasksCommand");
var se_DescribeTaskSetsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DescribeTaskSets");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeTaskSetsCommand");
var se_DiscoverPollEndpointCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DiscoverPollEndpoint");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DiscoverPollEndpointCommand");
var se_ExecuteCommandCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ExecuteCommand");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ExecuteCommandCommand");
var se_GetTaskProtectionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("GetTaskProtection");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetTaskProtectionCommand");
var se_ListAccountSettingsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ListAccountSettings");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListAccountSettingsCommand");
var se_ListAttributesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ListAttributes");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListAttributesCommand");
var se_ListClustersCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ListClusters");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListClustersCommand");
var se_ListContainerInstancesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ListContainerInstances");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListContainerInstancesCommand");
var se_ListServiceDeploymentsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ListServiceDeployments");
  let body;
  body = JSON.stringify(se_ListServiceDeploymentsRequest(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListServiceDeploymentsCommand");
var se_ListServicesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ListServices");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListServicesCommand");
var se_ListServicesByNamespaceCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ListServicesByNamespace");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListServicesByNamespaceCommand");
var se_ListTagsForResourceCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ListTagsForResource");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListTagsForResourceCommand");
var se_ListTaskDefinitionFamiliesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ListTaskDefinitionFamilies");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListTaskDefinitionFamiliesCommand");
var se_ListTaskDefinitionsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ListTaskDefinitions");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListTaskDefinitionsCommand");
var se_ListTasksCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ListTasks");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListTasksCommand");
var se_PutAccountSettingCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("PutAccountSetting");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_PutAccountSettingCommand");
var se_PutAccountSettingDefaultCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("PutAccountSettingDefault");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_PutAccountSettingDefaultCommand");
var se_PutAttributesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("PutAttributes");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_PutAttributesCommand");
var se_PutClusterCapacityProvidersCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("PutClusterCapacityProviders");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_PutClusterCapacityProvidersCommand");
var se_RegisterContainerInstanceCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("RegisterContainerInstance");
  let body;
  body = JSON.stringify(se_RegisterContainerInstanceRequest(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_RegisterContainerInstanceCommand");
var se_RegisterTaskDefinitionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("RegisterTaskDefinition");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_RegisterTaskDefinitionCommand");
var se_RunTaskCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("RunTask");
  let body;
  body = JSON.stringify(se_RunTaskRequest(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_RunTaskCommand");
var se_StartTaskCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("StartTask");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_StartTaskCommand");
var se_StopServiceDeploymentCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("StopServiceDeployment");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_StopServiceDeploymentCommand");
var se_StopTaskCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("StopTask");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_StopTaskCommand");
var se_SubmitAttachmentStateChangesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("SubmitAttachmentStateChanges");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_SubmitAttachmentStateChangesCommand");
var se_SubmitContainerStateChangeCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("SubmitContainerStateChange");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_SubmitContainerStateChangeCommand");
var se_SubmitTaskStateChangeCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("SubmitTaskStateChange");
  let body;
  body = JSON.stringify(se_SubmitTaskStateChangeRequest(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_SubmitTaskStateChangeCommand");
var se_TagResourceCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("TagResource");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_TagResourceCommand");
var se_UntagResourceCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("UntagResource");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_UntagResourceCommand");
var se_UpdateCapacityProviderCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("UpdateCapacityProvider");
  let body;
  body = JSON.stringify(se_UpdateCapacityProviderRequest(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_UpdateCapacityProviderCommand");
var se_UpdateClusterCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("UpdateCluster");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_UpdateClusterCommand");
var se_UpdateClusterSettingsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("UpdateClusterSettings");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_UpdateClusterSettingsCommand");
var se_UpdateContainerAgentCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("UpdateContainerAgent");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_UpdateContainerAgentCommand");
var se_UpdateContainerInstancesStateCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("UpdateContainerInstancesState");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_UpdateContainerInstancesStateCommand");
var se_UpdateServiceCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("UpdateService");
  let body;
  body = JSON.stringify(se_UpdateServiceRequest(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_UpdateServiceCommand");
var se_UpdateServicePrimaryTaskSetCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("UpdateServicePrimaryTaskSet");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_UpdateServicePrimaryTaskSetCommand");
var se_UpdateTaskProtectionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("UpdateTaskProtection");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_UpdateTaskProtectionCommand");
var se_UpdateTaskSetCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("UpdateTaskSet");
  let body;
  body = JSON.stringify(se_UpdateTaskSetRequest(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_UpdateTaskSetCommand");
var de_CreateCapacityProviderCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_CreateCapacityProviderResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CreateCapacityProviderCommand");
var de_CreateClusterCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CreateClusterCommand");
var de_CreateServiceCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_CreateServiceResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CreateServiceCommand");
var de_CreateTaskSetCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_CreateTaskSetResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CreateTaskSetCommand");
var de_DeleteAccountSettingCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DeleteAccountSettingCommand");
var de_DeleteAttributesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DeleteAttributesCommand");
var de_DeleteCapacityProviderCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_DeleteCapacityProviderResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DeleteCapacityProviderCommand");
var de_DeleteClusterCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DeleteClusterCommand");
var de_DeleteServiceCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_DeleteServiceResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DeleteServiceCommand");
var de_DeleteTaskDefinitionsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_DeleteTaskDefinitionsResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DeleteTaskDefinitionsCommand");
var de_DeleteTaskSetCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_DeleteTaskSetResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DeleteTaskSetCommand");
var de_DeregisterContainerInstanceCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_DeregisterContainerInstanceResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DeregisterContainerInstanceCommand");
var de_DeregisterTaskDefinitionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_DeregisterTaskDefinitionResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DeregisterTaskDefinitionCommand");
var de_DescribeCapacityProvidersCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_DescribeCapacityProvidersResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeCapacityProvidersCommand");
var de_DescribeClustersCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeClustersCommand");
var de_DescribeContainerInstancesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_DescribeContainerInstancesResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeContainerInstancesCommand");
var de_DescribeServiceDeploymentsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_DescribeServiceDeploymentsResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeServiceDeploymentsCommand");
var de_DescribeServiceRevisionsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_DescribeServiceRevisionsResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeServiceRevisionsCommand");
var de_DescribeServicesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_DescribeServicesResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeServicesCommand");
var de_DescribeTaskDefinitionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_DescribeTaskDefinitionResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeTaskDefinitionCommand");
var de_DescribeTasksCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_DescribeTasksResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeTasksCommand");
var de_DescribeTaskSetsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_DescribeTaskSetsResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeTaskSetsCommand");
var de_DiscoverPollEndpointCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DiscoverPollEndpointCommand");
var de_ExecuteCommandCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ExecuteCommandCommand");
var de_GetTaskProtectionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_GetTaskProtectionResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetTaskProtectionCommand");
var de_ListAccountSettingsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListAccountSettingsCommand");
var de_ListAttributesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListAttributesCommand");
var de_ListClustersCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListClustersCommand");
var de_ListContainerInstancesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListContainerInstancesCommand");
var de_ListServiceDeploymentsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_ListServiceDeploymentsResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListServiceDeploymentsCommand");
var de_ListServicesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListServicesCommand");
var de_ListServicesByNamespaceCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListServicesByNamespaceCommand");
var de_ListTagsForResourceCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListTagsForResourceCommand");
var de_ListTaskDefinitionFamiliesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListTaskDefinitionFamiliesCommand");
var de_ListTaskDefinitionsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListTaskDefinitionsCommand");
var de_ListTasksCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListTasksCommand");
var de_PutAccountSettingCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_PutAccountSettingCommand");
var de_PutAccountSettingDefaultCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_PutAccountSettingDefaultCommand");
var de_PutAttributesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_PutAttributesCommand");
var de_PutClusterCapacityProvidersCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_PutClusterCapacityProvidersCommand");
var de_RegisterContainerInstanceCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_RegisterContainerInstanceResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_RegisterContainerInstanceCommand");
var de_RegisterTaskDefinitionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_RegisterTaskDefinitionResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_RegisterTaskDefinitionCommand");
var de_RunTaskCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_RunTaskResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_RunTaskCommand");
var de_StartTaskCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_StartTaskResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_StartTaskCommand");
var de_StopServiceDeploymentCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_StopServiceDeploymentCommand");
var de_StopTaskCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_StopTaskResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_StopTaskCommand");
var de_SubmitAttachmentStateChangesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_SubmitAttachmentStateChangesCommand");
var de_SubmitContainerStateChangeCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_SubmitContainerStateChangeCommand");
var de_SubmitTaskStateChangeCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_SubmitTaskStateChangeCommand");
var de_TagResourceCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_TagResourceCommand");
var de_UntagResourceCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_UntagResourceCommand");
var de_UpdateCapacityProviderCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_UpdateCapacityProviderResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_UpdateCapacityProviderCommand");
var de_UpdateClusterCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_UpdateClusterCommand");
var de_UpdateClusterSettingsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_UpdateClusterSettingsCommand");
var de_UpdateContainerAgentCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_UpdateContainerAgentResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_UpdateContainerAgentCommand");
var de_UpdateContainerInstancesStateCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_UpdateContainerInstancesStateResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_UpdateContainerInstancesStateCommand");
var de_UpdateServiceCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_UpdateServiceResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_UpdateServiceCommand");
var de_UpdateServicePrimaryTaskSetCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_UpdateServicePrimaryTaskSetResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_UpdateServicePrimaryTaskSetCommand");
var de_UpdateTaskProtectionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_UpdateTaskProtectionResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_UpdateTaskProtectionCommand");
var de_UpdateTaskSetCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_UpdateTaskSetResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_UpdateTaskSetCommand");
var de_CommandError = /* @__PURE__ */ __name(async (output, context) => {
  const parsedOutput = {
    ...output,
    body: await (0, import_core2.parseJsonErrorBody)(output.body, context)
  };
  const errorCode = (0, import_core2.loadRestJsonErrorCode)(output, parsedOutput.body);
  switch (errorCode) {
    case "ClientException":
    case "com.amazonaws.ecs#ClientException":
      throw await de_ClientExceptionRes(parsedOutput, context);
    case "ClusterNotFoundException":
    case "com.amazonaws.ecs#ClusterNotFoundException":
      throw await de_ClusterNotFoundExceptionRes(parsedOutput, context);
    case "InvalidParameterException":
    case "com.amazonaws.ecs#InvalidParameterException":
      throw await de_InvalidParameterExceptionRes(parsedOutput, context);
    case "LimitExceededException":
    case "com.amazonaws.ecs#LimitExceededException":
      throw await de_LimitExceededExceptionRes(parsedOutput, context);
    case "ServerException":
    case "com.amazonaws.ecs#ServerException":
      throw await de_ServerExceptionRes(parsedOutput, context);
    case "UnsupportedFeatureException":
    case "com.amazonaws.ecs#UnsupportedFeatureException":
      throw await de_UnsupportedFeatureExceptionRes(parsedOutput, context);
    case "UpdateInProgressException":
    case "com.amazonaws.ecs#UpdateInProgressException":
      throw await de_UpdateInProgressExceptionRes(parsedOutput, context);
    case "NamespaceNotFoundException":
    case "com.amazonaws.ecs#NamespaceNotFoundException":
      throw await de_NamespaceNotFoundExceptionRes(parsedOutput, context);
    case "AccessDeniedException":
    case "com.amazonaws.ecs#AccessDeniedException":
      throw await de_AccessDeniedExceptionRes(parsedOutput, context);
    case "PlatformTaskDefinitionIncompatibilityException":
    case "com.amazonaws.ecs#PlatformTaskDefinitionIncompatibilityException":
      throw await de_PlatformTaskDefinitionIncompatibilityExceptionRes(parsedOutput, context);
    case "PlatformUnknownException":
    case "com.amazonaws.ecs#PlatformUnknownException":
      throw await de_PlatformUnknownExceptionRes(parsedOutput, context);
    case "ServiceNotActiveException":
    case "com.amazonaws.ecs#ServiceNotActiveException":
      throw await de_ServiceNotActiveExceptionRes(parsedOutput, context);
    case "ServiceNotFoundException":
    case "com.amazonaws.ecs#ServiceNotFoundException":
      throw await de_ServiceNotFoundExceptionRes(parsedOutput, context);
    case "TargetNotFoundException":
    case "com.amazonaws.ecs#TargetNotFoundException":
      throw await de_TargetNotFoundExceptionRes(parsedOutput, context);
    case "ClusterContainsCapacityProviderException":
    case "com.amazonaws.ecs#ClusterContainsCapacityProviderException":
      throw await de_ClusterContainsCapacityProviderExceptionRes(parsedOutput, context);
    case "ClusterContainsContainerInstancesException":
    case "com.amazonaws.ecs#ClusterContainsContainerInstancesException":
      throw await de_ClusterContainsContainerInstancesExceptionRes(parsedOutput, context);
    case "ClusterContainsServicesException":
    case "com.amazonaws.ecs#ClusterContainsServicesException":
      throw await de_ClusterContainsServicesExceptionRes(parsedOutput, context);
    case "ClusterContainsTasksException":
    case "com.amazonaws.ecs#ClusterContainsTasksException":
      throw await de_ClusterContainsTasksExceptionRes(parsedOutput, context);
    case "TaskSetNotFoundException":
    case "com.amazonaws.ecs#TaskSetNotFoundException":
      throw await de_TaskSetNotFoundExceptionRes(parsedOutput, context);
    case "TargetNotConnectedException":
    case "com.amazonaws.ecs#TargetNotConnectedException":
      throw await de_TargetNotConnectedExceptionRes(parsedOutput, context);
    case "ResourceNotFoundException":
    case "com.amazonaws.ecs#ResourceNotFoundException":
      throw await de_ResourceNotFoundExceptionRes(parsedOutput, context);
    case "AttributeLimitExceededException":
    case "com.amazonaws.ecs#AttributeLimitExceededException":
      throw await de_AttributeLimitExceededExceptionRes(parsedOutput, context);
    case "ResourceInUseException":
    case "com.amazonaws.ecs#ResourceInUseException":
      throw await de_ResourceInUseExceptionRes(parsedOutput, context);
    case "BlockedException":
    case "com.amazonaws.ecs#BlockedException":
      throw await de_BlockedExceptionRes(parsedOutput, context);
    case "ConflictException":
    case "com.amazonaws.ecs#ConflictException":
      throw await de_ConflictExceptionRes(parsedOutput, context);
    case "ServiceDeploymentNotFoundException":
    case "com.amazonaws.ecs#ServiceDeploymentNotFoundException":
      throw await de_ServiceDeploymentNotFoundExceptionRes(parsedOutput, context);
    case "MissingVersionException":
    case "com.amazonaws.ecs#MissingVersionException":
      throw await de_MissingVersionExceptionRes(parsedOutput, context);
    case "NoUpdateAvailableException":
    case "com.amazonaws.ecs#NoUpdateAvailableException":
      throw await de_NoUpdateAvailableExceptionRes(parsedOutput, context);
    default:
      const parsedBody = parsedOutput.body;
      return throwDefaultError({
        output,
        parsedBody,
        errorCode
      });
  }
}, "de_CommandError");
var de_AccessDeniedExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new AccessDeniedException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_AccessDeniedExceptionRes");
var de_AttributeLimitExceededExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new AttributeLimitExceededException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_AttributeLimitExceededExceptionRes");
var de_BlockedExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new BlockedException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_BlockedExceptionRes");
var de_ClientExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ClientException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ClientExceptionRes");
var de_ClusterContainsCapacityProviderExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ClusterContainsCapacityProviderException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ClusterContainsCapacityProviderExceptionRes");
var de_ClusterContainsContainerInstancesExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ClusterContainsContainerInstancesException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ClusterContainsContainerInstancesExceptionRes");
var de_ClusterContainsServicesExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ClusterContainsServicesException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ClusterContainsServicesExceptionRes");
var de_ClusterContainsTasksExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ClusterContainsTasksException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ClusterContainsTasksExceptionRes");
var de_ClusterNotFoundExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ClusterNotFoundException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ClusterNotFoundExceptionRes");
var de_ConflictExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ConflictException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ConflictExceptionRes");
var de_InvalidParameterExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidParameterException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidParameterExceptionRes");
var de_LimitExceededExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new LimitExceededException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_LimitExceededExceptionRes");
var de_MissingVersionExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new MissingVersionException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_MissingVersionExceptionRes");
var de_NamespaceNotFoundExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new NamespaceNotFoundException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_NamespaceNotFoundExceptionRes");
var de_NoUpdateAvailableExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new NoUpdateAvailableException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_NoUpdateAvailableExceptionRes");
var de_PlatformTaskDefinitionIncompatibilityExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new PlatformTaskDefinitionIncompatibilityException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_PlatformTaskDefinitionIncompatibilityExceptionRes");
var de_PlatformUnknownExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new PlatformUnknownException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_PlatformUnknownExceptionRes");
var de_ResourceInUseExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ResourceInUseException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ResourceInUseExceptionRes");
var de_ResourceNotFoundExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ResourceNotFoundException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ResourceNotFoundExceptionRes");
var de_ServerExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ServerException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ServerExceptionRes");
var de_ServiceDeploymentNotFoundExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ServiceDeploymentNotFoundException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ServiceDeploymentNotFoundExceptionRes");
var de_ServiceNotActiveExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ServiceNotActiveException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ServiceNotActiveExceptionRes");
var de_ServiceNotFoundExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ServiceNotFoundException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ServiceNotFoundExceptionRes");
var de_TargetNotConnectedExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new TargetNotConnectedException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_TargetNotConnectedExceptionRes");
var de_TargetNotFoundExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new TargetNotFoundException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_TargetNotFoundExceptionRes");
var de_TaskSetNotFoundExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new TaskSetNotFoundException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_TaskSetNotFoundExceptionRes");
var de_UnsupportedFeatureExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new UnsupportedFeatureException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_UnsupportedFeatureExceptionRes");
var de_UpdateInProgressExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new UpdateInProgressException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_UpdateInProgressExceptionRes");
var se_CreateCapacityProviderRequest = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    autoScalingGroupProvider: import_smithy_client._json,
    cluster: [],
    managedInstancesProvider: /* @__PURE__ */ __name((_) => se_CreateManagedInstancesProviderConfiguration(_, context), "managedInstancesProvider"),
    name: [],
    tags: import_smithy_client._json
  });
}, "se_CreateCapacityProviderRequest");
var se_CreatedAt = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    after: /* @__PURE__ */ __name((_) => _.getTime() / 1e3, "after"),
    before: /* @__PURE__ */ __name((_) => _.getTime() / 1e3, "before")
  });
}, "se_CreatedAt");
var se_CreateManagedInstancesProviderConfiguration = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    infrastructureRoleArn: [],
    instanceLaunchTemplate: /* @__PURE__ */ __name((_) => se_InstanceLaunchTemplate(_, context), "instanceLaunchTemplate"),
    propagateTags: []
  });
}, "se_CreateManagedInstancesProviderConfiguration");
var se_CreateServiceRequest = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    availabilityZoneRebalancing: [],
    capacityProviderStrategy: import_smithy_client._json,
    clientToken: [],
    cluster: [],
    deploymentConfiguration: /* @__PURE__ */ __name((_) => se_DeploymentConfiguration(_, context), "deploymentConfiguration"),
    deploymentController: import_smithy_client._json,
    desiredCount: [],
    enableECSManagedTags: [],
    enableExecuteCommand: [],
    healthCheckGracePeriodSeconds: [],
    launchType: [],
    loadBalancers: import_smithy_client._json,
    networkConfiguration: import_smithy_client._json,
    placementConstraints: import_smithy_client._json,
    placementStrategy: import_smithy_client._json,
    platformVersion: [],
    propagateTags: [],
    role: [],
    schedulingStrategy: [],
    serviceConnectConfiguration: import_smithy_client._json,
    serviceName: [],
    serviceRegistries: import_smithy_client._json,
    tags: import_smithy_client._json,
    taskDefinition: [],
    volumeConfigurations: import_smithy_client._json,
    vpcLatticeConfigurations: import_smithy_client._json
  });
}, "se_CreateServiceRequest");
var se_CreateTaskSetRequest = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    capacityProviderStrategy: import_smithy_client._json,
    clientToken: [],
    cluster: [],
    externalId: [],
    launchType: [],
    loadBalancers: import_smithy_client._json,
    networkConfiguration: import_smithy_client._json,
    platformVersion: [],
    scale: /* @__PURE__ */ __name((_) => se_Scale(_, context), "scale"),
    service: [],
    serviceRegistries: import_smithy_client._json,
    tags: import_smithy_client._json,
    taskDefinition: []
  });
}, "se_CreateTaskSetRequest");
var se_DeploymentConfiguration = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    alarms: import_smithy_client._json,
    bakeTimeInMinutes: [],
    deploymentCircuitBreaker: import_smithy_client._json,
    lifecycleHooks: /* @__PURE__ */ __name((_) => se_DeploymentLifecycleHookList(_, context), "lifecycleHooks"),
    maximumPercent: [],
    minimumHealthyPercent: [],
    strategy: []
  });
}, "se_DeploymentConfiguration");
var se_DeploymentLifecycleHook = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    hookDetails: /* @__PURE__ */ __name((_) => se_HookDetails(_, context), "hookDetails"),
    hookTargetArn: [],
    lifecycleStages: import_smithy_client._json,
    roleArn: []
  });
}, "se_DeploymentLifecycleHook");
var se_DeploymentLifecycleHookList = /* @__PURE__ */ __name((input, context) => {
  return input.filter((e) => e != null).map((entry) => {
    return se_DeploymentLifecycleHook(entry, context);
  });
}, "se_DeploymentLifecycleHookList");
var se_HookDetails = /* @__PURE__ */ __name((input, context) => {
  return input;
}, "se_HookDetails");
var se_InstanceLaunchTemplate = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    ec2InstanceProfileArn: [],
    instanceRequirements: /* @__PURE__ */ __name((_) => se_InstanceRequirementsRequest(_, context), "instanceRequirements"),
    monitoring: [],
    networkConfiguration: import_smithy_client._json,
    storageConfiguration: import_smithy_client._json
  });
}, "se_InstanceLaunchTemplate");
var se_InstanceLaunchTemplateUpdate = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    ec2InstanceProfileArn: [],
    instanceRequirements: /* @__PURE__ */ __name((_) => se_InstanceRequirementsRequest(_, context), "instanceRequirements"),
    monitoring: [],
    networkConfiguration: import_smithy_client._json,
    storageConfiguration: import_smithy_client._json
  });
}, "se_InstanceLaunchTemplateUpdate");
var se_InstanceRequirementsRequest = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    acceleratorCount: import_smithy_client._json,
    acceleratorManufacturers: import_smithy_client._json,
    acceleratorNames: import_smithy_client._json,
    acceleratorTotalMemoryMiB: import_smithy_client._json,
    acceleratorTypes: import_smithy_client._json,
    allowedInstanceTypes: import_smithy_client._json,
    bareMetal: [],
    baselineEbsBandwidthMbps: import_smithy_client._json,
    burstablePerformance: [],
    cpuManufacturers: import_smithy_client._json,
    excludedInstanceTypes: import_smithy_client._json,
    instanceGenerations: import_smithy_client._json,
    localStorage: [],
    localStorageTypes: import_smithy_client._json,
    maxSpotPriceAsPercentageOfOptimalOnDemandPrice: [],
    memoryGiBPerVCpu: /* @__PURE__ */ __name((_) => se_MemoryGiBPerVCpuRequest(_, context), "memoryGiBPerVCpu"),
    memoryMiB: import_smithy_client._json,
    networkBandwidthGbps: /* @__PURE__ */ __name((_) => se_NetworkBandwidthGbpsRequest(_, context), "networkBandwidthGbps"),
    networkInterfaceCount: import_smithy_client._json,
    onDemandMaxPricePercentageOverLowestPrice: [],
    requireHibernateSupport: [],
    spotMaxPricePercentageOverLowestPrice: [],
    totalLocalStorageGB: /* @__PURE__ */ __name((_) => se_TotalLocalStorageGBRequest(_, context), "totalLocalStorageGB"),
    vCpuCount: import_smithy_client._json
  });
}, "se_InstanceRequirementsRequest");
var se_ListServiceDeploymentsRequest = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    cluster: [],
    createdAt: /* @__PURE__ */ __name((_) => se_CreatedAt(_, context), "createdAt"),
    maxResults: [],
    nextToken: [],
    service: [],
    status: import_smithy_client._json
  });
}, "se_ListServiceDeploymentsRequest");
var se_MemoryGiBPerVCpuRequest = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    max: import_smithy_client.serializeFloat,
    min: import_smithy_client.serializeFloat
  });
}, "se_MemoryGiBPerVCpuRequest");
var se_NetworkBandwidthGbpsRequest = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    max: import_smithy_client.serializeFloat,
    min: import_smithy_client.serializeFloat
  });
}, "se_NetworkBandwidthGbpsRequest");
var se_RegisterContainerInstanceRequest = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    attributes: import_smithy_client._json,
    cluster: [],
    containerInstanceArn: [],
    instanceIdentityDocument: [],
    instanceIdentityDocumentSignature: [],
    platformDevices: import_smithy_client._json,
    tags: import_smithy_client._json,
    totalResources: /* @__PURE__ */ __name((_) => se_Resources(_, context), "totalResources"),
    versionInfo: import_smithy_client._json
  });
}, "se_RegisterContainerInstanceRequest");
var se_Resource = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    doubleValue: import_smithy_client.serializeFloat,
    integerValue: [],
    longValue: [],
    name: [],
    stringSetValue: import_smithy_client._json,
    type: []
  });
}, "se_Resource");
var se_Resources = /* @__PURE__ */ __name((input, context) => {
  return input.filter((e) => e != null).map((entry) => {
    return se_Resource(entry, context);
  });
}, "se_Resources");
var se_RunTaskRequest = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    capacityProviderStrategy: import_smithy_client._json,
    clientToken: [true, (_) => _ ?? (0, import_uuid.v4)()],
    cluster: [],
    count: [],
    enableECSManagedTags: [],
    enableExecuteCommand: [],
    group: [],
    launchType: [],
    networkConfiguration: import_smithy_client._json,
    overrides: import_smithy_client._json,
    placementConstraints: import_smithy_client._json,
    placementStrategy: import_smithy_client._json,
    platformVersion: [],
    propagateTags: [],
    referenceId: [],
    startedBy: [],
    tags: import_smithy_client._json,
    taskDefinition: [],
    volumeConfigurations: import_smithy_client._json
  });
}, "se_RunTaskRequest");
var se_Scale = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    unit: [],
    value: import_smithy_client.serializeFloat
  });
}, "se_Scale");
var se_SubmitTaskStateChangeRequest = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    attachments: import_smithy_client._json,
    cluster: [],
    containers: import_smithy_client._json,
    executionStoppedAt: /* @__PURE__ */ __name((_) => _.getTime() / 1e3, "executionStoppedAt"),
    managedAgents: import_smithy_client._json,
    pullStartedAt: /* @__PURE__ */ __name((_) => _.getTime() / 1e3, "pullStartedAt"),
    pullStoppedAt: /* @__PURE__ */ __name((_) => _.getTime() / 1e3, "pullStoppedAt"),
    reason: [],
    status: [],
    task: []
  });
}, "se_SubmitTaskStateChangeRequest");
var se_TotalLocalStorageGBRequest = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    max: import_smithy_client.serializeFloat,
    min: import_smithy_client.serializeFloat
  });
}, "se_TotalLocalStorageGBRequest");
var se_UpdateCapacityProviderRequest = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    autoScalingGroupProvider: import_smithy_client._json,
    cluster: [],
    managedInstancesProvider: /* @__PURE__ */ __name((_) => se_UpdateManagedInstancesProviderConfiguration(_, context), "managedInstancesProvider"),
    name: []
  });
}, "se_UpdateCapacityProviderRequest");
var se_UpdateManagedInstancesProviderConfiguration = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    infrastructureRoleArn: [],
    instanceLaunchTemplate: /* @__PURE__ */ __name((_) => se_InstanceLaunchTemplateUpdate(_, context), "instanceLaunchTemplate"),
    propagateTags: []
  });
}, "se_UpdateManagedInstancesProviderConfiguration");
var se_UpdateServiceRequest = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    availabilityZoneRebalancing: [],
    capacityProviderStrategy: import_smithy_client._json,
    cluster: [],
    deploymentConfiguration: /* @__PURE__ */ __name((_) => se_DeploymentConfiguration(_, context), "deploymentConfiguration"),
    deploymentController: import_smithy_client._json,
    desiredCount: [],
    enableECSManagedTags: [],
    enableExecuteCommand: [],
    forceNewDeployment: [],
    healthCheckGracePeriodSeconds: [],
    loadBalancers: import_smithy_client._json,
    networkConfiguration: import_smithy_client._json,
    placementConstraints: import_smithy_client._json,
    placementStrategy: import_smithy_client._json,
    platformVersion: [],
    propagateTags: [],
    service: [],
    serviceConnectConfiguration: import_smithy_client._json,
    serviceRegistries: import_smithy_client._json,
    taskDefinition: [],
    volumeConfigurations: import_smithy_client._json,
    vpcLatticeConfigurations: import_smithy_client._json
  });
}, "se_UpdateServiceRequest");
var se_UpdateTaskSetRequest = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    cluster: [],
    scale: /* @__PURE__ */ __name((_) => se_Scale(_, context), "scale"),
    service: [],
    taskSet: []
  });
}, "se_UpdateTaskSetRequest");
var de_CapacityProvider = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    autoScalingGroupProvider: import_smithy_client._json,
    capacityProviderArn: import_smithy_client.expectString,
    cluster: import_smithy_client.expectString,
    managedInstancesProvider: /* @__PURE__ */ __name((_) => de_ManagedInstancesProvider(_, context), "managedInstancesProvider"),
    name: import_smithy_client.expectString,
    status: import_smithy_client.expectString,
    tags: import_smithy_client._json,
    type: import_smithy_client.expectString,
    updateStatus: import_smithy_client.expectString,
    updateStatusReason: import_smithy_client.expectString
  });
}, "de_CapacityProvider");
var de_CapacityProviders = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_CapacityProvider(entry, context);
  });
  return retVal;
}, "de_CapacityProviders");
var de_Container = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    containerArn: import_smithy_client.expectString,
    cpu: import_smithy_client.expectString,
    exitCode: import_smithy_client.expectInt32,
    gpuIds: import_smithy_client._json,
    healthStatus: import_smithy_client.expectString,
    image: import_smithy_client.expectString,
    imageDigest: import_smithy_client.expectString,
    lastStatus: import_smithy_client.expectString,
    managedAgents: /* @__PURE__ */ __name((_) => de_ManagedAgents(_, context), "managedAgents"),
    memory: import_smithy_client.expectString,
    memoryReservation: import_smithy_client.expectString,
    name: import_smithy_client.expectString,
    networkBindings: import_smithy_client._json,
    networkInterfaces: import_smithy_client._json,
    reason: import_smithy_client.expectString,
    runtimeId: import_smithy_client.expectString,
    taskArn: import_smithy_client.expectString
  });
}, "de_Container");
var de_ContainerInstance = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    agentConnected: import_smithy_client.expectBoolean,
    agentUpdateStatus: import_smithy_client.expectString,
    attachments: import_smithy_client._json,
    attributes: import_smithy_client._json,
    capacityProviderName: import_smithy_client.expectString,
    containerInstanceArn: import_smithy_client.expectString,
    ec2InstanceId: import_smithy_client.expectString,
    healthStatus: /* @__PURE__ */ __name((_) => de_ContainerInstanceHealthStatus(_, context), "healthStatus"),
    pendingTasksCount: import_smithy_client.expectInt32,
    registeredAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "registeredAt"),
    registeredResources: /* @__PURE__ */ __name((_) => de_Resources(_, context), "registeredResources"),
    remainingResources: /* @__PURE__ */ __name((_) => de_Resources(_, context), "remainingResources"),
    runningTasksCount: import_smithy_client.expectInt32,
    status: import_smithy_client.expectString,
    statusReason: import_smithy_client.expectString,
    tags: import_smithy_client._json,
    version: import_smithy_client.expectLong,
    versionInfo: import_smithy_client._json
  });
}, "de_ContainerInstance");
var de_ContainerInstanceHealthStatus = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    details: /* @__PURE__ */ __name((_) => de_InstanceHealthCheckResultList(_, context), "details"),
    overallStatus: import_smithy_client.expectString
  });
}, "de_ContainerInstanceHealthStatus");
var de_ContainerInstances = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_ContainerInstance(entry, context);
  });
  return retVal;
}, "de_ContainerInstances");
var de_Containers = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_Container(entry, context);
  });
  return retVal;
}, "de_Containers");
var de_CreateCapacityProviderResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    capacityProvider: /* @__PURE__ */ __name((_) => de_CapacityProvider(_, context), "capacityProvider")
  });
}, "de_CreateCapacityProviderResponse");
var de_CreateServiceResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    service: /* @__PURE__ */ __name((_) => de_Service(_, context), "service")
  });
}, "de_CreateServiceResponse");
var de_CreateTaskSetResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    taskSet: /* @__PURE__ */ __name((_) => de_TaskSet(_, context), "taskSet")
  });
}, "de_CreateTaskSetResponse");
var de_DeleteCapacityProviderResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    capacityProvider: /* @__PURE__ */ __name((_) => de_CapacityProvider(_, context), "capacityProvider")
  });
}, "de_DeleteCapacityProviderResponse");
var de_DeleteServiceResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    service: /* @__PURE__ */ __name((_) => de_Service(_, context), "service")
  });
}, "de_DeleteServiceResponse");
var de_DeleteTaskDefinitionsResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    failures: import_smithy_client._json,
    taskDefinitions: /* @__PURE__ */ __name((_) => de_TaskDefinitionList(_, context), "taskDefinitions")
  });
}, "de_DeleteTaskDefinitionsResponse");
var de_DeleteTaskSetResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    taskSet: /* @__PURE__ */ __name((_) => de_TaskSet(_, context), "taskSet")
  });
}, "de_DeleteTaskSetResponse");
var de_Deployment = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    capacityProviderStrategy: import_smithy_client._json,
    createdAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "createdAt"),
    desiredCount: import_smithy_client.expectInt32,
    failedTasks: import_smithy_client.expectInt32,
    fargateEphemeralStorage: import_smithy_client._json,
    id: import_smithy_client.expectString,
    launchType: import_smithy_client.expectString,
    networkConfiguration: import_smithy_client._json,
    pendingCount: import_smithy_client.expectInt32,
    platformFamily: import_smithy_client.expectString,
    platformVersion: import_smithy_client.expectString,
    rolloutState: import_smithy_client.expectString,
    rolloutStateReason: import_smithy_client.expectString,
    runningCount: import_smithy_client.expectInt32,
    serviceConnectConfiguration: import_smithy_client._json,
    serviceConnectResources: import_smithy_client._json,
    status: import_smithy_client.expectString,
    taskDefinition: import_smithy_client.expectString,
    updatedAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "updatedAt"),
    volumeConfigurations: import_smithy_client._json,
    vpcLatticeConfigurations: import_smithy_client._json
  });
}, "de_Deployment");
var de_DeploymentConfiguration = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    alarms: import_smithy_client._json,
    bakeTimeInMinutes: import_smithy_client.expectInt32,
    deploymentCircuitBreaker: import_smithy_client._json,
    lifecycleHooks: /* @__PURE__ */ __name((_) => de_DeploymentLifecycleHookList(_, context), "lifecycleHooks"),
    maximumPercent: import_smithy_client.expectInt32,
    minimumHealthyPercent: import_smithy_client.expectInt32,
    strategy: import_smithy_client.expectString
  });
}, "de_DeploymentConfiguration");
var de_DeploymentLifecycleHook = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    hookDetails: /* @__PURE__ */ __name((_) => de_HookDetails(_, context), "hookDetails"),
    hookTargetArn: import_smithy_client.expectString,
    lifecycleStages: import_smithy_client._json,
    roleArn: import_smithy_client.expectString
  });
}, "de_DeploymentLifecycleHook");
var de_DeploymentLifecycleHookList = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_DeploymentLifecycleHook(entry, context);
  });
  return retVal;
}, "de_DeploymentLifecycleHookList");
var de_Deployments = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_Deployment(entry, context);
  });
  return retVal;
}, "de_Deployments");
var de_DeregisterContainerInstanceResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    containerInstance: /* @__PURE__ */ __name((_) => de_ContainerInstance(_, context), "containerInstance")
  });
}, "de_DeregisterContainerInstanceResponse");
var de_DeregisterTaskDefinitionResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    taskDefinition: /* @__PURE__ */ __name((_) => de_TaskDefinition(_, context), "taskDefinition")
  });
}, "de_DeregisterTaskDefinitionResponse");
var de_DescribeCapacityProvidersResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    capacityProviders: /* @__PURE__ */ __name((_) => de_CapacityProviders(_, context), "capacityProviders"),
    failures: import_smithy_client._json,
    nextToken: import_smithy_client.expectString
  });
}, "de_DescribeCapacityProvidersResponse");
var de_DescribeContainerInstancesResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    containerInstances: /* @__PURE__ */ __name((_) => de_ContainerInstances(_, context), "containerInstances"),
    failures: import_smithy_client._json
  });
}, "de_DescribeContainerInstancesResponse");
var de_DescribeServiceDeploymentsResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    failures: import_smithy_client._json,
    serviceDeployments: /* @__PURE__ */ __name((_) => de_ServiceDeployments(_, context), "serviceDeployments")
  });
}, "de_DescribeServiceDeploymentsResponse");
var de_DescribeServiceRevisionsResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    failures: import_smithy_client._json,
    serviceRevisions: /* @__PURE__ */ __name((_) => de_ServiceRevisions(_, context), "serviceRevisions")
  });
}, "de_DescribeServiceRevisionsResponse");
var de_DescribeServicesResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    failures: import_smithy_client._json,
    services: /* @__PURE__ */ __name((_) => de_Services(_, context), "services")
  });
}, "de_DescribeServicesResponse");
var de_DescribeTaskDefinitionResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    tags: import_smithy_client._json,
    taskDefinition: /* @__PURE__ */ __name((_) => de_TaskDefinition(_, context), "taskDefinition")
  });
}, "de_DescribeTaskDefinitionResponse");
var de_DescribeTaskSetsResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    failures: import_smithy_client._json,
    taskSets: /* @__PURE__ */ __name((_) => de_TaskSets(_, context), "taskSets")
  });
}, "de_DescribeTaskSetsResponse");
var de_DescribeTasksResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    failures: import_smithy_client._json,
    tasks: /* @__PURE__ */ __name((_) => de_Tasks(_, context), "tasks")
  });
}, "de_DescribeTasksResponse");
var de_GetTaskProtectionResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    failures: import_smithy_client._json,
    protectedTasks: /* @__PURE__ */ __name((_) => de_ProtectedTasks(_, context), "protectedTasks")
  });
}, "de_GetTaskProtectionResponse");
var de_HookDetails = /* @__PURE__ */ __name((output, context) => {
  return output;
}, "de_HookDetails");
var de_InstanceHealthCheckResult = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    lastStatusChange: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "lastStatusChange"),
    lastUpdated: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "lastUpdated"),
    status: import_smithy_client.expectString,
    type: import_smithy_client.expectString
  });
}, "de_InstanceHealthCheckResult");
var de_InstanceHealthCheckResultList = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_InstanceHealthCheckResult(entry, context);
  });
  return retVal;
}, "de_InstanceHealthCheckResultList");
var de_InstanceLaunchTemplate = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    ec2InstanceProfileArn: import_smithy_client.expectString,
    instanceRequirements: /* @__PURE__ */ __name((_) => de_InstanceRequirementsRequest(_, context), "instanceRequirements"),
    monitoring: import_smithy_client.expectString,
    networkConfiguration: import_smithy_client._json,
    storageConfiguration: import_smithy_client._json
  });
}, "de_InstanceLaunchTemplate");
var de_InstanceRequirementsRequest = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    acceleratorCount: import_smithy_client._json,
    acceleratorManufacturers: import_smithy_client._json,
    acceleratorNames: import_smithy_client._json,
    acceleratorTotalMemoryMiB: import_smithy_client._json,
    acceleratorTypes: import_smithy_client._json,
    allowedInstanceTypes: import_smithy_client._json,
    bareMetal: import_smithy_client.expectString,
    baselineEbsBandwidthMbps: import_smithy_client._json,
    burstablePerformance: import_smithy_client.expectString,
    cpuManufacturers: import_smithy_client._json,
    excludedInstanceTypes: import_smithy_client._json,
    instanceGenerations: import_smithy_client._json,
    localStorage: import_smithy_client.expectString,
    localStorageTypes: import_smithy_client._json,
    maxSpotPriceAsPercentageOfOptimalOnDemandPrice: import_smithy_client.expectInt32,
    memoryGiBPerVCpu: /* @__PURE__ */ __name((_) => de_MemoryGiBPerVCpuRequest(_, context), "memoryGiBPerVCpu"),
    memoryMiB: import_smithy_client._json,
    networkBandwidthGbps: /* @__PURE__ */ __name((_) => de_NetworkBandwidthGbpsRequest(_, context), "networkBandwidthGbps"),
    networkInterfaceCount: import_smithy_client._json,
    onDemandMaxPricePercentageOverLowestPrice: import_smithy_client.expectInt32,
    requireHibernateSupport: import_smithy_client.expectBoolean,
    spotMaxPricePercentageOverLowestPrice: import_smithy_client.expectInt32,
    totalLocalStorageGB: /* @__PURE__ */ __name((_) => de_TotalLocalStorageGBRequest(_, context), "totalLocalStorageGB"),
    vCpuCount: import_smithy_client._json
  });
}, "de_InstanceRequirementsRequest");
var de_ListServiceDeploymentsResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    nextToken: import_smithy_client.expectString,
    serviceDeployments: /* @__PURE__ */ __name((_) => de_ServiceDeploymentsBrief(_, context), "serviceDeployments")
  });
}, "de_ListServiceDeploymentsResponse");
var de_ManagedAgent = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    lastStartedAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "lastStartedAt"),
    lastStatus: import_smithy_client.expectString,
    name: import_smithy_client.expectString,
    reason: import_smithy_client.expectString
  });
}, "de_ManagedAgent");
var de_ManagedAgents = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_ManagedAgent(entry, context);
  });
  return retVal;
}, "de_ManagedAgents");
var de_ManagedInstancesProvider = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    infrastructureRoleArn: import_smithy_client.expectString,
    instanceLaunchTemplate: /* @__PURE__ */ __name((_) => de_InstanceLaunchTemplate(_, context), "instanceLaunchTemplate"),
    propagateTags: import_smithy_client.expectString
  });
}, "de_ManagedInstancesProvider");
var de_MemoryGiBPerVCpuRequest = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    max: import_smithy_client.limitedParseDouble,
    min: import_smithy_client.limitedParseDouble
  });
}, "de_MemoryGiBPerVCpuRequest");
var de_NetworkBandwidthGbpsRequest = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    max: import_smithy_client.limitedParseDouble,
    min: import_smithy_client.limitedParseDouble
  });
}, "de_NetworkBandwidthGbpsRequest");
var de_ProtectedTask = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    expirationDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "expirationDate"),
    protectionEnabled: import_smithy_client.expectBoolean,
    taskArn: import_smithy_client.expectString
  });
}, "de_ProtectedTask");
var de_ProtectedTasks = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_ProtectedTask(entry, context);
  });
  return retVal;
}, "de_ProtectedTasks");
var de_RegisterContainerInstanceResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    containerInstance: /* @__PURE__ */ __name((_) => de_ContainerInstance(_, context), "containerInstance")
  });
}, "de_RegisterContainerInstanceResponse");
var de_RegisterTaskDefinitionResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    tags: import_smithy_client._json,
    taskDefinition: /* @__PURE__ */ __name((_) => de_TaskDefinition(_, context), "taskDefinition")
  });
}, "de_RegisterTaskDefinitionResponse");
var de_Resource = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    doubleValue: import_smithy_client.limitedParseDouble,
    integerValue: import_smithy_client.expectInt32,
    longValue: import_smithy_client.expectLong,
    name: import_smithy_client.expectString,
    stringSetValue: import_smithy_client._json,
    type: import_smithy_client.expectString
  });
}, "de_Resource");
var de_Resources = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_Resource(entry, context);
  });
  return retVal;
}, "de_Resources");
var de_Rollback = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    reason: import_smithy_client.expectString,
    serviceRevisionArn: import_smithy_client.expectString,
    startedAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "startedAt")
  });
}, "de_Rollback");
var de_RunTaskResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    failures: import_smithy_client._json,
    tasks: /* @__PURE__ */ __name((_) => de_Tasks(_, context), "tasks")
  });
}, "de_RunTaskResponse");
var de_Scale = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    unit: import_smithy_client.expectString,
    value: import_smithy_client.limitedParseDouble
  });
}, "de_Scale");
var de_Service = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    availabilityZoneRebalancing: import_smithy_client.expectString,
    capacityProviderStrategy: import_smithy_client._json,
    clusterArn: import_smithy_client.expectString,
    createdAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "createdAt"),
    createdBy: import_smithy_client.expectString,
    deploymentConfiguration: /* @__PURE__ */ __name((_) => de_DeploymentConfiguration(_, context), "deploymentConfiguration"),
    deploymentController: import_smithy_client._json,
    deployments: /* @__PURE__ */ __name((_) => de_Deployments(_, context), "deployments"),
    desiredCount: import_smithy_client.expectInt32,
    enableECSManagedTags: import_smithy_client.expectBoolean,
    enableExecuteCommand: import_smithy_client.expectBoolean,
    events: /* @__PURE__ */ __name((_) => de_ServiceEvents(_, context), "events"),
    healthCheckGracePeriodSeconds: import_smithy_client.expectInt32,
    launchType: import_smithy_client.expectString,
    loadBalancers: import_smithy_client._json,
    networkConfiguration: import_smithy_client._json,
    pendingCount: import_smithy_client.expectInt32,
    placementConstraints: import_smithy_client._json,
    placementStrategy: import_smithy_client._json,
    platformFamily: import_smithy_client.expectString,
    platformVersion: import_smithy_client.expectString,
    propagateTags: import_smithy_client.expectString,
    roleArn: import_smithy_client.expectString,
    runningCount: import_smithy_client.expectInt32,
    schedulingStrategy: import_smithy_client.expectString,
    serviceArn: import_smithy_client.expectString,
    serviceName: import_smithy_client.expectString,
    serviceRegistries: import_smithy_client._json,
    status: import_smithy_client.expectString,
    tags: import_smithy_client._json,
    taskDefinition: import_smithy_client.expectString,
    taskSets: /* @__PURE__ */ __name((_) => de_TaskSets(_, context), "taskSets")
  });
}, "de_Service");
var de_ServiceDeployment = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    alarms: import_smithy_client._json,
    clusterArn: import_smithy_client.expectString,
    createdAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "createdAt"),
    deploymentCircuitBreaker: import_smithy_client._json,
    deploymentConfiguration: /* @__PURE__ */ __name((_) => de_DeploymentConfiguration(_, context), "deploymentConfiguration"),
    finishedAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "finishedAt"),
    lifecycleStage: import_smithy_client.expectString,
    rollback: /* @__PURE__ */ __name((_) => de_Rollback(_, context), "rollback"),
    serviceArn: import_smithy_client.expectString,
    serviceDeploymentArn: import_smithy_client.expectString,
    sourceServiceRevisions: import_smithy_client._json,
    startedAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "startedAt"),
    status: import_smithy_client.expectString,
    statusReason: import_smithy_client.expectString,
    stoppedAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "stoppedAt"),
    targetServiceRevision: import_smithy_client._json,
    updatedAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "updatedAt")
  });
}, "de_ServiceDeployment");
var de_ServiceDeploymentBrief = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    clusterArn: import_smithy_client.expectString,
    createdAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "createdAt"),
    finishedAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "finishedAt"),
    serviceArn: import_smithy_client.expectString,
    serviceDeploymentArn: import_smithy_client.expectString,
    startedAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "startedAt"),
    status: import_smithy_client.expectString,
    statusReason: import_smithy_client.expectString,
    targetServiceRevisionArn: import_smithy_client.expectString
  });
}, "de_ServiceDeploymentBrief");
var de_ServiceDeployments = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_ServiceDeployment(entry, context);
  });
  return retVal;
}, "de_ServiceDeployments");
var de_ServiceDeploymentsBrief = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_ServiceDeploymentBrief(entry, context);
  });
  return retVal;
}, "de_ServiceDeploymentsBrief");
var de_ServiceEvent = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    createdAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "createdAt"),
    id: import_smithy_client.expectString,
    message: import_smithy_client.expectString
  });
}, "de_ServiceEvent");
var de_ServiceEvents = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_ServiceEvent(entry, context);
  });
  return retVal;
}, "de_ServiceEvents");
var de_ServiceRevision = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    capacityProviderStrategy: import_smithy_client._json,
    clusterArn: import_smithy_client.expectString,
    containerImages: import_smithy_client._json,
    createdAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "createdAt"),
    fargateEphemeralStorage: import_smithy_client._json,
    guardDutyEnabled: import_smithy_client.expectBoolean,
    launchType: import_smithy_client.expectString,
    loadBalancers: import_smithy_client._json,
    networkConfiguration: import_smithy_client._json,
    platformFamily: import_smithy_client.expectString,
    platformVersion: import_smithy_client.expectString,
    resolvedConfiguration: import_smithy_client._json,
    serviceArn: import_smithy_client.expectString,
    serviceConnectConfiguration: import_smithy_client._json,
    serviceRegistries: import_smithy_client._json,
    serviceRevisionArn: import_smithy_client.expectString,
    taskDefinition: import_smithy_client.expectString,
    volumeConfigurations: import_smithy_client._json,
    vpcLatticeConfigurations: import_smithy_client._json
  });
}, "de_ServiceRevision");
var de_ServiceRevisions = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_ServiceRevision(entry, context);
  });
  return retVal;
}, "de_ServiceRevisions");
var de_Services = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_Service(entry, context);
  });
  return retVal;
}, "de_Services");
var de_StartTaskResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    failures: import_smithy_client._json,
    tasks: /* @__PURE__ */ __name((_) => de_Tasks(_, context), "tasks")
  });
}, "de_StartTaskResponse");
var de_StopTaskResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    task: /* @__PURE__ */ __name((_) => de_Task(_, context), "task")
  });
}, "de_StopTaskResponse");
var de_Task = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    attachments: import_smithy_client._json,
    attributes: import_smithy_client._json,
    availabilityZone: import_smithy_client.expectString,
    capacityProviderName: import_smithy_client.expectString,
    clusterArn: import_smithy_client.expectString,
    connectivity: import_smithy_client.expectString,
    connectivityAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "connectivityAt"),
    containerInstanceArn: import_smithy_client.expectString,
    containers: /* @__PURE__ */ __name((_) => de_Containers(_, context), "containers"),
    cpu: import_smithy_client.expectString,
    createdAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "createdAt"),
    desiredStatus: import_smithy_client.expectString,
    enableExecuteCommand: import_smithy_client.expectBoolean,
    ephemeralStorage: import_smithy_client._json,
    executionStoppedAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "executionStoppedAt"),
    fargateEphemeralStorage: import_smithy_client._json,
    group: import_smithy_client.expectString,
    healthStatus: import_smithy_client.expectString,
    inferenceAccelerators: import_smithy_client._json,
    lastStatus: import_smithy_client.expectString,
    launchType: import_smithy_client.expectString,
    memory: import_smithy_client.expectString,
    overrides: import_smithy_client._json,
    platformFamily: import_smithy_client.expectString,
    platformVersion: import_smithy_client.expectString,
    pullStartedAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "pullStartedAt"),
    pullStoppedAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "pullStoppedAt"),
    startedAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "startedAt"),
    startedBy: import_smithy_client.expectString,
    stopCode: import_smithy_client.expectString,
    stoppedAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "stoppedAt"),
    stoppedReason: import_smithy_client.expectString,
    stoppingAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "stoppingAt"),
    tags: import_smithy_client._json,
    taskArn: import_smithy_client.expectString,
    taskDefinitionArn: import_smithy_client.expectString,
    version: import_smithy_client.expectLong
  });
}, "de_Task");
var de_TaskDefinition = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    compatibilities: import_smithy_client._json,
    containerDefinitions: import_smithy_client._json,
    cpu: import_smithy_client.expectString,
    deregisteredAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "deregisteredAt"),
    enableFaultInjection: import_smithy_client.expectBoolean,
    ephemeralStorage: import_smithy_client._json,
    executionRoleArn: import_smithy_client.expectString,
    family: import_smithy_client.expectString,
    inferenceAccelerators: import_smithy_client._json,
    ipcMode: import_smithy_client.expectString,
    memory: import_smithy_client.expectString,
    networkMode: import_smithy_client.expectString,
    pidMode: import_smithy_client.expectString,
    placementConstraints: import_smithy_client._json,
    proxyConfiguration: import_smithy_client._json,
    registeredAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "registeredAt"),
    registeredBy: import_smithy_client.expectString,
    requiresAttributes: import_smithy_client._json,
    requiresCompatibilities: import_smithy_client._json,
    revision: import_smithy_client.expectInt32,
    runtimePlatform: import_smithy_client._json,
    status: import_smithy_client.expectString,
    taskDefinitionArn: import_smithy_client.expectString,
    taskRoleArn: import_smithy_client.expectString,
    volumes: import_smithy_client._json
  });
}, "de_TaskDefinition");
var de_TaskDefinitionList = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_TaskDefinition(entry, context);
  });
  return retVal;
}, "de_TaskDefinitionList");
var de_Tasks = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_Task(entry, context);
  });
  return retVal;
}, "de_Tasks");
var de_TaskSet = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    capacityProviderStrategy: import_smithy_client._json,
    clusterArn: import_smithy_client.expectString,
    computedDesiredCount: import_smithy_client.expectInt32,
    createdAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "createdAt"),
    externalId: import_smithy_client.expectString,
    fargateEphemeralStorage: import_smithy_client._json,
    id: import_smithy_client.expectString,
    launchType: import_smithy_client.expectString,
    loadBalancers: import_smithy_client._json,
    networkConfiguration: import_smithy_client._json,
    pendingCount: import_smithy_client.expectInt32,
    platformFamily: import_smithy_client.expectString,
    platformVersion: import_smithy_client.expectString,
    runningCount: import_smithy_client.expectInt32,
    scale: /* @__PURE__ */ __name((_) => de_Scale(_, context), "scale"),
    serviceArn: import_smithy_client.expectString,
    serviceRegistries: import_smithy_client._json,
    stabilityStatus: import_smithy_client.expectString,
    stabilityStatusAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "stabilityStatusAt"),
    startedBy: import_smithy_client.expectString,
    status: import_smithy_client.expectString,
    tags: import_smithy_client._json,
    taskDefinition: import_smithy_client.expectString,
    taskSetArn: import_smithy_client.expectString,
    updatedAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "updatedAt")
  });
}, "de_TaskSet");
var de_TaskSets = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_TaskSet(entry, context);
  });
  return retVal;
}, "de_TaskSets");
var de_TotalLocalStorageGBRequest = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    max: import_smithy_client.limitedParseDouble,
    min: import_smithy_client.limitedParseDouble
  });
}, "de_TotalLocalStorageGBRequest");
var de_UpdateCapacityProviderResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    capacityProvider: /* @__PURE__ */ __name((_) => de_CapacityProvider(_, context), "capacityProvider")
  });
}, "de_UpdateCapacityProviderResponse");
var de_UpdateContainerAgentResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    containerInstance: /* @__PURE__ */ __name((_) => de_ContainerInstance(_, context), "containerInstance")
  });
}, "de_UpdateContainerAgentResponse");
var de_UpdateContainerInstancesStateResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    containerInstances: /* @__PURE__ */ __name((_) => de_ContainerInstances(_, context), "containerInstances"),
    failures: import_smithy_client._json
  });
}, "de_UpdateContainerInstancesStateResponse");
var de_UpdateServicePrimaryTaskSetResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    taskSet: /* @__PURE__ */ __name((_) => de_TaskSet(_, context), "taskSet")
  });
}, "de_UpdateServicePrimaryTaskSetResponse");
var de_UpdateServiceResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    service: /* @__PURE__ */ __name((_) => de_Service(_, context), "service")
  });
}, "de_UpdateServiceResponse");
var de_UpdateTaskProtectionResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    failures: import_smithy_client._json,
    protectedTasks: /* @__PURE__ */ __name((_) => de_ProtectedTasks(_, context), "protectedTasks")
  });
}, "de_UpdateTaskProtectionResponse");
var de_UpdateTaskSetResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    taskSet: /* @__PURE__ */ __name((_) => de_TaskSet(_, context), "taskSet")
  });
}, "de_UpdateTaskSetResponse");
var deserializeMetadata = /* @__PURE__ */ __name((output) => ({
  httpStatusCode: output.statusCode,
  requestId: output.headers["x-amzn-requestid"] ?? output.headers["x-amzn-request-id"] ?? output.headers["x-amz-request-id"],
  extendedRequestId: output.headers["x-amz-id-2"],
  cfId: output.headers["x-amz-cf-id"]
}), "deserializeMetadata");
var throwDefaultError = (0, import_smithy_client.withBaseException)(ECSServiceException);
var buildHttpRpcRequest = /* @__PURE__ */ __name(async (context, headers, path, resolvedHostname, body) => {
  const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
  const contents = {
    protocol,
    hostname,
    port,
    method: "POST",
    path: basePath.endsWith("/") ? basePath.slice(0, -1) + path : basePath + path,
    headers
  };
  if (resolvedHostname !== void 0) {
    contents.hostname = resolvedHostname;
  }
  if (body !== void 0) {
    contents.body = body;
  }
  return new import_protocol_http.HttpRequest(contents);
}, "buildHttpRpcRequest");
function sharedHeaders(operation) {
  return {
    "content-type": "application/x-amz-json-1.1",
    "x-amz-target": `AmazonEC2ContainerServiceV20141113.${operation}`
  };
}
__name(sharedHeaders, "sharedHeaders");

// src/commands/CreateCapacityProviderCommand.ts
var CreateCapacityProviderCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonEC2ContainerServiceV20141113", "CreateCapacityProvider", {}).n("ECSClient", "CreateCapacityProviderCommand").f(void 0, void 0).ser(se_CreateCapacityProviderCommand).de(de_CreateCapacityProviderCommand).build() {
  static {
    __name(this, "CreateCapacityProviderCommand");
  }
};

// src/commands/CreateClusterCommand.ts



var CreateClusterCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonEC2ContainerServiceV20141113", "CreateCluster", {}).n("ECSClient", "CreateClusterCommand").f(void 0, void 0).ser(se_CreateClusterCommand).de(de_CreateClusterCommand).build() {
  static {
    __name(this, "CreateClusterCommand");
  }
};

// src/commands/CreateServiceCommand.ts



var CreateServiceCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonEC2ContainerServiceV20141113", "CreateService", {}).n("ECSClient", "CreateServiceCommand").f(void 0, void 0).ser(se_CreateServiceCommand).de(de_CreateServiceCommand).build() {
  static {
    __name(this, "CreateServiceCommand");
  }
};

// src/commands/CreateTaskSetCommand.ts



var CreateTaskSetCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonEC2ContainerServiceV20141113", "CreateTaskSet", {}).n("ECSClient", "CreateTaskSetCommand").f(void 0, void 0).ser(se_CreateTaskSetCommand).de(de_CreateTaskSetCommand).build() {
  static {
    __name(this, "CreateTaskSetCommand");
  }
};

// src/commands/DeleteAccountSettingCommand.ts



var DeleteAccountSettingCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonEC2ContainerServiceV20141113", "DeleteAccountSetting", {}).n("ECSClient", "DeleteAccountSettingCommand").f(void 0, void 0).ser(se_DeleteAccountSettingCommand).de(de_DeleteAccountSettingCommand).build() {
  static {
    __name(this, "DeleteAccountSettingCommand");
  }
};

// src/commands/DeleteAttributesCommand.ts



var DeleteAttributesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonEC2ContainerServiceV20141113", "DeleteAttributes", {}).n("ECSClient", "DeleteAttributesCommand").f(void 0, void 0).ser(se_DeleteAttributesCommand).de(de_DeleteAttributesCommand).build() {
  static {
    __name(this, "DeleteAttributesCommand");
  }
};

// src/commands/DeleteCapacityProviderCommand.ts



var DeleteCapacityProviderCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonEC2ContainerServiceV20141113", "DeleteCapacityProvider", {}).n("ECSClient", "DeleteCapacityProviderCommand").f(void 0, void 0).ser(se_DeleteCapacityProviderCommand).de(de_DeleteCapacityProviderCommand).build() {
  static {
    __name(this, "DeleteCapacityProviderCommand");
  }
};

// src/commands/DeleteClusterCommand.ts



var DeleteClusterCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonEC2ContainerServiceV20141113", "DeleteCluster", {}).n("ECSClient", "DeleteClusterCommand").f(void 0, void 0).ser(se_DeleteClusterCommand).de(de_DeleteClusterCommand).build() {
  static {
    __name(this, "DeleteClusterCommand");
  }
};

// src/commands/DeleteServiceCommand.ts



var DeleteServiceCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonEC2ContainerServiceV20141113", "DeleteService", {}).n("ECSClient", "DeleteServiceCommand").f(void 0, void 0).ser(se_DeleteServiceCommand).de(de_DeleteServiceCommand).build() {
  static {
    __name(this, "DeleteServiceCommand");
  }
};

// src/commands/DeleteTaskDefinitionsCommand.ts



var DeleteTaskDefinitionsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonEC2ContainerServiceV20141113", "DeleteTaskDefinitions", {}).n("ECSClient", "DeleteTaskDefinitionsCommand").f(void 0, void 0).ser(se_DeleteTaskDefinitionsCommand).de(de_DeleteTaskDefinitionsCommand).build() {
  static {
    __name(this, "DeleteTaskDefinitionsCommand");
  }
};

// src/commands/DeleteTaskSetCommand.ts



var DeleteTaskSetCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonEC2ContainerServiceV20141113", "DeleteTaskSet", {}).n("ECSClient", "DeleteTaskSetCommand").f(void 0, void 0).ser(se_DeleteTaskSetCommand).de(de_DeleteTaskSetCommand).build() {
  static {
    __name(this, "DeleteTaskSetCommand");
  }
};

// src/commands/DeregisterContainerInstanceCommand.ts



var DeregisterContainerInstanceCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonEC2ContainerServiceV20141113", "DeregisterContainerInstance", {}).n("ECSClient", "DeregisterContainerInstanceCommand").f(void 0, void 0).ser(se_DeregisterContainerInstanceCommand).de(de_DeregisterContainerInstanceCommand).build() {
  static {
    __name(this, "DeregisterContainerInstanceCommand");
  }
};

// src/commands/DeregisterTaskDefinitionCommand.ts



var DeregisterTaskDefinitionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonEC2ContainerServiceV20141113", "DeregisterTaskDefinition", {}).n("ECSClient", "DeregisterTaskDefinitionCommand").f(void 0, void 0).ser(se_DeregisterTaskDefinitionCommand).de(de_DeregisterTaskDefinitionCommand).build() {
  static {
    __name(this, "DeregisterTaskDefinitionCommand");
  }
};

// src/commands/DescribeCapacityProvidersCommand.ts



var DescribeCapacityProvidersCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonEC2ContainerServiceV20141113", "DescribeCapacityProviders", {}).n("ECSClient", "DescribeCapacityProvidersCommand").f(void 0, void 0).ser(se_DescribeCapacityProvidersCommand).de(de_DescribeCapacityProvidersCommand).build() {
  static {
    __name(this, "DescribeCapacityProvidersCommand");
  }
};

// src/commands/DescribeClustersCommand.ts



var DescribeClustersCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonEC2ContainerServiceV20141113", "DescribeClusters", {}).n("ECSClient", "DescribeClustersCommand").f(void 0, void 0).ser(se_DescribeClustersCommand).de(de_DescribeClustersCommand).build() {
  static {
    __name(this, "DescribeClustersCommand");
  }
};

// src/commands/DescribeContainerInstancesCommand.ts



var DescribeContainerInstancesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonEC2ContainerServiceV20141113", "DescribeContainerInstances", {}).n("ECSClient", "DescribeContainerInstancesCommand").f(void 0, void 0).ser(se_DescribeContainerInstancesCommand).de(de_DescribeContainerInstancesCommand).build() {
  static {
    __name(this, "DescribeContainerInstancesCommand");
  }
};

// src/commands/DescribeServiceDeploymentsCommand.ts



var DescribeServiceDeploymentsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonEC2ContainerServiceV20141113", "DescribeServiceDeployments", {}).n("ECSClient", "DescribeServiceDeploymentsCommand").f(void 0, void 0).ser(se_DescribeServiceDeploymentsCommand).de(de_DescribeServiceDeploymentsCommand).build() {
  static {
    __name(this, "DescribeServiceDeploymentsCommand");
  }
};

// src/commands/DescribeServiceRevisionsCommand.ts



var DescribeServiceRevisionsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonEC2ContainerServiceV20141113", "DescribeServiceRevisions", {}).n("ECSClient", "DescribeServiceRevisionsCommand").f(void 0, void 0).ser(se_DescribeServiceRevisionsCommand).de(de_DescribeServiceRevisionsCommand).build() {
  static {
    __name(this, "DescribeServiceRevisionsCommand");
  }
};

// src/commands/DescribeServicesCommand.ts



var DescribeServicesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonEC2ContainerServiceV20141113", "DescribeServices", {}).n("ECSClient", "DescribeServicesCommand").f(void 0, void 0).ser(se_DescribeServicesCommand).de(de_DescribeServicesCommand).build() {
  static {
    __name(this, "DescribeServicesCommand");
  }
};

// src/commands/DescribeTaskDefinitionCommand.ts



var DescribeTaskDefinitionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonEC2ContainerServiceV20141113", "DescribeTaskDefinition", {}).n("ECSClient", "DescribeTaskDefinitionCommand").f(void 0, void 0).ser(se_DescribeTaskDefinitionCommand).de(de_DescribeTaskDefinitionCommand).build() {
  static {
    __name(this, "DescribeTaskDefinitionCommand");
  }
};

// src/commands/DescribeTasksCommand.ts



var DescribeTasksCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonEC2ContainerServiceV20141113", "DescribeTasks", {}).n("ECSClient", "DescribeTasksCommand").f(void 0, void 0).ser(se_DescribeTasksCommand).de(de_DescribeTasksCommand).build() {
  static {
    __name(this, "DescribeTasksCommand");
  }
};

// src/commands/DescribeTaskSetsCommand.ts



var DescribeTaskSetsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonEC2ContainerServiceV20141113", "DescribeTaskSets", {}).n("ECSClient", "DescribeTaskSetsCommand").f(void 0, void 0).ser(se_DescribeTaskSetsCommand).de(de_DescribeTaskSetsCommand).build() {
  static {
    __name(this, "DescribeTaskSetsCommand");
  }
};

// src/commands/DiscoverPollEndpointCommand.ts



var DiscoverPollEndpointCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonEC2ContainerServiceV20141113", "DiscoverPollEndpoint", {}).n("ECSClient", "DiscoverPollEndpointCommand").f(void 0, void 0).ser(se_DiscoverPollEndpointCommand).de(de_DiscoverPollEndpointCommand).build() {
  static {
    __name(this, "DiscoverPollEndpointCommand");
  }
};

// src/commands/ExecuteCommandCommand.ts



var ExecuteCommandCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonEC2ContainerServiceV20141113", "ExecuteCommand", {}).n("ECSClient", "ExecuteCommandCommand").f(void 0, ExecuteCommandResponseFilterSensitiveLog).ser(se_ExecuteCommandCommand).de(de_ExecuteCommandCommand).build() {
  static {
    __name(this, "ExecuteCommandCommand");
  }
};

// src/commands/GetTaskProtectionCommand.ts



var GetTaskProtectionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonEC2ContainerServiceV20141113", "GetTaskProtection", {}).n("ECSClient", "GetTaskProtectionCommand").f(void 0, void 0).ser(se_GetTaskProtectionCommand).de(de_GetTaskProtectionCommand).build() {
  static {
    __name(this, "GetTaskProtectionCommand");
  }
};

// src/commands/ListAccountSettingsCommand.ts



var ListAccountSettingsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonEC2ContainerServiceV20141113", "ListAccountSettings", {}).n("ECSClient", "ListAccountSettingsCommand").f(void 0, void 0).ser(se_ListAccountSettingsCommand).de(de_ListAccountSettingsCommand).build() {
  static {
    __name(this, "ListAccountSettingsCommand");
  }
};

// src/commands/ListAttributesCommand.ts



var ListAttributesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonEC2ContainerServiceV20141113", "ListAttributes", {}).n("ECSClient", "ListAttributesCommand").f(void 0, void 0).ser(se_ListAttributesCommand).de(de_ListAttributesCommand).build() {
  static {
    __name(this, "ListAttributesCommand");
  }
};

// src/commands/ListClustersCommand.ts



var ListClustersCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonEC2ContainerServiceV20141113", "ListClusters", {}).n("ECSClient", "ListClustersCommand").f(void 0, void 0).ser(se_ListClustersCommand).de(de_ListClustersCommand).build() {
  static {
    __name(this, "ListClustersCommand");
  }
};

// src/commands/ListContainerInstancesCommand.ts



var ListContainerInstancesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonEC2ContainerServiceV20141113", "ListContainerInstances", {}).n("ECSClient", "ListContainerInstancesCommand").f(void 0, void 0).ser(se_ListContainerInstancesCommand).de(de_ListContainerInstancesCommand).build() {
  static {
    __name(this, "ListContainerInstancesCommand");
  }
};

// src/commands/ListServiceDeploymentsCommand.ts



var ListServiceDeploymentsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonEC2ContainerServiceV20141113", "ListServiceDeployments", {}).n("ECSClient", "ListServiceDeploymentsCommand").f(void 0, void 0).ser(se_ListServiceDeploymentsCommand).de(de_ListServiceDeploymentsCommand).build() {
  static {
    __name(this, "ListServiceDeploymentsCommand");
  }
};

// src/commands/ListServicesByNamespaceCommand.ts



var ListServicesByNamespaceCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonEC2ContainerServiceV20141113", "ListServicesByNamespace", {}).n("ECSClient", "ListServicesByNamespaceCommand").f(void 0, void 0).ser(se_ListServicesByNamespaceCommand).de(de_ListServicesByNamespaceCommand).build() {
  static {
    __name(this, "ListServicesByNamespaceCommand");
  }
};

// src/commands/ListServicesCommand.ts



var ListServicesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonEC2ContainerServiceV20141113", "ListServices", {}).n("ECSClient", "ListServicesCommand").f(void 0, void 0).ser(se_ListServicesCommand).de(de_ListServicesCommand).build() {
  static {
    __name(this, "ListServicesCommand");
  }
};

// src/commands/ListTagsForResourceCommand.ts



var ListTagsForResourceCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonEC2ContainerServiceV20141113", "ListTagsForResource", {}).n("ECSClient", "ListTagsForResourceCommand").f(void 0, void 0).ser(se_ListTagsForResourceCommand).de(de_ListTagsForResourceCommand).build() {
  static {
    __name(this, "ListTagsForResourceCommand");
  }
};

// src/commands/ListTaskDefinitionFamiliesCommand.ts



var ListTaskDefinitionFamiliesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonEC2ContainerServiceV20141113", "ListTaskDefinitionFamilies", {}).n("ECSClient", "ListTaskDefinitionFamiliesCommand").f(void 0, void 0).ser(se_ListTaskDefinitionFamiliesCommand).de(de_ListTaskDefinitionFamiliesCommand).build() {
  static {
    __name(this, "ListTaskDefinitionFamiliesCommand");
  }
};

// src/commands/ListTaskDefinitionsCommand.ts



var ListTaskDefinitionsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonEC2ContainerServiceV20141113", "ListTaskDefinitions", {}).n("ECSClient", "ListTaskDefinitionsCommand").f(void 0, void 0).ser(se_ListTaskDefinitionsCommand).de(de_ListTaskDefinitionsCommand).build() {
  static {
    __name(this, "ListTaskDefinitionsCommand");
  }
};

// src/commands/ListTasksCommand.ts



var ListTasksCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonEC2ContainerServiceV20141113", "ListTasks", {}).n("ECSClient", "ListTasksCommand").f(void 0, void 0).ser(se_ListTasksCommand).de(de_ListTasksCommand).build() {
  static {
    __name(this, "ListTasksCommand");
  }
};

// src/commands/PutAccountSettingCommand.ts



var PutAccountSettingCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonEC2ContainerServiceV20141113", "PutAccountSetting", {}).n("ECSClient", "PutAccountSettingCommand").f(void 0, void 0).ser(se_PutAccountSettingCommand).de(de_PutAccountSettingCommand).build() {
  static {
    __name(this, "PutAccountSettingCommand");
  }
};

// src/commands/PutAccountSettingDefaultCommand.ts



var PutAccountSettingDefaultCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonEC2ContainerServiceV20141113", "PutAccountSettingDefault", {}).n("ECSClient", "PutAccountSettingDefaultCommand").f(void 0, void 0).ser(se_PutAccountSettingDefaultCommand).de(de_PutAccountSettingDefaultCommand).build() {
  static {
    __name(this, "PutAccountSettingDefaultCommand");
  }
};

// src/commands/PutAttributesCommand.ts



var PutAttributesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonEC2ContainerServiceV20141113", "PutAttributes", {}).n("ECSClient", "PutAttributesCommand").f(void 0, void 0).ser(se_PutAttributesCommand).de(de_PutAttributesCommand).build() {
  static {
    __name(this, "PutAttributesCommand");
  }
};

// src/commands/PutClusterCapacityProvidersCommand.ts



var PutClusterCapacityProvidersCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonEC2ContainerServiceV20141113", "PutClusterCapacityProviders", {}).n("ECSClient", "PutClusterCapacityProvidersCommand").f(void 0, void 0).ser(se_PutClusterCapacityProvidersCommand).de(de_PutClusterCapacityProvidersCommand).build() {
  static {
    __name(this, "PutClusterCapacityProvidersCommand");
  }
};

// src/commands/RegisterContainerInstanceCommand.ts



var RegisterContainerInstanceCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonEC2ContainerServiceV20141113", "RegisterContainerInstance", {}).n("ECSClient", "RegisterContainerInstanceCommand").f(void 0, void 0).ser(se_RegisterContainerInstanceCommand).de(de_RegisterContainerInstanceCommand).build() {
  static {
    __name(this, "RegisterContainerInstanceCommand");
  }
};

// src/commands/RegisterTaskDefinitionCommand.ts



var RegisterTaskDefinitionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonEC2ContainerServiceV20141113", "RegisterTaskDefinition", {}).n("ECSClient", "RegisterTaskDefinitionCommand").f(void 0, void 0).ser(se_RegisterTaskDefinitionCommand).de(de_RegisterTaskDefinitionCommand).build() {
  static {
    __name(this, "RegisterTaskDefinitionCommand");
  }
};

// src/commands/RunTaskCommand.ts



var RunTaskCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonEC2ContainerServiceV20141113", "RunTask", {}).n("ECSClient", "RunTaskCommand").f(void 0, void 0).ser(se_RunTaskCommand).de(de_RunTaskCommand).build() {
  static {
    __name(this, "RunTaskCommand");
  }
};

// src/commands/StartTaskCommand.ts



var StartTaskCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonEC2ContainerServiceV20141113", "StartTask", {}).n("ECSClient", "StartTaskCommand").f(void 0, void 0).ser(se_StartTaskCommand).de(de_StartTaskCommand).build() {
  static {
    __name(this, "StartTaskCommand");
  }
};

// src/commands/StopServiceDeploymentCommand.ts



var StopServiceDeploymentCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonEC2ContainerServiceV20141113", "StopServiceDeployment", {}).n("ECSClient", "StopServiceDeploymentCommand").f(void 0, void 0).ser(se_StopServiceDeploymentCommand).de(de_StopServiceDeploymentCommand).build() {
  static {
    __name(this, "StopServiceDeploymentCommand");
  }
};

// src/commands/StopTaskCommand.ts



var StopTaskCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonEC2ContainerServiceV20141113", "StopTask", {}).n("ECSClient", "StopTaskCommand").f(void 0, void 0).ser(se_StopTaskCommand).de(de_StopTaskCommand).build() {
  static {
    __name(this, "StopTaskCommand");
  }
};

// src/commands/SubmitAttachmentStateChangesCommand.ts



var SubmitAttachmentStateChangesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonEC2ContainerServiceV20141113", "SubmitAttachmentStateChanges", {}).n("ECSClient", "SubmitAttachmentStateChangesCommand").f(void 0, void 0).ser(se_SubmitAttachmentStateChangesCommand).de(de_SubmitAttachmentStateChangesCommand).build() {
  static {
    __name(this, "SubmitAttachmentStateChangesCommand");
  }
};

// src/commands/SubmitContainerStateChangeCommand.ts



var SubmitContainerStateChangeCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonEC2ContainerServiceV20141113", "SubmitContainerStateChange", {}).n("ECSClient", "SubmitContainerStateChangeCommand").f(void 0, void 0).ser(se_SubmitContainerStateChangeCommand).de(de_SubmitContainerStateChangeCommand).build() {
  static {
    __name(this, "SubmitContainerStateChangeCommand");
  }
};

// src/commands/SubmitTaskStateChangeCommand.ts



var SubmitTaskStateChangeCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonEC2ContainerServiceV20141113", "SubmitTaskStateChange", {}).n("ECSClient", "SubmitTaskStateChangeCommand").f(void 0, void 0).ser(se_SubmitTaskStateChangeCommand).de(de_SubmitTaskStateChangeCommand).build() {
  static {
    __name(this, "SubmitTaskStateChangeCommand");
  }
};

// src/commands/TagResourceCommand.ts



var TagResourceCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonEC2ContainerServiceV20141113", "TagResource", {}).n("ECSClient", "TagResourceCommand").f(void 0, void 0).ser(se_TagResourceCommand).de(de_TagResourceCommand).build() {
  static {
    __name(this, "TagResourceCommand");
  }
};

// src/commands/UntagResourceCommand.ts



var UntagResourceCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonEC2ContainerServiceV20141113", "UntagResource", {}).n("ECSClient", "UntagResourceCommand").f(void 0, void 0).ser(se_UntagResourceCommand).de(de_UntagResourceCommand).build() {
  static {
    __name(this, "UntagResourceCommand");
  }
};

// src/commands/UpdateCapacityProviderCommand.ts



var UpdateCapacityProviderCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonEC2ContainerServiceV20141113", "UpdateCapacityProvider", {}).n("ECSClient", "UpdateCapacityProviderCommand").f(void 0, void 0).ser(se_UpdateCapacityProviderCommand).de(de_UpdateCapacityProviderCommand).build() {
  static {
    __name(this, "UpdateCapacityProviderCommand");
  }
};

// src/commands/UpdateClusterCommand.ts



var UpdateClusterCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonEC2ContainerServiceV20141113", "UpdateCluster", {}).n("ECSClient", "UpdateClusterCommand").f(void 0, void 0).ser(se_UpdateClusterCommand).de(de_UpdateClusterCommand).build() {
  static {
    __name(this, "UpdateClusterCommand");
  }
};

// src/commands/UpdateClusterSettingsCommand.ts



var UpdateClusterSettingsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonEC2ContainerServiceV20141113", "UpdateClusterSettings", {}).n("ECSClient", "UpdateClusterSettingsCommand").f(void 0, void 0).ser(se_UpdateClusterSettingsCommand).de(de_UpdateClusterSettingsCommand).build() {
  static {
    __name(this, "UpdateClusterSettingsCommand");
  }
};

// src/commands/UpdateContainerAgentCommand.ts



var UpdateContainerAgentCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonEC2ContainerServiceV20141113", "UpdateContainerAgent", {}).n("ECSClient", "UpdateContainerAgentCommand").f(void 0, void 0).ser(se_UpdateContainerAgentCommand).de(de_UpdateContainerAgentCommand).build() {
  static {
    __name(this, "UpdateContainerAgentCommand");
  }
};

// src/commands/UpdateContainerInstancesStateCommand.ts



var UpdateContainerInstancesStateCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonEC2ContainerServiceV20141113", "UpdateContainerInstancesState", {}).n("ECSClient", "UpdateContainerInstancesStateCommand").f(void 0, void 0).ser(se_UpdateContainerInstancesStateCommand).de(de_UpdateContainerInstancesStateCommand).build() {
  static {
    __name(this, "UpdateContainerInstancesStateCommand");
  }
};

// src/commands/UpdateServiceCommand.ts



var UpdateServiceCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonEC2ContainerServiceV20141113", "UpdateService", {}).n("ECSClient", "UpdateServiceCommand").f(void 0, void 0).ser(se_UpdateServiceCommand).de(de_UpdateServiceCommand).build() {
  static {
    __name(this, "UpdateServiceCommand");
  }
};

// src/commands/UpdateServicePrimaryTaskSetCommand.ts



var UpdateServicePrimaryTaskSetCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonEC2ContainerServiceV20141113", "UpdateServicePrimaryTaskSet", {}).n("ECSClient", "UpdateServicePrimaryTaskSetCommand").f(void 0, void 0).ser(se_UpdateServicePrimaryTaskSetCommand).de(de_UpdateServicePrimaryTaskSetCommand).build() {
  static {
    __name(this, "UpdateServicePrimaryTaskSetCommand");
  }
};

// src/commands/UpdateTaskProtectionCommand.ts



var UpdateTaskProtectionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonEC2ContainerServiceV20141113", "UpdateTaskProtection", {}).n("ECSClient", "UpdateTaskProtectionCommand").f(void 0, void 0).ser(se_UpdateTaskProtectionCommand).de(de_UpdateTaskProtectionCommand).build() {
  static {
    __name(this, "UpdateTaskProtectionCommand");
  }
};

// src/commands/UpdateTaskSetCommand.ts



var UpdateTaskSetCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonEC2ContainerServiceV20141113", "UpdateTaskSet", {}).n("ECSClient", "UpdateTaskSetCommand").f(void 0, void 0).ser(se_UpdateTaskSetCommand).de(de_UpdateTaskSetCommand).build() {
  static {
    __name(this, "UpdateTaskSetCommand");
  }
};

// src/ECS.ts
var commands = {
  CreateCapacityProviderCommand,
  CreateClusterCommand,
  CreateServiceCommand,
  CreateTaskSetCommand,
  DeleteAccountSettingCommand,
  DeleteAttributesCommand,
  DeleteCapacityProviderCommand,
  DeleteClusterCommand,
  DeleteServiceCommand,
  DeleteTaskDefinitionsCommand,
  DeleteTaskSetCommand,
  DeregisterContainerInstanceCommand,
  DeregisterTaskDefinitionCommand,
  DescribeCapacityProvidersCommand,
  DescribeClustersCommand,
  DescribeContainerInstancesCommand,
  DescribeServiceDeploymentsCommand,
  DescribeServiceRevisionsCommand,
  DescribeServicesCommand,
  DescribeTaskDefinitionCommand,
  DescribeTasksCommand,
  DescribeTaskSetsCommand,
  DiscoverPollEndpointCommand,
  ExecuteCommandCommand,
  GetTaskProtectionCommand,
  ListAccountSettingsCommand,
  ListAttributesCommand,
  ListClustersCommand,
  ListContainerInstancesCommand,
  ListServiceDeploymentsCommand,
  ListServicesCommand,
  ListServicesByNamespaceCommand,
  ListTagsForResourceCommand,
  ListTaskDefinitionFamiliesCommand,
  ListTaskDefinitionsCommand,
  ListTasksCommand,
  PutAccountSettingCommand,
  PutAccountSettingDefaultCommand,
  PutAttributesCommand,
  PutClusterCapacityProvidersCommand,
  RegisterContainerInstanceCommand,
  RegisterTaskDefinitionCommand,
  RunTaskCommand,
  StartTaskCommand,
  StopServiceDeploymentCommand,
  StopTaskCommand,
  SubmitAttachmentStateChangesCommand,
  SubmitContainerStateChangeCommand,
  SubmitTaskStateChangeCommand,
  TagResourceCommand,
  UntagResourceCommand,
  UpdateCapacityProviderCommand,
  UpdateClusterCommand,
  UpdateClusterSettingsCommand,
  UpdateContainerAgentCommand,
  UpdateContainerInstancesStateCommand,
  UpdateServiceCommand,
  UpdateServicePrimaryTaskSetCommand,
  UpdateTaskProtectionCommand,
  UpdateTaskSetCommand
};
var ECS = class extends ECSClient {
  static {
    __name(this, "ECS");
  }
};
(0, import_smithy_client.createAggregatedClient)(commands, ECS);

// src/pagination/ListAccountSettingsPaginator.ts

var paginateListAccountSettings = (0, import_core.createPaginator)(ECSClient, ListAccountSettingsCommand, "nextToken", "nextToken", "maxResults");

// src/pagination/ListAttributesPaginator.ts

var paginateListAttributes = (0, import_core.createPaginator)(ECSClient, ListAttributesCommand, "nextToken", "nextToken", "maxResults");

// src/pagination/ListClustersPaginator.ts

var paginateListClusters = (0, import_core.createPaginator)(ECSClient, ListClustersCommand, "nextToken", "nextToken", "maxResults");

// src/pagination/ListContainerInstancesPaginator.ts

var paginateListContainerInstances = (0, import_core.createPaginator)(ECSClient, ListContainerInstancesCommand, "nextToken", "nextToken", "maxResults");

// src/pagination/ListServicesByNamespacePaginator.ts

var paginateListServicesByNamespace = (0, import_core.createPaginator)(ECSClient, ListServicesByNamespaceCommand, "nextToken", "nextToken", "maxResults");

// src/pagination/ListServicesPaginator.ts

var paginateListServices = (0, import_core.createPaginator)(ECSClient, ListServicesCommand, "nextToken", "nextToken", "maxResults");

// src/pagination/ListTaskDefinitionFamiliesPaginator.ts

var paginateListTaskDefinitionFamilies = (0, import_core.createPaginator)(ECSClient, ListTaskDefinitionFamiliesCommand, "nextToken", "nextToken", "maxResults");

// src/pagination/ListTaskDefinitionsPaginator.ts

var paginateListTaskDefinitions = (0, import_core.createPaginator)(ECSClient, ListTaskDefinitionsCommand, "nextToken", "nextToken", "maxResults");

// src/pagination/ListTasksPaginator.ts

var paginateListTasks = (0, import_core.createPaginator)(ECSClient, ListTasksCommand, "nextToken", "nextToken", "maxResults");

// src/waiters/waitForServicesInactive.ts
var import_util_waiter = require("@smithy/util-waiter");
var checkState = /* @__PURE__ */ __name(async (client, input) => {
  let reason;
  try {
    const result = await client.send(new DescribeServicesCommand(input));
    reason = result;
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.failures);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.reason;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "MISSING") {
          return { state: import_util_waiter.WaiterState.FAILURE, reason };
        }
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.services);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.status;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "INACTIVE") {
          return { state: import_util_waiter.WaiterState.SUCCESS, reason };
        }
      }
    } catch (e) {
    }
  } catch (exception) {
    reason = exception;
  }
  return { state: import_util_waiter.WaiterState.RETRY, reason };
}, "checkState");
var waitForServicesInactive = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 15, maxDelay: 120 };
  return (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState);
}, "waitForServicesInactive");
var waitUntilServicesInactive = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 15, maxDelay: 120 };
  const result = await (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState);
  return (0, import_util_waiter.checkExceptions)(result);
}, "waitUntilServicesInactive");

// src/waiters/waitForServicesStable.ts

var checkState2 = /* @__PURE__ */ __name(async (client, input) => {
  let reason;
  try {
    const result = await client.send(new DescribeServicesCommand(input));
    reason = result;
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.failures);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.reason;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "MISSING") {
          return { state: import_util_waiter.WaiterState.FAILURE, reason };
        }
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.services);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.status;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "DRAINING") {
          return { state: import_util_waiter.WaiterState.FAILURE, reason };
        }
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.services);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.status;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "INACTIVE") {
          return { state: import_util_waiter.WaiterState.FAILURE, reason };
        }
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const filterRes_2 = result.services.filter((element_1) => {
          return !(element_1.deployments.length == 1 && element_1.runningCount == element_1.desiredCount);
        });
        return filterRes_2.length == 0;
      }, "returnComparator");
      if (returnComparator() == true) {
        return { state: import_util_waiter.WaiterState.SUCCESS, reason };
      }
    } catch (e) {
    }
  } catch (exception) {
    reason = exception;
  }
  return { state: import_util_waiter.WaiterState.RETRY, reason };
}, "checkState");
var waitForServicesStable = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 15, maxDelay: 120 };
  return (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState2);
}, "waitForServicesStable");
var waitUntilServicesStable = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 15, maxDelay: 120 };
  const result = await (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState2);
  return (0, import_util_waiter.checkExceptions)(result);
}, "waitUntilServicesStable");

// src/waiters/waitForTasksRunning.ts

var checkState3 = /* @__PURE__ */ __name(async (client, input) => {
  let reason;
  try {
    const result = await client.send(new DescribeTasksCommand(input));
    reason = result;
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.tasks);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.lastStatus;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "STOPPED") {
          return { state: import_util_waiter.WaiterState.FAILURE, reason };
        }
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.failures);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.reason;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "MISSING") {
          return { state: import_util_waiter.WaiterState.FAILURE, reason };
        }
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.tasks);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.lastStatus;
        });
        return projection_3;
      }, "returnComparator");
      let allStringEq_5 = returnComparator().length > 0;
      for (const element_4 of returnComparator()) {
        allStringEq_5 = allStringEq_5 && element_4 == "RUNNING";
      }
      if (allStringEq_5) {
        return { state: import_util_waiter.WaiterState.SUCCESS, reason };
      }
    } catch (e) {
    }
  } catch (exception) {
    reason = exception;
  }
  return { state: import_util_waiter.WaiterState.RETRY, reason };
}, "checkState");
var waitForTasksRunning = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 6, maxDelay: 120 };
  return (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState3);
}, "waitForTasksRunning");
var waitUntilTasksRunning = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 6, maxDelay: 120 };
  const result = await (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState3);
  return (0, import_util_waiter.checkExceptions)(result);
}, "waitUntilTasksRunning");

// src/waiters/waitForTasksStopped.ts

var checkState4 = /* @__PURE__ */ __name(async (client, input) => {
  let reason;
  try {
    const result = await client.send(new DescribeTasksCommand(input));
    reason = result;
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.tasks);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.lastStatus;
        });
        return projection_3;
      }, "returnComparator");
      let allStringEq_5 = returnComparator().length > 0;
      for (const element_4 of returnComparator()) {
        allStringEq_5 = allStringEq_5 && element_4 == "STOPPED";
      }
      if (allStringEq_5) {
        return { state: import_util_waiter.WaiterState.SUCCESS, reason };
      }
    } catch (e) {
    }
  } catch (exception) {
    reason = exception;
  }
  return { state: import_util_waiter.WaiterState.RETRY, reason };
}, "checkState");
var waitForTasksStopped = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 6, maxDelay: 120 };
  return (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState4);
}, "waitForTasksStopped");
var waitUntilTasksStopped = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 6, maxDelay: 120 };
  const result = await (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState4);
  return (0, import_util_waiter.checkExceptions)(result);
}, "waitUntilTasksStopped");
// Annotate the CommonJS export names for ESM import in node:

0 && (module.exports = {
  ECSServiceException,
  __Client,
  ECSClient,
  ECS,
  $Command,
  CreateCapacityProviderCommand,
  CreateClusterCommand,
  CreateServiceCommand,
  CreateTaskSetCommand,
  DeleteAccountSettingCommand,
  DeleteAttributesCommand,
  DeleteCapacityProviderCommand,
  DeleteClusterCommand,
  DeleteServiceCommand,
  DeleteTaskDefinitionsCommand,
  DeleteTaskSetCommand,
  DeregisterContainerInstanceCommand,
  DeregisterTaskDefinitionCommand,
  DescribeCapacityProvidersCommand,
  DescribeClustersCommand,
  DescribeContainerInstancesCommand,
  DescribeServiceDeploymentsCommand,
  DescribeServiceRevisionsCommand,
  DescribeServicesCommand,
  DescribeTaskDefinitionCommand,
  DescribeTaskSetsCommand,
  DescribeTasksCommand,
  DiscoverPollEndpointCommand,
  ExecuteCommandCommand,
  GetTaskProtectionCommand,
  ListAccountSettingsCommand,
  ListAttributesCommand,
  ListClustersCommand,
  ListContainerInstancesCommand,
  ListServiceDeploymentsCommand,
  ListServicesByNamespaceCommand,
  ListServicesCommand,
  ListTagsForResourceCommand,
  ListTaskDefinitionFamiliesCommand,
  ListTaskDefinitionsCommand,
  ListTasksCommand,
  PutAccountSettingCommand,
  PutAccountSettingDefaultCommand,
  PutAttributesCommand,
  PutClusterCapacityProvidersCommand,
  RegisterContainerInstanceCommand,
  RegisterTaskDefinitionCommand,
  RunTaskCommand,
  StartTaskCommand,
  StopServiceDeploymentCommand,
  StopTaskCommand,
  SubmitAttachmentStateChangesCommand,
  SubmitContainerStateChangeCommand,
  SubmitTaskStateChangeCommand,
  TagResourceCommand,
  UntagResourceCommand,
  UpdateCapacityProviderCommand,
  UpdateClusterCommand,
  UpdateClusterSettingsCommand,
  UpdateContainerAgentCommand,
  UpdateContainerInstancesStateCommand,
  UpdateServiceCommand,
  UpdateServicePrimaryTaskSetCommand,
  UpdateTaskProtectionCommand,
  UpdateTaskSetCommand,
  paginateListAccountSettings,
  paginateListAttributes,
  paginateListClusters,
  paginateListContainerInstances,
  paginateListServicesByNamespace,
  paginateListServices,
  paginateListTaskDefinitionFamilies,
  paginateListTaskDefinitions,
  paginateListTasks,
  waitForServicesInactive,
  waitUntilServicesInactive,
  waitForServicesStable,
  waitUntilServicesStable,
  waitForTasksRunning,
  waitUntilTasksRunning,
  waitForTasksStopped,
  waitUntilTasksStopped,
  AcceleratorManufacturer,
  AcceleratorName,
  AcceleratorType,
  AccessDeniedException,
  AgentUpdateStatus,
  ClientException,
  ClusterNotFoundException,
  ManagedDraining,
  ManagedScalingStatus,
  ManagedTerminationProtection,
  BareMetal,
  BurstablePerformance,
  CpuManufacturer,
  InstanceGeneration,
  LocalStorage,
  LocalStorageType,
  ManagedInstancesMonitoringOptions,
  PropagateMITags,
  CapacityProviderStatus,
  CapacityProviderType,
  CapacityProviderUpdateStatus,
  InvalidParameterException,
  LimitExceededException,
  ServerException,
  UnsupportedFeatureException,
  UpdateInProgressException,
  ExecuteCommandLogging,
  ClusterSettingName,
  NamespaceNotFoundException,
  AvailabilityZoneRebalancing,
  DeploymentLifecycleHookStage,
  DeploymentStrategy,
  DeploymentControllerType,
  LaunchType,
  AssignPublicIp,
  PlacementConstraintType,
  PlacementStrategyType,
  PropagateTags,
  SchedulingStrategy,
  LogDriver,
  TaskFilesystemType,
  EBSResourceType,
  DeploymentRolloutState,
  ScaleUnit,
  StabilityStatus,
  PlatformTaskDefinitionIncompatibilityException,
  PlatformUnknownException,
  ServiceNotActiveException,
  ServiceNotFoundException,
  SettingName,
  SettingType,
  TargetType,
  TargetNotFoundException,
  ClusterContainsCapacityProviderException,
  ClusterContainsContainerInstancesException,
  ClusterContainsServicesException,
  ClusterContainsTasksException,
  Compatibility,
  ContainerCondition,
  EnvironmentFileType,
  FirelensConfigurationType,
  DeviceCgroupPermission,
  ApplicationProtocol,
  TransportProtocol,
  ResourceType,
  UlimitName,
  VersionConsistency,
  IpcMode,
  NetworkMode,
  PidMode,
  TaskDefinitionPlacementConstraintType,
  ProxyConfigurationType,
  CPUArchitecture,
  OSFamily,
  TaskDefinitionStatus,
  Scope,
  EFSAuthorizationConfigIAM,
  EFSTransitEncryption,
  TaskSetNotFoundException,
  InstanceHealthCheckState,
  InstanceHealthCheckType,
  CapacityProviderField,
  ClusterField,
  ContainerInstanceField,
  ServiceDeploymentRollbackMonitorsStatus,
  ServiceDeploymentLifecycleStage,
  ServiceDeploymentStatus,
  ServiceField,
  TaskDefinitionField,
  TaskField,
  Connectivity,
  HealthStatus,
  ManagedAgentName,
  TaskStopCode,
  TaskSetField,
  TargetNotConnectedException,
  ResourceNotFoundException,
  ContainerInstanceStatus,
  TaskDefinitionFamilyStatus,
  SortOrder,
  DesiredStatus,
  SessionFilterSensitiveLog,
  ExecuteCommandResponseFilterSensitiveLog,
  AttributeLimitExceededException,
  ResourceInUseException,
  PlatformDeviceType,
  BlockedException,
  ConflictException,
  ServiceDeploymentNotFoundException,
  StopServiceDeploymentStopType,
  MissingVersionException,
  NoUpdateAvailableException
});

