import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { ExecuteCommandResponseFilterSensitiveLog, } from "../models/models_0";
import { de_ExecuteCommandCommand, se_ExecuteCommandCommand } from "../protocols/Aws_json1_1";
export { $Command };
export class ExecuteCommandCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonEC2ContainerServiceV20141113", "ExecuteCommand", {})
    .n("ECSClient", "ExecuteCommandCommand")
    .f(void 0, ExecuteCommandResponseFilterSensitiveLog)
    .ser(se_ExecuteCommandCommand)
    .de(de_ExecuteCommandCommand)
    .build() {
}
