import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_GetTaskProtectionCommand, se_GetTaskProtectionCommand } from "../protocols/Aws_json1_1";
export { $Command };
export class GetTaskProtectionCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonEC2ContainerServiceV20141113", "GetTaskProtection", {})
    .n("ECSClient", "GetTaskProtectionCommand")
    .f(void 0, void 0)
    .ser(se_GetTaskProtectionCommand)
    .de(de_GetTaskProtectionCommand)
    .build() {
}
