import { ECSServiceException as __BaseException } from "./ECSServiceException";
export class AttributeLimitExceededException extends __BaseException {
    name = "AttributeLimitExceededException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "AttributeLimitExceededException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, AttributeLimitExceededException.prototype);
    }
}
export class ResourceInUseException extends __BaseException {
    name = "ResourceInUseException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ResourceInUseException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ResourceInUseException.prototype);
    }
}
export const PlatformDeviceType = {
    GPU: "GPU",
};
export class BlockedException extends __BaseException {
    name = "BlockedException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "BlockedException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, BlockedException.prototype);
    }
}
export class ConflictException extends __BaseException {
    name = "ConflictException";
    $fault = "client";
    resourceIds;
    constructor(opts) {
        super({
            name: "ConflictException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ConflictException.prototype);
        this.resourceIds = opts.resourceIds;
    }
}
export class ServiceDeploymentNotFoundException extends __BaseException {
    name = "ServiceDeploymentNotFoundException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ServiceDeploymentNotFoundException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ServiceDeploymentNotFoundException.prototype);
    }
}
export const StopServiceDeploymentStopType = {
    ABORT: "ABORT",
    ROLLBACK: "ROLLBACK",
};
export class MissingVersionException extends __BaseException {
    name = "MissingVersionException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "MissingVersionException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, MissingVersionException.prototype);
    }
}
export class NoUpdateAvailableException extends __BaseException {
    name = "NoUpdateAvailableException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "NoUpdateAvailableException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, NoUpdateAvailableException.prototype);
    }
}
