import { ExceptionOptionType as __ExceptionOptionType } from "@smithy/smithy-client";
import { DocumentType as __DocumentType } from "@smithy/types";
import { ECSServiceException as __BaseException } from "./ECSServiceException";
export interface AcceleratorCountRequest {
  min?: number | undefined;
  max?: number | undefined;
}
export declare const AcceleratorManufacturer: {
  readonly AMAZON_WEB_SERVICES: "amazon-web-services";
  readonly AMD: "amd";
  readonly HABANA: "habana";
  readonly NVIDIA: "nvidia";
  readonly XILINX: "xilinx";
};
export type AcceleratorManufacturer =
  (typeof AcceleratorManufacturer)[keyof typeof AcceleratorManufacturer];
export declare const AcceleratorName: {
  readonly A100: "a100";
  readonly A10G: "a10g";
  readonly H100: "h100";
  readonly INFERENTIA: "inferentia";
  readonly K520: "k520";
  readonly K80: "k80";
  readonly M60: "m60";
  readonly RADEON_PRO_V520: "radeon-pro-v520";
  readonly T4: "t4";
  readonly T4G: "t4g";
  readonly V100: "v100";
  readonly VU9P: "vu9p";
};
export type AcceleratorName =
  (typeof AcceleratorName)[keyof typeof AcceleratorName];
export interface AcceleratorTotalMemoryMiBRequest {
  min?: number | undefined;
  max?: number | undefined;
}
export declare const AcceleratorType: {
  readonly FPGA: "fpga";
  readonly GPU: "gpu";
  readonly INFERENCE: "inference";
};
export type AcceleratorType =
  (typeof AcceleratorType)[keyof typeof AcceleratorType];
export declare class AccessDeniedException extends __BaseException {
  readonly name: "AccessDeniedException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<AccessDeniedException, __BaseException>
  );
}
export interface AdvancedConfiguration {
  alternateTargetGroupArn?: string | undefined;
  productionListenerRule?: string | undefined;
  testListenerRule?: string | undefined;
  roleArn?: string | undefined;
}
export declare const AgentUpdateStatus: {
  readonly FAILED: "FAILED";
  readonly PENDING: "PENDING";
  readonly STAGED: "STAGED";
  readonly STAGING: "STAGING";
  readonly UPDATED: "UPDATED";
  readonly UPDATING: "UPDATING";
};
export type AgentUpdateStatus =
  (typeof AgentUpdateStatus)[keyof typeof AgentUpdateStatus];
export declare class ClientException extends __BaseException {
  readonly name: "ClientException";
  readonly $fault: "client";
  constructor(opts: __ExceptionOptionType<ClientException, __BaseException>);
}
export declare class ClusterNotFoundException extends __BaseException {
  readonly name: "ClusterNotFoundException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<ClusterNotFoundException, __BaseException>
  );
}
export declare const ManagedDraining: {
  readonly DISABLED: "DISABLED";
  readonly ENABLED: "ENABLED";
};
export type ManagedDraining =
  (typeof ManagedDraining)[keyof typeof ManagedDraining];
export declare const ManagedScalingStatus: {
  readonly DISABLED: "DISABLED";
  readonly ENABLED: "ENABLED";
};
export type ManagedScalingStatus =
  (typeof ManagedScalingStatus)[keyof typeof ManagedScalingStatus];
export interface ManagedScaling {
  status?: ManagedScalingStatus | undefined;
  targetCapacity?: number | undefined;
  minimumScalingStepSize?: number | undefined;
  maximumScalingStepSize?: number | undefined;
  instanceWarmupPeriod?: number | undefined;
}
export declare const ManagedTerminationProtection: {
  readonly DISABLED: "DISABLED";
  readonly ENABLED: "ENABLED";
};
export type ManagedTerminationProtection =
  (typeof ManagedTerminationProtection)[keyof typeof ManagedTerminationProtection];
export interface AutoScalingGroupProvider {
  autoScalingGroupArn: string | undefined;
  managedScaling?: ManagedScaling | undefined;
  managedTerminationProtection?: ManagedTerminationProtection | undefined;
  managedDraining?: ManagedDraining | undefined;
}
export declare const BareMetal: {
  readonly EXCLUDED: "excluded";
  readonly INCLUDED: "included";
  readonly REQUIRED: "required";
};
export type BareMetal = (typeof BareMetal)[keyof typeof BareMetal];
export interface BaselineEbsBandwidthMbpsRequest {
  min?: number | undefined;
  max?: number | undefined;
}
export declare const BurstablePerformance: {
  readonly EXCLUDED: "excluded";
  readonly INCLUDED: "included";
  readonly REQUIRED: "required";
};
export type BurstablePerformance =
  (typeof BurstablePerformance)[keyof typeof BurstablePerformance];
export declare const CpuManufacturer: {
  readonly AMAZON_WEB_SERVICES: "amazon-web-services";
  readonly AMD: "amd";
  readonly INTEL: "intel";
};
export type CpuManufacturer =
  (typeof CpuManufacturer)[keyof typeof CpuManufacturer];
export declare const InstanceGeneration: {
  readonly CURRENT: "current";
  readonly PREVIOUS: "previous";
};
export type InstanceGeneration =
  (typeof InstanceGeneration)[keyof typeof InstanceGeneration];
export declare const LocalStorage: {
  readonly EXCLUDED: "excluded";
  readonly INCLUDED: "included";
  readonly REQUIRED: "required";
};
export type LocalStorage = (typeof LocalStorage)[keyof typeof LocalStorage];
export declare const LocalStorageType: {
  readonly HDD: "hdd";
  readonly SSD: "ssd";
};
export type LocalStorageType =
  (typeof LocalStorageType)[keyof typeof LocalStorageType];
export interface MemoryGiBPerVCpuRequest {
  min?: number | undefined;
  max?: number | undefined;
}
export interface MemoryMiBRequest {
  min: number | undefined;
  max?: number | undefined;
}
export interface NetworkBandwidthGbpsRequest {
  min?: number | undefined;
  max?: number | undefined;
}
export interface NetworkInterfaceCountRequest {
  min?: number | undefined;
  max?: number | undefined;
}
export interface TotalLocalStorageGBRequest {
  min?: number | undefined;
  max?: number | undefined;
}
export interface VCpuCountRangeRequest {
  min: number | undefined;
  max?: number | undefined;
}
export interface InstanceRequirementsRequest {
  vCpuCount: VCpuCountRangeRequest | undefined;
  memoryMiB: MemoryMiBRequest | undefined;
  cpuManufacturers?: CpuManufacturer[] | undefined;
  memoryGiBPerVCpu?: MemoryGiBPerVCpuRequest | undefined;
  excludedInstanceTypes?: string[] | undefined;
  instanceGenerations?: InstanceGeneration[] | undefined;
  spotMaxPricePercentageOverLowestPrice?: number | undefined;
  onDemandMaxPricePercentageOverLowestPrice?: number | undefined;
  bareMetal?: BareMetal | undefined;
  burstablePerformance?: BurstablePerformance | undefined;
  requireHibernateSupport?: boolean | undefined;
  networkInterfaceCount?: NetworkInterfaceCountRequest | undefined;
  localStorage?: LocalStorage | undefined;
  localStorageTypes?: LocalStorageType[] | undefined;
  totalLocalStorageGB?: TotalLocalStorageGBRequest | undefined;
  baselineEbsBandwidthMbps?: BaselineEbsBandwidthMbpsRequest | undefined;
  acceleratorTypes?: AcceleratorType[] | undefined;
  acceleratorCount?: AcceleratorCountRequest | undefined;
  acceleratorManufacturers?: AcceleratorManufacturer[] | undefined;
  acceleratorNames?: AcceleratorName[] | undefined;
  acceleratorTotalMemoryMiB?: AcceleratorTotalMemoryMiBRequest | undefined;
  networkBandwidthGbps?: NetworkBandwidthGbpsRequest | undefined;
  allowedInstanceTypes?: string[] | undefined;
  maxSpotPriceAsPercentageOfOptimalOnDemandPrice?: number | undefined;
}
export declare const ManagedInstancesMonitoringOptions: {
  readonly BASIC: "BASIC";
  readonly DETAILED: "DETAILED";
};
export type ManagedInstancesMonitoringOptions =
  (typeof ManagedInstancesMonitoringOptions)[keyof typeof ManagedInstancesMonitoringOptions];
export interface ManagedInstancesNetworkConfiguration {
  subnets?: string[] | undefined;
  securityGroups?: string[] | undefined;
}
export interface ManagedInstancesStorageConfiguration {
  storageSizeGiB?: number | undefined;
}
export interface InstanceLaunchTemplate {
  ec2InstanceProfileArn: string | undefined;
  networkConfiguration: ManagedInstancesNetworkConfiguration | undefined;
  storageConfiguration?: ManagedInstancesStorageConfiguration | undefined;
  monitoring?: ManagedInstancesMonitoringOptions | undefined;
  instanceRequirements?: InstanceRequirementsRequest | undefined;
}
export declare const PropagateMITags: {
  readonly CAPACITY_PROVIDER: "CAPACITY_PROVIDER";
  readonly NONE: "NONE";
};
export type PropagateMITags =
  (typeof PropagateMITags)[keyof typeof PropagateMITags];
export interface CreateManagedInstancesProviderConfiguration {
  infrastructureRoleArn: string | undefined;
  instanceLaunchTemplate: InstanceLaunchTemplate | undefined;
  propagateTags?: PropagateMITags | undefined;
}
export interface Tag {
  key?: string | undefined;
  value?: string | undefined;
}
export interface CreateCapacityProviderRequest {
  name: string | undefined;
  cluster?: string | undefined;
  autoScalingGroupProvider?: AutoScalingGroupProvider | undefined;
  managedInstancesProvider?:
    | CreateManagedInstancesProviderConfiguration
    | undefined;
  tags?: Tag[] | undefined;
}
export interface ManagedInstancesProvider {
  infrastructureRoleArn?: string | undefined;
  instanceLaunchTemplate?: InstanceLaunchTemplate | undefined;
  propagateTags?: PropagateMITags | undefined;
}
export declare const CapacityProviderStatus: {
  readonly ACTIVE: "ACTIVE";
  readonly DEPROVISIONING: "DEPROVISIONING";
  readonly INACTIVE: "INACTIVE";
  readonly PROVISIONING: "PROVISIONING";
};
export type CapacityProviderStatus =
  (typeof CapacityProviderStatus)[keyof typeof CapacityProviderStatus];
export declare const CapacityProviderType: {
  readonly EC2_AUTOSCALING: "EC2_AUTOSCALING";
  readonly FARGATE: "FARGATE";
  readonly FARGATE_SPOT: "FARGATE_SPOT";
  readonly MANAGED_INSTANCES: "MANAGED_INSTANCES";
};
export type CapacityProviderType =
  (typeof CapacityProviderType)[keyof typeof CapacityProviderType];
export declare const CapacityProviderUpdateStatus: {
  readonly CREATE_COMPLETE: "CREATE_COMPLETE";
  readonly CREATE_FAILED: "CREATE_FAILED";
  readonly CREATE_IN_PROGRESS: "CREATE_IN_PROGRESS";
  readonly DELETE_COMPLETE: "DELETE_COMPLETE";
  readonly DELETE_FAILED: "DELETE_FAILED";
  readonly DELETE_IN_PROGRESS: "DELETE_IN_PROGRESS";
  readonly UPDATE_COMPLETE: "UPDATE_COMPLETE";
  readonly UPDATE_FAILED: "UPDATE_FAILED";
  readonly UPDATE_IN_PROGRESS: "UPDATE_IN_PROGRESS";
};
export type CapacityProviderUpdateStatus =
  (typeof CapacityProviderUpdateStatus)[keyof typeof CapacityProviderUpdateStatus];
export interface CapacityProvider {
  capacityProviderArn?: string | undefined;
  name?: string | undefined;
  cluster?: string | undefined;
  status?: CapacityProviderStatus | undefined;
  autoScalingGroupProvider?: AutoScalingGroupProvider | undefined;
  managedInstancesProvider?: ManagedInstancesProvider | undefined;
  updateStatus?: CapacityProviderUpdateStatus | undefined;
  updateStatusReason?: string | undefined;
  tags?: Tag[] | undefined;
  type?: CapacityProviderType | undefined;
}
export interface CreateCapacityProviderResponse {
  capacityProvider?: CapacityProvider | undefined;
}
export declare class InvalidParameterException extends __BaseException {
  readonly name: "InvalidParameterException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidParameterException, __BaseException>
  );
}
export declare class LimitExceededException extends __BaseException {
  readonly name: "LimitExceededException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<LimitExceededException, __BaseException>
  );
}
export declare class ServerException extends __BaseException {
  readonly name: "ServerException";
  readonly $fault: "server";
  constructor(opts: __ExceptionOptionType<ServerException, __BaseException>);
}
export declare class UnsupportedFeatureException extends __BaseException {
  readonly name: "UnsupportedFeatureException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<UnsupportedFeatureException, __BaseException>
  );
}
export declare class UpdateInProgressException extends __BaseException {
  readonly name: "UpdateInProgressException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<UpdateInProgressException, __BaseException>
  );
}
export interface ExecuteCommandLogConfiguration {
  cloudWatchLogGroupName?: string | undefined;
  cloudWatchEncryptionEnabled?: boolean | undefined;
  s3BucketName?: string | undefined;
  s3EncryptionEnabled?: boolean | undefined;
  s3KeyPrefix?: string | undefined;
}
export declare const ExecuteCommandLogging: {
  readonly DEFAULT: "DEFAULT";
  readonly NONE: "NONE";
  readonly OVERRIDE: "OVERRIDE";
};
export type ExecuteCommandLogging =
  (typeof ExecuteCommandLogging)[keyof typeof ExecuteCommandLogging];
export interface ExecuteCommandConfiguration {
  kmsKeyId?: string | undefined;
  logging?: ExecuteCommandLogging | undefined;
  logConfiguration?: ExecuteCommandLogConfiguration | undefined;
}
export interface ManagedStorageConfiguration {
  kmsKeyId?: string | undefined;
  fargateEphemeralStorageKmsKeyId?: string | undefined;
}
export interface ClusterConfiguration {
  executeCommandConfiguration?: ExecuteCommandConfiguration | undefined;
  managedStorageConfiguration?: ManagedStorageConfiguration | undefined;
}
export interface CapacityProviderStrategyItem {
  capacityProvider: string | undefined;
  weight?: number | undefined;
  base?: number | undefined;
}
export interface ClusterServiceConnectDefaultsRequest {
  namespace: string | undefined;
}
export declare const ClusterSettingName: {
  readonly CONTAINER_INSIGHTS: "containerInsights";
};
export type ClusterSettingName =
  (typeof ClusterSettingName)[keyof typeof ClusterSettingName];
export interface ClusterSetting {
  name?: ClusterSettingName | undefined;
  value?: string | undefined;
}
export interface CreateClusterRequest {
  clusterName?: string | undefined;
  tags?: Tag[] | undefined;
  settings?: ClusterSetting[] | undefined;
  configuration?: ClusterConfiguration | undefined;
  capacityProviders?: string[] | undefined;
  defaultCapacityProviderStrategy?: CapacityProviderStrategyItem[] | undefined;
  serviceConnectDefaults?: ClusterServiceConnectDefaultsRequest | undefined;
}
export interface KeyValuePair {
  name?: string | undefined;
  value?: string | undefined;
}
export interface Attachment {
  id?: string | undefined;
  type?: string | undefined;
  status?: string | undefined;
  details?: KeyValuePair[] | undefined;
}
export interface ClusterServiceConnectDefaults {
  namespace?: string | undefined;
}
export interface Cluster {
  clusterArn?: string | undefined;
  clusterName?: string | undefined;
  configuration?: ClusterConfiguration | undefined;
  status?: string | undefined;
  registeredContainerInstancesCount?: number | undefined;
  runningTasksCount?: number | undefined;
  pendingTasksCount?: number | undefined;
  activeServicesCount?: number | undefined;
  statistics?: KeyValuePair[] | undefined;
  tags?: Tag[] | undefined;
  settings?: ClusterSetting[] | undefined;
  capacityProviders?: string[] | undefined;
  defaultCapacityProviderStrategy?: CapacityProviderStrategyItem[] | undefined;
  attachments?: Attachment[] | undefined;
  attachmentsStatus?: string | undefined;
  serviceConnectDefaults?: ClusterServiceConnectDefaults | undefined;
}
export interface CreateClusterResponse {
  cluster?: Cluster | undefined;
}
export declare class NamespaceNotFoundException extends __BaseException {
  readonly name: "NamespaceNotFoundException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<NamespaceNotFoundException, __BaseException>
  );
}
export declare const AvailabilityZoneRebalancing: {
  readonly DISABLED: "DISABLED";
  readonly ENABLED: "ENABLED";
};
export type AvailabilityZoneRebalancing =
  (typeof AvailabilityZoneRebalancing)[keyof typeof AvailabilityZoneRebalancing];
export interface DeploymentAlarms {
  alarmNames: string[] | undefined;
  rollback: boolean | undefined;
  enable: boolean | undefined;
}
export interface DeploymentCircuitBreaker {
  enable: boolean | undefined;
  rollback: boolean | undefined;
}
export declare const DeploymentLifecycleHookStage: {
  readonly POST_PRODUCTION_TRAFFIC_SHIFT: "POST_PRODUCTION_TRAFFIC_SHIFT";
  readonly POST_SCALE_UP: "POST_SCALE_UP";
  readonly POST_TEST_TRAFFIC_SHIFT: "POST_TEST_TRAFFIC_SHIFT";
  readonly PRE_SCALE_UP: "PRE_SCALE_UP";
  readonly PRODUCTION_TRAFFIC_SHIFT: "PRODUCTION_TRAFFIC_SHIFT";
  readonly RECONCILE_SERVICE: "RECONCILE_SERVICE";
  readonly TEST_TRAFFIC_SHIFT: "TEST_TRAFFIC_SHIFT";
};
export type DeploymentLifecycleHookStage =
  (typeof DeploymentLifecycleHookStage)[keyof typeof DeploymentLifecycleHookStage];
export interface DeploymentLifecycleHook {
  hookTargetArn?: string | undefined;
  roleArn?: string | undefined;
  lifecycleStages?: DeploymentLifecycleHookStage[] | undefined;
  hookDetails?: __DocumentType | undefined;
}
export declare const DeploymentStrategy: {
  readonly BLUE_GREEN: "BLUE_GREEN";
  readonly ROLLING: "ROLLING";
};
export type DeploymentStrategy =
  (typeof DeploymentStrategy)[keyof typeof DeploymentStrategy];
export interface DeploymentConfiguration {
  deploymentCircuitBreaker?: DeploymentCircuitBreaker | undefined;
  maximumPercent?: number | undefined;
  minimumHealthyPercent?: number | undefined;
  alarms?: DeploymentAlarms | undefined;
  strategy?: DeploymentStrategy | undefined;
  bakeTimeInMinutes?: number | undefined;
  lifecycleHooks?: DeploymentLifecycleHook[] | undefined;
}
export declare const DeploymentControllerType: {
  readonly CODE_DEPLOY: "CODE_DEPLOY";
  readonly ECS: "ECS";
  readonly EXTERNAL: "EXTERNAL";
};
export type DeploymentControllerType =
  (typeof DeploymentControllerType)[keyof typeof DeploymentControllerType];
export interface DeploymentController {
  type: DeploymentControllerType | undefined;
}
export declare const LaunchType: {
  readonly EC2: "EC2";
  readonly EXTERNAL: "EXTERNAL";
  readonly FARGATE: "FARGATE";
  readonly MANAGED_INSTANCES: "MANAGED_INSTANCES";
};
export type LaunchType = (typeof LaunchType)[keyof typeof LaunchType];
export interface LoadBalancer {
  targetGroupArn?: string | undefined;
  loadBalancerName?: string | undefined;
  containerName?: string | undefined;
  containerPort?: number | undefined;
  advancedConfiguration?: AdvancedConfiguration | undefined;
}
export declare const AssignPublicIp: {
  readonly DISABLED: "DISABLED";
  readonly ENABLED: "ENABLED";
};
export type AssignPublicIp =
  (typeof AssignPublicIp)[keyof typeof AssignPublicIp];
export interface AwsVpcConfiguration {
  subnets: string[] | undefined;
  securityGroups?: string[] | undefined;
  assignPublicIp?: AssignPublicIp | undefined;
}
export interface NetworkConfiguration {
  awsvpcConfiguration?: AwsVpcConfiguration | undefined;
}
export declare const PlacementConstraintType: {
  readonly DISTINCT_INSTANCE: "distinctInstance";
  readonly MEMBER_OF: "memberOf";
};
export type PlacementConstraintType =
  (typeof PlacementConstraintType)[keyof typeof PlacementConstraintType];
export interface PlacementConstraint {
  type?: PlacementConstraintType | undefined;
  expression?: string | undefined;
}
export declare const PlacementStrategyType: {
  readonly BINPACK: "binpack";
  readonly RANDOM: "random";
  readonly SPREAD: "spread";
};
export type PlacementStrategyType =
  (typeof PlacementStrategyType)[keyof typeof PlacementStrategyType];
export interface PlacementStrategy {
  type?: PlacementStrategyType | undefined;
  field?: string | undefined;
}
export declare const PropagateTags: {
  readonly NONE: "NONE";
  readonly SERVICE: "SERVICE";
  readonly TASK_DEFINITION: "TASK_DEFINITION";
};
export type PropagateTags = (typeof PropagateTags)[keyof typeof PropagateTags];
export declare const SchedulingStrategy: {
  readonly DAEMON: "DAEMON";
  readonly REPLICA: "REPLICA";
};
export type SchedulingStrategy =
  (typeof SchedulingStrategy)[keyof typeof SchedulingStrategy];
export declare const LogDriver: {
  readonly AWSFIRELENS: "awsfirelens";
  readonly AWSLOGS: "awslogs";
  readonly FLUENTD: "fluentd";
  readonly GELF: "gelf";
  readonly JOURNALD: "journald";
  readonly JSON_FILE: "json-file";
  readonly SPLUNK: "splunk";
  readonly SYSLOG: "syslog";
};
export type LogDriver = (typeof LogDriver)[keyof typeof LogDriver];
export interface Secret {
  name: string | undefined;
  valueFrom: string | undefined;
}
export interface LogConfiguration {
  logDriver: LogDriver | undefined;
  options?: Record<string, string> | undefined;
  secretOptions?: Secret[] | undefined;
}
export interface ServiceConnectTestTrafficHeaderMatchRules {
  exact: string | undefined;
}
export interface ServiceConnectTestTrafficHeaderRules {
  name: string | undefined;
  value?: ServiceConnectTestTrafficHeaderMatchRules | undefined;
}
export interface ServiceConnectTestTrafficRules {
  header: ServiceConnectTestTrafficHeaderRules | undefined;
}
export interface ServiceConnectClientAlias {
  port: number | undefined;
  dnsName?: string | undefined;
  testTrafficRules?: ServiceConnectTestTrafficRules | undefined;
}
export interface TimeoutConfiguration {
  idleTimeoutSeconds?: number | undefined;
  perRequestTimeoutSeconds?: number | undefined;
}
export interface ServiceConnectTlsCertificateAuthority {
  awsPcaAuthorityArn?: string | undefined;
}
export interface ServiceConnectTlsConfiguration {
  issuerCertificateAuthority: ServiceConnectTlsCertificateAuthority | undefined;
  kmsKey?: string | undefined;
  roleArn?: string | undefined;
}
export interface ServiceConnectService {
  portName: string | undefined;
  discoveryName?: string | undefined;
  clientAliases?: ServiceConnectClientAlias[] | undefined;
  ingressPortOverride?: number | undefined;
  timeout?: TimeoutConfiguration | undefined;
  tls?: ServiceConnectTlsConfiguration | undefined;
}
export interface ServiceConnectConfiguration {
  enabled: boolean | undefined;
  namespace?: string | undefined;
  services?: ServiceConnectService[] | undefined;
  logConfiguration?: LogConfiguration | undefined;
}
export interface ServiceRegistry {
  registryArn?: string | undefined;
  port?: number | undefined;
  containerName?: string | undefined;
  containerPort?: number | undefined;
}
export declare const TaskFilesystemType: {
  readonly EXT3: "ext3";
  readonly EXT4: "ext4";
  readonly NTFS: "ntfs";
  readonly XFS: "xfs";
};
export type TaskFilesystemType =
  (typeof TaskFilesystemType)[keyof typeof TaskFilesystemType];
export declare const EBSResourceType: {
  readonly VOLUME: "volume";
};
export type EBSResourceType =
  (typeof EBSResourceType)[keyof typeof EBSResourceType];
export interface EBSTagSpecification {
  resourceType: EBSResourceType | undefined;
  tags?: Tag[] | undefined;
  propagateTags?: PropagateTags | undefined;
}
export interface ServiceManagedEBSVolumeConfiguration {
  encrypted?: boolean | undefined;
  kmsKeyId?: string | undefined;
  volumeType?: string | undefined;
  sizeInGiB?: number | undefined;
  snapshotId?: string | undefined;
  volumeInitializationRate?: number | undefined;
  iops?: number | undefined;
  throughput?: number | undefined;
  tagSpecifications?: EBSTagSpecification[] | undefined;
  roleArn: string | undefined;
  filesystemType?: TaskFilesystemType | undefined;
}
export interface ServiceVolumeConfiguration {
  name: string | undefined;
  managedEBSVolume?: ServiceManagedEBSVolumeConfiguration | undefined;
}
export interface VpcLatticeConfiguration {
  roleArn: string | undefined;
  targetGroupArn: string | undefined;
  portName: string | undefined;
}
export interface CreateServiceRequest {
  cluster?: string | undefined;
  serviceName: string | undefined;
  taskDefinition?: string | undefined;
  availabilityZoneRebalancing?: AvailabilityZoneRebalancing | undefined;
  loadBalancers?: LoadBalancer[] | undefined;
  serviceRegistries?: ServiceRegistry[] | undefined;
  desiredCount?: number | undefined;
  clientToken?: string | undefined;
  launchType?: LaunchType | undefined;
  capacityProviderStrategy?: CapacityProviderStrategyItem[] | undefined;
  platformVersion?: string | undefined;
  role?: string | undefined;
  deploymentConfiguration?: DeploymentConfiguration | undefined;
  placementConstraints?: PlacementConstraint[] | undefined;
  placementStrategy?: PlacementStrategy[] | undefined;
  networkConfiguration?: NetworkConfiguration | undefined;
  healthCheckGracePeriodSeconds?: number | undefined;
  schedulingStrategy?: SchedulingStrategy | undefined;
  deploymentController?: DeploymentController | undefined;
  tags?: Tag[] | undefined;
  enableECSManagedTags?: boolean | undefined;
  propagateTags?: PropagateTags | undefined;
  enableExecuteCommand?: boolean | undefined;
  serviceConnectConfiguration?: ServiceConnectConfiguration | undefined;
  volumeConfigurations?: ServiceVolumeConfiguration[] | undefined;
  vpcLatticeConfigurations?: VpcLatticeConfiguration[] | undefined;
}
export interface DeploymentEphemeralStorage {
  kmsKeyId?: string | undefined;
}
export declare const DeploymentRolloutState: {
  readonly COMPLETED: "COMPLETED";
  readonly FAILED: "FAILED";
  readonly IN_PROGRESS: "IN_PROGRESS";
};
export type DeploymentRolloutState =
  (typeof DeploymentRolloutState)[keyof typeof DeploymentRolloutState];
export interface ServiceConnectServiceResource {
  discoveryName?: string | undefined;
  discoveryArn?: string | undefined;
}
export interface Deployment {
  id?: string | undefined;
  status?: string | undefined;
  taskDefinition?: string | undefined;
  desiredCount?: number | undefined;
  pendingCount?: number | undefined;
  runningCount?: number | undefined;
  failedTasks?: number | undefined;
  createdAt?: Date | undefined;
  updatedAt?: Date | undefined;
  capacityProviderStrategy?: CapacityProviderStrategyItem[] | undefined;
  launchType?: LaunchType | undefined;
  platformVersion?: string | undefined;
  platformFamily?: string | undefined;
  networkConfiguration?: NetworkConfiguration | undefined;
  rolloutState?: DeploymentRolloutState | undefined;
  rolloutStateReason?: string | undefined;
  serviceConnectConfiguration?: ServiceConnectConfiguration | undefined;
  serviceConnectResources?: ServiceConnectServiceResource[] | undefined;
  volumeConfigurations?: ServiceVolumeConfiguration[] | undefined;
  fargateEphemeralStorage?: DeploymentEphemeralStorage | undefined;
  vpcLatticeConfigurations?: VpcLatticeConfiguration[] | undefined;
}
export interface ServiceEvent {
  id?: string | undefined;
  createdAt?: Date | undefined;
  message?: string | undefined;
}
export declare const ScaleUnit: {
  readonly PERCENT: "PERCENT";
};
export type ScaleUnit = (typeof ScaleUnit)[keyof typeof ScaleUnit];
export interface Scale {
  value?: number | undefined;
  unit?: ScaleUnit | undefined;
}
export declare const StabilityStatus: {
  readonly STABILIZING: "STABILIZING";
  readonly STEADY_STATE: "STEADY_STATE";
};
export type StabilityStatus =
  (typeof StabilityStatus)[keyof typeof StabilityStatus];
export interface TaskSet {
  id?: string | undefined;
  taskSetArn?: string | undefined;
  serviceArn?: string | undefined;
  clusterArn?: string | undefined;
  startedBy?: string | undefined;
  externalId?: string | undefined;
  status?: string | undefined;
  taskDefinition?: string | undefined;
  computedDesiredCount?: number | undefined;
  pendingCount?: number | undefined;
  runningCount?: number | undefined;
  createdAt?: Date | undefined;
  updatedAt?: Date | undefined;
  launchType?: LaunchType | undefined;
  capacityProviderStrategy?: CapacityProviderStrategyItem[] | undefined;
  platformVersion?: string | undefined;
  platformFamily?: string | undefined;
  networkConfiguration?: NetworkConfiguration | undefined;
  loadBalancers?: LoadBalancer[] | undefined;
  serviceRegistries?: ServiceRegistry[] | undefined;
  scale?: Scale | undefined;
  stabilityStatus?: StabilityStatus | undefined;
  stabilityStatusAt?: Date | undefined;
  tags?: Tag[] | undefined;
  fargateEphemeralStorage?: DeploymentEphemeralStorage | undefined;
}
export interface Service {
  serviceArn?: string | undefined;
  serviceName?: string | undefined;
  clusterArn?: string | undefined;
  loadBalancers?: LoadBalancer[] | undefined;
  serviceRegistries?: ServiceRegistry[] | undefined;
  status?: string | undefined;
  desiredCount?: number | undefined;
  runningCount?: number | undefined;
  pendingCount?: number | undefined;
  launchType?: LaunchType | undefined;
  capacityProviderStrategy?: CapacityProviderStrategyItem[] | undefined;
  platformVersion?: string | undefined;
  platformFamily?: string | undefined;
  taskDefinition?: string | undefined;
  deploymentConfiguration?: DeploymentConfiguration | undefined;
  taskSets?: TaskSet[] | undefined;
  deployments?: Deployment[] | undefined;
  roleArn?: string | undefined;
  events?: ServiceEvent[] | undefined;
  createdAt?: Date | undefined;
  placementConstraints?: PlacementConstraint[] | undefined;
  placementStrategy?: PlacementStrategy[] | undefined;
  networkConfiguration?: NetworkConfiguration | undefined;
  healthCheckGracePeriodSeconds?: number | undefined;
  schedulingStrategy?: SchedulingStrategy | undefined;
  deploymentController?: DeploymentController | undefined;
  tags?: Tag[] | undefined;
  createdBy?: string | undefined;
  enableECSManagedTags?: boolean | undefined;
  propagateTags?: PropagateTags | undefined;
  enableExecuteCommand?: boolean | undefined;
  availabilityZoneRebalancing?: AvailabilityZoneRebalancing | undefined;
}
export interface CreateServiceResponse {
  service?: Service | undefined;
}
export declare class PlatformTaskDefinitionIncompatibilityException extends __BaseException {
  readonly name: "PlatformTaskDefinitionIncompatibilityException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      PlatformTaskDefinitionIncompatibilityException,
      __BaseException
    >
  );
}
export declare class PlatformUnknownException extends __BaseException {
  readonly name: "PlatformUnknownException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<PlatformUnknownException, __BaseException>
  );
}
export interface CreateTaskSetRequest {
  service: string | undefined;
  cluster: string | undefined;
  externalId?: string | undefined;
  taskDefinition: string | undefined;
  networkConfiguration?: NetworkConfiguration | undefined;
  loadBalancers?: LoadBalancer[] | undefined;
  serviceRegistries?: ServiceRegistry[] | undefined;
  launchType?: LaunchType | undefined;
  capacityProviderStrategy?: CapacityProviderStrategyItem[] | undefined;
  platformVersion?: string | undefined;
  scale?: Scale | undefined;
  clientToken?: string | undefined;
  tags?: Tag[] | undefined;
}
export interface CreateTaskSetResponse {
  taskSet?: TaskSet | undefined;
}
export declare class ServiceNotActiveException extends __BaseException {
  readonly name: "ServiceNotActiveException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<ServiceNotActiveException, __BaseException>
  );
}
export declare class ServiceNotFoundException extends __BaseException {
  readonly name: "ServiceNotFoundException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<ServiceNotFoundException, __BaseException>
  );
}
export declare const SettingName: {
  readonly AWSVPC_TRUNKING: "awsvpcTrunking";
  readonly CONTAINER_INSIGHTS: "containerInsights";
  readonly CONTAINER_INSTANCE_LONG_ARN_FORMAT: "containerInstanceLongArnFormat";
  readonly DEFAULT_LOG_DRIVER_MODE: "defaultLogDriverMode";
  readonly FARGATE_FIPS_MODE: "fargateFIPSMode";
  readonly FARGATE_TASK_RETIREMENT_WAIT_PERIOD: "fargateTaskRetirementWaitPeriod";
  readonly GUARD_DUTY_ACTIVATE: "guardDutyActivate";
  readonly SERVICE_LONG_ARN_FORMAT: "serviceLongArnFormat";
  readonly TAG_RESOURCE_AUTHORIZATION: "tagResourceAuthorization";
  readonly TASK_LONG_ARN_FORMAT: "taskLongArnFormat";
};
export type SettingName = (typeof SettingName)[keyof typeof SettingName];
export interface DeleteAccountSettingRequest {
  name: SettingName | undefined;
  principalArn?: string | undefined;
}
export declare const SettingType: {
  readonly AWS_MANAGED: "aws_managed";
  readonly USER: "user";
};
export type SettingType = (typeof SettingType)[keyof typeof SettingType];
export interface Setting {
  name?: SettingName | undefined;
  value?: string | undefined;
  principalArn?: string | undefined;
  type?: SettingType | undefined;
}
export interface DeleteAccountSettingResponse {
  setting?: Setting | undefined;
}
export declare const TargetType: {
  readonly CONTAINER_INSTANCE: "container-instance";
};
export type TargetType = (typeof TargetType)[keyof typeof TargetType];
export interface Attribute {
  name: string | undefined;
  value?: string | undefined;
  targetType?: TargetType | undefined;
  targetId?: string | undefined;
}
export interface DeleteAttributesRequest {
  cluster?: string | undefined;
  attributes: Attribute[] | undefined;
}
export interface DeleteAttributesResponse {
  attributes?: Attribute[] | undefined;
}
export declare class TargetNotFoundException extends __BaseException {
  readonly name: "TargetNotFoundException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<TargetNotFoundException, __BaseException>
  );
}
export interface DeleteCapacityProviderRequest {
  capacityProvider: string | undefined;
  cluster?: string | undefined;
}
export interface DeleteCapacityProviderResponse {
  capacityProvider?: CapacityProvider | undefined;
}
export declare class ClusterContainsCapacityProviderException extends __BaseException {
  readonly name: "ClusterContainsCapacityProviderException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      ClusterContainsCapacityProviderException,
      __BaseException
    >
  );
}
export declare class ClusterContainsContainerInstancesException extends __BaseException {
  readonly name: "ClusterContainsContainerInstancesException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      ClusterContainsContainerInstancesException,
      __BaseException
    >
  );
}
export declare class ClusterContainsServicesException extends __BaseException {
  readonly name: "ClusterContainsServicesException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      ClusterContainsServicesException,
      __BaseException
    >
  );
}
export declare class ClusterContainsTasksException extends __BaseException {
  readonly name: "ClusterContainsTasksException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<ClusterContainsTasksException, __BaseException>
  );
}
export interface DeleteClusterRequest {
  cluster: string | undefined;
}
export interface DeleteClusterResponse {
  cluster?: Cluster | undefined;
}
export interface DeleteServiceRequest {
  cluster?: string | undefined;
  service: string | undefined;
  force?: boolean | undefined;
}
export interface DeleteServiceResponse {
  service?: Service | undefined;
}
export interface DeleteTaskDefinitionsRequest {
  taskDefinitions: string[] | undefined;
}
export interface Failure {
  arn?: string | undefined;
  reason?: string | undefined;
  detail?: string | undefined;
}
export declare const Compatibility: {
  readonly EC2: "EC2";
  readonly EXTERNAL: "EXTERNAL";
  readonly FARGATE: "FARGATE";
  readonly MANAGED_INSTANCES: "MANAGED_INSTANCES";
};
export type Compatibility = (typeof Compatibility)[keyof typeof Compatibility];
export declare const ContainerCondition: {
  readonly COMPLETE: "COMPLETE";
  readonly HEALTHY: "HEALTHY";
  readonly START: "START";
  readonly SUCCESS: "SUCCESS";
};
export type ContainerCondition =
  (typeof ContainerCondition)[keyof typeof ContainerCondition];
export interface ContainerDependency {
  containerName: string | undefined;
  condition: ContainerCondition | undefined;
}
export declare const EnvironmentFileType: {
  readonly S3: "s3";
};
export type EnvironmentFileType =
  (typeof EnvironmentFileType)[keyof typeof EnvironmentFileType];
export interface EnvironmentFile {
  value: string | undefined;
  type: EnvironmentFileType | undefined;
}
export interface HostEntry {
  hostname: string | undefined;
  ipAddress: string | undefined;
}
export declare const FirelensConfigurationType: {
  readonly FLUENTBIT: "fluentbit";
  readonly FLUENTD: "fluentd";
};
export type FirelensConfigurationType =
  (typeof FirelensConfigurationType)[keyof typeof FirelensConfigurationType];
export interface FirelensConfiguration {
  type: FirelensConfigurationType | undefined;
  options?: Record<string, string> | undefined;
}
export interface HealthCheck {
  command: string[] | undefined;
  interval?: number | undefined;
  timeout?: number | undefined;
  retries?: number | undefined;
  startPeriod?: number | undefined;
}
export interface KernelCapabilities {
  add?: string[] | undefined;
  drop?: string[] | undefined;
}
export declare const DeviceCgroupPermission: {
  readonly MKNOD: "mknod";
  readonly READ: "read";
  readonly WRITE: "write";
};
export type DeviceCgroupPermission =
  (typeof DeviceCgroupPermission)[keyof typeof DeviceCgroupPermission];
export interface Device {
  hostPath: string | undefined;
  containerPath?: string | undefined;
  permissions?: DeviceCgroupPermission[] | undefined;
}
export interface Tmpfs {
  containerPath: string | undefined;
  size: number | undefined;
  mountOptions?: string[] | undefined;
}
export interface LinuxParameters {
  capabilities?: KernelCapabilities | undefined;
  devices?: Device[] | undefined;
  initProcessEnabled?: boolean | undefined;
  sharedMemorySize?: number | undefined;
  tmpfs?: Tmpfs[] | undefined;
  maxSwap?: number | undefined;
  swappiness?: number | undefined;
}
export interface MountPoint {
  sourceVolume?: string | undefined;
  containerPath?: string | undefined;
  readOnly?: boolean | undefined;
}
export declare const ApplicationProtocol: {
  readonly GRPC: "grpc";
  readonly HTTP: "http";
  readonly HTTP2: "http2";
};
export type ApplicationProtocol =
  (typeof ApplicationProtocol)[keyof typeof ApplicationProtocol];
export declare const TransportProtocol: {
  readonly TCP: "tcp";
  readonly UDP: "udp";
};
export type TransportProtocol =
  (typeof TransportProtocol)[keyof typeof TransportProtocol];
export interface PortMapping {
  containerPort?: number | undefined;
  hostPort?: number | undefined;
  protocol?: TransportProtocol | undefined;
  name?: string | undefined;
  appProtocol?: ApplicationProtocol | undefined;
  containerPortRange?: string | undefined;
}
export interface RepositoryCredentials {
  credentialsParameter: string | undefined;
}
export declare const ResourceType: {
  readonly GPU: "GPU";
  readonly INFERENCE_ACCELERATOR: "InferenceAccelerator";
};
export type ResourceType = (typeof ResourceType)[keyof typeof ResourceType];
export interface ResourceRequirement {
  value: string | undefined;
  type: ResourceType | undefined;
}
export interface ContainerRestartPolicy {
  enabled: boolean | undefined;
  ignoredExitCodes?: number[] | undefined;
  restartAttemptPeriod?: number | undefined;
}
export interface SystemControl {
  namespace?: string | undefined;
  value?: string | undefined;
}
export declare const UlimitName: {
  readonly CORE: "core";
  readonly CPU: "cpu";
  readonly DATA: "data";
  readonly FSIZE: "fsize";
  readonly LOCKS: "locks";
  readonly MEMLOCK: "memlock";
  readonly MSGQUEUE: "msgqueue";
  readonly NICE: "nice";
  readonly NOFILE: "nofile";
  readonly NPROC: "nproc";
  readonly RSS: "rss";
  readonly RTPRIO: "rtprio";
  readonly RTTIME: "rttime";
  readonly SIGPENDING: "sigpending";
  readonly STACK: "stack";
};
export type UlimitName = (typeof UlimitName)[keyof typeof UlimitName];
export interface Ulimit {
  name: UlimitName | undefined;
  softLimit: number | undefined;
  hardLimit: number | undefined;
}
export declare const VersionConsistency: {
  readonly DISABLED: "disabled";
  readonly ENABLED: "enabled";
};
export type VersionConsistency =
  (typeof VersionConsistency)[keyof typeof VersionConsistency];
export interface VolumeFrom {
  sourceContainer?: string | undefined;
  readOnly?: boolean | undefined;
}
export interface ContainerDefinition {
  name?: string | undefined;
  image?: string | undefined;
  repositoryCredentials?: RepositoryCredentials | undefined;
  cpu?: number | undefined;
  memory?: number | undefined;
  memoryReservation?: number | undefined;
  links?: string[] | undefined;
  portMappings?: PortMapping[] | undefined;
  essential?: boolean | undefined;
  restartPolicy?: ContainerRestartPolicy | undefined;
  entryPoint?: string[] | undefined;
  command?: string[] | undefined;
  environment?: KeyValuePair[] | undefined;
  environmentFiles?: EnvironmentFile[] | undefined;
  mountPoints?: MountPoint[] | undefined;
  volumesFrom?: VolumeFrom[] | undefined;
  linuxParameters?: LinuxParameters | undefined;
  secrets?: Secret[] | undefined;
  dependsOn?: ContainerDependency[] | undefined;
  startTimeout?: number | undefined;
  stopTimeout?: number | undefined;
  versionConsistency?: VersionConsistency | undefined;
  hostname?: string | undefined;
  user?: string | undefined;
  workingDirectory?: string | undefined;
  disableNetworking?: boolean | undefined;
  privileged?: boolean | undefined;
  readonlyRootFilesystem?: boolean | undefined;
  dnsServers?: string[] | undefined;
  dnsSearchDomains?: string[] | undefined;
  extraHosts?: HostEntry[] | undefined;
  dockerSecurityOptions?: string[] | undefined;
  interactive?: boolean | undefined;
  pseudoTerminal?: boolean | undefined;
  dockerLabels?: Record<string, string> | undefined;
  ulimits?: Ulimit[] | undefined;
  logConfiguration?: LogConfiguration | undefined;
  healthCheck?: HealthCheck | undefined;
  systemControls?: SystemControl[] | undefined;
  resourceRequirements?: ResourceRequirement[] | undefined;
  firelensConfiguration?: FirelensConfiguration | undefined;
  credentialSpecs?: string[] | undefined;
}
export interface EphemeralStorage {
  sizeInGiB: number | undefined;
}
export interface InferenceAccelerator {
  deviceName: string | undefined;
  deviceType: string | undefined;
}
export declare const IpcMode: {
  readonly HOST: "host";
  readonly NONE: "none";
  readonly TASK: "task";
};
export type IpcMode = (typeof IpcMode)[keyof typeof IpcMode];
export declare const NetworkMode: {
  readonly AWSVPC: "awsvpc";
  readonly BRIDGE: "bridge";
  readonly HOST: "host";
  readonly NONE: "none";
};
export type NetworkMode = (typeof NetworkMode)[keyof typeof NetworkMode];
export declare const PidMode: {
  readonly HOST: "host";
  readonly TASK: "task";
};
export type PidMode = (typeof PidMode)[keyof typeof PidMode];
export declare const TaskDefinitionPlacementConstraintType: {
  readonly MEMBER_OF: "memberOf";
};
export type TaskDefinitionPlacementConstraintType =
  (typeof TaskDefinitionPlacementConstraintType)[keyof typeof TaskDefinitionPlacementConstraintType];
export interface TaskDefinitionPlacementConstraint {
  type?: TaskDefinitionPlacementConstraintType | undefined;
  expression?: string | undefined;
}
export declare const ProxyConfigurationType: {
  readonly APPMESH: "APPMESH";
};
export type ProxyConfigurationType =
  (typeof ProxyConfigurationType)[keyof typeof ProxyConfigurationType];
export interface ProxyConfiguration {
  type?: ProxyConfigurationType | undefined;
  containerName: string | undefined;
  properties?: KeyValuePair[] | undefined;
}
export declare const CPUArchitecture: {
  readonly ARM64: "ARM64";
  readonly X86_64: "X86_64";
};
export type CPUArchitecture =
  (typeof CPUArchitecture)[keyof typeof CPUArchitecture];
export declare const OSFamily: {
  readonly LINUX: "LINUX";
  readonly WINDOWS_SERVER_2004_CORE: "WINDOWS_SERVER_2004_CORE";
  readonly WINDOWS_SERVER_2016_FULL: "WINDOWS_SERVER_2016_FULL";
  readonly WINDOWS_SERVER_2019_CORE: "WINDOWS_SERVER_2019_CORE";
  readonly WINDOWS_SERVER_2019_FULL: "WINDOWS_SERVER_2019_FULL";
  readonly WINDOWS_SERVER_2022_CORE: "WINDOWS_SERVER_2022_CORE";
  readonly WINDOWS_SERVER_2022_FULL: "WINDOWS_SERVER_2022_FULL";
  readonly WINDOWS_SERVER_2025_CORE: "WINDOWS_SERVER_2025_CORE";
  readonly WINDOWS_SERVER_2025_FULL: "WINDOWS_SERVER_2025_FULL";
  readonly WINDOWS_SERVER_20H2_CORE: "WINDOWS_SERVER_20H2_CORE";
};
export type OSFamily = (typeof OSFamily)[keyof typeof OSFamily];
export interface RuntimePlatform {
  cpuArchitecture?: CPUArchitecture | undefined;
  operatingSystemFamily?: OSFamily | undefined;
}
export declare const TaskDefinitionStatus: {
  readonly ACTIVE: "ACTIVE";
  readonly DELETE_IN_PROGRESS: "DELETE_IN_PROGRESS";
  readonly INACTIVE: "INACTIVE";
};
export type TaskDefinitionStatus =
  (typeof TaskDefinitionStatus)[keyof typeof TaskDefinitionStatus];
export declare const Scope: {
  readonly SHARED: "shared";
  readonly TASK: "task";
};
export type Scope = (typeof Scope)[keyof typeof Scope];
export interface DockerVolumeConfiguration {
  scope?: Scope | undefined;
  autoprovision?: boolean | undefined;
  driver?: string | undefined;
  driverOpts?: Record<string, string> | undefined;
  labels?: Record<string, string> | undefined;
}
export declare const EFSAuthorizationConfigIAM: {
  readonly DISABLED: "DISABLED";
  readonly ENABLED: "ENABLED";
};
export type EFSAuthorizationConfigIAM =
  (typeof EFSAuthorizationConfigIAM)[keyof typeof EFSAuthorizationConfigIAM];
export interface EFSAuthorizationConfig {
  accessPointId?: string | undefined;
  iam?: EFSAuthorizationConfigIAM | undefined;
}
export declare const EFSTransitEncryption: {
  readonly DISABLED: "DISABLED";
  readonly ENABLED: "ENABLED";
};
export type EFSTransitEncryption =
  (typeof EFSTransitEncryption)[keyof typeof EFSTransitEncryption];
export interface EFSVolumeConfiguration {
  fileSystemId: string | undefined;
  rootDirectory?: string | undefined;
  transitEncryption?: EFSTransitEncryption | undefined;
  transitEncryptionPort?: number | undefined;
  authorizationConfig?: EFSAuthorizationConfig | undefined;
}
export interface FSxWindowsFileServerAuthorizationConfig {
  credentialsParameter: string | undefined;
  domain: string | undefined;
}
export interface FSxWindowsFileServerVolumeConfiguration {
  fileSystemId: string | undefined;
  rootDirectory: string | undefined;
  authorizationConfig: FSxWindowsFileServerAuthorizationConfig | undefined;
}
export interface HostVolumeProperties {
  sourcePath?: string | undefined;
}
export interface Volume {
  name?: string | undefined;
  host?: HostVolumeProperties | undefined;
  dockerVolumeConfiguration?: DockerVolumeConfiguration | undefined;
  efsVolumeConfiguration?: EFSVolumeConfiguration | undefined;
  fsxWindowsFileServerVolumeConfiguration?:
    | FSxWindowsFileServerVolumeConfiguration
    | undefined;
  configuredAtLaunch?: boolean | undefined;
}
export interface TaskDefinition {
  taskDefinitionArn?: string | undefined;
  containerDefinitions?: ContainerDefinition[] | undefined;
  family?: string | undefined;
  taskRoleArn?: string | undefined;
  executionRoleArn?: string | undefined;
  networkMode?: NetworkMode | undefined;
  revision?: number | undefined;
  volumes?: Volume[] | undefined;
  status?: TaskDefinitionStatus | undefined;
  requiresAttributes?: Attribute[] | undefined;
  placementConstraints?: TaskDefinitionPlacementConstraint[] | undefined;
  compatibilities?: Compatibility[] | undefined;
  runtimePlatform?: RuntimePlatform | undefined;
  requiresCompatibilities?: Compatibility[] | undefined;
  cpu?: string | undefined;
  memory?: string | undefined;
  inferenceAccelerators?: InferenceAccelerator[] | undefined;
  pidMode?: PidMode | undefined;
  ipcMode?: IpcMode | undefined;
  proxyConfiguration?: ProxyConfiguration | undefined;
  registeredAt?: Date | undefined;
  deregisteredAt?: Date | undefined;
  registeredBy?: string | undefined;
  ephemeralStorage?: EphemeralStorage | undefined;
  enableFaultInjection?: boolean | undefined;
}
export interface DeleteTaskDefinitionsResponse {
  taskDefinitions?: TaskDefinition[] | undefined;
  failures?: Failure[] | undefined;
}
export interface DeleteTaskSetRequest {
  cluster: string | undefined;
  service: string | undefined;
  taskSet: string | undefined;
  force?: boolean | undefined;
}
export interface DeleteTaskSetResponse {
  taskSet?: TaskSet | undefined;
}
export declare class TaskSetNotFoundException extends __BaseException {
  readonly name: "TaskSetNotFoundException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<TaskSetNotFoundException, __BaseException>
  );
}
export interface DeregisterContainerInstanceRequest {
  cluster?: string | undefined;
  containerInstance: string | undefined;
  force?: boolean | undefined;
}
export declare const InstanceHealthCheckState: {
  readonly IMPAIRED: "IMPAIRED";
  readonly INITIALIZING: "INITIALIZING";
  readonly INSUFFICIENT_DATA: "INSUFFICIENT_DATA";
  readonly OK: "OK";
};
export type InstanceHealthCheckState =
  (typeof InstanceHealthCheckState)[keyof typeof InstanceHealthCheckState];
export declare const InstanceHealthCheckType: {
  readonly CONTAINER_RUNTIME: "CONTAINER_RUNTIME";
};
export type InstanceHealthCheckType =
  (typeof InstanceHealthCheckType)[keyof typeof InstanceHealthCheckType];
export interface InstanceHealthCheckResult {
  type?: InstanceHealthCheckType | undefined;
  status?: InstanceHealthCheckState | undefined;
  lastUpdated?: Date | undefined;
  lastStatusChange?: Date | undefined;
}
export interface ContainerInstanceHealthStatus {
  overallStatus?: InstanceHealthCheckState | undefined;
  details?: InstanceHealthCheckResult[] | undefined;
}
export interface Resource {
  name?: string | undefined;
  type?: string | undefined;
  doubleValue?: number | undefined;
  longValue?: number | undefined;
  integerValue?: number | undefined;
  stringSetValue?: string[] | undefined;
}
export interface VersionInfo {
  agentVersion?: string | undefined;
  agentHash?: string | undefined;
  dockerVersion?: string | undefined;
}
export interface ContainerInstance {
  containerInstanceArn?: string | undefined;
  ec2InstanceId?: string | undefined;
  capacityProviderName?: string | undefined;
  version?: number | undefined;
  versionInfo?: VersionInfo | undefined;
  remainingResources?: Resource[] | undefined;
  registeredResources?: Resource[] | undefined;
  status?: string | undefined;
  statusReason?: string | undefined;
  agentConnected?: boolean | undefined;
  runningTasksCount?: number | undefined;
  pendingTasksCount?: number | undefined;
  agentUpdateStatus?: AgentUpdateStatus | undefined;
  attributes?: Attribute[] | undefined;
  registeredAt?: Date | undefined;
  attachments?: Attachment[] | undefined;
  tags?: Tag[] | undefined;
  healthStatus?: ContainerInstanceHealthStatus | undefined;
}
export interface DeregisterContainerInstanceResponse {
  containerInstance?: ContainerInstance | undefined;
}
export interface DeregisterTaskDefinitionRequest {
  taskDefinition: string | undefined;
}
export interface DeregisterTaskDefinitionResponse {
  taskDefinition?: TaskDefinition | undefined;
}
export declare const CapacityProviderField: {
  readonly TAGS: "TAGS";
};
export type CapacityProviderField =
  (typeof CapacityProviderField)[keyof typeof CapacityProviderField];
export interface DescribeCapacityProvidersRequest {
  capacityProviders?: string[] | undefined;
  cluster?: string | undefined;
  include?: CapacityProviderField[] | undefined;
  maxResults?: number | undefined;
  nextToken?: string | undefined;
}
export interface DescribeCapacityProvidersResponse {
  capacityProviders?: CapacityProvider[] | undefined;
  failures?: Failure[] | undefined;
  nextToken?: string | undefined;
}
export declare const ClusterField: {
  readonly ATTACHMENTS: "ATTACHMENTS";
  readonly CONFIGURATIONS: "CONFIGURATIONS";
  readonly SETTINGS: "SETTINGS";
  readonly STATISTICS: "STATISTICS";
  readonly TAGS: "TAGS";
};
export type ClusterField = (typeof ClusterField)[keyof typeof ClusterField];
export interface DescribeClustersRequest {
  clusters?: string[] | undefined;
  include?: ClusterField[] | undefined;
}
export interface DescribeClustersResponse {
  clusters?: Cluster[] | undefined;
  failures?: Failure[] | undefined;
}
export declare const ContainerInstanceField: {
  readonly CONTAINER_INSTANCE_HEALTH: "CONTAINER_INSTANCE_HEALTH";
  readonly TAGS: "TAGS";
};
export type ContainerInstanceField =
  (typeof ContainerInstanceField)[keyof typeof ContainerInstanceField];
export interface DescribeContainerInstancesRequest {
  cluster?: string | undefined;
  containerInstances: string[] | undefined;
  include?: ContainerInstanceField[] | undefined;
}
export interface DescribeContainerInstancesResponse {
  containerInstances?: ContainerInstance[] | undefined;
  failures?: Failure[] | undefined;
}
export interface DescribeServiceDeploymentsRequest {
  serviceDeploymentArns: string[] | undefined;
}
export declare const ServiceDeploymentRollbackMonitorsStatus: {
  readonly DISABLED: "DISABLED";
  readonly MONITORING: "MONITORING";
  readonly MONITORING_COMPLETE: "MONITORING_COMPLETE";
  readonly TRIGGERED: "TRIGGERED";
};
export type ServiceDeploymentRollbackMonitorsStatus =
  (typeof ServiceDeploymentRollbackMonitorsStatus)[keyof typeof ServiceDeploymentRollbackMonitorsStatus];
export interface ServiceDeploymentAlarms {
  status?: ServiceDeploymentRollbackMonitorsStatus | undefined;
  alarmNames?: string[] | undefined;
  triggeredAlarmNames?: string[] | undefined;
}
export interface ServiceDeploymentCircuitBreaker {
  status?: ServiceDeploymentRollbackMonitorsStatus | undefined;
  failureCount?: number | undefined;
  threshold?: number | undefined;
}
export declare const ServiceDeploymentLifecycleStage: {
  readonly BAKE_TIME: "BAKE_TIME";
  readonly CLEAN_UP: "CLEAN_UP";
  readonly POST_PRODUCTION_TRAFFIC_SHIFT: "POST_PRODUCTION_TRAFFIC_SHIFT";
  readonly POST_SCALE_UP: "POST_SCALE_UP";
  readonly POST_TEST_TRAFFIC_SHIFT: "POST_TEST_TRAFFIC_SHIFT";
  readonly PRE_SCALE_UP: "PRE_SCALE_UP";
  readonly PRODUCTION_TRAFFIC_SHIFT: "PRODUCTION_TRAFFIC_SHIFT";
  readonly RECONCILE_SERVICE: "RECONCILE_SERVICE";
  readonly SCALE_UP: "SCALE_UP";
  readonly TEST_TRAFFIC_SHIFT: "TEST_TRAFFIC_SHIFT";
};
export type ServiceDeploymentLifecycleStage =
  (typeof ServiceDeploymentLifecycleStage)[keyof typeof ServiceDeploymentLifecycleStage];
export interface Rollback {
  reason?: string | undefined;
  startedAt?: Date | undefined;
  serviceRevisionArn?: string | undefined;
}
export interface ServiceRevisionSummary {
  arn?: string | undefined;
  requestedTaskCount?: number | undefined;
  runningTaskCount?: number | undefined;
  pendingTaskCount?: number | undefined;
}
export declare const ServiceDeploymentStatus: {
  readonly IN_PROGRESS: "IN_PROGRESS";
  readonly PENDING: "PENDING";
  readonly ROLLBACK_FAILED: "ROLLBACK_FAILED";
  readonly ROLLBACK_IN_PROGRESS: "ROLLBACK_IN_PROGRESS";
  readonly ROLLBACK_REQUESTED: "ROLLBACK_REQUESTED";
  readonly ROLLBACK_SUCCESSFUL: "ROLLBACK_SUCCESSFUL";
  readonly STOPPED: "STOPPED";
  readonly STOP_REQUESTED: "STOP_REQUESTED";
  readonly SUCCESSFUL: "SUCCESSFUL";
};
export type ServiceDeploymentStatus =
  (typeof ServiceDeploymentStatus)[keyof typeof ServiceDeploymentStatus];
export interface ServiceDeployment {
  serviceDeploymentArn?: string | undefined;
  serviceArn?: string | undefined;
  clusterArn?: string | undefined;
  createdAt?: Date | undefined;
  startedAt?: Date | undefined;
  finishedAt?: Date | undefined;
  stoppedAt?: Date | undefined;
  updatedAt?: Date | undefined;
  sourceServiceRevisions?: ServiceRevisionSummary[] | undefined;
  targetServiceRevision?: ServiceRevisionSummary | undefined;
  status?: ServiceDeploymentStatus | undefined;
  statusReason?: string | undefined;
  lifecycleStage?: ServiceDeploymentLifecycleStage | undefined;
  deploymentConfiguration?: DeploymentConfiguration | undefined;
  rollback?: Rollback | undefined;
  deploymentCircuitBreaker?: ServiceDeploymentCircuitBreaker | undefined;
  alarms?: ServiceDeploymentAlarms | undefined;
}
export interface DescribeServiceDeploymentsResponse {
  serviceDeployments?: ServiceDeployment[] | undefined;
  failures?: Failure[] | undefined;
}
export interface DescribeServiceRevisionsRequest {
  serviceRevisionArns: string[] | undefined;
}
export interface ContainerImage {
  containerName?: string | undefined;
  imageDigest?: string | undefined;
  image?: string | undefined;
}
export interface ServiceRevisionLoadBalancer {
  targetGroupArn?: string | undefined;
  productionListenerRule?: string | undefined;
}
export interface ResolvedConfiguration {
  loadBalancers?: ServiceRevisionLoadBalancer[] | undefined;
}
export interface ServiceRevision {
  serviceRevisionArn?: string | undefined;
  serviceArn?: string | undefined;
  clusterArn?: string | undefined;
  taskDefinition?: string | undefined;
  capacityProviderStrategy?: CapacityProviderStrategyItem[] | undefined;
  launchType?: LaunchType | undefined;
  platformVersion?: string | undefined;
  platformFamily?: string | undefined;
  loadBalancers?: LoadBalancer[] | undefined;
  serviceRegistries?: ServiceRegistry[] | undefined;
  networkConfiguration?: NetworkConfiguration | undefined;
  containerImages?: ContainerImage[] | undefined;
  guardDutyEnabled?: boolean | undefined;
  serviceConnectConfiguration?: ServiceConnectConfiguration | undefined;
  volumeConfigurations?: ServiceVolumeConfiguration[] | undefined;
  fargateEphemeralStorage?: DeploymentEphemeralStorage | undefined;
  createdAt?: Date | undefined;
  vpcLatticeConfigurations?: VpcLatticeConfiguration[] | undefined;
  resolvedConfiguration?: ResolvedConfiguration | undefined;
}
export interface DescribeServiceRevisionsResponse {
  serviceRevisions?: ServiceRevision[] | undefined;
  failures?: Failure[] | undefined;
}
export declare const ServiceField: {
  readonly TAGS: "TAGS";
};
export type ServiceField = (typeof ServiceField)[keyof typeof ServiceField];
export interface DescribeServicesRequest {
  cluster?: string | undefined;
  services: string[] | undefined;
  include?: ServiceField[] | undefined;
}
export interface DescribeServicesResponse {
  services?: Service[] | undefined;
  failures?: Failure[] | undefined;
}
export declare const TaskDefinitionField: {
  readonly TAGS: "TAGS";
};
export type TaskDefinitionField =
  (typeof TaskDefinitionField)[keyof typeof TaskDefinitionField];
export interface DescribeTaskDefinitionRequest {
  taskDefinition: string | undefined;
  include?: TaskDefinitionField[] | undefined;
}
export interface DescribeTaskDefinitionResponse {
  taskDefinition?: TaskDefinition | undefined;
  tags?: Tag[] | undefined;
}
export declare const TaskField: {
  readonly TAGS: "TAGS";
};
export type TaskField = (typeof TaskField)[keyof typeof TaskField];
export interface DescribeTasksRequest {
  cluster?: string | undefined;
  tasks: string[] | undefined;
  include?: TaskField[] | undefined;
}
export declare const Connectivity: {
  readonly CONNECTED: "CONNECTED";
  readonly DISCONNECTED: "DISCONNECTED";
};
export type Connectivity = (typeof Connectivity)[keyof typeof Connectivity];
export declare const HealthStatus: {
  readonly HEALTHY: "HEALTHY";
  readonly UNHEALTHY: "UNHEALTHY";
  readonly UNKNOWN: "UNKNOWN";
};
export type HealthStatus = (typeof HealthStatus)[keyof typeof HealthStatus];
export declare const ManagedAgentName: {
  readonly ExecuteCommandAgent: "ExecuteCommandAgent";
};
export type ManagedAgentName =
  (typeof ManagedAgentName)[keyof typeof ManagedAgentName];
export interface ManagedAgent {
  lastStartedAt?: Date | undefined;
  name?: ManagedAgentName | undefined;
  reason?: string | undefined;
  lastStatus?: string | undefined;
}
export interface NetworkBinding {
  bindIP?: string | undefined;
  containerPort?: number | undefined;
  hostPort?: number | undefined;
  protocol?: TransportProtocol | undefined;
  containerPortRange?: string | undefined;
  hostPortRange?: string | undefined;
}
export interface NetworkInterface {
  attachmentId?: string | undefined;
  privateIpv4Address?: string | undefined;
  ipv6Address?: string | undefined;
}
export interface Container {
  containerArn?: string | undefined;
  taskArn?: string | undefined;
  name?: string | undefined;
  image?: string | undefined;
  imageDigest?: string | undefined;
  runtimeId?: string | undefined;
  lastStatus?: string | undefined;
  exitCode?: number | undefined;
  reason?: string | undefined;
  networkBindings?: NetworkBinding[] | undefined;
  networkInterfaces?: NetworkInterface[] | undefined;
  healthStatus?: HealthStatus | undefined;
  managedAgents?: ManagedAgent[] | undefined;
  cpu?: string | undefined;
  memory?: string | undefined;
  memoryReservation?: string | undefined;
  gpuIds?: string[] | undefined;
}
export interface TaskEphemeralStorage {
  sizeInGiB?: number | undefined;
  kmsKeyId?: string | undefined;
}
export interface ContainerOverride {
  name?: string | undefined;
  command?: string[] | undefined;
  environment?: KeyValuePair[] | undefined;
  environmentFiles?: EnvironmentFile[] | undefined;
  cpu?: number | undefined;
  memory?: number | undefined;
  memoryReservation?: number | undefined;
  resourceRequirements?: ResourceRequirement[] | undefined;
}
export interface InferenceAcceleratorOverride {
  deviceName?: string | undefined;
  deviceType?: string | undefined;
}
export interface TaskOverride {
  containerOverrides?: ContainerOverride[] | undefined;
  cpu?: string | undefined;
  inferenceAcceleratorOverrides?: InferenceAcceleratorOverride[] | undefined;
  executionRoleArn?: string | undefined;
  memory?: string | undefined;
  taskRoleArn?: string | undefined;
  ephemeralStorage?: EphemeralStorage | undefined;
}
export declare const TaskStopCode: {
  readonly ESSENTIAL_CONTAINER_EXITED: "EssentialContainerExited";
  readonly SERVICE_SCHEDULER_INITIATED: "ServiceSchedulerInitiated";
  readonly SPOT_INTERRUPTION: "SpotInterruption";
  readonly TASK_FAILED_TO_START: "TaskFailedToStart";
  readonly TERMINATION_NOTICE: "TerminationNotice";
  readonly USER_INITIATED: "UserInitiated";
};
export type TaskStopCode = (typeof TaskStopCode)[keyof typeof TaskStopCode];
export interface Task {
  attachments?: Attachment[] | undefined;
  attributes?: Attribute[] | undefined;
  availabilityZone?: string | undefined;
  capacityProviderName?: string | undefined;
  clusterArn?: string | undefined;
  connectivity?: Connectivity | undefined;
  connectivityAt?: Date | undefined;
  containerInstanceArn?: string | undefined;
  containers?: Container[] | undefined;
  cpu?: string | undefined;
  createdAt?: Date | undefined;
  desiredStatus?: string | undefined;
  enableExecuteCommand?: boolean | undefined;
  executionStoppedAt?: Date | undefined;
  group?: string | undefined;
  healthStatus?: HealthStatus | undefined;
  inferenceAccelerators?: InferenceAccelerator[] | undefined;
  lastStatus?: string | undefined;
  launchType?: LaunchType | undefined;
  memory?: string | undefined;
  overrides?: TaskOverride | undefined;
  platformVersion?: string | undefined;
  platformFamily?: string | undefined;
  pullStartedAt?: Date | undefined;
  pullStoppedAt?: Date | undefined;
  startedAt?: Date | undefined;
  startedBy?: string | undefined;
  stopCode?: TaskStopCode | undefined;
  stoppedAt?: Date | undefined;
  stoppedReason?: string | undefined;
  stoppingAt?: Date | undefined;
  tags?: Tag[] | undefined;
  taskArn?: string | undefined;
  taskDefinitionArn?: string | undefined;
  version?: number | undefined;
  ephemeralStorage?: EphemeralStorage | undefined;
  fargateEphemeralStorage?: TaskEphemeralStorage | undefined;
}
export interface DescribeTasksResponse {
  tasks?: Task[] | undefined;
  failures?: Failure[] | undefined;
}
export declare const TaskSetField: {
  readonly TAGS: "TAGS";
};
export type TaskSetField = (typeof TaskSetField)[keyof typeof TaskSetField];
export interface DescribeTaskSetsRequest {
  cluster: string | undefined;
  service: string | undefined;
  taskSets?: string[] | undefined;
  include?: TaskSetField[] | undefined;
}
export interface DescribeTaskSetsResponse {
  taskSets?: TaskSet[] | undefined;
  failures?: Failure[] | undefined;
}
export interface DiscoverPollEndpointRequest {
  containerInstance?: string | undefined;
  cluster?: string | undefined;
}
export interface DiscoverPollEndpointResponse {
  endpoint?: string | undefined;
  telemetryEndpoint?: string | undefined;
  serviceConnectEndpoint?: string | undefined;
}
export interface ExecuteCommandRequest {
  cluster?: string | undefined;
  container?: string | undefined;
  command: string | undefined;
  interactive: boolean | undefined;
  task: string | undefined;
}
export interface Session {
  sessionId?: string | undefined;
  streamUrl?: string | undefined;
  tokenValue?: string | undefined;
}
export interface ExecuteCommandResponse {
  clusterArn?: string | undefined;
  containerArn?: string | undefined;
  containerName?: string | undefined;
  interactive?: boolean | undefined;
  session?: Session | undefined;
  taskArn?: string | undefined;
}
export declare class TargetNotConnectedException extends __BaseException {
  readonly name: "TargetNotConnectedException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<TargetNotConnectedException, __BaseException>
  );
}
export interface GetTaskProtectionRequest {
  cluster: string | undefined;
  tasks?: string[] | undefined;
}
export interface ProtectedTask {
  taskArn?: string | undefined;
  protectionEnabled?: boolean | undefined;
  expirationDate?: Date | undefined;
}
export interface GetTaskProtectionResponse {
  protectedTasks?: ProtectedTask[] | undefined;
  failures?: Failure[] | undefined;
}
export declare class ResourceNotFoundException extends __BaseException {
  readonly name: "ResourceNotFoundException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<ResourceNotFoundException, __BaseException>
  );
}
export interface ListAccountSettingsRequest {
  name?: SettingName | undefined;
  value?: string | undefined;
  principalArn?: string | undefined;
  effectiveSettings?: boolean | undefined;
  nextToken?: string | undefined;
  maxResults?: number | undefined;
}
export interface ListAccountSettingsResponse {
  settings?: Setting[] | undefined;
  nextToken?: string | undefined;
}
export interface ListAttributesRequest {
  cluster?: string | undefined;
  targetType: TargetType | undefined;
  attributeName?: string | undefined;
  attributeValue?: string | undefined;
  nextToken?: string | undefined;
  maxResults?: number | undefined;
}
export interface ListAttributesResponse {
  attributes?: Attribute[] | undefined;
  nextToken?: string | undefined;
}
export interface ListClustersRequest {
  nextToken?: string | undefined;
  maxResults?: number | undefined;
}
export interface ListClustersResponse {
  clusterArns?: string[] | undefined;
  nextToken?: string | undefined;
}
export declare const ContainerInstanceStatus: {
  readonly ACTIVE: "ACTIVE";
  readonly DEREGISTERING: "DEREGISTERING";
  readonly DRAINING: "DRAINING";
  readonly REGISTERING: "REGISTERING";
  readonly REGISTRATION_FAILED: "REGISTRATION_FAILED";
};
export type ContainerInstanceStatus =
  (typeof ContainerInstanceStatus)[keyof typeof ContainerInstanceStatus];
export interface ListContainerInstancesRequest {
  cluster?: string | undefined;
  filter?: string | undefined;
  nextToken?: string | undefined;
  maxResults?: number | undefined;
  status?: ContainerInstanceStatus | undefined;
}
export interface ListContainerInstancesResponse {
  containerInstanceArns?: string[] | undefined;
  nextToken?: string | undefined;
}
export interface CreatedAt {
  before?: Date | undefined;
  after?: Date | undefined;
}
export interface ListServiceDeploymentsRequest {
  service: string | undefined;
  cluster?: string | undefined;
  status?: ServiceDeploymentStatus[] | undefined;
  createdAt?: CreatedAt | undefined;
  nextToken?: string | undefined;
  maxResults?: number | undefined;
}
export interface ServiceDeploymentBrief {
  serviceDeploymentArn?: string | undefined;
  serviceArn?: string | undefined;
  clusterArn?: string | undefined;
  startedAt?: Date | undefined;
  createdAt?: Date | undefined;
  finishedAt?: Date | undefined;
  targetServiceRevisionArn?: string | undefined;
  status?: ServiceDeploymentStatus | undefined;
  statusReason?: string | undefined;
}
export interface ListServiceDeploymentsResponse {
  serviceDeployments?: ServiceDeploymentBrief[] | undefined;
  nextToken?: string | undefined;
}
export interface ListServicesRequest {
  cluster?: string | undefined;
  nextToken?: string | undefined;
  maxResults?: number | undefined;
  launchType?: LaunchType | undefined;
  schedulingStrategy?: SchedulingStrategy | undefined;
}
export interface ListServicesResponse {
  serviceArns?: string[] | undefined;
  nextToken?: string | undefined;
}
export interface ListServicesByNamespaceRequest {
  namespace: string | undefined;
  nextToken?: string | undefined;
  maxResults?: number | undefined;
}
export interface ListServicesByNamespaceResponse {
  serviceArns?: string[] | undefined;
  nextToken?: string | undefined;
}
export interface ListTagsForResourceRequest {
  resourceArn: string | undefined;
}
export interface ListTagsForResourceResponse {
  tags?: Tag[] | undefined;
}
export declare const TaskDefinitionFamilyStatus: {
  readonly ACTIVE: "ACTIVE";
  readonly ALL: "ALL";
  readonly INACTIVE: "INACTIVE";
};
export type TaskDefinitionFamilyStatus =
  (typeof TaskDefinitionFamilyStatus)[keyof typeof TaskDefinitionFamilyStatus];
export interface ListTaskDefinitionFamiliesRequest {
  familyPrefix?: string | undefined;
  status?: TaskDefinitionFamilyStatus | undefined;
  nextToken?: string | undefined;
  maxResults?: number | undefined;
}
export interface ListTaskDefinitionFamiliesResponse {
  families?: string[] | undefined;
  nextToken?: string | undefined;
}
export declare const SortOrder: {
  readonly ASC: "ASC";
  readonly DESC: "DESC";
};
export type SortOrder = (typeof SortOrder)[keyof typeof SortOrder];
export interface ListTaskDefinitionsRequest {
  familyPrefix?: string | undefined;
  status?: TaskDefinitionStatus | undefined;
  sort?: SortOrder | undefined;
  nextToken?: string | undefined;
  maxResults?: number | undefined;
}
export interface ListTaskDefinitionsResponse {
  taskDefinitionArns?: string[] | undefined;
  nextToken?: string | undefined;
}
export declare const DesiredStatus: {
  readonly PENDING: "PENDING";
  readonly RUNNING: "RUNNING";
  readonly STOPPED: "STOPPED";
};
export type DesiredStatus = (typeof DesiredStatus)[keyof typeof DesiredStatus];
export interface ListTasksRequest {
  cluster?: string | undefined;
  containerInstance?: string | undefined;
  family?: string | undefined;
  nextToken?: string | undefined;
  maxResults?: number | undefined;
  startedBy?: string | undefined;
  serviceName?: string | undefined;
  desiredStatus?: DesiredStatus | undefined;
  launchType?: LaunchType | undefined;
}
export interface ListTasksResponse {
  taskArns?: string[] | undefined;
  nextToken?: string | undefined;
}
export interface PutAccountSettingRequest {
  name: SettingName | undefined;
  value: string | undefined;
  principalArn?: string | undefined;
}
export interface PutAccountSettingResponse {
  setting?: Setting | undefined;
}
export declare const SessionFilterSensitiveLog: (obj: Session) => any;
export declare const ExecuteCommandResponseFilterSensitiveLog: (
  obj: ExecuteCommandResponse
) => any;
