import { ExceptionOptionType as __ExceptionOptionType } from "@smithy/smithy-client";
import { ECSServiceException as __BaseException } from "./ECSServiceException";
import {
  Attribute,
  AvailabilityZoneRebalancing,
  CapacityProvider,
  CapacityProviderStrategyItem,
  Cluster,
  ClusterConfiguration,
  ClusterServiceConnectDefaultsRequest,
  ClusterSetting,
  Compatibility,
  ContainerDefinition,
  ContainerInstance,
  ContainerInstanceStatus,
  DeploymentConfiguration,
  DeploymentController,
  EBSTagSpecification,
  EphemeralStorage,
  Failure,
  InferenceAccelerator,
  InstanceRequirementsRequest,
  IpcMode,
  LaunchType,
  LoadBalancer,
  ManagedAgentName,
  ManagedDraining,
  ManagedInstancesMonitoringOptions,
  ManagedInstancesNetworkConfiguration,
  ManagedInstancesStorageConfiguration,
  ManagedScaling,
  ManagedTerminationProtection,
  NetworkBinding,
  NetworkConfiguration,
  NetworkMode,
  PidMode,
  PlacementConstraint,
  PlacementStrategy,
  PropagateMITags,
  PropagateTags,
  ProtectedTask,
  ProxyConfiguration,
  Resource,
  RuntimePlatform,
  Scale,
  Service,
  ServiceConnectConfiguration,
  ServiceRegistry,
  ServiceVolumeConfiguration,
  Setting,
  SettingName,
  Tag,
  Task,
  TaskDefinition,
  TaskDefinitionPlacementConstraint,
  TaskFilesystemType,
  TaskOverride,
  TaskSet,
  VersionInfo,
  Volume,
  VpcLatticeConfiguration,
} from "./models_0";
export interface PutAccountSettingDefaultRequest {
  name: SettingName | undefined;
  value: string | undefined;
}
export interface PutAccountSettingDefaultResponse {
  setting?: Setting | undefined;
}
export declare class AttributeLimitExceededException extends __BaseException {
  readonly name: "AttributeLimitExceededException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      AttributeLimitExceededException,
      __BaseException
    >
  );
}
export interface PutAttributesRequest {
  cluster?: string | undefined;
  attributes: Attribute[] | undefined;
}
export interface PutAttributesResponse {
  attributes?: Attribute[] | undefined;
}
export interface PutClusterCapacityProvidersRequest {
  cluster: string | undefined;
  capacityProviders: string[] | undefined;
  defaultCapacityProviderStrategy: CapacityProviderStrategyItem[] | undefined;
}
export interface PutClusterCapacityProvidersResponse {
  cluster?: Cluster | undefined;
}
export declare class ResourceInUseException extends __BaseException {
  readonly name: "ResourceInUseException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<ResourceInUseException, __BaseException>
  );
}
export declare const PlatformDeviceType: {
  readonly GPU: "GPU";
};
export type PlatformDeviceType =
  (typeof PlatformDeviceType)[keyof typeof PlatformDeviceType];
export interface PlatformDevice {
  id: string | undefined;
  type: PlatformDeviceType | undefined;
}
export interface RegisterContainerInstanceRequest {
  cluster?: string | undefined;
  instanceIdentityDocument?: string | undefined;
  instanceIdentityDocumentSignature?: string | undefined;
  totalResources?: Resource[] | undefined;
  versionInfo?: VersionInfo | undefined;
  containerInstanceArn?: string | undefined;
  attributes?: Attribute[] | undefined;
  platformDevices?: PlatformDevice[] | undefined;
  tags?: Tag[] | undefined;
}
export interface RegisterContainerInstanceResponse {
  containerInstance?: ContainerInstance | undefined;
}
export interface RegisterTaskDefinitionRequest {
  family: string | undefined;
  taskRoleArn?: string | undefined;
  executionRoleArn?: string | undefined;
  networkMode?: NetworkMode | undefined;
  containerDefinitions: ContainerDefinition[] | undefined;
  volumes?: Volume[] | undefined;
  placementConstraints?: TaskDefinitionPlacementConstraint[] | undefined;
  requiresCompatibilities?: Compatibility[] | undefined;
  cpu?: string | undefined;
  memory?: string | undefined;
  tags?: Tag[] | undefined;
  pidMode?: PidMode | undefined;
  ipcMode?: IpcMode | undefined;
  proxyConfiguration?: ProxyConfiguration | undefined;
  inferenceAccelerators?: InferenceAccelerator[] | undefined;
  ephemeralStorage?: EphemeralStorage | undefined;
  runtimePlatform?: RuntimePlatform | undefined;
  enableFaultInjection?: boolean | undefined;
}
export interface RegisterTaskDefinitionResponse {
  taskDefinition?: TaskDefinition | undefined;
  tags?: Tag[] | undefined;
}
export declare class BlockedException extends __BaseException {
  readonly name: "BlockedException";
  readonly $fault: "client";
  constructor(opts: __ExceptionOptionType<BlockedException, __BaseException>);
}
export declare class ConflictException extends __BaseException {
  readonly name: "ConflictException";
  readonly $fault: "client";
  resourceIds?: string[] | undefined;
  constructor(opts: __ExceptionOptionType<ConflictException, __BaseException>);
}
export interface TaskManagedEBSVolumeTerminationPolicy {
  deleteOnTermination: boolean | undefined;
}
export interface TaskManagedEBSVolumeConfiguration {
  encrypted?: boolean | undefined;
  kmsKeyId?: string | undefined;
  volumeType?: string | undefined;
  sizeInGiB?: number | undefined;
  snapshotId?: string | undefined;
  volumeInitializationRate?: number | undefined;
  iops?: number | undefined;
  throughput?: number | undefined;
  tagSpecifications?: EBSTagSpecification[] | undefined;
  roleArn: string | undefined;
  terminationPolicy?: TaskManagedEBSVolumeTerminationPolicy | undefined;
  filesystemType?: TaskFilesystemType | undefined;
}
export interface TaskVolumeConfiguration {
  name: string | undefined;
  managedEBSVolume?: TaskManagedEBSVolumeConfiguration | undefined;
}
export interface RunTaskRequest {
  capacityProviderStrategy?: CapacityProviderStrategyItem[] | undefined;
  cluster?: string | undefined;
  count?: number | undefined;
  enableECSManagedTags?: boolean | undefined;
  enableExecuteCommand?: boolean | undefined;
  group?: string | undefined;
  launchType?: LaunchType | undefined;
  networkConfiguration?: NetworkConfiguration | undefined;
  overrides?: TaskOverride | undefined;
  placementConstraints?: PlacementConstraint[] | undefined;
  placementStrategy?: PlacementStrategy[] | undefined;
  platformVersion?: string | undefined;
  propagateTags?: PropagateTags | undefined;
  referenceId?: string | undefined;
  startedBy?: string | undefined;
  tags?: Tag[] | undefined;
  taskDefinition: string | undefined;
  clientToken?: string | undefined;
  volumeConfigurations?: TaskVolumeConfiguration[] | undefined;
}
export interface RunTaskResponse {
  tasks?: Task[] | undefined;
  failures?: Failure[] | undefined;
}
export interface StartTaskRequest {
  cluster?: string | undefined;
  containerInstances: string[] | undefined;
  enableECSManagedTags?: boolean | undefined;
  enableExecuteCommand?: boolean | undefined;
  group?: string | undefined;
  networkConfiguration?: NetworkConfiguration | undefined;
  overrides?: TaskOverride | undefined;
  propagateTags?: PropagateTags | undefined;
  referenceId?: string | undefined;
  startedBy?: string | undefined;
  tags?: Tag[] | undefined;
  taskDefinition: string | undefined;
  volumeConfigurations?: TaskVolumeConfiguration[] | undefined;
}
export interface StartTaskResponse {
  tasks?: Task[] | undefined;
  failures?: Failure[] | undefined;
}
export declare class ServiceDeploymentNotFoundException extends __BaseException {
  readonly name: "ServiceDeploymentNotFoundException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      ServiceDeploymentNotFoundException,
      __BaseException
    >
  );
}
export declare const StopServiceDeploymentStopType: {
  readonly ABORT: "ABORT";
  readonly ROLLBACK: "ROLLBACK";
};
export type StopServiceDeploymentStopType =
  (typeof StopServiceDeploymentStopType)[keyof typeof StopServiceDeploymentStopType];
export interface StopServiceDeploymentRequest {
  serviceDeploymentArn: string | undefined;
  stopType?: StopServiceDeploymentStopType | undefined;
}
export interface StopServiceDeploymentResponse {
  serviceDeploymentArn?: string | undefined;
}
export interface StopTaskRequest {
  cluster?: string | undefined;
  task: string | undefined;
  reason?: string | undefined;
}
export interface StopTaskResponse {
  task?: Task | undefined;
}
export interface AttachmentStateChange {
  attachmentArn: string | undefined;
  status: string | undefined;
}
export interface SubmitAttachmentStateChangesRequest {
  cluster?: string | undefined;
  attachments: AttachmentStateChange[] | undefined;
}
export interface SubmitAttachmentStateChangesResponse {
  acknowledgment?: string | undefined;
}
export interface SubmitContainerStateChangeRequest {
  cluster?: string | undefined;
  task?: string | undefined;
  containerName?: string | undefined;
  runtimeId?: string | undefined;
  status?: string | undefined;
  exitCode?: number | undefined;
  reason?: string | undefined;
  networkBindings?: NetworkBinding[] | undefined;
}
export interface SubmitContainerStateChangeResponse {
  acknowledgment?: string | undefined;
}
export interface ContainerStateChange {
  containerName?: string | undefined;
  imageDigest?: string | undefined;
  runtimeId?: string | undefined;
  exitCode?: number | undefined;
  networkBindings?: NetworkBinding[] | undefined;
  reason?: string | undefined;
  status?: string | undefined;
}
export interface ManagedAgentStateChange {
  containerName: string | undefined;
  managedAgentName: ManagedAgentName | undefined;
  status: string | undefined;
  reason?: string | undefined;
}
export interface SubmitTaskStateChangeRequest {
  cluster?: string | undefined;
  task?: string | undefined;
  status?: string | undefined;
  reason?: string | undefined;
  containers?: ContainerStateChange[] | undefined;
  attachments?: AttachmentStateChange[] | undefined;
  managedAgents?: ManagedAgentStateChange[] | undefined;
  pullStartedAt?: Date | undefined;
  pullStoppedAt?: Date | undefined;
  executionStoppedAt?: Date | undefined;
}
export interface SubmitTaskStateChangeResponse {
  acknowledgment?: string | undefined;
}
export interface TagResourceRequest {
  resourceArn: string | undefined;
  tags: Tag[] | undefined;
}
export interface TagResourceResponse {}
export interface UntagResourceRequest {
  resourceArn: string | undefined;
  tagKeys: string[] | undefined;
}
export interface UntagResourceResponse {}
export interface AutoScalingGroupProviderUpdate {
  managedScaling?: ManagedScaling | undefined;
  managedTerminationProtection?: ManagedTerminationProtection | undefined;
  managedDraining?: ManagedDraining | undefined;
}
export interface InstanceLaunchTemplateUpdate {
  ec2InstanceProfileArn?: string | undefined;
  networkConfiguration?: ManagedInstancesNetworkConfiguration | undefined;
  storageConfiguration?: ManagedInstancesStorageConfiguration | undefined;
  monitoring?: ManagedInstancesMonitoringOptions | undefined;
  instanceRequirements?: InstanceRequirementsRequest | undefined;
}
export interface UpdateManagedInstancesProviderConfiguration {
  infrastructureRoleArn: string | undefined;
  instanceLaunchTemplate: InstanceLaunchTemplateUpdate | undefined;
  propagateTags?: PropagateMITags | undefined;
}
export interface UpdateCapacityProviderRequest {
  name: string | undefined;
  cluster?: string | undefined;
  autoScalingGroupProvider?: AutoScalingGroupProviderUpdate | undefined;
  managedInstancesProvider?:
    | UpdateManagedInstancesProviderConfiguration
    | undefined;
}
export interface UpdateCapacityProviderResponse {
  capacityProvider?: CapacityProvider | undefined;
}
export interface UpdateClusterRequest {
  cluster: string | undefined;
  settings?: ClusterSetting[] | undefined;
  configuration?: ClusterConfiguration | undefined;
  serviceConnectDefaults?: ClusterServiceConnectDefaultsRequest | undefined;
}
export interface UpdateClusterResponse {
  cluster?: Cluster | undefined;
}
export interface UpdateClusterSettingsRequest {
  cluster: string | undefined;
  settings: ClusterSetting[] | undefined;
}
export interface UpdateClusterSettingsResponse {
  cluster?: Cluster | undefined;
}
export declare class MissingVersionException extends __BaseException {
  readonly name: "MissingVersionException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<MissingVersionException, __BaseException>
  );
}
export declare class NoUpdateAvailableException extends __BaseException {
  readonly name: "NoUpdateAvailableException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<NoUpdateAvailableException, __BaseException>
  );
}
export interface UpdateContainerAgentRequest {
  cluster?: string | undefined;
  containerInstance: string | undefined;
}
export interface UpdateContainerAgentResponse {
  containerInstance?: ContainerInstance | undefined;
}
export interface UpdateContainerInstancesStateRequest {
  cluster?: string | undefined;
  containerInstances: string[] | undefined;
  status: ContainerInstanceStatus | undefined;
}
export interface UpdateContainerInstancesStateResponse {
  containerInstances?: ContainerInstance[] | undefined;
  failures?: Failure[] | undefined;
}
export interface UpdateServiceRequest {
  cluster?: string | undefined;
  service: string | undefined;
  desiredCount?: number | undefined;
  taskDefinition?: string | undefined;
  capacityProviderStrategy?: CapacityProviderStrategyItem[] | undefined;
  deploymentConfiguration?: DeploymentConfiguration | undefined;
  availabilityZoneRebalancing?: AvailabilityZoneRebalancing | undefined;
  networkConfiguration?: NetworkConfiguration | undefined;
  placementConstraints?: PlacementConstraint[] | undefined;
  placementStrategy?: PlacementStrategy[] | undefined;
  platformVersion?: string | undefined;
  forceNewDeployment?: boolean | undefined;
  healthCheckGracePeriodSeconds?: number | undefined;
  deploymentController?: DeploymentController | undefined;
  enableExecuteCommand?: boolean | undefined;
  enableECSManagedTags?: boolean | undefined;
  loadBalancers?: LoadBalancer[] | undefined;
  propagateTags?: PropagateTags | undefined;
  serviceRegistries?: ServiceRegistry[] | undefined;
  serviceConnectConfiguration?: ServiceConnectConfiguration | undefined;
  volumeConfigurations?: ServiceVolumeConfiguration[] | undefined;
  vpcLatticeConfigurations?: VpcLatticeConfiguration[] | undefined;
}
export interface UpdateServiceResponse {
  service?: Service | undefined;
}
export interface UpdateServicePrimaryTaskSetRequest {
  cluster: string | undefined;
  service: string | undefined;
  primaryTaskSet: string | undefined;
}
export interface UpdateServicePrimaryTaskSetResponse {
  taskSet?: TaskSet | undefined;
}
export interface UpdateTaskProtectionRequest {
  cluster: string | undefined;
  tasks: string[] | undefined;
  protectionEnabled: boolean | undefined;
  expiresInMinutes?: number | undefined;
}
export interface UpdateTaskProtectionResponse {
  protectedTasks?: ProtectedTask[] | undefined;
  failures?: Failure[] | undefined;
}
export interface UpdateTaskSetRequest {
  cluster: string | undefined;
  service: string | undefined;
  taskSet: string | undefined;
  scale: Scale | undefined;
}
export interface UpdateTaskSetResponse {
  taskSet?: TaskSet | undefined;
}
