"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/index.ts
var index_exports = {};
__export(index_exports, {
  AlgorithmSpec: () => AlgorithmSpec,
  AlreadyExistsException: () => AlreadyExistsException,
  CancelKeyDeletionCommand: () => CancelKeyDeletionCommand,
  CloudHsmClusterInUseException: () => CloudHsmClusterInUseException,
  CloudHsmClusterInvalidConfigurationException: () => CloudHsmClusterInvalidConfigurationException,
  CloudHsmClusterNotActiveException: () => CloudHsmClusterNotActiveException,
  CloudHsmClusterNotFoundException: () => CloudHsmClusterNotFoundException,
  CloudHsmClusterNotRelatedException: () => CloudHsmClusterNotRelatedException,
  ConflictException: () => ConflictException,
  ConnectCustomKeyStoreCommand: () => ConnectCustomKeyStoreCommand,
  ConnectionErrorCodeType: () => ConnectionErrorCodeType,
  ConnectionStateType: () => ConnectionStateType,
  CreateAliasCommand: () => CreateAliasCommand,
  CreateCustomKeyStoreCommand: () => CreateCustomKeyStoreCommand,
  CreateCustomKeyStoreRequestFilterSensitiveLog: () => CreateCustomKeyStoreRequestFilterSensitiveLog,
  CreateGrantCommand: () => CreateGrantCommand,
  CreateKeyCommand: () => CreateKeyCommand,
  CustomKeyStoreHasCMKsException: () => CustomKeyStoreHasCMKsException,
  CustomKeyStoreInvalidStateException: () => CustomKeyStoreInvalidStateException,
  CustomKeyStoreNameInUseException: () => CustomKeyStoreNameInUseException,
  CustomKeyStoreNotFoundException: () => CustomKeyStoreNotFoundException,
  CustomKeyStoreType: () => CustomKeyStoreType,
  CustomKeyStoresListEntryFilterSensitiveLog: () => CustomKeyStoresListEntryFilterSensitiveLog,
  CustomerMasterKeySpec: () => CustomerMasterKeySpec,
  DataKeyPairSpec: () => DataKeyPairSpec,
  DataKeySpec: () => DataKeySpec,
  DecryptCommand: () => DecryptCommand,
  DecryptResponseFilterSensitiveLog: () => DecryptResponseFilterSensitiveLog,
  DeleteAliasCommand: () => DeleteAliasCommand,
  DeleteCustomKeyStoreCommand: () => DeleteCustomKeyStoreCommand,
  DeleteImportedKeyMaterialCommand: () => DeleteImportedKeyMaterialCommand,
  DependencyTimeoutException: () => DependencyTimeoutException,
  DeriveSharedSecretCommand: () => DeriveSharedSecretCommand,
  DeriveSharedSecretResponseFilterSensitiveLog: () => DeriveSharedSecretResponseFilterSensitiveLog,
  DescribeCustomKeyStoresCommand: () => DescribeCustomKeyStoresCommand,
  DescribeCustomKeyStoresResponseFilterSensitiveLog: () => DescribeCustomKeyStoresResponseFilterSensitiveLog,
  DescribeKeyCommand: () => DescribeKeyCommand,
  DisableKeyCommand: () => DisableKeyCommand,
  DisableKeyRotationCommand: () => DisableKeyRotationCommand,
  DisabledException: () => DisabledException,
  DisconnectCustomKeyStoreCommand: () => DisconnectCustomKeyStoreCommand,
  DryRunOperationException: () => DryRunOperationException,
  EnableKeyCommand: () => EnableKeyCommand,
  EnableKeyRotationCommand: () => EnableKeyRotationCommand,
  EncryptCommand: () => EncryptCommand,
  EncryptRequestFilterSensitiveLog: () => EncryptRequestFilterSensitiveLog,
  EncryptionAlgorithmSpec: () => EncryptionAlgorithmSpec,
  ExpirationModelType: () => ExpirationModelType,
  ExpiredImportTokenException: () => ExpiredImportTokenException,
  GenerateDataKeyCommand: () => GenerateDataKeyCommand,
  GenerateDataKeyPairCommand: () => GenerateDataKeyPairCommand,
  GenerateDataKeyPairResponseFilterSensitiveLog: () => GenerateDataKeyPairResponseFilterSensitiveLog,
  GenerateDataKeyPairWithoutPlaintextCommand: () => GenerateDataKeyPairWithoutPlaintextCommand,
  GenerateDataKeyResponseFilterSensitiveLog: () => GenerateDataKeyResponseFilterSensitiveLog,
  GenerateDataKeyWithoutPlaintextCommand: () => GenerateDataKeyWithoutPlaintextCommand,
  GenerateMacCommand: () => GenerateMacCommand,
  GenerateMacRequestFilterSensitiveLog: () => GenerateMacRequestFilterSensitiveLog,
  GenerateRandomCommand: () => GenerateRandomCommand,
  GenerateRandomResponseFilterSensitiveLog: () => GenerateRandomResponseFilterSensitiveLog,
  GetKeyPolicyCommand: () => GetKeyPolicyCommand,
  GetKeyRotationStatusCommand: () => GetKeyRotationStatusCommand,
  GetParametersForImportCommand: () => GetParametersForImportCommand,
  GetParametersForImportResponseFilterSensitiveLog: () => GetParametersForImportResponseFilterSensitiveLog,
  GetPublicKeyCommand: () => GetPublicKeyCommand,
  GrantOperation: () => GrantOperation,
  ImportKeyMaterialCommand: () => ImportKeyMaterialCommand,
  ImportState: () => ImportState,
  ImportType: () => ImportType,
  IncludeKeyMaterial: () => IncludeKeyMaterial,
  IncorrectKeyException: () => IncorrectKeyException,
  IncorrectKeyMaterialException: () => IncorrectKeyMaterialException,
  IncorrectTrustAnchorException: () => IncorrectTrustAnchorException,
  InvalidAliasNameException: () => InvalidAliasNameException,
  InvalidArnException: () => InvalidArnException,
  InvalidCiphertextException: () => InvalidCiphertextException,
  InvalidGrantIdException: () => InvalidGrantIdException,
  InvalidGrantTokenException: () => InvalidGrantTokenException,
  InvalidImportTokenException: () => InvalidImportTokenException,
  InvalidKeyUsageException: () => InvalidKeyUsageException,
  InvalidMarkerException: () => InvalidMarkerException,
  KMS: () => KMS,
  KMSClient: () => KMSClient,
  KMSInternalException: () => KMSInternalException,
  KMSInvalidMacException: () => KMSInvalidMacException,
  KMSInvalidSignatureException: () => KMSInvalidSignatureException,
  KMSInvalidStateException: () => KMSInvalidStateException,
  KMSServiceException: () => KMSServiceException,
  KeyAgreementAlgorithmSpec: () => KeyAgreementAlgorithmSpec,
  KeyEncryptionMechanism: () => KeyEncryptionMechanism,
  KeyManagerType: () => KeyManagerType,
  KeyMaterialState: () => KeyMaterialState,
  KeySpec: () => KeySpec,
  KeyState: () => KeyState,
  KeyUnavailableException: () => KeyUnavailableException,
  KeyUsageType: () => KeyUsageType,
  LimitExceededException: () => LimitExceededException,
  ListAliasesCommand: () => ListAliasesCommand,
  ListGrantsCommand: () => ListGrantsCommand,
  ListKeyPoliciesCommand: () => ListKeyPoliciesCommand,
  ListKeyRotationsCommand: () => ListKeyRotationsCommand,
  ListKeysCommand: () => ListKeysCommand,
  ListResourceTagsCommand: () => ListResourceTagsCommand,
  ListRetirableGrantsCommand: () => ListRetirableGrantsCommand,
  MacAlgorithmSpec: () => MacAlgorithmSpec,
  MalformedPolicyDocumentException: () => MalformedPolicyDocumentException,
  MessageType: () => MessageType,
  MultiRegionKeyType: () => MultiRegionKeyType,
  NotFoundException: () => NotFoundException,
  OriginType: () => OriginType,
  PutKeyPolicyCommand: () => PutKeyPolicyCommand,
  ReEncryptCommand: () => ReEncryptCommand,
  ReplicateKeyCommand: () => ReplicateKeyCommand,
  RetireGrantCommand: () => RetireGrantCommand,
  RevokeGrantCommand: () => RevokeGrantCommand,
  RotateKeyOnDemandCommand: () => RotateKeyOnDemandCommand,
  RotationType: () => RotationType,
  ScheduleKeyDeletionCommand: () => ScheduleKeyDeletionCommand,
  SignCommand: () => SignCommand,
  SignRequestFilterSensitiveLog: () => SignRequestFilterSensitiveLog,
  SigningAlgorithmSpec: () => SigningAlgorithmSpec,
  TagException: () => TagException,
  TagResourceCommand: () => TagResourceCommand,
  UnsupportedOperationException: () => UnsupportedOperationException,
  UntagResourceCommand: () => UntagResourceCommand,
  UpdateAliasCommand: () => UpdateAliasCommand,
  UpdateCustomKeyStoreCommand: () => UpdateCustomKeyStoreCommand,
  UpdateCustomKeyStoreRequestFilterSensitiveLog: () => UpdateCustomKeyStoreRequestFilterSensitiveLog,
  UpdateKeyDescriptionCommand: () => UpdateKeyDescriptionCommand,
  UpdatePrimaryRegionCommand: () => UpdatePrimaryRegionCommand,
  VerifyCommand: () => VerifyCommand,
  VerifyMacCommand: () => VerifyMacCommand,
  VerifyMacRequestFilterSensitiveLog: () => VerifyMacRequestFilterSensitiveLog,
  VerifyRequestFilterSensitiveLog: () => VerifyRequestFilterSensitiveLog,
  WrappingKeySpec: () => WrappingKeySpec,
  XksKeyAlreadyInUseException: () => XksKeyAlreadyInUseException,
  XksKeyInvalidConfigurationException: () => XksKeyInvalidConfigurationException,
  XksKeyNotFoundException: () => XksKeyNotFoundException,
  XksProxyAuthenticationCredentialTypeFilterSensitiveLog: () => XksProxyAuthenticationCredentialTypeFilterSensitiveLog,
  XksProxyConfigurationTypeFilterSensitiveLog: () => XksProxyConfigurationTypeFilterSensitiveLog,
  XksProxyConnectivityType: () => XksProxyConnectivityType,
  XksProxyIncorrectAuthenticationCredentialException: () => XksProxyIncorrectAuthenticationCredentialException,
  XksProxyInvalidConfigurationException: () => XksProxyInvalidConfigurationException,
  XksProxyInvalidResponseException: () => XksProxyInvalidResponseException,
  XksProxyUriEndpointInUseException: () => XksProxyUriEndpointInUseException,
  XksProxyUriInUseException: () => XksProxyUriInUseException,
  XksProxyUriUnreachableException: () => XksProxyUriUnreachableException,
  XksProxyVpcEndpointServiceInUseException: () => XksProxyVpcEndpointServiceInUseException,
  XksProxyVpcEndpointServiceInvalidConfigurationException: () => XksProxyVpcEndpointServiceInvalidConfigurationException,
  XksProxyVpcEndpointServiceNotFoundException: () => XksProxyVpcEndpointServiceNotFoundException,
  __Client: () => import_smithy_client.Client,
  paginateDescribeCustomKeyStores: () => paginateDescribeCustomKeyStores,
  paginateListAliases: () => paginateListAliases,
  paginateListGrants: () => paginateListGrants,
  paginateListKeyPolicies: () => paginateListKeyPolicies,
  paginateListKeyRotations: () => paginateListKeyRotations,
  paginateListKeys: () => paginateListKeys,
  paginateListResourceTags: () => paginateListResourceTags,
  paginateListRetirableGrants: () => paginateListRetirableGrants
});
module.exports = __toCommonJS(index_exports);

// src/KMSClient.ts
var import_middleware_host_header = require("@aws-sdk/middleware-host-header");
var import_middleware_logger = require("@aws-sdk/middleware-logger");
var import_middleware_recursion_detection = require("@aws-sdk/middleware-recursion-detection");
var import_middleware_user_agent = require("@aws-sdk/middleware-user-agent");
var import_config_resolver = require("@smithy/config-resolver");
var import_core = require("@smithy/core");
var import_middleware_content_length = require("@smithy/middleware-content-length");
var import_middleware_endpoint = require("@smithy/middleware-endpoint");
var import_middleware_retry = require("@smithy/middleware-retry");

var import_httpAuthSchemeProvider = require("./auth/httpAuthSchemeProvider");

// src/endpoint/EndpointParameters.ts
var resolveClientEndpointParameters = /* @__PURE__ */ __name((options) => {
  return Object.assign(options, {
    useDualstackEndpoint: options.useDualstackEndpoint ?? false,
    useFipsEndpoint: options.useFipsEndpoint ?? false,
    defaultSigningName: "kms"
  });
}, "resolveClientEndpointParameters");
var commonParams = {
  UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
  Endpoint: { type: "builtInParams", name: "endpoint" },
  Region: { type: "builtInParams", name: "region" },
  UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" }
};

// src/KMSClient.ts
var import_runtimeConfig = require("././runtimeConfig");

// src/runtimeExtensions.ts
var import_region_config_resolver = require("@aws-sdk/region-config-resolver");
var import_protocol_http = require("@smithy/protocol-http");
var import_smithy_client = require("@smithy/smithy-client");

// src/auth/httpAuthExtensionConfiguration.ts
var getHttpAuthExtensionConfiguration = /* @__PURE__ */ __name((runtimeConfig) => {
  const _httpAuthSchemes = runtimeConfig.httpAuthSchemes;
  let _httpAuthSchemeProvider = runtimeConfig.httpAuthSchemeProvider;
  let _credentials = runtimeConfig.credentials;
  return {
    setHttpAuthScheme(httpAuthScheme) {
      const index = _httpAuthSchemes.findIndex((scheme) => scheme.schemeId === httpAuthScheme.schemeId);
      if (index === -1) {
        _httpAuthSchemes.push(httpAuthScheme);
      } else {
        _httpAuthSchemes.splice(index, 1, httpAuthScheme);
      }
    },
    httpAuthSchemes() {
      return _httpAuthSchemes;
    },
    setHttpAuthSchemeProvider(httpAuthSchemeProvider) {
      _httpAuthSchemeProvider = httpAuthSchemeProvider;
    },
    httpAuthSchemeProvider() {
      return _httpAuthSchemeProvider;
    },
    setCredentials(credentials) {
      _credentials = credentials;
    },
    credentials() {
      return _credentials;
    }
  };
}, "getHttpAuthExtensionConfiguration");
var resolveHttpAuthRuntimeConfig = /* @__PURE__ */ __name((config) => {
  return {
    httpAuthSchemes: config.httpAuthSchemes(),
    httpAuthSchemeProvider: config.httpAuthSchemeProvider(),
    credentials: config.credentials()
  };
}, "resolveHttpAuthRuntimeConfig");

// src/runtimeExtensions.ts
var resolveRuntimeExtensions = /* @__PURE__ */ __name((runtimeConfig, extensions) => {
  const extensionConfiguration = Object.assign(
    (0, import_region_config_resolver.getAwsRegionExtensionConfiguration)(runtimeConfig),
    (0, import_smithy_client.getDefaultExtensionConfiguration)(runtimeConfig),
    (0, import_protocol_http.getHttpHandlerExtensionConfiguration)(runtimeConfig),
    getHttpAuthExtensionConfiguration(runtimeConfig)
  );
  extensions.forEach((extension) => extension.configure(extensionConfiguration));
  return Object.assign(
    runtimeConfig,
    (0, import_region_config_resolver.resolveAwsRegionExtensionConfiguration)(extensionConfiguration),
    (0, import_smithy_client.resolveDefaultRuntimeConfig)(extensionConfiguration),
    (0, import_protocol_http.resolveHttpHandlerRuntimeConfig)(extensionConfiguration),
    resolveHttpAuthRuntimeConfig(extensionConfiguration)
  );
}, "resolveRuntimeExtensions");

// src/KMSClient.ts
var KMSClient = class extends import_smithy_client.Client {
  static {
    __name(this, "KMSClient");
  }
  /**
   * The resolved configuration of KMSClient class. This is resolved and normalized from the {@link KMSClientConfig | constructor configuration interface}.
   */
  config;
  constructor(...[configuration]) {
    const _config_0 = (0, import_runtimeConfig.getRuntimeConfig)(configuration || {});
    super(_config_0);
    this.initConfig = _config_0;
    const _config_1 = resolveClientEndpointParameters(_config_0);
    const _config_2 = (0, import_middleware_user_agent.resolveUserAgentConfig)(_config_1);
    const _config_3 = (0, import_middleware_retry.resolveRetryConfig)(_config_2);
    const _config_4 = (0, import_config_resolver.resolveRegionConfig)(_config_3);
    const _config_5 = (0, import_middleware_host_header.resolveHostHeaderConfig)(_config_4);
    const _config_6 = (0, import_middleware_endpoint.resolveEndpointConfig)(_config_5);
    const _config_7 = (0, import_httpAuthSchemeProvider.resolveHttpAuthSchemeConfig)(_config_6);
    const _config_8 = resolveRuntimeExtensions(_config_7, configuration?.extensions || []);
    this.config = _config_8;
    this.middlewareStack.use((0, import_middleware_user_agent.getUserAgentPlugin)(this.config));
    this.middlewareStack.use((0, import_middleware_retry.getRetryPlugin)(this.config));
    this.middlewareStack.use((0, import_middleware_content_length.getContentLengthPlugin)(this.config));
    this.middlewareStack.use((0, import_middleware_host_header.getHostHeaderPlugin)(this.config));
    this.middlewareStack.use((0, import_middleware_logger.getLoggerPlugin)(this.config));
    this.middlewareStack.use((0, import_middleware_recursion_detection.getRecursionDetectionPlugin)(this.config));
    this.middlewareStack.use(
      (0, import_core.getHttpAuthSchemeEndpointRuleSetPlugin)(this.config, {
        httpAuthSchemeParametersProvider: import_httpAuthSchemeProvider.defaultKMSHttpAuthSchemeParametersProvider,
        identityProviderConfigProvider: /* @__PURE__ */ __name(async (config) => new import_core.DefaultIdentityProviderConfig({
          "aws.auth#sigv4": config.credentials
        }), "identityProviderConfigProvider")
      })
    );
    this.middlewareStack.use((0, import_core.getHttpSigningPlugin)(this.config));
  }
  /**
   * Destroy underlying resources, like sockets. It's usually not necessary to do this.
   * However in Node.js, it's best to explicitly shut down the client's agent when it is no longer needed.
   * Otherwise, sockets might stay open for quite a long time before the server terminates them.
   */
  destroy() {
    super.destroy();
  }
};

// src/KMS.ts


// src/commands/CancelKeyDeletionCommand.ts

var import_middleware_serde = require("@smithy/middleware-serde");


// src/protocols/Aws_json1_1.ts
var import_core2 = require("@aws-sdk/core");



// src/models/KMSServiceException.ts

var KMSServiceException = class _KMSServiceException extends import_smithy_client.ServiceException {
  static {
    __name(this, "KMSServiceException");
  }
  /**
   * @internal
   */
  constructor(options) {
    super(options);
    Object.setPrototypeOf(this, _KMSServiceException.prototype);
  }
};

// src/models/models_0.ts

var AlgorithmSpec = {
  RSAES_OAEP_SHA_1: "RSAES_OAEP_SHA_1",
  RSAES_OAEP_SHA_256: "RSAES_OAEP_SHA_256",
  RSAES_PKCS1_V1_5: "RSAES_PKCS1_V1_5",
  RSA_AES_KEY_WRAP_SHA_1: "RSA_AES_KEY_WRAP_SHA_1",
  RSA_AES_KEY_WRAP_SHA_256: "RSA_AES_KEY_WRAP_SHA_256",
  SM2PKE: "SM2PKE"
};
var AlreadyExistsException = class _AlreadyExistsException extends KMSServiceException {
  static {
    __name(this, "AlreadyExistsException");
  }
  name = "AlreadyExistsException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "AlreadyExistsException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _AlreadyExistsException.prototype);
  }
};
var DependencyTimeoutException = class _DependencyTimeoutException extends KMSServiceException {
  static {
    __name(this, "DependencyTimeoutException");
  }
  name = "DependencyTimeoutException";
  $fault = "server";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DependencyTimeoutException",
      $fault: "server",
      ...opts
    });
    Object.setPrototypeOf(this, _DependencyTimeoutException.prototype);
  }
};
var InvalidArnException = class _InvalidArnException extends KMSServiceException {
  static {
    __name(this, "InvalidArnException");
  }
  name = "InvalidArnException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidArnException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidArnException.prototype);
  }
};
var KMSInternalException = class _KMSInternalException extends KMSServiceException {
  static {
    __name(this, "KMSInternalException");
  }
  name = "KMSInternalException";
  $fault = "server";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "KMSInternalException",
      $fault: "server",
      ...opts
    });
    Object.setPrototypeOf(this, _KMSInternalException.prototype);
  }
};
var KMSInvalidStateException = class _KMSInvalidStateException extends KMSServiceException {
  static {
    __name(this, "KMSInvalidStateException");
  }
  name = "KMSInvalidStateException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "KMSInvalidStateException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _KMSInvalidStateException.prototype);
  }
};
var NotFoundException = class _NotFoundException extends KMSServiceException {
  static {
    __name(this, "NotFoundException");
  }
  name = "NotFoundException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "NotFoundException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _NotFoundException.prototype);
  }
};
var CloudHsmClusterInUseException = class _CloudHsmClusterInUseException extends KMSServiceException {
  static {
    __name(this, "CloudHsmClusterInUseException");
  }
  name = "CloudHsmClusterInUseException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "CloudHsmClusterInUseException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _CloudHsmClusterInUseException.prototype);
  }
};
var CloudHsmClusterInvalidConfigurationException = class _CloudHsmClusterInvalidConfigurationException extends KMSServiceException {
  static {
    __name(this, "CloudHsmClusterInvalidConfigurationException");
  }
  name = "CloudHsmClusterInvalidConfigurationException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "CloudHsmClusterInvalidConfigurationException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _CloudHsmClusterInvalidConfigurationException.prototype);
  }
};
var CloudHsmClusterNotActiveException = class _CloudHsmClusterNotActiveException extends KMSServiceException {
  static {
    __name(this, "CloudHsmClusterNotActiveException");
  }
  name = "CloudHsmClusterNotActiveException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "CloudHsmClusterNotActiveException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _CloudHsmClusterNotActiveException.prototype);
  }
};
var CloudHsmClusterNotFoundException = class _CloudHsmClusterNotFoundException extends KMSServiceException {
  static {
    __name(this, "CloudHsmClusterNotFoundException");
  }
  name = "CloudHsmClusterNotFoundException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "CloudHsmClusterNotFoundException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _CloudHsmClusterNotFoundException.prototype);
  }
};
var CloudHsmClusterNotRelatedException = class _CloudHsmClusterNotRelatedException extends KMSServiceException {
  static {
    __name(this, "CloudHsmClusterNotRelatedException");
  }
  name = "CloudHsmClusterNotRelatedException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "CloudHsmClusterNotRelatedException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _CloudHsmClusterNotRelatedException.prototype);
  }
};
var ConflictException = class _ConflictException extends KMSServiceException {
  static {
    __name(this, "ConflictException");
  }
  name = "ConflictException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ConflictException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ConflictException.prototype);
  }
};
var CustomKeyStoreInvalidStateException = class _CustomKeyStoreInvalidStateException extends KMSServiceException {
  static {
    __name(this, "CustomKeyStoreInvalidStateException");
  }
  name = "CustomKeyStoreInvalidStateException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "CustomKeyStoreInvalidStateException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _CustomKeyStoreInvalidStateException.prototype);
  }
};
var CustomKeyStoreNotFoundException = class _CustomKeyStoreNotFoundException extends KMSServiceException {
  static {
    __name(this, "CustomKeyStoreNotFoundException");
  }
  name = "CustomKeyStoreNotFoundException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "CustomKeyStoreNotFoundException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _CustomKeyStoreNotFoundException.prototype);
  }
};
var ConnectionErrorCodeType = {
  CLUSTER_NOT_FOUND: "CLUSTER_NOT_FOUND",
  INSUFFICIENT_CLOUDHSM_HSMS: "INSUFFICIENT_CLOUDHSM_HSMS",
  INSUFFICIENT_FREE_ADDRESSES_IN_SUBNET: "INSUFFICIENT_FREE_ADDRESSES_IN_SUBNET",
  INTERNAL_ERROR: "INTERNAL_ERROR",
  INVALID_CREDENTIALS: "INVALID_CREDENTIALS",
  NETWORK_ERRORS: "NETWORK_ERRORS",
  SUBNET_NOT_FOUND: "SUBNET_NOT_FOUND",
  USER_LOCKED_OUT: "USER_LOCKED_OUT",
  USER_LOGGED_IN: "USER_LOGGED_IN",
  USER_NOT_FOUND: "USER_NOT_FOUND",
  XKS_PROXY_ACCESS_DENIED: "XKS_PROXY_ACCESS_DENIED",
  XKS_PROXY_INVALID_CONFIGURATION: "XKS_PROXY_INVALID_CONFIGURATION",
  XKS_PROXY_INVALID_RESPONSE: "XKS_PROXY_INVALID_RESPONSE",
  XKS_PROXY_INVALID_TLS_CONFIGURATION: "XKS_PROXY_INVALID_TLS_CONFIGURATION",
  XKS_PROXY_NOT_REACHABLE: "XKS_PROXY_NOT_REACHABLE",
  XKS_PROXY_TIMED_OUT: "XKS_PROXY_TIMED_OUT",
  XKS_VPC_ENDPOINT_SERVICE_INVALID_CONFIGURATION: "XKS_VPC_ENDPOINT_SERVICE_INVALID_CONFIGURATION",
  XKS_VPC_ENDPOINT_SERVICE_NOT_FOUND: "XKS_VPC_ENDPOINT_SERVICE_NOT_FOUND"
};
var ConnectionStateType = {
  CONNECTED: "CONNECTED",
  CONNECTING: "CONNECTING",
  DISCONNECTED: "DISCONNECTED",
  DISCONNECTING: "DISCONNECTING",
  FAILED: "FAILED"
};
var InvalidAliasNameException = class _InvalidAliasNameException extends KMSServiceException {
  static {
    __name(this, "InvalidAliasNameException");
  }
  name = "InvalidAliasNameException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidAliasNameException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidAliasNameException.prototype);
  }
};
var LimitExceededException = class _LimitExceededException extends KMSServiceException {
  static {
    __name(this, "LimitExceededException");
  }
  name = "LimitExceededException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "LimitExceededException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _LimitExceededException.prototype);
  }
};
var CustomKeyStoreType = {
  AWS_CLOUDHSM: "AWS_CLOUDHSM",
  EXTERNAL_KEY_STORE: "EXTERNAL_KEY_STORE"
};
var XksProxyConnectivityType = {
  PUBLIC_ENDPOINT: "PUBLIC_ENDPOINT",
  VPC_ENDPOINT_SERVICE: "VPC_ENDPOINT_SERVICE"
};
var CustomKeyStoreNameInUseException = class _CustomKeyStoreNameInUseException extends KMSServiceException {
  static {
    __name(this, "CustomKeyStoreNameInUseException");
  }
  name = "CustomKeyStoreNameInUseException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "CustomKeyStoreNameInUseException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _CustomKeyStoreNameInUseException.prototype);
  }
};
var IncorrectTrustAnchorException = class _IncorrectTrustAnchorException extends KMSServiceException {
  static {
    __name(this, "IncorrectTrustAnchorException");
  }
  name = "IncorrectTrustAnchorException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "IncorrectTrustAnchorException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _IncorrectTrustAnchorException.prototype);
  }
};
var XksProxyIncorrectAuthenticationCredentialException = class _XksProxyIncorrectAuthenticationCredentialException extends KMSServiceException {
  static {
    __name(this, "XksProxyIncorrectAuthenticationCredentialException");
  }
  name = "XksProxyIncorrectAuthenticationCredentialException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "XksProxyIncorrectAuthenticationCredentialException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _XksProxyIncorrectAuthenticationCredentialException.prototype);
  }
};
var XksProxyInvalidConfigurationException = class _XksProxyInvalidConfigurationException extends KMSServiceException {
  static {
    __name(this, "XksProxyInvalidConfigurationException");
  }
  name = "XksProxyInvalidConfigurationException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "XksProxyInvalidConfigurationException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _XksProxyInvalidConfigurationException.prototype);
  }
};
var XksProxyInvalidResponseException = class _XksProxyInvalidResponseException extends KMSServiceException {
  static {
    __name(this, "XksProxyInvalidResponseException");
  }
  name = "XksProxyInvalidResponseException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "XksProxyInvalidResponseException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _XksProxyInvalidResponseException.prototype);
  }
};
var XksProxyUriEndpointInUseException = class _XksProxyUriEndpointInUseException extends KMSServiceException {
  static {
    __name(this, "XksProxyUriEndpointInUseException");
  }
  name = "XksProxyUriEndpointInUseException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "XksProxyUriEndpointInUseException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _XksProxyUriEndpointInUseException.prototype);
  }
};
var XksProxyUriInUseException = class _XksProxyUriInUseException extends KMSServiceException {
  static {
    __name(this, "XksProxyUriInUseException");
  }
  name = "XksProxyUriInUseException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "XksProxyUriInUseException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _XksProxyUriInUseException.prototype);
  }
};
var XksProxyUriUnreachableException = class _XksProxyUriUnreachableException extends KMSServiceException {
  static {
    __name(this, "XksProxyUriUnreachableException");
  }
  name = "XksProxyUriUnreachableException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "XksProxyUriUnreachableException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _XksProxyUriUnreachableException.prototype);
  }
};
var XksProxyVpcEndpointServiceInUseException = class _XksProxyVpcEndpointServiceInUseException extends KMSServiceException {
  static {
    __name(this, "XksProxyVpcEndpointServiceInUseException");
  }
  name = "XksProxyVpcEndpointServiceInUseException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "XksProxyVpcEndpointServiceInUseException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _XksProxyVpcEndpointServiceInUseException.prototype);
  }
};
var XksProxyVpcEndpointServiceInvalidConfigurationException = class _XksProxyVpcEndpointServiceInvalidConfigurationException extends KMSServiceException {
  static {
    __name(this, "XksProxyVpcEndpointServiceInvalidConfigurationException");
  }
  name = "XksProxyVpcEndpointServiceInvalidConfigurationException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "XksProxyVpcEndpointServiceInvalidConfigurationException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _XksProxyVpcEndpointServiceInvalidConfigurationException.prototype);
  }
};
var XksProxyVpcEndpointServiceNotFoundException = class _XksProxyVpcEndpointServiceNotFoundException extends KMSServiceException {
  static {
    __name(this, "XksProxyVpcEndpointServiceNotFoundException");
  }
  name = "XksProxyVpcEndpointServiceNotFoundException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "XksProxyVpcEndpointServiceNotFoundException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _XksProxyVpcEndpointServiceNotFoundException.prototype);
  }
};
var GrantOperation = {
  CreateGrant: "CreateGrant",
  Decrypt: "Decrypt",
  DeriveSharedSecret: "DeriveSharedSecret",
  DescribeKey: "DescribeKey",
  Encrypt: "Encrypt",
  GenerateDataKey: "GenerateDataKey",
  GenerateDataKeyPair: "GenerateDataKeyPair",
  GenerateDataKeyPairWithoutPlaintext: "GenerateDataKeyPairWithoutPlaintext",
  GenerateDataKeyWithoutPlaintext: "GenerateDataKeyWithoutPlaintext",
  GenerateMac: "GenerateMac",
  GetPublicKey: "GetPublicKey",
  ReEncryptFrom: "ReEncryptFrom",
  ReEncryptTo: "ReEncryptTo",
  RetireGrant: "RetireGrant",
  Sign: "Sign",
  Verify: "Verify",
  VerifyMac: "VerifyMac"
};
var DisabledException = class _DisabledException extends KMSServiceException {
  static {
    __name(this, "DisabledException");
  }
  name = "DisabledException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DisabledException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _DisabledException.prototype);
  }
};
var DryRunOperationException = class _DryRunOperationException extends KMSServiceException {
  static {
    __name(this, "DryRunOperationException");
  }
  name = "DryRunOperationException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DryRunOperationException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _DryRunOperationException.prototype);
  }
};
var InvalidGrantTokenException = class _InvalidGrantTokenException extends KMSServiceException {
  static {
    __name(this, "InvalidGrantTokenException");
  }
  name = "InvalidGrantTokenException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidGrantTokenException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidGrantTokenException.prototype);
  }
};
var CustomerMasterKeySpec = {
  ECC_NIST_P256: "ECC_NIST_P256",
  ECC_NIST_P384: "ECC_NIST_P384",
  ECC_NIST_P521: "ECC_NIST_P521",
  ECC_SECG_P256K1: "ECC_SECG_P256K1",
  HMAC_224: "HMAC_224",
  HMAC_256: "HMAC_256",
  HMAC_384: "HMAC_384",
  HMAC_512: "HMAC_512",
  RSA_2048: "RSA_2048",
  RSA_3072: "RSA_3072",
  RSA_4096: "RSA_4096",
  SM2: "SM2",
  SYMMETRIC_DEFAULT: "SYMMETRIC_DEFAULT"
};
var KeySpec = {
  ECC_NIST_P256: "ECC_NIST_P256",
  ECC_NIST_P384: "ECC_NIST_P384",
  ECC_NIST_P521: "ECC_NIST_P521",
  ECC_SECG_P256K1: "ECC_SECG_P256K1",
  HMAC_224: "HMAC_224",
  HMAC_256: "HMAC_256",
  HMAC_384: "HMAC_384",
  HMAC_512: "HMAC_512",
  ML_DSA_44: "ML_DSA_44",
  ML_DSA_65: "ML_DSA_65",
  ML_DSA_87: "ML_DSA_87",
  RSA_2048: "RSA_2048",
  RSA_3072: "RSA_3072",
  RSA_4096: "RSA_4096",
  SM2: "SM2",
  SYMMETRIC_DEFAULT: "SYMMETRIC_DEFAULT"
};
var KeyUsageType = {
  ENCRYPT_DECRYPT: "ENCRYPT_DECRYPT",
  GENERATE_VERIFY_MAC: "GENERATE_VERIFY_MAC",
  KEY_AGREEMENT: "KEY_AGREEMENT",
  SIGN_VERIFY: "SIGN_VERIFY"
};
var OriginType = {
  AWS_CLOUDHSM: "AWS_CLOUDHSM",
  AWS_KMS: "AWS_KMS",
  EXTERNAL: "EXTERNAL",
  EXTERNAL_KEY_STORE: "EXTERNAL_KEY_STORE"
};
var EncryptionAlgorithmSpec = {
  RSAES_OAEP_SHA_1: "RSAES_OAEP_SHA_1",
  RSAES_OAEP_SHA_256: "RSAES_OAEP_SHA_256",
  SM2PKE: "SM2PKE",
  SYMMETRIC_DEFAULT: "SYMMETRIC_DEFAULT"
};
var ExpirationModelType = {
  KEY_MATERIAL_DOES_NOT_EXPIRE: "KEY_MATERIAL_DOES_NOT_EXPIRE",
  KEY_MATERIAL_EXPIRES: "KEY_MATERIAL_EXPIRES"
};
var KeyAgreementAlgorithmSpec = {
  ECDH: "ECDH"
};
var KeyManagerType = {
  AWS: "AWS",
  CUSTOMER: "CUSTOMER"
};
var KeyState = {
  Creating: "Creating",
  Disabled: "Disabled",
  Enabled: "Enabled",
  PendingDeletion: "PendingDeletion",
  PendingImport: "PendingImport",
  PendingReplicaDeletion: "PendingReplicaDeletion",
  Unavailable: "Unavailable",
  Updating: "Updating"
};
var MacAlgorithmSpec = {
  HMAC_SHA_224: "HMAC_SHA_224",
  HMAC_SHA_256: "HMAC_SHA_256",
  HMAC_SHA_384: "HMAC_SHA_384",
  HMAC_SHA_512: "HMAC_SHA_512"
};
var MultiRegionKeyType = {
  PRIMARY: "PRIMARY",
  REPLICA: "REPLICA"
};
var SigningAlgorithmSpec = {
  ECDSA_SHA_256: "ECDSA_SHA_256",
  ECDSA_SHA_384: "ECDSA_SHA_384",
  ECDSA_SHA_512: "ECDSA_SHA_512",
  ML_DSA_SHAKE_256: "ML_DSA_SHAKE_256",
  RSASSA_PKCS1_V1_5_SHA_256: "RSASSA_PKCS1_V1_5_SHA_256",
  RSASSA_PKCS1_V1_5_SHA_384: "RSASSA_PKCS1_V1_5_SHA_384",
  RSASSA_PKCS1_V1_5_SHA_512: "RSASSA_PKCS1_V1_5_SHA_512",
  RSASSA_PSS_SHA_256: "RSASSA_PSS_SHA_256",
  RSASSA_PSS_SHA_384: "RSASSA_PSS_SHA_384",
  RSASSA_PSS_SHA_512: "RSASSA_PSS_SHA_512",
  SM2DSA: "SM2DSA"
};
var MalformedPolicyDocumentException = class _MalformedPolicyDocumentException extends KMSServiceException {
  static {
    __name(this, "MalformedPolicyDocumentException");
  }
  name = "MalformedPolicyDocumentException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "MalformedPolicyDocumentException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _MalformedPolicyDocumentException.prototype);
  }
};
var TagException = class _TagException extends KMSServiceException {
  static {
    __name(this, "TagException");
  }
  name = "TagException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TagException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TagException.prototype);
  }
};
var UnsupportedOperationException = class _UnsupportedOperationException extends KMSServiceException {
  static {
    __name(this, "UnsupportedOperationException");
  }
  name = "UnsupportedOperationException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "UnsupportedOperationException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _UnsupportedOperationException.prototype);
  }
};
var XksKeyAlreadyInUseException = class _XksKeyAlreadyInUseException extends KMSServiceException {
  static {
    __name(this, "XksKeyAlreadyInUseException");
  }
  name = "XksKeyAlreadyInUseException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "XksKeyAlreadyInUseException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _XksKeyAlreadyInUseException.prototype);
  }
};
var XksKeyInvalidConfigurationException = class _XksKeyInvalidConfigurationException extends KMSServiceException {
  static {
    __name(this, "XksKeyInvalidConfigurationException");
  }
  name = "XksKeyInvalidConfigurationException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "XksKeyInvalidConfigurationException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _XksKeyInvalidConfigurationException.prototype);
  }
};
var XksKeyNotFoundException = class _XksKeyNotFoundException extends KMSServiceException {
  static {
    __name(this, "XksKeyNotFoundException");
  }
  name = "XksKeyNotFoundException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "XksKeyNotFoundException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _XksKeyNotFoundException.prototype);
  }
};
var CustomKeyStoreHasCMKsException = class _CustomKeyStoreHasCMKsException extends KMSServiceException {
  static {
    __name(this, "CustomKeyStoreHasCMKsException");
  }
  name = "CustomKeyStoreHasCMKsException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "CustomKeyStoreHasCMKsException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _CustomKeyStoreHasCMKsException.prototype);
  }
};
var DataKeyPairSpec = {
  ECC_NIST_P256: "ECC_NIST_P256",
  ECC_NIST_P384: "ECC_NIST_P384",
  ECC_NIST_P521: "ECC_NIST_P521",
  ECC_SECG_P256K1: "ECC_SECG_P256K1",
  RSA_2048: "RSA_2048",
  RSA_3072: "RSA_3072",
  RSA_4096: "RSA_4096",
  SM2: "SM2"
};
var DataKeySpec = {
  AES_128: "AES_128",
  AES_256: "AES_256"
};
var KeyEncryptionMechanism = {
  RSAES_OAEP_SHA_256: "RSAES_OAEP_SHA_256"
};
var IncorrectKeyException = class _IncorrectKeyException extends KMSServiceException {
  static {
    __name(this, "IncorrectKeyException");
  }
  name = "IncorrectKeyException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "IncorrectKeyException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _IncorrectKeyException.prototype);
  }
};
var InvalidCiphertextException = class _InvalidCiphertextException extends KMSServiceException {
  static {
    __name(this, "InvalidCiphertextException");
  }
  name = "InvalidCiphertextException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidCiphertextException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidCiphertextException.prototype);
  }
};
var InvalidKeyUsageException = class _InvalidKeyUsageException extends KMSServiceException {
  static {
    __name(this, "InvalidKeyUsageException");
  }
  name = "InvalidKeyUsageException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidKeyUsageException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidKeyUsageException.prototype);
  }
};
var KeyUnavailableException = class _KeyUnavailableException extends KMSServiceException {
  static {
    __name(this, "KeyUnavailableException");
  }
  name = "KeyUnavailableException";
  $fault = "server";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "KeyUnavailableException",
      $fault: "server",
      ...opts
    });
    Object.setPrototypeOf(this, _KeyUnavailableException.prototype);
  }
};
var InvalidMarkerException = class _InvalidMarkerException extends KMSServiceException {
  static {
    __name(this, "InvalidMarkerException");
  }
  name = "InvalidMarkerException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidMarkerException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidMarkerException.prototype);
  }
};
var ExpiredImportTokenException = class _ExpiredImportTokenException extends KMSServiceException {
  static {
    __name(this, "ExpiredImportTokenException");
  }
  name = "ExpiredImportTokenException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ExpiredImportTokenException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ExpiredImportTokenException.prototype);
  }
};
var WrappingKeySpec = {
  RSA_2048: "RSA_2048",
  RSA_3072: "RSA_3072",
  RSA_4096: "RSA_4096",
  SM2: "SM2"
};
var ImportType = {
  EXISTING_KEY_MATERIAL: "EXISTING_KEY_MATERIAL",
  NEW_KEY_MATERIAL: "NEW_KEY_MATERIAL"
};
var IncorrectKeyMaterialException = class _IncorrectKeyMaterialException extends KMSServiceException {
  static {
    __name(this, "IncorrectKeyMaterialException");
  }
  name = "IncorrectKeyMaterialException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "IncorrectKeyMaterialException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _IncorrectKeyMaterialException.prototype);
  }
};
var InvalidImportTokenException = class _InvalidImportTokenException extends KMSServiceException {
  static {
    __name(this, "InvalidImportTokenException");
  }
  name = "InvalidImportTokenException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidImportTokenException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidImportTokenException.prototype);
  }
};
var ImportState = {
  IMPORTED: "IMPORTED",
  PENDING_IMPORT: "PENDING_IMPORT"
};
var IncludeKeyMaterial = {
  ALL_KEY_MATERIAL: "ALL_KEY_MATERIAL",
  ROTATIONS_ONLY: "ROTATIONS_ONLY"
};
var InvalidGrantIdException = class _InvalidGrantIdException extends KMSServiceException {
  static {
    __name(this, "InvalidGrantIdException");
  }
  name = "InvalidGrantIdException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidGrantIdException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidGrantIdException.prototype);
  }
};
var KeyMaterialState = {
  CURRENT: "CURRENT",
  NON_CURRENT: "NON_CURRENT",
  PENDING_ROTATION: "PENDING_ROTATION"
};
var KMSInvalidMacException = class _KMSInvalidMacException extends KMSServiceException {
  static {
    __name(this, "KMSInvalidMacException");
  }
  name = "KMSInvalidMacException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "KMSInvalidMacException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _KMSInvalidMacException.prototype);
  }
};
var KMSInvalidSignatureException = class _KMSInvalidSignatureException extends KMSServiceException {
  static {
    __name(this, "KMSInvalidSignatureException");
  }
  name = "KMSInvalidSignatureException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "KMSInvalidSignatureException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _KMSInvalidSignatureException.prototype);
  }
};
var RotationType = {
  AUTOMATIC: "AUTOMATIC",
  ON_DEMAND: "ON_DEMAND"
};
var MessageType = {
  DIGEST: "DIGEST",
  EXTERNAL_MU: "EXTERNAL_MU",
  RAW: "RAW"
};
var XksProxyAuthenticationCredentialTypeFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.AccessKeyId && { AccessKeyId: import_smithy_client.SENSITIVE_STRING },
  ...obj.RawSecretAccessKey && { RawSecretAccessKey: import_smithy_client.SENSITIVE_STRING }
}), "XksProxyAuthenticationCredentialTypeFilterSensitiveLog");
var CreateCustomKeyStoreRequestFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.KeyStorePassword && { KeyStorePassword: import_smithy_client.SENSITIVE_STRING },
  ...obj.XksProxyAuthenticationCredential && {
    XksProxyAuthenticationCredential: XksProxyAuthenticationCredentialTypeFilterSensitiveLog(
      obj.XksProxyAuthenticationCredential
    )
  }
}), "CreateCustomKeyStoreRequestFilterSensitiveLog");
var XksProxyConfigurationTypeFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.AccessKeyId && { AccessKeyId: import_smithy_client.SENSITIVE_STRING }
}), "XksProxyConfigurationTypeFilterSensitiveLog");
var CustomKeyStoresListEntryFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.XksProxyConfiguration && {
    XksProxyConfiguration: XksProxyConfigurationTypeFilterSensitiveLog(obj.XksProxyConfiguration)
  }
}), "CustomKeyStoresListEntryFilterSensitiveLog");
var DecryptResponseFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.Plaintext && { Plaintext: import_smithy_client.SENSITIVE_STRING }
}), "DecryptResponseFilterSensitiveLog");
var DeriveSharedSecretResponseFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.SharedSecret && { SharedSecret: import_smithy_client.SENSITIVE_STRING }
}), "DeriveSharedSecretResponseFilterSensitiveLog");
var DescribeCustomKeyStoresResponseFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.CustomKeyStores && {
    CustomKeyStores: obj.CustomKeyStores.map((item) => CustomKeyStoresListEntryFilterSensitiveLog(item))
  }
}), "DescribeCustomKeyStoresResponseFilterSensitiveLog");
var EncryptRequestFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.Plaintext && { Plaintext: import_smithy_client.SENSITIVE_STRING }
}), "EncryptRequestFilterSensitiveLog");
var GenerateDataKeyResponseFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.Plaintext && { Plaintext: import_smithy_client.SENSITIVE_STRING }
}), "GenerateDataKeyResponseFilterSensitiveLog");
var GenerateDataKeyPairResponseFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.PrivateKeyPlaintext && { PrivateKeyPlaintext: import_smithy_client.SENSITIVE_STRING }
}), "GenerateDataKeyPairResponseFilterSensitiveLog");
var GenerateMacRequestFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.Message && { Message: import_smithy_client.SENSITIVE_STRING }
}), "GenerateMacRequestFilterSensitiveLog");
var GenerateRandomResponseFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.Plaintext && { Plaintext: import_smithy_client.SENSITIVE_STRING }
}), "GenerateRandomResponseFilterSensitiveLog");
var GetParametersForImportResponseFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.PublicKey && { PublicKey: import_smithy_client.SENSITIVE_STRING }
}), "GetParametersForImportResponseFilterSensitiveLog");
var SignRequestFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.Message && { Message: import_smithy_client.SENSITIVE_STRING }
}), "SignRequestFilterSensitiveLog");
var UpdateCustomKeyStoreRequestFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.KeyStorePassword && { KeyStorePassword: import_smithy_client.SENSITIVE_STRING },
  ...obj.XksProxyAuthenticationCredential && {
    XksProxyAuthenticationCredential: XksProxyAuthenticationCredentialTypeFilterSensitiveLog(
      obj.XksProxyAuthenticationCredential
    )
  }
}), "UpdateCustomKeyStoreRequestFilterSensitiveLog");
var VerifyRequestFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.Message && { Message: import_smithy_client.SENSITIVE_STRING }
}), "VerifyRequestFilterSensitiveLog");
var VerifyMacRequestFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.Message && { Message: import_smithy_client.SENSITIVE_STRING }
}), "VerifyMacRequestFilterSensitiveLog");

// src/protocols/Aws_json1_1.ts
var se_CancelKeyDeletionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("CancelKeyDeletion");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CancelKeyDeletionCommand");
var se_ConnectCustomKeyStoreCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ConnectCustomKeyStore");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ConnectCustomKeyStoreCommand");
var se_CreateAliasCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("CreateAlias");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CreateAliasCommand");
var se_CreateCustomKeyStoreCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("CreateCustomKeyStore");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CreateCustomKeyStoreCommand");
var se_CreateGrantCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("CreateGrant");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CreateGrantCommand");
var se_CreateKeyCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("CreateKey");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CreateKeyCommand");
var se_DecryptCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("Decrypt");
  let body;
  body = JSON.stringify(se_DecryptRequest(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DecryptCommand");
var se_DeleteAliasCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DeleteAlias");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeleteAliasCommand");
var se_DeleteCustomKeyStoreCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DeleteCustomKeyStore");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeleteCustomKeyStoreCommand");
var se_DeleteImportedKeyMaterialCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DeleteImportedKeyMaterial");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeleteImportedKeyMaterialCommand");
var se_DeriveSharedSecretCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DeriveSharedSecret");
  let body;
  body = JSON.stringify(se_DeriveSharedSecretRequest(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeriveSharedSecretCommand");
var se_DescribeCustomKeyStoresCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DescribeCustomKeyStores");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeCustomKeyStoresCommand");
var se_DescribeKeyCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DescribeKey");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeKeyCommand");
var se_DisableKeyCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DisableKey");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DisableKeyCommand");
var se_DisableKeyRotationCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DisableKeyRotation");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DisableKeyRotationCommand");
var se_DisconnectCustomKeyStoreCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DisconnectCustomKeyStore");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DisconnectCustomKeyStoreCommand");
var se_EnableKeyCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("EnableKey");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_EnableKeyCommand");
var se_EnableKeyRotationCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("EnableKeyRotation");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_EnableKeyRotationCommand");
var se_EncryptCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("Encrypt");
  let body;
  body = JSON.stringify(se_EncryptRequest(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_EncryptCommand");
var se_GenerateDataKeyCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("GenerateDataKey");
  let body;
  body = JSON.stringify(se_GenerateDataKeyRequest(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GenerateDataKeyCommand");
var se_GenerateDataKeyPairCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("GenerateDataKeyPair");
  let body;
  body = JSON.stringify(se_GenerateDataKeyPairRequest(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GenerateDataKeyPairCommand");
var se_GenerateDataKeyPairWithoutPlaintextCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("GenerateDataKeyPairWithoutPlaintext");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GenerateDataKeyPairWithoutPlaintextCommand");
var se_GenerateDataKeyWithoutPlaintextCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("GenerateDataKeyWithoutPlaintext");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GenerateDataKeyWithoutPlaintextCommand");
var se_GenerateMacCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("GenerateMac");
  let body;
  body = JSON.stringify(se_GenerateMacRequest(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GenerateMacCommand");
var se_GenerateRandomCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("GenerateRandom");
  let body;
  body = JSON.stringify(se_GenerateRandomRequest(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GenerateRandomCommand");
var se_GetKeyPolicyCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("GetKeyPolicy");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetKeyPolicyCommand");
var se_GetKeyRotationStatusCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("GetKeyRotationStatus");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetKeyRotationStatusCommand");
var se_GetParametersForImportCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("GetParametersForImport");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetParametersForImportCommand");
var se_GetPublicKeyCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("GetPublicKey");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetPublicKeyCommand");
var se_ImportKeyMaterialCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ImportKeyMaterial");
  let body;
  body = JSON.stringify(se_ImportKeyMaterialRequest(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ImportKeyMaterialCommand");
var se_ListAliasesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ListAliases");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListAliasesCommand");
var se_ListGrantsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ListGrants");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListGrantsCommand");
var se_ListKeyPoliciesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ListKeyPolicies");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListKeyPoliciesCommand");
var se_ListKeyRotationsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ListKeyRotations");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListKeyRotationsCommand");
var se_ListKeysCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ListKeys");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListKeysCommand");
var se_ListResourceTagsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ListResourceTags");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListResourceTagsCommand");
var se_ListRetirableGrantsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ListRetirableGrants");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListRetirableGrantsCommand");
var se_PutKeyPolicyCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("PutKeyPolicy");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_PutKeyPolicyCommand");
var se_ReEncryptCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ReEncrypt");
  let body;
  body = JSON.stringify(se_ReEncryptRequest(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ReEncryptCommand");
var se_ReplicateKeyCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ReplicateKey");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ReplicateKeyCommand");
var se_RetireGrantCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("RetireGrant");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_RetireGrantCommand");
var se_RevokeGrantCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("RevokeGrant");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_RevokeGrantCommand");
var se_RotateKeyOnDemandCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("RotateKeyOnDemand");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_RotateKeyOnDemandCommand");
var se_ScheduleKeyDeletionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ScheduleKeyDeletion");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ScheduleKeyDeletionCommand");
var se_SignCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("Sign");
  let body;
  body = JSON.stringify(se_SignRequest(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_SignCommand");
var se_TagResourceCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("TagResource");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_TagResourceCommand");
var se_UntagResourceCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("UntagResource");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_UntagResourceCommand");
var se_UpdateAliasCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("UpdateAlias");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_UpdateAliasCommand");
var se_UpdateCustomKeyStoreCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("UpdateCustomKeyStore");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_UpdateCustomKeyStoreCommand");
var se_UpdateKeyDescriptionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("UpdateKeyDescription");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_UpdateKeyDescriptionCommand");
var se_UpdatePrimaryRegionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("UpdatePrimaryRegion");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_UpdatePrimaryRegionCommand");
var se_VerifyCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("Verify");
  let body;
  body = JSON.stringify(se_VerifyRequest(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_VerifyCommand");
var se_VerifyMacCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("VerifyMac");
  let body;
  body = JSON.stringify(se_VerifyMacRequest(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_VerifyMacCommand");
var de_CancelKeyDeletionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CancelKeyDeletionCommand");
var de_ConnectCustomKeyStoreCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ConnectCustomKeyStoreCommand");
var de_CreateAliasCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_CreateAliasCommand");
var de_CreateCustomKeyStoreCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CreateCustomKeyStoreCommand");
var de_CreateGrantCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CreateGrantCommand");
var de_CreateKeyCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_CreateKeyResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CreateKeyCommand");
var de_DecryptCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_DecryptResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DecryptCommand");
var de_DeleteAliasCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_DeleteAliasCommand");
var de_DeleteCustomKeyStoreCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DeleteCustomKeyStoreCommand");
var de_DeleteImportedKeyMaterialCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DeleteImportedKeyMaterialCommand");
var de_DeriveSharedSecretCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_DeriveSharedSecretResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DeriveSharedSecretCommand");
var de_DescribeCustomKeyStoresCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_DescribeCustomKeyStoresResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeCustomKeyStoresCommand");
var de_DescribeKeyCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_DescribeKeyResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeKeyCommand");
var de_DisableKeyCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_DisableKeyCommand");
var de_DisableKeyRotationCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_DisableKeyRotationCommand");
var de_DisconnectCustomKeyStoreCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DisconnectCustomKeyStoreCommand");
var de_EnableKeyCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_EnableKeyCommand");
var de_EnableKeyRotationCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_EnableKeyRotationCommand");
var de_EncryptCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_EncryptResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_EncryptCommand");
var de_GenerateDataKeyCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_GenerateDataKeyResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GenerateDataKeyCommand");
var de_GenerateDataKeyPairCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_GenerateDataKeyPairResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GenerateDataKeyPairCommand");
var de_GenerateDataKeyPairWithoutPlaintextCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_GenerateDataKeyPairWithoutPlaintextResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GenerateDataKeyPairWithoutPlaintextCommand");
var de_GenerateDataKeyWithoutPlaintextCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_GenerateDataKeyWithoutPlaintextResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GenerateDataKeyWithoutPlaintextCommand");
var de_GenerateMacCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_GenerateMacResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GenerateMacCommand");
var de_GenerateRandomCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_GenerateRandomResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GenerateRandomCommand");
var de_GetKeyPolicyCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetKeyPolicyCommand");
var de_GetKeyRotationStatusCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_GetKeyRotationStatusResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetKeyRotationStatusCommand");
var de_GetParametersForImportCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_GetParametersForImportResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetParametersForImportCommand");
var de_GetPublicKeyCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_GetPublicKeyResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetPublicKeyCommand");
var de_ImportKeyMaterialCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ImportKeyMaterialCommand");
var de_ListAliasesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_ListAliasesResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListAliasesCommand");
var de_ListGrantsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_ListGrantsResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListGrantsCommand");
var de_ListKeyPoliciesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListKeyPoliciesCommand");
var de_ListKeyRotationsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_ListKeyRotationsResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListKeyRotationsCommand");
var de_ListKeysCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListKeysCommand");
var de_ListResourceTagsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListResourceTagsCommand");
var de_ListRetirableGrantsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_ListGrantsResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListRetirableGrantsCommand");
var de_PutKeyPolicyCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_PutKeyPolicyCommand");
var de_ReEncryptCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_ReEncryptResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ReEncryptCommand");
var de_ReplicateKeyCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_ReplicateKeyResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ReplicateKeyCommand");
var de_RetireGrantCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_RetireGrantCommand");
var de_RevokeGrantCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_RevokeGrantCommand");
var de_RotateKeyOnDemandCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_RotateKeyOnDemandCommand");
var de_ScheduleKeyDeletionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_ScheduleKeyDeletionResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ScheduleKeyDeletionCommand");
var de_SignCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_SignResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_SignCommand");
var de_TagResourceCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_TagResourceCommand");
var de_UntagResourceCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_UntagResourceCommand");
var de_UpdateAliasCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_UpdateAliasCommand");
var de_UpdateCustomKeyStoreCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_UpdateCustomKeyStoreCommand");
var de_UpdateKeyDescriptionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_UpdateKeyDescriptionCommand");
var de_UpdatePrimaryRegionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_UpdatePrimaryRegionCommand");
var de_VerifyCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_VerifyCommand");
var de_VerifyMacCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_VerifyMacCommand");
var de_CommandError = /* @__PURE__ */ __name(async (output, context) => {
  const parsedOutput = {
    ...output,
    body: await (0, import_core2.parseJsonErrorBody)(output.body, context)
  };
  const errorCode = (0, import_core2.loadRestJsonErrorCode)(output, parsedOutput.body);
  switch (errorCode) {
    case "DependencyTimeoutException":
    case "com.amazonaws.kms#DependencyTimeoutException":
      throw await de_DependencyTimeoutExceptionRes(parsedOutput, context);
    case "InvalidArnException":
    case "com.amazonaws.kms#InvalidArnException":
      throw await de_InvalidArnExceptionRes(parsedOutput, context);
    case "KMSInternalException":
    case "com.amazonaws.kms#KMSInternalException":
      throw await de_KMSInternalExceptionRes(parsedOutput, context);
    case "KMSInvalidStateException":
    case "com.amazonaws.kms#KMSInvalidStateException":
      throw await de_KMSInvalidStateExceptionRes(parsedOutput, context);
    case "NotFoundException":
    case "com.amazonaws.kms#NotFoundException":
      throw await de_NotFoundExceptionRes(parsedOutput, context);
    case "CloudHsmClusterInvalidConfigurationException":
    case "com.amazonaws.kms#CloudHsmClusterInvalidConfigurationException":
      throw await de_CloudHsmClusterInvalidConfigurationExceptionRes(parsedOutput, context);
    case "CloudHsmClusterNotActiveException":
    case "com.amazonaws.kms#CloudHsmClusterNotActiveException":
      throw await de_CloudHsmClusterNotActiveExceptionRes(parsedOutput, context);
    case "CustomKeyStoreInvalidStateException":
    case "com.amazonaws.kms#CustomKeyStoreInvalidStateException":
      throw await de_CustomKeyStoreInvalidStateExceptionRes(parsedOutput, context);
    case "CustomKeyStoreNotFoundException":
    case "com.amazonaws.kms#CustomKeyStoreNotFoundException":
      throw await de_CustomKeyStoreNotFoundExceptionRes(parsedOutput, context);
    case "AlreadyExistsException":
    case "com.amazonaws.kms#AlreadyExistsException":
      throw await de_AlreadyExistsExceptionRes(parsedOutput, context);
    case "InvalidAliasNameException":
    case "com.amazonaws.kms#InvalidAliasNameException":
      throw await de_InvalidAliasNameExceptionRes(parsedOutput, context);
    case "LimitExceededException":
    case "com.amazonaws.kms#LimitExceededException":
      throw await de_LimitExceededExceptionRes(parsedOutput, context);
    case "CloudHsmClusterInUseException":
    case "com.amazonaws.kms#CloudHsmClusterInUseException":
      throw await de_CloudHsmClusterInUseExceptionRes(parsedOutput, context);
    case "CloudHsmClusterNotFoundException":
    case "com.amazonaws.kms#CloudHsmClusterNotFoundException":
      throw await de_CloudHsmClusterNotFoundExceptionRes(parsedOutput, context);
    case "CustomKeyStoreNameInUseException":
    case "com.amazonaws.kms#CustomKeyStoreNameInUseException":
      throw await de_CustomKeyStoreNameInUseExceptionRes(parsedOutput, context);
    case "IncorrectTrustAnchorException":
    case "com.amazonaws.kms#IncorrectTrustAnchorException":
      throw await de_IncorrectTrustAnchorExceptionRes(parsedOutput, context);
    case "XksProxyIncorrectAuthenticationCredentialException":
    case "com.amazonaws.kms#XksProxyIncorrectAuthenticationCredentialException":
      throw await de_XksProxyIncorrectAuthenticationCredentialExceptionRes(parsedOutput, context);
    case "XksProxyInvalidConfigurationException":
    case "com.amazonaws.kms#XksProxyInvalidConfigurationException":
      throw await de_XksProxyInvalidConfigurationExceptionRes(parsedOutput, context);
    case "XksProxyInvalidResponseException":
    case "com.amazonaws.kms#XksProxyInvalidResponseException":
      throw await de_XksProxyInvalidResponseExceptionRes(parsedOutput, context);
    case "XksProxyUriEndpointInUseException":
    case "com.amazonaws.kms#XksProxyUriEndpointInUseException":
      throw await de_XksProxyUriEndpointInUseExceptionRes(parsedOutput, context);
    case "XksProxyUriInUseException":
    case "com.amazonaws.kms#XksProxyUriInUseException":
      throw await de_XksProxyUriInUseExceptionRes(parsedOutput, context);
    case "XksProxyUriUnreachableException":
    case "com.amazonaws.kms#XksProxyUriUnreachableException":
      throw await de_XksProxyUriUnreachableExceptionRes(parsedOutput, context);
    case "XksProxyVpcEndpointServiceInUseException":
    case "com.amazonaws.kms#XksProxyVpcEndpointServiceInUseException":
      throw await de_XksProxyVpcEndpointServiceInUseExceptionRes(parsedOutput, context);
    case "XksProxyVpcEndpointServiceInvalidConfigurationException":
    case "com.amazonaws.kms#XksProxyVpcEndpointServiceInvalidConfigurationException":
      throw await de_XksProxyVpcEndpointServiceInvalidConfigurationExceptionRes(parsedOutput, context);
    case "XksProxyVpcEndpointServiceNotFoundException":
    case "com.amazonaws.kms#XksProxyVpcEndpointServiceNotFoundException":
      throw await de_XksProxyVpcEndpointServiceNotFoundExceptionRes(parsedOutput, context);
    case "DisabledException":
    case "com.amazonaws.kms#DisabledException":
      throw await de_DisabledExceptionRes(parsedOutput, context);
    case "DryRunOperationException":
    case "com.amazonaws.kms#DryRunOperationException":
      throw await de_DryRunOperationExceptionRes(parsedOutput, context);
    case "InvalidGrantTokenException":
    case "com.amazonaws.kms#InvalidGrantTokenException":
      throw await de_InvalidGrantTokenExceptionRes(parsedOutput, context);
    case "MalformedPolicyDocumentException":
    case "com.amazonaws.kms#MalformedPolicyDocumentException":
      throw await de_MalformedPolicyDocumentExceptionRes(parsedOutput, context);
    case "TagException":
    case "com.amazonaws.kms#TagException":
      throw await de_TagExceptionRes(parsedOutput, context);
    case "UnsupportedOperationException":
    case "com.amazonaws.kms#UnsupportedOperationException":
      throw await de_UnsupportedOperationExceptionRes(parsedOutput, context);
    case "XksKeyAlreadyInUseException":
    case "com.amazonaws.kms#XksKeyAlreadyInUseException":
      throw await de_XksKeyAlreadyInUseExceptionRes(parsedOutput, context);
    case "XksKeyInvalidConfigurationException":
    case "com.amazonaws.kms#XksKeyInvalidConfigurationException":
      throw await de_XksKeyInvalidConfigurationExceptionRes(parsedOutput, context);
    case "XksKeyNotFoundException":
    case "com.amazonaws.kms#XksKeyNotFoundException":
      throw await de_XksKeyNotFoundExceptionRes(parsedOutput, context);
    case "IncorrectKeyException":
    case "com.amazonaws.kms#IncorrectKeyException":
      throw await de_IncorrectKeyExceptionRes(parsedOutput, context);
    case "InvalidCiphertextException":
    case "com.amazonaws.kms#InvalidCiphertextException":
      throw await de_InvalidCiphertextExceptionRes(parsedOutput, context);
    case "InvalidKeyUsageException":
    case "com.amazonaws.kms#InvalidKeyUsageException":
      throw await de_InvalidKeyUsageExceptionRes(parsedOutput, context);
    case "KeyUnavailableException":
    case "com.amazonaws.kms#KeyUnavailableException":
      throw await de_KeyUnavailableExceptionRes(parsedOutput, context);
    case "CustomKeyStoreHasCMKsException":
    case "com.amazonaws.kms#CustomKeyStoreHasCMKsException":
      throw await de_CustomKeyStoreHasCMKsExceptionRes(parsedOutput, context);
    case "InvalidMarkerException":
    case "com.amazonaws.kms#InvalidMarkerException":
      throw await de_InvalidMarkerExceptionRes(parsedOutput, context);
    case "ExpiredImportTokenException":
    case "com.amazonaws.kms#ExpiredImportTokenException":
      throw await de_ExpiredImportTokenExceptionRes(parsedOutput, context);
    case "IncorrectKeyMaterialException":
    case "com.amazonaws.kms#IncorrectKeyMaterialException":
      throw await de_IncorrectKeyMaterialExceptionRes(parsedOutput, context);
    case "InvalidImportTokenException":
    case "com.amazonaws.kms#InvalidImportTokenException":
      throw await de_InvalidImportTokenExceptionRes(parsedOutput, context);
    case "InvalidGrantIdException":
    case "com.amazonaws.kms#InvalidGrantIdException":
      throw await de_InvalidGrantIdExceptionRes(parsedOutput, context);
    case "ConflictException":
    case "com.amazonaws.kms#ConflictException":
      throw await de_ConflictExceptionRes(parsedOutput, context);
    case "CloudHsmClusterNotRelatedException":
    case "com.amazonaws.kms#CloudHsmClusterNotRelatedException":
      throw await de_CloudHsmClusterNotRelatedExceptionRes(parsedOutput, context);
    case "KMSInvalidSignatureException":
    case "com.amazonaws.kms#KMSInvalidSignatureException":
      throw await de_KMSInvalidSignatureExceptionRes(parsedOutput, context);
    case "KMSInvalidMacException":
    case "com.amazonaws.kms#KMSInvalidMacException":
      throw await de_KMSInvalidMacExceptionRes(parsedOutput, context);
    default:
      const parsedBody = parsedOutput.body;
      return throwDefaultError({
        output,
        parsedBody,
        errorCode
      });
  }
}, "de_CommandError");
var de_AlreadyExistsExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new AlreadyExistsException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_AlreadyExistsExceptionRes");
var de_CloudHsmClusterInUseExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new CloudHsmClusterInUseException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_CloudHsmClusterInUseExceptionRes");
var de_CloudHsmClusterInvalidConfigurationExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new CloudHsmClusterInvalidConfigurationException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_CloudHsmClusterInvalidConfigurationExceptionRes");
var de_CloudHsmClusterNotActiveExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new CloudHsmClusterNotActiveException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_CloudHsmClusterNotActiveExceptionRes");
var de_CloudHsmClusterNotFoundExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new CloudHsmClusterNotFoundException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_CloudHsmClusterNotFoundExceptionRes");
var de_CloudHsmClusterNotRelatedExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new CloudHsmClusterNotRelatedException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_CloudHsmClusterNotRelatedExceptionRes");
var de_ConflictExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ConflictException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ConflictExceptionRes");
var de_CustomKeyStoreHasCMKsExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new CustomKeyStoreHasCMKsException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_CustomKeyStoreHasCMKsExceptionRes");
var de_CustomKeyStoreInvalidStateExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new CustomKeyStoreInvalidStateException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_CustomKeyStoreInvalidStateExceptionRes");
var de_CustomKeyStoreNameInUseExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new CustomKeyStoreNameInUseException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_CustomKeyStoreNameInUseExceptionRes");
var de_CustomKeyStoreNotFoundExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new CustomKeyStoreNotFoundException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_CustomKeyStoreNotFoundExceptionRes");
var de_DependencyTimeoutExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new DependencyTimeoutException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_DependencyTimeoutExceptionRes");
var de_DisabledExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new DisabledException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_DisabledExceptionRes");
var de_DryRunOperationExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new DryRunOperationException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_DryRunOperationExceptionRes");
var de_ExpiredImportTokenExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ExpiredImportTokenException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ExpiredImportTokenExceptionRes");
var de_IncorrectKeyExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new IncorrectKeyException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_IncorrectKeyExceptionRes");
var de_IncorrectKeyMaterialExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new IncorrectKeyMaterialException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_IncorrectKeyMaterialExceptionRes");
var de_IncorrectTrustAnchorExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new IncorrectTrustAnchorException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_IncorrectTrustAnchorExceptionRes");
var de_InvalidAliasNameExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidAliasNameException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidAliasNameExceptionRes");
var de_InvalidArnExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidArnException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidArnExceptionRes");
var de_InvalidCiphertextExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidCiphertextException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidCiphertextExceptionRes");
var de_InvalidGrantIdExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidGrantIdException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidGrantIdExceptionRes");
var de_InvalidGrantTokenExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidGrantTokenException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidGrantTokenExceptionRes");
var de_InvalidImportTokenExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidImportTokenException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidImportTokenExceptionRes");
var de_InvalidKeyUsageExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidKeyUsageException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidKeyUsageExceptionRes");
var de_InvalidMarkerExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidMarkerException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidMarkerExceptionRes");
var de_KeyUnavailableExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new KeyUnavailableException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_KeyUnavailableExceptionRes");
var de_KMSInternalExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new KMSInternalException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_KMSInternalExceptionRes");
var de_KMSInvalidMacExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new KMSInvalidMacException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_KMSInvalidMacExceptionRes");
var de_KMSInvalidSignatureExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new KMSInvalidSignatureException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_KMSInvalidSignatureExceptionRes");
var de_KMSInvalidStateExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new KMSInvalidStateException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_KMSInvalidStateExceptionRes");
var de_LimitExceededExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new LimitExceededException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_LimitExceededExceptionRes");
var de_MalformedPolicyDocumentExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new MalformedPolicyDocumentException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_MalformedPolicyDocumentExceptionRes");
var de_NotFoundExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new NotFoundException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_NotFoundExceptionRes");
var de_TagExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new TagException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_TagExceptionRes");
var de_UnsupportedOperationExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new UnsupportedOperationException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_UnsupportedOperationExceptionRes");
var de_XksKeyAlreadyInUseExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new XksKeyAlreadyInUseException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_XksKeyAlreadyInUseExceptionRes");
var de_XksKeyInvalidConfigurationExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new XksKeyInvalidConfigurationException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_XksKeyInvalidConfigurationExceptionRes");
var de_XksKeyNotFoundExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new XksKeyNotFoundException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_XksKeyNotFoundExceptionRes");
var de_XksProxyIncorrectAuthenticationCredentialExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new XksProxyIncorrectAuthenticationCredentialException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_XksProxyIncorrectAuthenticationCredentialExceptionRes");
var de_XksProxyInvalidConfigurationExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new XksProxyInvalidConfigurationException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_XksProxyInvalidConfigurationExceptionRes");
var de_XksProxyInvalidResponseExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new XksProxyInvalidResponseException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_XksProxyInvalidResponseExceptionRes");
var de_XksProxyUriEndpointInUseExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new XksProxyUriEndpointInUseException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_XksProxyUriEndpointInUseExceptionRes");
var de_XksProxyUriInUseExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new XksProxyUriInUseException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_XksProxyUriInUseExceptionRes");
var de_XksProxyUriUnreachableExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new XksProxyUriUnreachableException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_XksProxyUriUnreachableExceptionRes");
var de_XksProxyVpcEndpointServiceInUseExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new XksProxyVpcEndpointServiceInUseException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_XksProxyVpcEndpointServiceInUseExceptionRes");
var de_XksProxyVpcEndpointServiceInvalidConfigurationExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new XksProxyVpcEndpointServiceInvalidConfigurationException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_XksProxyVpcEndpointServiceInvalidConfigurationExceptionRes");
var de_XksProxyVpcEndpointServiceNotFoundExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new XksProxyVpcEndpointServiceNotFoundException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_XksProxyVpcEndpointServiceNotFoundExceptionRes");
var se_DecryptRequest = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    CiphertextBlob: context.base64Encoder,
    DryRun: [],
    EncryptionAlgorithm: [],
    EncryptionContext: import_smithy_client._json,
    GrantTokens: import_smithy_client._json,
    KeyId: [],
    Recipient: /* @__PURE__ */ __name((_) => se_RecipientInfo(_, context), "Recipient")
  });
}, "se_DecryptRequest");
var se_DeriveSharedSecretRequest = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    DryRun: [],
    GrantTokens: import_smithy_client._json,
    KeyAgreementAlgorithm: [],
    KeyId: [],
    PublicKey: context.base64Encoder,
    Recipient: /* @__PURE__ */ __name((_) => se_RecipientInfo(_, context), "Recipient")
  });
}, "se_DeriveSharedSecretRequest");
var se_EncryptRequest = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    DryRun: [],
    EncryptionAlgorithm: [],
    EncryptionContext: import_smithy_client._json,
    GrantTokens: import_smithy_client._json,
    KeyId: [],
    Plaintext: context.base64Encoder
  });
}, "se_EncryptRequest");
var se_GenerateDataKeyPairRequest = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    DryRun: [],
    EncryptionContext: import_smithy_client._json,
    GrantTokens: import_smithy_client._json,
    KeyId: [],
    KeyPairSpec: [],
    Recipient: /* @__PURE__ */ __name((_) => se_RecipientInfo(_, context), "Recipient")
  });
}, "se_GenerateDataKeyPairRequest");
var se_GenerateDataKeyRequest = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    DryRun: [],
    EncryptionContext: import_smithy_client._json,
    GrantTokens: import_smithy_client._json,
    KeyId: [],
    KeySpec: [],
    NumberOfBytes: [],
    Recipient: /* @__PURE__ */ __name((_) => se_RecipientInfo(_, context), "Recipient")
  });
}, "se_GenerateDataKeyRequest");
var se_GenerateMacRequest = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    DryRun: [],
    GrantTokens: import_smithy_client._json,
    KeyId: [],
    MacAlgorithm: [],
    Message: context.base64Encoder
  });
}, "se_GenerateMacRequest");
var se_GenerateRandomRequest = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    CustomKeyStoreId: [],
    NumberOfBytes: [],
    Recipient: /* @__PURE__ */ __name((_) => se_RecipientInfo(_, context), "Recipient")
  });
}, "se_GenerateRandomRequest");
var se_ImportKeyMaterialRequest = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    EncryptedKeyMaterial: context.base64Encoder,
    ExpirationModel: [],
    ImportToken: context.base64Encoder,
    ImportType: [],
    KeyId: [],
    KeyMaterialDescription: [],
    KeyMaterialId: [],
    ValidTo: /* @__PURE__ */ __name((_) => _.getTime() / 1e3, "ValidTo")
  });
}, "se_ImportKeyMaterialRequest");
var se_RecipientInfo = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    AttestationDocument: context.base64Encoder,
    KeyEncryptionAlgorithm: []
  });
}, "se_RecipientInfo");
var se_ReEncryptRequest = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    CiphertextBlob: context.base64Encoder,
    DestinationEncryptionAlgorithm: [],
    DestinationEncryptionContext: import_smithy_client._json,
    DestinationKeyId: [],
    DryRun: [],
    GrantTokens: import_smithy_client._json,
    SourceEncryptionAlgorithm: [],
    SourceEncryptionContext: import_smithy_client._json,
    SourceKeyId: []
  });
}, "se_ReEncryptRequest");
var se_SignRequest = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    DryRun: [],
    GrantTokens: import_smithy_client._json,
    KeyId: [],
    Message: context.base64Encoder,
    MessageType: [],
    SigningAlgorithm: []
  });
}, "se_SignRequest");
var se_VerifyMacRequest = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    DryRun: [],
    GrantTokens: import_smithy_client._json,
    KeyId: [],
    Mac: context.base64Encoder,
    MacAlgorithm: [],
    Message: context.base64Encoder
  });
}, "se_VerifyMacRequest");
var se_VerifyRequest = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    DryRun: [],
    GrantTokens: import_smithy_client._json,
    KeyId: [],
    Message: context.base64Encoder,
    MessageType: [],
    Signature: context.base64Encoder,
    SigningAlgorithm: []
  });
}, "se_VerifyRequest");
var de_AliasList = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_AliasListEntry(entry, context);
  });
  return retVal;
}, "de_AliasList");
var de_AliasListEntry = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    AliasArn: import_smithy_client.expectString,
    AliasName: import_smithy_client.expectString,
    CreationDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "CreationDate"),
    LastUpdatedDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "LastUpdatedDate"),
    TargetKeyId: import_smithy_client.expectString
  });
}, "de_AliasListEntry");
var de_CreateKeyResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    KeyMetadata: /* @__PURE__ */ __name((_) => de_KeyMetadata(_, context), "KeyMetadata")
  });
}, "de_CreateKeyResponse");
var de_CustomKeyStoresList = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_CustomKeyStoresListEntry(entry, context);
  });
  return retVal;
}, "de_CustomKeyStoresList");
var de_CustomKeyStoresListEntry = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    CloudHsmClusterId: import_smithy_client.expectString,
    ConnectionErrorCode: import_smithy_client.expectString,
    ConnectionState: import_smithy_client.expectString,
    CreationDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "CreationDate"),
    CustomKeyStoreId: import_smithy_client.expectString,
    CustomKeyStoreName: import_smithy_client.expectString,
    CustomKeyStoreType: import_smithy_client.expectString,
    TrustAnchorCertificate: import_smithy_client.expectString,
    XksProxyConfiguration: import_smithy_client._json
  });
}, "de_CustomKeyStoresListEntry");
var de_DecryptResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    CiphertextForRecipient: context.base64Decoder,
    EncryptionAlgorithm: import_smithy_client.expectString,
    KeyId: import_smithy_client.expectString,
    KeyMaterialId: import_smithy_client.expectString,
    Plaintext: context.base64Decoder
  });
}, "de_DecryptResponse");
var de_DeriveSharedSecretResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    CiphertextForRecipient: context.base64Decoder,
    KeyAgreementAlgorithm: import_smithy_client.expectString,
    KeyId: import_smithy_client.expectString,
    KeyOrigin: import_smithy_client.expectString,
    SharedSecret: context.base64Decoder
  });
}, "de_DeriveSharedSecretResponse");
var de_DescribeCustomKeyStoresResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    CustomKeyStores: /* @__PURE__ */ __name((_) => de_CustomKeyStoresList(_, context), "CustomKeyStores"),
    NextMarker: import_smithy_client.expectString,
    Truncated: import_smithy_client.expectBoolean
  });
}, "de_DescribeCustomKeyStoresResponse");
var de_DescribeKeyResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    KeyMetadata: /* @__PURE__ */ __name((_) => de_KeyMetadata(_, context), "KeyMetadata")
  });
}, "de_DescribeKeyResponse");
var de_EncryptResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    CiphertextBlob: context.base64Decoder,
    EncryptionAlgorithm: import_smithy_client.expectString,
    KeyId: import_smithy_client.expectString
  });
}, "de_EncryptResponse");
var de_GenerateDataKeyPairResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    CiphertextForRecipient: context.base64Decoder,
    KeyId: import_smithy_client.expectString,
    KeyMaterialId: import_smithy_client.expectString,
    KeyPairSpec: import_smithy_client.expectString,
    PrivateKeyCiphertextBlob: context.base64Decoder,
    PrivateKeyPlaintext: context.base64Decoder,
    PublicKey: context.base64Decoder
  });
}, "de_GenerateDataKeyPairResponse");
var de_GenerateDataKeyPairWithoutPlaintextResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    KeyId: import_smithy_client.expectString,
    KeyMaterialId: import_smithy_client.expectString,
    KeyPairSpec: import_smithy_client.expectString,
    PrivateKeyCiphertextBlob: context.base64Decoder,
    PublicKey: context.base64Decoder
  });
}, "de_GenerateDataKeyPairWithoutPlaintextResponse");
var de_GenerateDataKeyResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    CiphertextBlob: context.base64Decoder,
    CiphertextForRecipient: context.base64Decoder,
    KeyId: import_smithy_client.expectString,
    KeyMaterialId: import_smithy_client.expectString,
    Plaintext: context.base64Decoder
  });
}, "de_GenerateDataKeyResponse");
var de_GenerateDataKeyWithoutPlaintextResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    CiphertextBlob: context.base64Decoder,
    KeyId: import_smithy_client.expectString,
    KeyMaterialId: import_smithy_client.expectString
  });
}, "de_GenerateDataKeyWithoutPlaintextResponse");
var de_GenerateMacResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    KeyId: import_smithy_client.expectString,
    Mac: context.base64Decoder,
    MacAlgorithm: import_smithy_client.expectString
  });
}, "de_GenerateMacResponse");
var de_GenerateRandomResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    CiphertextForRecipient: context.base64Decoder,
    Plaintext: context.base64Decoder
  });
}, "de_GenerateRandomResponse");
var de_GetKeyRotationStatusResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    KeyId: import_smithy_client.expectString,
    KeyRotationEnabled: import_smithy_client.expectBoolean,
    NextRotationDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "NextRotationDate"),
    OnDemandRotationStartDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "OnDemandRotationStartDate"),
    RotationPeriodInDays: import_smithy_client.expectInt32
  });
}, "de_GetKeyRotationStatusResponse");
var de_GetParametersForImportResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    ImportToken: context.base64Decoder,
    KeyId: import_smithy_client.expectString,
    ParametersValidTo: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "ParametersValidTo"),
    PublicKey: context.base64Decoder
  });
}, "de_GetParametersForImportResponse");
var de_GetPublicKeyResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    CustomerMasterKeySpec: import_smithy_client.expectString,
    EncryptionAlgorithms: import_smithy_client._json,
    KeyAgreementAlgorithms: import_smithy_client._json,
    KeyId: import_smithy_client.expectString,
    KeySpec: import_smithy_client.expectString,
    KeyUsage: import_smithy_client.expectString,
    PublicKey: context.base64Decoder,
    SigningAlgorithms: import_smithy_client._json
  });
}, "de_GetPublicKeyResponse");
var de_GrantList = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_GrantListEntry(entry, context);
  });
  return retVal;
}, "de_GrantList");
var de_GrantListEntry = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    Constraints: import_smithy_client._json,
    CreationDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "CreationDate"),
    GrantId: import_smithy_client.expectString,
    GranteePrincipal: import_smithy_client.expectString,
    IssuingAccount: import_smithy_client.expectString,
    KeyId: import_smithy_client.expectString,
    Name: import_smithy_client.expectString,
    Operations: import_smithy_client._json,
    RetiringPrincipal: import_smithy_client.expectString
  });
}, "de_GrantListEntry");
var de_KeyMetadata = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    AWSAccountId: import_smithy_client.expectString,
    Arn: import_smithy_client.expectString,
    CloudHsmClusterId: import_smithy_client.expectString,
    CreationDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "CreationDate"),
    CurrentKeyMaterialId: import_smithy_client.expectString,
    CustomKeyStoreId: import_smithy_client.expectString,
    CustomerMasterKeySpec: import_smithy_client.expectString,
    DeletionDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "DeletionDate"),
    Description: import_smithy_client.expectString,
    Enabled: import_smithy_client.expectBoolean,
    EncryptionAlgorithms: import_smithy_client._json,
    ExpirationModel: import_smithy_client.expectString,
    KeyAgreementAlgorithms: import_smithy_client._json,
    KeyId: import_smithy_client.expectString,
    KeyManager: import_smithy_client.expectString,
    KeySpec: import_smithy_client.expectString,
    KeyState: import_smithy_client.expectString,
    KeyUsage: import_smithy_client.expectString,
    MacAlgorithms: import_smithy_client._json,
    MultiRegion: import_smithy_client.expectBoolean,
    MultiRegionConfiguration: import_smithy_client._json,
    Origin: import_smithy_client.expectString,
    PendingDeletionWindowInDays: import_smithy_client.expectInt32,
    SigningAlgorithms: import_smithy_client._json,
    ValidTo: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "ValidTo"),
    XksKeyConfiguration: import_smithy_client._json
  });
}, "de_KeyMetadata");
var de_ListAliasesResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    Aliases: /* @__PURE__ */ __name((_) => de_AliasList(_, context), "Aliases"),
    NextMarker: import_smithy_client.expectString,
    Truncated: import_smithy_client.expectBoolean
  });
}, "de_ListAliasesResponse");
var de_ListGrantsResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    Grants: /* @__PURE__ */ __name((_) => de_GrantList(_, context), "Grants"),
    NextMarker: import_smithy_client.expectString,
    Truncated: import_smithy_client.expectBoolean
  });
}, "de_ListGrantsResponse");
var de_ListKeyRotationsResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    NextMarker: import_smithy_client.expectString,
    Rotations: /* @__PURE__ */ __name((_) => de_RotationsList(_, context), "Rotations"),
    Truncated: import_smithy_client.expectBoolean
  });
}, "de_ListKeyRotationsResponse");
var de_ReEncryptResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    CiphertextBlob: context.base64Decoder,
    DestinationEncryptionAlgorithm: import_smithy_client.expectString,
    DestinationKeyMaterialId: import_smithy_client.expectString,
    KeyId: import_smithy_client.expectString,
    SourceEncryptionAlgorithm: import_smithy_client.expectString,
    SourceKeyId: import_smithy_client.expectString,
    SourceKeyMaterialId: import_smithy_client.expectString
  });
}, "de_ReEncryptResponse");
var de_ReplicateKeyResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    ReplicaKeyMetadata: /* @__PURE__ */ __name((_) => de_KeyMetadata(_, context), "ReplicaKeyMetadata"),
    ReplicaPolicy: import_smithy_client.expectString,
    ReplicaTags: import_smithy_client._json
  });
}, "de_ReplicateKeyResponse");
var de_RotationsList = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_RotationsListEntry(entry, context);
  });
  return retVal;
}, "de_RotationsList");
var de_RotationsListEntry = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    ExpirationModel: import_smithy_client.expectString,
    ImportState: import_smithy_client.expectString,
    KeyId: import_smithy_client.expectString,
    KeyMaterialDescription: import_smithy_client.expectString,
    KeyMaterialId: import_smithy_client.expectString,
    KeyMaterialState: import_smithy_client.expectString,
    RotationDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "RotationDate"),
    RotationType: import_smithy_client.expectString,
    ValidTo: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "ValidTo")
  });
}, "de_RotationsListEntry");
var de_ScheduleKeyDeletionResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    DeletionDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "DeletionDate"),
    KeyId: import_smithy_client.expectString,
    KeyState: import_smithy_client.expectString,
    PendingWindowInDays: import_smithy_client.expectInt32
  });
}, "de_ScheduleKeyDeletionResponse");
var de_SignResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    KeyId: import_smithy_client.expectString,
    Signature: context.base64Decoder,
    SigningAlgorithm: import_smithy_client.expectString
  });
}, "de_SignResponse");
var deserializeMetadata = /* @__PURE__ */ __name((output) => ({
  httpStatusCode: output.statusCode,
  requestId: output.headers["x-amzn-requestid"] ?? output.headers["x-amzn-request-id"] ?? output.headers["x-amz-request-id"],
  extendedRequestId: output.headers["x-amz-id-2"],
  cfId: output.headers["x-amz-cf-id"]
}), "deserializeMetadata");
var throwDefaultError = (0, import_smithy_client.withBaseException)(KMSServiceException);
var buildHttpRpcRequest = /* @__PURE__ */ __name(async (context, headers, path, resolvedHostname, body) => {
  const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
  const contents = {
    protocol,
    hostname,
    port,
    method: "POST",
    path: basePath.endsWith("/") ? basePath.slice(0, -1) + path : basePath + path,
    headers
  };
  if (resolvedHostname !== void 0) {
    contents.hostname = resolvedHostname;
  }
  if (body !== void 0) {
    contents.body = body;
  }
  return new import_protocol_http.HttpRequest(contents);
}, "buildHttpRpcRequest");
function sharedHeaders(operation) {
  return {
    "content-type": "application/x-amz-json-1.1",
    "x-amz-target": `TrentService.${operation}`
  };
}
__name(sharedHeaders, "sharedHeaders");

// src/commands/CancelKeyDeletionCommand.ts
var CancelKeyDeletionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("TrentService", "CancelKeyDeletion", {}).n("KMSClient", "CancelKeyDeletionCommand").f(void 0, void 0).ser(se_CancelKeyDeletionCommand).de(de_CancelKeyDeletionCommand).build() {
  static {
    __name(this, "CancelKeyDeletionCommand");
  }
};

// src/commands/ConnectCustomKeyStoreCommand.ts



var ConnectCustomKeyStoreCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("TrentService", "ConnectCustomKeyStore", {}).n("KMSClient", "ConnectCustomKeyStoreCommand").f(void 0, void 0).ser(se_ConnectCustomKeyStoreCommand).de(de_ConnectCustomKeyStoreCommand).build() {
  static {
    __name(this, "ConnectCustomKeyStoreCommand");
  }
};

// src/commands/CreateAliasCommand.ts



var CreateAliasCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("TrentService", "CreateAlias", {}).n("KMSClient", "CreateAliasCommand").f(void 0, void 0).ser(se_CreateAliasCommand).de(de_CreateAliasCommand).build() {
  static {
    __name(this, "CreateAliasCommand");
  }
};

// src/commands/CreateCustomKeyStoreCommand.ts



var CreateCustomKeyStoreCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("TrentService", "CreateCustomKeyStore", {}).n("KMSClient", "CreateCustomKeyStoreCommand").f(CreateCustomKeyStoreRequestFilterSensitiveLog, void 0).ser(se_CreateCustomKeyStoreCommand).de(de_CreateCustomKeyStoreCommand).build() {
  static {
    __name(this, "CreateCustomKeyStoreCommand");
  }
};

// src/commands/CreateGrantCommand.ts



var CreateGrantCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("TrentService", "CreateGrant", {}).n("KMSClient", "CreateGrantCommand").f(void 0, void 0).ser(se_CreateGrantCommand).de(de_CreateGrantCommand).build() {
  static {
    __name(this, "CreateGrantCommand");
  }
};

// src/commands/CreateKeyCommand.ts



var CreateKeyCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("TrentService", "CreateKey", {}).n("KMSClient", "CreateKeyCommand").f(void 0, void 0).ser(se_CreateKeyCommand).de(de_CreateKeyCommand).build() {
  static {
    __name(this, "CreateKeyCommand");
  }
};

// src/commands/DecryptCommand.ts



var DecryptCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("TrentService", "Decrypt", {}).n("KMSClient", "DecryptCommand").f(void 0, DecryptResponseFilterSensitiveLog).ser(se_DecryptCommand).de(de_DecryptCommand).build() {
  static {
    __name(this, "DecryptCommand");
  }
};

// src/commands/DeleteAliasCommand.ts



var DeleteAliasCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("TrentService", "DeleteAlias", {}).n("KMSClient", "DeleteAliasCommand").f(void 0, void 0).ser(se_DeleteAliasCommand).de(de_DeleteAliasCommand).build() {
  static {
    __name(this, "DeleteAliasCommand");
  }
};

// src/commands/DeleteCustomKeyStoreCommand.ts



var DeleteCustomKeyStoreCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("TrentService", "DeleteCustomKeyStore", {}).n("KMSClient", "DeleteCustomKeyStoreCommand").f(void 0, void 0).ser(se_DeleteCustomKeyStoreCommand).de(de_DeleteCustomKeyStoreCommand).build() {
  static {
    __name(this, "DeleteCustomKeyStoreCommand");
  }
};

// src/commands/DeleteImportedKeyMaterialCommand.ts



var DeleteImportedKeyMaterialCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("TrentService", "DeleteImportedKeyMaterial", {}).n("KMSClient", "DeleteImportedKeyMaterialCommand").f(void 0, void 0).ser(se_DeleteImportedKeyMaterialCommand).de(de_DeleteImportedKeyMaterialCommand).build() {
  static {
    __name(this, "DeleteImportedKeyMaterialCommand");
  }
};

// src/commands/DeriveSharedSecretCommand.ts



var DeriveSharedSecretCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("TrentService", "DeriveSharedSecret", {}).n("KMSClient", "DeriveSharedSecretCommand").f(void 0, DeriveSharedSecretResponseFilterSensitiveLog).ser(se_DeriveSharedSecretCommand).de(de_DeriveSharedSecretCommand).build() {
  static {
    __name(this, "DeriveSharedSecretCommand");
  }
};

// src/commands/DescribeCustomKeyStoresCommand.ts



var DescribeCustomKeyStoresCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("TrentService", "DescribeCustomKeyStores", {}).n("KMSClient", "DescribeCustomKeyStoresCommand").f(void 0, DescribeCustomKeyStoresResponseFilterSensitiveLog).ser(se_DescribeCustomKeyStoresCommand).de(de_DescribeCustomKeyStoresCommand).build() {
  static {
    __name(this, "DescribeCustomKeyStoresCommand");
  }
};

// src/commands/DescribeKeyCommand.ts



var DescribeKeyCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("TrentService", "DescribeKey", {}).n("KMSClient", "DescribeKeyCommand").f(void 0, void 0).ser(se_DescribeKeyCommand).de(de_DescribeKeyCommand).build() {
  static {
    __name(this, "DescribeKeyCommand");
  }
};

// src/commands/DisableKeyCommand.ts



var DisableKeyCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("TrentService", "DisableKey", {}).n("KMSClient", "DisableKeyCommand").f(void 0, void 0).ser(se_DisableKeyCommand).de(de_DisableKeyCommand).build() {
  static {
    __name(this, "DisableKeyCommand");
  }
};

// src/commands/DisableKeyRotationCommand.ts



var DisableKeyRotationCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("TrentService", "DisableKeyRotation", {}).n("KMSClient", "DisableKeyRotationCommand").f(void 0, void 0).ser(se_DisableKeyRotationCommand).de(de_DisableKeyRotationCommand).build() {
  static {
    __name(this, "DisableKeyRotationCommand");
  }
};

// src/commands/DisconnectCustomKeyStoreCommand.ts



var DisconnectCustomKeyStoreCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("TrentService", "DisconnectCustomKeyStore", {}).n("KMSClient", "DisconnectCustomKeyStoreCommand").f(void 0, void 0).ser(se_DisconnectCustomKeyStoreCommand).de(de_DisconnectCustomKeyStoreCommand).build() {
  static {
    __name(this, "DisconnectCustomKeyStoreCommand");
  }
};

// src/commands/EnableKeyCommand.ts



var EnableKeyCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("TrentService", "EnableKey", {}).n("KMSClient", "EnableKeyCommand").f(void 0, void 0).ser(se_EnableKeyCommand).de(de_EnableKeyCommand).build() {
  static {
    __name(this, "EnableKeyCommand");
  }
};

// src/commands/EnableKeyRotationCommand.ts



var EnableKeyRotationCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("TrentService", "EnableKeyRotation", {}).n("KMSClient", "EnableKeyRotationCommand").f(void 0, void 0).ser(se_EnableKeyRotationCommand).de(de_EnableKeyRotationCommand).build() {
  static {
    __name(this, "EnableKeyRotationCommand");
  }
};

// src/commands/EncryptCommand.ts



var EncryptCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("TrentService", "Encrypt", {}).n("KMSClient", "EncryptCommand").f(EncryptRequestFilterSensitiveLog, void 0).ser(se_EncryptCommand).de(de_EncryptCommand).build() {
  static {
    __name(this, "EncryptCommand");
  }
};

// src/commands/GenerateDataKeyCommand.ts



var GenerateDataKeyCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("TrentService", "GenerateDataKey", {}).n("KMSClient", "GenerateDataKeyCommand").f(void 0, GenerateDataKeyResponseFilterSensitiveLog).ser(se_GenerateDataKeyCommand).de(de_GenerateDataKeyCommand).build() {
  static {
    __name(this, "GenerateDataKeyCommand");
  }
};

// src/commands/GenerateDataKeyPairCommand.ts



var GenerateDataKeyPairCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("TrentService", "GenerateDataKeyPair", {}).n("KMSClient", "GenerateDataKeyPairCommand").f(void 0, GenerateDataKeyPairResponseFilterSensitiveLog).ser(se_GenerateDataKeyPairCommand).de(de_GenerateDataKeyPairCommand).build() {
  static {
    __name(this, "GenerateDataKeyPairCommand");
  }
};

// src/commands/GenerateDataKeyPairWithoutPlaintextCommand.ts



var GenerateDataKeyPairWithoutPlaintextCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("TrentService", "GenerateDataKeyPairWithoutPlaintext", {}).n("KMSClient", "GenerateDataKeyPairWithoutPlaintextCommand").f(void 0, void 0).ser(se_GenerateDataKeyPairWithoutPlaintextCommand).de(de_GenerateDataKeyPairWithoutPlaintextCommand).build() {
  static {
    __name(this, "GenerateDataKeyPairWithoutPlaintextCommand");
  }
};

// src/commands/GenerateDataKeyWithoutPlaintextCommand.ts



var GenerateDataKeyWithoutPlaintextCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("TrentService", "GenerateDataKeyWithoutPlaintext", {}).n("KMSClient", "GenerateDataKeyWithoutPlaintextCommand").f(void 0, void 0).ser(se_GenerateDataKeyWithoutPlaintextCommand).de(de_GenerateDataKeyWithoutPlaintextCommand).build() {
  static {
    __name(this, "GenerateDataKeyWithoutPlaintextCommand");
  }
};

// src/commands/GenerateMacCommand.ts



var GenerateMacCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("TrentService", "GenerateMac", {}).n("KMSClient", "GenerateMacCommand").f(GenerateMacRequestFilterSensitiveLog, void 0).ser(se_GenerateMacCommand).de(de_GenerateMacCommand).build() {
  static {
    __name(this, "GenerateMacCommand");
  }
};

// src/commands/GenerateRandomCommand.ts



var GenerateRandomCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("TrentService", "GenerateRandom", {}).n("KMSClient", "GenerateRandomCommand").f(void 0, GenerateRandomResponseFilterSensitiveLog).ser(se_GenerateRandomCommand).de(de_GenerateRandomCommand).build() {
  static {
    __name(this, "GenerateRandomCommand");
  }
};

// src/commands/GetKeyPolicyCommand.ts



var GetKeyPolicyCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("TrentService", "GetKeyPolicy", {}).n("KMSClient", "GetKeyPolicyCommand").f(void 0, void 0).ser(se_GetKeyPolicyCommand).de(de_GetKeyPolicyCommand).build() {
  static {
    __name(this, "GetKeyPolicyCommand");
  }
};

// src/commands/GetKeyRotationStatusCommand.ts



var GetKeyRotationStatusCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("TrentService", "GetKeyRotationStatus", {}).n("KMSClient", "GetKeyRotationStatusCommand").f(void 0, void 0).ser(se_GetKeyRotationStatusCommand).de(de_GetKeyRotationStatusCommand).build() {
  static {
    __name(this, "GetKeyRotationStatusCommand");
  }
};

// src/commands/GetParametersForImportCommand.ts



var GetParametersForImportCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("TrentService", "GetParametersForImport", {}).n("KMSClient", "GetParametersForImportCommand").f(void 0, GetParametersForImportResponseFilterSensitiveLog).ser(se_GetParametersForImportCommand).de(de_GetParametersForImportCommand).build() {
  static {
    __name(this, "GetParametersForImportCommand");
  }
};

// src/commands/GetPublicKeyCommand.ts



var GetPublicKeyCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("TrentService", "GetPublicKey", {}).n("KMSClient", "GetPublicKeyCommand").f(void 0, void 0).ser(se_GetPublicKeyCommand).de(de_GetPublicKeyCommand).build() {
  static {
    __name(this, "GetPublicKeyCommand");
  }
};

// src/commands/ImportKeyMaterialCommand.ts



var ImportKeyMaterialCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("TrentService", "ImportKeyMaterial", {}).n("KMSClient", "ImportKeyMaterialCommand").f(void 0, void 0).ser(se_ImportKeyMaterialCommand).de(de_ImportKeyMaterialCommand).build() {
  static {
    __name(this, "ImportKeyMaterialCommand");
  }
};

// src/commands/ListAliasesCommand.ts



var ListAliasesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("TrentService", "ListAliases", {}).n("KMSClient", "ListAliasesCommand").f(void 0, void 0).ser(se_ListAliasesCommand).de(de_ListAliasesCommand).build() {
  static {
    __name(this, "ListAliasesCommand");
  }
};

// src/commands/ListGrantsCommand.ts



var ListGrantsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("TrentService", "ListGrants", {}).n("KMSClient", "ListGrantsCommand").f(void 0, void 0).ser(se_ListGrantsCommand).de(de_ListGrantsCommand).build() {
  static {
    __name(this, "ListGrantsCommand");
  }
};

// src/commands/ListKeyPoliciesCommand.ts



var ListKeyPoliciesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("TrentService", "ListKeyPolicies", {}).n("KMSClient", "ListKeyPoliciesCommand").f(void 0, void 0).ser(se_ListKeyPoliciesCommand).de(de_ListKeyPoliciesCommand).build() {
  static {
    __name(this, "ListKeyPoliciesCommand");
  }
};

// src/commands/ListKeyRotationsCommand.ts



var ListKeyRotationsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("TrentService", "ListKeyRotations", {}).n("KMSClient", "ListKeyRotationsCommand").f(void 0, void 0).ser(se_ListKeyRotationsCommand).de(de_ListKeyRotationsCommand).build() {
  static {
    __name(this, "ListKeyRotationsCommand");
  }
};

// src/commands/ListKeysCommand.ts



var ListKeysCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("TrentService", "ListKeys", {}).n("KMSClient", "ListKeysCommand").f(void 0, void 0).ser(se_ListKeysCommand).de(de_ListKeysCommand).build() {
  static {
    __name(this, "ListKeysCommand");
  }
};

// src/commands/ListResourceTagsCommand.ts



var ListResourceTagsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("TrentService", "ListResourceTags", {}).n("KMSClient", "ListResourceTagsCommand").f(void 0, void 0).ser(se_ListResourceTagsCommand).de(de_ListResourceTagsCommand).build() {
  static {
    __name(this, "ListResourceTagsCommand");
  }
};

// src/commands/ListRetirableGrantsCommand.ts



var ListRetirableGrantsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("TrentService", "ListRetirableGrants", {}).n("KMSClient", "ListRetirableGrantsCommand").f(void 0, void 0).ser(se_ListRetirableGrantsCommand).de(de_ListRetirableGrantsCommand).build() {
  static {
    __name(this, "ListRetirableGrantsCommand");
  }
};

// src/commands/PutKeyPolicyCommand.ts



var PutKeyPolicyCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("TrentService", "PutKeyPolicy", {}).n("KMSClient", "PutKeyPolicyCommand").f(void 0, void 0).ser(se_PutKeyPolicyCommand).de(de_PutKeyPolicyCommand).build() {
  static {
    __name(this, "PutKeyPolicyCommand");
  }
};

// src/commands/ReEncryptCommand.ts



var ReEncryptCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("TrentService", "ReEncrypt", {}).n("KMSClient", "ReEncryptCommand").f(void 0, void 0).ser(se_ReEncryptCommand).de(de_ReEncryptCommand).build() {
  static {
    __name(this, "ReEncryptCommand");
  }
};

// src/commands/ReplicateKeyCommand.ts



var ReplicateKeyCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("TrentService", "ReplicateKey", {}).n("KMSClient", "ReplicateKeyCommand").f(void 0, void 0).ser(se_ReplicateKeyCommand).de(de_ReplicateKeyCommand).build() {
  static {
    __name(this, "ReplicateKeyCommand");
  }
};

// src/commands/RetireGrantCommand.ts



var RetireGrantCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("TrentService", "RetireGrant", {}).n("KMSClient", "RetireGrantCommand").f(void 0, void 0).ser(se_RetireGrantCommand).de(de_RetireGrantCommand).build() {
  static {
    __name(this, "RetireGrantCommand");
  }
};

// src/commands/RevokeGrantCommand.ts



var RevokeGrantCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("TrentService", "RevokeGrant", {}).n("KMSClient", "RevokeGrantCommand").f(void 0, void 0).ser(se_RevokeGrantCommand).de(de_RevokeGrantCommand).build() {
  static {
    __name(this, "RevokeGrantCommand");
  }
};

// src/commands/RotateKeyOnDemandCommand.ts



var RotateKeyOnDemandCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("TrentService", "RotateKeyOnDemand", {}).n("KMSClient", "RotateKeyOnDemandCommand").f(void 0, void 0).ser(se_RotateKeyOnDemandCommand).de(de_RotateKeyOnDemandCommand).build() {
  static {
    __name(this, "RotateKeyOnDemandCommand");
  }
};

// src/commands/ScheduleKeyDeletionCommand.ts



var ScheduleKeyDeletionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("TrentService", "ScheduleKeyDeletion", {}).n("KMSClient", "ScheduleKeyDeletionCommand").f(void 0, void 0).ser(se_ScheduleKeyDeletionCommand).de(de_ScheduleKeyDeletionCommand).build() {
  static {
    __name(this, "ScheduleKeyDeletionCommand");
  }
};

// src/commands/SignCommand.ts



var SignCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("TrentService", "Sign", {}).n("KMSClient", "SignCommand").f(SignRequestFilterSensitiveLog, void 0).ser(se_SignCommand).de(de_SignCommand).build() {
  static {
    __name(this, "SignCommand");
  }
};

// src/commands/TagResourceCommand.ts



var TagResourceCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("TrentService", "TagResource", {}).n("KMSClient", "TagResourceCommand").f(void 0, void 0).ser(se_TagResourceCommand).de(de_TagResourceCommand).build() {
  static {
    __name(this, "TagResourceCommand");
  }
};

// src/commands/UntagResourceCommand.ts



var UntagResourceCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("TrentService", "UntagResource", {}).n("KMSClient", "UntagResourceCommand").f(void 0, void 0).ser(se_UntagResourceCommand).de(de_UntagResourceCommand).build() {
  static {
    __name(this, "UntagResourceCommand");
  }
};

// src/commands/UpdateAliasCommand.ts



var UpdateAliasCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("TrentService", "UpdateAlias", {}).n("KMSClient", "UpdateAliasCommand").f(void 0, void 0).ser(se_UpdateAliasCommand).de(de_UpdateAliasCommand).build() {
  static {
    __name(this, "UpdateAliasCommand");
  }
};

// src/commands/UpdateCustomKeyStoreCommand.ts



var UpdateCustomKeyStoreCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("TrentService", "UpdateCustomKeyStore", {}).n("KMSClient", "UpdateCustomKeyStoreCommand").f(UpdateCustomKeyStoreRequestFilterSensitiveLog, void 0).ser(se_UpdateCustomKeyStoreCommand).de(de_UpdateCustomKeyStoreCommand).build() {
  static {
    __name(this, "UpdateCustomKeyStoreCommand");
  }
};

// src/commands/UpdateKeyDescriptionCommand.ts



var UpdateKeyDescriptionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("TrentService", "UpdateKeyDescription", {}).n("KMSClient", "UpdateKeyDescriptionCommand").f(void 0, void 0).ser(se_UpdateKeyDescriptionCommand).de(de_UpdateKeyDescriptionCommand).build() {
  static {
    __name(this, "UpdateKeyDescriptionCommand");
  }
};

// src/commands/UpdatePrimaryRegionCommand.ts



var UpdatePrimaryRegionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("TrentService", "UpdatePrimaryRegion", {}).n("KMSClient", "UpdatePrimaryRegionCommand").f(void 0, void 0).ser(se_UpdatePrimaryRegionCommand).de(de_UpdatePrimaryRegionCommand).build() {
  static {
    __name(this, "UpdatePrimaryRegionCommand");
  }
};

// src/commands/VerifyCommand.ts



var VerifyCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("TrentService", "Verify", {}).n("KMSClient", "VerifyCommand").f(VerifyRequestFilterSensitiveLog, void 0).ser(se_VerifyCommand).de(de_VerifyCommand).build() {
  static {
    __name(this, "VerifyCommand");
  }
};

// src/commands/VerifyMacCommand.ts



var VerifyMacCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("TrentService", "VerifyMac", {}).n("KMSClient", "VerifyMacCommand").f(VerifyMacRequestFilterSensitiveLog, void 0).ser(se_VerifyMacCommand).de(de_VerifyMacCommand).build() {
  static {
    __name(this, "VerifyMacCommand");
  }
};

// src/KMS.ts
var commands = {
  CancelKeyDeletionCommand,
  ConnectCustomKeyStoreCommand,
  CreateAliasCommand,
  CreateCustomKeyStoreCommand,
  CreateGrantCommand,
  CreateKeyCommand,
  DecryptCommand,
  DeleteAliasCommand,
  DeleteCustomKeyStoreCommand,
  DeleteImportedKeyMaterialCommand,
  DeriveSharedSecretCommand,
  DescribeCustomKeyStoresCommand,
  DescribeKeyCommand,
  DisableKeyCommand,
  DisableKeyRotationCommand,
  DisconnectCustomKeyStoreCommand,
  EnableKeyCommand,
  EnableKeyRotationCommand,
  EncryptCommand,
  GenerateDataKeyCommand,
  GenerateDataKeyPairCommand,
  GenerateDataKeyPairWithoutPlaintextCommand,
  GenerateDataKeyWithoutPlaintextCommand,
  GenerateMacCommand,
  GenerateRandomCommand,
  GetKeyPolicyCommand,
  GetKeyRotationStatusCommand,
  GetParametersForImportCommand,
  GetPublicKeyCommand,
  ImportKeyMaterialCommand,
  ListAliasesCommand,
  ListGrantsCommand,
  ListKeyPoliciesCommand,
  ListKeyRotationsCommand,
  ListKeysCommand,
  ListResourceTagsCommand,
  ListRetirableGrantsCommand,
  PutKeyPolicyCommand,
  ReEncryptCommand,
  ReplicateKeyCommand,
  RetireGrantCommand,
  RevokeGrantCommand,
  RotateKeyOnDemandCommand,
  ScheduleKeyDeletionCommand,
  SignCommand,
  TagResourceCommand,
  UntagResourceCommand,
  UpdateAliasCommand,
  UpdateCustomKeyStoreCommand,
  UpdateKeyDescriptionCommand,
  UpdatePrimaryRegionCommand,
  VerifyCommand,
  VerifyMacCommand
};
var KMS = class extends KMSClient {
  static {
    __name(this, "KMS");
  }
};
(0, import_smithy_client.createAggregatedClient)(commands, KMS);

// src/pagination/DescribeCustomKeyStoresPaginator.ts

var paginateDescribeCustomKeyStores = (0, import_core.createPaginator)(KMSClient, DescribeCustomKeyStoresCommand, "Marker", "NextMarker", "Limit");

// src/pagination/ListAliasesPaginator.ts

var paginateListAliases = (0, import_core.createPaginator)(KMSClient, ListAliasesCommand, "Marker", "NextMarker", "Limit");

// src/pagination/ListGrantsPaginator.ts

var paginateListGrants = (0, import_core.createPaginator)(KMSClient, ListGrantsCommand, "Marker", "NextMarker", "Limit");

// src/pagination/ListKeyPoliciesPaginator.ts

var paginateListKeyPolicies = (0, import_core.createPaginator)(KMSClient, ListKeyPoliciesCommand, "Marker", "NextMarker", "Limit");

// src/pagination/ListKeyRotationsPaginator.ts

var paginateListKeyRotations = (0, import_core.createPaginator)(KMSClient, ListKeyRotationsCommand, "Marker", "NextMarker", "Limit");

// src/pagination/ListKeysPaginator.ts

var paginateListKeys = (0, import_core.createPaginator)(KMSClient, ListKeysCommand, "Marker", "NextMarker", "Limit");

// src/pagination/ListResourceTagsPaginator.ts

var paginateListResourceTags = (0, import_core.createPaginator)(KMSClient, ListResourceTagsCommand, "Marker", "NextMarker", "Limit");

// src/pagination/ListRetirableGrantsPaginator.ts

var paginateListRetirableGrants = (0, import_core.createPaginator)(KMSClient, ListRetirableGrantsCommand, "Marker", "NextMarker", "Limit");
// Annotate the CommonJS export names for ESM import in node:

0 && (module.exports = {
  KMSServiceException,
  __Client,
  KMSClient,
  KMS,
  $Command,
  CancelKeyDeletionCommand,
  ConnectCustomKeyStoreCommand,
  CreateAliasCommand,
  CreateCustomKeyStoreCommand,
  CreateGrantCommand,
  CreateKeyCommand,
  DecryptCommand,
  DeleteAliasCommand,
  DeleteCustomKeyStoreCommand,
  DeleteImportedKeyMaterialCommand,
  DeriveSharedSecretCommand,
  DescribeCustomKeyStoresCommand,
  DescribeKeyCommand,
  DisableKeyCommand,
  DisableKeyRotationCommand,
  DisconnectCustomKeyStoreCommand,
  EnableKeyCommand,
  EnableKeyRotationCommand,
  EncryptCommand,
  GenerateDataKeyCommand,
  GenerateDataKeyPairCommand,
  GenerateDataKeyPairWithoutPlaintextCommand,
  GenerateDataKeyWithoutPlaintextCommand,
  GenerateMacCommand,
  GenerateRandomCommand,
  GetKeyPolicyCommand,
  GetKeyRotationStatusCommand,
  GetParametersForImportCommand,
  GetPublicKeyCommand,
  ImportKeyMaterialCommand,
  ListAliasesCommand,
  ListGrantsCommand,
  ListKeyPoliciesCommand,
  ListKeyRotationsCommand,
  ListKeysCommand,
  ListResourceTagsCommand,
  ListRetirableGrantsCommand,
  PutKeyPolicyCommand,
  ReEncryptCommand,
  ReplicateKeyCommand,
  RetireGrantCommand,
  RevokeGrantCommand,
  RotateKeyOnDemandCommand,
  ScheduleKeyDeletionCommand,
  SignCommand,
  TagResourceCommand,
  UntagResourceCommand,
  UpdateAliasCommand,
  UpdateCustomKeyStoreCommand,
  UpdateKeyDescriptionCommand,
  UpdatePrimaryRegionCommand,
  VerifyCommand,
  VerifyMacCommand,
  paginateDescribeCustomKeyStores,
  paginateListAliases,
  paginateListGrants,
  paginateListKeyPolicies,
  paginateListKeyRotations,
  paginateListKeys,
  paginateListResourceTags,
  paginateListRetirableGrants,
  AlgorithmSpec,
  AlreadyExistsException,
  DependencyTimeoutException,
  InvalidArnException,
  KMSInternalException,
  KMSInvalidStateException,
  NotFoundException,
  CloudHsmClusterInUseException,
  CloudHsmClusterInvalidConfigurationException,
  CloudHsmClusterNotActiveException,
  CloudHsmClusterNotFoundException,
  CloudHsmClusterNotRelatedException,
  ConflictException,
  CustomKeyStoreInvalidStateException,
  CustomKeyStoreNotFoundException,
  ConnectionErrorCodeType,
  ConnectionStateType,
  InvalidAliasNameException,
  LimitExceededException,
  CustomKeyStoreType,
  XksProxyConnectivityType,
  CustomKeyStoreNameInUseException,
  IncorrectTrustAnchorException,
  XksProxyIncorrectAuthenticationCredentialException,
  XksProxyInvalidConfigurationException,
  XksProxyInvalidResponseException,
  XksProxyUriEndpointInUseException,
  XksProxyUriInUseException,
  XksProxyUriUnreachableException,
  XksProxyVpcEndpointServiceInUseException,
  XksProxyVpcEndpointServiceInvalidConfigurationException,
  XksProxyVpcEndpointServiceNotFoundException,
  GrantOperation,
  DisabledException,
  DryRunOperationException,
  InvalidGrantTokenException,
  CustomerMasterKeySpec,
  KeySpec,
  KeyUsageType,
  OriginType,
  EncryptionAlgorithmSpec,
  ExpirationModelType,
  KeyAgreementAlgorithmSpec,
  KeyManagerType,
  KeyState,
  MacAlgorithmSpec,
  MultiRegionKeyType,
  SigningAlgorithmSpec,
  MalformedPolicyDocumentException,
  TagException,
  UnsupportedOperationException,
  XksKeyAlreadyInUseException,
  XksKeyInvalidConfigurationException,
  XksKeyNotFoundException,
  CustomKeyStoreHasCMKsException,
  DataKeyPairSpec,
  DataKeySpec,
  KeyEncryptionMechanism,
  IncorrectKeyException,
  InvalidCiphertextException,
  InvalidKeyUsageException,
  KeyUnavailableException,
  InvalidMarkerException,
  ExpiredImportTokenException,
  WrappingKeySpec,
  ImportType,
  IncorrectKeyMaterialException,
  InvalidImportTokenException,
  ImportState,
  IncludeKeyMaterial,
  InvalidGrantIdException,
  KeyMaterialState,
  KMSInvalidMacException,
  KMSInvalidSignatureException,
  RotationType,
  MessageType,
  XksProxyAuthenticationCredentialTypeFilterSensitiveLog,
  CreateCustomKeyStoreRequestFilterSensitiveLog,
  XksProxyConfigurationTypeFilterSensitiveLog,
  CustomKeyStoresListEntryFilterSensitiveLog,
  DecryptResponseFilterSensitiveLog,
  DeriveSharedSecretResponseFilterSensitiveLog,
  DescribeCustomKeyStoresResponseFilterSensitiveLog,
  EncryptRequestFilterSensitiveLog,
  GenerateDataKeyResponseFilterSensitiveLog,
  GenerateDataKeyPairResponseFilterSensitiveLog,
  GenerateMacRequestFilterSensitiveLog,
  GenerateRandomResponseFilterSensitiveLog,
  GetParametersForImportResponseFilterSensitiveLog,
  SignRequestFilterSensitiveLog,
  UpdateCustomKeyStoreRequestFilterSensitiveLog,
  VerifyRequestFilterSensitiveLog,
  VerifyMacRequestFilterSensitiveLog
});

