import { ExceptionOptionType as __ExceptionOptionType } from "@smithy/smithy-client";
import { KMSServiceException as __BaseException } from "./KMSServiceException";
export declare const AlgorithmSpec: {
  readonly RSAES_OAEP_SHA_1: "RSAES_OAEP_SHA_1";
  readonly RSAES_OAEP_SHA_256: "RSAES_OAEP_SHA_256";
  readonly RSAES_PKCS1_V1_5: "RSAES_PKCS1_V1_5";
  readonly RSA_AES_KEY_WRAP_SHA_1: "RSA_AES_KEY_WRAP_SHA_1";
  readonly RSA_AES_KEY_WRAP_SHA_256: "RSA_AES_KEY_WRAP_SHA_256";
  readonly SM2PKE: "SM2PKE";
};
export type AlgorithmSpec = (typeof AlgorithmSpec)[keyof typeof AlgorithmSpec];
export interface AliasListEntry {
  AliasName?: string | undefined;
  AliasArn?: string | undefined;
  TargetKeyId?: string | undefined;
  CreationDate?: Date | undefined;
  LastUpdatedDate?: Date | undefined;
}
export declare class AlreadyExistsException extends __BaseException {
  readonly name: "AlreadyExistsException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<AlreadyExistsException, __BaseException>
  );
}
export interface CancelKeyDeletionRequest {
  KeyId: string | undefined;
}
export interface CancelKeyDeletionResponse {
  KeyId?: string | undefined;
}
export declare class DependencyTimeoutException extends __BaseException {
  readonly name: "DependencyTimeoutException";
  readonly $fault: "server";
  constructor(
    opts: __ExceptionOptionType<DependencyTimeoutException, __BaseException>
  );
}
export declare class InvalidArnException extends __BaseException {
  readonly name: "InvalidArnException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidArnException, __BaseException>
  );
}
export declare class KMSInternalException extends __BaseException {
  readonly name: "KMSInternalException";
  readonly $fault: "server";
  constructor(
    opts: __ExceptionOptionType<KMSInternalException, __BaseException>
  );
}
export declare class KMSInvalidStateException extends __BaseException {
  readonly name: "KMSInvalidStateException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<KMSInvalidStateException, __BaseException>
  );
}
export declare class NotFoundException extends __BaseException {
  readonly name: "NotFoundException";
  readonly $fault: "client";
  constructor(opts: __ExceptionOptionType<NotFoundException, __BaseException>);
}
export declare class CloudHsmClusterInUseException extends __BaseException {
  readonly name: "CloudHsmClusterInUseException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<CloudHsmClusterInUseException, __BaseException>
  );
}
export declare class CloudHsmClusterInvalidConfigurationException extends __BaseException {
  readonly name: "CloudHsmClusterInvalidConfigurationException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      CloudHsmClusterInvalidConfigurationException,
      __BaseException
    >
  );
}
export declare class CloudHsmClusterNotActiveException extends __BaseException {
  readonly name: "CloudHsmClusterNotActiveException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      CloudHsmClusterNotActiveException,
      __BaseException
    >
  );
}
export declare class CloudHsmClusterNotFoundException extends __BaseException {
  readonly name: "CloudHsmClusterNotFoundException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      CloudHsmClusterNotFoundException,
      __BaseException
    >
  );
}
export declare class CloudHsmClusterNotRelatedException extends __BaseException {
  readonly name: "CloudHsmClusterNotRelatedException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      CloudHsmClusterNotRelatedException,
      __BaseException
    >
  );
}
export declare class ConflictException extends __BaseException {
  readonly name: "ConflictException";
  readonly $fault: "client";
  constructor(opts: __ExceptionOptionType<ConflictException, __BaseException>);
}
export interface ConnectCustomKeyStoreRequest {
  CustomKeyStoreId: string | undefined;
}
export interface ConnectCustomKeyStoreResponse {}
export declare class CustomKeyStoreInvalidStateException extends __BaseException {
  readonly name: "CustomKeyStoreInvalidStateException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      CustomKeyStoreInvalidStateException,
      __BaseException
    >
  );
}
export declare class CustomKeyStoreNotFoundException extends __BaseException {
  readonly name: "CustomKeyStoreNotFoundException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      CustomKeyStoreNotFoundException,
      __BaseException
    >
  );
}
export declare const ConnectionErrorCodeType: {
  readonly CLUSTER_NOT_FOUND: "CLUSTER_NOT_FOUND";
  readonly INSUFFICIENT_CLOUDHSM_HSMS: "INSUFFICIENT_CLOUDHSM_HSMS";
  readonly INSUFFICIENT_FREE_ADDRESSES_IN_SUBNET: "INSUFFICIENT_FREE_ADDRESSES_IN_SUBNET";
  readonly INTERNAL_ERROR: "INTERNAL_ERROR";
  readonly INVALID_CREDENTIALS: "INVALID_CREDENTIALS";
  readonly NETWORK_ERRORS: "NETWORK_ERRORS";
  readonly SUBNET_NOT_FOUND: "SUBNET_NOT_FOUND";
  readonly USER_LOCKED_OUT: "USER_LOCKED_OUT";
  readonly USER_LOGGED_IN: "USER_LOGGED_IN";
  readonly USER_NOT_FOUND: "USER_NOT_FOUND";
  readonly XKS_PROXY_ACCESS_DENIED: "XKS_PROXY_ACCESS_DENIED";
  readonly XKS_PROXY_INVALID_CONFIGURATION: "XKS_PROXY_INVALID_CONFIGURATION";
  readonly XKS_PROXY_INVALID_RESPONSE: "XKS_PROXY_INVALID_RESPONSE";
  readonly XKS_PROXY_INVALID_TLS_CONFIGURATION: "XKS_PROXY_INVALID_TLS_CONFIGURATION";
  readonly XKS_PROXY_NOT_REACHABLE: "XKS_PROXY_NOT_REACHABLE";
  readonly XKS_PROXY_TIMED_OUT: "XKS_PROXY_TIMED_OUT";
  readonly XKS_VPC_ENDPOINT_SERVICE_INVALID_CONFIGURATION: "XKS_VPC_ENDPOINT_SERVICE_INVALID_CONFIGURATION";
  readonly XKS_VPC_ENDPOINT_SERVICE_NOT_FOUND: "XKS_VPC_ENDPOINT_SERVICE_NOT_FOUND";
};
export type ConnectionErrorCodeType =
  (typeof ConnectionErrorCodeType)[keyof typeof ConnectionErrorCodeType];
export declare const ConnectionStateType: {
  readonly CONNECTED: "CONNECTED";
  readonly CONNECTING: "CONNECTING";
  readonly DISCONNECTED: "DISCONNECTED";
  readonly DISCONNECTING: "DISCONNECTING";
  readonly FAILED: "FAILED";
};
export type ConnectionStateType =
  (typeof ConnectionStateType)[keyof typeof ConnectionStateType];
export interface CreateAliasRequest {
  AliasName: string | undefined;
  TargetKeyId: string | undefined;
}
export declare class InvalidAliasNameException extends __BaseException {
  readonly name: "InvalidAliasNameException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidAliasNameException, __BaseException>
  );
}
export declare class LimitExceededException extends __BaseException {
  readonly name: "LimitExceededException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<LimitExceededException, __BaseException>
  );
}
export declare const CustomKeyStoreType: {
  readonly AWS_CLOUDHSM: "AWS_CLOUDHSM";
  readonly EXTERNAL_KEY_STORE: "EXTERNAL_KEY_STORE";
};
export type CustomKeyStoreType =
  (typeof CustomKeyStoreType)[keyof typeof CustomKeyStoreType];
export interface XksProxyAuthenticationCredentialType {
  AccessKeyId: string | undefined;
  RawSecretAccessKey: string | undefined;
}
export declare const XksProxyConnectivityType: {
  readonly PUBLIC_ENDPOINT: "PUBLIC_ENDPOINT";
  readonly VPC_ENDPOINT_SERVICE: "VPC_ENDPOINT_SERVICE";
};
export type XksProxyConnectivityType =
  (typeof XksProxyConnectivityType)[keyof typeof XksProxyConnectivityType];
export interface CreateCustomKeyStoreRequest {
  CustomKeyStoreName: string | undefined;
  CloudHsmClusterId?: string | undefined;
  TrustAnchorCertificate?: string | undefined;
  KeyStorePassword?: string | undefined;
  CustomKeyStoreType?: CustomKeyStoreType | undefined;
  XksProxyUriEndpoint?: string | undefined;
  XksProxyUriPath?: string | undefined;
  XksProxyVpcEndpointServiceName?: string | undefined;
  XksProxyAuthenticationCredential?:
    | XksProxyAuthenticationCredentialType
    | undefined;
  XksProxyConnectivity?: XksProxyConnectivityType | undefined;
}
export interface CreateCustomKeyStoreResponse {
  CustomKeyStoreId?: string | undefined;
}
export declare class CustomKeyStoreNameInUseException extends __BaseException {
  readonly name: "CustomKeyStoreNameInUseException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      CustomKeyStoreNameInUseException,
      __BaseException
    >
  );
}
export declare class IncorrectTrustAnchorException extends __BaseException {
  readonly name: "IncorrectTrustAnchorException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<IncorrectTrustAnchorException, __BaseException>
  );
}
export declare class XksProxyIncorrectAuthenticationCredentialException extends __BaseException {
  readonly name: "XksProxyIncorrectAuthenticationCredentialException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      XksProxyIncorrectAuthenticationCredentialException,
      __BaseException
    >
  );
}
export declare class XksProxyInvalidConfigurationException extends __BaseException {
  readonly name: "XksProxyInvalidConfigurationException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      XksProxyInvalidConfigurationException,
      __BaseException
    >
  );
}
export declare class XksProxyInvalidResponseException extends __BaseException {
  readonly name: "XksProxyInvalidResponseException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      XksProxyInvalidResponseException,
      __BaseException
    >
  );
}
export declare class XksProxyUriEndpointInUseException extends __BaseException {
  readonly name: "XksProxyUriEndpointInUseException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      XksProxyUriEndpointInUseException,
      __BaseException
    >
  );
}
export declare class XksProxyUriInUseException extends __BaseException {
  readonly name: "XksProxyUriInUseException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<XksProxyUriInUseException, __BaseException>
  );
}
export declare class XksProxyUriUnreachableException extends __BaseException {
  readonly name: "XksProxyUriUnreachableException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      XksProxyUriUnreachableException,
      __BaseException
    >
  );
}
export declare class XksProxyVpcEndpointServiceInUseException extends __BaseException {
  readonly name: "XksProxyVpcEndpointServiceInUseException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      XksProxyVpcEndpointServiceInUseException,
      __BaseException
    >
  );
}
export declare class XksProxyVpcEndpointServiceInvalidConfigurationException extends __BaseException {
  readonly name: "XksProxyVpcEndpointServiceInvalidConfigurationException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      XksProxyVpcEndpointServiceInvalidConfigurationException,
      __BaseException
    >
  );
}
export declare class XksProxyVpcEndpointServiceNotFoundException extends __BaseException {
  readonly name: "XksProxyVpcEndpointServiceNotFoundException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      XksProxyVpcEndpointServiceNotFoundException,
      __BaseException
    >
  );
}
export interface GrantConstraints {
  EncryptionContextSubset?: Record<string, string> | undefined;
  EncryptionContextEquals?: Record<string, string> | undefined;
}
export declare const GrantOperation: {
  readonly CreateGrant: "CreateGrant";
  readonly Decrypt: "Decrypt";
  readonly DeriveSharedSecret: "DeriveSharedSecret";
  readonly DescribeKey: "DescribeKey";
  readonly Encrypt: "Encrypt";
  readonly GenerateDataKey: "GenerateDataKey";
  readonly GenerateDataKeyPair: "GenerateDataKeyPair";
  readonly GenerateDataKeyPairWithoutPlaintext: "GenerateDataKeyPairWithoutPlaintext";
  readonly GenerateDataKeyWithoutPlaintext: "GenerateDataKeyWithoutPlaintext";
  readonly GenerateMac: "GenerateMac";
  readonly GetPublicKey: "GetPublicKey";
  readonly ReEncryptFrom: "ReEncryptFrom";
  readonly ReEncryptTo: "ReEncryptTo";
  readonly RetireGrant: "RetireGrant";
  readonly Sign: "Sign";
  readonly Verify: "Verify";
  readonly VerifyMac: "VerifyMac";
};
export type GrantOperation =
  (typeof GrantOperation)[keyof typeof GrantOperation];
export interface CreateGrantRequest {
  KeyId: string | undefined;
  GranteePrincipal: string | undefined;
  RetiringPrincipal?: string | undefined;
  Operations: GrantOperation[] | undefined;
  Constraints?: GrantConstraints | undefined;
  GrantTokens?: string[] | undefined;
  Name?: string | undefined;
  DryRun?: boolean | undefined;
}
export interface CreateGrantResponse {
  GrantToken?: string | undefined;
  GrantId?: string | undefined;
}
export declare class DisabledException extends __BaseException {
  readonly name: "DisabledException";
  readonly $fault: "client";
  constructor(opts: __ExceptionOptionType<DisabledException, __BaseException>);
}
export declare class DryRunOperationException extends __BaseException {
  readonly name: "DryRunOperationException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<DryRunOperationException, __BaseException>
  );
}
export declare class InvalidGrantTokenException extends __BaseException {
  readonly name: "InvalidGrantTokenException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidGrantTokenException, __BaseException>
  );
}
export declare const CustomerMasterKeySpec: {
  readonly ECC_NIST_P256: "ECC_NIST_P256";
  readonly ECC_NIST_P384: "ECC_NIST_P384";
  readonly ECC_NIST_P521: "ECC_NIST_P521";
  readonly ECC_SECG_P256K1: "ECC_SECG_P256K1";
  readonly HMAC_224: "HMAC_224";
  readonly HMAC_256: "HMAC_256";
  readonly HMAC_384: "HMAC_384";
  readonly HMAC_512: "HMAC_512";
  readonly RSA_2048: "RSA_2048";
  readonly RSA_3072: "RSA_3072";
  readonly RSA_4096: "RSA_4096";
  readonly SM2: "SM2";
  readonly SYMMETRIC_DEFAULT: "SYMMETRIC_DEFAULT";
};
export type CustomerMasterKeySpec =
  (typeof CustomerMasterKeySpec)[keyof typeof CustomerMasterKeySpec];
export declare const KeySpec: {
  readonly ECC_NIST_P256: "ECC_NIST_P256";
  readonly ECC_NIST_P384: "ECC_NIST_P384";
  readonly ECC_NIST_P521: "ECC_NIST_P521";
  readonly ECC_SECG_P256K1: "ECC_SECG_P256K1";
  readonly HMAC_224: "HMAC_224";
  readonly HMAC_256: "HMAC_256";
  readonly HMAC_384: "HMAC_384";
  readonly HMAC_512: "HMAC_512";
  readonly ML_DSA_44: "ML_DSA_44";
  readonly ML_DSA_65: "ML_DSA_65";
  readonly ML_DSA_87: "ML_DSA_87";
  readonly RSA_2048: "RSA_2048";
  readonly RSA_3072: "RSA_3072";
  readonly RSA_4096: "RSA_4096";
  readonly SM2: "SM2";
  readonly SYMMETRIC_DEFAULT: "SYMMETRIC_DEFAULT";
};
export type KeySpec = (typeof KeySpec)[keyof typeof KeySpec];
export declare const KeyUsageType: {
  readonly ENCRYPT_DECRYPT: "ENCRYPT_DECRYPT";
  readonly GENERATE_VERIFY_MAC: "GENERATE_VERIFY_MAC";
  readonly KEY_AGREEMENT: "KEY_AGREEMENT";
  readonly SIGN_VERIFY: "SIGN_VERIFY";
};
export type KeyUsageType = (typeof KeyUsageType)[keyof typeof KeyUsageType];
export declare const OriginType: {
  readonly AWS_CLOUDHSM: "AWS_CLOUDHSM";
  readonly AWS_KMS: "AWS_KMS";
  readonly EXTERNAL: "EXTERNAL";
  readonly EXTERNAL_KEY_STORE: "EXTERNAL_KEY_STORE";
};
export type OriginType = (typeof OriginType)[keyof typeof OriginType];
export interface Tag {
  TagKey: string | undefined;
  TagValue: string | undefined;
}
export interface CreateKeyRequest {
  Policy?: string | undefined;
  Description?: string | undefined;
  KeyUsage?: KeyUsageType | undefined;
  CustomerMasterKeySpec?: CustomerMasterKeySpec | undefined;
  KeySpec?: KeySpec | undefined;
  Origin?: OriginType | undefined;
  CustomKeyStoreId?: string | undefined;
  BypassPolicyLockoutSafetyCheck?: boolean | undefined;
  Tags?: Tag[] | undefined;
  MultiRegion?: boolean | undefined;
  XksKeyId?: string | undefined;
}
export declare const EncryptionAlgorithmSpec: {
  readonly RSAES_OAEP_SHA_1: "RSAES_OAEP_SHA_1";
  readonly RSAES_OAEP_SHA_256: "RSAES_OAEP_SHA_256";
  readonly SM2PKE: "SM2PKE";
  readonly SYMMETRIC_DEFAULT: "SYMMETRIC_DEFAULT";
};
export type EncryptionAlgorithmSpec =
  (typeof EncryptionAlgorithmSpec)[keyof typeof EncryptionAlgorithmSpec];
export declare const ExpirationModelType: {
  readonly KEY_MATERIAL_DOES_NOT_EXPIRE: "KEY_MATERIAL_DOES_NOT_EXPIRE";
  readonly KEY_MATERIAL_EXPIRES: "KEY_MATERIAL_EXPIRES";
};
export type ExpirationModelType =
  (typeof ExpirationModelType)[keyof typeof ExpirationModelType];
export declare const KeyAgreementAlgorithmSpec: {
  readonly ECDH: "ECDH";
};
export type KeyAgreementAlgorithmSpec =
  (typeof KeyAgreementAlgorithmSpec)[keyof typeof KeyAgreementAlgorithmSpec];
export declare const KeyManagerType: {
  readonly AWS: "AWS";
  readonly CUSTOMER: "CUSTOMER";
};
export type KeyManagerType =
  (typeof KeyManagerType)[keyof typeof KeyManagerType];
export declare const KeyState: {
  readonly Creating: "Creating";
  readonly Disabled: "Disabled";
  readonly Enabled: "Enabled";
  readonly PendingDeletion: "PendingDeletion";
  readonly PendingImport: "PendingImport";
  readonly PendingReplicaDeletion: "PendingReplicaDeletion";
  readonly Unavailable: "Unavailable";
  readonly Updating: "Updating";
};
export type KeyState = (typeof KeyState)[keyof typeof KeyState];
export declare const MacAlgorithmSpec: {
  readonly HMAC_SHA_224: "HMAC_SHA_224";
  readonly HMAC_SHA_256: "HMAC_SHA_256";
  readonly HMAC_SHA_384: "HMAC_SHA_384";
  readonly HMAC_SHA_512: "HMAC_SHA_512";
};
export type MacAlgorithmSpec =
  (typeof MacAlgorithmSpec)[keyof typeof MacAlgorithmSpec];
export declare const MultiRegionKeyType: {
  readonly PRIMARY: "PRIMARY";
  readonly REPLICA: "REPLICA";
};
export type MultiRegionKeyType =
  (typeof MultiRegionKeyType)[keyof typeof MultiRegionKeyType];
export interface MultiRegionKey {
  Arn?: string | undefined;
  Region?: string | undefined;
}
export interface MultiRegionConfiguration {
  MultiRegionKeyType?: MultiRegionKeyType | undefined;
  PrimaryKey?: MultiRegionKey | undefined;
  ReplicaKeys?: MultiRegionKey[] | undefined;
}
export declare const SigningAlgorithmSpec: {
  readonly ECDSA_SHA_256: "ECDSA_SHA_256";
  readonly ECDSA_SHA_384: "ECDSA_SHA_384";
  readonly ECDSA_SHA_512: "ECDSA_SHA_512";
  readonly ML_DSA_SHAKE_256: "ML_DSA_SHAKE_256";
  readonly RSASSA_PKCS1_V1_5_SHA_256: "RSASSA_PKCS1_V1_5_SHA_256";
  readonly RSASSA_PKCS1_V1_5_SHA_384: "RSASSA_PKCS1_V1_5_SHA_384";
  readonly RSASSA_PKCS1_V1_5_SHA_512: "RSASSA_PKCS1_V1_5_SHA_512";
  readonly RSASSA_PSS_SHA_256: "RSASSA_PSS_SHA_256";
  readonly RSASSA_PSS_SHA_384: "RSASSA_PSS_SHA_384";
  readonly RSASSA_PSS_SHA_512: "RSASSA_PSS_SHA_512";
  readonly SM2DSA: "SM2DSA";
};
export type SigningAlgorithmSpec =
  (typeof SigningAlgorithmSpec)[keyof typeof SigningAlgorithmSpec];
export interface XksKeyConfigurationType {
  Id?: string | undefined;
}
export interface KeyMetadata {
  AWSAccountId?: string | undefined;
  KeyId: string | undefined;
  Arn?: string | undefined;
  CreationDate?: Date | undefined;
  Enabled?: boolean | undefined;
  Description?: string | undefined;
  KeyUsage?: KeyUsageType | undefined;
  KeyState?: KeyState | undefined;
  DeletionDate?: Date | undefined;
  ValidTo?: Date | undefined;
  Origin?: OriginType | undefined;
  CustomKeyStoreId?: string | undefined;
  CloudHsmClusterId?: string | undefined;
  ExpirationModel?: ExpirationModelType | undefined;
  KeyManager?: KeyManagerType | undefined;
  CustomerMasterKeySpec?: CustomerMasterKeySpec | undefined;
  KeySpec?: KeySpec | undefined;
  EncryptionAlgorithms?: EncryptionAlgorithmSpec[] | undefined;
  SigningAlgorithms?: SigningAlgorithmSpec[] | undefined;
  KeyAgreementAlgorithms?: KeyAgreementAlgorithmSpec[] | undefined;
  MultiRegion?: boolean | undefined;
  MultiRegionConfiguration?: MultiRegionConfiguration | undefined;
  PendingDeletionWindowInDays?: number | undefined;
  MacAlgorithms?: MacAlgorithmSpec[] | undefined;
  XksKeyConfiguration?: XksKeyConfigurationType | undefined;
  CurrentKeyMaterialId?: string | undefined;
}
export interface CreateKeyResponse {
  KeyMetadata?: KeyMetadata | undefined;
}
export declare class MalformedPolicyDocumentException extends __BaseException {
  readonly name: "MalformedPolicyDocumentException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      MalformedPolicyDocumentException,
      __BaseException
    >
  );
}
export declare class TagException extends __BaseException {
  readonly name: "TagException";
  readonly $fault: "client";
  constructor(opts: __ExceptionOptionType<TagException, __BaseException>);
}
export declare class UnsupportedOperationException extends __BaseException {
  readonly name: "UnsupportedOperationException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<UnsupportedOperationException, __BaseException>
  );
}
export declare class XksKeyAlreadyInUseException extends __BaseException {
  readonly name: "XksKeyAlreadyInUseException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<XksKeyAlreadyInUseException, __BaseException>
  );
}
export declare class XksKeyInvalidConfigurationException extends __BaseException {
  readonly name: "XksKeyInvalidConfigurationException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      XksKeyInvalidConfigurationException,
      __BaseException
    >
  );
}
export declare class XksKeyNotFoundException extends __BaseException {
  readonly name: "XksKeyNotFoundException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<XksKeyNotFoundException, __BaseException>
  );
}
export declare class CustomKeyStoreHasCMKsException extends __BaseException {
  readonly name: "CustomKeyStoreHasCMKsException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<CustomKeyStoreHasCMKsException, __BaseException>
  );
}
export interface XksProxyConfigurationType {
  Connectivity?: XksProxyConnectivityType | undefined;
  AccessKeyId?: string | undefined;
  UriEndpoint?: string | undefined;
  UriPath?: string | undefined;
  VpcEndpointServiceName?: string | undefined;
}
export interface CustomKeyStoresListEntry {
  CustomKeyStoreId?: string | undefined;
  CustomKeyStoreName?: string | undefined;
  CloudHsmClusterId?: string | undefined;
  TrustAnchorCertificate?: string | undefined;
  ConnectionState?: ConnectionStateType | undefined;
  ConnectionErrorCode?: ConnectionErrorCodeType | undefined;
  CreationDate?: Date | undefined;
  CustomKeyStoreType?: CustomKeyStoreType | undefined;
  XksProxyConfiguration?: XksProxyConfigurationType | undefined;
}
export declare const DataKeyPairSpec: {
  readonly ECC_NIST_P256: "ECC_NIST_P256";
  readonly ECC_NIST_P384: "ECC_NIST_P384";
  readonly ECC_NIST_P521: "ECC_NIST_P521";
  readonly ECC_SECG_P256K1: "ECC_SECG_P256K1";
  readonly RSA_2048: "RSA_2048";
  readonly RSA_3072: "RSA_3072";
  readonly RSA_4096: "RSA_4096";
  readonly SM2: "SM2";
};
export type DataKeyPairSpec =
  (typeof DataKeyPairSpec)[keyof typeof DataKeyPairSpec];
export declare const DataKeySpec: {
  readonly AES_128: "AES_128";
  readonly AES_256: "AES_256";
};
export type DataKeySpec = (typeof DataKeySpec)[keyof typeof DataKeySpec];
export declare const KeyEncryptionMechanism: {
  readonly RSAES_OAEP_SHA_256: "RSAES_OAEP_SHA_256";
};
export type KeyEncryptionMechanism =
  (typeof KeyEncryptionMechanism)[keyof typeof KeyEncryptionMechanism];
export interface RecipientInfo {
  KeyEncryptionAlgorithm?: KeyEncryptionMechanism | undefined;
  AttestationDocument?: Uint8Array | undefined;
}
export interface DecryptRequest {
  CiphertextBlob: Uint8Array | undefined;
  EncryptionContext?: Record<string, string> | undefined;
  GrantTokens?: string[] | undefined;
  KeyId?: string | undefined;
  EncryptionAlgorithm?: EncryptionAlgorithmSpec | undefined;
  Recipient?: RecipientInfo | undefined;
  DryRun?: boolean | undefined;
}
export interface DecryptResponse {
  KeyId?: string | undefined;
  Plaintext?: Uint8Array | undefined;
  EncryptionAlgorithm?: EncryptionAlgorithmSpec | undefined;
  CiphertextForRecipient?: Uint8Array | undefined;
  KeyMaterialId?: string | undefined;
}
export declare class IncorrectKeyException extends __BaseException {
  readonly name: "IncorrectKeyException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<IncorrectKeyException, __BaseException>
  );
}
export declare class InvalidCiphertextException extends __BaseException {
  readonly name: "InvalidCiphertextException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidCiphertextException, __BaseException>
  );
}
export declare class InvalidKeyUsageException extends __BaseException {
  readonly name: "InvalidKeyUsageException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidKeyUsageException, __BaseException>
  );
}
export declare class KeyUnavailableException extends __BaseException {
  readonly name: "KeyUnavailableException";
  readonly $fault: "server";
  constructor(
    opts: __ExceptionOptionType<KeyUnavailableException, __BaseException>
  );
}
export interface DeleteAliasRequest {
  AliasName: string | undefined;
}
export interface DeleteCustomKeyStoreRequest {
  CustomKeyStoreId: string | undefined;
}
export interface DeleteCustomKeyStoreResponse {}
export interface DeleteImportedKeyMaterialRequest {
  KeyId: string | undefined;
  KeyMaterialId?: string | undefined;
}
export interface DeleteImportedKeyMaterialResponse {
  KeyId?: string | undefined;
  KeyMaterialId?: string | undefined;
}
export interface DeriveSharedSecretRequest {
  KeyId: string | undefined;
  KeyAgreementAlgorithm: KeyAgreementAlgorithmSpec | undefined;
  PublicKey: Uint8Array | undefined;
  GrantTokens?: string[] | undefined;
  DryRun?: boolean | undefined;
  Recipient?: RecipientInfo | undefined;
}
export interface DeriveSharedSecretResponse {
  KeyId?: string | undefined;
  SharedSecret?: Uint8Array | undefined;
  CiphertextForRecipient?: Uint8Array | undefined;
  KeyAgreementAlgorithm?: KeyAgreementAlgorithmSpec | undefined;
  KeyOrigin?: OriginType | undefined;
}
export interface DescribeCustomKeyStoresRequest {
  CustomKeyStoreId?: string | undefined;
  CustomKeyStoreName?: string | undefined;
  Limit?: number | undefined;
  Marker?: string | undefined;
}
export interface DescribeCustomKeyStoresResponse {
  CustomKeyStores?: CustomKeyStoresListEntry[] | undefined;
  NextMarker?: string | undefined;
  Truncated?: boolean | undefined;
}
export declare class InvalidMarkerException extends __BaseException {
  readonly name: "InvalidMarkerException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidMarkerException, __BaseException>
  );
}
export interface DescribeKeyRequest {
  KeyId: string | undefined;
  GrantTokens?: string[] | undefined;
}
export interface DescribeKeyResponse {
  KeyMetadata?: KeyMetadata | undefined;
}
export interface DisableKeyRequest {
  KeyId: string | undefined;
}
export interface DisableKeyRotationRequest {
  KeyId: string | undefined;
}
export interface DisconnectCustomKeyStoreRequest {
  CustomKeyStoreId: string | undefined;
}
export interface DisconnectCustomKeyStoreResponse {}
export interface EnableKeyRequest {
  KeyId: string | undefined;
}
export interface EnableKeyRotationRequest {
  KeyId: string | undefined;
  RotationPeriodInDays?: number | undefined;
}
export interface EncryptRequest {
  KeyId: string | undefined;
  Plaintext: Uint8Array | undefined;
  EncryptionContext?: Record<string, string> | undefined;
  GrantTokens?: string[] | undefined;
  EncryptionAlgorithm?: EncryptionAlgorithmSpec | undefined;
  DryRun?: boolean | undefined;
}
export interface EncryptResponse {
  CiphertextBlob?: Uint8Array | undefined;
  KeyId?: string | undefined;
  EncryptionAlgorithm?: EncryptionAlgorithmSpec | undefined;
}
export declare class ExpiredImportTokenException extends __BaseException {
  readonly name: "ExpiredImportTokenException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<ExpiredImportTokenException, __BaseException>
  );
}
export interface GenerateDataKeyRequest {
  KeyId: string | undefined;
  EncryptionContext?: Record<string, string> | undefined;
  NumberOfBytes?: number | undefined;
  KeySpec?: DataKeySpec | undefined;
  GrantTokens?: string[] | undefined;
  Recipient?: RecipientInfo | undefined;
  DryRun?: boolean | undefined;
}
export interface GenerateDataKeyResponse {
  CiphertextBlob?: Uint8Array | undefined;
  Plaintext?: Uint8Array | undefined;
  KeyId?: string | undefined;
  CiphertextForRecipient?: Uint8Array | undefined;
  KeyMaterialId?: string | undefined;
}
export interface GenerateDataKeyPairRequest {
  EncryptionContext?: Record<string, string> | undefined;
  KeyId: string | undefined;
  KeyPairSpec: DataKeyPairSpec | undefined;
  GrantTokens?: string[] | undefined;
  Recipient?: RecipientInfo | undefined;
  DryRun?: boolean | undefined;
}
export interface GenerateDataKeyPairResponse {
  PrivateKeyCiphertextBlob?: Uint8Array | undefined;
  PrivateKeyPlaintext?: Uint8Array | undefined;
  PublicKey?: Uint8Array | undefined;
  KeyId?: string | undefined;
  KeyPairSpec?: DataKeyPairSpec | undefined;
  CiphertextForRecipient?: Uint8Array | undefined;
  KeyMaterialId?: string | undefined;
}
export interface GenerateDataKeyPairWithoutPlaintextRequest {
  EncryptionContext?: Record<string, string> | undefined;
  KeyId: string | undefined;
  KeyPairSpec: DataKeyPairSpec | undefined;
  GrantTokens?: string[] | undefined;
  DryRun?: boolean | undefined;
}
export interface GenerateDataKeyPairWithoutPlaintextResponse {
  PrivateKeyCiphertextBlob?: Uint8Array | undefined;
  PublicKey?: Uint8Array | undefined;
  KeyId?: string | undefined;
  KeyPairSpec?: DataKeyPairSpec | undefined;
  KeyMaterialId?: string | undefined;
}
export interface GenerateDataKeyWithoutPlaintextRequest {
  KeyId: string | undefined;
  EncryptionContext?: Record<string, string> | undefined;
  KeySpec?: DataKeySpec | undefined;
  NumberOfBytes?: number | undefined;
  GrantTokens?: string[] | undefined;
  DryRun?: boolean | undefined;
}
export interface GenerateDataKeyWithoutPlaintextResponse {
  CiphertextBlob?: Uint8Array | undefined;
  KeyId?: string | undefined;
  KeyMaterialId?: string | undefined;
}
export interface GenerateMacRequest {
  Message: Uint8Array | undefined;
  KeyId: string | undefined;
  MacAlgorithm: MacAlgorithmSpec | undefined;
  GrantTokens?: string[] | undefined;
  DryRun?: boolean | undefined;
}
export interface GenerateMacResponse {
  Mac?: Uint8Array | undefined;
  MacAlgorithm?: MacAlgorithmSpec | undefined;
  KeyId?: string | undefined;
}
export interface GenerateRandomRequest {
  NumberOfBytes?: number | undefined;
  CustomKeyStoreId?: string | undefined;
  Recipient?: RecipientInfo | undefined;
}
export interface GenerateRandomResponse {
  Plaintext?: Uint8Array | undefined;
  CiphertextForRecipient?: Uint8Array | undefined;
}
export interface GetKeyPolicyRequest {
  KeyId: string | undefined;
  PolicyName?: string | undefined;
}
export interface GetKeyPolicyResponse {
  Policy?: string | undefined;
  PolicyName?: string | undefined;
}
export interface GetKeyRotationStatusRequest {
  KeyId: string | undefined;
}
export interface GetKeyRotationStatusResponse {
  KeyRotationEnabled?: boolean | undefined;
  KeyId?: string | undefined;
  RotationPeriodInDays?: number | undefined;
  NextRotationDate?: Date | undefined;
  OnDemandRotationStartDate?: Date | undefined;
}
export declare const WrappingKeySpec: {
  readonly RSA_2048: "RSA_2048";
  readonly RSA_3072: "RSA_3072";
  readonly RSA_4096: "RSA_4096";
  readonly SM2: "SM2";
};
export type WrappingKeySpec =
  (typeof WrappingKeySpec)[keyof typeof WrappingKeySpec];
export interface GetParametersForImportRequest {
  KeyId: string | undefined;
  WrappingAlgorithm: AlgorithmSpec | undefined;
  WrappingKeySpec: WrappingKeySpec | undefined;
}
export interface GetParametersForImportResponse {
  KeyId?: string | undefined;
  ImportToken?: Uint8Array | undefined;
  PublicKey?: Uint8Array | undefined;
  ParametersValidTo?: Date | undefined;
}
export interface GetPublicKeyRequest {
  KeyId: string | undefined;
  GrantTokens?: string[] | undefined;
}
export interface GetPublicKeyResponse {
  KeyId?: string | undefined;
  PublicKey?: Uint8Array | undefined;
  CustomerMasterKeySpec?: CustomerMasterKeySpec | undefined;
  KeySpec?: KeySpec | undefined;
  KeyUsage?: KeyUsageType | undefined;
  EncryptionAlgorithms?: EncryptionAlgorithmSpec[] | undefined;
  SigningAlgorithms?: SigningAlgorithmSpec[] | undefined;
  KeyAgreementAlgorithms?: KeyAgreementAlgorithmSpec[] | undefined;
}
export interface GrantListEntry {
  KeyId?: string | undefined;
  GrantId?: string | undefined;
  Name?: string | undefined;
  CreationDate?: Date | undefined;
  GranteePrincipal?: string | undefined;
  RetiringPrincipal?: string | undefined;
  IssuingAccount?: string | undefined;
  Operations?: GrantOperation[] | undefined;
  Constraints?: GrantConstraints | undefined;
}
export declare const ImportType: {
  readonly EXISTING_KEY_MATERIAL: "EXISTING_KEY_MATERIAL";
  readonly NEW_KEY_MATERIAL: "NEW_KEY_MATERIAL";
};
export type ImportType = (typeof ImportType)[keyof typeof ImportType];
export interface ImportKeyMaterialRequest {
  KeyId: string | undefined;
  ImportToken: Uint8Array | undefined;
  EncryptedKeyMaterial: Uint8Array | undefined;
  ValidTo?: Date | undefined;
  ExpirationModel?: ExpirationModelType | undefined;
  ImportType?: ImportType | undefined;
  KeyMaterialDescription?: string | undefined;
  KeyMaterialId?: string | undefined;
}
export interface ImportKeyMaterialResponse {
  KeyId?: string | undefined;
  KeyMaterialId?: string | undefined;
}
export declare class IncorrectKeyMaterialException extends __BaseException {
  readonly name: "IncorrectKeyMaterialException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<IncorrectKeyMaterialException, __BaseException>
  );
}
export declare class InvalidImportTokenException extends __BaseException {
  readonly name: "InvalidImportTokenException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidImportTokenException, __BaseException>
  );
}
export declare const ImportState: {
  readonly IMPORTED: "IMPORTED";
  readonly PENDING_IMPORT: "PENDING_IMPORT";
};
export type ImportState = (typeof ImportState)[keyof typeof ImportState];
export declare const IncludeKeyMaterial: {
  readonly ALL_KEY_MATERIAL: "ALL_KEY_MATERIAL";
  readonly ROTATIONS_ONLY: "ROTATIONS_ONLY";
};
export type IncludeKeyMaterial =
  (typeof IncludeKeyMaterial)[keyof typeof IncludeKeyMaterial];
export declare class InvalidGrantIdException extends __BaseException {
  readonly name: "InvalidGrantIdException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidGrantIdException, __BaseException>
  );
}
export interface KeyListEntry {
  KeyId?: string | undefined;
  KeyArn?: string | undefined;
}
export declare const KeyMaterialState: {
  readonly CURRENT: "CURRENT";
  readonly NON_CURRENT: "NON_CURRENT";
  readonly PENDING_ROTATION: "PENDING_ROTATION";
};
export type KeyMaterialState =
  (typeof KeyMaterialState)[keyof typeof KeyMaterialState];
export declare class KMSInvalidMacException extends __BaseException {
  readonly name: "KMSInvalidMacException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<KMSInvalidMacException, __BaseException>
  );
}
export declare class KMSInvalidSignatureException extends __BaseException {
  readonly name: "KMSInvalidSignatureException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<KMSInvalidSignatureException, __BaseException>
  );
}
export interface ListAliasesRequest {
  KeyId?: string | undefined;
  Limit?: number | undefined;
  Marker?: string | undefined;
}
export interface ListAliasesResponse {
  Aliases?: AliasListEntry[] | undefined;
  NextMarker?: string | undefined;
  Truncated?: boolean | undefined;
}
export interface ListGrantsRequest {
  Limit?: number | undefined;
  Marker?: string | undefined;
  KeyId: string | undefined;
  GrantId?: string | undefined;
  GranteePrincipal?: string | undefined;
}
export interface ListGrantsResponse {
  Grants?: GrantListEntry[] | undefined;
  NextMarker?: string | undefined;
  Truncated?: boolean | undefined;
}
export interface ListKeyPoliciesRequest {
  KeyId: string | undefined;
  Limit?: number | undefined;
  Marker?: string | undefined;
}
export interface ListKeyPoliciesResponse {
  PolicyNames?: string[] | undefined;
  NextMarker?: string | undefined;
  Truncated?: boolean | undefined;
}
export interface ListKeyRotationsRequest {
  KeyId: string | undefined;
  IncludeKeyMaterial?: IncludeKeyMaterial | undefined;
  Limit?: number | undefined;
  Marker?: string | undefined;
}
export declare const RotationType: {
  readonly AUTOMATIC: "AUTOMATIC";
  readonly ON_DEMAND: "ON_DEMAND";
};
export type RotationType = (typeof RotationType)[keyof typeof RotationType];
export interface RotationsListEntry {
  KeyId?: string | undefined;
  KeyMaterialId?: string | undefined;
  KeyMaterialDescription?: string | undefined;
  ImportState?: ImportState | undefined;
  KeyMaterialState?: KeyMaterialState | undefined;
  ExpirationModel?: ExpirationModelType | undefined;
  ValidTo?: Date | undefined;
  RotationDate?: Date | undefined;
  RotationType?: RotationType | undefined;
}
export interface ListKeyRotationsResponse {
  Rotations?: RotationsListEntry[] | undefined;
  NextMarker?: string | undefined;
  Truncated?: boolean | undefined;
}
export interface ListKeysRequest {
  Limit?: number | undefined;
  Marker?: string | undefined;
}
export interface ListKeysResponse {
  Keys?: KeyListEntry[] | undefined;
  NextMarker?: string | undefined;
  Truncated?: boolean | undefined;
}
export interface ListResourceTagsRequest {
  KeyId: string | undefined;
  Limit?: number | undefined;
  Marker?: string | undefined;
}
export interface ListResourceTagsResponse {
  Tags?: Tag[] | undefined;
  NextMarker?: string | undefined;
  Truncated?: boolean | undefined;
}
export interface ListRetirableGrantsRequest {
  Limit?: number | undefined;
  Marker?: string | undefined;
  RetiringPrincipal: string | undefined;
}
export declare const MessageType: {
  readonly DIGEST: "DIGEST";
  readonly EXTERNAL_MU: "EXTERNAL_MU";
  readonly RAW: "RAW";
};
export type MessageType = (typeof MessageType)[keyof typeof MessageType];
export interface PutKeyPolicyRequest {
  KeyId: string | undefined;
  PolicyName?: string | undefined;
  Policy: string | undefined;
  BypassPolicyLockoutSafetyCheck?: boolean | undefined;
}
export interface ReEncryptRequest {
  CiphertextBlob: Uint8Array | undefined;
  SourceEncryptionContext?: Record<string, string> | undefined;
  SourceKeyId?: string | undefined;
  DestinationKeyId: string | undefined;
  DestinationEncryptionContext?: Record<string, string> | undefined;
  SourceEncryptionAlgorithm?: EncryptionAlgorithmSpec | undefined;
  DestinationEncryptionAlgorithm?: EncryptionAlgorithmSpec | undefined;
  GrantTokens?: string[] | undefined;
  DryRun?: boolean | undefined;
}
export interface ReEncryptResponse {
  CiphertextBlob?: Uint8Array | undefined;
  SourceKeyId?: string | undefined;
  KeyId?: string | undefined;
  SourceEncryptionAlgorithm?: EncryptionAlgorithmSpec | undefined;
  DestinationEncryptionAlgorithm?: EncryptionAlgorithmSpec | undefined;
  SourceKeyMaterialId?: string | undefined;
  DestinationKeyMaterialId?: string | undefined;
}
export interface ReplicateKeyRequest {
  KeyId: string | undefined;
  ReplicaRegion: string | undefined;
  Policy?: string | undefined;
  BypassPolicyLockoutSafetyCheck?: boolean | undefined;
  Description?: string | undefined;
  Tags?: Tag[] | undefined;
}
export interface ReplicateKeyResponse {
  ReplicaKeyMetadata?: KeyMetadata | undefined;
  ReplicaPolicy?: string | undefined;
  ReplicaTags?: Tag[] | undefined;
}
export interface RetireGrantRequest {
  GrantToken?: string | undefined;
  KeyId?: string | undefined;
  GrantId?: string | undefined;
  DryRun?: boolean | undefined;
}
export interface RevokeGrantRequest {
  KeyId: string | undefined;
  GrantId: string | undefined;
  DryRun?: boolean | undefined;
}
export interface RotateKeyOnDemandRequest {
  KeyId: string | undefined;
}
export interface RotateKeyOnDemandResponse {
  KeyId?: string | undefined;
}
export interface ScheduleKeyDeletionRequest {
  KeyId: string | undefined;
  PendingWindowInDays?: number | undefined;
}
export interface ScheduleKeyDeletionResponse {
  KeyId?: string | undefined;
  DeletionDate?: Date | undefined;
  KeyState?: KeyState | undefined;
  PendingWindowInDays?: number | undefined;
}
export interface SignRequest {
  KeyId: string | undefined;
  Message: Uint8Array | undefined;
  MessageType?: MessageType | undefined;
  GrantTokens?: string[] | undefined;
  SigningAlgorithm: SigningAlgorithmSpec | undefined;
  DryRun?: boolean | undefined;
}
export interface SignResponse {
  KeyId?: string | undefined;
  Signature?: Uint8Array | undefined;
  SigningAlgorithm?: SigningAlgorithmSpec | undefined;
}
export interface TagResourceRequest {
  KeyId: string | undefined;
  Tags: Tag[] | undefined;
}
export interface UntagResourceRequest {
  KeyId: string | undefined;
  TagKeys: string[] | undefined;
}
export interface UpdateAliasRequest {
  AliasName: string | undefined;
  TargetKeyId: string | undefined;
}
export interface UpdateCustomKeyStoreRequest {
  CustomKeyStoreId: string | undefined;
  NewCustomKeyStoreName?: string | undefined;
  KeyStorePassword?: string | undefined;
  CloudHsmClusterId?: string | undefined;
  XksProxyUriEndpoint?: string | undefined;
  XksProxyUriPath?: string | undefined;
  XksProxyVpcEndpointServiceName?: string | undefined;
  XksProxyAuthenticationCredential?:
    | XksProxyAuthenticationCredentialType
    | undefined;
  XksProxyConnectivity?: XksProxyConnectivityType | undefined;
}
export interface UpdateCustomKeyStoreResponse {}
export interface UpdateKeyDescriptionRequest {
  KeyId: string | undefined;
  Description: string | undefined;
}
export interface UpdatePrimaryRegionRequest {
  KeyId: string | undefined;
  PrimaryRegion: string | undefined;
}
export interface VerifyRequest {
  KeyId: string | undefined;
  Message: Uint8Array | undefined;
  MessageType?: MessageType | undefined;
  Signature: Uint8Array | undefined;
  SigningAlgorithm: SigningAlgorithmSpec | undefined;
  GrantTokens?: string[] | undefined;
  DryRun?: boolean | undefined;
}
export interface VerifyResponse {
  KeyId?: string | undefined;
  SignatureValid?: boolean | undefined;
  SigningAlgorithm?: SigningAlgorithmSpec | undefined;
}
export interface VerifyMacRequest {
  Message: Uint8Array | undefined;
  KeyId: string | undefined;
  MacAlgorithm: MacAlgorithmSpec | undefined;
  Mac: Uint8Array | undefined;
  GrantTokens?: string[] | undefined;
  DryRun?: boolean | undefined;
}
export interface VerifyMacResponse {
  KeyId?: string | undefined;
  MacValid?: boolean | undefined;
  MacAlgorithm?: MacAlgorithmSpec | undefined;
}
export declare const XksProxyAuthenticationCredentialTypeFilterSensitiveLog: (
  obj: XksProxyAuthenticationCredentialType
) => any;
export declare const CreateCustomKeyStoreRequestFilterSensitiveLog: (
  obj: CreateCustomKeyStoreRequest
) => any;
export declare const XksProxyConfigurationTypeFilterSensitiveLog: (
  obj: XksProxyConfigurationType
) => any;
export declare const CustomKeyStoresListEntryFilterSensitiveLog: (
  obj: CustomKeyStoresListEntry
) => any;
export declare const DecryptResponseFilterSensitiveLog: (
  obj: DecryptResponse
) => any;
export declare const DeriveSharedSecretResponseFilterSensitiveLog: (
  obj: DeriveSharedSecretResponse
) => any;
export declare const DescribeCustomKeyStoresResponseFilterSensitiveLog: (
  obj: DescribeCustomKeyStoresResponse
) => any;
export declare const EncryptRequestFilterSensitiveLog: (
  obj: EncryptRequest
) => any;
export declare const GenerateDataKeyResponseFilterSensitiveLog: (
  obj: GenerateDataKeyResponse
) => any;
export declare const GenerateDataKeyPairResponseFilterSensitiveLog: (
  obj: GenerateDataKeyPairResponse
) => any;
export declare const GenerateMacRequestFilterSensitiveLog: (
  obj: GenerateMacRequest
) => any;
export declare const GenerateRandomResponseFilterSensitiveLog: (
  obj: GenerateRandomResponse
) => any;
export declare const GetParametersForImportResponseFilterSensitiveLog: (
  obj: GetParametersForImportResponse
) => any;
export declare const SignRequestFilterSensitiveLog: (obj: SignRequest) => any;
export declare const UpdateCustomKeyStoreRequestFilterSensitiveLog: (
  obj: UpdateCustomKeyStoreRequest
) => any;
export declare const VerifyRequestFilterSensitiveLog: (
  obj: VerifyRequest
) => any;
export declare const VerifyMacRequestFilterSensitiveLog: (
  obj: VerifyMacRequest
) => any;
