import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { ValidateStateMachineDefinitionInputFilterSensitiveLog, ValidateStateMachineDefinitionOutputFilterSensitiveLog, } from "../models/models_0";
import { de_ValidateStateMachineDefinitionCommand, se_ValidateStateMachineDefinitionCommand, } from "../protocols/Aws_json1_0";
export { $Command };
export class ValidateStateMachineDefinitionCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AWSStepFunctions", "ValidateStateMachineDefinition", {})
    .n("SFNClient", "ValidateStateMachineDefinitionCommand")
    .f(ValidateStateMachineDefinitionInputFilterSensitiveLog, ValidateStateMachineDefinitionOutputFilterSensitiveLog)
    .ser(se_ValidateStateMachineDefinitionCommand)
    .de(de_ValidateStateMachineDefinitionCommand)
    .build() {
}
