import { SENSITIVE_STRING } from "@smithy/smithy-client";
import { SFNServiceException as __BaseException } from "./SFNServiceException";
export class ActivityAlreadyExists extends __BaseException {
    name = "ActivityAlreadyExists";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ActivityAlreadyExists",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ActivityAlreadyExists.prototype);
    }
}
export class ActivityDoesNotExist extends __BaseException {
    name = "ActivityDoesNotExist";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ActivityDoesNotExist",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ActivityDoesNotExist.prototype);
    }
}
export class ActivityLimitExceeded extends __BaseException {
    name = "ActivityLimitExceeded";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ActivityLimitExceeded",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ActivityLimitExceeded.prototype);
    }
}
export class ActivityWorkerLimitExceeded extends __BaseException {
    name = "ActivityWorkerLimitExceeded";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ActivityWorkerLimitExceeded",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ActivityWorkerLimitExceeded.prototype);
    }
}
export const EncryptionType = {
    AWS_OWNED_KEY: "AWS_OWNED_KEY",
    CUSTOMER_MANAGED_KMS_KEY: "CUSTOMER_MANAGED_KMS_KEY",
};
export class InvalidEncryptionConfiguration extends __BaseException {
    name = "InvalidEncryptionConfiguration";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidEncryptionConfiguration",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidEncryptionConfiguration.prototype);
    }
}
export class InvalidName extends __BaseException {
    name = "InvalidName";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidName",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidName.prototype);
    }
}
export class KmsAccessDeniedException extends __BaseException {
    name = "KmsAccessDeniedException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "KmsAccessDeniedException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, KmsAccessDeniedException.prototype);
    }
}
export class KmsThrottlingException extends __BaseException {
    name = "KmsThrottlingException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "KmsThrottlingException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, KmsThrottlingException.prototype);
    }
}
export class TooManyTags extends __BaseException {
    name = "TooManyTags";
    $fault = "client";
    resourceName;
    constructor(opts) {
        super({
            name: "TooManyTags",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, TooManyTags.prototype);
        this.resourceName = opts.resourceName;
    }
}
export class ConflictException extends __BaseException {
    name = "ConflictException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ConflictException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ConflictException.prototype);
    }
}
export const LogLevel = {
    ALL: "ALL",
    ERROR: "ERROR",
    FATAL: "FATAL",
    OFF: "OFF",
};
export const StateMachineType = {
    EXPRESS: "EXPRESS",
    STANDARD: "STANDARD",
};
export class InvalidArn extends __BaseException {
    name = "InvalidArn";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidArn",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidArn.prototype);
    }
}
export class InvalidDefinition extends __BaseException {
    name = "InvalidDefinition";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidDefinition",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidDefinition.prototype);
    }
}
export class InvalidLoggingConfiguration extends __BaseException {
    name = "InvalidLoggingConfiguration";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidLoggingConfiguration",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidLoggingConfiguration.prototype);
    }
}
export class InvalidTracingConfiguration extends __BaseException {
    name = "InvalidTracingConfiguration";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidTracingConfiguration",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidTracingConfiguration.prototype);
    }
}
export class StateMachineAlreadyExists extends __BaseException {
    name = "StateMachineAlreadyExists";
    $fault = "client";
    constructor(opts) {
        super({
            name: "StateMachineAlreadyExists",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, StateMachineAlreadyExists.prototype);
    }
}
export class StateMachineDeleting extends __BaseException {
    name = "StateMachineDeleting";
    $fault = "client";
    constructor(opts) {
        super({
            name: "StateMachineDeleting",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, StateMachineDeleting.prototype);
    }
}
export class StateMachineLimitExceeded extends __BaseException {
    name = "StateMachineLimitExceeded";
    $fault = "client";
    constructor(opts) {
        super({
            name: "StateMachineLimitExceeded",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, StateMachineLimitExceeded.prototype);
    }
}
export class StateMachineTypeNotSupported extends __BaseException {
    name = "StateMachineTypeNotSupported";
    $fault = "client";
    constructor(opts) {
        super({
            name: "StateMachineTypeNotSupported",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, StateMachineTypeNotSupported.prototype);
    }
}
export const ValidationExceptionReason = {
    API_DOES_NOT_SUPPORT_LABELED_ARNS: "API_DOES_NOT_SUPPORT_LABELED_ARNS",
    CANNOT_UPDATE_COMPLETED_MAP_RUN: "CANNOT_UPDATE_COMPLETED_MAP_RUN",
    INVALID_ROUTING_CONFIGURATION: "INVALID_ROUTING_CONFIGURATION",
    MISSING_REQUIRED_PARAMETER: "MISSING_REQUIRED_PARAMETER",
};
export class ValidationException extends __BaseException {
    name = "ValidationException";
    $fault = "client";
    reason;
    constructor(opts) {
        super({
            name: "ValidationException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ValidationException.prototype);
        this.reason = opts.reason;
    }
}
export class ResourceNotFound extends __BaseException {
    name = "ResourceNotFound";
    $fault = "client";
    resourceName;
    constructor(opts) {
        super({
            name: "ResourceNotFound",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ResourceNotFound.prototype);
        this.resourceName = opts.resourceName;
    }
}
export class ServiceQuotaExceededException extends __BaseException {
    name = "ServiceQuotaExceededException";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ServiceQuotaExceededException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ServiceQuotaExceededException.prototype);
    }
}
export const IncludedData = {
    ALL_DATA: "ALL_DATA",
    METADATA_ONLY: "METADATA_ONLY",
};
export const ExecutionRedriveStatus = {
    NOT_REDRIVABLE: "NOT_REDRIVABLE",
    REDRIVABLE: "REDRIVABLE",
    REDRIVABLE_BY_MAP_RUN: "REDRIVABLE_BY_MAP_RUN",
};
export const ExecutionStatus = {
    ABORTED: "ABORTED",
    FAILED: "FAILED",
    PENDING_REDRIVE: "PENDING_REDRIVE",
    RUNNING: "RUNNING",
    SUCCEEDED: "SUCCEEDED",
    TIMED_OUT: "TIMED_OUT",
};
export class ExecutionDoesNotExist extends __BaseException {
    name = "ExecutionDoesNotExist";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ExecutionDoesNotExist",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ExecutionDoesNotExist.prototype);
    }
}
export const KmsKeyState = {
    CREATING: "CREATING",
    DISABLED: "DISABLED",
    PENDING_DELETION: "PENDING_DELETION",
    PENDING_IMPORT: "PENDING_IMPORT",
    UNAVAILABLE: "UNAVAILABLE",
};
export class KmsInvalidStateException extends __BaseException {
    name = "KmsInvalidStateException";
    $fault = "client";
    kmsKeyState;
    constructor(opts) {
        super({
            name: "KmsInvalidStateException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, KmsInvalidStateException.prototype);
        this.kmsKeyState = opts.kmsKeyState;
    }
}
export const MapRunStatus = {
    ABORTED: "ABORTED",
    FAILED: "FAILED",
    RUNNING: "RUNNING",
    SUCCEEDED: "SUCCEEDED",
};
export const StateMachineStatus = {
    ACTIVE: "ACTIVE",
    DELETING: "DELETING",
};
export class StateMachineDoesNotExist extends __BaseException {
    name = "StateMachineDoesNotExist";
    $fault = "client";
    constructor(opts) {
        super({
            name: "StateMachineDoesNotExist",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, StateMachineDoesNotExist.prototype);
    }
}
export const HistoryEventType = {
    ActivityFailed: "ActivityFailed",
    ActivityScheduleFailed: "ActivityScheduleFailed",
    ActivityScheduled: "ActivityScheduled",
    ActivityStarted: "ActivityStarted",
    ActivitySucceeded: "ActivitySucceeded",
    ActivityTimedOut: "ActivityTimedOut",
    ChoiceStateEntered: "ChoiceStateEntered",
    ChoiceStateExited: "ChoiceStateExited",
    EvaluationFailed: "EvaluationFailed",
    ExecutionAborted: "ExecutionAborted",
    ExecutionFailed: "ExecutionFailed",
    ExecutionRedriven: "ExecutionRedriven",
    ExecutionStarted: "ExecutionStarted",
    ExecutionSucceeded: "ExecutionSucceeded",
    ExecutionTimedOut: "ExecutionTimedOut",
    FailStateEntered: "FailStateEntered",
    LambdaFunctionFailed: "LambdaFunctionFailed",
    LambdaFunctionScheduleFailed: "LambdaFunctionScheduleFailed",
    LambdaFunctionScheduled: "LambdaFunctionScheduled",
    LambdaFunctionStartFailed: "LambdaFunctionStartFailed",
    LambdaFunctionStarted: "LambdaFunctionStarted",
    LambdaFunctionSucceeded: "LambdaFunctionSucceeded",
    LambdaFunctionTimedOut: "LambdaFunctionTimedOut",
    MapIterationAborted: "MapIterationAborted",
    MapIterationFailed: "MapIterationFailed",
    MapIterationStarted: "MapIterationStarted",
    MapIterationSucceeded: "MapIterationSucceeded",
    MapRunAborted: "MapRunAborted",
    MapRunFailed: "MapRunFailed",
    MapRunRedriven: "MapRunRedriven",
    MapRunStarted: "MapRunStarted",
    MapRunSucceeded: "MapRunSucceeded",
    MapStateAborted: "MapStateAborted",
    MapStateEntered: "MapStateEntered",
    MapStateExited: "MapStateExited",
    MapStateFailed: "MapStateFailed",
    MapStateStarted: "MapStateStarted",
    MapStateSucceeded: "MapStateSucceeded",
    ParallelStateAborted: "ParallelStateAborted",
    ParallelStateEntered: "ParallelStateEntered",
    ParallelStateExited: "ParallelStateExited",
    ParallelStateFailed: "ParallelStateFailed",
    ParallelStateStarted: "ParallelStateStarted",
    ParallelStateSucceeded: "ParallelStateSucceeded",
    PassStateEntered: "PassStateEntered",
    PassStateExited: "PassStateExited",
    SucceedStateEntered: "SucceedStateEntered",
    SucceedStateExited: "SucceedStateExited",
    TaskFailed: "TaskFailed",
    TaskScheduled: "TaskScheduled",
    TaskStartFailed: "TaskStartFailed",
    TaskStarted: "TaskStarted",
    TaskStateAborted: "TaskStateAborted",
    TaskStateEntered: "TaskStateEntered",
    TaskStateExited: "TaskStateExited",
    TaskSubmitFailed: "TaskSubmitFailed",
    TaskSubmitted: "TaskSubmitted",
    TaskSucceeded: "TaskSucceeded",
    TaskTimedOut: "TaskTimedOut",
    WaitStateAborted: "WaitStateAborted",
    WaitStateEntered: "WaitStateEntered",
    WaitStateExited: "WaitStateExited",
};
export class InvalidToken extends __BaseException {
    name = "InvalidToken";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidToken",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidToken.prototype);
    }
}
export const ExecutionRedriveFilter = {
    NOT_REDRIVEN: "NOT_REDRIVEN",
    REDRIVEN: "REDRIVEN",
};
export class ExecutionLimitExceeded extends __BaseException {
    name = "ExecutionLimitExceeded";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ExecutionLimitExceeded",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ExecutionLimitExceeded.prototype);
    }
}
export class ExecutionNotRedrivable extends __BaseException {
    name = "ExecutionNotRedrivable";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ExecutionNotRedrivable",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ExecutionNotRedrivable.prototype);
    }
}
export class TaskDoesNotExist extends __BaseException {
    name = "TaskDoesNotExist";
    $fault = "client";
    constructor(opts) {
        super({
            name: "TaskDoesNotExist",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, TaskDoesNotExist.prototype);
    }
}
export class TaskTimedOut extends __BaseException {
    name = "TaskTimedOut";
    $fault = "client";
    constructor(opts) {
        super({
            name: "TaskTimedOut",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, TaskTimedOut.prototype);
    }
}
export class InvalidOutput extends __BaseException {
    name = "InvalidOutput";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidOutput",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidOutput.prototype);
    }
}
export class ExecutionAlreadyExists extends __BaseException {
    name = "ExecutionAlreadyExists";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ExecutionAlreadyExists",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ExecutionAlreadyExists.prototype);
    }
}
export class InvalidExecutionInput extends __BaseException {
    name = "InvalidExecutionInput";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidExecutionInput",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidExecutionInput.prototype);
    }
}
export const SyncExecutionStatus = {
    FAILED: "FAILED",
    SUCCEEDED: "SUCCEEDED",
    TIMED_OUT: "TIMED_OUT",
};
export const InspectionLevel = {
    DEBUG: "DEBUG",
    INFO: "INFO",
    TRACE: "TRACE",
};
export const TestExecutionStatus = {
    CAUGHT_ERROR: "CAUGHT_ERROR",
    FAILED: "FAILED",
    RETRIABLE: "RETRIABLE",
    SUCCEEDED: "SUCCEEDED",
};
export class MissingRequiredParameter extends __BaseException {
    name = "MissingRequiredParameter";
    $fault = "client";
    constructor(opts) {
        super({
            name: "MissingRequiredParameter",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, MissingRequiredParameter.prototype);
    }
}
export const ValidateStateMachineDefinitionSeverity = {
    ERROR: "ERROR",
    WARNING: "WARNING",
};
export const ValidateStateMachineDefinitionResultCode = {
    FAIL: "FAIL",
    OK: "OK",
};
export const ActivityFailedEventDetailsFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.error && { error: SENSITIVE_STRING }),
    ...(obj.cause && { cause: SENSITIVE_STRING }),
});
export const ActivityScheduledEventDetailsFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.input && { input: SENSITIVE_STRING }),
});
export const ActivityScheduleFailedEventDetailsFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.error && { error: SENSITIVE_STRING }),
    ...(obj.cause && { cause: SENSITIVE_STRING }),
});
export const ActivitySucceededEventDetailsFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.output && { output: SENSITIVE_STRING }),
});
export const ActivityTimedOutEventDetailsFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.error && { error: SENSITIVE_STRING }),
    ...(obj.cause && { cause: SENSITIVE_STRING }),
});
export const CreateStateMachineInputFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.definition && { definition: SENSITIVE_STRING }),
    ...(obj.versionDescription && { versionDescription: SENSITIVE_STRING }),
});
export const CreateStateMachineAliasInputFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.description && { description: SENSITIVE_STRING }),
});
export const DescribeExecutionOutputFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.input && { input: SENSITIVE_STRING }),
    ...(obj.output && { output: SENSITIVE_STRING }),
    ...(obj.error && { error: SENSITIVE_STRING }),
    ...(obj.cause && { cause: SENSITIVE_STRING }),
    ...(obj.redriveStatusReason && { redriveStatusReason: SENSITIVE_STRING }),
});
export const DescribeStateMachineOutputFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.definition && { definition: SENSITIVE_STRING }),
    ...(obj.description && { description: SENSITIVE_STRING }),
    ...(obj.variableReferences && { variableReferences: SENSITIVE_STRING }),
});
export const DescribeStateMachineAliasOutputFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.description && { description: SENSITIVE_STRING }),
});
export const DescribeStateMachineForExecutionOutputFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.definition && { definition: SENSITIVE_STRING }),
    ...(obj.variableReferences && { variableReferences: SENSITIVE_STRING }),
});
export const GetActivityTaskOutputFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.input && { input: SENSITIVE_STRING }),
});
export const EvaluationFailedEventDetailsFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.error && { error: SENSITIVE_STRING }),
    ...(obj.cause && { cause: SENSITIVE_STRING }),
    ...(obj.location && { location: SENSITIVE_STRING }),
});
export const ExecutionAbortedEventDetailsFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.error && { error: SENSITIVE_STRING }),
    ...(obj.cause && { cause: SENSITIVE_STRING }),
});
export const ExecutionFailedEventDetailsFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.error && { error: SENSITIVE_STRING }),
    ...(obj.cause && { cause: SENSITIVE_STRING }),
});
export const ExecutionStartedEventDetailsFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.input && { input: SENSITIVE_STRING }),
});
export const ExecutionSucceededEventDetailsFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.output && { output: SENSITIVE_STRING }),
});
export const ExecutionTimedOutEventDetailsFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.error && { error: SENSITIVE_STRING }),
    ...(obj.cause && { cause: SENSITIVE_STRING }),
});
export const LambdaFunctionFailedEventDetailsFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.error && { error: SENSITIVE_STRING }),
    ...(obj.cause && { cause: SENSITIVE_STRING }),
});
export const LambdaFunctionScheduledEventDetailsFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.input && { input: SENSITIVE_STRING }),
});
export const LambdaFunctionScheduleFailedEventDetailsFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.error && { error: SENSITIVE_STRING }),
    ...(obj.cause && { cause: SENSITIVE_STRING }),
});
export const LambdaFunctionStartFailedEventDetailsFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.error && { error: SENSITIVE_STRING }),
    ...(obj.cause && { cause: SENSITIVE_STRING }),
});
export const LambdaFunctionSucceededEventDetailsFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.output && { output: SENSITIVE_STRING }),
});
export const LambdaFunctionTimedOutEventDetailsFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.error && { error: SENSITIVE_STRING }),
    ...(obj.cause && { cause: SENSITIVE_STRING }),
});
export const MapRunFailedEventDetailsFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.error && { error: SENSITIVE_STRING }),
    ...(obj.cause && { cause: SENSITIVE_STRING }),
});
export const StateEnteredEventDetailsFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.input && { input: SENSITIVE_STRING }),
});
export const StateExitedEventDetailsFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.output && { output: SENSITIVE_STRING }),
    ...(obj.assignedVariables && { assignedVariables: SENSITIVE_STRING }),
});
export const TaskFailedEventDetailsFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.error && { error: SENSITIVE_STRING }),
    ...(obj.cause && { cause: SENSITIVE_STRING }),
});
export const TaskScheduledEventDetailsFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.parameters && { parameters: SENSITIVE_STRING }),
});
export const TaskStartFailedEventDetailsFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.error && { error: SENSITIVE_STRING }),
    ...(obj.cause && { cause: SENSITIVE_STRING }),
});
export const TaskSubmitFailedEventDetailsFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.error && { error: SENSITIVE_STRING }),
    ...(obj.cause && { cause: SENSITIVE_STRING }),
});
export const TaskSubmittedEventDetailsFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.output && { output: SENSITIVE_STRING }),
});
export const TaskSucceededEventDetailsFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.output && { output: SENSITIVE_STRING }),
});
export const TaskTimedOutEventDetailsFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.error && { error: SENSITIVE_STRING }),
    ...(obj.cause && { cause: SENSITIVE_STRING }),
});
export const HistoryEventFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.activityFailedEventDetails && {
        activityFailedEventDetails: ActivityFailedEventDetailsFilterSensitiveLog(obj.activityFailedEventDetails),
    }),
    ...(obj.activityScheduleFailedEventDetails && {
        activityScheduleFailedEventDetails: ActivityScheduleFailedEventDetailsFilterSensitiveLog(obj.activityScheduleFailedEventDetails),
    }),
    ...(obj.activityScheduledEventDetails && {
        activityScheduledEventDetails: ActivityScheduledEventDetailsFilterSensitiveLog(obj.activityScheduledEventDetails),
    }),
    ...(obj.activitySucceededEventDetails && {
        activitySucceededEventDetails: ActivitySucceededEventDetailsFilterSensitiveLog(obj.activitySucceededEventDetails),
    }),
    ...(obj.activityTimedOutEventDetails && {
        activityTimedOutEventDetails: ActivityTimedOutEventDetailsFilterSensitiveLog(obj.activityTimedOutEventDetails),
    }),
    ...(obj.taskFailedEventDetails && {
        taskFailedEventDetails: TaskFailedEventDetailsFilterSensitiveLog(obj.taskFailedEventDetails),
    }),
    ...(obj.taskScheduledEventDetails && {
        taskScheduledEventDetails: TaskScheduledEventDetailsFilterSensitiveLog(obj.taskScheduledEventDetails),
    }),
    ...(obj.taskStartFailedEventDetails && {
        taskStartFailedEventDetails: TaskStartFailedEventDetailsFilterSensitiveLog(obj.taskStartFailedEventDetails),
    }),
    ...(obj.taskSubmitFailedEventDetails && {
        taskSubmitFailedEventDetails: TaskSubmitFailedEventDetailsFilterSensitiveLog(obj.taskSubmitFailedEventDetails),
    }),
    ...(obj.taskSubmittedEventDetails && {
        taskSubmittedEventDetails: TaskSubmittedEventDetailsFilterSensitiveLog(obj.taskSubmittedEventDetails),
    }),
    ...(obj.taskSucceededEventDetails && {
        taskSucceededEventDetails: TaskSucceededEventDetailsFilterSensitiveLog(obj.taskSucceededEventDetails),
    }),
    ...(obj.taskTimedOutEventDetails && {
        taskTimedOutEventDetails: TaskTimedOutEventDetailsFilterSensitiveLog(obj.taskTimedOutEventDetails),
    }),
    ...(obj.executionFailedEventDetails && {
        executionFailedEventDetails: ExecutionFailedEventDetailsFilterSensitiveLog(obj.executionFailedEventDetails),
    }),
    ...(obj.executionStartedEventDetails && {
        executionStartedEventDetails: ExecutionStartedEventDetailsFilterSensitiveLog(obj.executionStartedEventDetails),
    }),
    ...(obj.executionSucceededEventDetails && {
        executionSucceededEventDetails: ExecutionSucceededEventDetailsFilterSensitiveLog(obj.executionSucceededEventDetails),
    }),
    ...(obj.executionAbortedEventDetails && {
        executionAbortedEventDetails: ExecutionAbortedEventDetailsFilterSensitiveLog(obj.executionAbortedEventDetails),
    }),
    ...(obj.executionTimedOutEventDetails && {
        executionTimedOutEventDetails: ExecutionTimedOutEventDetailsFilterSensitiveLog(obj.executionTimedOutEventDetails),
    }),
    ...(obj.lambdaFunctionFailedEventDetails && {
        lambdaFunctionFailedEventDetails: LambdaFunctionFailedEventDetailsFilterSensitiveLog(obj.lambdaFunctionFailedEventDetails),
    }),
    ...(obj.lambdaFunctionScheduleFailedEventDetails && {
        lambdaFunctionScheduleFailedEventDetails: LambdaFunctionScheduleFailedEventDetailsFilterSensitiveLog(obj.lambdaFunctionScheduleFailedEventDetails),
    }),
    ...(obj.lambdaFunctionScheduledEventDetails && {
        lambdaFunctionScheduledEventDetails: LambdaFunctionScheduledEventDetailsFilterSensitiveLog(obj.lambdaFunctionScheduledEventDetails),
    }),
    ...(obj.lambdaFunctionStartFailedEventDetails && {
        lambdaFunctionStartFailedEventDetails: LambdaFunctionStartFailedEventDetailsFilterSensitiveLog(obj.lambdaFunctionStartFailedEventDetails),
    }),
    ...(obj.lambdaFunctionSucceededEventDetails && {
        lambdaFunctionSucceededEventDetails: LambdaFunctionSucceededEventDetailsFilterSensitiveLog(obj.lambdaFunctionSucceededEventDetails),
    }),
    ...(obj.lambdaFunctionTimedOutEventDetails && {
        lambdaFunctionTimedOutEventDetails: LambdaFunctionTimedOutEventDetailsFilterSensitiveLog(obj.lambdaFunctionTimedOutEventDetails),
    }),
    ...(obj.stateEnteredEventDetails && {
        stateEnteredEventDetails: StateEnteredEventDetailsFilterSensitiveLog(obj.stateEnteredEventDetails),
    }),
    ...(obj.stateExitedEventDetails && {
        stateExitedEventDetails: StateExitedEventDetailsFilterSensitiveLog(obj.stateExitedEventDetails),
    }),
    ...(obj.mapRunFailedEventDetails && {
        mapRunFailedEventDetails: MapRunFailedEventDetailsFilterSensitiveLog(obj.mapRunFailedEventDetails),
    }),
    ...(obj.evaluationFailedEventDetails && {
        evaluationFailedEventDetails: EvaluationFailedEventDetailsFilterSensitiveLog(obj.evaluationFailedEventDetails),
    }),
});
export const GetExecutionHistoryOutputFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.events && { events: obj.events.map((item) => HistoryEventFilterSensitiveLog(item)) }),
});
export const PublishStateMachineVersionInputFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.description && { description: SENSITIVE_STRING }),
});
export const SendTaskFailureInputFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.error && { error: SENSITIVE_STRING }),
    ...(obj.cause && { cause: SENSITIVE_STRING }),
});
export const SendTaskSuccessInputFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.output && { output: SENSITIVE_STRING }),
});
export const StartExecutionInputFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.input && { input: SENSITIVE_STRING }),
});
export const StartSyncExecutionInputFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.input && { input: SENSITIVE_STRING }),
});
export const StartSyncExecutionOutputFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.error && { error: SENSITIVE_STRING }),
    ...(obj.cause && { cause: SENSITIVE_STRING }),
    ...(obj.input && { input: SENSITIVE_STRING }),
    ...(obj.output && { output: SENSITIVE_STRING }),
});
export const StopExecutionInputFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.error && { error: SENSITIVE_STRING }),
    ...(obj.cause && { cause: SENSITIVE_STRING }),
});
export const TestStateInputFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.definition && { definition: SENSITIVE_STRING }),
    ...(obj.input && { input: SENSITIVE_STRING }),
    ...(obj.variables && { variables: SENSITIVE_STRING }),
});
export const InspectionDataFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.input && { input: SENSITIVE_STRING }),
    ...(obj.afterArguments && { afterArguments: SENSITIVE_STRING }),
    ...(obj.afterInputPath && { afterInputPath: SENSITIVE_STRING }),
    ...(obj.afterParameters && { afterParameters: SENSITIVE_STRING }),
    ...(obj.result && { result: SENSITIVE_STRING }),
    ...(obj.afterResultSelector && { afterResultSelector: SENSITIVE_STRING }),
    ...(obj.afterResultPath && { afterResultPath: SENSITIVE_STRING }),
    ...(obj.variables && { variables: SENSITIVE_STRING }),
});
export const TestStateOutputFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.output && { output: SENSITIVE_STRING }),
    ...(obj.error && { error: SENSITIVE_STRING }),
    ...(obj.cause && { cause: SENSITIVE_STRING }),
    ...(obj.inspectionData && { inspectionData: SENSITIVE_STRING }),
});
export const UpdateStateMachineInputFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.definition && { definition: SENSITIVE_STRING }),
    ...(obj.versionDescription && { versionDescription: SENSITIVE_STRING }),
});
export const UpdateStateMachineAliasInputFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.description && { description: SENSITIVE_STRING }),
});
export const ValidateStateMachineDefinitionInputFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.definition && { definition: SENSITIVE_STRING }),
});
export const ValidateStateMachineDefinitionDiagnosticFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.code && { code: SENSITIVE_STRING }),
    ...(obj.message && { message: SENSITIVE_STRING }),
    ...(obj.location && { location: SENSITIVE_STRING }),
});
export const ValidateStateMachineDefinitionOutputFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.diagnostics && {
        diagnostics: obj.diagnostics.map((item) => ValidateStateMachineDefinitionDiagnosticFilterSensitiveLog(item)),
    }),
});
