import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { CheckIfPhoneNumberIsOptedOutInputFilterSensitiveLog, } from "../models/models_0";
import { de_CheckIfPhoneNumberIsOptedOutCommand, se_CheckIfPhoneNumberIsOptedOutCommand } from "../protocols/Aws_query";
export { $Command };
export class CheckIfPhoneNumberIsOptedOutCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonSimpleNotificationService", "CheckIfPhoneNumberIsOptedOut", {})
    .n("SNSClient", "CheckIfPhoneNumberIsOptedOutCommand")
    .f(CheckIfPhoneNumberIsOptedOutInputFilterSensitiveLog, void 0)
    .ser(se_CheckIfPhoneNumberIsOptedOutCommand)
    .de(de_CheckIfPhoneNumberIsOptedOutCommand)
    .build() {
}
