import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_PutDataProtectionPolicyCommand, se_PutDataProtectionPolicyCommand } from "../protocols/Aws_query";
export { $Command };
export class PutDataProtectionPolicyCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonSimpleNotificationService", "PutDataProtectionPolicy", {})
    .n("SNSClient", "PutDataProtectionPolicyCommand")
    .f(void 0, void 0)
    .ser(se_PutDataProtectionPolicyCommand)
    .de(de_PutDataProtectionPolicyCommand)
    .build() {
}
