import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_SetPlatformApplicationAttributesCommand, se_SetPlatformApplicationAttributesCommand, } from "../protocols/Aws_query";
export { $Command };
export class SetPlatformApplicationAttributesCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonSimpleNotificationService", "SetPlatformApplicationAttributes", {})
    .n("SNSClient", "SetPlatformApplicationAttributesCommand")
    .f(void 0, void 0)
    .ser(se_SetPlatformApplicationAttributesCommand)
    .de(de_SetPlatformApplicationAttributesCommand)
    .build() {
}
