"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/index.ts
var index_exports = {};
__export(index_exports, {
  AccessDeniedException: () => AccessDeniedException,
  AccessRequestStatus: () => AccessRequestStatus,
  AccessType: () => AccessType,
  AddTagsToResourceCommand: () => AddTagsToResourceCommand,
  AlreadyExistsException: () => AlreadyExistsException,
  AssociateOpsItemRelatedItemCommand: () => AssociateOpsItemRelatedItemCommand,
  AssociatedInstances: () => AssociatedInstances,
  AssociationAlreadyExists: () => AssociationAlreadyExists,
  AssociationComplianceSeverity: () => AssociationComplianceSeverity,
  AssociationDescriptionFilterSensitiveLog: () => AssociationDescriptionFilterSensitiveLog,
  AssociationDoesNotExist: () => AssociationDoesNotExist,
  AssociationExecutionDoesNotExist: () => AssociationExecutionDoesNotExist,
  AssociationExecutionFilterKey: () => AssociationExecutionFilterKey,
  AssociationExecutionTargetsFilterKey: () => AssociationExecutionTargetsFilterKey,
  AssociationFilterKey: () => AssociationFilterKey,
  AssociationFilterOperatorType: () => AssociationFilterOperatorType,
  AssociationLimitExceeded: () => AssociationLimitExceeded,
  AssociationStatusName: () => AssociationStatusName,
  AssociationSyncCompliance: () => AssociationSyncCompliance,
  AssociationVersionInfoFilterSensitiveLog: () => AssociationVersionInfoFilterSensitiveLog,
  AssociationVersionLimitExceeded: () => AssociationVersionLimitExceeded,
  AttachmentHashType: () => AttachmentHashType,
  AttachmentsSourceKey: () => AttachmentsSourceKey,
  AutomationDefinitionNotApprovedException: () => AutomationDefinitionNotApprovedException,
  AutomationDefinitionNotFoundException: () => AutomationDefinitionNotFoundException,
  AutomationDefinitionVersionNotFoundException: () => AutomationDefinitionVersionNotFoundException,
  AutomationExecutionFilterKey: () => AutomationExecutionFilterKey,
  AutomationExecutionLimitExceededException: () => AutomationExecutionLimitExceededException,
  AutomationExecutionNotFoundException: () => AutomationExecutionNotFoundException,
  AutomationExecutionStatus: () => AutomationExecutionStatus,
  AutomationStepNotFoundException: () => AutomationStepNotFoundException,
  AutomationSubtype: () => AutomationSubtype,
  AutomationType: () => AutomationType,
  BaselineOverrideFilterSensitiveLog: () => BaselineOverrideFilterSensitiveLog,
  CalendarState: () => CalendarState,
  CancelCommandCommand: () => CancelCommandCommand,
  CancelMaintenanceWindowExecutionCommand: () => CancelMaintenanceWindowExecutionCommand,
  CommandFilterKey: () => CommandFilterKey,
  CommandFilterSensitiveLog: () => CommandFilterSensitiveLog,
  CommandInvocationStatus: () => CommandInvocationStatus,
  CommandPluginStatus: () => CommandPluginStatus,
  CommandStatus: () => CommandStatus,
  ComplianceQueryOperatorType: () => ComplianceQueryOperatorType,
  ComplianceSeverity: () => ComplianceSeverity,
  ComplianceStatus: () => ComplianceStatus,
  ComplianceTypeCountLimitExceededException: () => ComplianceTypeCountLimitExceededException,
  ComplianceUploadType: () => ComplianceUploadType,
  ConnectionStatus: () => ConnectionStatus,
  CreateActivationCommand: () => CreateActivationCommand,
  CreateAssociationBatchCommand: () => CreateAssociationBatchCommand,
  CreateAssociationBatchRequestEntryFilterSensitiveLog: () => CreateAssociationBatchRequestEntryFilterSensitiveLog,
  CreateAssociationBatchRequestFilterSensitiveLog: () => CreateAssociationBatchRequestFilterSensitiveLog,
  CreateAssociationBatchResultFilterSensitiveLog: () => CreateAssociationBatchResultFilterSensitiveLog,
  CreateAssociationCommand: () => CreateAssociationCommand,
  CreateAssociationRequestFilterSensitiveLog: () => CreateAssociationRequestFilterSensitiveLog,
  CreateAssociationResultFilterSensitiveLog: () => CreateAssociationResultFilterSensitiveLog,
  CreateDocumentCommand: () => CreateDocumentCommand,
  CreateMaintenanceWindowCommand: () => CreateMaintenanceWindowCommand,
  CreateMaintenanceWindowRequestFilterSensitiveLog: () => CreateMaintenanceWindowRequestFilterSensitiveLog,
  CreateOpsItemCommand: () => CreateOpsItemCommand,
  CreateOpsMetadataCommand: () => CreateOpsMetadataCommand,
  CreatePatchBaselineCommand: () => CreatePatchBaselineCommand,
  CreatePatchBaselineRequestFilterSensitiveLog: () => CreatePatchBaselineRequestFilterSensitiveLog,
  CreateResourceDataSyncCommand: () => CreateResourceDataSyncCommand,
  CredentialsFilterSensitiveLog: () => CredentialsFilterSensitiveLog,
  CustomSchemaCountLimitExceededException: () => CustomSchemaCountLimitExceededException,
  DeleteActivationCommand: () => DeleteActivationCommand,
  DeleteAssociationCommand: () => DeleteAssociationCommand,
  DeleteDocumentCommand: () => DeleteDocumentCommand,
  DeleteInventoryCommand: () => DeleteInventoryCommand,
  DeleteMaintenanceWindowCommand: () => DeleteMaintenanceWindowCommand,
  DeleteOpsItemCommand: () => DeleteOpsItemCommand,
  DeleteOpsMetadataCommand: () => DeleteOpsMetadataCommand,
  DeleteParameterCommand: () => DeleteParameterCommand,
  DeleteParametersCommand: () => DeleteParametersCommand,
  DeletePatchBaselineCommand: () => DeletePatchBaselineCommand,
  DeleteResourceDataSyncCommand: () => DeleteResourceDataSyncCommand,
  DeleteResourcePolicyCommand: () => DeleteResourcePolicyCommand,
  DeregisterManagedInstanceCommand: () => DeregisterManagedInstanceCommand,
  DeregisterPatchBaselineForPatchGroupCommand: () => DeregisterPatchBaselineForPatchGroupCommand,
  DeregisterTargetFromMaintenanceWindowCommand: () => DeregisterTargetFromMaintenanceWindowCommand,
  DeregisterTaskFromMaintenanceWindowCommand: () => DeregisterTaskFromMaintenanceWindowCommand,
  DescribeActivationsCommand: () => DescribeActivationsCommand,
  DescribeActivationsFilterKeys: () => DescribeActivationsFilterKeys,
  DescribeAssociationCommand: () => DescribeAssociationCommand,
  DescribeAssociationExecutionTargetsCommand: () => DescribeAssociationExecutionTargetsCommand,
  DescribeAssociationExecutionsCommand: () => DescribeAssociationExecutionsCommand,
  DescribeAssociationResultFilterSensitiveLog: () => DescribeAssociationResultFilterSensitiveLog,
  DescribeAutomationExecutionsCommand: () => DescribeAutomationExecutionsCommand,
  DescribeAutomationStepExecutionsCommand: () => DescribeAutomationStepExecutionsCommand,
  DescribeAvailablePatchesCommand: () => DescribeAvailablePatchesCommand,
  DescribeDocumentCommand: () => DescribeDocumentCommand,
  DescribeDocumentPermissionCommand: () => DescribeDocumentPermissionCommand,
  DescribeEffectiveInstanceAssociationsCommand: () => DescribeEffectiveInstanceAssociationsCommand,
  DescribeEffectivePatchesForPatchBaselineCommand: () => DescribeEffectivePatchesForPatchBaselineCommand,
  DescribeInstanceAssociationsStatusCommand: () => DescribeInstanceAssociationsStatusCommand,
  DescribeInstanceInformationCommand: () => DescribeInstanceInformationCommand,
  DescribeInstanceInformationResultFilterSensitiveLog: () => DescribeInstanceInformationResultFilterSensitiveLog,
  DescribeInstancePatchStatesCommand: () => DescribeInstancePatchStatesCommand,
  DescribeInstancePatchStatesForPatchGroupCommand: () => DescribeInstancePatchStatesForPatchGroupCommand,
  DescribeInstancePatchStatesForPatchGroupResultFilterSensitiveLog: () => DescribeInstancePatchStatesForPatchGroupResultFilterSensitiveLog,
  DescribeInstancePatchStatesResultFilterSensitiveLog: () => DescribeInstancePatchStatesResultFilterSensitiveLog,
  DescribeInstancePatchesCommand: () => DescribeInstancePatchesCommand,
  DescribeInstancePropertiesCommand: () => DescribeInstancePropertiesCommand,
  DescribeInstancePropertiesResultFilterSensitiveLog: () => DescribeInstancePropertiesResultFilterSensitiveLog,
  DescribeInventoryDeletionsCommand: () => DescribeInventoryDeletionsCommand,
  DescribeMaintenanceWindowExecutionTaskInvocationsCommand: () => DescribeMaintenanceWindowExecutionTaskInvocationsCommand,
  DescribeMaintenanceWindowExecutionTaskInvocationsResultFilterSensitiveLog: () => DescribeMaintenanceWindowExecutionTaskInvocationsResultFilterSensitiveLog,
  DescribeMaintenanceWindowExecutionTasksCommand: () => DescribeMaintenanceWindowExecutionTasksCommand,
  DescribeMaintenanceWindowExecutionsCommand: () => DescribeMaintenanceWindowExecutionsCommand,
  DescribeMaintenanceWindowScheduleCommand: () => DescribeMaintenanceWindowScheduleCommand,
  DescribeMaintenanceWindowTargetsCommand: () => DescribeMaintenanceWindowTargetsCommand,
  DescribeMaintenanceWindowTargetsResultFilterSensitiveLog: () => DescribeMaintenanceWindowTargetsResultFilterSensitiveLog,
  DescribeMaintenanceWindowTasksCommand: () => DescribeMaintenanceWindowTasksCommand,
  DescribeMaintenanceWindowTasksResultFilterSensitiveLog: () => DescribeMaintenanceWindowTasksResultFilterSensitiveLog,
  DescribeMaintenanceWindowsCommand: () => DescribeMaintenanceWindowsCommand,
  DescribeMaintenanceWindowsForTargetCommand: () => DescribeMaintenanceWindowsForTargetCommand,
  DescribeMaintenanceWindowsResultFilterSensitiveLog: () => DescribeMaintenanceWindowsResultFilterSensitiveLog,
  DescribeOpsItemsCommand: () => DescribeOpsItemsCommand,
  DescribeParametersCommand: () => DescribeParametersCommand,
  DescribePatchBaselinesCommand: () => DescribePatchBaselinesCommand,
  DescribePatchGroupStateCommand: () => DescribePatchGroupStateCommand,
  DescribePatchGroupsCommand: () => DescribePatchGroupsCommand,
  DescribePatchPropertiesCommand: () => DescribePatchPropertiesCommand,
  DescribeSessionsCommand: () => DescribeSessionsCommand,
  DisassociateOpsItemRelatedItemCommand: () => DisassociateOpsItemRelatedItemCommand,
  DocumentAlreadyExists: () => DocumentAlreadyExists,
  DocumentFilterKey: () => DocumentFilterKey,
  DocumentFormat: () => DocumentFormat,
  DocumentHashType: () => DocumentHashType,
  DocumentLimitExceeded: () => DocumentLimitExceeded,
  DocumentMetadataEnum: () => DocumentMetadataEnum,
  DocumentParameterType: () => DocumentParameterType,
  DocumentPermissionLimit: () => DocumentPermissionLimit,
  DocumentPermissionType: () => DocumentPermissionType,
  DocumentReviewAction: () => DocumentReviewAction,
  DocumentReviewCommentType: () => DocumentReviewCommentType,
  DocumentStatus: () => DocumentStatus,
  DocumentType: () => DocumentType,
  DocumentVersionLimitExceeded: () => DocumentVersionLimitExceeded,
  DoesNotExistException: () => DoesNotExistException,
  DuplicateDocumentContent: () => DuplicateDocumentContent,
  DuplicateDocumentVersionName: () => DuplicateDocumentVersionName,
  DuplicateInstanceId: () => DuplicateInstanceId,
  ExecutionInputs: () => ExecutionInputs,
  ExecutionMode: () => ExecutionMode,
  ExecutionPreview: () => ExecutionPreview,
  ExecutionPreviewStatus: () => ExecutionPreviewStatus,
  ExternalAlarmState: () => ExternalAlarmState,
  FailedCreateAssociationFilterSensitiveLog: () => FailedCreateAssociationFilterSensitiveLog,
  Fault: () => Fault,
  FeatureNotAvailableException: () => FeatureNotAvailableException,
  GetAccessTokenCommand: () => GetAccessTokenCommand,
  GetAccessTokenResponseFilterSensitiveLog: () => GetAccessTokenResponseFilterSensitiveLog,
  GetAutomationExecutionCommand: () => GetAutomationExecutionCommand,
  GetCalendarStateCommand: () => GetCalendarStateCommand,
  GetCommandInvocationCommand: () => GetCommandInvocationCommand,
  GetConnectionStatusCommand: () => GetConnectionStatusCommand,
  GetDefaultPatchBaselineCommand: () => GetDefaultPatchBaselineCommand,
  GetDeployablePatchSnapshotForInstanceCommand: () => GetDeployablePatchSnapshotForInstanceCommand,
  GetDeployablePatchSnapshotForInstanceRequestFilterSensitiveLog: () => GetDeployablePatchSnapshotForInstanceRequestFilterSensitiveLog,
  GetDocumentCommand: () => GetDocumentCommand,
  GetExecutionPreviewCommand: () => GetExecutionPreviewCommand,
  GetInventoryCommand: () => GetInventoryCommand,
  GetInventorySchemaCommand: () => GetInventorySchemaCommand,
  GetMaintenanceWindowCommand: () => GetMaintenanceWindowCommand,
  GetMaintenanceWindowExecutionCommand: () => GetMaintenanceWindowExecutionCommand,
  GetMaintenanceWindowExecutionTaskCommand: () => GetMaintenanceWindowExecutionTaskCommand,
  GetMaintenanceWindowExecutionTaskInvocationCommand: () => GetMaintenanceWindowExecutionTaskInvocationCommand,
  GetMaintenanceWindowExecutionTaskInvocationResultFilterSensitiveLog: () => GetMaintenanceWindowExecutionTaskInvocationResultFilterSensitiveLog,
  GetMaintenanceWindowExecutionTaskResultFilterSensitiveLog: () => GetMaintenanceWindowExecutionTaskResultFilterSensitiveLog,
  GetMaintenanceWindowResultFilterSensitiveLog: () => GetMaintenanceWindowResultFilterSensitiveLog,
  GetMaintenanceWindowTaskCommand: () => GetMaintenanceWindowTaskCommand,
  GetMaintenanceWindowTaskResultFilterSensitiveLog: () => GetMaintenanceWindowTaskResultFilterSensitiveLog,
  GetOpsItemCommand: () => GetOpsItemCommand,
  GetOpsMetadataCommand: () => GetOpsMetadataCommand,
  GetOpsSummaryCommand: () => GetOpsSummaryCommand,
  GetParameterCommand: () => GetParameterCommand,
  GetParameterHistoryCommand: () => GetParameterHistoryCommand,
  GetParameterHistoryResultFilterSensitiveLog: () => GetParameterHistoryResultFilterSensitiveLog,
  GetParameterResultFilterSensitiveLog: () => GetParameterResultFilterSensitiveLog,
  GetParametersByPathCommand: () => GetParametersByPathCommand,
  GetParametersByPathResultFilterSensitiveLog: () => GetParametersByPathResultFilterSensitiveLog,
  GetParametersCommand: () => GetParametersCommand,
  GetParametersResultFilterSensitiveLog: () => GetParametersResultFilterSensitiveLog,
  GetPatchBaselineCommand: () => GetPatchBaselineCommand,
  GetPatchBaselineForPatchGroupCommand: () => GetPatchBaselineForPatchGroupCommand,
  GetPatchBaselineResultFilterSensitiveLog: () => GetPatchBaselineResultFilterSensitiveLog,
  GetResourcePoliciesCommand: () => GetResourcePoliciesCommand,
  GetServiceSettingCommand: () => GetServiceSettingCommand,
  HierarchyLevelLimitExceededException: () => HierarchyLevelLimitExceededException,
  HierarchyTypeMismatchException: () => HierarchyTypeMismatchException,
  IdempotentParameterMismatch: () => IdempotentParameterMismatch,
  ImpactType: () => ImpactType,
  IncompatiblePolicyException: () => IncompatiblePolicyException,
  InstanceInfoFilterSensitiveLog: () => InstanceInfoFilterSensitiveLog,
  InstanceInformationFilterKey: () => InstanceInformationFilterKey,
  InstanceInformationFilterSensitiveLog: () => InstanceInformationFilterSensitiveLog,
  InstancePatchStateFilterSensitiveLog: () => InstancePatchStateFilterSensitiveLog,
  InstancePatchStateOperatorType: () => InstancePatchStateOperatorType,
  InstancePropertyFilterKey: () => InstancePropertyFilterKey,
  InstancePropertyFilterOperator: () => InstancePropertyFilterOperator,
  InstancePropertyFilterSensitiveLog: () => InstancePropertyFilterSensitiveLog,
  InternalServerError: () => InternalServerError,
  InvalidActivation: () => InvalidActivation,
  InvalidActivationId: () => InvalidActivationId,
  InvalidAggregatorException: () => InvalidAggregatorException,
  InvalidAllowedPatternException: () => InvalidAllowedPatternException,
  InvalidAssociation: () => InvalidAssociation,
  InvalidAssociationVersion: () => InvalidAssociationVersion,
  InvalidAutomationExecutionParametersException: () => InvalidAutomationExecutionParametersException,
  InvalidAutomationSignalException: () => InvalidAutomationSignalException,
  InvalidAutomationStatusUpdateException: () => InvalidAutomationStatusUpdateException,
  InvalidCommandId: () => InvalidCommandId,
  InvalidDeleteInventoryParametersException: () => InvalidDeleteInventoryParametersException,
  InvalidDeletionIdException: () => InvalidDeletionIdException,
  InvalidDocument: () => InvalidDocument,
  InvalidDocumentContent: () => InvalidDocumentContent,
  InvalidDocumentOperation: () => InvalidDocumentOperation,
  InvalidDocumentSchemaVersion: () => InvalidDocumentSchemaVersion,
  InvalidDocumentType: () => InvalidDocumentType,
  InvalidDocumentVersion: () => InvalidDocumentVersion,
  InvalidFilter: () => InvalidFilter,
  InvalidFilterKey: () => InvalidFilterKey,
  InvalidFilterOption: () => InvalidFilterOption,
  InvalidFilterValue: () => InvalidFilterValue,
  InvalidInstanceId: () => InvalidInstanceId,
  InvalidInstanceInformationFilterValue: () => InvalidInstanceInformationFilterValue,
  InvalidInstancePropertyFilterValue: () => InvalidInstancePropertyFilterValue,
  InvalidInventoryGroupException: () => InvalidInventoryGroupException,
  InvalidInventoryItemContextException: () => InvalidInventoryItemContextException,
  InvalidInventoryRequestException: () => InvalidInventoryRequestException,
  InvalidItemContentException: () => InvalidItemContentException,
  InvalidKeyId: () => InvalidKeyId,
  InvalidNextToken: () => InvalidNextToken,
  InvalidNotificationConfig: () => InvalidNotificationConfig,
  InvalidOptionException: () => InvalidOptionException,
  InvalidOutputFolder: () => InvalidOutputFolder,
  InvalidOutputLocation: () => InvalidOutputLocation,
  InvalidParameters: () => InvalidParameters,
  InvalidPermissionType: () => InvalidPermissionType,
  InvalidPluginName: () => InvalidPluginName,
  InvalidPolicyAttributeException: () => InvalidPolicyAttributeException,
  InvalidPolicyTypeException: () => InvalidPolicyTypeException,
  InvalidResourceId: () => InvalidResourceId,
  InvalidResourceType: () => InvalidResourceType,
  InvalidResultAttributeException: () => InvalidResultAttributeException,
  InvalidRole: () => InvalidRole,
  InvalidSchedule: () => InvalidSchedule,
  InvalidTag: () => InvalidTag,
  InvalidTarget: () => InvalidTarget,
  InvalidTargetMaps: () => InvalidTargetMaps,
  InvalidTypeNameException: () => InvalidTypeNameException,
  InvalidUpdate: () => InvalidUpdate,
  InventoryAttributeDataType: () => InventoryAttributeDataType,
  InventoryDeletionStatus: () => InventoryDeletionStatus,
  InventoryQueryOperatorType: () => InventoryQueryOperatorType,
  InventorySchemaDeleteOption: () => InventorySchemaDeleteOption,
  InvocationDoesNotExist: () => InvocationDoesNotExist,
  ItemContentMismatchException: () => ItemContentMismatchException,
  ItemSizeLimitExceededException: () => ItemSizeLimitExceededException,
  LabelParameterVersionCommand: () => LabelParameterVersionCommand,
  LastResourceDataSyncStatus: () => LastResourceDataSyncStatus,
  ListAssociationVersionsCommand: () => ListAssociationVersionsCommand,
  ListAssociationVersionsResultFilterSensitiveLog: () => ListAssociationVersionsResultFilterSensitiveLog,
  ListAssociationsCommand: () => ListAssociationsCommand,
  ListCommandInvocationsCommand: () => ListCommandInvocationsCommand,
  ListCommandsCommand: () => ListCommandsCommand,
  ListCommandsResultFilterSensitiveLog: () => ListCommandsResultFilterSensitiveLog,
  ListComplianceItemsCommand: () => ListComplianceItemsCommand,
  ListComplianceSummariesCommand: () => ListComplianceSummariesCommand,
  ListDocumentMetadataHistoryCommand: () => ListDocumentMetadataHistoryCommand,
  ListDocumentVersionsCommand: () => ListDocumentVersionsCommand,
  ListDocumentsCommand: () => ListDocumentsCommand,
  ListInventoryEntriesCommand: () => ListInventoryEntriesCommand,
  ListNodesCommand: () => ListNodesCommand,
  ListNodesResultFilterSensitiveLog: () => ListNodesResultFilterSensitiveLog,
  ListNodesSummaryCommand: () => ListNodesSummaryCommand,
  ListOpsItemEventsCommand: () => ListOpsItemEventsCommand,
  ListOpsItemRelatedItemsCommand: () => ListOpsItemRelatedItemsCommand,
  ListOpsMetadataCommand: () => ListOpsMetadataCommand,
  ListResourceComplianceSummariesCommand: () => ListResourceComplianceSummariesCommand,
  ListResourceDataSyncCommand: () => ListResourceDataSyncCommand,
  ListTagsForResourceCommand: () => ListTagsForResourceCommand,
  MaintenanceWindowExecutionStatus: () => MaintenanceWindowExecutionStatus,
  MaintenanceWindowExecutionTaskInvocationIdentityFilterSensitiveLog: () => MaintenanceWindowExecutionTaskInvocationIdentityFilterSensitiveLog,
  MaintenanceWindowIdentityFilterSensitiveLog: () => MaintenanceWindowIdentityFilterSensitiveLog,
  MaintenanceWindowLambdaParametersFilterSensitiveLog: () => MaintenanceWindowLambdaParametersFilterSensitiveLog,
  MaintenanceWindowResourceType: () => MaintenanceWindowResourceType,
  MaintenanceWindowRunCommandParametersFilterSensitiveLog: () => MaintenanceWindowRunCommandParametersFilterSensitiveLog,
  MaintenanceWindowStepFunctionsParametersFilterSensitiveLog: () => MaintenanceWindowStepFunctionsParametersFilterSensitiveLog,
  MaintenanceWindowTargetFilterSensitiveLog: () => MaintenanceWindowTargetFilterSensitiveLog,
  MaintenanceWindowTaskCutoffBehavior: () => MaintenanceWindowTaskCutoffBehavior,
  MaintenanceWindowTaskFilterSensitiveLog: () => MaintenanceWindowTaskFilterSensitiveLog,
  MaintenanceWindowTaskInvocationParametersFilterSensitiveLog: () => MaintenanceWindowTaskInvocationParametersFilterSensitiveLog,
  MaintenanceWindowTaskParameterValueExpressionFilterSensitiveLog: () => MaintenanceWindowTaskParameterValueExpressionFilterSensitiveLog,
  MaintenanceWindowTaskType: () => MaintenanceWindowTaskType,
  MalformedResourcePolicyDocumentException: () => MalformedResourcePolicyDocumentException,
  ManagedStatus: () => ManagedStatus,
  MaxDocumentSizeExceeded: () => MaxDocumentSizeExceeded,
  ModifyDocumentPermissionCommand: () => ModifyDocumentPermissionCommand,
  NodeAggregatorType: () => NodeAggregatorType,
  NodeAttributeName: () => NodeAttributeName,
  NodeFilterKey: () => NodeFilterKey,
  NodeFilterOperatorType: () => NodeFilterOperatorType,
  NodeFilterSensitiveLog: () => NodeFilterSensitiveLog,
  NodeType: () => NodeType,
  NodeTypeFilterSensitiveLog: () => NodeTypeFilterSensitiveLog,
  NodeTypeName: () => NodeTypeName,
  NotificationEvent: () => NotificationEvent,
  NotificationType: () => NotificationType,
  OperatingSystem: () => OperatingSystem,
  OpsFilterOperatorType: () => OpsFilterOperatorType,
  OpsItemAccessDeniedException: () => OpsItemAccessDeniedException,
  OpsItemAlreadyExistsException: () => OpsItemAlreadyExistsException,
  OpsItemConflictException: () => OpsItemConflictException,
  OpsItemDataType: () => OpsItemDataType,
  OpsItemEventFilterKey: () => OpsItemEventFilterKey,
  OpsItemEventFilterOperator: () => OpsItemEventFilterOperator,
  OpsItemFilterKey: () => OpsItemFilterKey,
  OpsItemFilterOperator: () => OpsItemFilterOperator,
  OpsItemInvalidParameterException: () => OpsItemInvalidParameterException,
  OpsItemLimitExceededException: () => OpsItemLimitExceededException,
  OpsItemNotFoundException: () => OpsItemNotFoundException,
  OpsItemRelatedItemAlreadyExistsException: () => OpsItemRelatedItemAlreadyExistsException,
  OpsItemRelatedItemAssociationNotFoundException: () => OpsItemRelatedItemAssociationNotFoundException,
  OpsItemRelatedItemsFilterKey: () => OpsItemRelatedItemsFilterKey,
  OpsItemRelatedItemsFilterOperator: () => OpsItemRelatedItemsFilterOperator,
  OpsItemStatus: () => OpsItemStatus,
  OpsMetadataAlreadyExistsException: () => OpsMetadataAlreadyExistsException,
  OpsMetadataInvalidArgumentException: () => OpsMetadataInvalidArgumentException,
  OpsMetadataKeyLimitExceededException: () => OpsMetadataKeyLimitExceededException,
  OpsMetadataLimitExceededException: () => OpsMetadataLimitExceededException,
  OpsMetadataNotFoundException: () => OpsMetadataNotFoundException,
  OpsMetadataTooManyUpdatesException: () => OpsMetadataTooManyUpdatesException,
  ParameterAlreadyExists: () => ParameterAlreadyExists,
  ParameterFilterSensitiveLog: () => ParameterFilterSensitiveLog,
  ParameterHistoryFilterSensitiveLog: () => ParameterHistoryFilterSensitiveLog,
  ParameterLimitExceeded: () => ParameterLimitExceeded,
  ParameterMaxVersionLimitExceeded: () => ParameterMaxVersionLimitExceeded,
  ParameterNotFound: () => ParameterNotFound,
  ParameterPatternMismatchException: () => ParameterPatternMismatchException,
  ParameterTier: () => ParameterTier,
  ParameterType: () => ParameterType,
  ParameterVersionLabelLimitExceeded: () => ParameterVersionLabelLimitExceeded,
  ParameterVersionNotFound: () => ParameterVersionNotFound,
  ParametersFilterKey: () => ParametersFilterKey,
  PatchAction: () => PatchAction,
  PatchComplianceDataState: () => PatchComplianceDataState,
  PatchComplianceLevel: () => PatchComplianceLevel,
  PatchComplianceStatus: () => PatchComplianceStatus,
  PatchDeploymentStatus: () => PatchDeploymentStatus,
  PatchFilterKey: () => PatchFilterKey,
  PatchOperationType: () => PatchOperationType,
  PatchProperty: () => PatchProperty,
  PatchSet: () => PatchSet,
  PatchSourceFilterSensitiveLog: () => PatchSourceFilterSensitiveLog,
  PingStatus: () => PingStatus,
  PlatformType: () => PlatformType,
  PoliciesLimitExceededException: () => PoliciesLimitExceededException,
  PutComplianceItemsCommand: () => PutComplianceItemsCommand,
  PutInventoryCommand: () => PutInventoryCommand,
  PutParameterCommand: () => PutParameterCommand,
  PutParameterRequestFilterSensitiveLog: () => PutParameterRequestFilterSensitiveLog,
  PutResourcePolicyCommand: () => PutResourcePolicyCommand,
  RebootOption: () => RebootOption,
  RegisterDefaultPatchBaselineCommand: () => RegisterDefaultPatchBaselineCommand,
  RegisterPatchBaselineForPatchGroupCommand: () => RegisterPatchBaselineForPatchGroupCommand,
  RegisterTargetWithMaintenanceWindowCommand: () => RegisterTargetWithMaintenanceWindowCommand,
  RegisterTargetWithMaintenanceWindowRequestFilterSensitiveLog: () => RegisterTargetWithMaintenanceWindowRequestFilterSensitiveLog,
  RegisterTaskWithMaintenanceWindowCommand: () => RegisterTaskWithMaintenanceWindowCommand,
  RegisterTaskWithMaintenanceWindowRequestFilterSensitiveLog: () => RegisterTaskWithMaintenanceWindowRequestFilterSensitiveLog,
  RemoveTagsFromResourceCommand: () => RemoveTagsFromResourceCommand,
  ResetServiceSettingCommand: () => ResetServiceSettingCommand,
  ResourceDataSyncAlreadyExistsException: () => ResourceDataSyncAlreadyExistsException,
  ResourceDataSyncConflictException: () => ResourceDataSyncConflictException,
  ResourceDataSyncCountExceededException: () => ResourceDataSyncCountExceededException,
  ResourceDataSyncInvalidConfigurationException: () => ResourceDataSyncInvalidConfigurationException,
  ResourceDataSyncNotFoundException: () => ResourceDataSyncNotFoundException,
  ResourceDataSyncS3Format: () => ResourceDataSyncS3Format,
  ResourceInUseException: () => ResourceInUseException,
  ResourceLimitExceededException: () => ResourceLimitExceededException,
  ResourceNotFoundException: () => ResourceNotFoundException,
  ResourcePolicyConflictException: () => ResourcePolicyConflictException,
  ResourcePolicyInvalidParameterException: () => ResourcePolicyInvalidParameterException,
  ResourcePolicyLimitExceededException: () => ResourcePolicyLimitExceededException,
  ResourcePolicyNotFoundException: () => ResourcePolicyNotFoundException,
  ResourceType: () => ResourceType,
  ResourceTypeForTagging: () => ResourceTypeForTagging,
  ResumeSessionCommand: () => ResumeSessionCommand,
  ReviewStatus: () => ReviewStatus,
  SSM: () => SSM,
  SSMClient: () => SSMClient,
  SSMServiceException: () => SSMServiceException,
  SendAutomationSignalCommand: () => SendAutomationSignalCommand,
  SendCommandCommand: () => SendCommandCommand,
  SendCommandRequestFilterSensitiveLog: () => SendCommandRequestFilterSensitiveLog,
  SendCommandResultFilterSensitiveLog: () => SendCommandResultFilterSensitiveLog,
  ServiceQuotaExceededException: () => ServiceQuotaExceededException,
  ServiceSettingNotFound: () => ServiceSettingNotFound,
  SessionFilterKey: () => SessionFilterKey,
  SessionState: () => SessionState,
  SessionStatus: () => SessionStatus,
  SignalType: () => SignalType,
  SourceType: () => SourceType,
  StartAccessRequestCommand: () => StartAccessRequestCommand,
  StartAssociationsOnceCommand: () => StartAssociationsOnceCommand,
  StartAutomationExecutionCommand: () => StartAutomationExecutionCommand,
  StartChangeRequestExecutionCommand: () => StartChangeRequestExecutionCommand,
  StartExecutionPreviewCommand: () => StartExecutionPreviewCommand,
  StartSessionCommand: () => StartSessionCommand,
  StatusUnchanged: () => StatusUnchanged,
  StepExecutionFilterKey: () => StepExecutionFilterKey,
  StopAutomationExecutionCommand: () => StopAutomationExecutionCommand,
  StopType: () => StopType,
  SubTypeCountLimitExceededException: () => SubTypeCountLimitExceededException,
  TargetInUseException: () => TargetInUseException,
  TargetNotConnected: () => TargetNotConnected,
  TerminateSessionCommand: () => TerminateSessionCommand,
  ThrottlingException: () => ThrottlingException,
  TooManyTagsError: () => TooManyTagsError,
  TooManyUpdates: () => TooManyUpdates,
  TotalSizeLimitExceededException: () => TotalSizeLimitExceededException,
  UnlabelParameterVersionCommand: () => UnlabelParameterVersionCommand,
  UnsupportedCalendarException: () => UnsupportedCalendarException,
  UnsupportedFeatureRequiredException: () => UnsupportedFeatureRequiredException,
  UnsupportedInventoryItemContextException: () => UnsupportedInventoryItemContextException,
  UnsupportedInventorySchemaVersionException: () => UnsupportedInventorySchemaVersionException,
  UnsupportedOperatingSystem: () => UnsupportedOperatingSystem,
  UnsupportedOperationException: () => UnsupportedOperationException,
  UnsupportedParameterType: () => UnsupportedParameterType,
  UnsupportedPlatformType: () => UnsupportedPlatformType,
  UpdateAssociationCommand: () => UpdateAssociationCommand,
  UpdateAssociationRequestFilterSensitiveLog: () => UpdateAssociationRequestFilterSensitiveLog,
  UpdateAssociationResultFilterSensitiveLog: () => UpdateAssociationResultFilterSensitiveLog,
  UpdateAssociationStatusCommand: () => UpdateAssociationStatusCommand,
  UpdateAssociationStatusResultFilterSensitiveLog: () => UpdateAssociationStatusResultFilterSensitiveLog,
  UpdateDocumentCommand: () => UpdateDocumentCommand,
  UpdateDocumentDefaultVersionCommand: () => UpdateDocumentDefaultVersionCommand,
  UpdateDocumentMetadataCommand: () => UpdateDocumentMetadataCommand,
  UpdateMaintenanceWindowCommand: () => UpdateMaintenanceWindowCommand,
  UpdateMaintenanceWindowRequestFilterSensitiveLog: () => UpdateMaintenanceWindowRequestFilterSensitiveLog,
  UpdateMaintenanceWindowResultFilterSensitiveLog: () => UpdateMaintenanceWindowResultFilterSensitiveLog,
  UpdateMaintenanceWindowTargetCommand: () => UpdateMaintenanceWindowTargetCommand,
  UpdateMaintenanceWindowTargetRequestFilterSensitiveLog: () => UpdateMaintenanceWindowTargetRequestFilterSensitiveLog,
  UpdateMaintenanceWindowTargetResultFilterSensitiveLog: () => UpdateMaintenanceWindowTargetResultFilterSensitiveLog,
  UpdateMaintenanceWindowTaskCommand: () => UpdateMaintenanceWindowTaskCommand,
  UpdateMaintenanceWindowTaskRequestFilterSensitiveLog: () => UpdateMaintenanceWindowTaskRequestFilterSensitiveLog,
  UpdateMaintenanceWindowTaskResultFilterSensitiveLog: () => UpdateMaintenanceWindowTaskResultFilterSensitiveLog,
  UpdateManagedInstanceRoleCommand: () => UpdateManagedInstanceRoleCommand,
  UpdateOpsItemCommand: () => UpdateOpsItemCommand,
  UpdateOpsMetadataCommand: () => UpdateOpsMetadataCommand,
  UpdatePatchBaselineCommand: () => UpdatePatchBaselineCommand,
  UpdatePatchBaselineRequestFilterSensitiveLog: () => UpdatePatchBaselineRequestFilterSensitiveLog,
  UpdatePatchBaselineResultFilterSensitiveLog: () => UpdatePatchBaselineResultFilterSensitiveLog,
  UpdateResourceDataSyncCommand: () => UpdateResourceDataSyncCommand,
  UpdateServiceSettingCommand: () => UpdateServiceSettingCommand,
  ValidationException: () => ValidationException,
  __Client: () => import_smithy_client.Client,
  paginateDescribeActivations: () => paginateDescribeActivations,
  paginateDescribeAssociationExecutionTargets: () => paginateDescribeAssociationExecutionTargets,
  paginateDescribeAssociationExecutions: () => paginateDescribeAssociationExecutions,
  paginateDescribeAutomationExecutions: () => paginateDescribeAutomationExecutions,
  paginateDescribeAutomationStepExecutions: () => paginateDescribeAutomationStepExecutions,
  paginateDescribeAvailablePatches: () => paginateDescribeAvailablePatches,
  paginateDescribeEffectiveInstanceAssociations: () => paginateDescribeEffectiveInstanceAssociations,
  paginateDescribeEffectivePatchesForPatchBaseline: () => paginateDescribeEffectivePatchesForPatchBaseline,
  paginateDescribeInstanceAssociationsStatus: () => paginateDescribeInstanceAssociationsStatus,
  paginateDescribeInstanceInformation: () => paginateDescribeInstanceInformation,
  paginateDescribeInstancePatchStates: () => paginateDescribeInstancePatchStates,
  paginateDescribeInstancePatchStatesForPatchGroup: () => paginateDescribeInstancePatchStatesForPatchGroup,
  paginateDescribeInstancePatches: () => paginateDescribeInstancePatches,
  paginateDescribeInstanceProperties: () => paginateDescribeInstanceProperties,
  paginateDescribeInventoryDeletions: () => paginateDescribeInventoryDeletions,
  paginateDescribeMaintenanceWindowExecutionTaskInvocations: () => paginateDescribeMaintenanceWindowExecutionTaskInvocations,
  paginateDescribeMaintenanceWindowExecutionTasks: () => paginateDescribeMaintenanceWindowExecutionTasks,
  paginateDescribeMaintenanceWindowExecutions: () => paginateDescribeMaintenanceWindowExecutions,
  paginateDescribeMaintenanceWindowSchedule: () => paginateDescribeMaintenanceWindowSchedule,
  paginateDescribeMaintenanceWindowTargets: () => paginateDescribeMaintenanceWindowTargets,
  paginateDescribeMaintenanceWindowTasks: () => paginateDescribeMaintenanceWindowTasks,
  paginateDescribeMaintenanceWindows: () => paginateDescribeMaintenanceWindows,
  paginateDescribeMaintenanceWindowsForTarget: () => paginateDescribeMaintenanceWindowsForTarget,
  paginateDescribeOpsItems: () => paginateDescribeOpsItems,
  paginateDescribeParameters: () => paginateDescribeParameters,
  paginateDescribePatchBaselines: () => paginateDescribePatchBaselines,
  paginateDescribePatchGroups: () => paginateDescribePatchGroups,
  paginateDescribePatchProperties: () => paginateDescribePatchProperties,
  paginateDescribeSessions: () => paginateDescribeSessions,
  paginateGetInventory: () => paginateGetInventory,
  paginateGetInventorySchema: () => paginateGetInventorySchema,
  paginateGetOpsSummary: () => paginateGetOpsSummary,
  paginateGetParameterHistory: () => paginateGetParameterHistory,
  paginateGetParametersByPath: () => paginateGetParametersByPath,
  paginateGetResourcePolicies: () => paginateGetResourcePolicies,
  paginateListAssociationVersions: () => paginateListAssociationVersions,
  paginateListAssociations: () => paginateListAssociations,
  paginateListCommandInvocations: () => paginateListCommandInvocations,
  paginateListCommands: () => paginateListCommands,
  paginateListComplianceItems: () => paginateListComplianceItems,
  paginateListComplianceSummaries: () => paginateListComplianceSummaries,
  paginateListDocumentVersions: () => paginateListDocumentVersions,
  paginateListDocuments: () => paginateListDocuments,
  paginateListNodes: () => paginateListNodes,
  paginateListNodesSummary: () => paginateListNodesSummary,
  paginateListOpsItemEvents: () => paginateListOpsItemEvents,
  paginateListOpsItemRelatedItems: () => paginateListOpsItemRelatedItems,
  paginateListOpsMetadata: () => paginateListOpsMetadata,
  paginateListResourceComplianceSummaries: () => paginateListResourceComplianceSummaries,
  paginateListResourceDataSync: () => paginateListResourceDataSync,
  waitForCommandExecuted: () => waitForCommandExecuted,
  waitUntilCommandExecuted: () => waitUntilCommandExecuted
});
module.exports = __toCommonJS(index_exports);

// src/SSMClient.ts
var import_middleware_host_header = require("@aws-sdk/middleware-host-header");
var import_middleware_logger = require("@aws-sdk/middleware-logger");
var import_middleware_recursion_detection = require("@aws-sdk/middleware-recursion-detection");
var import_middleware_user_agent = require("@aws-sdk/middleware-user-agent");
var import_config_resolver = require("@smithy/config-resolver");
var import_core = require("@smithy/core");
var import_middleware_content_length = require("@smithy/middleware-content-length");
var import_middleware_endpoint = require("@smithy/middleware-endpoint");
var import_middleware_retry = require("@smithy/middleware-retry");

var import_httpAuthSchemeProvider = require("./auth/httpAuthSchemeProvider");

// src/endpoint/EndpointParameters.ts
var resolveClientEndpointParameters = /* @__PURE__ */ __name((options) => {
  return Object.assign(options, {
    useDualstackEndpoint: options.useDualstackEndpoint ?? false,
    useFipsEndpoint: options.useFipsEndpoint ?? false,
    defaultSigningName: "ssm"
  });
}, "resolveClientEndpointParameters");
var commonParams = {
  UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
  Endpoint: { type: "builtInParams", name: "endpoint" },
  Region: { type: "builtInParams", name: "region" },
  UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" }
};

// src/SSMClient.ts
var import_runtimeConfig = require("././runtimeConfig");

// src/runtimeExtensions.ts
var import_region_config_resolver = require("@aws-sdk/region-config-resolver");
var import_protocol_http = require("@smithy/protocol-http");
var import_smithy_client = require("@smithy/smithy-client");

// src/auth/httpAuthExtensionConfiguration.ts
var getHttpAuthExtensionConfiguration = /* @__PURE__ */ __name((runtimeConfig) => {
  const _httpAuthSchemes = runtimeConfig.httpAuthSchemes;
  let _httpAuthSchemeProvider = runtimeConfig.httpAuthSchemeProvider;
  let _credentials = runtimeConfig.credentials;
  return {
    setHttpAuthScheme(httpAuthScheme) {
      const index = _httpAuthSchemes.findIndex((scheme) => scheme.schemeId === httpAuthScheme.schemeId);
      if (index === -1) {
        _httpAuthSchemes.push(httpAuthScheme);
      } else {
        _httpAuthSchemes.splice(index, 1, httpAuthScheme);
      }
    },
    httpAuthSchemes() {
      return _httpAuthSchemes;
    },
    setHttpAuthSchemeProvider(httpAuthSchemeProvider) {
      _httpAuthSchemeProvider = httpAuthSchemeProvider;
    },
    httpAuthSchemeProvider() {
      return _httpAuthSchemeProvider;
    },
    setCredentials(credentials) {
      _credentials = credentials;
    },
    credentials() {
      return _credentials;
    }
  };
}, "getHttpAuthExtensionConfiguration");
var resolveHttpAuthRuntimeConfig = /* @__PURE__ */ __name((config) => {
  return {
    httpAuthSchemes: config.httpAuthSchemes(),
    httpAuthSchemeProvider: config.httpAuthSchemeProvider(),
    credentials: config.credentials()
  };
}, "resolveHttpAuthRuntimeConfig");

// src/runtimeExtensions.ts
var resolveRuntimeExtensions = /* @__PURE__ */ __name((runtimeConfig, extensions) => {
  const extensionConfiguration = Object.assign(
    (0, import_region_config_resolver.getAwsRegionExtensionConfiguration)(runtimeConfig),
    (0, import_smithy_client.getDefaultExtensionConfiguration)(runtimeConfig),
    (0, import_protocol_http.getHttpHandlerExtensionConfiguration)(runtimeConfig),
    getHttpAuthExtensionConfiguration(runtimeConfig)
  );
  extensions.forEach((extension) => extension.configure(extensionConfiguration));
  return Object.assign(
    runtimeConfig,
    (0, import_region_config_resolver.resolveAwsRegionExtensionConfiguration)(extensionConfiguration),
    (0, import_smithy_client.resolveDefaultRuntimeConfig)(extensionConfiguration),
    (0, import_protocol_http.resolveHttpHandlerRuntimeConfig)(extensionConfiguration),
    resolveHttpAuthRuntimeConfig(extensionConfiguration)
  );
}, "resolveRuntimeExtensions");

// src/SSMClient.ts
var SSMClient = class extends import_smithy_client.Client {
  static {
    __name(this, "SSMClient");
  }
  /**
   * The resolved configuration of SSMClient class. This is resolved and normalized from the {@link SSMClientConfig | constructor configuration interface}.
   */
  config;
  constructor(...[configuration]) {
    const _config_0 = (0, import_runtimeConfig.getRuntimeConfig)(configuration || {});
    super(_config_0);
    this.initConfig = _config_0;
    const _config_1 = resolveClientEndpointParameters(_config_0);
    const _config_2 = (0, import_middleware_user_agent.resolveUserAgentConfig)(_config_1);
    const _config_3 = (0, import_middleware_retry.resolveRetryConfig)(_config_2);
    const _config_4 = (0, import_config_resolver.resolveRegionConfig)(_config_3);
    const _config_5 = (0, import_middleware_host_header.resolveHostHeaderConfig)(_config_4);
    const _config_6 = (0, import_middleware_endpoint.resolveEndpointConfig)(_config_5);
    const _config_7 = (0, import_httpAuthSchemeProvider.resolveHttpAuthSchemeConfig)(_config_6);
    const _config_8 = resolveRuntimeExtensions(_config_7, configuration?.extensions || []);
    this.config = _config_8;
    this.middlewareStack.use((0, import_middleware_user_agent.getUserAgentPlugin)(this.config));
    this.middlewareStack.use((0, import_middleware_retry.getRetryPlugin)(this.config));
    this.middlewareStack.use((0, import_middleware_content_length.getContentLengthPlugin)(this.config));
    this.middlewareStack.use((0, import_middleware_host_header.getHostHeaderPlugin)(this.config));
    this.middlewareStack.use((0, import_middleware_logger.getLoggerPlugin)(this.config));
    this.middlewareStack.use((0, import_middleware_recursion_detection.getRecursionDetectionPlugin)(this.config));
    this.middlewareStack.use(
      (0, import_core.getHttpAuthSchemeEndpointRuleSetPlugin)(this.config, {
        httpAuthSchemeParametersProvider: import_httpAuthSchemeProvider.defaultSSMHttpAuthSchemeParametersProvider,
        identityProviderConfigProvider: /* @__PURE__ */ __name(async (config) => new import_core.DefaultIdentityProviderConfig({
          "aws.auth#sigv4": config.credentials
        }), "identityProviderConfigProvider")
      })
    );
    this.middlewareStack.use((0, import_core.getHttpSigningPlugin)(this.config));
  }
  /**
   * Destroy underlying resources, like sockets. It's usually not necessary to do this.
   * However in Node.js, it's best to explicitly shut down the client's agent when it is no longer needed.
   * Otherwise, sockets might stay open for quite a long time before the server terminates them.
   */
  destroy() {
    super.destroy();
  }
};

// src/SSM.ts


// src/commands/AddTagsToResourceCommand.ts

var import_middleware_serde = require("@smithy/middleware-serde");


// src/protocols/Aws_json1_1.ts
var import_core2 = require("@aws-sdk/core");


var import_uuid = require("@smithy/uuid");

// src/models/models_0.ts


// src/models/SSMServiceException.ts

var SSMServiceException = class _SSMServiceException extends import_smithy_client.ServiceException {
  static {
    __name(this, "SSMServiceException");
  }
  /**
   * @internal
   */
  constructor(options) {
    super(options);
    Object.setPrototypeOf(this, _SSMServiceException.prototype);
  }
};

// src/models/models_0.ts
var AccessDeniedException = class _AccessDeniedException extends SSMServiceException {
  static {
    __name(this, "AccessDeniedException");
  }
  name = "AccessDeniedException";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "AccessDeniedException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _AccessDeniedException.prototype);
    this.Message = opts.Message;
  }
};
var AccessRequestStatus = {
  APPROVED: "Approved",
  EXPIRED: "Expired",
  PENDING: "Pending",
  REJECTED: "Rejected",
  REVOKED: "Revoked"
};
var AccessType = {
  JUSTINTIME: "JustInTime",
  STANDARD: "Standard"
};
var ResourceTypeForTagging = {
  ASSOCIATION: "Association",
  AUTOMATION: "Automation",
  DOCUMENT: "Document",
  MAINTENANCE_WINDOW: "MaintenanceWindow",
  MANAGED_INSTANCE: "ManagedInstance",
  OPSMETADATA: "OpsMetadata",
  OPS_ITEM: "OpsItem",
  PARAMETER: "Parameter",
  PATCH_BASELINE: "PatchBaseline"
};
var InternalServerError = class _InternalServerError extends SSMServiceException {
  static {
    __name(this, "InternalServerError");
  }
  name = "InternalServerError";
  $fault = "server";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InternalServerError",
      $fault: "server",
      ...opts
    });
    Object.setPrototypeOf(this, _InternalServerError.prototype);
    this.Message = opts.Message;
  }
};
var InvalidResourceId = class _InvalidResourceId extends SSMServiceException {
  static {
    __name(this, "InvalidResourceId");
  }
  name = "InvalidResourceId";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidResourceId",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidResourceId.prototype);
  }
};
var InvalidResourceType = class _InvalidResourceType extends SSMServiceException {
  static {
    __name(this, "InvalidResourceType");
  }
  name = "InvalidResourceType";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidResourceType",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidResourceType.prototype);
  }
};
var TooManyTagsError = class _TooManyTagsError extends SSMServiceException {
  static {
    __name(this, "TooManyTagsError");
  }
  name = "TooManyTagsError";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TooManyTagsError",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TooManyTagsError.prototype);
  }
};
var TooManyUpdates = class _TooManyUpdates extends SSMServiceException {
  static {
    __name(this, "TooManyUpdates");
  }
  name = "TooManyUpdates";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TooManyUpdates",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TooManyUpdates.prototype);
    this.Message = opts.Message;
  }
};
var ExternalAlarmState = {
  ALARM: "ALARM",
  UNKNOWN: "UNKNOWN"
};
var AlreadyExistsException = class _AlreadyExistsException extends SSMServiceException {
  static {
    __name(this, "AlreadyExistsException");
  }
  name = "AlreadyExistsException";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "AlreadyExistsException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _AlreadyExistsException.prototype);
    this.Message = opts.Message;
  }
};
var OpsItemConflictException = class _OpsItemConflictException extends SSMServiceException {
  static {
    __name(this, "OpsItemConflictException");
  }
  name = "OpsItemConflictException";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "OpsItemConflictException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _OpsItemConflictException.prototype);
    this.Message = opts.Message;
  }
};
var OpsItemInvalidParameterException = class _OpsItemInvalidParameterException extends SSMServiceException {
  static {
    __name(this, "OpsItemInvalidParameterException");
  }
  name = "OpsItemInvalidParameterException";
  $fault = "client";
  ParameterNames;
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "OpsItemInvalidParameterException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _OpsItemInvalidParameterException.prototype);
    this.ParameterNames = opts.ParameterNames;
    this.Message = opts.Message;
  }
};
var OpsItemLimitExceededException = class _OpsItemLimitExceededException extends SSMServiceException {
  static {
    __name(this, "OpsItemLimitExceededException");
  }
  name = "OpsItemLimitExceededException";
  $fault = "client";
  ResourceTypes;
  Limit;
  LimitType;
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "OpsItemLimitExceededException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _OpsItemLimitExceededException.prototype);
    this.ResourceTypes = opts.ResourceTypes;
    this.Limit = opts.Limit;
    this.LimitType = opts.LimitType;
    this.Message = opts.Message;
  }
};
var OpsItemNotFoundException = class _OpsItemNotFoundException extends SSMServiceException {
  static {
    __name(this, "OpsItemNotFoundException");
  }
  name = "OpsItemNotFoundException";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "OpsItemNotFoundException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _OpsItemNotFoundException.prototype);
    this.Message = opts.Message;
  }
};
var OpsItemRelatedItemAlreadyExistsException = class _OpsItemRelatedItemAlreadyExistsException extends SSMServiceException {
  static {
    __name(this, "OpsItemRelatedItemAlreadyExistsException");
  }
  name = "OpsItemRelatedItemAlreadyExistsException";
  $fault = "client";
  Message;
  ResourceUri;
  OpsItemId;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "OpsItemRelatedItemAlreadyExistsException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _OpsItemRelatedItemAlreadyExistsException.prototype);
    this.Message = opts.Message;
    this.ResourceUri = opts.ResourceUri;
    this.OpsItemId = opts.OpsItemId;
  }
};
var DuplicateInstanceId = class _DuplicateInstanceId extends SSMServiceException {
  static {
    __name(this, "DuplicateInstanceId");
  }
  name = "DuplicateInstanceId";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DuplicateInstanceId",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _DuplicateInstanceId.prototype);
  }
};
var InvalidCommandId = class _InvalidCommandId extends SSMServiceException {
  static {
    __name(this, "InvalidCommandId");
  }
  name = "InvalidCommandId";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidCommandId",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidCommandId.prototype);
  }
};
var InvalidInstanceId = class _InvalidInstanceId extends SSMServiceException {
  static {
    __name(this, "InvalidInstanceId");
  }
  name = "InvalidInstanceId";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidInstanceId",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidInstanceId.prototype);
    this.Message = opts.Message;
  }
};
var DoesNotExistException = class _DoesNotExistException extends SSMServiceException {
  static {
    __name(this, "DoesNotExistException");
  }
  name = "DoesNotExistException";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DoesNotExistException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _DoesNotExistException.prototype);
    this.Message = opts.Message;
  }
};
var InvalidParameters = class _InvalidParameters extends SSMServiceException {
  static {
    __name(this, "InvalidParameters");
  }
  name = "InvalidParameters";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidParameters",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidParameters.prototype);
    this.Message = opts.Message;
  }
};
var AssociationAlreadyExists = class _AssociationAlreadyExists extends SSMServiceException {
  static {
    __name(this, "AssociationAlreadyExists");
  }
  name = "AssociationAlreadyExists";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "AssociationAlreadyExists",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _AssociationAlreadyExists.prototype);
  }
};
var AssociationLimitExceeded = class _AssociationLimitExceeded extends SSMServiceException {
  static {
    __name(this, "AssociationLimitExceeded");
  }
  name = "AssociationLimitExceeded";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "AssociationLimitExceeded",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _AssociationLimitExceeded.prototype);
  }
};
var AssociationComplianceSeverity = {
  Critical: "CRITICAL",
  High: "HIGH",
  Low: "LOW",
  Medium: "MEDIUM",
  Unspecified: "UNSPECIFIED"
};
var AssociationSyncCompliance = {
  Auto: "AUTO",
  Manual: "MANUAL"
};
var AssociationStatusName = {
  Failed: "Failed",
  Pending: "Pending",
  Success: "Success"
};
var InvalidDocument = class _InvalidDocument extends SSMServiceException {
  static {
    __name(this, "InvalidDocument");
  }
  name = "InvalidDocument";
  $fault = "client";
  /**
   * <p>The SSM document doesn't exist or the document isn't available to the user. This exception
   *    can be issued by various API operations. </p>
   * @public
   */
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidDocument",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidDocument.prototype);
    this.Message = opts.Message;
  }
};
var InvalidDocumentVersion = class _InvalidDocumentVersion extends SSMServiceException {
  static {
    __name(this, "InvalidDocumentVersion");
  }
  name = "InvalidDocumentVersion";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidDocumentVersion",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidDocumentVersion.prototype);
    this.Message = opts.Message;
  }
};
var InvalidOutputLocation = class _InvalidOutputLocation extends SSMServiceException {
  static {
    __name(this, "InvalidOutputLocation");
  }
  name = "InvalidOutputLocation";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidOutputLocation",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidOutputLocation.prototype);
  }
};
var InvalidSchedule = class _InvalidSchedule extends SSMServiceException {
  static {
    __name(this, "InvalidSchedule");
  }
  name = "InvalidSchedule";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidSchedule",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidSchedule.prototype);
    this.Message = opts.Message;
  }
};
var InvalidTag = class _InvalidTag extends SSMServiceException {
  static {
    __name(this, "InvalidTag");
  }
  name = "InvalidTag";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidTag",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidTag.prototype);
    this.Message = opts.Message;
  }
};
var InvalidTarget = class _InvalidTarget extends SSMServiceException {
  static {
    __name(this, "InvalidTarget");
  }
  name = "InvalidTarget";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidTarget",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidTarget.prototype);
    this.Message = opts.Message;
  }
};
var InvalidTargetMaps = class _InvalidTargetMaps extends SSMServiceException {
  static {
    __name(this, "InvalidTargetMaps");
  }
  name = "InvalidTargetMaps";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidTargetMaps",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidTargetMaps.prototype);
    this.Message = opts.Message;
  }
};
var UnsupportedPlatformType = class _UnsupportedPlatformType extends SSMServiceException {
  static {
    __name(this, "UnsupportedPlatformType");
  }
  name = "UnsupportedPlatformType";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "UnsupportedPlatformType",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _UnsupportedPlatformType.prototype);
    this.Message = opts.Message;
  }
};
var Fault = {
  Client: "Client",
  Server: "Server",
  Unknown: "Unknown"
};
var AttachmentsSourceKey = {
  AttachmentReference: "AttachmentReference",
  S3FileUrl: "S3FileUrl",
  SourceUrl: "SourceUrl"
};
var DocumentFormat = {
  JSON: "JSON",
  TEXT: "TEXT",
  YAML: "YAML"
};
var DocumentType = {
  ApplicationConfiguration: "ApplicationConfiguration",
  ApplicationConfigurationSchema: "ApplicationConfigurationSchema",
  AutoApprovalPolicy: "AutoApprovalPolicy",
  Automation: "Automation",
  ChangeCalendar: "ChangeCalendar",
  ChangeTemplate: "Automation.ChangeTemplate",
  CloudFormation: "CloudFormation",
  Command: "Command",
  ConformancePackTemplate: "ConformancePackTemplate",
  DeploymentStrategy: "DeploymentStrategy",
  ManualApprovalPolicy: "ManualApprovalPolicy",
  Package: "Package",
  Policy: "Policy",
  ProblemAnalysis: "ProblemAnalysis",
  ProblemAnalysisTemplate: "ProblemAnalysisTemplate",
  QuickSetup: "QuickSetup",
  Session: "Session"
};
var DocumentHashType = {
  SHA1: "Sha1",
  SHA256: "Sha256"
};
var DocumentParameterType = {
  String: "String",
  StringList: "StringList"
};
var PlatformType = {
  LINUX: "Linux",
  MACOS: "MacOS",
  WINDOWS: "Windows"
};
var ReviewStatus = {
  APPROVED: "APPROVED",
  NOT_REVIEWED: "NOT_REVIEWED",
  PENDING: "PENDING",
  REJECTED: "REJECTED"
};
var DocumentStatus = {
  Active: "Active",
  Creating: "Creating",
  Deleting: "Deleting",
  Failed: "Failed",
  Updating: "Updating"
};
var DocumentAlreadyExists = class _DocumentAlreadyExists extends SSMServiceException {
  static {
    __name(this, "DocumentAlreadyExists");
  }
  name = "DocumentAlreadyExists";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DocumentAlreadyExists",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _DocumentAlreadyExists.prototype);
    this.Message = opts.Message;
  }
};
var DocumentLimitExceeded = class _DocumentLimitExceeded extends SSMServiceException {
  static {
    __name(this, "DocumentLimitExceeded");
  }
  name = "DocumentLimitExceeded";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DocumentLimitExceeded",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _DocumentLimitExceeded.prototype);
    this.Message = opts.Message;
  }
};
var InvalidDocumentContent = class _InvalidDocumentContent extends SSMServiceException {
  static {
    __name(this, "InvalidDocumentContent");
  }
  name = "InvalidDocumentContent";
  $fault = "client";
  /**
   * <p>A description of the validation error.</p>
   * @public
   */
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidDocumentContent",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidDocumentContent.prototype);
    this.Message = opts.Message;
  }
};
var InvalidDocumentSchemaVersion = class _InvalidDocumentSchemaVersion extends SSMServiceException {
  static {
    __name(this, "InvalidDocumentSchemaVersion");
  }
  name = "InvalidDocumentSchemaVersion";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidDocumentSchemaVersion",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidDocumentSchemaVersion.prototype);
    this.Message = opts.Message;
  }
};
var MaxDocumentSizeExceeded = class _MaxDocumentSizeExceeded extends SSMServiceException {
  static {
    __name(this, "MaxDocumentSizeExceeded");
  }
  name = "MaxDocumentSizeExceeded";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "MaxDocumentSizeExceeded",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _MaxDocumentSizeExceeded.prototype);
    this.Message = opts.Message;
  }
};
var IdempotentParameterMismatch = class _IdempotentParameterMismatch extends SSMServiceException {
  static {
    __name(this, "IdempotentParameterMismatch");
  }
  name = "IdempotentParameterMismatch";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "IdempotentParameterMismatch",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _IdempotentParameterMismatch.prototype);
    this.Message = opts.Message;
  }
};
var ResourceLimitExceededException = class _ResourceLimitExceededException extends SSMServiceException {
  static {
    __name(this, "ResourceLimitExceededException");
  }
  name = "ResourceLimitExceededException";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ResourceLimitExceededException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ResourceLimitExceededException.prototype);
    this.Message = opts.Message;
  }
};
var OpsItemDataType = {
  SEARCHABLE_STRING: "SearchableString",
  STRING: "String"
};
var OpsItemAccessDeniedException = class _OpsItemAccessDeniedException extends SSMServiceException {
  static {
    __name(this, "OpsItemAccessDeniedException");
  }
  name = "OpsItemAccessDeniedException";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "OpsItemAccessDeniedException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _OpsItemAccessDeniedException.prototype);
    this.Message = opts.Message;
  }
};
var OpsItemAlreadyExistsException = class _OpsItemAlreadyExistsException extends SSMServiceException {
  static {
    __name(this, "OpsItemAlreadyExistsException");
  }
  name = "OpsItemAlreadyExistsException";
  $fault = "client";
  Message;
  OpsItemId;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "OpsItemAlreadyExistsException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _OpsItemAlreadyExistsException.prototype);
    this.Message = opts.Message;
    this.OpsItemId = opts.OpsItemId;
  }
};
var OpsMetadataAlreadyExistsException = class _OpsMetadataAlreadyExistsException extends SSMServiceException {
  static {
    __name(this, "OpsMetadataAlreadyExistsException");
  }
  name = "OpsMetadataAlreadyExistsException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "OpsMetadataAlreadyExistsException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _OpsMetadataAlreadyExistsException.prototype);
  }
};
var OpsMetadataInvalidArgumentException = class _OpsMetadataInvalidArgumentException extends SSMServiceException {
  static {
    __name(this, "OpsMetadataInvalidArgumentException");
  }
  name = "OpsMetadataInvalidArgumentException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "OpsMetadataInvalidArgumentException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _OpsMetadataInvalidArgumentException.prototype);
  }
};
var OpsMetadataLimitExceededException = class _OpsMetadataLimitExceededException extends SSMServiceException {
  static {
    __name(this, "OpsMetadataLimitExceededException");
  }
  name = "OpsMetadataLimitExceededException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "OpsMetadataLimitExceededException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _OpsMetadataLimitExceededException.prototype);
  }
};
var OpsMetadataTooManyUpdatesException = class _OpsMetadataTooManyUpdatesException extends SSMServiceException {
  static {
    __name(this, "OpsMetadataTooManyUpdatesException");
  }
  name = "OpsMetadataTooManyUpdatesException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "OpsMetadataTooManyUpdatesException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _OpsMetadataTooManyUpdatesException.prototype);
  }
};
var PatchComplianceLevel = {
  Critical: "CRITICAL",
  High: "HIGH",
  Informational: "INFORMATIONAL",
  Low: "LOW",
  Medium: "MEDIUM",
  Unspecified: "UNSPECIFIED"
};
var PatchFilterKey = {
  AdvisoryId: "ADVISORY_ID",
  Arch: "ARCH",
  BugzillaId: "BUGZILLA_ID",
  CVEId: "CVE_ID",
  Classification: "CLASSIFICATION",
  Epoch: "EPOCH",
  MsrcSeverity: "MSRC_SEVERITY",
  Name: "NAME",
  PatchId: "PATCH_ID",
  PatchSet: "PATCH_SET",
  Priority: "PRIORITY",
  Product: "PRODUCT",
  ProductFamily: "PRODUCT_FAMILY",
  Release: "RELEASE",
  Repository: "REPOSITORY",
  Section: "SECTION",
  Security: "SECURITY",
  Severity: "SEVERITY",
  Version: "VERSION"
};
var PatchComplianceStatus = {
  Compliant: "COMPLIANT",
  NonCompliant: "NON_COMPLIANT"
};
var OperatingSystem = {
  AlmaLinux: "ALMA_LINUX",
  AmazonLinux: "AMAZON_LINUX",
  AmazonLinux2: "AMAZON_LINUX_2",
  AmazonLinux2022: "AMAZON_LINUX_2022",
  AmazonLinux2023: "AMAZON_LINUX_2023",
  CentOS: "CENTOS",
  Debian: "DEBIAN",
  MacOS: "MACOS",
  OracleLinux: "ORACLE_LINUX",
  Raspbian: "RASPBIAN",
  RedhatEnterpriseLinux: "REDHAT_ENTERPRISE_LINUX",
  Rocky_Linux: "ROCKY_LINUX",
  Suse: "SUSE",
  Ubuntu: "UBUNTU",
  Windows: "WINDOWS"
};
var PatchAction = {
  AllowAsDependency: "ALLOW_AS_DEPENDENCY",
  Block: "BLOCK"
};
var ResourceDataSyncS3Format = {
  JSON_SERDE: "JsonSerDe"
};
var ResourceDataSyncAlreadyExistsException = class _ResourceDataSyncAlreadyExistsException extends SSMServiceException {
  static {
    __name(this, "ResourceDataSyncAlreadyExistsException");
  }
  name = "ResourceDataSyncAlreadyExistsException";
  $fault = "client";
  SyncName;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ResourceDataSyncAlreadyExistsException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ResourceDataSyncAlreadyExistsException.prototype);
    this.SyncName = opts.SyncName;
  }
};
var ResourceDataSyncCountExceededException = class _ResourceDataSyncCountExceededException extends SSMServiceException {
  static {
    __name(this, "ResourceDataSyncCountExceededException");
  }
  name = "ResourceDataSyncCountExceededException";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ResourceDataSyncCountExceededException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ResourceDataSyncCountExceededException.prototype);
    this.Message = opts.Message;
  }
};
var ResourceDataSyncInvalidConfigurationException = class _ResourceDataSyncInvalidConfigurationException extends SSMServiceException {
  static {
    __name(this, "ResourceDataSyncInvalidConfigurationException");
  }
  name = "ResourceDataSyncInvalidConfigurationException";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ResourceDataSyncInvalidConfigurationException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ResourceDataSyncInvalidConfigurationException.prototype);
    this.Message = opts.Message;
  }
};
var InvalidActivation = class _InvalidActivation extends SSMServiceException {
  static {
    __name(this, "InvalidActivation");
  }
  name = "InvalidActivation";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidActivation",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidActivation.prototype);
    this.Message = opts.Message;
  }
};
var InvalidActivationId = class _InvalidActivationId extends SSMServiceException {
  static {
    __name(this, "InvalidActivationId");
  }
  name = "InvalidActivationId";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidActivationId",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidActivationId.prototype);
    this.Message = opts.Message;
  }
};
var AssociationDoesNotExist = class _AssociationDoesNotExist extends SSMServiceException {
  static {
    __name(this, "AssociationDoesNotExist");
  }
  name = "AssociationDoesNotExist";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "AssociationDoesNotExist",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _AssociationDoesNotExist.prototype);
    this.Message = opts.Message;
  }
};
var AssociatedInstances = class _AssociatedInstances extends SSMServiceException {
  static {
    __name(this, "AssociatedInstances");
  }
  name = "AssociatedInstances";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "AssociatedInstances",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _AssociatedInstances.prototype);
  }
};
var InvalidDocumentOperation = class _InvalidDocumentOperation extends SSMServiceException {
  static {
    __name(this, "InvalidDocumentOperation");
  }
  name = "InvalidDocumentOperation";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidDocumentOperation",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidDocumentOperation.prototype);
    this.Message = opts.Message;
  }
};
var InventorySchemaDeleteOption = {
  DELETE_SCHEMA: "DeleteSchema",
  DISABLE_SCHEMA: "DisableSchema"
};
var InvalidDeleteInventoryParametersException = class _InvalidDeleteInventoryParametersException extends SSMServiceException {
  static {
    __name(this, "InvalidDeleteInventoryParametersException");
  }
  name = "InvalidDeleteInventoryParametersException";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidDeleteInventoryParametersException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidDeleteInventoryParametersException.prototype);
    this.Message = opts.Message;
  }
};
var InvalidInventoryRequestException = class _InvalidInventoryRequestException extends SSMServiceException {
  static {
    __name(this, "InvalidInventoryRequestException");
  }
  name = "InvalidInventoryRequestException";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidInventoryRequestException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidInventoryRequestException.prototype);
    this.Message = opts.Message;
  }
};
var InvalidOptionException = class _InvalidOptionException extends SSMServiceException {
  static {
    __name(this, "InvalidOptionException");
  }
  name = "InvalidOptionException";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidOptionException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidOptionException.prototype);
    this.Message = opts.Message;
  }
};
var InvalidTypeNameException = class _InvalidTypeNameException extends SSMServiceException {
  static {
    __name(this, "InvalidTypeNameException");
  }
  name = "InvalidTypeNameException";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidTypeNameException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidTypeNameException.prototype);
    this.Message = opts.Message;
  }
};
var OpsMetadataNotFoundException = class _OpsMetadataNotFoundException extends SSMServiceException {
  static {
    __name(this, "OpsMetadataNotFoundException");
  }
  name = "OpsMetadataNotFoundException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "OpsMetadataNotFoundException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _OpsMetadataNotFoundException.prototype);
  }
};
var ParameterNotFound = class _ParameterNotFound extends SSMServiceException {
  static {
    __name(this, "ParameterNotFound");
  }
  name = "ParameterNotFound";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ParameterNotFound",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ParameterNotFound.prototype);
  }
};
var ResourceInUseException = class _ResourceInUseException extends SSMServiceException {
  static {
    __name(this, "ResourceInUseException");
  }
  name = "ResourceInUseException";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ResourceInUseException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ResourceInUseException.prototype);
    this.Message = opts.Message;
  }
};
var ResourceDataSyncNotFoundException = class _ResourceDataSyncNotFoundException extends SSMServiceException {
  static {
    __name(this, "ResourceDataSyncNotFoundException");
  }
  name = "ResourceDataSyncNotFoundException";
  $fault = "client";
  SyncName;
  SyncType;
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ResourceDataSyncNotFoundException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ResourceDataSyncNotFoundException.prototype);
    this.SyncName = opts.SyncName;
    this.SyncType = opts.SyncType;
    this.Message = opts.Message;
  }
};
var MalformedResourcePolicyDocumentException = class _MalformedResourcePolicyDocumentException extends SSMServiceException {
  static {
    __name(this, "MalformedResourcePolicyDocumentException");
  }
  name = "MalformedResourcePolicyDocumentException";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "MalformedResourcePolicyDocumentException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _MalformedResourcePolicyDocumentException.prototype);
    this.Message = opts.Message;
  }
};
var ResourceNotFoundException = class _ResourceNotFoundException extends SSMServiceException {
  static {
    __name(this, "ResourceNotFoundException");
  }
  name = "ResourceNotFoundException";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ResourceNotFoundException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ResourceNotFoundException.prototype);
    this.Message = opts.Message;
  }
};
var ResourcePolicyConflictException = class _ResourcePolicyConflictException extends SSMServiceException {
  static {
    __name(this, "ResourcePolicyConflictException");
  }
  name = "ResourcePolicyConflictException";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ResourcePolicyConflictException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ResourcePolicyConflictException.prototype);
    this.Message = opts.Message;
  }
};
var ResourcePolicyInvalidParameterException = class _ResourcePolicyInvalidParameterException extends SSMServiceException {
  static {
    __name(this, "ResourcePolicyInvalidParameterException");
  }
  name = "ResourcePolicyInvalidParameterException";
  $fault = "client";
  ParameterNames;
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ResourcePolicyInvalidParameterException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ResourcePolicyInvalidParameterException.prototype);
    this.ParameterNames = opts.ParameterNames;
    this.Message = opts.Message;
  }
};
var ResourcePolicyNotFoundException = class _ResourcePolicyNotFoundException extends SSMServiceException {
  static {
    __name(this, "ResourcePolicyNotFoundException");
  }
  name = "ResourcePolicyNotFoundException";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ResourcePolicyNotFoundException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ResourcePolicyNotFoundException.prototype);
    this.Message = opts.Message;
  }
};
var TargetInUseException = class _TargetInUseException extends SSMServiceException {
  static {
    __name(this, "TargetInUseException");
  }
  name = "TargetInUseException";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TargetInUseException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TargetInUseException.prototype);
    this.Message = opts.Message;
  }
};
var DescribeActivationsFilterKeys = {
  ACTIVATION_IDS: "ActivationIds",
  DEFAULT_INSTANCE_NAME: "DefaultInstanceName",
  IAM_ROLE: "IamRole"
};
var InvalidFilter = class _InvalidFilter extends SSMServiceException {
  static {
    __name(this, "InvalidFilter");
  }
  name = "InvalidFilter";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidFilter",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidFilter.prototype);
    this.Message = opts.Message;
  }
};
var InvalidNextToken = class _InvalidNextToken extends SSMServiceException {
  static {
    __name(this, "InvalidNextToken");
  }
  name = "InvalidNextToken";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidNextToken",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidNextToken.prototype);
    this.Message = opts.Message;
  }
};
var InvalidAssociationVersion = class _InvalidAssociationVersion extends SSMServiceException {
  static {
    __name(this, "InvalidAssociationVersion");
  }
  name = "InvalidAssociationVersion";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidAssociationVersion",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidAssociationVersion.prototype);
    this.Message = opts.Message;
  }
};
var AssociationExecutionFilterKey = {
  CreatedTime: "CreatedTime",
  ExecutionId: "ExecutionId",
  Status: "Status"
};
var AssociationFilterOperatorType = {
  Equal: "EQUAL",
  GreaterThan: "GREATER_THAN",
  LessThan: "LESS_THAN"
};
var AssociationExecutionDoesNotExist = class _AssociationExecutionDoesNotExist extends SSMServiceException {
  static {
    __name(this, "AssociationExecutionDoesNotExist");
  }
  name = "AssociationExecutionDoesNotExist";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "AssociationExecutionDoesNotExist",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _AssociationExecutionDoesNotExist.prototype);
    this.Message = opts.Message;
  }
};
var AssociationExecutionTargetsFilterKey = {
  ResourceId: "ResourceId",
  ResourceType: "ResourceType",
  Status: "Status"
};
var AutomationExecutionFilterKey = {
  AUTOMATION_SUBTYPE: "AutomationSubtype",
  AUTOMATION_TYPE: "AutomationType",
  CURRENT_ACTION: "CurrentAction",
  DOCUMENT_NAME_PREFIX: "DocumentNamePrefix",
  EXECUTION_ID: "ExecutionId",
  EXECUTION_STATUS: "ExecutionStatus",
  OPS_ITEM_ID: "OpsItemId",
  PARENT_EXECUTION_ID: "ParentExecutionId",
  START_TIME_AFTER: "StartTimeAfter",
  START_TIME_BEFORE: "StartTimeBefore",
  TAG_KEY: "TagKey",
  TARGET_RESOURCE_GROUP: "TargetResourceGroup"
};
var AutomationExecutionStatus = {
  APPROVED: "Approved",
  CANCELLED: "Cancelled",
  CANCELLING: "Cancelling",
  CHANGE_CALENDAR_OVERRIDE_APPROVED: "ChangeCalendarOverrideApproved",
  CHANGE_CALENDAR_OVERRIDE_REJECTED: "ChangeCalendarOverrideRejected",
  COMPLETED_WITH_FAILURE: "CompletedWithFailure",
  COMPLETED_WITH_SUCCESS: "CompletedWithSuccess",
  EXITED: "Exited",
  FAILED: "Failed",
  INPROGRESS: "InProgress",
  PENDING: "Pending",
  PENDING_APPROVAL: "PendingApproval",
  PENDING_CHANGE_CALENDAR_OVERRIDE: "PendingChangeCalendarOverride",
  REJECTED: "Rejected",
  RUNBOOK_INPROGRESS: "RunbookInProgress",
  SCHEDULED: "Scheduled",
  SUCCESS: "Success",
  TIMEDOUT: "TimedOut",
  WAITING: "Waiting"
};
var AutomationSubtype = {
  AccessRequest: "AccessRequest",
  ChangeRequest: "ChangeRequest"
};
var AutomationType = {
  CrossAccount: "CrossAccount",
  Local: "Local"
};
var ExecutionMode = {
  Auto: "Auto",
  Interactive: "Interactive"
};
var InvalidFilterKey = class _InvalidFilterKey extends SSMServiceException {
  static {
    __name(this, "InvalidFilterKey");
  }
  name = "InvalidFilterKey";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidFilterKey",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidFilterKey.prototype);
  }
};
var InvalidFilterValue = class _InvalidFilterValue extends SSMServiceException {
  static {
    __name(this, "InvalidFilterValue");
  }
  name = "InvalidFilterValue";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidFilterValue",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidFilterValue.prototype);
    this.Message = opts.Message;
  }
};
var AutomationExecutionNotFoundException = class _AutomationExecutionNotFoundException extends SSMServiceException {
  static {
    __name(this, "AutomationExecutionNotFoundException");
  }
  name = "AutomationExecutionNotFoundException";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "AutomationExecutionNotFoundException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _AutomationExecutionNotFoundException.prototype);
    this.Message = opts.Message;
  }
};
var StepExecutionFilterKey = {
  ACTION: "Action",
  PARENT_STEP_EXECUTION_ID: "ParentStepExecutionId",
  PARENT_STEP_ITERATION: "ParentStepIteration",
  PARENT_STEP_ITERATOR_VALUE: "ParentStepIteratorValue",
  START_TIME_AFTER: "StartTimeAfter",
  START_TIME_BEFORE: "StartTimeBefore",
  STEP_EXECUTION_ID: "StepExecutionId",
  STEP_EXECUTION_STATUS: "StepExecutionStatus",
  STEP_NAME: "StepName"
};
var DocumentPermissionType = {
  SHARE: "Share"
};
var InvalidPermissionType = class _InvalidPermissionType extends SSMServiceException {
  static {
    __name(this, "InvalidPermissionType");
  }
  name = "InvalidPermissionType";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidPermissionType",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidPermissionType.prototype);
    this.Message = opts.Message;
  }
};
var PatchDeploymentStatus = {
  Approved: "APPROVED",
  ExplicitApproved: "EXPLICIT_APPROVED",
  ExplicitRejected: "EXPLICIT_REJECTED",
  PendingApproval: "PENDING_APPROVAL"
};
var UnsupportedOperatingSystem = class _UnsupportedOperatingSystem extends SSMServiceException {
  static {
    __name(this, "UnsupportedOperatingSystem");
  }
  name = "UnsupportedOperatingSystem";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "UnsupportedOperatingSystem",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _UnsupportedOperatingSystem.prototype);
    this.Message = opts.Message;
  }
};
var InstanceInformationFilterKey = {
  ACTIVATION_IDS: "ActivationIds",
  AGENT_VERSION: "AgentVersion",
  ASSOCIATION_STATUS: "AssociationStatus",
  IAM_ROLE: "IamRole",
  INSTANCE_IDS: "InstanceIds",
  PING_STATUS: "PingStatus",
  PLATFORM_TYPES: "PlatformTypes",
  RESOURCE_TYPE: "ResourceType"
};
var PingStatus = {
  CONNECTION_LOST: "ConnectionLost",
  INACTIVE: "Inactive",
  ONLINE: "Online"
};
var ResourceType = {
  EC2_INSTANCE: "EC2Instance",
  MANAGED_INSTANCE: "ManagedInstance"
};
var SourceType = {
  AWS_EC2_INSTANCE: "AWS::EC2::Instance",
  AWS_IOT_THING: "AWS::IoT::Thing",
  AWS_SSM_MANAGEDINSTANCE: "AWS::SSM::ManagedInstance"
};
var InvalidInstanceInformationFilterValue = class _InvalidInstanceInformationFilterValue extends SSMServiceException {
  static {
    __name(this, "InvalidInstanceInformationFilterValue");
  }
  name = "InvalidInstanceInformationFilterValue";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidInstanceInformationFilterValue",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidInstanceInformationFilterValue.prototype);
  }
};
var PatchComplianceDataState = {
  AvailableSecurityUpdate: "AVAILABLE_SECURITY_UPDATE",
  Failed: "FAILED",
  Installed: "INSTALLED",
  InstalledOther: "INSTALLED_OTHER",
  InstalledPendingReboot: "INSTALLED_PENDING_REBOOT",
  InstalledRejected: "INSTALLED_REJECTED",
  Missing: "MISSING",
  NotApplicable: "NOT_APPLICABLE"
};
var PatchOperationType = {
  INSTALL: "Install",
  SCAN: "Scan"
};
var RebootOption = {
  NO_REBOOT: "NoReboot",
  REBOOT_IF_NEEDED: "RebootIfNeeded"
};
var InstancePatchStateOperatorType = {
  EQUAL: "Equal",
  GREATER_THAN: "GreaterThan",
  LESS_THAN: "LessThan",
  NOT_EQUAL: "NotEqual"
};
var InstancePropertyFilterOperator = {
  BEGIN_WITH: "BeginWith",
  EQUAL: "Equal",
  GREATER_THAN: "GreaterThan",
  LESS_THAN: "LessThan",
  NOT_EQUAL: "NotEqual"
};
var InstancePropertyFilterKey = {
  ACTIVATION_IDS: "ActivationIds",
  AGENT_VERSION: "AgentVersion",
  ASSOCIATION_STATUS: "AssociationStatus",
  DOCUMENT_NAME: "DocumentName",
  IAM_ROLE: "IamRole",
  INSTANCE_IDS: "InstanceIds",
  PING_STATUS: "PingStatus",
  PLATFORM_TYPES: "PlatformTypes",
  RESOURCE_TYPE: "ResourceType"
};
var InvalidInstancePropertyFilterValue = class _InvalidInstancePropertyFilterValue extends SSMServiceException {
  static {
    __name(this, "InvalidInstancePropertyFilterValue");
  }
  name = "InvalidInstancePropertyFilterValue";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidInstancePropertyFilterValue",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidInstancePropertyFilterValue.prototype);
  }
};
var InventoryDeletionStatus = {
  COMPLETE: "Complete",
  IN_PROGRESS: "InProgress"
};
var InvalidDeletionIdException = class _InvalidDeletionIdException extends SSMServiceException {
  static {
    __name(this, "InvalidDeletionIdException");
  }
  name = "InvalidDeletionIdException";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidDeletionIdException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidDeletionIdException.prototype);
    this.Message = opts.Message;
  }
};
var MaintenanceWindowExecutionStatus = {
  Cancelled: "CANCELLED",
  Cancelling: "CANCELLING",
  Failed: "FAILED",
  InProgress: "IN_PROGRESS",
  Pending: "PENDING",
  SkippedOverlapping: "SKIPPED_OVERLAPPING",
  Success: "SUCCESS",
  TimedOut: "TIMED_OUT"
};
var MaintenanceWindowTaskType = {
  Automation: "AUTOMATION",
  Lambda: "LAMBDA",
  RunCommand: "RUN_COMMAND",
  StepFunctions: "STEP_FUNCTIONS"
};
var CreateAssociationRequestFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.Parameters && { Parameters: import_smithy_client.SENSITIVE_STRING }
}), "CreateAssociationRequestFilterSensitiveLog");
var AssociationDescriptionFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.Parameters && { Parameters: import_smithy_client.SENSITIVE_STRING }
}), "AssociationDescriptionFilterSensitiveLog");
var CreateAssociationResultFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.AssociationDescription && {
    AssociationDescription: AssociationDescriptionFilterSensitiveLog(obj.AssociationDescription)
  }
}), "CreateAssociationResultFilterSensitiveLog");
var CreateAssociationBatchRequestEntryFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.Parameters && { Parameters: import_smithy_client.SENSITIVE_STRING }
}), "CreateAssociationBatchRequestEntryFilterSensitiveLog");
var CreateAssociationBatchRequestFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.Entries && {
    Entries: obj.Entries.map((item) => CreateAssociationBatchRequestEntryFilterSensitiveLog(item))
  }
}), "CreateAssociationBatchRequestFilterSensitiveLog");
var FailedCreateAssociationFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.Entry && { Entry: CreateAssociationBatchRequestEntryFilterSensitiveLog(obj.Entry) }
}), "FailedCreateAssociationFilterSensitiveLog");
var CreateAssociationBatchResultFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.Successful && { Successful: obj.Successful.map((item) => AssociationDescriptionFilterSensitiveLog(item)) },
  ...obj.Failed && { Failed: obj.Failed.map((item) => FailedCreateAssociationFilterSensitiveLog(item)) }
}), "CreateAssociationBatchResultFilterSensitiveLog");
var CreateMaintenanceWindowRequestFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.Description && { Description: import_smithy_client.SENSITIVE_STRING }
}), "CreateMaintenanceWindowRequestFilterSensitiveLog");
var PatchSourceFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.Configuration && { Configuration: import_smithy_client.SENSITIVE_STRING }
}), "PatchSourceFilterSensitiveLog");
var CreatePatchBaselineRequestFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.Sources && { Sources: obj.Sources.map((item) => PatchSourceFilterSensitiveLog(item)) }
}), "CreatePatchBaselineRequestFilterSensitiveLog");
var DescribeAssociationResultFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.AssociationDescription && {
    AssociationDescription: AssociationDescriptionFilterSensitiveLog(obj.AssociationDescription)
  }
}), "DescribeAssociationResultFilterSensitiveLog");
var InstanceInformationFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.IPAddress && { IPAddress: import_smithy_client.SENSITIVE_STRING }
}), "InstanceInformationFilterSensitiveLog");
var DescribeInstanceInformationResultFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.InstanceInformationList && {
    InstanceInformationList: obj.InstanceInformationList.map((item) => InstanceInformationFilterSensitiveLog(item))
  }
}), "DescribeInstanceInformationResultFilterSensitiveLog");
var InstancePatchStateFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.OwnerInformation && { OwnerInformation: import_smithy_client.SENSITIVE_STRING }
}), "InstancePatchStateFilterSensitiveLog");
var DescribeInstancePatchStatesResultFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.InstancePatchStates && {
    InstancePatchStates: obj.InstancePatchStates.map((item) => InstancePatchStateFilterSensitiveLog(item))
  }
}), "DescribeInstancePatchStatesResultFilterSensitiveLog");
var DescribeInstancePatchStatesForPatchGroupResultFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.InstancePatchStates && {
    InstancePatchStates: obj.InstancePatchStates.map((item) => InstancePatchStateFilterSensitiveLog(item))
  }
}), "DescribeInstancePatchStatesForPatchGroupResultFilterSensitiveLog");
var InstancePropertyFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.IPAddress && { IPAddress: import_smithy_client.SENSITIVE_STRING }
}), "InstancePropertyFilterSensitiveLog");
var DescribeInstancePropertiesResultFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.InstanceProperties && {
    InstanceProperties: obj.InstanceProperties.map((item) => InstancePropertyFilterSensitiveLog(item))
  }
}), "DescribeInstancePropertiesResultFilterSensitiveLog");
var MaintenanceWindowExecutionTaskInvocationIdentityFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.Parameters && { Parameters: import_smithy_client.SENSITIVE_STRING },
  ...obj.OwnerInformation && { OwnerInformation: import_smithy_client.SENSITIVE_STRING }
}), "MaintenanceWindowExecutionTaskInvocationIdentityFilterSensitiveLog");
var DescribeMaintenanceWindowExecutionTaskInvocationsResultFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.WindowExecutionTaskInvocationIdentities && {
    WindowExecutionTaskInvocationIdentities: obj.WindowExecutionTaskInvocationIdentities.map(
      (item) => MaintenanceWindowExecutionTaskInvocationIdentityFilterSensitiveLog(item)
    )
  }
}), "DescribeMaintenanceWindowExecutionTaskInvocationsResultFilterSensitiveLog");
var MaintenanceWindowIdentityFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.Description && { Description: import_smithy_client.SENSITIVE_STRING }
}), "MaintenanceWindowIdentityFilterSensitiveLog");

// src/models/models_1.ts

var MaintenanceWindowResourceType = {
  Instance: "INSTANCE",
  ResourceGroup: "RESOURCE_GROUP"
};
var MaintenanceWindowTaskCutoffBehavior = {
  CancelTask: "CANCEL_TASK",
  ContinueTask: "CONTINUE_TASK"
};
var OpsItemFilterKey = {
  ACCESS_REQUEST_APPROVER_ARN: "AccessRequestByApproverArn",
  ACCESS_REQUEST_APPROVER_ID: "AccessRequestByApproverId",
  ACCESS_REQUEST_IS_REPLICA: "AccessRequestByIsReplica",
  ACCESS_REQUEST_REQUESTER_ARN: "AccessRequestByRequesterArn",
  ACCESS_REQUEST_REQUESTER_ID: "AccessRequestByRequesterId",
  ACCESS_REQUEST_SOURCE_ACCOUNT_ID: "AccessRequestBySourceAccountId",
  ACCESS_REQUEST_SOURCE_OPS_ITEM_ID: "AccessRequestBySourceOpsItemId",
  ACCESS_REQUEST_SOURCE_REGION: "AccessRequestBySourceRegion",
  ACCESS_REQUEST_TARGET_RESOURCE_ID: "AccessRequestByTargetResourceId",
  ACCOUNT_ID: "AccountId",
  ACTUAL_END_TIME: "ActualEndTime",
  ACTUAL_START_TIME: "ActualStartTime",
  AUTOMATION_ID: "AutomationId",
  CATEGORY: "Category",
  CHANGE_REQUEST_APPROVER_ARN: "ChangeRequestByApproverArn",
  CHANGE_REQUEST_APPROVER_NAME: "ChangeRequestByApproverName",
  CHANGE_REQUEST_REQUESTER_ARN: "ChangeRequestByRequesterArn",
  CHANGE_REQUEST_REQUESTER_NAME: "ChangeRequestByRequesterName",
  CHANGE_REQUEST_TARGETS_RESOURCE_GROUP: "ChangeRequestByTargetsResourceGroup",
  CHANGE_REQUEST_TEMPLATE: "ChangeRequestByTemplate",
  CREATED_BY: "CreatedBy",
  CREATED_TIME: "CreatedTime",
  INSIGHT_TYPE: "InsightByType",
  LAST_MODIFIED_TIME: "LastModifiedTime",
  OPERATIONAL_DATA: "OperationalData",
  OPERATIONAL_DATA_KEY: "OperationalDataKey",
  OPERATIONAL_DATA_VALUE: "OperationalDataValue",
  OPSITEM_ID: "OpsItemId",
  OPSITEM_TYPE: "OpsItemType",
  PLANNED_END_TIME: "PlannedEndTime",
  PLANNED_START_TIME: "PlannedStartTime",
  PRIORITY: "Priority",
  RESOURCE_ID: "ResourceId",
  SEVERITY: "Severity",
  SOURCE: "Source",
  STATUS: "Status",
  TITLE: "Title"
};
var OpsItemFilterOperator = {
  CONTAINS: "Contains",
  EQUAL: "Equal",
  GREATER_THAN: "GreaterThan",
  LESS_THAN: "LessThan"
};
var OpsItemStatus = {
  APPROVED: "Approved",
  CANCELLED: "Cancelled",
  CANCELLING: "Cancelling",
  CHANGE_CALENDAR_OVERRIDE_APPROVED: "ChangeCalendarOverrideApproved",
  CHANGE_CALENDAR_OVERRIDE_REJECTED: "ChangeCalendarOverrideRejected",
  CLOSED: "Closed",
  COMPLETED_WITH_FAILURE: "CompletedWithFailure",
  COMPLETED_WITH_SUCCESS: "CompletedWithSuccess",
  FAILED: "Failed",
  IN_PROGRESS: "InProgress",
  OPEN: "Open",
  PENDING: "Pending",
  PENDING_APPROVAL: "PendingApproval",
  PENDING_CHANGE_CALENDAR_OVERRIDE: "PendingChangeCalendarOverride",
  REJECTED: "Rejected",
  RESOLVED: "Resolved",
  REVOKED: "Revoked",
  RUNBOOK_IN_PROGRESS: "RunbookInProgress",
  SCHEDULED: "Scheduled",
  TIMED_OUT: "TimedOut"
};
var ParametersFilterKey = {
  KEY_ID: "KeyId",
  NAME: "Name",
  TYPE: "Type"
};
var ParameterTier = {
  ADVANCED: "Advanced",
  INTELLIGENT_TIERING: "Intelligent-Tiering",
  STANDARD: "Standard"
};
var ParameterType = {
  SECURE_STRING: "SecureString",
  STRING: "String",
  STRING_LIST: "StringList"
};
var InvalidFilterOption = class _InvalidFilterOption extends SSMServiceException {
  static {
    __name(this, "InvalidFilterOption");
  }
  name = "InvalidFilterOption";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidFilterOption",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidFilterOption.prototype);
  }
};
var PatchSet = {
  Application: "APPLICATION",
  Os: "OS"
};
var PatchProperty = {
  PatchClassification: "CLASSIFICATION",
  PatchMsrcSeverity: "MSRC_SEVERITY",
  PatchPriority: "PRIORITY",
  PatchProductFamily: "PRODUCT_FAMILY",
  PatchSeverity: "SEVERITY",
  Product: "PRODUCT"
};
var SessionFilterKey = {
  ACCESS_TYPE: "AccessType",
  INVOKED_AFTER: "InvokedAfter",
  INVOKED_BEFORE: "InvokedBefore",
  OWNER: "Owner",
  SESSION_ID: "SessionId",
  STATUS: "Status",
  TARGET_ID: "Target"
};
var SessionState = {
  ACTIVE: "Active",
  HISTORY: "History"
};
var SessionStatus = {
  CONNECTED: "Connected",
  CONNECTING: "Connecting",
  DISCONNECTED: "Disconnected",
  FAILED: "Failed",
  TERMINATED: "Terminated",
  TERMINATING: "Terminating"
};
var OpsItemRelatedItemAssociationNotFoundException = class _OpsItemRelatedItemAssociationNotFoundException extends SSMServiceException {
  static {
    __name(this, "OpsItemRelatedItemAssociationNotFoundException");
  }
  name = "OpsItemRelatedItemAssociationNotFoundException";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "OpsItemRelatedItemAssociationNotFoundException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _OpsItemRelatedItemAssociationNotFoundException.prototype);
    this.Message = opts.Message;
  }
};
var ThrottlingException = class _ThrottlingException extends SSMServiceException {
  static {
    __name(this, "ThrottlingException");
  }
  name = "ThrottlingException";
  $fault = "client";
  Message;
  /**
   * <p>The quota code recognized by the Amazon Web Services Service Quotas service.</p>
   * @public
   */
  QuotaCode;
  /**
   * <p>The code for the Amazon Web Services service that owns the quota.</p>
   * @public
   */
  ServiceCode;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ThrottlingException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ThrottlingException.prototype);
    this.Message = opts.Message;
    this.QuotaCode = opts.QuotaCode;
    this.ServiceCode = opts.ServiceCode;
  }
};
var ValidationException = class _ValidationException extends SSMServiceException {
  static {
    __name(this, "ValidationException");
  }
  name = "ValidationException";
  $fault = "client";
  Message;
  /**
   * <p>The reason code for the invalid request.</p>
   * @public
   */
  ReasonCode;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ValidationException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ValidationException.prototype);
    this.Message = opts.Message;
    this.ReasonCode = opts.ReasonCode;
  }
};
var CalendarState = {
  CLOSED: "CLOSED",
  OPEN: "OPEN"
};
var InvalidDocumentType = class _InvalidDocumentType extends SSMServiceException {
  static {
    __name(this, "InvalidDocumentType");
  }
  name = "InvalidDocumentType";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidDocumentType",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidDocumentType.prototype);
    this.Message = opts.Message;
  }
};
var UnsupportedCalendarException = class _UnsupportedCalendarException extends SSMServiceException {
  static {
    __name(this, "UnsupportedCalendarException");
  }
  name = "UnsupportedCalendarException";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "UnsupportedCalendarException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _UnsupportedCalendarException.prototype);
    this.Message = opts.Message;
  }
};
var CommandInvocationStatus = {
  CANCELLED: "Cancelled",
  CANCELLING: "Cancelling",
  DELAYED: "Delayed",
  FAILED: "Failed",
  IN_PROGRESS: "InProgress",
  PENDING: "Pending",
  SUCCESS: "Success",
  TIMED_OUT: "TimedOut"
};
var InvalidPluginName = class _InvalidPluginName extends SSMServiceException {
  static {
    __name(this, "InvalidPluginName");
  }
  name = "InvalidPluginName";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidPluginName",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidPluginName.prototype);
  }
};
var InvocationDoesNotExist = class _InvocationDoesNotExist extends SSMServiceException {
  static {
    __name(this, "InvocationDoesNotExist");
  }
  name = "InvocationDoesNotExist";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvocationDoesNotExist",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvocationDoesNotExist.prototype);
  }
};
var ConnectionStatus = {
  CONNECTED: "connected",
  NOT_CONNECTED: "notconnected"
};
var UnsupportedFeatureRequiredException = class _UnsupportedFeatureRequiredException extends SSMServiceException {
  static {
    __name(this, "UnsupportedFeatureRequiredException");
  }
  name = "UnsupportedFeatureRequiredException";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "UnsupportedFeatureRequiredException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _UnsupportedFeatureRequiredException.prototype);
    this.Message = opts.Message;
  }
};
var AttachmentHashType = {
  SHA256: "Sha256"
};
var ImpactType = {
  MUTATING: "Mutating",
  NON_MUTATING: "NonMutating",
  UNDETERMINED: "Undetermined"
};
var ExecutionPreview;
((ExecutionPreview2) => {
  ExecutionPreview2.visit = /* @__PURE__ */ __name((value, visitor) => {
    if (value.Automation !== void 0) return visitor.Automation(value.Automation);
    return visitor._(value.$unknown[0], value.$unknown[1]);
  }, "visit");
})(ExecutionPreview || (ExecutionPreview = {}));
var ExecutionPreviewStatus = {
  FAILED: "Failed",
  IN_PROGRESS: "InProgress",
  PENDING: "Pending",
  SUCCESS: "Success"
};
var InventoryQueryOperatorType = {
  BEGIN_WITH: "BeginWith",
  EQUAL: "Equal",
  EXISTS: "Exists",
  GREATER_THAN: "GreaterThan",
  LESS_THAN: "LessThan",
  NOT_EQUAL: "NotEqual"
};
var InvalidAggregatorException = class _InvalidAggregatorException extends SSMServiceException {
  static {
    __name(this, "InvalidAggregatorException");
  }
  name = "InvalidAggregatorException";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidAggregatorException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidAggregatorException.prototype);
    this.Message = opts.Message;
  }
};
var InvalidInventoryGroupException = class _InvalidInventoryGroupException extends SSMServiceException {
  static {
    __name(this, "InvalidInventoryGroupException");
  }
  name = "InvalidInventoryGroupException";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidInventoryGroupException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidInventoryGroupException.prototype);
    this.Message = opts.Message;
  }
};
var InvalidResultAttributeException = class _InvalidResultAttributeException extends SSMServiceException {
  static {
    __name(this, "InvalidResultAttributeException");
  }
  name = "InvalidResultAttributeException";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidResultAttributeException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidResultAttributeException.prototype);
    this.Message = opts.Message;
  }
};
var InventoryAttributeDataType = {
  NUMBER: "number",
  STRING: "string"
};
var NotificationEvent = {
  ALL: "All",
  CANCELLED: "Cancelled",
  FAILED: "Failed",
  IN_PROGRESS: "InProgress",
  SUCCESS: "Success",
  TIMED_OUT: "TimedOut"
};
var NotificationType = {
  Command: "Command",
  Invocation: "Invocation"
};
var OpsFilterOperatorType = {
  BEGIN_WITH: "BeginWith",
  EQUAL: "Equal",
  EXISTS: "Exists",
  GREATER_THAN: "GreaterThan",
  LESS_THAN: "LessThan",
  NOT_EQUAL: "NotEqual"
};
var InvalidKeyId = class _InvalidKeyId extends SSMServiceException {
  static {
    __name(this, "InvalidKeyId");
  }
  name = "InvalidKeyId";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidKeyId",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidKeyId.prototype);
  }
};
var ParameterVersionNotFound = class _ParameterVersionNotFound extends SSMServiceException {
  static {
    __name(this, "ParameterVersionNotFound");
  }
  name = "ParameterVersionNotFound";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ParameterVersionNotFound",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ParameterVersionNotFound.prototype);
  }
};
var ServiceSettingNotFound = class _ServiceSettingNotFound extends SSMServiceException {
  static {
    __name(this, "ServiceSettingNotFound");
  }
  name = "ServiceSettingNotFound";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ServiceSettingNotFound",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ServiceSettingNotFound.prototype);
    this.Message = opts.Message;
  }
};
var ParameterVersionLabelLimitExceeded = class _ParameterVersionLabelLimitExceeded extends SSMServiceException {
  static {
    __name(this, "ParameterVersionLabelLimitExceeded");
  }
  name = "ParameterVersionLabelLimitExceeded";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ParameterVersionLabelLimitExceeded",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ParameterVersionLabelLimitExceeded.prototype);
  }
};
var AssociationFilterKey = {
  AssociationId: "AssociationId",
  AssociationName: "AssociationName",
  InstanceId: "InstanceId",
  LastExecutedAfter: "LastExecutedAfter",
  LastExecutedBefore: "LastExecutedBefore",
  Name: "Name",
  ResourceGroupName: "ResourceGroupName",
  Status: "AssociationStatusName"
};
var CommandFilterKey = {
  DOCUMENT_NAME: "DocumentName",
  EXECUTION_STAGE: "ExecutionStage",
  INVOKED_AFTER: "InvokedAfter",
  INVOKED_BEFORE: "InvokedBefore",
  STATUS: "Status"
};
var CommandPluginStatus = {
  CANCELLED: "Cancelled",
  FAILED: "Failed",
  IN_PROGRESS: "InProgress",
  PENDING: "Pending",
  SUCCESS: "Success",
  TIMED_OUT: "TimedOut"
};
var CommandStatus = {
  CANCELLED: "Cancelled",
  CANCELLING: "Cancelling",
  FAILED: "Failed",
  IN_PROGRESS: "InProgress",
  PENDING: "Pending",
  SUCCESS: "Success",
  TIMED_OUT: "TimedOut"
};
var ComplianceQueryOperatorType = {
  BeginWith: "BEGIN_WITH",
  Equal: "EQUAL",
  GreaterThan: "GREATER_THAN",
  LessThan: "LESS_THAN",
  NotEqual: "NOT_EQUAL"
};
var ComplianceSeverity = {
  Critical: "CRITICAL",
  High: "HIGH",
  Informational: "INFORMATIONAL",
  Low: "LOW",
  Medium: "MEDIUM",
  Unspecified: "UNSPECIFIED"
};
var ComplianceStatus = {
  Compliant: "COMPLIANT",
  NonCompliant: "NON_COMPLIANT"
};
var DocumentMetadataEnum = {
  DocumentReviews: "DocumentReviews"
};
var DocumentReviewCommentType = {
  Comment: "Comment"
};
var DocumentFilterKey = {
  DocumentType: "DocumentType",
  Name: "Name",
  Owner: "Owner",
  PlatformTypes: "PlatformTypes"
};
var NodeFilterKey = {
  ACCOUNT_ID: "AccountId",
  AGENT_TYPE: "AgentType",
  AGENT_VERSION: "AgentVersion",
  COMPUTER_NAME: "ComputerName",
  INSTANCE_ID: "InstanceId",
  INSTANCE_STATUS: "InstanceStatus",
  IP_ADDRESS: "IpAddress",
  MANAGED_STATUS: "ManagedStatus",
  ORGANIZATIONAL_UNIT_ID: "OrganizationalUnitId",
  ORGANIZATIONAL_UNIT_PATH: "OrganizationalUnitPath",
  PLATFORM_NAME: "PlatformName",
  PLATFORM_TYPE: "PlatformType",
  PLATFORM_VERSION: "PlatformVersion",
  REGION: "Region",
  RESOURCE_TYPE: "ResourceType"
};
var NodeFilterOperatorType = {
  BEGIN_WITH: "BeginWith",
  EQUAL: "Equal",
  NOT_EQUAL: "NotEqual"
};
var ManagedStatus = {
  ALL: "All",
  MANAGED: "Managed",
  UNMANAGED: "Unmanaged"
};
var NodeType;
((NodeType2) => {
  NodeType2.visit = /* @__PURE__ */ __name((value, visitor) => {
    if (value.Instance !== void 0) return visitor.Instance(value.Instance);
    return visitor._(value.$unknown[0], value.$unknown[1]);
  }, "visit");
})(NodeType || (NodeType = {}));
var UnsupportedOperationException = class _UnsupportedOperationException extends SSMServiceException {
  static {
    __name(this, "UnsupportedOperationException");
  }
  name = "UnsupportedOperationException";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "UnsupportedOperationException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _UnsupportedOperationException.prototype);
    this.Message = opts.Message;
  }
};
var NodeAggregatorType = {
  COUNT: "Count"
};
var NodeAttributeName = {
  AGENT_VERSION: "AgentVersion",
  PLATFORM_NAME: "PlatformName",
  PLATFORM_TYPE: "PlatformType",
  PLATFORM_VERSION: "PlatformVersion",
  REGION: "Region",
  RESOURCE_TYPE: "ResourceType"
};
var NodeTypeName = {
  INSTANCE: "Instance"
};
var OpsItemEventFilterKey = {
  OPSITEM_ID: "OpsItemId"
};
var OpsItemEventFilterOperator = {
  EQUAL: "Equal"
};
var OpsItemRelatedItemsFilterKey = {
  ASSOCIATION_ID: "AssociationId",
  RESOURCE_TYPE: "ResourceType",
  RESOURCE_URI: "ResourceUri"
};
var OpsItemRelatedItemsFilterOperator = {
  EQUAL: "Equal"
};
var LastResourceDataSyncStatus = {
  FAILED: "Failed",
  INPROGRESS: "InProgress",
  SUCCESSFUL: "Successful"
};
var DocumentPermissionLimit = class _DocumentPermissionLimit extends SSMServiceException {
  static {
    __name(this, "DocumentPermissionLimit");
  }
  name = "DocumentPermissionLimit";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DocumentPermissionLimit",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _DocumentPermissionLimit.prototype);
    this.Message = opts.Message;
  }
};
var ComplianceTypeCountLimitExceededException = class _ComplianceTypeCountLimitExceededException extends SSMServiceException {
  static {
    __name(this, "ComplianceTypeCountLimitExceededException");
  }
  name = "ComplianceTypeCountLimitExceededException";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ComplianceTypeCountLimitExceededException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ComplianceTypeCountLimitExceededException.prototype);
    this.Message = opts.Message;
  }
};
var InvalidItemContentException = class _InvalidItemContentException extends SSMServiceException {
  static {
    __name(this, "InvalidItemContentException");
  }
  name = "InvalidItemContentException";
  $fault = "client";
  TypeName;
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidItemContentException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidItemContentException.prototype);
    this.TypeName = opts.TypeName;
    this.Message = opts.Message;
  }
};
var ItemSizeLimitExceededException = class _ItemSizeLimitExceededException extends SSMServiceException {
  static {
    __name(this, "ItemSizeLimitExceededException");
  }
  name = "ItemSizeLimitExceededException";
  $fault = "client";
  TypeName;
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ItemSizeLimitExceededException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ItemSizeLimitExceededException.prototype);
    this.TypeName = opts.TypeName;
    this.Message = opts.Message;
  }
};
var ComplianceUploadType = {
  Complete: "COMPLETE",
  Partial: "PARTIAL"
};
var TotalSizeLimitExceededException = class _TotalSizeLimitExceededException extends SSMServiceException {
  static {
    __name(this, "TotalSizeLimitExceededException");
  }
  name = "TotalSizeLimitExceededException";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TotalSizeLimitExceededException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TotalSizeLimitExceededException.prototype);
    this.Message = opts.Message;
  }
};
var CustomSchemaCountLimitExceededException = class _CustomSchemaCountLimitExceededException extends SSMServiceException {
  static {
    __name(this, "CustomSchemaCountLimitExceededException");
  }
  name = "CustomSchemaCountLimitExceededException";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "CustomSchemaCountLimitExceededException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _CustomSchemaCountLimitExceededException.prototype);
    this.Message = opts.Message;
  }
};
var InvalidInventoryItemContextException = class _InvalidInventoryItemContextException extends SSMServiceException {
  static {
    __name(this, "InvalidInventoryItemContextException");
  }
  name = "InvalidInventoryItemContextException";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidInventoryItemContextException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidInventoryItemContextException.prototype);
    this.Message = opts.Message;
  }
};
var ItemContentMismatchException = class _ItemContentMismatchException extends SSMServiceException {
  static {
    __name(this, "ItemContentMismatchException");
  }
  name = "ItemContentMismatchException";
  $fault = "client";
  TypeName;
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ItemContentMismatchException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ItemContentMismatchException.prototype);
    this.TypeName = opts.TypeName;
    this.Message = opts.Message;
  }
};
var SubTypeCountLimitExceededException = class _SubTypeCountLimitExceededException extends SSMServiceException {
  static {
    __name(this, "SubTypeCountLimitExceededException");
  }
  name = "SubTypeCountLimitExceededException";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "SubTypeCountLimitExceededException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _SubTypeCountLimitExceededException.prototype);
    this.Message = opts.Message;
  }
};
var UnsupportedInventoryItemContextException = class _UnsupportedInventoryItemContextException extends SSMServiceException {
  static {
    __name(this, "UnsupportedInventoryItemContextException");
  }
  name = "UnsupportedInventoryItemContextException";
  $fault = "client";
  TypeName;
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "UnsupportedInventoryItemContextException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _UnsupportedInventoryItemContextException.prototype);
    this.TypeName = opts.TypeName;
    this.Message = opts.Message;
  }
};
var UnsupportedInventorySchemaVersionException = class _UnsupportedInventorySchemaVersionException extends SSMServiceException {
  static {
    __name(this, "UnsupportedInventorySchemaVersionException");
  }
  name = "UnsupportedInventorySchemaVersionException";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "UnsupportedInventorySchemaVersionException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _UnsupportedInventorySchemaVersionException.prototype);
    this.Message = opts.Message;
  }
};
var HierarchyLevelLimitExceededException = class _HierarchyLevelLimitExceededException extends SSMServiceException {
  static {
    __name(this, "HierarchyLevelLimitExceededException");
  }
  name = "HierarchyLevelLimitExceededException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "HierarchyLevelLimitExceededException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _HierarchyLevelLimitExceededException.prototype);
  }
};
var HierarchyTypeMismatchException = class _HierarchyTypeMismatchException extends SSMServiceException {
  static {
    __name(this, "HierarchyTypeMismatchException");
  }
  name = "HierarchyTypeMismatchException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "HierarchyTypeMismatchException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _HierarchyTypeMismatchException.prototype);
  }
};
var IncompatiblePolicyException = class _IncompatiblePolicyException extends SSMServiceException {
  static {
    __name(this, "IncompatiblePolicyException");
  }
  name = "IncompatiblePolicyException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "IncompatiblePolicyException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _IncompatiblePolicyException.prototype);
  }
};
var InvalidAllowedPatternException = class _InvalidAllowedPatternException extends SSMServiceException {
  static {
    __name(this, "InvalidAllowedPatternException");
  }
  name = "InvalidAllowedPatternException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidAllowedPatternException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidAllowedPatternException.prototype);
  }
};
var InvalidPolicyAttributeException = class _InvalidPolicyAttributeException extends SSMServiceException {
  static {
    __name(this, "InvalidPolicyAttributeException");
  }
  name = "InvalidPolicyAttributeException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidPolicyAttributeException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidPolicyAttributeException.prototype);
  }
};
var InvalidPolicyTypeException = class _InvalidPolicyTypeException extends SSMServiceException {
  static {
    __name(this, "InvalidPolicyTypeException");
  }
  name = "InvalidPolicyTypeException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidPolicyTypeException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidPolicyTypeException.prototype);
  }
};
var ParameterAlreadyExists = class _ParameterAlreadyExists extends SSMServiceException {
  static {
    __name(this, "ParameterAlreadyExists");
  }
  name = "ParameterAlreadyExists";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ParameterAlreadyExists",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ParameterAlreadyExists.prototype);
  }
};
var ParameterLimitExceeded = class _ParameterLimitExceeded extends SSMServiceException {
  static {
    __name(this, "ParameterLimitExceeded");
  }
  name = "ParameterLimitExceeded";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ParameterLimitExceeded",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ParameterLimitExceeded.prototype);
  }
};
var ParameterMaxVersionLimitExceeded = class _ParameterMaxVersionLimitExceeded extends SSMServiceException {
  static {
    __name(this, "ParameterMaxVersionLimitExceeded");
  }
  name = "ParameterMaxVersionLimitExceeded";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ParameterMaxVersionLimitExceeded",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ParameterMaxVersionLimitExceeded.prototype);
  }
};
var ParameterPatternMismatchException = class _ParameterPatternMismatchException extends SSMServiceException {
  static {
    __name(this, "ParameterPatternMismatchException");
  }
  name = "ParameterPatternMismatchException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ParameterPatternMismatchException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ParameterPatternMismatchException.prototype);
  }
};
var PoliciesLimitExceededException = class _PoliciesLimitExceededException extends SSMServiceException {
  static {
    __name(this, "PoliciesLimitExceededException");
  }
  name = "PoliciesLimitExceededException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "PoliciesLimitExceededException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _PoliciesLimitExceededException.prototype);
  }
};
var UnsupportedParameterType = class _UnsupportedParameterType extends SSMServiceException {
  static {
    __name(this, "UnsupportedParameterType");
  }
  name = "UnsupportedParameterType";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "UnsupportedParameterType",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _UnsupportedParameterType.prototype);
  }
};
var ResourcePolicyLimitExceededException = class _ResourcePolicyLimitExceededException extends SSMServiceException {
  static {
    __name(this, "ResourcePolicyLimitExceededException");
  }
  name = "ResourcePolicyLimitExceededException";
  $fault = "client";
  Limit;
  LimitType;
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ResourcePolicyLimitExceededException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ResourcePolicyLimitExceededException.prototype);
    this.Limit = opts.Limit;
    this.LimitType = opts.LimitType;
    this.Message = opts.Message;
  }
};
var DescribeMaintenanceWindowsResultFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.WindowIdentities && {
    WindowIdentities: obj.WindowIdentities.map((item) => MaintenanceWindowIdentityFilterSensitiveLog(item))
  }
}), "DescribeMaintenanceWindowsResultFilterSensitiveLog");
var MaintenanceWindowTargetFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.OwnerInformation && { OwnerInformation: import_smithy_client.SENSITIVE_STRING },
  ...obj.Description && { Description: import_smithy_client.SENSITIVE_STRING }
}), "MaintenanceWindowTargetFilterSensitiveLog");
var DescribeMaintenanceWindowTargetsResultFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.Targets && { Targets: obj.Targets.map((item) => MaintenanceWindowTargetFilterSensitiveLog(item)) }
}), "DescribeMaintenanceWindowTargetsResultFilterSensitiveLog");
var MaintenanceWindowTaskParameterValueExpressionFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.Values && { Values: import_smithy_client.SENSITIVE_STRING }
}), "MaintenanceWindowTaskParameterValueExpressionFilterSensitiveLog");
var MaintenanceWindowTaskFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.TaskParameters && { TaskParameters: import_smithy_client.SENSITIVE_STRING },
  ...obj.Description && { Description: import_smithy_client.SENSITIVE_STRING }
}), "MaintenanceWindowTaskFilterSensitiveLog");
var DescribeMaintenanceWindowTasksResultFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.Tasks && { Tasks: obj.Tasks.map((item) => MaintenanceWindowTaskFilterSensitiveLog(item)) }
}), "DescribeMaintenanceWindowTasksResultFilterSensitiveLog");
var CredentialsFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.SecretAccessKey && { SecretAccessKey: import_smithy_client.SENSITIVE_STRING },
  ...obj.SessionToken && { SessionToken: import_smithy_client.SENSITIVE_STRING }
}), "CredentialsFilterSensitiveLog");
var GetAccessTokenResponseFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.Credentials && { Credentials: CredentialsFilterSensitiveLog(obj.Credentials) }
}), "GetAccessTokenResponseFilterSensitiveLog");
var BaselineOverrideFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.Sources && { Sources: obj.Sources.map((item) => PatchSourceFilterSensitiveLog(item)) }
}), "BaselineOverrideFilterSensitiveLog");
var GetDeployablePatchSnapshotForInstanceRequestFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj
}), "GetDeployablePatchSnapshotForInstanceRequestFilterSensitiveLog");
var GetMaintenanceWindowResultFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.Description && { Description: import_smithy_client.SENSITIVE_STRING }
}), "GetMaintenanceWindowResultFilterSensitiveLog");
var GetMaintenanceWindowExecutionTaskResultFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.TaskParameters && { TaskParameters: import_smithy_client.SENSITIVE_STRING }
}), "GetMaintenanceWindowExecutionTaskResultFilterSensitiveLog");
var GetMaintenanceWindowExecutionTaskInvocationResultFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.Parameters && { Parameters: import_smithy_client.SENSITIVE_STRING },
  ...obj.OwnerInformation && { OwnerInformation: import_smithy_client.SENSITIVE_STRING }
}), "GetMaintenanceWindowExecutionTaskInvocationResultFilterSensitiveLog");
var MaintenanceWindowLambdaParametersFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.Payload && { Payload: import_smithy_client.SENSITIVE_STRING }
}), "MaintenanceWindowLambdaParametersFilterSensitiveLog");
var MaintenanceWindowRunCommandParametersFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.Parameters && { Parameters: import_smithy_client.SENSITIVE_STRING }
}), "MaintenanceWindowRunCommandParametersFilterSensitiveLog");
var MaintenanceWindowStepFunctionsParametersFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.Input && { Input: import_smithy_client.SENSITIVE_STRING }
}), "MaintenanceWindowStepFunctionsParametersFilterSensitiveLog");
var MaintenanceWindowTaskInvocationParametersFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.RunCommand && { RunCommand: MaintenanceWindowRunCommandParametersFilterSensitiveLog(obj.RunCommand) },
  ...obj.StepFunctions && {
    StepFunctions: MaintenanceWindowStepFunctionsParametersFilterSensitiveLog(obj.StepFunctions)
  },
  ...obj.Lambda && { Lambda: MaintenanceWindowLambdaParametersFilterSensitiveLog(obj.Lambda) }
}), "MaintenanceWindowTaskInvocationParametersFilterSensitiveLog");
var GetMaintenanceWindowTaskResultFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.TaskParameters && { TaskParameters: import_smithy_client.SENSITIVE_STRING },
  ...obj.TaskInvocationParameters && {
    TaskInvocationParameters: MaintenanceWindowTaskInvocationParametersFilterSensitiveLog(obj.TaskInvocationParameters)
  },
  ...obj.Description && { Description: import_smithy_client.SENSITIVE_STRING }
}), "GetMaintenanceWindowTaskResultFilterSensitiveLog");
var ParameterFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.Value && { Value: import_smithy_client.SENSITIVE_STRING }
}), "ParameterFilterSensitiveLog");
var GetParameterResultFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.Parameter && { Parameter: ParameterFilterSensitiveLog(obj.Parameter) }
}), "GetParameterResultFilterSensitiveLog");
var ParameterHistoryFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.Value && { Value: import_smithy_client.SENSITIVE_STRING }
}), "ParameterHistoryFilterSensitiveLog");
var GetParameterHistoryResultFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.Parameters && { Parameters: obj.Parameters.map((item) => ParameterHistoryFilterSensitiveLog(item)) }
}), "GetParameterHistoryResultFilterSensitiveLog");
var GetParametersResultFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.Parameters && { Parameters: obj.Parameters.map((item) => ParameterFilterSensitiveLog(item)) }
}), "GetParametersResultFilterSensitiveLog");
var GetParametersByPathResultFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.Parameters && { Parameters: obj.Parameters.map((item) => ParameterFilterSensitiveLog(item)) }
}), "GetParametersByPathResultFilterSensitiveLog");
var GetPatchBaselineResultFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.Sources && { Sources: obj.Sources.map((item) => PatchSourceFilterSensitiveLog(item)) }
}), "GetPatchBaselineResultFilterSensitiveLog");
var AssociationVersionInfoFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.Parameters && { Parameters: import_smithy_client.SENSITIVE_STRING }
}), "AssociationVersionInfoFilterSensitiveLog");
var ListAssociationVersionsResultFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.AssociationVersions && {
    AssociationVersions: obj.AssociationVersions.map((item) => AssociationVersionInfoFilterSensitiveLog(item))
  }
}), "ListAssociationVersionsResultFilterSensitiveLog");
var CommandFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.Parameters && { Parameters: import_smithy_client.SENSITIVE_STRING }
}), "CommandFilterSensitiveLog");
var ListCommandsResultFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.Commands && { Commands: obj.Commands.map((item) => CommandFilterSensitiveLog(item)) }
}), "ListCommandsResultFilterSensitiveLog");
var InstanceInfoFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.IpAddress && { IpAddress: import_smithy_client.SENSITIVE_STRING }
}), "InstanceInfoFilterSensitiveLog");
var NodeTypeFilterSensitiveLog = /* @__PURE__ */ __name((obj) => {
  if (obj.Instance !== void 0) return { Instance: InstanceInfoFilterSensitiveLog(obj.Instance) };
  if (obj.$unknown !== void 0) return { [obj.$unknown[0]]: "UNKNOWN" };
}, "NodeTypeFilterSensitiveLog");
var NodeFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.NodeType && { NodeType: NodeTypeFilterSensitiveLog(obj.NodeType) }
}), "NodeFilterSensitiveLog");
var ListNodesResultFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.Nodes && { Nodes: obj.Nodes.map((item) => NodeFilterSensitiveLog(item)) }
}), "ListNodesResultFilterSensitiveLog");
var PutParameterRequestFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.Value && { Value: import_smithy_client.SENSITIVE_STRING }
}), "PutParameterRequestFilterSensitiveLog");

// src/models/models_2.ts

var FeatureNotAvailableException = class _FeatureNotAvailableException extends SSMServiceException {
  static {
    __name(this, "FeatureNotAvailableException");
  }
  name = "FeatureNotAvailableException";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "FeatureNotAvailableException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _FeatureNotAvailableException.prototype);
    this.Message = opts.Message;
  }
};
var AutomationStepNotFoundException = class _AutomationStepNotFoundException extends SSMServiceException {
  static {
    __name(this, "AutomationStepNotFoundException");
  }
  name = "AutomationStepNotFoundException";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "AutomationStepNotFoundException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _AutomationStepNotFoundException.prototype);
    this.Message = opts.Message;
  }
};
var InvalidAutomationSignalException = class _InvalidAutomationSignalException extends SSMServiceException {
  static {
    __name(this, "InvalidAutomationSignalException");
  }
  name = "InvalidAutomationSignalException";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidAutomationSignalException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidAutomationSignalException.prototype);
    this.Message = opts.Message;
  }
};
var SignalType = {
  APPROVE: "Approve",
  REJECT: "Reject",
  RESUME: "Resume",
  REVOKE: "Revoke",
  START_STEP: "StartStep",
  STOP_STEP: "StopStep"
};
var InvalidNotificationConfig = class _InvalidNotificationConfig extends SSMServiceException {
  static {
    __name(this, "InvalidNotificationConfig");
  }
  name = "InvalidNotificationConfig";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidNotificationConfig",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidNotificationConfig.prototype);
    this.Message = opts.Message;
  }
};
var InvalidOutputFolder = class _InvalidOutputFolder extends SSMServiceException {
  static {
    __name(this, "InvalidOutputFolder");
  }
  name = "InvalidOutputFolder";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidOutputFolder",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidOutputFolder.prototype);
  }
};
var InvalidRole = class _InvalidRole extends SSMServiceException {
  static {
    __name(this, "InvalidRole");
  }
  name = "InvalidRole";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidRole",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidRole.prototype);
    this.Message = opts.Message;
  }
};
var ServiceQuotaExceededException = class _ServiceQuotaExceededException extends SSMServiceException {
  static {
    __name(this, "ServiceQuotaExceededException");
  }
  name = "ServiceQuotaExceededException";
  $fault = "client";
  Message;
  /**
   * <p>The unique ID of the resource referenced in the failed request.</p>
   * @public
   */
  ResourceId;
  /**
   * <p>The resource type of the resource referenced in the failed request.</p>
   * @public
   */
  ResourceType;
  /**
   * <p>The quota code recognized by the Amazon Web Services Service Quotas service.</p>
   * @public
   */
  QuotaCode;
  /**
   * <p>The code for the Amazon Web Services service that owns the quota.</p>
   * @public
   */
  ServiceCode;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ServiceQuotaExceededException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ServiceQuotaExceededException.prototype);
    this.Message = opts.Message;
    this.ResourceId = opts.ResourceId;
    this.ResourceType = opts.ResourceType;
    this.QuotaCode = opts.QuotaCode;
    this.ServiceCode = opts.ServiceCode;
  }
};
var InvalidAssociation = class _InvalidAssociation extends SSMServiceException {
  static {
    __name(this, "InvalidAssociation");
  }
  name = "InvalidAssociation";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidAssociation",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidAssociation.prototype);
    this.Message = opts.Message;
  }
};
var AutomationDefinitionNotFoundException = class _AutomationDefinitionNotFoundException extends SSMServiceException {
  static {
    __name(this, "AutomationDefinitionNotFoundException");
  }
  name = "AutomationDefinitionNotFoundException";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "AutomationDefinitionNotFoundException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _AutomationDefinitionNotFoundException.prototype);
    this.Message = opts.Message;
  }
};
var AutomationDefinitionVersionNotFoundException = class _AutomationDefinitionVersionNotFoundException extends SSMServiceException {
  static {
    __name(this, "AutomationDefinitionVersionNotFoundException");
  }
  name = "AutomationDefinitionVersionNotFoundException";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "AutomationDefinitionVersionNotFoundException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _AutomationDefinitionVersionNotFoundException.prototype);
    this.Message = opts.Message;
  }
};
var AutomationExecutionLimitExceededException = class _AutomationExecutionLimitExceededException extends SSMServiceException {
  static {
    __name(this, "AutomationExecutionLimitExceededException");
  }
  name = "AutomationExecutionLimitExceededException";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "AutomationExecutionLimitExceededException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _AutomationExecutionLimitExceededException.prototype);
    this.Message = opts.Message;
  }
};
var InvalidAutomationExecutionParametersException = class _InvalidAutomationExecutionParametersException extends SSMServiceException {
  static {
    __name(this, "InvalidAutomationExecutionParametersException");
  }
  name = "InvalidAutomationExecutionParametersException";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidAutomationExecutionParametersException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidAutomationExecutionParametersException.prototype);
    this.Message = opts.Message;
  }
};
var AutomationDefinitionNotApprovedException = class _AutomationDefinitionNotApprovedException extends SSMServiceException {
  static {
    __name(this, "AutomationDefinitionNotApprovedException");
  }
  name = "AutomationDefinitionNotApprovedException";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "AutomationDefinitionNotApprovedException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _AutomationDefinitionNotApprovedException.prototype);
    this.Message = opts.Message;
  }
};
var ExecutionInputs;
((ExecutionInputs3) => {
  ExecutionInputs3.visit = /* @__PURE__ */ __name((value, visitor) => {
    if (value.Automation !== void 0) return visitor.Automation(value.Automation);
    return visitor._(value.$unknown[0], value.$unknown[1]);
  }, "visit");
})(ExecutionInputs || (ExecutionInputs = {}));
var TargetNotConnected = class _TargetNotConnected extends SSMServiceException {
  static {
    __name(this, "TargetNotConnected");
  }
  name = "TargetNotConnected";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TargetNotConnected",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TargetNotConnected.prototype);
    this.Message = opts.Message;
  }
};
var InvalidAutomationStatusUpdateException = class _InvalidAutomationStatusUpdateException extends SSMServiceException {
  static {
    __name(this, "InvalidAutomationStatusUpdateException");
  }
  name = "InvalidAutomationStatusUpdateException";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidAutomationStatusUpdateException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidAutomationStatusUpdateException.prototype);
    this.Message = opts.Message;
  }
};
var StopType = {
  CANCEL: "Cancel",
  COMPLETE: "Complete"
};
var AssociationVersionLimitExceeded = class _AssociationVersionLimitExceeded extends SSMServiceException {
  static {
    __name(this, "AssociationVersionLimitExceeded");
  }
  name = "AssociationVersionLimitExceeded";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "AssociationVersionLimitExceeded",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _AssociationVersionLimitExceeded.prototype);
    this.Message = opts.Message;
  }
};
var InvalidUpdate = class _InvalidUpdate extends SSMServiceException {
  static {
    __name(this, "InvalidUpdate");
  }
  name = "InvalidUpdate";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidUpdate",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidUpdate.prototype);
    this.Message = opts.Message;
  }
};
var StatusUnchanged = class _StatusUnchanged extends SSMServiceException {
  static {
    __name(this, "StatusUnchanged");
  }
  name = "StatusUnchanged";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "StatusUnchanged",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _StatusUnchanged.prototype);
  }
};
var DocumentVersionLimitExceeded = class _DocumentVersionLimitExceeded extends SSMServiceException {
  static {
    __name(this, "DocumentVersionLimitExceeded");
  }
  name = "DocumentVersionLimitExceeded";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DocumentVersionLimitExceeded",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _DocumentVersionLimitExceeded.prototype);
    this.Message = opts.Message;
  }
};
var DuplicateDocumentContent = class _DuplicateDocumentContent extends SSMServiceException {
  static {
    __name(this, "DuplicateDocumentContent");
  }
  name = "DuplicateDocumentContent";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DuplicateDocumentContent",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _DuplicateDocumentContent.prototype);
    this.Message = opts.Message;
  }
};
var DuplicateDocumentVersionName = class _DuplicateDocumentVersionName extends SSMServiceException {
  static {
    __name(this, "DuplicateDocumentVersionName");
  }
  name = "DuplicateDocumentVersionName";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DuplicateDocumentVersionName",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _DuplicateDocumentVersionName.prototype);
    this.Message = opts.Message;
  }
};
var DocumentReviewAction = {
  Approve: "Approve",
  Reject: "Reject",
  SendForReview: "SendForReview",
  UpdateReview: "UpdateReview"
};
var OpsMetadataKeyLimitExceededException = class _OpsMetadataKeyLimitExceededException extends SSMServiceException {
  static {
    __name(this, "OpsMetadataKeyLimitExceededException");
  }
  name = "OpsMetadataKeyLimitExceededException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "OpsMetadataKeyLimitExceededException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _OpsMetadataKeyLimitExceededException.prototype);
  }
};
var ResourceDataSyncConflictException = class _ResourceDataSyncConflictException extends SSMServiceException {
  static {
    __name(this, "ResourceDataSyncConflictException");
  }
  name = "ResourceDataSyncConflictException";
  $fault = "client";
  Message;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ResourceDataSyncConflictException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ResourceDataSyncConflictException.prototype);
    this.Message = opts.Message;
  }
};
var RegisterTargetWithMaintenanceWindowRequestFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.OwnerInformation && { OwnerInformation: import_smithy_client.SENSITIVE_STRING },
  ...obj.Description && { Description: import_smithy_client.SENSITIVE_STRING }
}), "RegisterTargetWithMaintenanceWindowRequestFilterSensitiveLog");
var RegisterTaskWithMaintenanceWindowRequestFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.TaskParameters && { TaskParameters: import_smithy_client.SENSITIVE_STRING },
  ...obj.TaskInvocationParameters && {
    TaskInvocationParameters: MaintenanceWindowTaskInvocationParametersFilterSensitiveLog(obj.TaskInvocationParameters)
  },
  ...obj.Description && { Description: import_smithy_client.SENSITIVE_STRING }
}), "RegisterTaskWithMaintenanceWindowRequestFilterSensitiveLog");
var SendCommandRequestFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.Parameters && { Parameters: import_smithy_client.SENSITIVE_STRING }
}), "SendCommandRequestFilterSensitiveLog");
var SendCommandResultFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.Command && { Command: CommandFilterSensitiveLog(obj.Command) }
}), "SendCommandResultFilterSensitiveLog");
var UpdateAssociationRequestFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.Parameters && { Parameters: import_smithy_client.SENSITIVE_STRING }
}), "UpdateAssociationRequestFilterSensitiveLog");
var UpdateAssociationResultFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.AssociationDescription && {
    AssociationDescription: AssociationDescriptionFilterSensitiveLog(obj.AssociationDescription)
  }
}), "UpdateAssociationResultFilterSensitiveLog");
var UpdateAssociationStatusResultFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.AssociationDescription && {
    AssociationDescription: AssociationDescriptionFilterSensitiveLog(obj.AssociationDescription)
  }
}), "UpdateAssociationStatusResultFilterSensitiveLog");
var UpdateMaintenanceWindowRequestFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.Description && { Description: import_smithy_client.SENSITIVE_STRING }
}), "UpdateMaintenanceWindowRequestFilterSensitiveLog");
var UpdateMaintenanceWindowResultFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.Description && { Description: import_smithy_client.SENSITIVE_STRING }
}), "UpdateMaintenanceWindowResultFilterSensitiveLog");
var UpdateMaintenanceWindowTargetRequestFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.OwnerInformation && { OwnerInformation: import_smithy_client.SENSITIVE_STRING },
  ...obj.Description && { Description: import_smithy_client.SENSITIVE_STRING }
}), "UpdateMaintenanceWindowTargetRequestFilterSensitiveLog");
var UpdateMaintenanceWindowTargetResultFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.OwnerInformation && { OwnerInformation: import_smithy_client.SENSITIVE_STRING },
  ...obj.Description && { Description: import_smithy_client.SENSITIVE_STRING }
}), "UpdateMaintenanceWindowTargetResultFilterSensitiveLog");
var UpdateMaintenanceWindowTaskRequestFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.TaskParameters && { TaskParameters: import_smithy_client.SENSITIVE_STRING },
  ...obj.TaskInvocationParameters && {
    TaskInvocationParameters: MaintenanceWindowTaskInvocationParametersFilterSensitiveLog(obj.TaskInvocationParameters)
  },
  ...obj.Description && { Description: import_smithy_client.SENSITIVE_STRING }
}), "UpdateMaintenanceWindowTaskRequestFilterSensitiveLog");
var UpdateMaintenanceWindowTaskResultFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.TaskParameters && { TaskParameters: import_smithy_client.SENSITIVE_STRING },
  ...obj.TaskInvocationParameters && {
    TaskInvocationParameters: MaintenanceWindowTaskInvocationParametersFilterSensitiveLog(obj.TaskInvocationParameters)
  },
  ...obj.Description && { Description: import_smithy_client.SENSITIVE_STRING }
}), "UpdateMaintenanceWindowTaskResultFilterSensitiveLog");
var UpdatePatchBaselineRequestFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.Sources && { Sources: obj.Sources.map((item) => PatchSourceFilterSensitiveLog(item)) }
}), "UpdatePatchBaselineRequestFilterSensitiveLog");
var UpdatePatchBaselineResultFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.Sources && { Sources: obj.Sources.map((item) => PatchSourceFilterSensitiveLog(item)) }
}), "UpdatePatchBaselineResultFilterSensitiveLog");

// src/protocols/Aws_json1_1.ts
var se_AddTagsToResourceCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("AddTagsToResource");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_AddTagsToResourceCommand");
var se_AssociateOpsItemRelatedItemCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("AssociateOpsItemRelatedItem");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_AssociateOpsItemRelatedItemCommand");
var se_CancelCommandCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("CancelCommand");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CancelCommandCommand");
var se_CancelMaintenanceWindowExecutionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("CancelMaintenanceWindowExecution");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CancelMaintenanceWindowExecutionCommand");
var se_CreateActivationCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("CreateActivation");
  let body;
  body = JSON.stringify(se_CreateActivationRequest(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CreateActivationCommand");
var se_CreateAssociationCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("CreateAssociation");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CreateAssociationCommand");
var se_CreateAssociationBatchCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("CreateAssociationBatch");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CreateAssociationBatchCommand");
var se_CreateDocumentCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("CreateDocument");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CreateDocumentCommand");
var se_CreateMaintenanceWindowCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("CreateMaintenanceWindow");
  let body;
  body = JSON.stringify(se_CreateMaintenanceWindowRequest(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CreateMaintenanceWindowCommand");
var se_CreateOpsItemCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("CreateOpsItem");
  let body;
  body = JSON.stringify(se_CreateOpsItemRequest(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CreateOpsItemCommand");
var se_CreateOpsMetadataCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("CreateOpsMetadata");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CreateOpsMetadataCommand");
var se_CreatePatchBaselineCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("CreatePatchBaseline");
  let body;
  body = JSON.stringify(se_CreatePatchBaselineRequest(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CreatePatchBaselineCommand");
var se_CreateResourceDataSyncCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("CreateResourceDataSync");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CreateResourceDataSyncCommand");
var se_DeleteActivationCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DeleteActivation");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeleteActivationCommand");
var se_DeleteAssociationCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DeleteAssociation");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeleteAssociationCommand");
var se_DeleteDocumentCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DeleteDocument");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeleteDocumentCommand");
var se_DeleteInventoryCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DeleteInventory");
  let body;
  body = JSON.stringify(se_DeleteInventoryRequest(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeleteInventoryCommand");
var se_DeleteMaintenanceWindowCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DeleteMaintenanceWindow");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeleteMaintenanceWindowCommand");
var se_DeleteOpsItemCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DeleteOpsItem");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeleteOpsItemCommand");
var se_DeleteOpsMetadataCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DeleteOpsMetadata");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeleteOpsMetadataCommand");
var se_DeleteParameterCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DeleteParameter");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeleteParameterCommand");
var se_DeleteParametersCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DeleteParameters");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeleteParametersCommand");
var se_DeletePatchBaselineCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DeletePatchBaseline");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeletePatchBaselineCommand");
var se_DeleteResourceDataSyncCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DeleteResourceDataSync");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeleteResourceDataSyncCommand");
var se_DeleteResourcePolicyCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DeleteResourcePolicy");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeleteResourcePolicyCommand");
var se_DeregisterManagedInstanceCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DeregisterManagedInstance");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeregisterManagedInstanceCommand");
var se_DeregisterPatchBaselineForPatchGroupCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DeregisterPatchBaselineForPatchGroup");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeregisterPatchBaselineForPatchGroupCommand");
var se_DeregisterTargetFromMaintenanceWindowCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DeregisterTargetFromMaintenanceWindow");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeregisterTargetFromMaintenanceWindowCommand");
var se_DeregisterTaskFromMaintenanceWindowCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DeregisterTaskFromMaintenanceWindow");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeregisterTaskFromMaintenanceWindowCommand");
var se_DescribeActivationsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DescribeActivations");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeActivationsCommand");
var se_DescribeAssociationCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DescribeAssociation");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeAssociationCommand");
var se_DescribeAssociationExecutionsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DescribeAssociationExecutions");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeAssociationExecutionsCommand");
var se_DescribeAssociationExecutionTargetsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DescribeAssociationExecutionTargets");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeAssociationExecutionTargetsCommand");
var se_DescribeAutomationExecutionsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DescribeAutomationExecutions");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeAutomationExecutionsCommand");
var se_DescribeAutomationStepExecutionsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DescribeAutomationStepExecutions");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeAutomationStepExecutionsCommand");
var se_DescribeAvailablePatchesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DescribeAvailablePatches");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeAvailablePatchesCommand");
var se_DescribeDocumentCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DescribeDocument");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeDocumentCommand");
var se_DescribeDocumentPermissionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DescribeDocumentPermission");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeDocumentPermissionCommand");
var se_DescribeEffectiveInstanceAssociationsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DescribeEffectiveInstanceAssociations");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeEffectiveInstanceAssociationsCommand");
var se_DescribeEffectivePatchesForPatchBaselineCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DescribeEffectivePatchesForPatchBaseline");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeEffectivePatchesForPatchBaselineCommand");
var se_DescribeInstanceAssociationsStatusCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DescribeInstanceAssociationsStatus");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeInstanceAssociationsStatusCommand");
var se_DescribeInstanceInformationCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DescribeInstanceInformation");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeInstanceInformationCommand");
var se_DescribeInstancePatchesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DescribeInstancePatches");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeInstancePatchesCommand");
var se_DescribeInstancePatchStatesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DescribeInstancePatchStates");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeInstancePatchStatesCommand");
var se_DescribeInstancePatchStatesForPatchGroupCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DescribeInstancePatchStatesForPatchGroup");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeInstancePatchStatesForPatchGroupCommand");
var se_DescribeInstancePropertiesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DescribeInstanceProperties");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeInstancePropertiesCommand");
var se_DescribeInventoryDeletionsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DescribeInventoryDeletions");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeInventoryDeletionsCommand");
var se_DescribeMaintenanceWindowExecutionsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DescribeMaintenanceWindowExecutions");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeMaintenanceWindowExecutionsCommand");
var se_DescribeMaintenanceWindowExecutionTaskInvocationsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DescribeMaintenanceWindowExecutionTaskInvocations");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeMaintenanceWindowExecutionTaskInvocationsCommand");
var se_DescribeMaintenanceWindowExecutionTasksCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DescribeMaintenanceWindowExecutionTasks");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeMaintenanceWindowExecutionTasksCommand");
var se_DescribeMaintenanceWindowsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DescribeMaintenanceWindows");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeMaintenanceWindowsCommand");
var se_DescribeMaintenanceWindowScheduleCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DescribeMaintenanceWindowSchedule");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeMaintenanceWindowScheduleCommand");
var se_DescribeMaintenanceWindowsForTargetCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DescribeMaintenanceWindowsForTarget");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeMaintenanceWindowsForTargetCommand");
var se_DescribeMaintenanceWindowTargetsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DescribeMaintenanceWindowTargets");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeMaintenanceWindowTargetsCommand");
var se_DescribeMaintenanceWindowTasksCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DescribeMaintenanceWindowTasks");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeMaintenanceWindowTasksCommand");
var se_DescribeOpsItemsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DescribeOpsItems");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeOpsItemsCommand");
var se_DescribeParametersCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DescribeParameters");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeParametersCommand");
var se_DescribePatchBaselinesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DescribePatchBaselines");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribePatchBaselinesCommand");
var se_DescribePatchGroupsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DescribePatchGroups");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribePatchGroupsCommand");
var se_DescribePatchGroupStateCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DescribePatchGroupState");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribePatchGroupStateCommand");
var se_DescribePatchPropertiesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DescribePatchProperties");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribePatchPropertiesCommand");
var se_DescribeSessionsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DescribeSessions");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeSessionsCommand");
var se_DisassociateOpsItemRelatedItemCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("DisassociateOpsItemRelatedItem");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DisassociateOpsItemRelatedItemCommand");
var se_GetAccessTokenCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("GetAccessToken");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetAccessTokenCommand");
var se_GetAutomationExecutionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("GetAutomationExecution");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetAutomationExecutionCommand");
var se_GetCalendarStateCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("GetCalendarState");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetCalendarStateCommand");
var se_GetCommandInvocationCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("GetCommandInvocation");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetCommandInvocationCommand");
var se_GetConnectionStatusCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("GetConnectionStatus");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetConnectionStatusCommand");
var se_GetDefaultPatchBaselineCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("GetDefaultPatchBaseline");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetDefaultPatchBaselineCommand");
var se_GetDeployablePatchSnapshotForInstanceCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("GetDeployablePatchSnapshotForInstance");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetDeployablePatchSnapshotForInstanceCommand");
var se_GetDocumentCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("GetDocument");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetDocumentCommand");
var se_GetExecutionPreviewCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("GetExecutionPreview");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetExecutionPreviewCommand");
var se_GetInventoryCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("GetInventory");
  let body;
  body = JSON.stringify(se_GetInventoryRequest(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetInventoryCommand");
var se_GetInventorySchemaCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("GetInventorySchema");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetInventorySchemaCommand");
var se_GetMaintenanceWindowCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("GetMaintenanceWindow");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetMaintenanceWindowCommand");
var se_GetMaintenanceWindowExecutionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("GetMaintenanceWindowExecution");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetMaintenanceWindowExecutionCommand");
var se_GetMaintenanceWindowExecutionTaskCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("GetMaintenanceWindowExecutionTask");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetMaintenanceWindowExecutionTaskCommand");
var se_GetMaintenanceWindowExecutionTaskInvocationCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("GetMaintenanceWindowExecutionTaskInvocation");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetMaintenanceWindowExecutionTaskInvocationCommand");
var se_GetMaintenanceWindowTaskCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("GetMaintenanceWindowTask");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetMaintenanceWindowTaskCommand");
var se_GetOpsItemCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("GetOpsItem");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetOpsItemCommand");
var se_GetOpsMetadataCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("GetOpsMetadata");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetOpsMetadataCommand");
var se_GetOpsSummaryCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("GetOpsSummary");
  let body;
  body = JSON.stringify(se_GetOpsSummaryRequest(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetOpsSummaryCommand");
var se_GetParameterCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("GetParameter");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetParameterCommand");
var se_GetParameterHistoryCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("GetParameterHistory");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetParameterHistoryCommand");
var se_GetParametersCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("GetParameters");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetParametersCommand");
var se_GetParametersByPathCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("GetParametersByPath");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetParametersByPathCommand");
var se_GetPatchBaselineCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("GetPatchBaseline");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetPatchBaselineCommand");
var se_GetPatchBaselineForPatchGroupCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("GetPatchBaselineForPatchGroup");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetPatchBaselineForPatchGroupCommand");
var se_GetResourcePoliciesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("GetResourcePolicies");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetResourcePoliciesCommand");
var se_GetServiceSettingCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("GetServiceSetting");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetServiceSettingCommand");
var se_LabelParameterVersionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("LabelParameterVersion");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_LabelParameterVersionCommand");
var se_ListAssociationsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ListAssociations");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListAssociationsCommand");
var se_ListAssociationVersionsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ListAssociationVersions");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListAssociationVersionsCommand");
var se_ListCommandInvocationsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ListCommandInvocations");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListCommandInvocationsCommand");
var se_ListCommandsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ListCommands");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListCommandsCommand");
var se_ListComplianceItemsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ListComplianceItems");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListComplianceItemsCommand");
var se_ListComplianceSummariesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ListComplianceSummaries");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListComplianceSummariesCommand");
var se_ListDocumentMetadataHistoryCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ListDocumentMetadataHistory");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListDocumentMetadataHistoryCommand");
var se_ListDocumentsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ListDocuments");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListDocumentsCommand");
var se_ListDocumentVersionsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ListDocumentVersions");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListDocumentVersionsCommand");
var se_ListInventoryEntriesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ListInventoryEntries");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListInventoryEntriesCommand");
var se_ListNodesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ListNodes");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListNodesCommand");
var se_ListNodesSummaryCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ListNodesSummary");
  let body;
  body = JSON.stringify(se_ListNodesSummaryRequest(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListNodesSummaryCommand");
var se_ListOpsItemEventsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ListOpsItemEvents");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListOpsItemEventsCommand");
var se_ListOpsItemRelatedItemsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ListOpsItemRelatedItems");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListOpsItemRelatedItemsCommand");
var se_ListOpsMetadataCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ListOpsMetadata");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListOpsMetadataCommand");
var se_ListResourceComplianceSummariesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ListResourceComplianceSummaries");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListResourceComplianceSummariesCommand");
var se_ListResourceDataSyncCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ListResourceDataSync");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListResourceDataSyncCommand");
var se_ListTagsForResourceCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ListTagsForResource");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListTagsForResourceCommand");
var se_ModifyDocumentPermissionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ModifyDocumentPermission");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ModifyDocumentPermissionCommand");
var se_PutComplianceItemsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("PutComplianceItems");
  let body;
  body = JSON.stringify(se_PutComplianceItemsRequest(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_PutComplianceItemsCommand");
var se_PutInventoryCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("PutInventory");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_PutInventoryCommand");
var se_PutParameterCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("PutParameter");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_PutParameterCommand");
var se_PutResourcePolicyCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("PutResourcePolicy");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_PutResourcePolicyCommand");
var se_RegisterDefaultPatchBaselineCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("RegisterDefaultPatchBaseline");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_RegisterDefaultPatchBaselineCommand");
var se_RegisterPatchBaselineForPatchGroupCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("RegisterPatchBaselineForPatchGroup");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_RegisterPatchBaselineForPatchGroupCommand");
var se_RegisterTargetWithMaintenanceWindowCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("RegisterTargetWithMaintenanceWindow");
  let body;
  body = JSON.stringify(se_RegisterTargetWithMaintenanceWindowRequest(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_RegisterTargetWithMaintenanceWindowCommand");
var se_RegisterTaskWithMaintenanceWindowCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("RegisterTaskWithMaintenanceWindow");
  let body;
  body = JSON.stringify(se_RegisterTaskWithMaintenanceWindowRequest(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_RegisterTaskWithMaintenanceWindowCommand");
var se_RemoveTagsFromResourceCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("RemoveTagsFromResource");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_RemoveTagsFromResourceCommand");
var se_ResetServiceSettingCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ResetServiceSetting");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ResetServiceSettingCommand");
var se_ResumeSessionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("ResumeSession");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ResumeSessionCommand");
var se_SendAutomationSignalCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("SendAutomationSignal");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_SendAutomationSignalCommand");
var se_SendCommandCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("SendCommand");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_SendCommandCommand");
var se_StartAccessRequestCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("StartAccessRequest");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_StartAccessRequestCommand");
var se_StartAssociationsOnceCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("StartAssociationsOnce");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_StartAssociationsOnceCommand");
var se_StartAutomationExecutionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("StartAutomationExecution");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_StartAutomationExecutionCommand");
var se_StartChangeRequestExecutionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("StartChangeRequestExecution");
  let body;
  body = JSON.stringify(se_StartChangeRequestExecutionRequest(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_StartChangeRequestExecutionCommand");
var se_StartExecutionPreviewCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("StartExecutionPreview");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_StartExecutionPreviewCommand");
var se_StartSessionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("StartSession");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_StartSessionCommand");
var se_StopAutomationExecutionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("StopAutomationExecution");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_StopAutomationExecutionCommand");
var se_TerminateSessionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("TerminateSession");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_TerminateSessionCommand");
var se_UnlabelParameterVersionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("UnlabelParameterVersion");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_UnlabelParameterVersionCommand");
var se_UpdateAssociationCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("UpdateAssociation");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_UpdateAssociationCommand");
var se_UpdateAssociationStatusCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("UpdateAssociationStatus");
  let body;
  body = JSON.stringify(se_UpdateAssociationStatusRequest(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_UpdateAssociationStatusCommand");
var se_UpdateDocumentCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("UpdateDocument");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_UpdateDocumentCommand");
var se_UpdateDocumentDefaultVersionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("UpdateDocumentDefaultVersion");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_UpdateDocumentDefaultVersionCommand");
var se_UpdateDocumentMetadataCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("UpdateDocumentMetadata");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_UpdateDocumentMetadataCommand");
var se_UpdateMaintenanceWindowCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("UpdateMaintenanceWindow");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_UpdateMaintenanceWindowCommand");
var se_UpdateMaintenanceWindowTargetCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("UpdateMaintenanceWindowTarget");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_UpdateMaintenanceWindowTargetCommand");
var se_UpdateMaintenanceWindowTaskCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("UpdateMaintenanceWindowTask");
  let body;
  body = JSON.stringify(se_UpdateMaintenanceWindowTaskRequest(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_UpdateMaintenanceWindowTaskCommand");
var se_UpdateManagedInstanceRoleCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("UpdateManagedInstanceRole");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_UpdateManagedInstanceRoleCommand");
var se_UpdateOpsItemCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("UpdateOpsItem");
  let body;
  body = JSON.stringify(se_UpdateOpsItemRequest(input, context));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_UpdateOpsItemCommand");
var se_UpdateOpsMetadataCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("UpdateOpsMetadata");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_UpdateOpsMetadataCommand");
var se_UpdatePatchBaselineCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("UpdatePatchBaseline");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_UpdatePatchBaselineCommand");
var se_UpdateResourceDataSyncCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("UpdateResourceDataSync");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_UpdateResourceDataSyncCommand");
var se_UpdateServiceSettingCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = sharedHeaders("UpdateServiceSetting");
  let body;
  body = JSON.stringify((0, import_smithy_client._json)(input));
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_UpdateServiceSettingCommand");
var de_AddTagsToResourceCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_AddTagsToResourceCommand");
var de_AssociateOpsItemRelatedItemCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_AssociateOpsItemRelatedItemCommand");
var de_CancelCommandCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CancelCommandCommand");
var de_CancelMaintenanceWindowExecutionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CancelMaintenanceWindowExecutionCommand");
var de_CreateActivationCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CreateActivationCommand");
var de_CreateAssociationCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_CreateAssociationResult(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CreateAssociationCommand");
var de_CreateAssociationBatchCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_CreateAssociationBatchResult(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CreateAssociationBatchCommand");
var de_CreateDocumentCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_CreateDocumentResult(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CreateDocumentCommand");
var de_CreateMaintenanceWindowCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CreateMaintenanceWindowCommand");
var de_CreateOpsItemCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CreateOpsItemCommand");
var de_CreateOpsMetadataCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CreateOpsMetadataCommand");
var de_CreatePatchBaselineCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CreatePatchBaselineCommand");
var de_CreateResourceDataSyncCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CreateResourceDataSyncCommand");
var de_DeleteActivationCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DeleteActivationCommand");
var de_DeleteAssociationCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DeleteAssociationCommand");
var de_DeleteDocumentCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DeleteDocumentCommand");
var de_DeleteInventoryCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DeleteInventoryCommand");
var de_DeleteMaintenanceWindowCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DeleteMaintenanceWindowCommand");
var de_DeleteOpsItemCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DeleteOpsItemCommand");
var de_DeleteOpsMetadataCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DeleteOpsMetadataCommand");
var de_DeleteParameterCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DeleteParameterCommand");
var de_DeleteParametersCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DeleteParametersCommand");
var de_DeletePatchBaselineCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DeletePatchBaselineCommand");
var de_DeleteResourceDataSyncCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DeleteResourceDataSyncCommand");
var de_DeleteResourcePolicyCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DeleteResourcePolicyCommand");
var de_DeregisterManagedInstanceCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DeregisterManagedInstanceCommand");
var de_DeregisterPatchBaselineForPatchGroupCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DeregisterPatchBaselineForPatchGroupCommand");
var de_DeregisterTargetFromMaintenanceWindowCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DeregisterTargetFromMaintenanceWindowCommand");
var de_DeregisterTaskFromMaintenanceWindowCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DeregisterTaskFromMaintenanceWindowCommand");
var de_DescribeActivationsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_DescribeActivationsResult(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeActivationsCommand");
var de_DescribeAssociationCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_DescribeAssociationResult(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeAssociationCommand");
var de_DescribeAssociationExecutionsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_DescribeAssociationExecutionsResult(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeAssociationExecutionsCommand");
var de_DescribeAssociationExecutionTargetsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_DescribeAssociationExecutionTargetsResult(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeAssociationExecutionTargetsCommand");
var de_DescribeAutomationExecutionsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_DescribeAutomationExecutionsResult(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeAutomationExecutionsCommand");
var de_DescribeAutomationStepExecutionsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_DescribeAutomationStepExecutionsResult(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeAutomationStepExecutionsCommand");
var de_DescribeAvailablePatchesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_DescribeAvailablePatchesResult(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeAvailablePatchesCommand");
var de_DescribeDocumentCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_DescribeDocumentResult(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeDocumentCommand");
var de_DescribeDocumentPermissionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeDocumentPermissionCommand");
var de_DescribeEffectiveInstanceAssociationsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeEffectiveInstanceAssociationsCommand");
var de_DescribeEffectivePatchesForPatchBaselineCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_DescribeEffectivePatchesForPatchBaselineResult(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeEffectivePatchesForPatchBaselineCommand");
var de_DescribeInstanceAssociationsStatusCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_DescribeInstanceAssociationsStatusResult(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeInstanceAssociationsStatusCommand");
var de_DescribeInstanceInformationCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_DescribeInstanceInformationResult(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeInstanceInformationCommand");
var de_DescribeInstancePatchesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_DescribeInstancePatchesResult(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeInstancePatchesCommand");
var de_DescribeInstancePatchStatesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_DescribeInstancePatchStatesResult(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeInstancePatchStatesCommand");
var de_DescribeInstancePatchStatesForPatchGroupCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_DescribeInstancePatchStatesForPatchGroupResult(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeInstancePatchStatesForPatchGroupCommand");
var de_DescribeInstancePropertiesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_DescribeInstancePropertiesResult(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeInstancePropertiesCommand");
var de_DescribeInventoryDeletionsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_DescribeInventoryDeletionsResult(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeInventoryDeletionsCommand");
var de_DescribeMaintenanceWindowExecutionsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_DescribeMaintenanceWindowExecutionsResult(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeMaintenanceWindowExecutionsCommand");
var de_DescribeMaintenanceWindowExecutionTaskInvocationsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_DescribeMaintenanceWindowExecutionTaskInvocationsResult(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeMaintenanceWindowExecutionTaskInvocationsCommand");
var de_DescribeMaintenanceWindowExecutionTasksCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_DescribeMaintenanceWindowExecutionTasksResult(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeMaintenanceWindowExecutionTasksCommand");
var de_DescribeMaintenanceWindowsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeMaintenanceWindowsCommand");
var de_DescribeMaintenanceWindowScheduleCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeMaintenanceWindowScheduleCommand");
var de_DescribeMaintenanceWindowsForTargetCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeMaintenanceWindowsForTargetCommand");
var de_DescribeMaintenanceWindowTargetsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeMaintenanceWindowTargetsCommand");
var de_DescribeMaintenanceWindowTasksCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeMaintenanceWindowTasksCommand");
var de_DescribeOpsItemsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_DescribeOpsItemsResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeOpsItemsCommand");
var de_DescribeParametersCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_DescribeParametersResult(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeParametersCommand");
var de_DescribePatchBaselinesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribePatchBaselinesCommand");
var de_DescribePatchGroupsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribePatchGroupsCommand");
var de_DescribePatchGroupStateCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribePatchGroupStateCommand");
var de_DescribePatchPropertiesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribePatchPropertiesCommand");
var de_DescribeSessionsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_DescribeSessionsResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeSessionsCommand");
var de_DisassociateOpsItemRelatedItemCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DisassociateOpsItemRelatedItemCommand");
var de_GetAccessTokenCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_GetAccessTokenResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetAccessTokenCommand");
var de_GetAutomationExecutionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_GetAutomationExecutionResult(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetAutomationExecutionCommand");
var de_GetCalendarStateCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetCalendarStateCommand");
var de_GetCommandInvocationCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetCommandInvocationCommand");
var de_GetConnectionStatusCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetConnectionStatusCommand");
var de_GetDefaultPatchBaselineCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetDefaultPatchBaselineCommand");
var de_GetDeployablePatchSnapshotForInstanceCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetDeployablePatchSnapshotForInstanceCommand");
var de_GetDocumentCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_GetDocumentResult(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetDocumentCommand");
var de_GetExecutionPreviewCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_GetExecutionPreviewResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetExecutionPreviewCommand");
var de_GetInventoryCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetInventoryCommand");
var de_GetInventorySchemaCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetInventorySchemaCommand");
var de_GetMaintenanceWindowCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_GetMaintenanceWindowResult(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetMaintenanceWindowCommand");
var de_GetMaintenanceWindowExecutionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_GetMaintenanceWindowExecutionResult(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetMaintenanceWindowExecutionCommand");
var de_GetMaintenanceWindowExecutionTaskCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_GetMaintenanceWindowExecutionTaskResult(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetMaintenanceWindowExecutionTaskCommand");
var de_GetMaintenanceWindowExecutionTaskInvocationCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_GetMaintenanceWindowExecutionTaskInvocationResult(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetMaintenanceWindowExecutionTaskInvocationCommand");
var de_GetMaintenanceWindowTaskCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_GetMaintenanceWindowTaskResult(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetMaintenanceWindowTaskCommand");
var de_GetOpsItemCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_GetOpsItemResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetOpsItemCommand");
var de_GetOpsMetadataCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetOpsMetadataCommand");
var de_GetOpsSummaryCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetOpsSummaryCommand");
var de_GetParameterCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_GetParameterResult(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetParameterCommand");
var de_GetParameterHistoryCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_GetParameterHistoryResult(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetParameterHistoryCommand");
var de_GetParametersCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_GetParametersResult(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetParametersCommand");
var de_GetParametersByPathCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_GetParametersByPathResult(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetParametersByPathCommand");
var de_GetPatchBaselineCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_GetPatchBaselineResult(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetPatchBaselineCommand");
var de_GetPatchBaselineForPatchGroupCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetPatchBaselineForPatchGroupCommand");
var de_GetResourcePoliciesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetResourcePoliciesCommand");
var de_GetServiceSettingCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_GetServiceSettingResult(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetServiceSettingCommand");
var de_LabelParameterVersionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_LabelParameterVersionCommand");
var de_ListAssociationsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_ListAssociationsResult(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListAssociationsCommand");
var de_ListAssociationVersionsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_ListAssociationVersionsResult(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListAssociationVersionsCommand");
var de_ListCommandInvocationsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_ListCommandInvocationsResult(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListCommandInvocationsCommand");
var de_ListCommandsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_ListCommandsResult(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListCommandsCommand");
var de_ListComplianceItemsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_ListComplianceItemsResult(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListComplianceItemsCommand");
var de_ListComplianceSummariesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListComplianceSummariesCommand");
var de_ListDocumentMetadataHistoryCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_ListDocumentMetadataHistoryResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListDocumentMetadataHistoryCommand");
var de_ListDocumentsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_ListDocumentsResult(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListDocumentsCommand");
var de_ListDocumentVersionsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_ListDocumentVersionsResult(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListDocumentVersionsCommand");
var de_ListInventoryEntriesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListInventoryEntriesCommand");
var de_ListNodesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_ListNodesResult(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListNodesCommand");
var de_ListNodesSummaryCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListNodesSummaryCommand");
var de_ListOpsItemEventsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_ListOpsItemEventsResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListOpsItemEventsCommand");
var de_ListOpsItemRelatedItemsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_ListOpsItemRelatedItemsResponse(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListOpsItemRelatedItemsCommand");
var de_ListOpsMetadataCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_ListOpsMetadataResult(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListOpsMetadataCommand");
var de_ListResourceComplianceSummariesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_ListResourceComplianceSummariesResult(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListResourceComplianceSummariesCommand");
var de_ListResourceDataSyncCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_ListResourceDataSyncResult(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListResourceDataSyncCommand");
var de_ListTagsForResourceCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListTagsForResourceCommand");
var de_ModifyDocumentPermissionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ModifyDocumentPermissionCommand");
var de_PutComplianceItemsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_PutComplianceItemsCommand");
var de_PutInventoryCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_PutInventoryCommand");
var de_PutParameterCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_PutParameterCommand");
var de_PutResourcePolicyCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_PutResourcePolicyCommand");
var de_RegisterDefaultPatchBaselineCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_RegisterDefaultPatchBaselineCommand");
var de_RegisterPatchBaselineForPatchGroupCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_RegisterPatchBaselineForPatchGroupCommand");
var de_RegisterTargetWithMaintenanceWindowCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_RegisterTargetWithMaintenanceWindowCommand");
var de_RegisterTaskWithMaintenanceWindowCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_RegisterTaskWithMaintenanceWindowCommand");
var de_RemoveTagsFromResourceCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_RemoveTagsFromResourceCommand");
var de_ResetServiceSettingCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_ResetServiceSettingResult(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ResetServiceSettingCommand");
var de_ResumeSessionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ResumeSessionCommand");
var de_SendAutomationSignalCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_SendAutomationSignalCommand");
var de_SendCommandCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_SendCommandResult(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_SendCommandCommand");
var de_StartAccessRequestCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_StartAccessRequestCommand");
var de_StartAssociationsOnceCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_StartAssociationsOnceCommand");
var de_StartAutomationExecutionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_StartAutomationExecutionCommand");
var de_StartChangeRequestExecutionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_StartChangeRequestExecutionCommand");
var de_StartExecutionPreviewCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_StartExecutionPreviewCommand");
var de_StartSessionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_StartSessionCommand");
var de_StopAutomationExecutionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_StopAutomationExecutionCommand");
var de_TerminateSessionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_TerminateSessionCommand");
var de_UnlabelParameterVersionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_UnlabelParameterVersionCommand");
var de_UpdateAssociationCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_UpdateAssociationResult(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_UpdateAssociationCommand");
var de_UpdateAssociationStatusCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_UpdateAssociationStatusResult(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_UpdateAssociationStatusCommand");
var de_UpdateDocumentCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_UpdateDocumentResult(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_UpdateDocumentCommand");
var de_UpdateDocumentDefaultVersionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_UpdateDocumentDefaultVersionCommand");
var de_UpdateDocumentMetadataCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_UpdateDocumentMetadataCommand");
var de_UpdateMaintenanceWindowCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_UpdateMaintenanceWindowCommand");
var de_UpdateMaintenanceWindowTargetCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_UpdateMaintenanceWindowTargetCommand");
var de_UpdateMaintenanceWindowTaskCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_UpdateMaintenanceWindowTaskResult(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_UpdateMaintenanceWindowTaskCommand");
var de_UpdateManagedInstanceRoleCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_UpdateManagedInstanceRoleCommand");
var de_UpdateOpsItemCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_UpdateOpsItemCommand");
var de_UpdateOpsMetadataCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_UpdateOpsMetadataCommand");
var de_UpdatePatchBaselineCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = de_UpdatePatchBaselineResult(data, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_UpdatePatchBaselineCommand");
var de_UpdateResourceDataSyncCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_UpdateResourceDataSyncCommand");
var de_UpdateServiceSettingCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseJsonBody)(output.body, context);
  let contents = {};
  contents = (0, import_smithy_client._json)(data);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_UpdateServiceSettingCommand");
var de_CommandError = /* @__PURE__ */ __name(async (output, context) => {
  const parsedOutput = {
    ...output,
    body: await (0, import_core2.parseJsonErrorBody)(output.body, context)
  };
  const errorCode = (0, import_core2.loadRestJsonErrorCode)(output, parsedOutput.body);
  switch (errorCode) {
    case "InternalServerError":
    case "com.amazonaws.ssm#InternalServerError":
      throw await de_InternalServerErrorRes(parsedOutput, context);
    case "InvalidResourceId":
    case "com.amazonaws.ssm#InvalidResourceId":
      throw await de_InvalidResourceIdRes(parsedOutput, context);
    case "InvalidResourceType":
    case "com.amazonaws.ssm#InvalidResourceType":
      throw await de_InvalidResourceTypeRes(parsedOutput, context);
    case "TooManyTagsError":
    case "com.amazonaws.ssm#TooManyTagsError":
      throw await de_TooManyTagsErrorRes(parsedOutput, context);
    case "TooManyUpdates":
    case "com.amazonaws.ssm#TooManyUpdates":
      throw await de_TooManyUpdatesRes(parsedOutput, context);
    case "OpsItemConflictException":
    case "com.amazonaws.ssm#OpsItemConflictException":
      throw await de_OpsItemConflictExceptionRes(parsedOutput, context);
    case "OpsItemInvalidParameterException":
    case "com.amazonaws.ssm#OpsItemInvalidParameterException":
      throw await de_OpsItemInvalidParameterExceptionRes(parsedOutput, context);
    case "OpsItemLimitExceededException":
    case "com.amazonaws.ssm#OpsItemLimitExceededException":
      throw await de_OpsItemLimitExceededExceptionRes(parsedOutput, context);
    case "OpsItemNotFoundException":
    case "com.amazonaws.ssm#OpsItemNotFoundException":
      throw await de_OpsItemNotFoundExceptionRes(parsedOutput, context);
    case "OpsItemRelatedItemAlreadyExistsException":
    case "com.amazonaws.ssm#OpsItemRelatedItemAlreadyExistsException":
      throw await de_OpsItemRelatedItemAlreadyExistsExceptionRes(parsedOutput, context);
    case "DuplicateInstanceId":
    case "com.amazonaws.ssm#DuplicateInstanceId":
      throw await de_DuplicateInstanceIdRes(parsedOutput, context);
    case "InvalidCommandId":
    case "com.amazonaws.ssm#InvalidCommandId":
      throw await de_InvalidCommandIdRes(parsedOutput, context);
    case "InvalidInstanceId":
    case "com.amazonaws.ssm#InvalidInstanceId":
      throw await de_InvalidInstanceIdRes(parsedOutput, context);
    case "DoesNotExistException":
    case "com.amazonaws.ssm#DoesNotExistException":
      throw await de_DoesNotExistExceptionRes(parsedOutput, context);
    case "InvalidParameters":
    case "com.amazonaws.ssm#InvalidParameters":
      throw await de_InvalidParametersRes(parsedOutput, context);
    case "AssociationAlreadyExists":
    case "com.amazonaws.ssm#AssociationAlreadyExists":
      throw await de_AssociationAlreadyExistsRes(parsedOutput, context);
    case "AssociationLimitExceeded":
    case "com.amazonaws.ssm#AssociationLimitExceeded":
      throw await de_AssociationLimitExceededRes(parsedOutput, context);
    case "InvalidDocument":
    case "com.amazonaws.ssm#InvalidDocument":
      throw await de_InvalidDocumentRes(parsedOutput, context);
    case "InvalidDocumentVersion":
    case "com.amazonaws.ssm#InvalidDocumentVersion":
      throw await de_InvalidDocumentVersionRes(parsedOutput, context);
    case "InvalidOutputLocation":
    case "com.amazonaws.ssm#InvalidOutputLocation":
      throw await de_InvalidOutputLocationRes(parsedOutput, context);
    case "InvalidSchedule":
    case "com.amazonaws.ssm#InvalidSchedule":
      throw await de_InvalidScheduleRes(parsedOutput, context);
    case "InvalidTag":
    case "com.amazonaws.ssm#InvalidTag":
      throw await de_InvalidTagRes(parsedOutput, context);
    case "InvalidTarget":
    case "com.amazonaws.ssm#InvalidTarget":
      throw await de_InvalidTargetRes(parsedOutput, context);
    case "InvalidTargetMaps":
    case "com.amazonaws.ssm#InvalidTargetMaps":
      throw await de_InvalidTargetMapsRes(parsedOutput, context);
    case "UnsupportedPlatformType":
    case "com.amazonaws.ssm#UnsupportedPlatformType":
      throw await de_UnsupportedPlatformTypeRes(parsedOutput, context);
    case "DocumentAlreadyExists":
    case "com.amazonaws.ssm#DocumentAlreadyExists":
      throw await de_DocumentAlreadyExistsRes(parsedOutput, context);
    case "DocumentLimitExceeded":
    case "com.amazonaws.ssm#DocumentLimitExceeded":
      throw await de_DocumentLimitExceededRes(parsedOutput, context);
    case "InvalidDocumentContent":
    case "com.amazonaws.ssm#InvalidDocumentContent":
      throw await de_InvalidDocumentContentRes(parsedOutput, context);
    case "InvalidDocumentSchemaVersion":
    case "com.amazonaws.ssm#InvalidDocumentSchemaVersion":
      throw await de_InvalidDocumentSchemaVersionRes(parsedOutput, context);
    case "MaxDocumentSizeExceeded":
    case "com.amazonaws.ssm#MaxDocumentSizeExceeded":
      throw await de_MaxDocumentSizeExceededRes(parsedOutput, context);
    case "IdempotentParameterMismatch":
    case "com.amazonaws.ssm#IdempotentParameterMismatch":
      throw await de_IdempotentParameterMismatchRes(parsedOutput, context);
    case "ResourceLimitExceededException":
    case "com.amazonaws.ssm#ResourceLimitExceededException":
      throw await de_ResourceLimitExceededExceptionRes(parsedOutput, context);
    case "OpsItemAccessDeniedException":
    case "com.amazonaws.ssm#OpsItemAccessDeniedException":
      throw await de_OpsItemAccessDeniedExceptionRes(parsedOutput, context);
    case "OpsItemAlreadyExistsException":
    case "com.amazonaws.ssm#OpsItemAlreadyExistsException":
      throw await de_OpsItemAlreadyExistsExceptionRes(parsedOutput, context);
    case "OpsMetadataAlreadyExistsException":
    case "com.amazonaws.ssm#OpsMetadataAlreadyExistsException":
      throw await de_OpsMetadataAlreadyExistsExceptionRes(parsedOutput, context);
    case "OpsMetadataInvalidArgumentException":
    case "com.amazonaws.ssm#OpsMetadataInvalidArgumentException":
      throw await de_OpsMetadataInvalidArgumentExceptionRes(parsedOutput, context);
    case "OpsMetadataLimitExceededException":
    case "com.amazonaws.ssm#OpsMetadataLimitExceededException":
      throw await de_OpsMetadataLimitExceededExceptionRes(parsedOutput, context);
    case "OpsMetadataTooManyUpdatesException":
    case "com.amazonaws.ssm#OpsMetadataTooManyUpdatesException":
      throw await de_OpsMetadataTooManyUpdatesExceptionRes(parsedOutput, context);
    case "ResourceDataSyncAlreadyExistsException":
    case "com.amazonaws.ssm#ResourceDataSyncAlreadyExistsException":
      throw await de_ResourceDataSyncAlreadyExistsExceptionRes(parsedOutput, context);
    case "ResourceDataSyncCountExceededException":
    case "com.amazonaws.ssm#ResourceDataSyncCountExceededException":
      throw await de_ResourceDataSyncCountExceededExceptionRes(parsedOutput, context);
    case "ResourceDataSyncInvalidConfigurationException":
    case "com.amazonaws.ssm#ResourceDataSyncInvalidConfigurationException":
      throw await de_ResourceDataSyncInvalidConfigurationExceptionRes(parsedOutput, context);
    case "InvalidActivation":
    case "com.amazonaws.ssm#InvalidActivation":
      throw await de_InvalidActivationRes(parsedOutput, context);
    case "InvalidActivationId":
    case "com.amazonaws.ssm#InvalidActivationId":
      throw await de_InvalidActivationIdRes(parsedOutput, context);
    case "AssociationDoesNotExist":
    case "com.amazonaws.ssm#AssociationDoesNotExist":
      throw await de_AssociationDoesNotExistRes(parsedOutput, context);
    case "AssociatedInstances":
    case "com.amazonaws.ssm#AssociatedInstances":
      throw await de_AssociatedInstancesRes(parsedOutput, context);
    case "InvalidDocumentOperation":
    case "com.amazonaws.ssm#InvalidDocumentOperation":
      throw await de_InvalidDocumentOperationRes(parsedOutput, context);
    case "InvalidDeleteInventoryParametersException":
    case "com.amazonaws.ssm#InvalidDeleteInventoryParametersException":
      throw await de_InvalidDeleteInventoryParametersExceptionRes(parsedOutput, context);
    case "InvalidInventoryRequestException":
    case "com.amazonaws.ssm#InvalidInventoryRequestException":
      throw await de_InvalidInventoryRequestExceptionRes(parsedOutput, context);
    case "InvalidOptionException":
    case "com.amazonaws.ssm#InvalidOptionException":
      throw await de_InvalidOptionExceptionRes(parsedOutput, context);
    case "InvalidTypeNameException":
    case "com.amazonaws.ssm#InvalidTypeNameException":
      throw await de_InvalidTypeNameExceptionRes(parsedOutput, context);
    case "OpsMetadataNotFoundException":
    case "com.amazonaws.ssm#OpsMetadataNotFoundException":
      throw await de_OpsMetadataNotFoundExceptionRes(parsedOutput, context);
    case "ParameterNotFound":
    case "com.amazonaws.ssm#ParameterNotFound":
      throw await de_ParameterNotFoundRes(parsedOutput, context);
    case "ResourceInUseException":
    case "com.amazonaws.ssm#ResourceInUseException":
      throw await de_ResourceInUseExceptionRes(parsedOutput, context);
    case "ResourceDataSyncNotFoundException":
    case "com.amazonaws.ssm#ResourceDataSyncNotFoundException":
      throw await de_ResourceDataSyncNotFoundExceptionRes(parsedOutput, context);
    case "MalformedResourcePolicyDocumentException":
    case "com.amazonaws.ssm#MalformedResourcePolicyDocumentException":
      throw await de_MalformedResourcePolicyDocumentExceptionRes(parsedOutput, context);
    case "ResourceNotFoundException":
    case "com.amazonaws.ssm#ResourceNotFoundException":
      throw await de_ResourceNotFoundExceptionRes(parsedOutput, context);
    case "ResourcePolicyConflictException":
    case "com.amazonaws.ssm#ResourcePolicyConflictException":
      throw await de_ResourcePolicyConflictExceptionRes(parsedOutput, context);
    case "ResourcePolicyInvalidParameterException":
    case "com.amazonaws.ssm#ResourcePolicyInvalidParameterException":
      throw await de_ResourcePolicyInvalidParameterExceptionRes(parsedOutput, context);
    case "ResourcePolicyNotFoundException":
    case "com.amazonaws.ssm#ResourcePolicyNotFoundException":
      throw await de_ResourcePolicyNotFoundExceptionRes(parsedOutput, context);
    case "TargetInUseException":
    case "com.amazonaws.ssm#TargetInUseException":
      throw await de_TargetInUseExceptionRes(parsedOutput, context);
    case "InvalidFilter":
    case "com.amazonaws.ssm#InvalidFilter":
      throw await de_InvalidFilterRes(parsedOutput, context);
    case "InvalidNextToken":
    case "com.amazonaws.ssm#InvalidNextToken":
      throw await de_InvalidNextTokenRes(parsedOutput, context);
    case "InvalidAssociationVersion":
    case "com.amazonaws.ssm#InvalidAssociationVersion":
      throw await de_InvalidAssociationVersionRes(parsedOutput, context);
    case "AssociationExecutionDoesNotExist":
    case "com.amazonaws.ssm#AssociationExecutionDoesNotExist":
      throw await de_AssociationExecutionDoesNotExistRes(parsedOutput, context);
    case "InvalidFilterKey":
    case "com.amazonaws.ssm#InvalidFilterKey":
      throw await de_InvalidFilterKeyRes(parsedOutput, context);
    case "InvalidFilterValue":
    case "com.amazonaws.ssm#InvalidFilterValue":
      throw await de_InvalidFilterValueRes(parsedOutput, context);
    case "AutomationExecutionNotFoundException":
    case "com.amazonaws.ssm#AutomationExecutionNotFoundException":
      throw await de_AutomationExecutionNotFoundExceptionRes(parsedOutput, context);
    case "InvalidPermissionType":
    case "com.amazonaws.ssm#InvalidPermissionType":
      throw await de_InvalidPermissionTypeRes(parsedOutput, context);
    case "UnsupportedOperatingSystem":
    case "com.amazonaws.ssm#UnsupportedOperatingSystem":
      throw await de_UnsupportedOperatingSystemRes(parsedOutput, context);
    case "InvalidInstanceInformationFilterValue":
    case "com.amazonaws.ssm#InvalidInstanceInformationFilterValue":
      throw await de_InvalidInstanceInformationFilterValueRes(parsedOutput, context);
    case "InvalidInstancePropertyFilterValue":
    case "com.amazonaws.ssm#InvalidInstancePropertyFilterValue":
      throw await de_InvalidInstancePropertyFilterValueRes(parsedOutput, context);
    case "InvalidDeletionIdException":
    case "com.amazonaws.ssm#InvalidDeletionIdException":
      throw await de_InvalidDeletionIdExceptionRes(parsedOutput, context);
    case "InvalidFilterOption":
    case "com.amazonaws.ssm#InvalidFilterOption":
      throw await de_InvalidFilterOptionRes(parsedOutput, context);
    case "OpsItemRelatedItemAssociationNotFoundException":
    case "com.amazonaws.ssm#OpsItemRelatedItemAssociationNotFoundException":
      throw await de_OpsItemRelatedItemAssociationNotFoundExceptionRes(parsedOutput, context);
    case "AccessDeniedException":
    case "com.amazonaws.ssm#AccessDeniedException":
      throw await de_AccessDeniedExceptionRes(parsedOutput, context);
    case "ThrottlingException":
    case "com.amazonaws.ssm#ThrottlingException":
      throw await de_ThrottlingExceptionRes(parsedOutput, context);
    case "ValidationException":
    case "com.amazonaws.ssm#ValidationException":
      throw await de_ValidationExceptionRes(parsedOutput, context);
    case "InvalidDocumentType":
    case "com.amazonaws.ssm#InvalidDocumentType":
      throw await de_InvalidDocumentTypeRes(parsedOutput, context);
    case "UnsupportedCalendarException":
    case "com.amazonaws.ssm#UnsupportedCalendarException":
      throw await de_UnsupportedCalendarExceptionRes(parsedOutput, context);
    case "InvalidPluginName":
    case "com.amazonaws.ssm#InvalidPluginName":
      throw await de_InvalidPluginNameRes(parsedOutput, context);
    case "InvocationDoesNotExist":
    case "com.amazonaws.ssm#InvocationDoesNotExist":
      throw await de_InvocationDoesNotExistRes(parsedOutput, context);
    case "UnsupportedFeatureRequiredException":
    case "com.amazonaws.ssm#UnsupportedFeatureRequiredException":
      throw await de_UnsupportedFeatureRequiredExceptionRes(parsedOutput, context);
    case "InvalidAggregatorException":
    case "com.amazonaws.ssm#InvalidAggregatorException":
      throw await de_InvalidAggregatorExceptionRes(parsedOutput, context);
    case "InvalidInventoryGroupException":
    case "com.amazonaws.ssm#InvalidInventoryGroupException":
      throw await de_InvalidInventoryGroupExceptionRes(parsedOutput, context);
    case "InvalidResultAttributeException":
    case "com.amazonaws.ssm#InvalidResultAttributeException":
      throw await de_InvalidResultAttributeExceptionRes(parsedOutput, context);
    case "InvalidKeyId":
    case "com.amazonaws.ssm#InvalidKeyId":
      throw await de_InvalidKeyIdRes(parsedOutput, context);
    case "ParameterVersionNotFound":
    case "com.amazonaws.ssm#ParameterVersionNotFound":
      throw await de_ParameterVersionNotFoundRes(parsedOutput, context);
    case "ServiceSettingNotFound":
    case "com.amazonaws.ssm#ServiceSettingNotFound":
      throw await de_ServiceSettingNotFoundRes(parsedOutput, context);
    case "ParameterVersionLabelLimitExceeded":
    case "com.amazonaws.ssm#ParameterVersionLabelLimitExceeded":
      throw await de_ParameterVersionLabelLimitExceededRes(parsedOutput, context);
    case "UnsupportedOperationException":
    case "com.amazonaws.ssm#UnsupportedOperationException":
      throw await de_UnsupportedOperationExceptionRes(parsedOutput, context);
    case "DocumentPermissionLimit":
    case "com.amazonaws.ssm#DocumentPermissionLimit":
      throw await de_DocumentPermissionLimitRes(parsedOutput, context);
    case "ComplianceTypeCountLimitExceededException":
    case "com.amazonaws.ssm#ComplianceTypeCountLimitExceededException":
      throw await de_ComplianceTypeCountLimitExceededExceptionRes(parsedOutput, context);
    case "InvalidItemContentException":
    case "com.amazonaws.ssm#InvalidItemContentException":
      throw await de_InvalidItemContentExceptionRes(parsedOutput, context);
    case "ItemSizeLimitExceededException":
    case "com.amazonaws.ssm#ItemSizeLimitExceededException":
      throw await de_ItemSizeLimitExceededExceptionRes(parsedOutput, context);
    case "TotalSizeLimitExceededException":
    case "com.amazonaws.ssm#TotalSizeLimitExceededException":
      throw await de_TotalSizeLimitExceededExceptionRes(parsedOutput, context);
    case "CustomSchemaCountLimitExceededException":
    case "com.amazonaws.ssm#CustomSchemaCountLimitExceededException":
      throw await de_CustomSchemaCountLimitExceededExceptionRes(parsedOutput, context);
    case "InvalidInventoryItemContextException":
    case "com.amazonaws.ssm#InvalidInventoryItemContextException":
      throw await de_InvalidInventoryItemContextExceptionRes(parsedOutput, context);
    case "ItemContentMismatchException":
    case "com.amazonaws.ssm#ItemContentMismatchException":
      throw await de_ItemContentMismatchExceptionRes(parsedOutput, context);
    case "SubTypeCountLimitExceededException":
    case "com.amazonaws.ssm#SubTypeCountLimitExceededException":
      throw await de_SubTypeCountLimitExceededExceptionRes(parsedOutput, context);
    case "UnsupportedInventoryItemContextException":
    case "com.amazonaws.ssm#UnsupportedInventoryItemContextException":
      throw await de_UnsupportedInventoryItemContextExceptionRes(parsedOutput, context);
    case "UnsupportedInventorySchemaVersionException":
    case "com.amazonaws.ssm#UnsupportedInventorySchemaVersionException":
      throw await de_UnsupportedInventorySchemaVersionExceptionRes(parsedOutput, context);
    case "HierarchyLevelLimitExceededException":
    case "com.amazonaws.ssm#HierarchyLevelLimitExceededException":
      throw await de_HierarchyLevelLimitExceededExceptionRes(parsedOutput, context);
    case "HierarchyTypeMismatchException":
    case "com.amazonaws.ssm#HierarchyTypeMismatchException":
      throw await de_HierarchyTypeMismatchExceptionRes(parsedOutput, context);
    case "IncompatiblePolicyException":
    case "com.amazonaws.ssm#IncompatiblePolicyException":
      throw await de_IncompatiblePolicyExceptionRes(parsedOutput, context);
    case "InvalidAllowedPatternException":
    case "com.amazonaws.ssm#InvalidAllowedPatternException":
      throw await de_InvalidAllowedPatternExceptionRes(parsedOutput, context);
    case "InvalidPolicyAttributeException":
    case "com.amazonaws.ssm#InvalidPolicyAttributeException":
      throw await de_InvalidPolicyAttributeExceptionRes(parsedOutput, context);
    case "InvalidPolicyTypeException":
    case "com.amazonaws.ssm#InvalidPolicyTypeException":
      throw await de_InvalidPolicyTypeExceptionRes(parsedOutput, context);
    case "ParameterAlreadyExists":
    case "com.amazonaws.ssm#ParameterAlreadyExists":
      throw await de_ParameterAlreadyExistsRes(parsedOutput, context);
    case "ParameterLimitExceeded":
    case "com.amazonaws.ssm#ParameterLimitExceeded":
      throw await de_ParameterLimitExceededRes(parsedOutput, context);
    case "ParameterMaxVersionLimitExceeded":
    case "com.amazonaws.ssm#ParameterMaxVersionLimitExceeded":
      throw await de_ParameterMaxVersionLimitExceededRes(parsedOutput, context);
    case "ParameterPatternMismatchException":
    case "com.amazonaws.ssm#ParameterPatternMismatchException":
      throw await de_ParameterPatternMismatchExceptionRes(parsedOutput, context);
    case "PoliciesLimitExceededException":
    case "com.amazonaws.ssm#PoliciesLimitExceededException":
      throw await de_PoliciesLimitExceededExceptionRes(parsedOutput, context);
    case "UnsupportedParameterType":
    case "com.amazonaws.ssm#UnsupportedParameterType":
      throw await de_UnsupportedParameterTypeRes(parsedOutput, context);
    case "ResourcePolicyLimitExceededException":
    case "com.amazonaws.ssm#ResourcePolicyLimitExceededException":
      throw await de_ResourcePolicyLimitExceededExceptionRes(parsedOutput, context);
    case "AlreadyExistsException":
    case "com.amazonaws.ssm#AlreadyExistsException":
      throw await de_AlreadyExistsExceptionRes(parsedOutput, context);
    case "FeatureNotAvailableException":
    case "com.amazonaws.ssm#FeatureNotAvailableException":
      throw await de_FeatureNotAvailableExceptionRes(parsedOutput, context);
    case "AutomationStepNotFoundException":
    case "com.amazonaws.ssm#AutomationStepNotFoundException":
      throw await de_AutomationStepNotFoundExceptionRes(parsedOutput, context);
    case "InvalidAutomationSignalException":
    case "com.amazonaws.ssm#InvalidAutomationSignalException":
      throw await de_InvalidAutomationSignalExceptionRes(parsedOutput, context);
    case "InvalidNotificationConfig":
    case "com.amazonaws.ssm#InvalidNotificationConfig":
      throw await de_InvalidNotificationConfigRes(parsedOutput, context);
    case "InvalidOutputFolder":
    case "com.amazonaws.ssm#InvalidOutputFolder":
      throw await de_InvalidOutputFolderRes(parsedOutput, context);
    case "InvalidRole":
    case "com.amazonaws.ssm#InvalidRole":
      throw await de_InvalidRoleRes(parsedOutput, context);
    case "ServiceQuotaExceededException":
    case "com.amazonaws.ssm#ServiceQuotaExceededException":
      throw await de_ServiceQuotaExceededExceptionRes(parsedOutput, context);
    case "InvalidAssociation":
    case "com.amazonaws.ssm#InvalidAssociation":
      throw await de_InvalidAssociationRes(parsedOutput, context);
    case "AutomationDefinitionNotFoundException":
    case "com.amazonaws.ssm#AutomationDefinitionNotFoundException":
      throw await de_AutomationDefinitionNotFoundExceptionRes(parsedOutput, context);
    case "AutomationDefinitionVersionNotFoundException":
    case "com.amazonaws.ssm#AutomationDefinitionVersionNotFoundException":
      throw await de_AutomationDefinitionVersionNotFoundExceptionRes(parsedOutput, context);
    case "AutomationExecutionLimitExceededException":
    case "com.amazonaws.ssm#AutomationExecutionLimitExceededException":
      throw await de_AutomationExecutionLimitExceededExceptionRes(parsedOutput, context);
    case "InvalidAutomationExecutionParametersException":
    case "com.amazonaws.ssm#InvalidAutomationExecutionParametersException":
      throw await de_InvalidAutomationExecutionParametersExceptionRes(parsedOutput, context);
    case "AutomationDefinitionNotApprovedException":
    case "com.amazonaws.ssm#AutomationDefinitionNotApprovedException":
      throw await de_AutomationDefinitionNotApprovedExceptionRes(parsedOutput, context);
    case "TargetNotConnected":
    case "com.amazonaws.ssm#TargetNotConnected":
      throw await de_TargetNotConnectedRes(parsedOutput, context);
    case "InvalidAutomationStatusUpdateException":
    case "com.amazonaws.ssm#InvalidAutomationStatusUpdateException":
      throw await de_InvalidAutomationStatusUpdateExceptionRes(parsedOutput, context);
    case "AssociationVersionLimitExceeded":
    case "com.amazonaws.ssm#AssociationVersionLimitExceeded":
      throw await de_AssociationVersionLimitExceededRes(parsedOutput, context);
    case "InvalidUpdate":
    case "com.amazonaws.ssm#InvalidUpdate":
      throw await de_InvalidUpdateRes(parsedOutput, context);
    case "StatusUnchanged":
    case "com.amazonaws.ssm#StatusUnchanged":
      throw await de_StatusUnchangedRes(parsedOutput, context);
    case "DocumentVersionLimitExceeded":
    case "com.amazonaws.ssm#DocumentVersionLimitExceeded":
      throw await de_DocumentVersionLimitExceededRes(parsedOutput, context);
    case "DuplicateDocumentContent":
    case "com.amazonaws.ssm#DuplicateDocumentContent":
      throw await de_DuplicateDocumentContentRes(parsedOutput, context);
    case "DuplicateDocumentVersionName":
    case "com.amazonaws.ssm#DuplicateDocumentVersionName":
      throw await de_DuplicateDocumentVersionNameRes(parsedOutput, context);
    case "OpsMetadataKeyLimitExceededException":
    case "com.amazonaws.ssm#OpsMetadataKeyLimitExceededException":
      throw await de_OpsMetadataKeyLimitExceededExceptionRes(parsedOutput, context);
    case "ResourceDataSyncConflictException":
    case "com.amazonaws.ssm#ResourceDataSyncConflictException":
      throw await de_ResourceDataSyncConflictExceptionRes(parsedOutput, context);
    default:
      const parsedBody = parsedOutput.body;
      return throwDefaultError({
        output,
        parsedBody,
        errorCode
      });
  }
}, "de_CommandError");
var de_AccessDeniedExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new AccessDeniedException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_AccessDeniedExceptionRes");
var de_AlreadyExistsExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new AlreadyExistsException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_AlreadyExistsExceptionRes");
var de_AssociatedInstancesRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new AssociatedInstances({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_AssociatedInstancesRes");
var de_AssociationAlreadyExistsRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new AssociationAlreadyExists({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_AssociationAlreadyExistsRes");
var de_AssociationDoesNotExistRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new AssociationDoesNotExist({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_AssociationDoesNotExistRes");
var de_AssociationExecutionDoesNotExistRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new AssociationExecutionDoesNotExist({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_AssociationExecutionDoesNotExistRes");
var de_AssociationLimitExceededRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new AssociationLimitExceeded({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_AssociationLimitExceededRes");
var de_AssociationVersionLimitExceededRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new AssociationVersionLimitExceeded({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_AssociationVersionLimitExceededRes");
var de_AutomationDefinitionNotApprovedExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new AutomationDefinitionNotApprovedException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_AutomationDefinitionNotApprovedExceptionRes");
var de_AutomationDefinitionNotFoundExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new AutomationDefinitionNotFoundException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_AutomationDefinitionNotFoundExceptionRes");
var de_AutomationDefinitionVersionNotFoundExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new AutomationDefinitionVersionNotFoundException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_AutomationDefinitionVersionNotFoundExceptionRes");
var de_AutomationExecutionLimitExceededExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new AutomationExecutionLimitExceededException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_AutomationExecutionLimitExceededExceptionRes");
var de_AutomationExecutionNotFoundExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new AutomationExecutionNotFoundException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_AutomationExecutionNotFoundExceptionRes");
var de_AutomationStepNotFoundExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new AutomationStepNotFoundException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_AutomationStepNotFoundExceptionRes");
var de_ComplianceTypeCountLimitExceededExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ComplianceTypeCountLimitExceededException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ComplianceTypeCountLimitExceededExceptionRes");
var de_CustomSchemaCountLimitExceededExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new CustomSchemaCountLimitExceededException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_CustomSchemaCountLimitExceededExceptionRes");
var de_DocumentAlreadyExistsRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new DocumentAlreadyExists({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_DocumentAlreadyExistsRes");
var de_DocumentLimitExceededRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new DocumentLimitExceeded({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_DocumentLimitExceededRes");
var de_DocumentPermissionLimitRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new DocumentPermissionLimit({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_DocumentPermissionLimitRes");
var de_DocumentVersionLimitExceededRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new DocumentVersionLimitExceeded({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_DocumentVersionLimitExceededRes");
var de_DoesNotExistExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new DoesNotExistException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_DoesNotExistExceptionRes");
var de_DuplicateDocumentContentRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new DuplicateDocumentContent({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_DuplicateDocumentContentRes");
var de_DuplicateDocumentVersionNameRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new DuplicateDocumentVersionName({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_DuplicateDocumentVersionNameRes");
var de_DuplicateInstanceIdRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new DuplicateInstanceId({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_DuplicateInstanceIdRes");
var de_FeatureNotAvailableExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new FeatureNotAvailableException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_FeatureNotAvailableExceptionRes");
var de_HierarchyLevelLimitExceededExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new HierarchyLevelLimitExceededException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_HierarchyLevelLimitExceededExceptionRes");
var de_HierarchyTypeMismatchExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new HierarchyTypeMismatchException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_HierarchyTypeMismatchExceptionRes");
var de_IdempotentParameterMismatchRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new IdempotentParameterMismatch({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_IdempotentParameterMismatchRes");
var de_IncompatiblePolicyExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new IncompatiblePolicyException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_IncompatiblePolicyExceptionRes");
var de_InternalServerErrorRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InternalServerError({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InternalServerErrorRes");
var de_InvalidActivationRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidActivation({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidActivationRes");
var de_InvalidActivationIdRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidActivationId({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidActivationIdRes");
var de_InvalidAggregatorExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidAggregatorException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidAggregatorExceptionRes");
var de_InvalidAllowedPatternExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidAllowedPatternException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidAllowedPatternExceptionRes");
var de_InvalidAssociationRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidAssociation({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidAssociationRes");
var de_InvalidAssociationVersionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidAssociationVersion({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidAssociationVersionRes");
var de_InvalidAutomationExecutionParametersExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidAutomationExecutionParametersException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidAutomationExecutionParametersExceptionRes");
var de_InvalidAutomationSignalExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidAutomationSignalException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidAutomationSignalExceptionRes");
var de_InvalidAutomationStatusUpdateExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidAutomationStatusUpdateException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidAutomationStatusUpdateExceptionRes");
var de_InvalidCommandIdRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidCommandId({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidCommandIdRes");
var de_InvalidDeleteInventoryParametersExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidDeleteInventoryParametersException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidDeleteInventoryParametersExceptionRes");
var de_InvalidDeletionIdExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidDeletionIdException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidDeletionIdExceptionRes");
var de_InvalidDocumentRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidDocument({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidDocumentRes");
var de_InvalidDocumentContentRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidDocumentContent({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidDocumentContentRes");
var de_InvalidDocumentOperationRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidDocumentOperation({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidDocumentOperationRes");
var de_InvalidDocumentSchemaVersionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidDocumentSchemaVersion({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidDocumentSchemaVersionRes");
var de_InvalidDocumentTypeRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidDocumentType({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidDocumentTypeRes");
var de_InvalidDocumentVersionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidDocumentVersion({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidDocumentVersionRes");
var de_InvalidFilterRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidFilter({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidFilterRes");
var de_InvalidFilterKeyRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidFilterKey({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidFilterKeyRes");
var de_InvalidFilterOptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidFilterOption({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidFilterOptionRes");
var de_InvalidFilterValueRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidFilterValue({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidFilterValueRes");
var de_InvalidInstanceIdRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidInstanceId({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidInstanceIdRes");
var de_InvalidInstanceInformationFilterValueRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidInstanceInformationFilterValue({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidInstanceInformationFilterValueRes");
var de_InvalidInstancePropertyFilterValueRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidInstancePropertyFilterValue({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidInstancePropertyFilterValueRes");
var de_InvalidInventoryGroupExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidInventoryGroupException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidInventoryGroupExceptionRes");
var de_InvalidInventoryItemContextExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidInventoryItemContextException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidInventoryItemContextExceptionRes");
var de_InvalidInventoryRequestExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidInventoryRequestException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidInventoryRequestExceptionRes");
var de_InvalidItemContentExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidItemContentException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidItemContentExceptionRes");
var de_InvalidKeyIdRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidKeyId({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidKeyIdRes");
var de_InvalidNextTokenRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidNextToken({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidNextTokenRes");
var de_InvalidNotificationConfigRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidNotificationConfig({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidNotificationConfigRes");
var de_InvalidOptionExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidOptionException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidOptionExceptionRes");
var de_InvalidOutputFolderRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidOutputFolder({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidOutputFolderRes");
var de_InvalidOutputLocationRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidOutputLocation({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidOutputLocationRes");
var de_InvalidParametersRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidParameters({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidParametersRes");
var de_InvalidPermissionTypeRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidPermissionType({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidPermissionTypeRes");
var de_InvalidPluginNameRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidPluginName({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidPluginNameRes");
var de_InvalidPolicyAttributeExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidPolicyAttributeException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidPolicyAttributeExceptionRes");
var de_InvalidPolicyTypeExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidPolicyTypeException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidPolicyTypeExceptionRes");
var de_InvalidResourceIdRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidResourceId({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidResourceIdRes");
var de_InvalidResourceTypeRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidResourceType({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidResourceTypeRes");
var de_InvalidResultAttributeExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidResultAttributeException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidResultAttributeExceptionRes");
var de_InvalidRoleRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidRole({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidRoleRes");
var de_InvalidScheduleRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidSchedule({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidScheduleRes");
var de_InvalidTagRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidTag({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidTagRes");
var de_InvalidTargetRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidTarget({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidTargetRes");
var de_InvalidTargetMapsRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidTargetMaps({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidTargetMapsRes");
var de_InvalidTypeNameExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidTypeNameException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidTypeNameExceptionRes");
var de_InvalidUpdateRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvalidUpdate({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidUpdateRes");
var de_InvocationDoesNotExistRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new InvocationDoesNotExist({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvocationDoesNotExistRes");
var de_ItemContentMismatchExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ItemContentMismatchException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ItemContentMismatchExceptionRes");
var de_ItemSizeLimitExceededExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ItemSizeLimitExceededException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ItemSizeLimitExceededExceptionRes");
var de_MalformedResourcePolicyDocumentExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new MalformedResourcePolicyDocumentException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_MalformedResourcePolicyDocumentExceptionRes");
var de_MaxDocumentSizeExceededRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new MaxDocumentSizeExceeded({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_MaxDocumentSizeExceededRes");
var de_OpsItemAccessDeniedExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new OpsItemAccessDeniedException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_OpsItemAccessDeniedExceptionRes");
var de_OpsItemAlreadyExistsExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new OpsItemAlreadyExistsException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_OpsItemAlreadyExistsExceptionRes");
var de_OpsItemConflictExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new OpsItemConflictException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_OpsItemConflictExceptionRes");
var de_OpsItemInvalidParameterExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new OpsItemInvalidParameterException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_OpsItemInvalidParameterExceptionRes");
var de_OpsItemLimitExceededExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new OpsItemLimitExceededException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_OpsItemLimitExceededExceptionRes");
var de_OpsItemNotFoundExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new OpsItemNotFoundException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_OpsItemNotFoundExceptionRes");
var de_OpsItemRelatedItemAlreadyExistsExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new OpsItemRelatedItemAlreadyExistsException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_OpsItemRelatedItemAlreadyExistsExceptionRes");
var de_OpsItemRelatedItemAssociationNotFoundExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new OpsItemRelatedItemAssociationNotFoundException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_OpsItemRelatedItemAssociationNotFoundExceptionRes");
var de_OpsMetadataAlreadyExistsExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new OpsMetadataAlreadyExistsException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_OpsMetadataAlreadyExistsExceptionRes");
var de_OpsMetadataInvalidArgumentExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new OpsMetadataInvalidArgumentException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_OpsMetadataInvalidArgumentExceptionRes");
var de_OpsMetadataKeyLimitExceededExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new OpsMetadataKeyLimitExceededException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_OpsMetadataKeyLimitExceededExceptionRes");
var de_OpsMetadataLimitExceededExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new OpsMetadataLimitExceededException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_OpsMetadataLimitExceededExceptionRes");
var de_OpsMetadataNotFoundExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new OpsMetadataNotFoundException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_OpsMetadataNotFoundExceptionRes");
var de_OpsMetadataTooManyUpdatesExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new OpsMetadataTooManyUpdatesException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_OpsMetadataTooManyUpdatesExceptionRes");
var de_ParameterAlreadyExistsRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ParameterAlreadyExists({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ParameterAlreadyExistsRes");
var de_ParameterLimitExceededRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ParameterLimitExceeded({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ParameterLimitExceededRes");
var de_ParameterMaxVersionLimitExceededRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ParameterMaxVersionLimitExceeded({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ParameterMaxVersionLimitExceededRes");
var de_ParameterNotFoundRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ParameterNotFound({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ParameterNotFoundRes");
var de_ParameterPatternMismatchExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ParameterPatternMismatchException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ParameterPatternMismatchExceptionRes");
var de_ParameterVersionLabelLimitExceededRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ParameterVersionLabelLimitExceeded({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ParameterVersionLabelLimitExceededRes");
var de_ParameterVersionNotFoundRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ParameterVersionNotFound({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ParameterVersionNotFoundRes");
var de_PoliciesLimitExceededExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new PoliciesLimitExceededException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_PoliciesLimitExceededExceptionRes");
var de_ResourceDataSyncAlreadyExistsExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ResourceDataSyncAlreadyExistsException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ResourceDataSyncAlreadyExistsExceptionRes");
var de_ResourceDataSyncConflictExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ResourceDataSyncConflictException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ResourceDataSyncConflictExceptionRes");
var de_ResourceDataSyncCountExceededExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ResourceDataSyncCountExceededException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ResourceDataSyncCountExceededExceptionRes");
var de_ResourceDataSyncInvalidConfigurationExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ResourceDataSyncInvalidConfigurationException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ResourceDataSyncInvalidConfigurationExceptionRes");
var de_ResourceDataSyncNotFoundExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ResourceDataSyncNotFoundException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ResourceDataSyncNotFoundExceptionRes");
var de_ResourceInUseExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ResourceInUseException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ResourceInUseExceptionRes");
var de_ResourceLimitExceededExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ResourceLimitExceededException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ResourceLimitExceededExceptionRes");
var de_ResourceNotFoundExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ResourceNotFoundException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ResourceNotFoundExceptionRes");
var de_ResourcePolicyConflictExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ResourcePolicyConflictException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ResourcePolicyConflictExceptionRes");
var de_ResourcePolicyInvalidParameterExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ResourcePolicyInvalidParameterException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ResourcePolicyInvalidParameterExceptionRes");
var de_ResourcePolicyLimitExceededExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ResourcePolicyLimitExceededException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ResourcePolicyLimitExceededExceptionRes");
var de_ResourcePolicyNotFoundExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ResourcePolicyNotFoundException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ResourcePolicyNotFoundExceptionRes");
var de_ServiceQuotaExceededExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ServiceQuotaExceededException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ServiceQuotaExceededExceptionRes");
var de_ServiceSettingNotFoundRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ServiceSettingNotFound({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ServiceSettingNotFoundRes");
var de_StatusUnchangedRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new StatusUnchanged({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_StatusUnchangedRes");
var de_SubTypeCountLimitExceededExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new SubTypeCountLimitExceededException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_SubTypeCountLimitExceededExceptionRes");
var de_TargetInUseExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new TargetInUseException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_TargetInUseExceptionRes");
var de_TargetNotConnectedRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new TargetNotConnected({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_TargetNotConnectedRes");
var de_ThrottlingExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ThrottlingException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ThrottlingExceptionRes");
var de_TooManyTagsErrorRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new TooManyTagsError({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_TooManyTagsErrorRes");
var de_TooManyUpdatesRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new TooManyUpdates({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_TooManyUpdatesRes");
var de_TotalSizeLimitExceededExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new TotalSizeLimitExceededException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_TotalSizeLimitExceededExceptionRes");
var de_UnsupportedCalendarExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new UnsupportedCalendarException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_UnsupportedCalendarExceptionRes");
var de_UnsupportedFeatureRequiredExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new UnsupportedFeatureRequiredException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_UnsupportedFeatureRequiredExceptionRes");
var de_UnsupportedInventoryItemContextExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new UnsupportedInventoryItemContextException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_UnsupportedInventoryItemContextExceptionRes");
var de_UnsupportedInventorySchemaVersionExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new UnsupportedInventorySchemaVersionException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_UnsupportedInventorySchemaVersionExceptionRes");
var de_UnsupportedOperatingSystemRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new UnsupportedOperatingSystem({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_UnsupportedOperatingSystemRes");
var de_UnsupportedOperationExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new UnsupportedOperationException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_UnsupportedOperationExceptionRes");
var de_UnsupportedParameterTypeRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new UnsupportedParameterType({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_UnsupportedParameterTypeRes");
var de_UnsupportedPlatformTypeRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new UnsupportedPlatformType({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_UnsupportedPlatformTypeRes");
var de_ValidationExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = (0, import_smithy_client._json)(body);
  const exception = new ValidationException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ValidationExceptionRes");
var se_AssociationStatus = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    AdditionalInfo: [],
    Date: /* @__PURE__ */ __name((_) => _.getTime() / 1e3, "Date"),
    Message: [],
    Name: []
  });
}, "se_AssociationStatus");
var se_ComplianceExecutionSummary = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    ExecutionId: [],
    ExecutionTime: /* @__PURE__ */ __name((_) => _.getTime() / 1e3, "ExecutionTime"),
    ExecutionType: []
  });
}, "se_ComplianceExecutionSummary");
var se_CreateActivationRequest = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    DefaultInstanceName: [],
    Description: [],
    ExpirationDate: /* @__PURE__ */ __name((_) => _.getTime() / 1e3, "ExpirationDate"),
    IamRole: [],
    RegistrationLimit: [],
    RegistrationMetadata: import_smithy_client._json,
    Tags: import_smithy_client._json
  });
}, "se_CreateActivationRequest");
var se_CreateMaintenanceWindowRequest = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    AllowUnassociatedTargets: [],
    ClientToken: [true, (_) => _ ?? (0, import_uuid.v4)()],
    Cutoff: [],
    Description: [],
    Duration: [],
    EndDate: [],
    Name: [],
    Schedule: [],
    ScheduleOffset: [],
    ScheduleTimezone: [],
    StartDate: [],
    Tags: import_smithy_client._json
  });
}, "se_CreateMaintenanceWindowRequest");
var se_CreateOpsItemRequest = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    AccountId: [],
    ActualEndTime: /* @__PURE__ */ __name((_) => _.getTime() / 1e3, "ActualEndTime"),
    ActualStartTime: /* @__PURE__ */ __name((_) => _.getTime() / 1e3, "ActualStartTime"),
    Category: [],
    Description: [],
    Notifications: import_smithy_client._json,
    OperationalData: import_smithy_client._json,
    OpsItemType: [],
    PlannedEndTime: /* @__PURE__ */ __name((_) => _.getTime() / 1e3, "PlannedEndTime"),
    PlannedStartTime: /* @__PURE__ */ __name((_) => _.getTime() / 1e3, "PlannedStartTime"),
    Priority: [],
    RelatedOpsItems: import_smithy_client._json,
    Severity: [],
    Source: [],
    Tags: import_smithy_client._json,
    Title: []
  });
}, "se_CreateOpsItemRequest");
var se_CreatePatchBaselineRequest = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    ApprovalRules: import_smithy_client._json,
    ApprovedPatches: import_smithy_client._json,
    ApprovedPatchesComplianceLevel: [],
    ApprovedPatchesEnableNonSecurity: [],
    AvailableSecurityUpdatesComplianceStatus: [],
    ClientToken: [true, (_) => _ ?? (0, import_uuid.v4)()],
    Description: [],
    GlobalFilters: import_smithy_client._json,
    Name: [],
    OperatingSystem: [],
    RejectedPatches: import_smithy_client._json,
    RejectedPatchesAction: [],
    Sources: import_smithy_client._json,
    Tags: import_smithy_client._json
  });
}, "se_CreatePatchBaselineRequest");
var se_DeleteInventoryRequest = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    ClientToken: [true, (_) => _ ?? (0, import_uuid.v4)()],
    DryRun: [],
    SchemaDeleteOption: [],
    TypeName: []
  });
}, "se_DeleteInventoryRequest");
var se_GetInventoryRequest = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    Aggregators: /* @__PURE__ */ __name((_) => se_InventoryAggregatorList(_, context), "Aggregators"),
    Filters: import_smithy_client._json,
    MaxResults: [],
    NextToken: [],
    ResultAttributes: import_smithy_client._json
  });
}, "se_GetInventoryRequest");
var se_GetOpsSummaryRequest = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    Aggregators: /* @__PURE__ */ __name((_) => se_OpsAggregatorList(_, context), "Aggregators"),
    Filters: import_smithy_client._json,
    MaxResults: [],
    NextToken: [],
    ResultAttributes: import_smithy_client._json,
    SyncName: []
  });
}, "se_GetOpsSummaryRequest");
var se_InventoryAggregator = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    Aggregators: /* @__PURE__ */ __name((_) => se_InventoryAggregatorList(_, context), "Aggregators"),
    Expression: [],
    Groups: import_smithy_client._json
  });
}, "se_InventoryAggregator");
var se_InventoryAggregatorList = /* @__PURE__ */ __name((input, context) => {
  return input.filter((e) => e != null).map((entry) => {
    return se_InventoryAggregator(entry, context);
  });
}, "se_InventoryAggregatorList");
var se_ListNodesSummaryRequest = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    Aggregators: /* @__PURE__ */ __name((_) => se_NodeAggregatorList(_, context), "Aggregators"),
    Filters: import_smithy_client._json,
    MaxResults: [],
    NextToken: [],
    SyncName: []
  });
}, "se_ListNodesSummaryRequest");
var se_MaintenanceWindowLambdaParameters = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    ClientContext: [],
    Payload: context.base64Encoder,
    Qualifier: []
  });
}, "se_MaintenanceWindowLambdaParameters");
var se_MaintenanceWindowTaskInvocationParameters = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    Automation: import_smithy_client._json,
    Lambda: /* @__PURE__ */ __name((_) => se_MaintenanceWindowLambdaParameters(_, context), "Lambda"),
    RunCommand: import_smithy_client._json,
    StepFunctions: import_smithy_client._json
  });
}, "se_MaintenanceWindowTaskInvocationParameters");
var se_NodeAggregator = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    AggregatorType: [],
    Aggregators: /* @__PURE__ */ __name((_) => se_NodeAggregatorList(_, context), "Aggregators"),
    AttributeName: [],
    TypeName: []
  });
}, "se_NodeAggregator");
var se_NodeAggregatorList = /* @__PURE__ */ __name((input, context) => {
  return input.filter((e) => e != null).map((entry) => {
    return se_NodeAggregator(entry, context);
  });
}, "se_NodeAggregatorList");
var se_OpsAggregator = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    AggregatorType: [],
    Aggregators: /* @__PURE__ */ __name((_) => se_OpsAggregatorList(_, context), "Aggregators"),
    AttributeName: [],
    Filters: import_smithy_client._json,
    TypeName: [],
    Values: import_smithy_client._json
  });
}, "se_OpsAggregator");
var se_OpsAggregatorList = /* @__PURE__ */ __name((input, context) => {
  return input.filter((e) => e != null).map((entry) => {
    return se_OpsAggregator(entry, context);
  });
}, "se_OpsAggregatorList");
var se_PutComplianceItemsRequest = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    ComplianceType: [],
    ExecutionSummary: /* @__PURE__ */ __name((_) => se_ComplianceExecutionSummary(_, context), "ExecutionSummary"),
    ItemContentHash: [],
    Items: import_smithy_client._json,
    ResourceId: [],
    ResourceType: [],
    UploadType: []
  });
}, "se_PutComplianceItemsRequest");
var se_RegisterTargetWithMaintenanceWindowRequest = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    ClientToken: [true, (_) => _ ?? (0, import_uuid.v4)()],
    Description: [],
    Name: [],
    OwnerInformation: [],
    ResourceType: [],
    Targets: import_smithy_client._json,
    WindowId: []
  });
}, "se_RegisterTargetWithMaintenanceWindowRequest");
var se_RegisterTaskWithMaintenanceWindowRequest = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    AlarmConfiguration: import_smithy_client._json,
    ClientToken: [true, (_) => _ ?? (0, import_uuid.v4)()],
    CutoffBehavior: [],
    Description: [],
    LoggingInfo: import_smithy_client._json,
    MaxConcurrency: [],
    MaxErrors: [],
    Name: [],
    Priority: [],
    ServiceRoleArn: [],
    Targets: import_smithy_client._json,
    TaskArn: [],
    TaskInvocationParameters: /* @__PURE__ */ __name((_) => se_MaintenanceWindowTaskInvocationParameters(_, context), "TaskInvocationParameters"),
    TaskParameters: import_smithy_client._json,
    TaskType: [],
    WindowId: []
  });
}, "se_RegisterTaskWithMaintenanceWindowRequest");
var se_StartChangeRequestExecutionRequest = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    AutoApprove: [],
    ChangeDetails: [],
    ChangeRequestName: [],
    ClientToken: [],
    DocumentName: [],
    DocumentVersion: [],
    Parameters: import_smithy_client._json,
    Runbooks: import_smithy_client._json,
    ScheduledEndTime: /* @__PURE__ */ __name((_) => _.getTime() / 1e3, "ScheduledEndTime"),
    ScheduledTime: /* @__PURE__ */ __name((_) => _.getTime() / 1e3, "ScheduledTime"),
    Tags: import_smithy_client._json
  });
}, "se_StartChangeRequestExecutionRequest");
var se_UpdateAssociationStatusRequest = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    AssociationStatus: /* @__PURE__ */ __name((_) => se_AssociationStatus(_, context), "AssociationStatus"),
    InstanceId: [],
    Name: []
  });
}, "se_UpdateAssociationStatusRequest");
var se_UpdateMaintenanceWindowTaskRequest = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    AlarmConfiguration: import_smithy_client._json,
    CutoffBehavior: [],
    Description: [],
    LoggingInfo: import_smithy_client._json,
    MaxConcurrency: [],
    MaxErrors: [],
    Name: [],
    Priority: [],
    Replace: [],
    ServiceRoleArn: [],
    Targets: import_smithy_client._json,
    TaskArn: [],
    TaskInvocationParameters: /* @__PURE__ */ __name((_) => se_MaintenanceWindowTaskInvocationParameters(_, context), "TaskInvocationParameters"),
    TaskParameters: import_smithy_client._json,
    WindowId: [],
    WindowTaskId: []
  });
}, "se_UpdateMaintenanceWindowTaskRequest");
var se_UpdateOpsItemRequest = /* @__PURE__ */ __name((input, context) => {
  return (0, import_smithy_client.take)(input, {
    ActualEndTime: /* @__PURE__ */ __name((_) => _.getTime() / 1e3, "ActualEndTime"),
    ActualStartTime: /* @__PURE__ */ __name((_) => _.getTime() / 1e3, "ActualStartTime"),
    Category: [],
    Description: [],
    Notifications: import_smithy_client._json,
    OperationalData: import_smithy_client._json,
    OperationalDataToDelete: import_smithy_client._json,
    OpsItemArn: [],
    OpsItemId: [],
    PlannedEndTime: /* @__PURE__ */ __name((_) => _.getTime() / 1e3, "PlannedEndTime"),
    PlannedStartTime: /* @__PURE__ */ __name((_) => _.getTime() / 1e3, "PlannedStartTime"),
    Priority: [],
    RelatedOpsItems: import_smithy_client._json,
    Severity: [],
    Status: [],
    Title: []
  });
}, "se_UpdateOpsItemRequest");
var de_Activation = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    ActivationId: import_smithy_client.expectString,
    CreatedDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "CreatedDate"),
    DefaultInstanceName: import_smithy_client.expectString,
    Description: import_smithy_client.expectString,
    ExpirationDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "ExpirationDate"),
    Expired: import_smithy_client.expectBoolean,
    IamRole: import_smithy_client.expectString,
    RegistrationLimit: import_smithy_client.expectInt32,
    RegistrationsCount: import_smithy_client.expectInt32,
    Tags: import_smithy_client._json
  });
}, "de_Activation");
var de_ActivationList = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_Activation(entry, context);
  });
  return retVal;
}, "de_ActivationList");
var de_Association = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    AssociationId: import_smithy_client.expectString,
    AssociationName: import_smithy_client.expectString,
    AssociationVersion: import_smithy_client.expectString,
    DocumentVersion: import_smithy_client.expectString,
    Duration: import_smithy_client.expectInt32,
    InstanceId: import_smithy_client.expectString,
    LastExecutionDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "LastExecutionDate"),
    Name: import_smithy_client.expectString,
    Overview: import_smithy_client._json,
    ScheduleExpression: import_smithy_client.expectString,
    ScheduleOffset: import_smithy_client.expectInt32,
    TargetMaps: import_smithy_client._json,
    Targets: import_smithy_client._json
  });
}, "de_Association");
var de_AssociationDescription = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    AlarmConfiguration: import_smithy_client._json,
    ApplyOnlyAtCronInterval: import_smithy_client.expectBoolean,
    AssociationId: import_smithy_client.expectString,
    AssociationName: import_smithy_client.expectString,
    AssociationVersion: import_smithy_client.expectString,
    AutomationTargetParameterName: import_smithy_client.expectString,
    CalendarNames: import_smithy_client._json,
    ComplianceSeverity: import_smithy_client.expectString,
    Date: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "Date"),
    DocumentVersion: import_smithy_client.expectString,
    Duration: import_smithy_client.expectInt32,
    InstanceId: import_smithy_client.expectString,
    LastExecutionDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "LastExecutionDate"),
    LastSuccessfulExecutionDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "LastSuccessfulExecutionDate"),
    LastUpdateAssociationDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "LastUpdateAssociationDate"),
    MaxConcurrency: import_smithy_client.expectString,
    MaxErrors: import_smithy_client.expectString,
    Name: import_smithy_client.expectString,
    OutputLocation: import_smithy_client._json,
    Overview: import_smithy_client._json,
    Parameters: import_smithy_client._json,
    ScheduleExpression: import_smithy_client.expectString,
    ScheduleOffset: import_smithy_client.expectInt32,
    Status: /* @__PURE__ */ __name((_) => de_AssociationStatus(_, context), "Status"),
    SyncCompliance: import_smithy_client.expectString,
    TargetLocations: import_smithy_client._json,
    TargetMaps: import_smithy_client._json,
    Targets: import_smithy_client._json,
    TriggeredAlarms: import_smithy_client._json
  });
}, "de_AssociationDescription");
var de_AssociationDescriptionList = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_AssociationDescription(entry, context);
  });
  return retVal;
}, "de_AssociationDescriptionList");
var de_AssociationExecution = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    AlarmConfiguration: import_smithy_client._json,
    AssociationId: import_smithy_client.expectString,
    AssociationVersion: import_smithy_client.expectString,
    CreatedTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "CreatedTime"),
    DetailedStatus: import_smithy_client.expectString,
    ExecutionId: import_smithy_client.expectString,
    LastExecutionDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "LastExecutionDate"),
    ResourceCountByStatus: import_smithy_client.expectString,
    Status: import_smithy_client.expectString,
    TriggeredAlarms: import_smithy_client._json
  });
}, "de_AssociationExecution");
var de_AssociationExecutionsList = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_AssociationExecution(entry, context);
  });
  return retVal;
}, "de_AssociationExecutionsList");
var de_AssociationExecutionTarget = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    AssociationId: import_smithy_client.expectString,
    AssociationVersion: import_smithy_client.expectString,
    DetailedStatus: import_smithy_client.expectString,
    ExecutionId: import_smithy_client.expectString,
    LastExecutionDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "LastExecutionDate"),
    OutputSource: import_smithy_client._json,
    ResourceId: import_smithy_client.expectString,
    ResourceType: import_smithy_client.expectString,
    Status: import_smithy_client.expectString
  });
}, "de_AssociationExecutionTarget");
var de_AssociationExecutionTargetsList = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_AssociationExecutionTarget(entry, context);
  });
  return retVal;
}, "de_AssociationExecutionTargetsList");
var de_AssociationList = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_Association(entry, context);
  });
  return retVal;
}, "de_AssociationList");
var de_AssociationStatus = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    AdditionalInfo: import_smithy_client.expectString,
    Date: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "Date"),
    Message: import_smithy_client.expectString,
    Name: import_smithy_client.expectString
  });
}, "de_AssociationStatus");
var de_AssociationVersionInfo = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    ApplyOnlyAtCronInterval: import_smithy_client.expectBoolean,
    AssociationId: import_smithy_client.expectString,
    AssociationName: import_smithy_client.expectString,
    AssociationVersion: import_smithy_client.expectString,
    CalendarNames: import_smithy_client._json,
    ComplianceSeverity: import_smithy_client.expectString,
    CreatedDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "CreatedDate"),
    DocumentVersion: import_smithy_client.expectString,
    Duration: import_smithy_client.expectInt32,
    MaxConcurrency: import_smithy_client.expectString,
    MaxErrors: import_smithy_client.expectString,
    Name: import_smithy_client.expectString,
    OutputLocation: import_smithy_client._json,
    Parameters: import_smithy_client._json,
    ScheduleExpression: import_smithy_client.expectString,
    ScheduleOffset: import_smithy_client.expectInt32,
    SyncCompliance: import_smithy_client.expectString,
    TargetLocations: import_smithy_client._json,
    TargetMaps: import_smithy_client._json,
    Targets: import_smithy_client._json
  });
}, "de_AssociationVersionInfo");
var de_AssociationVersionList = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_AssociationVersionInfo(entry, context);
  });
  return retVal;
}, "de_AssociationVersionList");
var de_AutomationExecution = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    AlarmConfiguration: import_smithy_client._json,
    AssociationId: import_smithy_client.expectString,
    AutomationExecutionId: import_smithy_client.expectString,
    AutomationExecutionStatus: import_smithy_client.expectString,
    AutomationSubtype: import_smithy_client.expectString,
    ChangeRequestName: import_smithy_client.expectString,
    CurrentAction: import_smithy_client.expectString,
    CurrentStepName: import_smithy_client.expectString,
    DocumentName: import_smithy_client.expectString,
    DocumentVersion: import_smithy_client.expectString,
    ExecutedBy: import_smithy_client.expectString,
    ExecutionEndTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "ExecutionEndTime"),
    ExecutionStartTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "ExecutionStartTime"),
    FailureMessage: import_smithy_client.expectString,
    MaxConcurrency: import_smithy_client.expectString,
    MaxErrors: import_smithy_client.expectString,
    Mode: import_smithy_client.expectString,
    OpsItemId: import_smithy_client.expectString,
    Outputs: import_smithy_client._json,
    Parameters: import_smithy_client._json,
    ParentAutomationExecutionId: import_smithy_client.expectString,
    ProgressCounters: import_smithy_client._json,
    ResolvedTargets: import_smithy_client._json,
    Runbooks: import_smithy_client._json,
    ScheduledTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "ScheduledTime"),
    StepExecutions: /* @__PURE__ */ __name((_) => de_StepExecutionList(_, context), "StepExecutions"),
    StepExecutionsTruncated: import_smithy_client.expectBoolean,
    Target: import_smithy_client.expectString,
    TargetLocations: import_smithy_client._json,
    TargetLocationsURL: import_smithy_client.expectString,
    TargetMaps: import_smithy_client._json,
    TargetParameterName: import_smithy_client.expectString,
    Targets: import_smithy_client._json,
    TriggeredAlarms: import_smithy_client._json,
    Variables: import_smithy_client._json
  });
}, "de_AutomationExecution");
var de_AutomationExecutionMetadata = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    AlarmConfiguration: import_smithy_client._json,
    AssociationId: import_smithy_client.expectString,
    AutomationExecutionId: import_smithy_client.expectString,
    AutomationExecutionStatus: import_smithy_client.expectString,
    AutomationSubtype: import_smithy_client.expectString,
    AutomationType: import_smithy_client.expectString,
    ChangeRequestName: import_smithy_client.expectString,
    CurrentAction: import_smithy_client.expectString,
    CurrentStepName: import_smithy_client.expectString,
    DocumentName: import_smithy_client.expectString,
    DocumentVersion: import_smithy_client.expectString,
    ExecutedBy: import_smithy_client.expectString,
    ExecutionEndTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "ExecutionEndTime"),
    ExecutionStartTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "ExecutionStartTime"),
    FailureMessage: import_smithy_client.expectString,
    LogFile: import_smithy_client.expectString,
    MaxConcurrency: import_smithy_client.expectString,
    MaxErrors: import_smithy_client.expectString,
    Mode: import_smithy_client.expectString,
    OpsItemId: import_smithy_client.expectString,
    Outputs: import_smithy_client._json,
    ParentAutomationExecutionId: import_smithy_client.expectString,
    ResolvedTargets: import_smithy_client._json,
    Runbooks: import_smithy_client._json,
    ScheduledTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "ScheduledTime"),
    Target: import_smithy_client.expectString,
    TargetLocationsURL: import_smithy_client.expectString,
    TargetMaps: import_smithy_client._json,
    TargetParameterName: import_smithy_client.expectString,
    Targets: import_smithy_client._json,
    TriggeredAlarms: import_smithy_client._json
  });
}, "de_AutomationExecutionMetadata");
var de_AutomationExecutionMetadataList = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_AutomationExecutionMetadata(entry, context);
  });
  return retVal;
}, "de_AutomationExecutionMetadataList");
var de_Command = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    AlarmConfiguration: import_smithy_client._json,
    CloudWatchOutputConfig: import_smithy_client._json,
    CommandId: import_smithy_client.expectString,
    Comment: import_smithy_client.expectString,
    CompletedCount: import_smithy_client.expectInt32,
    DeliveryTimedOutCount: import_smithy_client.expectInt32,
    DocumentName: import_smithy_client.expectString,
    DocumentVersion: import_smithy_client.expectString,
    ErrorCount: import_smithy_client.expectInt32,
    ExpiresAfter: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "ExpiresAfter"),
    InstanceIds: import_smithy_client._json,
    MaxConcurrency: import_smithy_client.expectString,
    MaxErrors: import_smithy_client.expectString,
    NotificationConfig: import_smithy_client._json,
    OutputS3BucketName: import_smithy_client.expectString,
    OutputS3KeyPrefix: import_smithy_client.expectString,
    OutputS3Region: import_smithy_client.expectString,
    Parameters: import_smithy_client._json,
    RequestedDateTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "RequestedDateTime"),
    ServiceRole: import_smithy_client.expectString,
    Status: import_smithy_client.expectString,
    StatusDetails: import_smithy_client.expectString,
    TargetCount: import_smithy_client.expectInt32,
    Targets: import_smithy_client._json,
    TimeoutSeconds: import_smithy_client.expectInt32,
    TriggeredAlarms: import_smithy_client._json
  });
}, "de_Command");
var de_CommandInvocation = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    CloudWatchOutputConfig: import_smithy_client._json,
    CommandId: import_smithy_client.expectString,
    CommandPlugins: /* @__PURE__ */ __name((_) => de_CommandPluginList(_, context), "CommandPlugins"),
    Comment: import_smithy_client.expectString,
    DocumentName: import_smithy_client.expectString,
    DocumentVersion: import_smithy_client.expectString,
    InstanceId: import_smithy_client.expectString,
    InstanceName: import_smithy_client.expectString,
    NotificationConfig: import_smithy_client._json,
    RequestedDateTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "RequestedDateTime"),
    ServiceRole: import_smithy_client.expectString,
    StandardErrorUrl: import_smithy_client.expectString,
    StandardOutputUrl: import_smithy_client.expectString,
    Status: import_smithy_client.expectString,
    StatusDetails: import_smithy_client.expectString,
    TraceOutput: import_smithy_client.expectString
  });
}, "de_CommandInvocation");
var de_CommandInvocationList = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_CommandInvocation(entry, context);
  });
  return retVal;
}, "de_CommandInvocationList");
var de_CommandList = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_Command(entry, context);
  });
  return retVal;
}, "de_CommandList");
var de_CommandPlugin = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    Name: import_smithy_client.expectString,
    Output: import_smithy_client.expectString,
    OutputS3BucketName: import_smithy_client.expectString,
    OutputS3KeyPrefix: import_smithy_client.expectString,
    OutputS3Region: import_smithy_client.expectString,
    ResponseCode: import_smithy_client.expectInt32,
    ResponseFinishDateTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "ResponseFinishDateTime"),
    ResponseStartDateTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "ResponseStartDateTime"),
    StandardErrorUrl: import_smithy_client.expectString,
    StandardOutputUrl: import_smithy_client.expectString,
    Status: import_smithy_client.expectString,
    StatusDetails: import_smithy_client.expectString
  });
}, "de_CommandPlugin");
var de_CommandPluginList = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_CommandPlugin(entry, context);
  });
  return retVal;
}, "de_CommandPluginList");
var de_ComplianceExecutionSummary = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    ExecutionId: import_smithy_client.expectString,
    ExecutionTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "ExecutionTime"),
    ExecutionType: import_smithy_client.expectString
  });
}, "de_ComplianceExecutionSummary");
var de_ComplianceItem = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    ComplianceType: import_smithy_client.expectString,
    Details: import_smithy_client._json,
    ExecutionSummary: /* @__PURE__ */ __name((_) => de_ComplianceExecutionSummary(_, context), "ExecutionSummary"),
    Id: import_smithy_client.expectString,
    ResourceId: import_smithy_client.expectString,
    ResourceType: import_smithy_client.expectString,
    Severity: import_smithy_client.expectString,
    Status: import_smithy_client.expectString,
    Title: import_smithy_client.expectString
  });
}, "de_ComplianceItem");
var de_ComplianceItemList = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_ComplianceItem(entry, context);
  });
  return retVal;
}, "de_ComplianceItemList");
var de_CreateAssociationBatchResult = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    Failed: import_smithy_client._json,
    Successful: /* @__PURE__ */ __name((_) => de_AssociationDescriptionList(_, context), "Successful")
  });
}, "de_CreateAssociationBatchResult");
var de_CreateAssociationResult = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    AssociationDescription: /* @__PURE__ */ __name((_) => de_AssociationDescription(_, context), "AssociationDescription")
  });
}, "de_CreateAssociationResult");
var de_CreateDocumentResult = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    DocumentDescription: /* @__PURE__ */ __name((_) => de_DocumentDescription(_, context), "DocumentDescription")
  });
}, "de_CreateDocumentResult");
var de_Credentials = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    AccessKeyId: import_smithy_client.expectString,
    ExpirationTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "ExpirationTime"),
    SecretAccessKey: import_smithy_client.expectString,
    SessionToken: import_smithy_client.expectString
  });
}, "de_Credentials");
var de_DescribeActivationsResult = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    ActivationList: /* @__PURE__ */ __name((_) => de_ActivationList(_, context), "ActivationList"),
    NextToken: import_smithy_client.expectString
  });
}, "de_DescribeActivationsResult");
var de_DescribeAssociationExecutionsResult = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    AssociationExecutions: /* @__PURE__ */ __name((_) => de_AssociationExecutionsList(_, context), "AssociationExecutions"),
    NextToken: import_smithy_client.expectString
  });
}, "de_DescribeAssociationExecutionsResult");
var de_DescribeAssociationExecutionTargetsResult = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    AssociationExecutionTargets: /* @__PURE__ */ __name((_) => de_AssociationExecutionTargetsList(_, context), "AssociationExecutionTargets"),
    NextToken: import_smithy_client.expectString
  });
}, "de_DescribeAssociationExecutionTargetsResult");
var de_DescribeAssociationResult = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    AssociationDescription: /* @__PURE__ */ __name((_) => de_AssociationDescription(_, context), "AssociationDescription")
  });
}, "de_DescribeAssociationResult");
var de_DescribeAutomationExecutionsResult = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    AutomationExecutionMetadataList: /* @__PURE__ */ __name((_) => de_AutomationExecutionMetadataList(_, context), "AutomationExecutionMetadataList"),
    NextToken: import_smithy_client.expectString
  });
}, "de_DescribeAutomationExecutionsResult");
var de_DescribeAutomationStepExecutionsResult = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    NextToken: import_smithy_client.expectString,
    StepExecutions: /* @__PURE__ */ __name((_) => de_StepExecutionList(_, context), "StepExecutions")
  });
}, "de_DescribeAutomationStepExecutionsResult");
var de_DescribeAvailablePatchesResult = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    NextToken: import_smithy_client.expectString,
    Patches: /* @__PURE__ */ __name((_) => de_PatchList(_, context), "Patches")
  });
}, "de_DescribeAvailablePatchesResult");
var de_DescribeDocumentResult = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    Document: /* @__PURE__ */ __name((_) => de_DocumentDescription(_, context), "Document")
  });
}, "de_DescribeDocumentResult");
var de_DescribeEffectivePatchesForPatchBaselineResult = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    EffectivePatches: /* @__PURE__ */ __name((_) => de_EffectivePatchList(_, context), "EffectivePatches"),
    NextToken: import_smithy_client.expectString
  });
}, "de_DescribeEffectivePatchesForPatchBaselineResult");
var de_DescribeInstanceAssociationsStatusResult = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    InstanceAssociationStatusInfos: /* @__PURE__ */ __name((_) => de_InstanceAssociationStatusInfos(_, context), "InstanceAssociationStatusInfos"),
    NextToken: import_smithy_client.expectString
  });
}, "de_DescribeInstanceAssociationsStatusResult");
var de_DescribeInstanceInformationResult = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    InstanceInformationList: /* @__PURE__ */ __name((_) => de_InstanceInformationList(_, context), "InstanceInformationList"),
    NextToken: import_smithy_client.expectString
  });
}, "de_DescribeInstanceInformationResult");
var de_DescribeInstancePatchesResult = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    NextToken: import_smithy_client.expectString,
    Patches: /* @__PURE__ */ __name((_) => de_PatchComplianceDataList(_, context), "Patches")
  });
}, "de_DescribeInstancePatchesResult");
var de_DescribeInstancePatchStatesForPatchGroupResult = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    InstancePatchStates: /* @__PURE__ */ __name((_) => de_InstancePatchStatesList(_, context), "InstancePatchStates"),
    NextToken: import_smithy_client.expectString
  });
}, "de_DescribeInstancePatchStatesForPatchGroupResult");
var de_DescribeInstancePatchStatesResult = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    InstancePatchStates: /* @__PURE__ */ __name((_) => de_InstancePatchStateList(_, context), "InstancePatchStates"),
    NextToken: import_smithy_client.expectString
  });
}, "de_DescribeInstancePatchStatesResult");
var de_DescribeInstancePropertiesResult = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    InstanceProperties: /* @__PURE__ */ __name((_) => de_InstanceProperties(_, context), "InstanceProperties"),
    NextToken: import_smithy_client.expectString
  });
}, "de_DescribeInstancePropertiesResult");
var de_DescribeInventoryDeletionsResult = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    InventoryDeletions: /* @__PURE__ */ __name((_) => de_InventoryDeletionsList(_, context), "InventoryDeletions"),
    NextToken: import_smithy_client.expectString
  });
}, "de_DescribeInventoryDeletionsResult");
var de_DescribeMaintenanceWindowExecutionsResult = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    NextToken: import_smithy_client.expectString,
    WindowExecutions: /* @__PURE__ */ __name((_) => de_MaintenanceWindowExecutionList(_, context), "WindowExecutions")
  });
}, "de_DescribeMaintenanceWindowExecutionsResult");
var de_DescribeMaintenanceWindowExecutionTaskInvocationsResult = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    NextToken: import_smithy_client.expectString,
    WindowExecutionTaskInvocationIdentities: /* @__PURE__ */ __name((_) => de_MaintenanceWindowExecutionTaskInvocationIdentityList(_, context), "WindowExecutionTaskInvocationIdentities")
  });
}, "de_DescribeMaintenanceWindowExecutionTaskInvocationsResult");
var de_DescribeMaintenanceWindowExecutionTasksResult = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    NextToken: import_smithy_client.expectString,
    WindowExecutionTaskIdentities: /* @__PURE__ */ __name((_) => de_MaintenanceWindowExecutionTaskIdentityList(_, context), "WindowExecutionTaskIdentities")
  });
}, "de_DescribeMaintenanceWindowExecutionTasksResult");
var de_DescribeOpsItemsResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    NextToken: import_smithy_client.expectString,
    OpsItemSummaries: /* @__PURE__ */ __name((_) => de_OpsItemSummaries(_, context), "OpsItemSummaries")
  });
}, "de_DescribeOpsItemsResponse");
var de_DescribeParametersResult = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    NextToken: import_smithy_client.expectString,
    Parameters: /* @__PURE__ */ __name((_) => de_ParameterMetadataList(_, context), "Parameters")
  });
}, "de_DescribeParametersResult");
var de_DescribeSessionsResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    NextToken: import_smithy_client.expectString,
    Sessions: /* @__PURE__ */ __name((_) => de_SessionList(_, context), "Sessions")
  });
}, "de_DescribeSessionsResponse");
var de_DocumentDescription = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    ApprovedVersion: import_smithy_client.expectString,
    AttachmentsInformation: import_smithy_client._json,
    Author: import_smithy_client.expectString,
    Category: import_smithy_client._json,
    CategoryEnum: import_smithy_client._json,
    CreatedDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "CreatedDate"),
    DefaultVersion: import_smithy_client.expectString,
    Description: import_smithy_client.expectString,
    DisplayName: import_smithy_client.expectString,
    DocumentFormat: import_smithy_client.expectString,
    DocumentType: import_smithy_client.expectString,
    DocumentVersion: import_smithy_client.expectString,
    Hash: import_smithy_client.expectString,
    HashType: import_smithy_client.expectString,
    LatestVersion: import_smithy_client.expectString,
    Name: import_smithy_client.expectString,
    Owner: import_smithy_client.expectString,
    Parameters: import_smithy_client._json,
    PendingReviewVersion: import_smithy_client.expectString,
    PlatformTypes: import_smithy_client._json,
    Requires: import_smithy_client._json,
    ReviewInformation: /* @__PURE__ */ __name((_) => de_ReviewInformationList(_, context), "ReviewInformation"),
    ReviewStatus: import_smithy_client.expectString,
    SchemaVersion: import_smithy_client.expectString,
    Sha1: import_smithy_client.expectString,
    Status: import_smithy_client.expectString,
    StatusInformation: import_smithy_client.expectString,
    Tags: import_smithy_client._json,
    TargetType: import_smithy_client.expectString,
    VersionName: import_smithy_client.expectString
  });
}, "de_DocumentDescription");
var de_DocumentIdentifier = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    Author: import_smithy_client.expectString,
    CreatedDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "CreatedDate"),
    DisplayName: import_smithy_client.expectString,
    DocumentFormat: import_smithy_client.expectString,
    DocumentType: import_smithy_client.expectString,
    DocumentVersion: import_smithy_client.expectString,
    Name: import_smithy_client.expectString,
    Owner: import_smithy_client.expectString,
    PlatformTypes: import_smithy_client._json,
    Requires: import_smithy_client._json,
    ReviewStatus: import_smithy_client.expectString,
    SchemaVersion: import_smithy_client.expectString,
    Tags: import_smithy_client._json,
    TargetType: import_smithy_client.expectString,
    VersionName: import_smithy_client.expectString
  });
}, "de_DocumentIdentifier");
var de_DocumentIdentifierList = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_DocumentIdentifier(entry, context);
  });
  return retVal;
}, "de_DocumentIdentifierList");
var de_DocumentMetadataResponseInfo = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    ReviewerResponse: /* @__PURE__ */ __name((_) => de_DocumentReviewerResponseList(_, context), "ReviewerResponse")
  });
}, "de_DocumentMetadataResponseInfo");
var de_DocumentReviewerResponseList = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_DocumentReviewerResponseSource(entry, context);
  });
  return retVal;
}, "de_DocumentReviewerResponseList");
var de_DocumentReviewerResponseSource = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    Comment: import_smithy_client._json,
    CreateTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "CreateTime"),
    ReviewStatus: import_smithy_client.expectString,
    Reviewer: import_smithy_client.expectString,
    UpdatedTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "UpdatedTime")
  });
}, "de_DocumentReviewerResponseSource");
var de_DocumentVersionInfo = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    CreatedDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "CreatedDate"),
    DisplayName: import_smithy_client.expectString,
    DocumentFormat: import_smithy_client.expectString,
    DocumentVersion: import_smithy_client.expectString,
    IsDefaultVersion: import_smithy_client.expectBoolean,
    Name: import_smithy_client.expectString,
    ReviewStatus: import_smithy_client.expectString,
    Status: import_smithy_client.expectString,
    StatusInformation: import_smithy_client.expectString,
    VersionName: import_smithy_client.expectString
  });
}, "de_DocumentVersionInfo");
var de_DocumentVersionList = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_DocumentVersionInfo(entry, context);
  });
  return retVal;
}, "de_DocumentVersionList");
var de_EffectivePatch = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    Patch: /* @__PURE__ */ __name((_) => de_Patch(_, context), "Patch"),
    PatchStatus: /* @__PURE__ */ __name((_) => de_PatchStatus(_, context), "PatchStatus")
  });
}, "de_EffectivePatch");
var de_EffectivePatchList = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_EffectivePatch(entry, context);
  });
  return retVal;
}, "de_EffectivePatchList");
var de_GetAccessTokenResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    AccessRequestStatus: import_smithy_client.expectString,
    Credentials: /* @__PURE__ */ __name((_) => de_Credentials(_, context), "Credentials")
  });
}, "de_GetAccessTokenResponse");
var de_GetAutomationExecutionResult = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    AutomationExecution: /* @__PURE__ */ __name((_) => de_AutomationExecution(_, context), "AutomationExecution")
  });
}, "de_GetAutomationExecutionResult");
var de_GetDocumentResult = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    AttachmentsContent: import_smithy_client._json,
    Content: import_smithy_client.expectString,
    CreatedDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "CreatedDate"),
    DisplayName: import_smithy_client.expectString,
    DocumentFormat: import_smithy_client.expectString,
    DocumentType: import_smithy_client.expectString,
    DocumentVersion: import_smithy_client.expectString,
    Name: import_smithy_client.expectString,
    Requires: import_smithy_client._json,
    ReviewStatus: import_smithy_client.expectString,
    Status: import_smithy_client.expectString,
    StatusInformation: import_smithy_client.expectString,
    VersionName: import_smithy_client.expectString
  });
}, "de_GetDocumentResult");
var de_GetExecutionPreviewResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    EndedAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "EndedAt"),
    ExecutionPreview: /* @__PURE__ */ __name((_) => (0, import_smithy_client._json)((0, import_core2.awsExpectUnion)(_)), "ExecutionPreview"),
    ExecutionPreviewId: import_smithy_client.expectString,
    Status: import_smithy_client.expectString,
    StatusMessage: import_smithy_client.expectString
  });
}, "de_GetExecutionPreviewResponse");
var de_GetMaintenanceWindowExecutionResult = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    EndTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "EndTime"),
    StartTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "StartTime"),
    Status: import_smithy_client.expectString,
    StatusDetails: import_smithy_client.expectString,
    TaskIds: import_smithy_client._json,
    WindowExecutionId: import_smithy_client.expectString
  });
}, "de_GetMaintenanceWindowExecutionResult");
var de_GetMaintenanceWindowExecutionTaskInvocationResult = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    EndTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "EndTime"),
    ExecutionId: import_smithy_client.expectString,
    InvocationId: import_smithy_client.expectString,
    OwnerInformation: import_smithy_client.expectString,
    Parameters: import_smithy_client.expectString,
    StartTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "StartTime"),
    Status: import_smithy_client.expectString,
    StatusDetails: import_smithy_client.expectString,
    TaskExecutionId: import_smithy_client.expectString,
    TaskType: import_smithy_client.expectString,
    WindowExecutionId: import_smithy_client.expectString,
    WindowTargetId: import_smithy_client.expectString
  });
}, "de_GetMaintenanceWindowExecutionTaskInvocationResult");
var de_GetMaintenanceWindowExecutionTaskResult = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    AlarmConfiguration: import_smithy_client._json,
    EndTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "EndTime"),
    MaxConcurrency: import_smithy_client.expectString,
    MaxErrors: import_smithy_client.expectString,
    Priority: import_smithy_client.expectInt32,
    ServiceRole: import_smithy_client.expectString,
    StartTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "StartTime"),
    Status: import_smithy_client.expectString,
    StatusDetails: import_smithy_client.expectString,
    TaskArn: import_smithy_client.expectString,
    TaskExecutionId: import_smithy_client.expectString,
    TaskParameters: import_smithy_client._json,
    TriggeredAlarms: import_smithy_client._json,
    Type: import_smithy_client.expectString,
    WindowExecutionId: import_smithy_client.expectString
  });
}, "de_GetMaintenanceWindowExecutionTaskResult");
var de_GetMaintenanceWindowResult = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    AllowUnassociatedTargets: import_smithy_client.expectBoolean,
    CreatedDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "CreatedDate"),
    Cutoff: import_smithy_client.expectInt32,
    Description: import_smithy_client.expectString,
    Duration: import_smithy_client.expectInt32,
    Enabled: import_smithy_client.expectBoolean,
    EndDate: import_smithy_client.expectString,
    ModifiedDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "ModifiedDate"),
    Name: import_smithy_client.expectString,
    NextExecutionTime: import_smithy_client.expectString,
    Schedule: import_smithy_client.expectString,
    ScheduleOffset: import_smithy_client.expectInt32,
    ScheduleTimezone: import_smithy_client.expectString,
    StartDate: import_smithy_client.expectString,
    WindowId: import_smithy_client.expectString
  });
}, "de_GetMaintenanceWindowResult");
var de_GetMaintenanceWindowTaskResult = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    AlarmConfiguration: import_smithy_client._json,
    CutoffBehavior: import_smithy_client.expectString,
    Description: import_smithy_client.expectString,
    LoggingInfo: import_smithy_client._json,
    MaxConcurrency: import_smithy_client.expectString,
    MaxErrors: import_smithy_client.expectString,
    Name: import_smithy_client.expectString,
    Priority: import_smithy_client.expectInt32,
    ServiceRoleArn: import_smithy_client.expectString,
    Targets: import_smithy_client._json,
    TaskArn: import_smithy_client.expectString,
    TaskInvocationParameters: /* @__PURE__ */ __name((_) => de_MaintenanceWindowTaskInvocationParameters(_, context), "TaskInvocationParameters"),
    TaskParameters: import_smithy_client._json,
    TaskType: import_smithy_client.expectString,
    WindowId: import_smithy_client.expectString,
    WindowTaskId: import_smithy_client.expectString
  });
}, "de_GetMaintenanceWindowTaskResult");
var de_GetOpsItemResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    OpsItem: /* @__PURE__ */ __name((_) => de_OpsItem(_, context), "OpsItem")
  });
}, "de_GetOpsItemResponse");
var de_GetParameterHistoryResult = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    NextToken: import_smithy_client.expectString,
    Parameters: /* @__PURE__ */ __name((_) => de_ParameterHistoryList(_, context), "Parameters")
  });
}, "de_GetParameterHistoryResult");
var de_GetParameterResult = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    Parameter: /* @__PURE__ */ __name((_) => de_Parameter(_, context), "Parameter")
  });
}, "de_GetParameterResult");
var de_GetParametersByPathResult = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    NextToken: import_smithy_client.expectString,
    Parameters: /* @__PURE__ */ __name((_) => de_ParameterList(_, context), "Parameters")
  });
}, "de_GetParametersByPathResult");
var de_GetParametersResult = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    InvalidParameters: import_smithy_client._json,
    Parameters: /* @__PURE__ */ __name((_) => de_ParameterList(_, context), "Parameters")
  });
}, "de_GetParametersResult");
var de_GetPatchBaselineResult = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    ApprovalRules: import_smithy_client._json,
    ApprovedPatches: import_smithy_client._json,
    ApprovedPatchesComplianceLevel: import_smithy_client.expectString,
    ApprovedPatchesEnableNonSecurity: import_smithy_client.expectBoolean,
    AvailableSecurityUpdatesComplianceStatus: import_smithy_client.expectString,
    BaselineId: import_smithy_client.expectString,
    CreatedDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "CreatedDate"),
    Description: import_smithy_client.expectString,
    GlobalFilters: import_smithy_client._json,
    ModifiedDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "ModifiedDate"),
    Name: import_smithy_client.expectString,
    OperatingSystem: import_smithy_client.expectString,
    PatchGroups: import_smithy_client._json,
    RejectedPatches: import_smithy_client._json,
    RejectedPatchesAction: import_smithy_client.expectString,
    Sources: import_smithy_client._json
  });
}, "de_GetPatchBaselineResult");
var de_GetServiceSettingResult = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    ServiceSetting: /* @__PURE__ */ __name((_) => de_ServiceSetting(_, context), "ServiceSetting")
  });
}, "de_GetServiceSettingResult");
var de_InstanceAssociationStatusInfo = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    AssociationId: import_smithy_client.expectString,
    AssociationName: import_smithy_client.expectString,
    AssociationVersion: import_smithy_client.expectString,
    DetailedStatus: import_smithy_client.expectString,
    DocumentVersion: import_smithy_client.expectString,
    ErrorCode: import_smithy_client.expectString,
    ExecutionDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "ExecutionDate"),
    ExecutionSummary: import_smithy_client.expectString,
    InstanceId: import_smithy_client.expectString,
    Name: import_smithy_client.expectString,
    OutputUrl: import_smithy_client._json,
    Status: import_smithy_client.expectString
  });
}, "de_InstanceAssociationStatusInfo");
var de_InstanceAssociationStatusInfos = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_InstanceAssociationStatusInfo(entry, context);
  });
  return retVal;
}, "de_InstanceAssociationStatusInfos");
var de_InstanceInformation = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    ActivationId: import_smithy_client.expectString,
    AgentVersion: import_smithy_client.expectString,
    AssociationOverview: import_smithy_client._json,
    AssociationStatus: import_smithy_client.expectString,
    ComputerName: import_smithy_client.expectString,
    IPAddress: import_smithy_client.expectString,
    IamRole: import_smithy_client.expectString,
    InstanceId: import_smithy_client.expectString,
    IsLatestVersion: import_smithy_client.expectBoolean,
    LastAssociationExecutionDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "LastAssociationExecutionDate"),
    LastPingDateTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "LastPingDateTime"),
    LastSuccessfulAssociationExecutionDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "LastSuccessfulAssociationExecutionDate"),
    Name: import_smithy_client.expectString,
    PingStatus: import_smithy_client.expectString,
    PlatformName: import_smithy_client.expectString,
    PlatformType: import_smithy_client.expectString,
    PlatformVersion: import_smithy_client.expectString,
    RegistrationDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "RegistrationDate"),
    ResourceType: import_smithy_client.expectString,
    SourceId: import_smithy_client.expectString,
    SourceType: import_smithy_client.expectString
  });
}, "de_InstanceInformation");
var de_InstanceInformationList = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_InstanceInformation(entry, context);
  });
  return retVal;
}, "de_InstanceInformationList");
var de_InstancePatchState = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    AvailableSecurityUpdateCount: import_smithy_client.expectInt32,
    BaselineId: import_smithy_client.expectString,
    CriticalNonCompliantCount: import_smithy_client.expectInt32,
    FailedCount: import_smithy_client.expectInt32,
    InstallOverrideList: import_smithy_client.expectString,
    InstalledCount: import_smithy_client.expectInt32,
    InstalledOtherCount: import_smithy_client.expectInt32,
    InstalledPendingRebootCount: import_smithy_client.expectInt32,
    InstalledRejectedCount: import_smithy_client.expectInt32,
    InstanceId: import_smithy_client.expectString,
    LastNoRebootInstallOperationTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "LastNoRebootInstallOperationTime"),
    MissingCount: import_smithy_client.expectInt32,
    NotApplicableCount: import_smithy_client.expectInt32,
    Operation: import_smithy_client.expectString,
    OperationEndTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "OperationEndTime"),
    OperationStartTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "OperationStartTime"),
    OtherNonCompliantCount: import_smithy_client.expectInt32,
    OwnerInformation: import_smithy_client.expectString,
    PatchGroup: import_smithy_client.expectString,
    RebootOption: import_smithy_client.expectString,
    SecurityNonCompliantCount: import_smithy_client.expectInt32,
    SnapshotId: import_smithy_client.expectString,
    UnreportedNotApplicableCount: import_smithy_client.expectInt32
  });
}, "de_InstancePatchState");
var de_InstancePatchStateList = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_InstancePatchState(entry, context);
  });
  return retVal;
}, "de_InstancePatchStateList");
var de_InstancePatchStatesList = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_InstancePatchState(entry, context);
  });
  return retVal;
}, "de_InstancePatchStatesList");
var de_InstanceProperties = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_InstanceProperty(entry, context);
  });
  return retVal;
}, "de_InstanceProperties");
var de_InstanceProperty = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    ActivationId: import_smithy_client.expectString,
    AgentVersion: import_smithy_client.expectString,
    Architecture: import_smithy_client.expectString,
    AssociationOverview: import_smithy_client._json,
    AssociationStatus: import_smithy_client.expectString,
    ComputerName: import_smithy_client.expectString,
    IPAddress: import_smithy_client.expectString,
    IamRole: import_smithy_client.expectString,
    InstanceId: import_smithy_client.expectString,
    InstanceRole: import_smithy_client.expectString,
    InstanceState: import_smithy_client.expectString,
    InstanceType: import_smithy_client.expectString,
    KeyName: import_smithy_client.expectString,
    LastAssociationExecutionDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "LastAssociationExecutionDate"),
    LastPingDateTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "LastPingDateTime"),
    LastSuccessfulAssociationExecutionDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "LastSuccessfulAssociationExecutionDate"),
    LaunchTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "LaunchTime"),
    Name: import_smithy_client.expectString,
    PingStatus: import_smithy_client.expectString,
    PlatformName: import_smithy_client.expectString,
    PlatformType: import_smithy_client.expectString,
    PlatformVersion: import_smithy_client.expectString,
    RegistrationDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "RegistrationDate"),
    ResourceType: import_smithy_client.expectString,
    SourceId: import_smithy_client.expectString,
    SourceType: import_smithy_client.expectString
  });
}, "de_InstanceProperty");
var de_InventoryDeletionsList = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_InventoryDeletionStatusItem(entry, context);
  });
  return retVal;
}, "de_InventoryDeletionsList");
var de_InventoryDeletionStatusItem = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    DeletionId: import_smithy_client.expectString,
    DeletionStartTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "DeletionStartTime"),
    DeletionSummary: import_smithy_client._json,
    LastStatus: import_smithy_client.expectString,
    LastStatusMessage: import_smithy_client.expectString,
    LastStatusUpdateTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "LastStatusUpdateTime"),
    TypeName: import_smithy_client.expectString
  });
}, "de_InventoryDeletionStatusItem");
var de_ListAssociationsResult = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    Associations: /* @__PURE__ */ __name((_) => de_AssociationList(_, context), "Associations"),
    NextToken: import_smithy_client.expectString
  });
}, "de_ListAssociationsResult");
var de_ListAssociationVersionsResult = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    AssociationVersions: /* @__PURE__ */ __name((_) => de_AssociationVersionList(_, context), "AssociationVersions"),
    NextToken: import_smithy_client.expectString
  });
}, "de_ListAssociationVersionsResult");
var de_ListCommandInvocationsResult = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    CommandInvocations: /* @__PURE__ */ __name((_) => de_CommandInvocationList(_, context), "CommandInvocations"),
    NextToken: import_smithy_client.expectString
  });
}, "de_ListCommandInvocationsResult");
var de_ListCommandsResult = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    Commands: /* @__PURE__ */ __name((_) => de_CommandList(_, context), "Commands"),
    NextToken: import_smithy_client.expectString
  });
}, "de_ListCommandsResult");
var de_ListComplianceItemsResult = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    ComplianceItems: /* @__PURE__ */ __name((_) => de_ComplianceItemList(_, context), "ComplianceItems"),
    NextToken: import_smithy_client.expectString
  });
}, "de_ListComplianceItemsResult");
var de_ListDocumentMetadataHistoryResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    Author: import_smithy_client.expectString,
    DocumentVersion: import_smithy_client.expectString,
    Metadata: /* @__PURE__ */ __name((_) => de_DocumentMetadataResponseInfo(_, context), "Metadata"),
    Name: import_smithy_client.expectString,
    NextToken: import_smithy_client.expectString
  });
}, "de_ListDocumentMetadataHistoryResponse");
var de_ListDocumentsResult = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    DocumentIdentifiers: /* @__PURE__ */ __name((_) => de_DocumentIdentifierList(_, context), "DocumentIdentifiers"),
    NextToken: import_smithy_client.expectString
  });
}, "de_ListDocumentsResult");
var de_ListDocumentVersionsResult = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    DocumentVersions: /* @__PURE__ */ __name((_) => de_DocumentVersionList(_, context), "DocumentVersions"),
    NextToken: import_smithy_client.expectString
  });
}, "de_ListDocumentVersionsResult");
var de_ListNodesResult = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    NextToken: import_smithy_client.expectString,
    Nodes: /* @__PURE__ */ __name((_) => de_NodeList(_, context), "Nodes")
  });
}, "de_ListNodesResult");
var de_ListOpsItemEventsResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    NextToken: import_smithy_client.expectString,
    Summaries: /* @__PURE__ */ __name((_) => de_OpsItemEventSummaries(_, context), "Summaries")
  });
}, "de_ListOpsItemEventsResponse");
var de_ListOpsItemRelatedItemsResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    NextToken: import_smithy_client.expectString,
    Summaries: /* @__PURE__ */ __name((_) => de_OpsItemRelatedItemSummaries(_, context), "Summaries")
  });
}, "de_ListOpsItemRelatedItemsResponse");
var de_ListOpsMetadataResult = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    NextToken: import_smithy_client.expectString,
    OpsMetadataList: /* @__PURE__ */ __name((_) => de_OpsMetadataList(_, context), "OpsMetadataList")
  });
}, "de_ListOpsMetadataResult");
var de_ListResourceComplianceSummariesResult = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    NextToken: import_smithy_client.expectString,
    ResourceComplianceSummaryItems: /* @__PURE__ */ __name((_) => de_ResourceComplianceSummaryItemList(_, context), "ResourceComplianceSummaryItems")
  });
}, "de_ListResourceComplianceSummariesResult");
var de_ListResourceDataSyncResult = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    NextToken: import_smithy_client.expectString,
    ResourceDataSyncItems: /* @__PURE__ */ __name((_) => de_ResourceDataSyncItemList(_, context), "ResourceDataSyncItems")
  });
}, "de_ListResourceDataSyncResult");
var de_MaintenanceWindowExecution = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    EndTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "EndTime"),
    StartTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "StartTime"),
    Status: import_smithy_client.expectString,
    StatusDetails: import_smithy_client.expectString,
    WindowExecutionId: import_smithy_client.expectString,
    WindowId: import_smithy_client.expectString
  });
}, "de_MaintenanceWindowExecution");
var de_MaintenanceWindowExecutionList = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_MaintenanceWindowExecution(entry, context);
  });
  return retVal;
}, "de_MaintenanceWindowExecutionList");
var de_MaintenanceWindowExecutionTaskIdentity = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    AlarmConfiguration: import_smithy_client._json,
    EndTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "EndTime"),
    StartTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "StartTime"),
    Status: import_smithy_client.expectString,
    StatusDetails: import_smithy_client.expectString,
    TaskArn: import_smithy_client.expectString,
    TaskExecutionId: import_smithy_client.expectString,
    TaskType: import_smithy_client.expectString,
    TriggeredAlarms: import_smithy_client._json,
    WindowExecutionId: import_smithy_client.expectString
  });
}, "de_MaintenanceWindowExecutionTaskIdentity");
var de_MaintenanceWindowExecutionTaskIdentityList = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_MaintenanceWindowExecutionTaskIdentity(entry, context);
  });
  return retVal;
}, "de_MaintenanceWindowExecutionTaskIdentityList");
var de_MaintenanceWindowExecutionTaskInvocationIdentity = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    EndTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "EndTime"),
    ExecutionId: import_smithy_client.expectString,
    InvocationId: import_smithy_client.expectString,
    OwnerInformation: import_smithy_client.expectString,
    Parameters: import_smithy_client.expectString,
    StartTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "StartTime"),
    Status: import_smithy_client.expectString,
    StatusDetails: import_smithy_client.expectString,
    TaskExecutionId: import_smithy_client.expectString,
    TaskType: import_smithy_client.expectString,
    WindowExecutionId: import_smithy_client.expectString,
    WindowTargetId: import_smithy_client.expectString
  });
}, "de_MaintenanceWindowExecutionTaskInvocationIdentity");
var de_MaintenanceWindowExecutionTaskInvocationIdentityList = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_MaintenanceWindowExecutionTaskInvocationIdentity(entry, context);
  });
  return retVal;
}, "de_MaintenanceWindowExecutionTaskInvocationIdentityList");
var de_MaintenanceWindowLambdaParameters = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    ClientContext: import_smithy_client.expectString,
    Payload: context.base64Decoder,
    Qualifier: import_smithy_client.expectString
  });
}, "de_MaintenanceWindowLambdaParameters");
var de_MaintenanceWindowTaskInvocationParameters = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    Automation: import_smithy_client._json,
    Lambda: /* @__PURE__ */ __name((_) => de_MaintenanceWindowLambdaParameters(_, context), "Lambda"),
    RunCommand: import_smithy_client._json,
    StepFunctions: import_smithy_client._json
  });
}, "de_MaintenanceWindowTaskInvocationParameters");
var de_Node = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    CaptureTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "CaptureTime"),
    Id: import_smithy_client.expectString,
    NodeType: /* @__PURE__ */ __name((_) => (0, import_smithy_client._json)((0, import_core2.awsExpectUnion)(_)), "NodeType"),
    Owner: import_smithy_client._json,
    Region: import_smithy_client.expectString
  });
}, "de_Node");
var de_NodeList = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_Node(entry, context);
  });
  return retVal;
}, "de_NodeList");
var de_OpsItem = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    ActualEndTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "ActualEndTime"),
    ActualStartTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "ActualStartTime"),
    Category: import_smithy_client.expectString,
    CreatedBy: import_smithy_client.expectString,
    CreatedTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "CreatedTime"),
    Description: import_smithy_client.expectString,
    LastModifiedBy: import_smithy_client.expectString,
    LastModifiedTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "LastModifiedTime"),
    Notifications: import_smithy_client._json,
    OperationalData: import_smithy_client._json,
    OpsItemArn: import_smithy_client.expectString,
    OpsItemId: import_smithy_client.expectString,
    OpsItemType: import_smithy_client.expectString,
    PlannedEndTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "PlannedEndTime"),
    PlannedStartTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "PlannedStartTime"),
    Priority: import_smithy_client.expectInt32,
    RelatedOpsItems: import_smithy_client._json,
    Severity: import_smithy_client.expectString,
    Source: import_smithy_client.expectString,
    Status: import_smithy_client.expectString,
    Title: import_smithy_client.expectString,
    Version: import_smithy_client.expectString
  });
}, "de_OpsItem");
var de_OpsItemEventSummaries = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_OpsItemEventSummary(entry, context);
  });
  return retVal;
}, "de_OpsItemEventSummaries");
var de_OpsItemEventSummary = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    CreatedBy: import_smithy_client._json,
    CreatedTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "CreatedTime"),
    Detail: import_smithy_client.expectString,
    DetailType: import_smithy_client.expectString,
    EventId: import_smithy_client.expectString,
    OpsItemId: import_smithy_client.expectString,
    Source: import_smithy_client.expectString
  });
}, "de_OpsItemEventSummary");
var de_OpsItemRelatedItemSummaries = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_OpsItemRelatedItemSummary(entry, context);
  });
  return retVal;
}, "de_OpsItemRelatedItemSummaries");
var de_OpsItemRelatedItemSummary = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    AssociationId: import_smithy_client.expectString,
    AssociationType: import_smithy_client.expectString,
    CreatedBy: import_smithy_client._json,
    CreatedTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "CreatedTime"),
    LastModifiedBy: import_smithy_client._json,
    LastModifiedTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "LastModifiedTime"),
    OpsItemId: import_smithy_client.expectString,
    ResourceType: import_smithy_client.expectString,
    ResourceUri: import_smithy_client.expectString
  });
}, "de_OpsItemRelatedItemSummary");
var de_OpsItemSummaries = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_OpsItemSummary(entry, context);
  });
  return retVal;
}, "de_OpsItemSummaries");
var de_OpsItemSummary = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    ActualEndTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "ActualEndTime"),
    ActualStartTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "ActualStartTime"),
    Category: import_smithy_client.expectString,
    CreatedBy: import_smithy_client.expectString,
    CreatedTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "CreatedTime"),
    LastModifiedBy: import_smithy_client.expectString,
    LastModifiedTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "LastModifiedTime"),
    OperationalData: import_smithy_client._json,
    OpsItemId: import_smithy_client.expectString,
    OpsItemType: import_smithy_client.expectString,
    PlannedEndTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "PlannedEndTime"),
    PlannedStartTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "PlannedStartTime"),
    Priority: import_smithy_client.expectInt32,
    Severity: import_smithy_client.expectString,
    Source: import_smithy_client.expectString,
    Status: import_smithy_client.expectString,
    Title: import_smithy_client.expectString
  });
}, "de_OpsItemSummary");
var de_OpsMetadata = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    CreationDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "CreationDate"),
    LastModifiedDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "LastModifiedDate"),
    LastModifiedUser: import_smithy_client.expectString,
    OpsMetadataArn: import_smithy_client.expectString,
    ResourceId: import_smithy_client.expectString
  });
}, "de_OpsMetadata");
var de_OpsMetadataList = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_OpsMetadata(entry, context);
  });
  return retVal;
}, "de_OpsMetadataList");
var de_Parameter = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    ARN: import_smithy_client.expectString,
    DataType: import_smithy_client.expectString,
    LastModifiedDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "LastModifiedDate"),
    Name: import_smithy_client.expectString,
    Selector: import_smithy_client.expectString,
    SourceResult: import_smithy_client.expectString,
    Type: import_smithy_client.expectString,
    Value: import_smithy_client.expectString,
    Version: import_smithy_client.expectLong
  });
}, "de_Parameter");
var de_ParameterHistory = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    AllowedPattern: import_smithy_client.expectString,
    DataType: import_smithy_client.expectString,
    Description: import_smithy_client.expectString,
    KeyId: import_smithy_client.expectString,
    Labels: import_smithy_client._json,
    LastModifiedDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "LastModifiedDate"),
    LastModifiedUser: import_smithy_client.expectString,
    Name: import_smithy_client.expectString,
    Policies: import_smithy_client._json,
    Tier: import_smithy_client.expectString,
    Type: import_smithy_client.expectString,
    Value: import_smithy_client.expectString,
    Version: import_smithy_client.expectLong
  });
}, "de_ParameterHistory");
var de_ParameterHistoryList = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_ParameterHistory(entry, context);
  });
  return retVal;
}, "de_ParameterHistoryList");
var de_ParameterList = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_Parameter(entry, context);
  });
  return retVal;
}, "de_ParameterList");
var de_ParameterMetadata = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    ARN: import_smithy_client.expectString,
    AllowedPattern: import_smithy_client.expectString,
    DataType: import_smithy_client.expectString,
    Description: import_smithy_client.expectString,
    KeyId: import_smithy_client.expectString,
    LastModifiedDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "LastModifiedDate"),
    LastModifiedUser: import_smithy_client.expectString,
    Name: import_smithy_client.expectString,
    Policies: import_smithy_client._json,
    Tier: import_smithy_client.expectString,
    Type: import_smithy_client.expectString,
    Version: import_smithy_client.expectLong
  });
}, "de_ParameterMetadata");
var de_ParameterMetadataList = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_ParameterMetadata(entry, context);
  });
  return retVal;
}, "de_ParameterMetadataList");
var de_Patch = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    AdvisoryIds: import_smithy_client._json,
    Arch: import_smithy_client.expectString,
    BugzillaIds: import_smithy_client._json,
    CVEIds: import_smithy_client._json,
    Classification: import_smithy_client.expectString,
    ContentUrl: import_smithy_client.expectString,
    Description: import_smithy_client.expectString,
    Epoch: import_smithy_client.expectInt32,
    Id: import_smithy_client.expectString,
    KbNumber: import_smithy_client.expectString,
    Language: import_smithy_client.expectString,
    MsrcNumber: import_smithy_client.expectString,
    MsrcSeverity: import_smithy_client.expectString,
    Name: import_smithy_client.expectString,
    Product: import_smithy_client.expectString,
    ProductFamily: import_smithy_client.expectString,
    Release: import_smithy_client.expectString,
    ReleaseDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "ReleaseDate"),
    Repository: import_smithy_client.expectString,
    Severity: import_smithy_client.expectString,
    Title: import_smithy_client.expectString,
    Vendor: import_smithy_client.expectString,
    Version: import_smithy_client.expectString
  });
}, "de_Patch");
var de_PatchComplianceData = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    CVEIds: import_smithy_client.expectString,
    Classification: import_smithy_client.expectString,
    InstalledTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "InstalledTime"),
    KBId: import_smithy_client.expectString,
    Severity: import_smithy_client.expectString,
    State: import_smithy_client.expectString,
    Title: import_smithy_client.expectString
  });
}, "de_PatchComplianceData");
var de_PatchComplianceDataList = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_PatchComplianceData(entry, context);
  });
  return retVal;
}, "de_PatchComplianceDataList");
var de_PatchList = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_Patch(entry, context);
  });
  return retVal;
}, "de_PatchList");
var de_PatchStatus = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    ApprovalDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "ApprovalDate"),
    ComplianceLevel: import_smithy_client.expectString,
    DeploymentStatus: import_smithy_client.expectString
  });
}, "de_PatchStatus");
var de_ResetServiceSettingResult = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    ServiceSetting: /* @__PURE__ */ __name((_) => de_ServiceSetting(_, context), "ServiceSetting")
  });
}, "de_ResetServiceSettingResult");
var de_ResourceComplianceSummaryItem = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    ComplianceType: import_smithy_client.expectString,
    CompliantSummary: import_smithy_client._json,
    ExecutionSummary: /* @__PURE__ */ __name((_) => de_ComplianceExecutionSummary(_, context), "ExecutionSummary"),
    NonCompliantSummary: import_smithy_client._json,
    OverallSeverity: import_smithy_client.expectString,
    ResourceId: import_smithy_client.expectString,
    ResourceType: import_smithy_client.expectString,
    Status: import_smithy_client.expectString
  });
}, "de_ResourceComplianceSummaryItem");
var de_ResourceComplianceSummaryItemList = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_ResourceComplianceSummaryItem(entry, context);
  });
  return retVal;
}, "de_ResourceComplianceSummaryItemList");
var de_ResourceDataSyncItem = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    LastStatus: import_smithy_client.expectString,
    LastSuccessfulSyncTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "LastSuccessfulSyncTime"),
    LastSyncStatusMessage: import_smithy_client.expectString,
    LastSyncTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "LastSyncTime"),
    S3Destination: import_smithy_client._json,
    SyncCreatedTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "SyncCreatedTime"),
    SyncLastModifiedTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "SyncLastModifiedTime"),
    SyncName: import_smithy_client.expectString,
    SyncSource: import_smithy_client._json,
    SyncType: import_smithy_client.expectString
  });
}, "de_ResourceDataSyncItem");
var de_ResourceDataSyncItemList = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_ResourceDataSyncItem(entry, context);
  });
  return retVal;
}, "de_ResourceDataSyncItemList");
var de_ReviewInformation = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    ReviewedTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "ReviewedTime"),
    Reviewer: import_smithy_client.expectString,
    Status: import_smithy_client.expectString
  });
}, "de_ReviewInformation");
var de_ReviewInformationList = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_ReviewInformation(entry, context);
  });
  return retVal;
}, "de_ReviewInformationList");
var de_SendCommandResult = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    Command: /* @__PURE__ */ __name((_) => de_Command(_, context), "Command")
  });
}, "de_SendCommandResult");
var de_ServiceSetting = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    ARN: import_smithy_client.expectString,
    LastModifiedDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "LastModifiedDate"),
    LastModifiedUser: import_smithy_client.expectString,
    SettingId: import_smithy_client.expectString,
    SettingValue: import_smithy_client.expectString,
    Status: import_smithy_client.expectString
  });
}, "de_ServiceSetting");
var de_Session = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    AccessType: import_smithy_client.expectString,
    Details: import_smithy_client.expectString,
    DocumentName: import_smithy_client.expectString,
    EndDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "EndDate"),
    MaxSessionDuration: import_smithy_client.expectString,
    OutputUrl: import_smithy_client._json,
    Owner: import_smithy_client.expectString,
    Reason: import_smithy_client.expectString,
    SessionId: import_smithy_client.expectString,
    StartDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "StartDate"),
    Status: import_smithy_client.expectString,
    Target: import_smithy_client.expectString
  });
}, "de_Session");
var de_SessionList = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_Session(entry, context);
  });
  return retVal;
}, "de_SessionList");
var de_StepExecution = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    Action: import_smithy_client.expectString,
    ExecutionEndTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "ExecutionEndTime"),
    ExecutionStartTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "ExecutionStartTime"),
    FailureDetails: import_smithy_client._json,
    FailureMessage: import_smithy_client.expectString,
    Inputs: import_smithy_client._json,
    IsCritical: import_smithy_client.expectBoolean,
    IsEnd: import_smithy_client.expectBoolean,
    MaxAttempts: import_smithy_client.expectInt32,
    NextStep: import_smithy_client.expectString,
    OnFailure: import_smithy_client.expectString,
    Outputs: import_smithy_client._json,
    OverriddenParameters: import_smithy_client._json,
    ParentStepDetails: import_smithy_client._json,
    Response: import_smithy_client.expectString,
    ResponseCode: import_smithy_client.expectString,
    StepExecutionId: import_smithy_client.expectString,
    StepName: import_smithy_client.expectString,
    StepStatus: import_smithy_client.expectString,
    TargetLocation: import_smithy_client._json,
    Targets: import_smithy_client._json,
    TimeoutSeconds: import_smithy_client.expectLong,
    TriggeredAlarms: import_smithy_client._json,
    ValidNextSteps: import_smithy_client._json
  });
}, "de_StepExecution");
var de_StepExecutionList = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_StepExecution(entry, context);
  });
  return retVal;
}, "de_StepExecutionList");
var de_UpdateAssociationResult = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    AssociationDescription: /* @__PURE__ */ __name((_) => de_AssociationDescription(_, context), "AssociationDescription")
  });
}, "de_UpdateAssociationResult");
var de_UpdateAssociationStatusResult = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    AssociationDescription: /* @__PURE__ */ __name((_) => de_AssociationDescription(_, context), "AssociationDescription")
  });
}, "de_UpdateAssociationStatusResult");
var de_UpdateDocumentResult = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    DocumentDescription: /* @__PURE__ */ __name((_) => de_DocumentDescription(_, context), "DocumentDescription")
  });
}, "de_UpdateDocumentResult");
var de_UpdateMaintenanceWindowTaskResult = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    AlarmConfiguration: import_smithy_client._json,
    CutoffBehavior: import_smithy_client.expectString,
    Description: import_smithy_client.expectString,
    LoggingInfo: import_smithy_client._json,
    MaxConcurrency: import_smithy_client.expectString,
    MaxErrors: import_smithy_client.expectString,
    Name: import_smithy_client.expectString,
    Priority: import_smithy_client.expectInt32,
    ServiceRoleArn: import_smithy_client.expectString,
    Targets: import_smithy_client._json,
    TaskArn: import_smithy_client.expectString,
    TaskInvocationParameters: /* @__PURE__ */ __name((_) => de_MaintenanceWindowTaskInvocationParameters(_, context), "TaskInvocationParameters"),
    TaskParameters: import_smithy_client._json,
    WindowId: import_smithy_client.expectString,
    WindowTaskId: import_smithy_client.expectString
  });
}, "de_UpdateMaintenanceWindowTaskResult");
var de_UpdatePatchBaselineResult = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    ApprovalRules: import_smithy_client._json,
    ApprovedPatches: import_smithy_client._json,
    ApprovedPatchesComplianceLevel: import_smithy_client.expectString,
    ApprovedPatchesEnableNonSecurity: import_smithy_client.expectBoolean,
    AvailableSecurityUpdatesComplianceStatus: import_smithy_client.expectString,
    BaselineId: import_smithy_client.expectString,
    CreatedDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "CreatedDate"),
    Description: import_smithy_client.expectString,
    GlobalFilters: import_smithy_client._json,
    ModifiedDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "ModifiedDate"),
    Name: import_smithy_client.expectString,
    OperatingSystem: import_smithy_client.expectString,
    RejectedPatches: import_smithy_client._json,
    RejectedPatchesAction: import_smithy_client.expectString,
    Sources: import_smithy_client._json
  });
}, "de_UpdatePatchBaselineResult");
var deserializeMetadata = /* @__PURE__ */ __name((output) => ({
  httpStatusCode: output.statusCode,
  requestId: output.headers["x-amzn-requestid"] ?? output.headers["x-amzn-request-id"] ?? output.headers["x-amz-request-id"],
  extendedRequestId: output.headers["x-amz-id-2"],
  cfId: output.headers["x-amz-cf-id"]
}), "deserializeMetadata");
var throwDefaultError = (0, import_smithy_client.withBaseException)(SSMServiceException);
var buildHttpRpcRequest = /* @__PURE__ */ __name(async (context, headers, path, resolvedHostname, body) => {
  const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
  const contents = {
    protocol,
    hostname,
    port,
    method: "POST",
    path: basePath.endsWith("/") ? basePath.slice(0, -1) + path : basePath + path,
    headers
  };
  if (resolvedHostname !== void 0) {
    contents.hostname = resolvedHostname;
  }
  if (body !== void 0) {
    contents.body = body;
  }
  return new import_protocol_http.HttpRequest(contents);
}, "buildHttpRpcRequest");
function sharedHeaders(operation) {
  return {
    "content-type": "application/x-amz-json-1.1",
    "x-amz-target": `AmazonSSM.${operation}`
  };
}
__name(sharedHeaders, "sharedHeaders");

// src/commands/AddTagsToResourceCommand.ts
var AddTagsToResourceCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "AddTagsToResource", {}).n("SSMClient", "AddTagsToResourceCommand").f(void 0, void 0).ser(se_AddTagsToResourceCommand).de(de_AddTagsToResourceCommand).build() {
  static {
    __name(this, "AddTagsToResourceCommand");
  }
};

// src/commands/AssociateOpsItemRelatedItemCommand.ts



var AssociateOpsItemRelatedItemCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "AssociateOpsItemRelatedItem", {}).n("SSMClient", "AssociateOpsItemRelatedItemCommand").f(void 0, void 0).ser(se_AssociateOpsItemRelatedItemCommand).de(de_AssociateOpsItemRelatedItemCommand).build() {
  static {
    __name(this, "AssociateOpsItemRelatedItemCommand");
  }
};

// src/commands/CancelCommandCommand.ts



var CancelCommandCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "CancelCommand", {}).n("SSMClient", "CancelCommandCommand").f(void 0, void 0).ser(se_CancelCommandCommand).de(de_CancelCommandCommand).build() {
  static {
    __name(this, "CancelCommandCommand");
  }
};

// src/commands/CancelMaintenanceWindowExecutionCommand.ts



var CancelMaintenanceWindowExecutionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "CancelMaintenanceWindowExecution", {}).n("SSMClient", "CancelMaintenanceWindowExecutionCommand").f(void 0, void 0).ser(se_CancelMaintenanceWindowExecutionCommand).de(de_CancelMaintenanceWindowExecutionCommand).build() {
  static {
    __name(this, "CancelMaintenanceWindowExecutionCommand");
  }
};

// src/commands/CreateActivationCommand.ts



var CreateActivationCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "CreateActivation", {}).n("SSMClient", "CreateActivationCommand").f(void 0, void 0).ser(se_CreateActivationCommand).de(de_CreateActivationCommand).build() {
  static {
    __name(this, "CreateActivationCommand");
  }
};

// src/commands/CreateAssociationBatchCommand.ts



var CreateAssociationBatchCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "CreateAssociationBatch", {}).n("SSMClient", "CreateAssociationBatchCommand").f(CreateAssociationBatchRequestFilterSensitiveLog, CreateAssociationBatchResultFilterSensitiveLog).ser(se_CreateAssociationBatchCommand).de(de_CreateAssociationBatchCommand).build() {
  static {
    __name(this, "CreateAssociationBatchCommand");
  }
};

// src/commands/CreateAssociationCommand.ts



var CreateAssociationCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "CreateAssociation", {}).n("SSMClient", "CreateAssociationCommand").f(CreateAssociationRequestFilterSensitiveLog, CreateAssociationResultFilterSensitiveLog).ser(se_CreateAssociationCommand).de(de_CreateAssociationCommand).build() {
  static {
    __name(this, "CreateAssociationCommand");
  }
};

// src/commands/CreateDocumentCommand.ts



var CreateDocumentCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "CreateDocument", {}).n("SSMClient", "CreateDocumentCommand").f(void 0, void 0).ser(se_CreateDocumentCommand).de(de_CreateDocumentCommand).build() {
  static {
    __name(this, "CreateDocumentCommand");
  }
};

// src/commands/CreateMaintenanceWindowCommand.ts



var CreateMaintenanceWindowCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "CreateMaintenanceWindow", {}).n("SSMClient", "CreateMaintenanceWindowCommand").f(CreateMaintenanceWindowRequestFilterSensitiveLog, void 0).ser(se_CreateMaintenanceWindowCommand).de(de_CreateMaintenanceWindowCommand).build() {
  static {
    __name(this, "CreateMaintenanceWindowCommand");
  }
};

// src/commands/CreateOpsItemCommand.ts



var CreateOpsItemCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "CreateOpsItem", {}).n("SSMClient", "CreateOpsItemCommand").f(void 0, void 0).ser(se_CreateOpsItemCommand).de(de_CreateOpsItemCommand).build() {
  static {
    __name(this, "CreateOpsItemCommand");
  }
};

// src/commands/CreateOpsMetadataCommand.ts



var CreateOpsMetadataCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "CreateOpsMetadata", {}).n("SSMClient", "CreateOpsMetadataCommand").f(void 0, void 0).ser(se_CreateOpsMetadataCommand).de(de_CreateOpsMetadataCommand).build() {
  static {
    __name(this, "CreateOpsMetadataCommand");
  }
};

// src/commands/CreatePatchBaselineCommand.ts



var CreatePatchBaselineCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "CreatePatchBaseline", {}).n("SSMClient", "CreatePatchBaselineCommand").f(CreatePatchBaselineRequestFilterSensitiveLog, void 0).ser(se_CreatePatchBaselineCommand).de(de_CreatePatchBaselineCommand).build() {
  static {
    __name(this, "CreatePatchBaselineCommand");
  }
};

// src/commands/CreateResourceDataSyncCommand.ts



var CreateResourceDataSyncCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "CreateResourceDataSync", {}).n("SSMClient", "CreateResourceDataSyncCommand").f(void 0, void 0).ser(se_CreateResourceDataSyncCommand).de(de_CreateResourceDataSyncCommand).build() {
  static {
    __name(this, "CreateResourceDataSyncCommand");
  }
};

// src/commands/DeleteActivationCommand.ts



var DeleteActivationCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "DeleteActivation", {}).n("SSMClient", "DeleteActivationCommand").f(void 0, void 0).ser(se_DeleteActivationCommand).de(de_DeleteActivationCommand).build() {
  static {
    __name(this, "DeleteActivationCommand");
  }
};

// src/commands/DeleteAssociationCommand.ts



var DeleteAssociationCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "DeleteAssociation", {}).n("SSMClient", "DeleteAssociationCommand").f(void 0, void 0).ser(se_DeleteAssociationCommand).de(de_DeleteAssociationCommand).build() {
  static {
    __name(this, "DeleteAssociationCommand");
  }
};

// src/commands/DeleteDocumentCommand.ts



var DeleteDocumentCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "DeleteDocument", {}).n("SSMClient", "DeleteDocumentCommand").f(void 0, void 0).ser(se_DeleteDocumentCommand).de(de_DeleteDocumentCommand).build() {
  static {
    __name(this, "DeleteDocumentCommand");
  }
};

// src/commands/DeleteInventoryCommand.ts



var DeleteInventoryCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "DeleteInventory", {}).n("SSMClient", "DeleteInventoryCommand").f(void 0, void 0).ser(se_DeleteInventoryCommand).de(de_DeleteInventoryCommand).build() {
  static {
    __name(this, "DeleteInventoryCommand");
  }
};

// src/commands/DeleteMaintenanceWindowCommand.ts



var DeleteMaintenanceWindowCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "DeleteMaintenanceWindow", {}).n("SSMClient", "DeleteMaintenanceWindowCommand").f(void 0, void 0).ser(se_DeleteMaintenanceWindowCommand).de(de_DeleteMaintenanceWindowCommand).build() {
  static {
    __name(this, "DeleteMaintenanceWindowCommand");
  }
};

// src/commands/DeleteOpsItemCommand.ts



var DeleteOpsItemCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "DeleteOpsItem", {}).n("SSMClient", "DeleteOpsItemCommand").f(void 0, void 0).ser(se_DeleteOpsItemCommand).de(de_DeleteOpsItemCommand).build() {
  static {
    __name(this, "DeleteOpsItemCommand");
  }
};

// src/commands/DeleteOpsMetadataCommand.ts



var DeleteOpsMetadataCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "DeleteOpsMetadata", {}).n("SSMClient", "DeleteOpsMetadataCommand").f(void 0, void 0).ser(se_DeleteOpsMetadataCommand).de(de_DeleteOpsMetadataCommand).build() {
  static {
    __name(this, "DeleteOpsMetadataCommand");
  }
};

// src/commands/DeleteParameterCommand.ts



var DeleteParameterCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "DeleteParameter", {}).n("SSMClient", "DeleteParameterCommand").f(void 0, void 0).ser(se_DeleteParameterCommand).de(de_DeleteParameterCommand).build() {
  static {
    __name(this, "DeleteParameterCommand");
  }
};

// src/commands/DeleteParametersCommand.ts



var DeleteParametersCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "DeleteParameters", {}).n("SSMClient", "DeleteParametersCommand").f(void 0, void 0).ser(se_DeleteParametersCommand).de(de_DeleteParametersCommand).build() {
  static {
    __name(this, "DeleteParametersCommand");
  }
};

// src/commands/DeletePatchBaselineCommand.ts



var DeletePatchBaselineCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "DeletePatchBaseline", {}).n("SSMClient", "DeletePatchBaselineCommand").f(void 0, void 0).ser(se_DeletePatchBaselineCommand).de(de_DeletePatchBaselineCommand).build() {
  static {
    __name(this, "DeletePatchBaselineCommand");
  }
};

// src/commands/DeleteResourceDataSyncCommand.ts



var DeleteResourceDataSyncCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "DeleteResourceDataSync", {}).n("SSMClient", "DeleteResourceDataSyncCommand").f(void 0, void 0).ser(se_DeleteResourceDataSyncCommand).de(de_DeleteResourceDataSyncCommand).build() {
  static {
    __name(this, "DeleteResourceDataSyncCommand");
  }
};

// src/commands/DeleteResourcePolicyCommand.ts



var DeleteResourcePolicyCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "DeleteResourcePolicy", {}).n("SSMClient", "DeleteResourcePolicyCommand").f(void 0, void 0).ser(se_DeleteResourcePolicyCommand).de(de_DeleteResourcePolicyCommand).build() {
  static {
    __name(this, "DeleteResourcePolicyCommand");
  }
};

// src/commands/DeregisterManagedInstanceCommand.ts



var DeregisterManagedInstanceCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "DeregisterManagedInstance", {}).n("SSMClient", "DeregisterManagedInstanceCommand").f(void 0, void 0).ser(se_DeregisterManagedInstanceCommand).de(de_DeregisterManagedInstanceCommand).build() {
  static {
    __name(this, "DeregisterManagedInstanceCommand");
  }
};

// src/commands/DeregisterPatchBaselineForPatchGroupCommand.ts



var DeregisterPatchBaselineForPatchGroupCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "DeregisterPatchBaselineForPatchGroup", {}).n("SSMClient", "DeregisterPatchBaselineForPatchGroupCommand").f(void 0, void 0).ser(se_DeregisterPatchBaselineForPatchGroupCommand).de(de_DeregisterPatchBaselineForPatchGroupCommand).build() {
  static {
    __name(this, "DeregisterPatchBaselineForPatchGroupCommand");
  }
};

// src/commands/DeregisterTargetFromMaintenanceWindowCommand.ts



var DeregisterTargetFromMaintenanceWindowCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "DeregisterTargetFromMaintenanceWindow", {}).n("SSMClient", "DeregisterTargetFromMaintenanceWindowCommand").f(void 0, void 0).ser(se_DeregisterTargetFromMaintenanceWindowCommand).de(de_DeregisterTargetFromMaintenanceWindowCommand).build() {
  static {
    __name(this, "DeregisterTargetFromMaintenanceWindowCommand");
  }
};

// src/commands/DeregisterTaskFromMaintenanceWindowCommand.ts



var DeregisterTaskFromMaintenanceWindowCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "DeregisterTaskFromMaintenanceWindow", {}).n("SSMClient", "DeregisterTaskFromMaintenanceWindowCommand").f(void 0, void 0).ser(se_DeregisterTaskFromMaintenanceWindowCommand).de(de_DeregisterTaskFromMaintenanceWindowCommand).build() {
  static {
    __name(this, "DeregisterTaskFromMaintenanceWindowCommand");
  }
};

// src/commands/DescribeActivationsCommand.ts



var DescribeActivationsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "DescribeActivations", {}).n("SSMClient", "DescribeActivationsCommand").f(void 0, void 0).ser(se_DescribeActivationsCommand).de(de_DescribeActivationsCommand).build() {
  static {
    __name(this, "DescribeActivationsCommand");
  }
};

// src/commands/DescribeAssociationCommand.ts



var DescribeAssociationCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "DescribeAssociation", {}).n("SSMClient", "DescribeAssociationCommand").f(void 0, DescribeAssociationResultFilterSensitiveLog).ser(se_DescribeAssociationCommand).de(de_DescribeAssociationCommand).build() {
  static {
    __name(this, "DescribeAssociationCommand");
  }
};

// src/commands/DescribeAssociationExecutionsCommand.ts



var DescribeAssociationExecutionsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "DescribeAssociationExecutions", {}).n("SSMClient", "DescribeAssociationExecutionsCommand").f(void 0, void 0).ser(se_DescribeAssociationExecutionsCommand).de(de_DescribeAssociationExecutionsCommand).build() {
  static {
    __name(this, "DescribeAssociationExecutionsCommand");
  }
};

// src/commands/DescribeAssociationExecutionTargetsCommand.ts



var DescribeAssociationExecutionTargetsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "DescribeAssociationExecutionTargets", {}).n("SSMClient", "DescribeAssociationExecutionTargetsCommand").f(void 0, void 0).ser(se_DescribeAssociationExecutionTargetsCommand).de(de_DescribeAssociationExecutionTargetsCommand).build() {
  static {
    __name(this, "DescribeAssociationExecutionTargetsCommand");
  }
};

// src/commands/DescribeAutomationExecutionsCommand.ts



var DescribeAutomationExecutionsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "DescribeAutomationExecutions", {}).n("SSMClient", "DescribeAutomationExecutionsCommand").f(void 0, void 0).ser(se_DescribeAutomationExecutionsCommand).de(de_DescribeAutomationExecutionsCommand).build() {
  static {
    __name(this, "DescribeAutomationExecutionsCommand");
  }
};

// src/commands/DescribeAutomationStepExecutionsCommand.ts



var DescribeAutomationStepExecutionsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "DescribeAutomationStepExecutions", {}).n("SSMClient", "DescribeAutomationStepExecutionsCommand").f(void 0, void 0).ser(se_DescribeAutomationStepExecutionsCommand).de(de_DescribeAutomationStepExecutionsCommand).build() {
  static {
    __name(this, "DescribeAutomationStepExecutionsCommand");
  }
};

// src/commands/DescribeAvailablePatchesCommand.ts



var DescribeAvailablePatchesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "DescribeAvailablePatches", {}).n("SSMClient", "DescribeAvailablePatchesCommand").f(void 0, void 0).ser(se_DescribeAvailablePatchesCommand).de(de_DescribeAvailablePatchesCommand).build() {
  static {
    __name(this, "DescribeAvailablePatchesCommand");
  }
};

// src/commands/DescribeDocumentCommand.ts



var DescribeDocumentCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "DescribeDocument", {}).n("SSMClient", "DescribeDocumentCommand").f(void 0, void 0).ser(se_DescribeDocumentCommand).de(de_DescribeDocumentCommand).build() {
  static {
    __name(this, "DescribeDocumentCommand");
  }
};

// src/commands/DescribeDocumentPermissionCommand.ts



var DescribeDocumentPermissionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "DescribeDocumentPermission", {}).n("SSMClient", "DescribeDocumentPermissionCommand").f(void 0, void 0).ser(se_DescribeDocumentPermissionCommand).de(de_DescribeDocumentPermissionCommand).build() {
  static {
    __name(this, "DescribeDocumentPermissionCommand");
  }
};

// src/commands/DescribeEffectiveInstanceAssociationsCommand.ts



var DescribeEffectiveInstanceAssociationsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "DescribeEffectiveInstanceAssociations", {}).n("SSMClient", "DescribeEffectiveInstanceAssociationsCommand").f(void 0, void 0).ser(se_DescribeEffectiveInstanceAssociationsCommand).de(de_DescribeEffectiveInstanceAssociationsCommand).build() {
  static {
    __name(this, "DescribeEffectiveInstanceAssociationsCommand");
  }
};

// src/commands/DescribeEffectivePatchesForPatchBaselineCommand.ts



var DescribeEffectivePatchesForPatchBaselineCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "DescribeEffectivePatchesForPatchBaseline", {}).n("SSMClient", "DescribeEffectivePatchesForPatchBaselineCommand").f(void 0, void 0).ser(se_DescribeEffectivePatchesForPatchBaselineCommand).de(de_DescribeEffectivePatchesForPatchBaselineCommand).build() {
  static {
    __name(this, "DescribeEffectivePatchesForPatchBaselineCommand");
  }
};

// src/commands/DescribeInstanceAssociationsStatusCommand.ts



var DescribeInstanceAssociationsStatusCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "DescribeInstanceAssociationsStatus", {}).n("SSMClient", "DescribeInstanceAssociationsStatusCommand").f(void 0, void 0).ser(se_DescribeInstanceAssociationsStatusCommand).de(de_DescribeInstanceAssociationsStatusCommand).build() {
  static {
    __name(this, "DescribeInstanceAssociationsStatusCommand");
  }
};

// src/commands/DescribeInstanceInformationCommand.ts



var DescribeInstanceInformationCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "DescribeInstanceInformation", {}).n("SSMClient", "DescribeInstanceInformationCommand").f(void 0, DescribeInstanceInformationResultFilterSensitiveLog).ser(se_DescribeInstanceInformationCommand).de(de_DescribeInstanceInformationCommand).build() {
  static {
    __name(this, "DescribeInstanceInformationCommand");
  }
};

// src/commands/DescribeInstancePatchesCommand.ts



var DescribeInstancePatchesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "DescribeInstancePatches", {}).n("SSMClient", "DescribeInstancePatchesCommand").f(void 0, void 0).ser(se_DescribeInstancePatchesCommand).de(de_DescribeInstancePatchesCommand).build() {
  static {
    __name(this, "DescribeInstancePatchesCommand");
  }
};

// src/commands/DescribeInstancePatchStatesCommand.ts



var DescribeInstancePatchStatesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "DescribeInstancePatchStates", {}).n("SSMClient", "DescribeInstancePatchStatesCommand").f(void 0, DescribeInstancePatchStatesResultFilterSensitiveLog).ser(se_DescribeInstancePatchStatesCommand).de(de_DescribeInstancePatchStatesCommand).build() {
  static {
    __name(this, "DescribeInstancePatchStatesCommand");
  }
};

// src/commands/DescribeInstancePatchStatesForPatchGroupCommand.ts



var DescribeInstancePatchStatesForPatchGroupCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "DescribeInstancePatchStatesForPatchGroup", {}).n("SSMClient", "DescribeInstancePatchStatesForPatchGroupCommand").f(void 0, DescribeInstancePatchStatesForPatchGroupResultFilterSensitiveLog).ser(se_DescribeInstancePatchStatesForPatchGroupCommand).de(de_DescribeInstancePatchStatesForPatchGroupCommand).build() {
  static {
    __name(this, "DescribeInstancePatchStatesForPatchGroupCommand");
  }
};

// src/commands/DescribeInstancePropertiesCommand.ts



var DescribeInstancePropertiesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "DescribeInstanceProperties", {}).n("SSMClient", "DescribeInstancePropertiesCommand").f(void 0, DescribeInstancePropertiesResultFilterSensitiveLog).ser(se_DescribeInstancePropertiesCommand).de(de_DescribeInstancePropertiesCommand).build() {
  static {
    __name(this, "DescribeInstancePropertiesCommand");
  }
};

// src/commands/DescribeInventoryDeletionsCommand.ts



var DescribeInventoryDeletionsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "DescribeInventoryDeletions", {}).n("SSMClient", "DescribeInventoryDeletionsCommand").f(void 0, void 0).ser(se_DescribeInventoryDeletionsCommand).de(de_DescribeInventoryDeletionsCommand).build() {
  static {
    __name(this, "DescribeInventoryDeletionsCommand");
  }
};

// src/commands/DescribeMaintenanceWindowExecutionsCommand.ts



var DescribeMaintenanceWindowExecutionsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "DescribeMaintenanceWindowExecutions", {}).n("SSMClient", "DescribeMaintenanceWindowExecutionsCommand").f(void 0, void 0).ser(se_DescribeMaintenanceWindowExecutionsCommand).de(de_DescribeMaintenanceWindowExecutionsCommand).build() {
  static {
    __name(this, "DescribeMaintenanceWindowExecutionsCommand");
  }
};

// src/commands/DescribeMaintenanceWindowExecutionTaskInvocationsCommand.ts



var DescribeMaintenanceWindowExecutionTaskInvocationsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "DescribeMaintenanceWindowExecutionTaskInvocations", {}).n("SSMClient", "DescribeMaintenanceWindowExecutionTaskInvocationsCommand").f(void 0, DescribeMaintenanceWindowExecutionTaskInvocationsResultFilterSensitiveLog).ser(se_DescribeMaintenanceWindowExecutionTaskInvocationsCommand).de(de_DescribeMaintenanceWindowExecutionTaskInvocationsCommand).build() {
  static {
    __name(this, "DescribeMaintenanceWindowExecutionTaskInvocationsCommand");
  }
};

// src/commands/DescribeMaintenanceWindowExecutionTasksCommand.ts



var DescribeMaintenanceWindowExecutionTasksCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "DescribeMaintenanceWindowExecutionTasks", {}).n("SSMClient", "DescribeMaintenanceWindowExecutionTasksCommand").f(void 0, void 0).ser(se_DescribeMaintenanceWindowExecutionTasksCommand).de(de_DescribeMaintenanceWindowExecutionTasksCommand).build() {
  static {
    __name(this, "DescribeMaintenanceWindowExecutionTasksCommand");
  }
};

// src/commands/DescribeMaintenanceWindowScheduleCommand.ts



var DescribeMaintenanceWindowScheduleCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "DescribeMaintenanceWindowSchedule", {}).n("SSMClient", "DescribeMaintenanceWindowScheduleCommand").f(void 0, void 0).ser(se_DescribeMaintenanceWindowScheduleCommand).de(de_DescribeMaintenanceWindowScheduleCommand).build() {
  static {
    __name(this, "DescribeMaintenanceWindowScheduleCommand");
  }
};

// src/commands/DescribeMaintenanceWindowsCommand.ts



var DescribeMaintenanceWindowsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "DescribeMaintenanceWindows", {}).n("SSMClient", "DescribeMaintenanceWindowsCommand").f(void 0, DescribeMaintenanceWindowsResultFilterSensitiveLog).ser(se_DescribeMaintenanceWindowsCommand).de(de_DescribeMaintenanceWindowsCommand).build() {
  static {
    __name(this, "DescribeMaintenanceWindowsCommand");
  }
};

// src/commands/DescribeMaintenanceWindowsForTargetCommand.ts



var DescribeMaintenanceWindowsForTargetCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "DescribeMaintenanceWindowsForTarget", {}).n("SSMClient", "DescribeMaintenanceWindowsForTargetCommand").f(void 0, void 0).ser(se_DescribeMaintenanceWindowsForTargetCommand).de(de_DescribeMaintenanceWindowsForTargetCommand).build() {
  static {
    __name(this, "DescribeMaintenanceWindowsForTargetCommand");
  }
};

// src/commands/DescribeMaintenanceWindowTargetsCommand.ts



var DescribeMaintenanceWindowTargetsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "DescribeMaintenanceWindowTargets", {}).n("SSMClient", "DescribeMaintenanceWindowTargetsCommand").f(void 0, DescribeMaintenanceWindowTargetsResultFilterSensitiveLog).ser(se_DescribeMaintenanceWindowTargetsCommand).de(de_DescribeMaintenanceWindowTargetsCommand).build() {
  static {
    __name(this, "DescribeMaintenanceWindowTargetsCommand");
  }
};

// src/commands/DescribeMaintenanceWindowTasksCommand.ts



var DescribeMaintenanceWindowTasksCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "DescribeMaintenanceWindowTasks", {}).n("SSMClient", "DescribeMaintenanceWindowTasksCommand").f(void 0, DescribeMaintenanceWindowTasksResultFilterSensitiveLog).ser(se_DescribeMaintenanceWindowTasksCommand).de(de_DescribeMaintenanceWindowTasksCommand).build() {
  static {
    __name(this, "DescribeMaintenanceWindowTasksCommand");
  }
};

// src/commands/DescribeOpsItemsCommand.ts



var DescribeOpsItemsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "DescribeOpsItems", {}).n("SSMClient", "DescribeOpsItemsCommand").f(void 0, void 0).ser(se_DescribeOpsItemsCommand).de(de_DescribeOpsItemsCommand).build() {
  static {
    __name(this, "DescribeOpsItemsCommand");
  }
};

// src/commands/DescribeParametersCommand.ts



var DescribeParametersCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "DescribeParameters", {}).n("SSMClient", "DescribeParametersCommand").f(void 0, void 0).ser(se_DescribeParametersCommand).de(de_DescribeParametersCommand).build() {
  static {
    __name(this, "DescribeParametersCommand");
  }
};

// src/commands/DescribePatchBaselinesCommand.ts



var DescribePatchBaselinesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "DescribePatchBaselines", {}).n("SSMClient", "DescribePatchBaselinesCommand").f(void 0, void 0).ser(se_DescribePatchBaselinesCommand).de(de_DescribePatchBaselinesCommand).build() {
  static {
    __name(this, "DescribePatchBaselinesCommand");
  }
};

// src/commands/DescribePatchGroupsCommand.ts



var DescribePatchGroupsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "DescribePatchGroups", {}).n("SSMClient", "DescribePatchGroupsCommand").f(void 0, void 0).ser(se_DescribePatchGroupsCommand).de(de_DescribePatchGroupsCommand).build() {
  static {
    __name(this, "DescribePatchGroupsCommand");
  }
};

// src/commands/DescribePatchGroupStateCommand.ts



var DescribePatchGroupStateCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "DescribePatchGroupState", {}).n("SSMClient", "DescribePatchGroupStateCommand").f(void 0, void 0).ser(se_DescribePatchGroupStateCommand).de(de_DescribePatchGroupStateCommand).build() {
  static {
    __name(this, "DescribePatchGroupStateCommand");
  }
};

// src/commands/DescribePatchPropertiesCommand.ts



var DescribePatchPropertiesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "DescribePatchProperties", {}).n("SSMClient", "DescribePatchPropertiesCommand").f(void 0, void 0).ser(se_DescribePatchPropertiesCommand).de(de_DescribePatchPropertiesCommand).build() {
  static {
    __name(this, "DescribePatchPropertiesCommand");
  }
};

// src/commands/DescribeSessionsCommand.ts



var DescribeSessionsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "DescribeSessions", {}).n("SSMClient", "DescribeSessionsCommand").f(void 0, void 0).ser(se_DescribeSessionsCommand).de(de_DescribeSessionsCommand).build() {
  static {
    __name(this, "DescribeSessionsCommand");
  }
};

// src/commands/DisassociateOpsItemRelatedItemCommand.ts



var DisassociateOpsItemRelatedItemCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "DisassociateOpsItemRelatedItem", {}).n("SSMClient", "DisassociateOpsItemRelatedItemCommand").f(void 0, void 0).ser(se_DisassociateOpsItemRelatedItemCommand).de(de_DisassociateOpsItemRelatedItemCommand).build() {
  static {
    __name(this, "DisassociateOpsItemRelatedItemCommand");
  }
};

// src/commands/GetAccessTokenCommand.ts



var GetAccessTokenCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "GetAccessToken", {}).n("SSMClient", "GetAccessTokenCommand").f(void 0, GetAccessTokenResponseFilterSensitiveLog).ser(se_GetAccessTokenCommand).de(de_GetAccessTokenCommand).build() {
  static {
    __name(this, "GetAccessTokenCommand");
  }
};

// src/commands/GetAutomationExecutionCommand.ts



var GetAutomationExecutionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "GetAutomationExecution", {}).n("SSMClient", "GetAutomationExecutionCommand").f(void 0, void 0).ser(se_GetAutomationExecutionCommand).de(de_GetAutomationExecutionCommand).build() {
  static {
    __name(this, "GetAutomationExecutionCommand");
  }
};

// src/commands/GetCalendarStateCommand.ts



var GetCalendarStateCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "GetCalendarState", {}).n("SSMClient", "GetCalendarStateCommand").f(void 0, void 0).ser(se_GetCalendarStateCommand).de(de_GetCalendarStateCommand).build() {
  static {
    __name(this, "GetCalendarStateCommand");
  }
};

// src/commands/GetCommandInvocationCommand.ts



var GetCommandInvocationCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "GetCommandInvocation", {}).n("SSMClient", "GetCommandInvocationCommand").f(void 0, void 0).ser(se_GetCommandInvocationCommand).de(de_GetCommandInvocationCommand).build() {
  static {
    __name(this, "GetCommandInvocationCommand");
  }
};

// src/commands/GetConnectionStatusCommand.ts



var GetConnectionStatusCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "GetConnectionStatus", {}).n("SSMClient", "GetConnectionStatusCommand").f(void 0, void 0).ser(se_GetConnectionStatusCommand).de(de_GetConnectionStatusCommand).build() {
  static {
    __name(this, "GetConnectionStatusCommand");
  }
};

// src/commands/GetDefaultPatchBaselineCommand.ts



var GetDefaultPatchBaselineCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "GetDefaultPatchBaseline", {}).n("SSMClient", "GetDefaultPatchBaselineCommand").f(void 0, void 0).ser(se_GetDefaultPatchBaselineCommand).de(de_GetDefaultPatchBaselineCommand).build() {
  static {
    __name(this, "GetDefaultPatchBaselineCommand");
  }
};

// src/commands/GetDeployablePatchSnapshotForInstanceCommand.ts



var GetDeployablePatchSnapshotForInstanceCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "GetDeployablePatchSnapshotForInstance", {}).n("SSMClient", "GetDeployablePatchSnapshotForInstanceCommand").f(GetDeployablePatchSnapshotForInstanceRequestFilterSensitiveLog, void 0).ser(se_GetDeployablePatchSnapshotForInstanceCommand).de(de_GetDeployablePatchSnapshotForInstanceCommand).build() {
  static {
    __name(this, "GetDeployablePatchSnapshotForInstanceCommand");
  }
};

// src/commands/GetDocumentCommand.ts



var GetDocumentCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "GetDocument", {}).n("SSMClient", "GetDocumentCommand").f(void 0, void 0).ser(se_GetDocumentCommand).de(de_GetDocumentCommand).build() {
  static {
    __name(this, "GetDocumentCommand");
  }
};

// src/commands/GetExecutionPreviewCommand.ts



var GetExecutionPreviewCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "GetExecutionPreview", {}).n("SSMClient", "GetExecutionPreviewCommand").f(void 0, void 0).ser(se_GetExecutionPreviewCommand).de(de_GetExecutionPreviewCommand).build() {
  static {
    __name(this, "GetExecutionPreviewCommand");
  }
};

// src/commands/GetInventoryCommand.ts



var GetInventoryCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "GetInventory", {}).n("SSMClient", "GetInventoryCommand").f(void 0, void 0).ser(se_GetInventoryCommand).de(de_GetInventoryCommand).build() {
  static {
    __name(this, "GetInventoryCommand");
  }
};

// src/commands/GetInventorySchemaCommand.ts



var GetInventorySchemaCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "GetInventorySchema", {}).n("SSMClient", "GetInventorySchemaCommand").f(void 0, void 0).ser(se_GetInventorySchemaCommand).de(de_GetInventorySchemaCommand).build() {
  static {
    __name(this, "GetInventorySchemaCommand");
  }
};

// src/commands/GetMaintenanceWindowCommand.ts



var GetMaintenanceWindowCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "GetMaintenanceWindow", {}).n("SSMClient", "GetMaintenanceWindowCommand").f(void 0, GetMaintenanceWindowResultFilterSensitiveLog).ser(se_GetMaintenanceWindowCommand).de(de_GetMaintenanceWindowCommand).build() {
  static {
    __name(this, "GetMaintenanceWindowCommand");
  }
};

// src/commands/GetMaintenanceWindowExecutionCommand.ts



var GetMaintenanceWindowExecutionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "GetMaintenanceWindowExecution", {}).n("SSMClient", "GetMaintenanceWindowExecutionCommand").f(void 0, void 0).ser(se_GetMaintenanceWindowExecutionCommand).de(de_GetMaintenanceWindowExecutionCommand).build() {
  static {
    __name(this, "GetMaintenanceWindowExecutionCommand");
  }
};

// src/commands/GetMaintenanceWindowExecutionTaskCommand.ts



var GetMaintenanceWindowExecutionTaskCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "GetMaintenanceWindowExecutionTask", {}).n("SSMClient", "GetMaintenanceWindowExecutionTaskCommand").f(void 0, GetMaintenanceWindowExecutionTaskResultFilterSensitiveLog).ser(se_GetMaintenanceWindowExecutionTaskCommand).de(de_GetMaintenanceWindowExecutionTaskCommand).build() {
  static {
    __name(this, "GetMaintenanceWindowExecutionTaskCommand");
  }
};

// src/commands/GetMaintenanceWindowExecutionTaskInvocationCommand.ts



var GetMaintenanceWindowExecutionTaskInvocationCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "GetMaintenanceWindowExecutionTaskInvocation", {}).n("SSMClient", "GetMaintenanceWindowExecutionTaskInvocationCommand").f(void 0, GetMaintenanceWindowExecutionTaskInvocationResultFilterSensitiveLog).ser(se_GetMaintenanceWindowExecutionTaskInvocationCommand).de(de_GetMaintenanceWindowExecutionTaskInvocationCommand).build() {
  static {
    __name(this, "GetMaintenanceWindowExecutionTaskInvocationCommand");
  }
};

// src/commands/GetMaintenanceWindowTaskCommand.ts



var GetMaintenanceWindowTaskCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "GetMaintenanceWindowTask", {}).n("SSMClient", "GetMaintenanceWindowTaskCommand").f(void 0, GetMaintenanceWindowTaskResultFilterSensitiveLog).ser(se_GetMaintenanceWindowTaskCommand).de(de_GetMaintenanceWindowTaskCommand).build() {
  static {
    __name(this, "GetMaintenanceWindowTaskCommand");
  }
};

// src/commands/GetOpsItemCommand.ts



var GetOpsItemCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "GetOpsItem", {}).n("SSMClient", "GetOpsItemCommand").f(void 0, void 0).ser(se_GetOpsItemCommand).de(de_GetOpsItemCommand).build() {
  static {
    __name(this, "GetOpsItemCommand");
  }
};

// src/commands/GetOpsMetadataCommand.ts



var GetOpsMetadataCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "GetOpsMetadata", {}).n("SSMClient", "GetOpsMetadataCommand").f(void 0, void 0).ser(se_GetOpsMetadataCommand).de(de_GetOpsMetadataCommand).build() {
  static {
    __name(this, "GetOpsMetadataCommand");
  }
};

// src/commands/GetOpsSummaryCommand.ts



var GetOpsSummaryCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "GetOpsSummary", {}).n("SSMClient", "GetOpsSummaryCommand").f(void 0, void 0).ser(se_GetOpsSummaryCommand).de(de_GetOpsSummaryCommand).build() {
  static {
    __name(this, "GetOpsSummaryCommand");
  }
};

// src/commands/GetParameterCommand.ts



var GetParameterCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "GetParameter", {}).n("SSMClient", "GetParameterCommand").f(void 0, GetParameterResultFilterSensitiveLog).ser(se_GetParameterCommand).de(de_GetParameterCommand).build() {
  static {
    __name(this, "GetParameterCommand");
  }
};

// src/commands/GetParameterHistoryCommand.ts



var GetParameterHistoryCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "GetParameterHistory", {}).n("SSMClient", "GetParameterHistoryCommand").f(void 0, GetParameterHistoryResultFilterSensitiveLog).ser(se_GetParameterHistoryCommand).de(de_GetParameterHistoryCommand).build() {
  static {
    __name(this, "GetParameterHistoryCommand");
  }
};

// src/commands/GetParametersByPathCommand.ts



var GetParametersByPathCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "GetParametersByPath", {}).n("SSMClient", "GetParametersByPathCommand").f(void 0, GetParametersByPathResultFilterSensitiveLog).ser(se_GetParametersByPathCommand).de(de_GetParametersByPathCommand).build() {
  static {
    __name(this, "GetParametersByPathCommand");
  }
};

// src/commands/GetParametersCommand.ts



var GetParametersCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "GetParameters", {}).n("SSMClient", "GetParametersCommand").f(void 0, GetParametersResultFilterSensitiveLog).ser(se_GetParametersCommand).de(de_GetParametersCommand).build() {
  static {
    __name(this, "GetParametersCommand");
  }
};

// src/commands/GetPatchBaselineCommand.ts



var GetPatchBaselineCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "GetPatchBaseline", {}).n("SSMClient", "GetPatchBaselineCommand").f(void 0, GetPatchBaselineResultFilterSensitiveLog).ser(se_GetPatchBaselineCommand).de(de_GetPatchBaselineCommand).build() {
  static {
    __name(this, "GetPatchBaselineCommand");
  }
};

// src/commands/GetPatchBaselineForPatchGroupCommand.ts



var GetPatchBaselineForPatchGroupCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "GetPatchBaselineForPatchGroup", {}).n("SSMClient", "GetPatchBaselineForPatchGroupCommand").f(void 0, void 0).ser(se_GetPatchBaselineForPatchGroupCommand).de(de_GetPatchBaselineForPatchGroupCommand).build() {
  static {
    __name(this, "GetPatchBaselineForPatchGroupCommand");
  }
};

// src/commands/GetResourcePoliciesCommand.ts



var GetResourcePoliciesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "GetResourcePolicies", {}).n("SSMClient", "GetResourcePoliciesCommand").f(void 0, void 0).ser(se_GetResourcePoliciesCommand).de(de_GetResourcePoliciesCommand).build() {
  static {
    __name(this, "GetResourcePoliciesCommand");
  }
};

// src/commands/GetServiceSettingCommand.ts



var GetServiceSettingCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "GetServiceSetting", {}).n("SSMClient", "GetServiceSettingCommand").f(void 0, void 0).ser(se_GetServiceSettingCommand).de(de_GetServiceSettingCommand).build() {
  static {
    __name(this, "GetServiceSettingCommand");
  }
};

// src/commands/LabelParameterVersionCommand.ts



var LabelParameterVersionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "LabelParameterVersion", {}).n("SSMClient", "LabelParameterVersionCommand").f(void 0, void 0).ser(se_LabelParameterVersionCommand).de(de_LabelParameterVersionCommand).build() {
  static {
    __name(this, "LabelParameterVersionCommand");
  }
};

// src/commands/ListAssociationsCommand.ts



var ListAssociationsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "ListAssociations", {}).n("SSMClient", "ListAssociationsCommand").f(void 0, void 0).ser(se_ListAssociationsCommand).de(de_ListAssociationsCommand).build() {
  static {
    __name(this, "ListAssociationsCommand");
  }
};

// src/commands/ListAssociationVersionsCommand.ts



var ListAssociationVersionsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "ListAssociationVersions", {}).n("SSMClient", "ListAssociationVersionsCommand").f(void 0, ListAssociationVersionsResultFilterSensitiveLog).ser(se_ListAssociationVersionsCommand).de(de_ListAssociationVersionsCommand).build() {
  static {
    __name(this, "ListAssociationVersionsCommand");
  }
};

// src/commands/ListCommandInvocationsCommand.ts



var ListCommandInvocationsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "ListCommandInvocations", {}).n("SSMClient", "ListCommandInvocationsCommand").f(void 0, void 0).ser(se_ListCommandInvocationsCommand).de(de_ListCommandInvocationsCommand).build() {
  static {
    __name(this, "ListCommandInvocationsCommand");
  }
};

// src/commands/ListCommandsCommand.ts



var ListCommandsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "ListCommands", {}).n("SSMClient", "ListCommandsCommand").f(void 0, ListCommandsResultFilterSensitiveLog).ser(se_ListCommandsCommand).de(de_ListCommandsCommand).build() {
  static {
    __name(this, "ListCommandsCommand");
  }
};

// src/commands/ListComplianceItemsCommand.ts



var ListComplianceItemsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "ListComplianceItems", {}).n("SSMClient", "ListComplianceItemsCommand").f(void 0, void 0).ser(se_ListComplianceItemsCommand).de(de_ListComplianceItemsCommand).build() {
  static {
    __name(this, "ListComplianceItemsCommand");
  }
};

// src/commands/ListComplianceSummariesCommand.ts



var ListComplianceSummariesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "ListComplianceSummaries", {}).n("SSMClient", "ListComplianceSummariesCommand").f(void 0, void 0).ser(se_ListComplianceSummariesCommand).de(de_ListComplianceSummariesCommand).build() {
  static {
    __name(this, "ListComplianceSummariesCommand");
  }
};

// src/commands/ListDocumentMetadataHistoryCommand.ts



var ListDocumentMetadataHistoryCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "ListDocumentMetadataHistory", {}).n("SSMClient", "ListDocumentMetadataHistoryCommand").f(void 0, void 0).ser(se_ListDocumentMetadataHistoryCommand).de(de_ListDocumentMetadataHistoryCommand).build() {
  static {
    __name(this, "ListDocumentMetadataHistoryCommand");
  }
};

// src/commands/ListDocumentsCommand.ts



var ListDocumentsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "ListDocuments", {}).n("SSMClient", "ListDocumentsCommand").f(void 0, void 0).ser(se_ListDocumentsCommand).de(de_ListDocumentsCommand).build() {
  static {
    __name(this, "ListDocumentsCommand");
  }
};

// src/commands/ListDocumentVersionsCommand.ts



var ListDocumentVersionsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "ListDocumentVersions", {}).n("SSMClient", "ListDocumentVersionsCommand").f(void 0, void 0).ser(se_ListDocumentVersionsCommand).de(de_ListDocumentVersionsCommand).build() {
  static {
    __name(this, "ListDocumentVersionsCommand");
  }
};

// src/commands/ListInventoryEntriesCommand.ts



var ListInventoryEntriesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "ListInventoryEntries", {}).n("SSMClient", "ListInventoryEntriesCommand").f(void 0, void 0).ser(se_ListInventoryEntriesCommand).de(de_ListInventoryEntriesCommand).build() {
  static {
    __name(this, "ListInventoryEntriesCommand");
  }
};

// src/commands/ListNodesCommand.ts



var ListNodesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "ListNodes", {}).n("SSMClient", "ListNodesCommand").f(void 0, ListNodesResultFilterSensitiveLog).ser(se_ListNodesCommand).de(de_ListNodesCommand).build() {
  static {
    __name(this, "ListNodesCommand");
  }
};

// src/commands/ListNodesSummaryCommand.ts



var ListNodesSummaryCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "ListNodesSummary", {}).n("SSMClient", "ListNodesSummaryCommand").f(void 0, void 0).ser(se_ListNodesSummaryCommand).de(de_ListNodesSummaryCommand).build() {
  static {
    __name(this, "ListNodesSummaryCommand");
  }
};

// src/commands/ListOpsItemEventsCommand.ts



var ListOpsItemEventsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "ListOpsItemEvents", {}).n("SSMClient", "ListOpsItemEventsCommand").f(void 0, void 0).ser(se_ListOpsItemEventsCommand).de(de_ListOpsItemEventsCommand).build() {
  static {
    __name(this, "ListOpsItemEventsCommand");
  }
};

// src/commands/ListOpsItemRelatedItemsCommand.ts



var ListOpsItemRelatedItemsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "ListOpsItemRelatedItems", {}).n("SSMClient", "ListOpsItemRelatedItemsCommand").f(void 0, void 0).ser(se_ListOpsItemRelatedItemsCommand).de(de_ListOpsItemRelatedItemsCommand).build() {
  static {
    __name(this, "ListOpsItemRelatedItemsCommand");
  }
};

// src/commands/ListOpsMetadataCommand.ts



var ListOpsMetadataCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "ListOpsMetadata", {}).n("SSMClient", "ListOpsMetadataCommand").f(void 0, void 0).ser(se_ListOpsMetadataCommand).de(de_ListOpsMetadataCommand).build() {
  static {
    __name(this, "ListOpsMetadataCommand");
  }
};

// src/commands/ListResourceComplianceSummariesCommand.ts



var ListResourceComplianceSummariesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "ListResourceComplianceSummaries", {}).n("SSMClient", "ListResourceComplianceSummariesCommand").f(void 0, void 0).ser(se_ListResourceComplianceSummariesCommand).de(de_ListResourceComplianceSummariesCommand).build() {
  static {
    __name(this, "ListResourceComplianceSummariesCommand");
  }
};

// src/commands/ListResourceDataSyncCommand.ts



var ListResourceDataSyncCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "ListResourceDataSync", {}).n("SSMClient", "ListResourceDataSyncCommand").f(void 0, void 0).ser(se_ListResourceDataSyncCommand).de(de_ListResourceDataSyncCommand).build() {
  static {
    __name(this, "ListResourceDataSyncCommand");
  }
};

// src/commands/ListTagsForResourceCommand.ts



var ListTagsForResourceCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "ListTagsForResource", {}).n("SSMClient", "ListTagsForResourceCommand").f(void 0, void 0).ser(se_ListTagsForResourceCommand).de(de_ListTagsForResourceCommand).build() {
  static {
    __name(this, "ListTagsForResourceCommand");
  }
};

// src/commands/ModifyDocumentPermissionCommand.ts



var ModifyDocumentPermissionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "ModifyDocumentPermission", {}).n("SSMClient", "ModifyDocumentPermissionCommand").f(void 0, void 0).ser(se_ModifyDocumentPermissionCommand).de(de_ModifyDocumentPermissionCommand).build() {
  static {
    __name(this, "ModifyDocumentPermissionCommand");
  }
};

// src/commands/PutComplianceItemsCommand.ts



var PutComplianceItemsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "PutComplianceItems", {}).n("SSMClient", "PutComplianceItemsCommand").f(void 0, void 0).ser(se_PutComplianceItemsCommand).de(de_PutComplianceItemsCommand).build() {
  static {
    __name(this, "PutComplianceItemsCommand");
  }
};

// src/commands/PutInventoryCommand.ts



var PutInventoryCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "PutInventory", {}).n("SSMClient", "PutInventoryCommand").f(void 0, void 0).ser(se_PutInventoryCommand).de(de_PutInventoryCommand).build() {
  static {
    __name(this, "PutInventoryCommand");
  }
};

// src/commands/PutParameterCommand.ts



var PutParameterCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "PutParameter", {}).n("SSMClient", "PutParameterCommand").f(PutParameterRequestFilterSensitiveLog, void 0).ser(se_PutParameterCommand).de(de_PutParameterCommand).build() {
  static {
    __name(this, "PutParameterCommand");
  }
};

// src/commands/PutResourcePolicyCommand.ts



var PutResourcePolicyCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "PutResourcePolicy", {}).n("SSMClient", "PutResourcePolicyCommand").f(void 0, void 0).ser(se_PutResourcePolicyCommand).de(de_PutResourcePolicyCommand).build() {
  static {
    __name(this, "PutResourcePolicyCommand");
  }
};

// src/commands/RegisterDefaultPatchBaselineCommand.ts



var RegisterDefaultPatchBaselineCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "RegisterDefaultPatchBaseline", {}).n("SSMClient", "RegisterDefaultPatchBaselineCommand").f(void 0, void 0).ser(se_RegisterDefaultPatchBaselineCommand).de(de_RegisterDefaultPatchBaselineCommand).build() {
  static {
    __name(this, "RegisterDefaultPatchBaselineCommand");
  }
};

// src/commands/RegisterPatchBaselineForPatchGroupCommand.ts



var RegisterPatchBaselineForPatchGroupCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "RegisterPatchBaselineForPatchGroup", {}).n("SSMClient", "RegisterPatchBaselineForPatchGroupCommand").f(void 0, void 0).ser(se_RegisterPatchBaselineForPatchGroupCommand).de(de_RegisterPatchBaselineForPatchGroupCommand).build() {
  static {
    __name(this, "RegisterPatchBaselineForPatchGroupCommand");
  }
};

// src/commands/RegisterTargetWithMaintenanceWindowCommand.ts



var RegisterTargetWithMaintenanceWindowCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "RegisterTargetWithMaintenanceWindow", {}).n("SSMClient", "RegisterTargetWithMaintenanceWindowCommand").f(RegisterTargetWithMaintenanceWindowRequestFilterSensitiveLog, void 0).ser(se_RegisterTargetWithMaintenanceWindowCommand).de(de_RegisterTargetWithMaintenanceWindowCommand).build() {
  static {
    __name(this, "RegisterTargetWithMaintenanceWindowCommand");
  }
};

// src/commands/RegisterTaskWithMaintenanceWindowCommand.ts



var RegisterTaskWithMaintenanceWindowCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "RegisterTaskWithMaintenanceWindow", {}).n("SSMClient", "RegisterTaskWithMaintenanceWindowCommand").f(RegisterTaskWithMaintenanceWindowRequestFilterSensitiveLog, void 0).ser(se_RegisterTaskWithMaintenanceWindowCommand).de(de_RegisterTaskWithMaintenanceWindowCommand).build() {
  static {
    __name(this, "RegisterTaskWithMaintenanceWindowCommand");
  }
};

// src/commands/RemoveTagsFromResourceCommand.ts



var RemoveTagsFromResourceCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "RemoveTagsFromResource", {}).n("SSMClient", "RemoveTagsFromResourceCommand").f(void 0, void 0).ser(se_RemoveTagsFromResourceCommand).de(de_RemoveTagsFromResourceCommand).build() {
  static {
    __name(this, "RemoveTagsFromResourceCommand");
  }
};

// src/commands/ResetServiceSettingCommand.ts



var ResetServiceSettingCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "ResetServiceSetting", {}).n("SSMClient", "ResetServiceSettingCommand").f(void 0, void 0).ser(se_ResetServiceSettingCommand).de(de_ResetServiceSettingCommand).build() {
  static {
    __name(this, "ResetServiceSettingCommand");
  }
};

// src/commands/ResumeSessionCommand.ts



var ResumeSessionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "ResumeSession", {}).n("SSMClient", "ResumeSessionCommand").f(void 0, void 0).ser(se_ResumeSessionCommand).de(de_ResumeSessionCommand).build() {
  static {
    __name(this, "ResumeSessionCommand");
  }
};

// src/commands/SendAutomationSignalCommand.ts



var SendAutomationSignalCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "SendAutomationSignal", {}).n("SSMClient", "SendAutomationSignalCommand").f(void 0, void 0).ser(se_SendAutomationSignalCommand).de(de_SendAutomationSignalCommand).build() {
  static {
    __name(this, "SendAutomationSignalCommand");
  }
};

// src/commands/SendCommandCommand.ts



var SendCommandCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "SendCommand", {}).n("SSMClient", "SendCommandCommand").f(SendCommandRequestFilterSensitiveLog, SendCommandResultFilterSensitiveLog).ser(se_SendCommandCommand).de(de_SendCommandCommand).build() {
  static {
    __name(this, "SendCommandCommand");
  }
};

// src/commands/StartAccessRequestCommand.ts



var StartAccessRequestCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "StartAccessRequest", {}).n("SSMClient", "StartAccessRequestCommand").f(void 0, void 0).ser(se_StartAccessRequestCommand).de(de_StartAccessRequestCommand).build() {
  static {
    __name(this, "StartAccessRequestCommand");
  }
};

// src/commands/StartAssociationsOnceCommand.ts



var StartAssociationsOnceCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "StartAssociationsOnce", {}).n("SSMClient", "StartAssociationsOnceCommand").f(void 0, void 0).ser(se_StartAssociationsOnceCommand).de(de_StartAssociationsOnceCommand).build() {
  static {
    __name(this, "StartAssociationsOnceCommand");
  }
};

// src/commands/StartAutomationExecutionCommand.ts



var StartAutomationExecutionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "StartAutomationExecution", {}).n("SSMClient", "StartAutomationExecutionCommand").f(void 0, void 0).ser(se_StartAutomationExecutionCommand).de(de_StartAutomationExecutionCommand).build() {
  static {
    __name(this, "StartAutomationExecutionCommand");
  }
};

// src/commands/StartChangeRequestExecutionCommand.ts



var StartChangeRequestExecutionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "StartChangeRequestExecution", {}).n("SSMClient", "StartChangeRequestExecutionCommand").f(void 0, void 0).ser(se_StartChangeRequestExecutionCommand).de(de_StartChangeRequestExecutionCommand).build() {
  static {
    __name(this, "StartChangeRequestExecutionCommand");
  }
};

// src/commands/StartExecutionPreviewCommand.ts



var StartExecutionPreviewCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "StartExecutionPreview", {}).n("SSMClient", "StartExecutionPreviewCommand").f(void 0, void 0).ser(se_StartExecutionPreviewCommand).de(de_StartExecutionPreviewCommand).build() {
  static {
    __name(this, "StartExecutionPreviewCommand");
  }
};

// src/commands/StartSessionCommand.ts



var StartSessionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "StartSession", {}).n("SSMClient", "StartSessionCommand").f(void 0, void 0).ser(se_StartSessionCommand).de(de_StartSessionCommand).build() {
  static {
    __name(this, "StartSessionCommand");
  }
};

// src/commands/StopAutomationExecutionCommand.ts



var StopAutomationExecutionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "StopAutomationExecution", {}).n("SSMClient", "StopAutomationExecutionCommand").f(void 0, void 0).ser(se_StopAutomationExecutionCommand).de(de_StopAutomationExecutionCommand).build() {
  static {
    __name(this, "StopAutomationExecutionCommand");
  }
};

// src/commands/TerminateSessionCommand.ts



var TerminateSessionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "TerminateSession", {}).n("SSMClient", "TerminateSessionCommand").f(void 0, void 0).ser(se_TerminateSessionCommand).de(de_TerminateSessionCommand).build() {
  static {
    __name(this, "TerminateSessionCommand");
  }
};

// src/commands/UnlabelParameterVersionCommand.ts



var UnlabelParameterVersionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "UnlabelParameterVersion", {}).n("SSMClient", "UnlabelParameterVersionCommand").f(void 0, void 0).ser(se_UnlabelParameterVersionCommand).de(de_UnlabelParameterVersionCommand).build() {
  static {
    __name(this, "UnlabelParameterVersionCommand");
  }
};

// src/commands/UpdateAssociationCommand.ts



var UpdateAssociationCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "UpdateAssociation", {}).n("SSMClient", "UpdateAssociationCommand").f(UpdateAssociationRequestFilterSensitiveLog, UpdateAssociationResultFilterSensitiveLog).ser(se_UpdateAssociationCommand).de(de_UpdateAssociationCommand).build() {
  static {
    __name(this, "UpdateAssociationCommand");
  }
};

// src/commands/UpdateAssociationStatusCommand.ts



var UpdateAssociationStatusCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "UpdateAssociationStatus", {}).n("SSMClient", "UpdateAssociationStatusCommand").f(void 0, UpdateAssociationStatusResultFilterSensitiveLog).ser(se_UpdateAssociationStatusCommand).de(de_UpdateAssociationStatusCommand).build() {
  static {
    __name(this, "UpdateAssociationStatusCommand");
  }
};

// src/commands/UpdateDocumentCommand.ts



var UpdateDocumentCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "UpdateDocument", {}).n("SSMClient", "UpdateDocumentCommand").f(void 0, void 0).ser(se_UpdateDocumentCommand).de(de_UpdateDocumentCommand).build() {
  static {
    __name(this, "UpdateDocumentCommand");
  }
};

// src/commands/UpdateDocumentDefaultVersionCommand.ts



var UpdateDocumentDefaultVersionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "UpdateDocumentDefaultVersion", {}).n("SSMClient", "UpdateDocumentDefaultVersionCommand").f(void 0, void 0).ser(se_UpdateDocumentDefaultVersionCommand).de(de_UpdateDocumentDefaultVersionCommand).build() {
  static {
    __name(this, "UpdateDocumentDefaultVersionCommand");
  }
};

// src/commands/UpdateDocumentMetadataCommand.ts



var UpdateDocumentMetadataCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "UpdateDocumentMetadata", {}).n("SSMClient", "UpdateDocumentMetadataCommand").f(void 0, void 0).ser(se_UpdateDocumentMetadataCommand).de(de_UpdateDocumentMetadataCommand).build() {
  static {
    __name(this, "UpdateDocumentMetadataCommand");
  }
};

// src/commands/UpdateMaintenanceWindowCommand.ts



var UpdateMaintenanceWindowCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "UpdateMaintenanceWindow", {}).n("SSMClient", "UpdateMaintenanceWindowCommand").f(UpdateMaintenanceWindowRequestFilterSensitiveLog, UpdateMaintenanceWindowResultFilterSensitiveLog).ser(se_UpdateMaintenanceWindowCommand).de(de_UpdateMaintenanceWindowCommand).build() {
  static {
    __name(this, "UpdateMaintenanceWindowCommand");
  }
};

// src/commands/UpdateMaintenanceWindowTargetCommand.ts



var UpdateMaintenanceWindowTargetCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "UpdateMaintenanceWindowTarget", {}).n("SSMClient", "UpdateMaintenanceWindowTargetCommand").f(UpdateMaintenanceWindowTargetRequestFilterSensitiveLog, UpdateMaintenanceWindowTargetResultFilterSensitiveLog).ser(se_UpdateMaintenanceWindowTargetCommand).de(de_UpdateMaintenanceWindowTargetCommand).build() {
  static {
    __name(this, "UpdateMaintenanceWindowTargetCommand");
  }
};

// src/commands/UpdateMaintenanceWindowTaskCommand.ts



var UpdateMaintenanceWindowTaskCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "UpdateMaintenanceWindowTask", {}).n("SSMClient", "UpdateMaintenanceWindowTaskCommand").f(UpdateMaintenanceWindowTaskRequestFilterSensitiveLog, UpdateMaintenanceWindowTaskResultFilterSensitiveLog).ser(se_UpdateMaintenanceWindowTaskCommand).de(de_UpdateMaintenanceWindowTaskCommand).build() {
  static {
    __name(this, "UpdateMaintenanceWindowTaskCommand");
  }
};

// src/commands/UpdateManagedInstanceRoleCommand.ts



var UpdateManagedInstanceRoleCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "UpdateManagedInstanceRole", {}).n("SSMClient", "UpdateManagedInstanceRoleCommand").f(void 0, void 0).ser(se_UpdateManagedInstanceRoleCommand).de(de_UpdateManagedInstanceRoleCommand).build() {
  static {
    __name(this, "UpdateManagedInstanceRoleCommand");
  }
};

// src/commands/UpdateOpsItemCommand.ts



var UpdateOpsItemCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "UpdateOpsItem", {}).n("SSMClient", "UpdateOpsItemCommand").f(void 0, void 0).ser(se_UpdateOpsItemCommand).de(de_UpdateOpsItemCommand).build() {
  static {
    __name(this, "UpdateOpsItemCommand");
  }
};

// src/commands/UpdateOpsMetadataCommand.ts



var UpdateOpsMetadataCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "UpdateOpsMetadata", {}).n("SSMClient", "UpdateOpsMetadataCommand").f(void 0, void 0).ser(se_UpdateOpsMetadataCommand).de(de_UpdateOpsMetadataCommand).build() {
  static {
    __name(this, "UpdateOpsMetadataCommand");
  }
};

// src/commands/UpdatePatchBaselineCommand.ts



var UpdatePatchBaselineCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "UpdatePatchBaseline", {}).n("SSMClient", "UpdatePatchBaselineCommand").f(UpdatePatchBaselineRequestFilterSensitiveLog, UpdatePatchBaselineResultFilterSensitiveLog).ser(se_UpdatePatchBaselineCommand).de(de_UpdatePatchBaselineCommand).build() {
  static {
    __name(this, "UpdatePatchBaselineCommand");
  }
};

// src/commands/UpdateResourceDataSyncCommand.ts



var UpdateResourceDataSyncCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "UpdateResourceDataSync", {}).n("SSMClient", "UpdateResourceDataSyncCommand").f(void 0, void 0).ser(se_UpdateResourceDataSyncCommand).de(de_UpdateResourceDataSyncCommand).build() {
  static {
    __name(this, "UpdateResourceDataSyncCommand");
  }
};

// src/commands/UpdateServiceSettingCommand.ts



var UpdateServiceSettingCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command3, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command3.getEndpointParameterInstructions())
  ];
}).s("AmazonSSM", "UpdateServiceSetting", {}).n("SSMClient", "UpdateServiceSettingCommand").f(void 0, void 0).ser(se_UpdateServiceSettingCommand).de(de_UpdateServiceSettingCommand).build() {
  static {
    __name(this, "UpdateServiceSettingCommand");
  }
};

// src/SSM.ts
var commands = {
  AddTagsToResourceCommand,
  AssociateOpsItemRelatedItemCommand,
  CancelCommandCommand,
  CancelMaintenanceWindowExecutionCommand,
  CreateActivationCommand,
  CreateAssociationCommand,
  CreateAssociationBatchCommand,
  CreateDocumentCommand,
  CreateMaintenanceWindowCommand,
  CreateOpsItemCommand,
  CreateOpsMetadataCommand,
  CreatePatchBaselineCommand,
  CreateResourceDataSyncCommand,
  DeleteActivationCommand,
  DeleteAssociationCommand,
  DeleteDocumentCommand,
  DeleteInventoryCommand,
  DeleteMaintenanceWindowCommand,
  DeleteOpsItemCommand,
  DeleteOpsMetadataCommand,
  DeleteParameterCommand,
  DeleteParametersCommand,
  DeletePatchBaselineCommand,
  DeleteResourceDataSyncCommand,
  DeleteResourcePolicyCommand,
  DeregisterManagedInstanceCommand,
  DeregisterPatchBaselineForPatchGroupCommand,
  DeregisterTargetFromMaintenanceWindowCommand,
  DeregisterTaskFromMaintenanceWindowCommand,
  DescribeActivationsCommand,
  DescribeAssociationCommand,
  DescribeAssociationExecutionsCommand,
  DescribeAssociationExecutionTargetsCommand,
  DescribeAutomationExecutionsCommand,
  DescribeAutomationStepExecutionsCommand,
  DescribeAvailablePatchesCommand,
  DescribeDocumentCommand,
  DescribeDocumentPermissionCommand,
  DescribeEffectiveInstanceAssociationsCommand,
  DescribeEffectivePatchesForPatchBaselineCommand,
  DescribeInstanceAssociationsStatusCommand,
  DescribeInstanceInformationCommand,
  DescribeInstancePatchesCommand,
  DescribeInstancePatchStatesCommand,
  DescribeInstancePatchStatesForPatchGroupCommand,
  DescribeInstancePropertiesCommand,
  DescribeInventoryDeletionsCommand,
  DescribeMaintenanceWindowExecutionsCommand,
  DescribeMaintenanceWindowExecutionTaskInvocationsCommand,
  DescribeMaintenanceWindowExecutionTasksCommand,
  DescribeMaintenanceWindowsCommand,
  DescribeMaintenanceWindowScheduleCommand,
  DescribeMaintenanceWindowsForTargetCommand,
  DescribeMaintenanceWindowTargetsCommand,
  DescribeMaintenanceWindowTasksCommand,
  DescribeOpsItemsCommand,
  DescribeParametersCommand,
  DescribePatchBaselinesCommand,
  DescribePatchGroupsCommand,
  DescribePatchGroupStateCommand,
  DescribePatchPropertiesCommand,
  DescribeSessionsCommand,
  DisassociateOpsItemRelatedItemCommand,
  GetAccessTokenCommand,
  GetAutomationExecutionCommand,
  GetCalendarStateCommand,
  GetCommandInvocationCommand,
  GetConnectionStatusCommand,
  GetDefaultPatchBaselineCommand,
  GetDeployablePatchSnapshotForInstanceCommand,
  GetDocumentCommand,
  GetExecutionPreviewCommand,
  GetInventoryCommand,
  GetInventorySchemaCommand,
  GetMaintenanceWindowCommand,
  GetMaintenanceWindowExecutionCommand,
  GetMaintenanceWindowExecutionTaskCommand,
  GetMaintenanceWindowExecutionTaskInvocationCommand,
  GetMaintenanceWindowTaskCommand,
  GetOpsItemCommand,
  GetOpsMetadataCommand,
  GetOpsSummaryCommand,
  GetParameterCommand,
  GetParameterHistoryCommand,
  GetParametersCommand,
  GetParametersByPathCommand,
  GetPatchBaselineCommand,
  GetPatchBaselineForPatchGroupCommand,
  GetResourcePoliciesCommand,
  GetServiceSettingCommand,
  LabelParameterVersionCommand,
  ListAssociationsCommand,
  ListAssociationVersionsCommand,
  ListCommandInvocationsCommand,
  ListCommandsCommand,
  ListComplianceItemsCommand,
  ListComplianceSummariesCommand,
  ListDocumentMetadataHistoryCommand,
  ListDocumentsCommand,
  ListDocumentVersionsCommand,
  ListInventoryEntriesCommand,
  ListNodesCommand,
  ListNodesSummaryCommand,
  ListOpsItemEventsCommand,
  ListOpsItemRelatedItemsCommand,
  ListOpsMetadataCommand,
  ListResourceComplianceSummariesCommand,
  ListResourceDataSyncCommand,
  ListTagsForResourceCommand,
  ModifyDocumentPermissionCommand,
  PutComplianceItemsCommand,
  PutInventoryCommand,
  PutParameterCommand,
  PutResourcePolicyCommand,
  RegisterDefaultPatchBaselineCommand,
  RegisterPatchBaselineForPatchGroupCommand,
  RegisterTargetWithMaintenanceWindowCommand,
  RegisterTaskWithMaintenanceWindowCommand,
  RemoveTagsFromResourceCommand,
  ResetServiceSettingCommand,
  ResumeSessionCommand,
  SendAutomationSignalCommand,
  SendCommandCommand,
  StartAccessRequestCommand,
  StartAssociationsOnceCommand,
  StartAutomationExecutionCommand,
  StartChangeRequestExecutionCommand,
  StartExecutionPreviewCommand,
  StartSessionCommand,
  StopAutomationExecutionCommand,
  TerminateSessionCommand,
  UnlabelParameterVersionCommand,
  UpdateAssociationCommand,
  UpdateAssociationStatusCommand,
  UpdateDocumentCommand,
  UpdateDocumentDefaultVersionCommand,
  UpdateDocumentMetadataCommand,
  UpdateMaintenanceWindowCommand,
  UpdateMaintenanceWindowTargetCommand,
  UpdateMaintenanceWindowTaskCommand,
  UpdateManagedInstanceRoleCommand,
  UpdateOpsItemCommand,
  UpdateOpsMetadataCommand,
  UpdatePatchBaselineCommand,
  UpdateResourceDataSyncCommand,
  UpdateServiceSettingCommand
};
var SSM = class extends SSMClient {
  static {
    __name(this, "SSM");
  }
};
(0, import_smithy_client.createAggregatedClient)(commands, SSM);

// src/pagination/DescribeActivationsPaginator.ts

var paginateDescribeActivations = (0, import_core.createPaginator)(SSMClient, DescribeActivationsCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/DescribeAssociationExecutionTargetsPaginator.ts

var paginateDescribeAssociationExecutionTargets = (0, import_core.createPaginator)(SSMClient, DescribeAssociationExecutionTargetsCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/DescribeAssociationExecutionsPaginator.ts

var paginateDescribeAssociationExecutions = (0, import_core.createPaginator)(SSMClient, DescribeAssociationExecutionsCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/DescribeAutomationExecutionsPaginator.ts

var paginateDescribeAutomationExecutions = (0, import_core.createPaginator)(SSMClient, DescribeAutomationExecutionsCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/DescribeAutomationStepExecutionsPaginator.ts

var paginateDescribeAutomationStepExecutions = (0, import_core.createPaginator)(SSMClient, DescribeAutomationStepExecutionsCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/DescribeAvailablePatchesPaginator.ts

var paginateDescribeAvailablePatches = (0, import_core.createPaginator)(SSMClient, DescribeAvailablePatchesCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/DescribeEffectiveInstanceAssociationsPaginator.ts

var paginateDescribeEffectiveInstanceAssociations = (0, import_core.createPaginator)(SSMClient, DescribeEffectiveInstanceAssociationsCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/DescribeEffectivePatchesForPatchBaselinePaginator.ts

var paginateDescribeEffectivePatchesForPatchBaseline = (0, import_core.createPaginator)(SSMClient, DescribeEffectivePatchesForPatchBaselineCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/DescribeInstanceAssociationsStatusPaginator.ts

var paginateDescribeInstanceAssociationsStatus = (0, import_core.createPaginator)(SSMClient, DescribeInstanceAssociationsStatusCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/DescribeInstanceInformationPaginator.ts

var paginateDescribeInstanceInformation = (0, import_core.createPaginator)(SSMClient, DescribeInstanceInformationCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/DescribeInstancePatchStatesForPatchGroupPaginator.ts

var paginateDescribeInstancePatchStatesForPatchGroup = (0, import_core.createPaginator)(SSMClient, DescribeInstancePatchStatesForPatchGroupCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/DescribeInstancePatchStatesPaginator.ts

var paginateDescribeInstancePatchStates = (0, import_core.createPaginator)(SSMClient, DescribeInstancePatchStatesCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/DescribeInstancePatchesPaginator.ts

var paginateDescribeInstancePatches = (0, import_core.createPaginator)(SSMClient, DescribeInstancePatchesCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/DescribeInstancePropertiesPaginator.ts

var paginateDescribeInstanceProperties = (0, import_core.createPaginator)(SSMClient, DescribeInstancePropertiesCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/DescribeInventoryDeletionsPaginator.ts

var paginateDescribeInventoryDeletions = (0, import_core.createPaginator)(SSMClient, DescribeInventoryDeletionsCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/DescribeMaintenanceWindowExecutionTaskInvocationsPaginator.ts

var paginateDescribeMaintenanceWindowExecutionTaskInvocations = (0, import_core.createPaginator)(SSMClient, DescribeMaintenanceWindowExecutionTaskInvocationsCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/DescribeMaintenanceWindowExecutionTasksPaginator.ts

var paginateDescribeMaintenanceWindowExecutionTasks = (0, import_core.createPaginator)(SSMClient, DescribeMaintenanceWindowExecutionTasksCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/DescribeMaintenanceWindowExecutionsPaginator.ts

var paginateDescribeMaintenanceWindowExecutions = (0, import_core.createPaginator)(SSMClient, DescribeMaintenanceWindowExecutionsCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/DescribeMaintenanceWindowSchedulePaginator.ts

var paginateDescribeMaintenanceWindowSchedule = (0, import_core.createPaginator)(SSMClient, DescribeMaintenanceWindowScheduleCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/DescribeMaintenanceWindowTargetsPaginator.ts

var paginateDescribeMaintenanceWindowTargets = (0, import_core.createPaginator)(SSMClient, DescribeMaintenanceWindowTargetsCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/DescribeMaintenanceWindowTasksPaginator.ts

var paginateDescribeMaintenanceWindowTasks = (0, import_core.createPaginator)(SSMClient, DescribeMaintenanceWindowTasksCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/DescribeMaintenanceWindowsForTargetPaginator.ts

var paginateDescribeMaintenanceWindowsForTarget = (0, import_core.createPaginator)(SSMClient, DescribeMaintenanceWindowsForTargetCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/DescribeMaintenanceWindowsPaginator.ts

var paginateDescribeMaintenanceWindows = (0, import_core.createPaginator)(SSMClient, DescribeMaintenanceWindowsCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/DescribeOpsItemsPaginator.ts

var paginateDescribeOpsItems = (0, import_core.createPaginator)(SSMClient, DescribeOpsItemsCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/DescribeParametersPaginator.ts

var paginateDescribeParameters = (0, import_core.createPaginator)(SSMClient, DescribeParametersCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/DescribePatchBaselinesPaginator.ts

var paginateDescribePatchBaselines = (0, import_core.createPaginator)(SSMClient, DescribePatchBaselinesCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/DescribePatchGroupsPaginator.ts

var paginateDescribePatchGroups = (0, import_core.createPaginator)(SSMClient, DescribePatchGroupsCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/DescribePatchPropertiesPaginator.ts

var paginateDescribePatchProperties = (0, import_core.createPaginator)(SSMClient, DescribePatchPropertiesCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/DescribeSessionsPaginator.ts

var paginateDescribeSessions = (0, import_core.createPaginator)(SSMClient, DescribeSessionsCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/GetInventoryPaginator.ts

var paginateGetInventory = (0, import_core.createPaginator)(SSMClient, GetInventoryCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/GetInventorySchemaPaginator.ts

var paginateGetInventorySchema = (0, import_core.createPaginator)(SSMClient, GetInventorySchemaCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/GetOpsSummaryPaginator.ts

var paginateGetOpsSummary = (0, import_core.createPaginator)(SSMClient, GetOpsSummaryCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/GetParameterHistoryPaginator.ts

var paginateGetParameterHistory = (0, import_core.createPaginator)(SSMClient, GetParameterHistoryCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/GetParametersByPathPaginator.ts

var paginateGetParametersByPath = (0, import_core.createPaginator)(SSMClient, GetParametersByPathCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/GetResourcePoliciesPaginator.ts

var paginateGetResourcePolicies = (0, import_core.createPaginator)(SSMClient, GetResourcePoliciesCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/ListAssociationVersionsPaginator.ts

var paginateListAssociationVersions = (0, import_core.createPaginator)(SSMClient, ListAssociationVersionsCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/ListAssociationsPaginator.ts

var paginateListAssociations = (0, import_core.createPaginator)(SSMClient, ListAssociationsCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/ListCommandInvocationsPaginator.ts

var paginateListCommandInvocations = (0, import_core.createPaginator)(SSMClient, ListCommandInvocationsCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/ListCommandsPaginator.ts

var paginateListCommands = (0, import_core.createPaginator)(SSMClient, ListCommandsCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/ListComplianceItemsPaginator.ts

var paginateListComplianceItems = (0, import_core.createPaginator)(SSMClient, ListComplianceItemsCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/ListComplianceSummariesPaginator.ts

var paginateListComplianceSummaries = (0, import_core.createPaginator)(SSMClient, ListComplianceSummariesCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/ListDocumentVersionsPaginator.ts

var paginateListDocumentVersions = (0, import_core.createPaginator)(SSMClient, ListDocumentVersionsCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/ListDocumentsPaginator.ts

var paginateListDocuments = (0, import_core.createPaginator)(SSMClient, ListDocumentsCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/ListNodesPaginator.ts

var paginateListNodes = (0, import_core.createPaginator)(SSMClient, ListNodesCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/ListNodesSummaryPaginator.ts

var paginateListNodesSummary = (0, import_core.createPaginator)(SSMClient, ListNodesSummaryCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/ListOpsItemEventsPaginator.ts

var paginateListOpsItemEvents = (0, import_core.createPaginator)(SSMClient, ListOpsItemEventsCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/ListOpsItemRelatedItemsPaginator.ts

var paginateListOpsItemRelatedItems = (0, import_core.createPaginator)(SSMClient, ListOpsItemRelatedItemsCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/ListOpsMetadataPaginator.ts

var paginateListOpsMetadata = (0, import_core.createPaginator)(SSMClient, ListOpsMetadataCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/ListResourceComplianceSummariesPaginator.ts

var paginateListResourceComplianceSummaries = (0, import_core.createPaginator)(SSMClient, ListResourceComplianceSummariesCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/ListResourceDataSyncPaginator.ts

var paginateListResourceDataSync = (0, import_core.createPaginator)(SSMClient, ListResourceDataSyncCommand, "NextToken", "NextToken", "MaxResults");

// src/waiters/waitForCommandExecuted.ts
var import_util_waiter = require("@smithy/util-waiter");
var checkState = /* @__PURE__ */ __name(async (client, input) => {
  let reason;
  try {
    const result = await client.send(new GetCommandInvocationCommand(input));
    reason = result;
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        return result.Status;
      }, "returnComparator");
      if (returnComparator() === "Pending") {
        return { state: import_util_waiter.WaiterState.RETRY, reason };
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        return result.Status;
      }, "returnComparator");
      if (returnComparator() === "InProgress") {
        return { state: import_util_waiter.WaiterState.RETRY, reason };
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        return result.Status;
      }, "returnComparator");
      if (returnComparator() === "Delayed") {
        return { state: import_util_waiter.WaiterState.RETRY, reason };
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        return result.Status;
      }, "returnComparator");
      if (returnComparator() === "Success") {
        return { state: import_util_waiter.WaiterState.SUCCESS, reason };
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        return result.Status;
      }, "returnComparator");
      if (returnComparator() === "Cancelled") {
        return { state: import_util_waiter.WaiterState.FAILURE, reason };
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        return result.Status;
      }, "returnComparator");
      if (returnComparator() === "TimedOut") {
        return { state: import_util_waiter.WaiterState.FAILURE, reason };
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        return result.Status;
      }, "returnComparator");
      if (returnComparator() === "Failed") {
        return { state: import_util_waiter.WaiterState.FAILURE, reason };
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        return result.Status;
      }, "returnComparator");
      if (returnComparator() === "Cancelling") {
        return { state: import_util_waiter.WaiterState.FAILURE, reason };
      }
    } catch (e) {
    }
  } catch (exception) {
    reason = exception;
    if (exception.name && exception.name == "InvocationDoesNotExist") {
      return { state: import_util_waiter.WaiterState.RETRY, reason };
    }
  }
  return { state: import_util_waiter.WaiterState.RETRY, reason };
}, "checkState");
var waitForCommandExecuted = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 5, maxDelay: 120 };
  return (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState);
}, "waitForCommandExecuted");
var waitUntilCommandExecuted = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 5, maxDelay: 120 };
  const result = await (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState);
  return (0, import_util_waiter.checkExceptions)(result);
}, "waitUntilCommandExecuted");
// Annotate the CommonJS export names for ESM import in node:

0 && (module.exports = {
  SSMServiceException,
  __Client,
  SSMClient,
  SSM,
  $Command,
  AddTagsToResourceCommand,
  AssociateOpsItemRelatedItemCommand,
  CancelCommandCommand,
  CancelMaintenanceWindowExecutionCommand,
  CreateActivationCommand,
  CreateAssociationBatchCommand,
  CreateAssociationCommand,
  CreateDocumentCommand,
  CreateMaintenanceWindowCommand,
  CreateOpsItemCommand,
  CreateOpsMetadataCommand,
  CreatePatchBaselineCommand,
  CreateResourceDataSyncCommand,
  DeleteActivationCommand,
  DeleteAssociationCommand,
  DeleteDocumentCommand,
  DeleteInventoryCommand,
  DeleteMaintenanceWindowCommand,
  DeleteOpsItemCommand,
  DeleteOpsMetadataCommand,
  DeleteParameterCommand,
  DeleteParametersCommand,
  DeletePatchBaselineCommand,
  DeleteResourceDataSyncCommand,
  DeleteResourcePolicyCommand,
  DeregisterManagedInstanceCommand,
  DeregisterPatchBaselineForPatchGroupCommand,
  DeregisterTargetFromMaintenanceWindowCommand,
  DeregisterTaskFromMaintenanceWindowCommand,
  DescribeActivationsCommand,
  DescribeAssociationCommand,
  DescribeAssociationExecutionTargetsCommand,
  DescribeAssociationExecutionsCommand,
  DescribeAutomationExecutionsCommand,
  DescribeAutomationStepExecutionsCommand,
  DescribeAvailablePatchesCommand,
  DescribeDocumentCommand,
  DescribeDocumentPermissionCommand,
  DescribeEffectiveInstanceAssociationsCommand,
  DescribeEffectivePatchesForPatchBaselineCommand,
  DescribeInstanceAssociationsStatusCommand,
  DescribeInstanceInformationCommand,
  DescribeInstancePatchStatesCommand,
  DescribeInstancePatchStatesForPatchGroupCommand,
  DescribeInstancePatchesCommand,
  DescribeInstancePropertiesCommand,
  DescribeInventoryDeletionsCommand,
  DescribeMaintenanceWindowExecutionTaskInvocationsCommand,
  DescribeMaintenanceWindowExecutionTasksCommand,
  DescribeMaintenanceWindowExecutionsCommand,
  DescribeMaintenanceWindowScheduleCommand,
  DescribeMaintenanceWindowTargetsCommand,
  DescribeMaintenanceWindowTasksCommand,
  DescribeMaintenanceWindowsCommand,
  DescribeMaintenanceWindowsForTargetCommand,
  DescribeOpsItemsCommand,
  DescribeParametersCommand,
  DescribePatchBaselinesCommand,
  DescribePatchGroupStateCommand,
  DescribePatchGroupsCommand,
  DescribePatchPropertiesCommand,
  DescribeSessionsCommand,
  DisassociateOpsItemRelatedItemCommand,
  GetAccessTokenCommand,
  GetAutomationExecutionCommand,
  GetCalendarStateCommand,
  GetCommandInvocationCommand,
  GetConnectionStatusCommand,
  GetDefaultPatchBaselineCommand,
  GetDeployablePatchSnapshotForInstanceCommand,
  GetDocumentCommand,
  GetExecutionPreviewCommand,
  GetInventoryCommand,
  GetInventorySchemaCommand,
  GetMaintenanceWindowCommand,
  GetMaintenanceWindowExecutionCommand,
  GetMaintenanceWindowExecutionTaskCommand,
  GetMaintenanceWindowExecutionTaskInvocationCommand,
  GetMaintenanceWindowTaskCommand,
  GetOpsItemCommand,
  GetOpsMetadataCommand,
  GetOpsSummaryCommand,
  GetParameterCommand,
  GetParameterHistoryCommand,
  GetParametersByPathCommand,
  GetParametersCommand,
  GetPatchBaselineCommand,
  GetPatchBaselineForPatchGroupCommand,
  GetResourcePoliciesCommand,
  GetServiceSettingCommand,
  LabelParameterVersionCommand,
  ListAssociationVersionsCommand,
  ListAssociationsCommand,
  ListCommandInvocationsCommand,
  ListCommandsCommand,
  ListComplianceItemsCommand,
  ListComplianceSummariesCommand,
  ListDocumentMetadataHistoryCommand,
  ListDocumentVersionsCommand,
  ListDocumentsCommand,
  ListInventoryEntriesCommand,
  ListNodesCommand,
  ListNodesSummaryCommand,
  ListOpsItemEventsCommand,
  ListOpsItemRelatedItemsCommand,
  ListOpsMetadataCommand,
  ListResourceComplianceSummariesCommand,
  ListResourceDataSyncCommand,
  ListTagsForResourceCommand,
  ModifyDocumentPermissionCommand,
  PutComplianceItemsCommand,
  PutInventoryCommand,
  PutParameterCommand,
  PutResourcePolicyCommand,
  RegisterDefaultPatchBaselineCommand,
  RegisterPatchBaselineForPatchGroupCommand,
  RegisterTargetWithMaintenanceWindowCommand,
  RegisterTaskWithMaintenanceWindowCommand,
  RemoveTagsFromResourceCommand,
  ResetServiceSettingCommand,
  ResumeSessionCommand,
  SendAutomationSignalCommand,
  SendCommandCommand,
  StartAccessRequestCommand,
  StartAssociationsOnceCommand,
  StartAutomationExecutionCommand,
  StartChangeRequestExecutionCommand,
  StartExecutionPreviewCommand,
  StartSessionCommand,
  StopAutomationExecutionCommand,
  TerminateSessionCommand,
  UnlabelParameterVersionCommand,
  UpdateAssociationCommand,
  UpdateAssociationStatusCommand,
  UpdateDocumentCommand,
  UpdateDocumentDefaultVersionCommand,
  UpdateDocumentMetadataCommand,
  UpdateMaintenanceWindowCommand,
  UpdateMaintenanceWindowTargetCommand,
  UpdateMaintenanceWindowTaskCommand,
  UpdateManagedInstanceRoleCommand,
  UpdateOpsItemCommand,
  UpdateOpsMetadataCommand,
  UpdatePatchBaselineCommand,
  UpdateResourceDataSyncCommand,
  UpdateServiceSettingCommand,
  paginateDescribeActivations,
  paginateDescribeAssociationExecutionTargets,
  paginateDescribeAssociationExecutions,
  paginateDescribeAutomationExecutions,
  paginateDescribeAutomationStepExecutions,
  paginateDescribeAvailablePatches,
  paginateDescribeEffectiveInstanceAssociations,
  paginateDescribeEffectivePatchesForPatchBaseline,
  paginateDescribeInstanceAssociationsStatus,
  paginateDescribeInstanceInformation,
  paginateDescribeInstancePatchStatesForPatchGroup,
  paginateDescribeInstancePatchStates,
  paginateDescribeInstancePatches,
  paginateDescribeInstanceProperties,
  paginateDescribeInventoryDeletions,
  paginateDescribeMaintenanceWindowExecutionTaskInvocations,
  paginateDescribeMaintenanceWindowExecutionTasks,
  paginateDescribeMaintenanceWindowExecutions,
  paginateDescribeMaintenanceWindowSchedule,
  paginateDescribeMaintenanceWindowTargets,
  paginateDescribeMaintenanceWindowTasks,
  paginateDescribeMaintenanceWindowsForTarget,
  paginateDescribeMaintenanceWindows,
  paginateDescribeOpsItems,
  paginateDescribeParameters,
  paginateDescribePatchBaselines,
  paginateDescribePatchGroups,
  paginateDescribePatchProperties,
  paginateDescribeSessions,
  paginateGetInventory,
  paginateGetInventorySchema,
  paginateGetOpsSummary,
  paginateGetParameterHistory,
  paginateGetParametersByPath,
  paginateGetResourcePolicies,
  paginateListAssociationVersions,
  paginateListAssociations,
  paginateListCommandInvocations,
  paginateListCommands,
  paginateListComplianceItems,
  paginateListComplianceSummaries,
  paginateListDocumentVersions,
  paginateListDocuments,
  paginateListNodes,
  paginateListNodesSummary,
  paginateListOpsItemEvents,
  paginateListOpsItemRelatedItems,
  paginateListOpsMetadata,
  paginateListResourceComplianceSummaries,
  paginateListResourceDataSync,
  waitForCommandExecuted,
  waitUntilCommandExecuted,
  AccessDeniedException,
  AccessRequestStatus,
  AccessType,
  ResourceTypeForTagging,
  InternalServerError,
  InvalidResourceId,
  InvalidResourceType,
  TooManyTagsError,
  TooManyUpdates,
  ExternalAlarmState,
  AlreadyExistsException,
  OpsItemConflictException,
  OpsItemInvalidParameterException,
  OpsItemLimitExceededException,
  OpsItemNotFoundException,
  OpsItemRelatedItemAlreadyExistsException,
  DuplicateInstanceId,
  InvalidCommandId,
  InvalidInstanceId,
  DoesNotExistException,
  InvalidParameters,
  AssociationAlreadyExists,
  AssociationLimitExceeded,
  AssociationComplianceSeverity,
  AssociationSyncCompliance,
  AssociationStatusName,
  InvalidDocument,
  InvalidDocumentVersion,
  InvalidOutputLocation,
  InvalidSchedule,
  InvalidTag,
  InvalidTarget,
  InvalidTargetMaps,
  UnsupportedPlatformType,
  Fault,
  AttachmentsSourceKey,
  DocumentFormat,
  DocumentType,
  DocumentHashType,
  DocumentParameterType,
  PlatformType,
  ReviewStatus,
  DocumentStatus,
  DocumentAlreadyExists,
  DocumentLimitExceeded,
  InvalidDocumentContent,
  InvalidDocumentSchemaVersion,
  MaxDocumentSizeExceeded,
  IdempotentParameterMismatch,
  ResourceLimitExceededException,
  OpsItemDataType,
  OpsItemAccessDeniedException,
  OpsItemAlreadyExistsException,
  OpsMetadataAlreadyExistsException,
  OpsMetadataInvalidArgumentException,
  OpsMetadataLimitExceededException,
  OpsMetadataTooManyUpdatesException,
  PatchComplianceLevel,
  PatchFilterKey,
  PatchComplianceStatus,
  OperatingSystem,
  PatchAction,
  ResourceDataSyncS3Format,
  ResourceDataSyncAlreadyExistsException,
  ResourceDataSyncCountExceededException,
  ResourceDataSyncInvalidConfigurationException,
  InvalidActivation,
  InvalidActivationId,
  AssociationDoesNotExist,
  AssociatedInstances,
  InvalidDocumentOperation,
  InventorySchemaDeleteOption,
  InvalidDeleteInventoryParametersException,
  InvalidInventoryRequestException,
  InvalidOptionException,
  InvalidTypeNameException,
  OpsMetadataNotFoundException,
  ParameterNotFound,
  ResourceInUseException,
  ResourceDataSyncNotFoundException,
  MalformedResourcePolicyDocumentException,
  ResourceNotFoundException,
  ResourcePolicyConflictException,
  ResourcePolicyInvalidParameterException,
  ResourcePolicyNotFoundException,
  TargetInUseException,
  DescribeActivationsFilterKeys,
  InvalidFilter,
  InvalidNextToken,
  InvalidAssociationVersion,
  AssociationExecutionFilterKey,
  AssociationFilterOperatorType,
  AssociationExecutionDoesNotExist,
  AssociationExecutionTargetsFilterKey,
  AutomationExecutionFilterKey,
  AutomationExecutionStatus,
  AutomationSubtype,
  AutomationType,
  ExecutionMode,
  InvalidFilterKey,
  InvalidFilterValue,
  AutomationExecutionNotFoundException,
  StepExecutionFilterKey,
  DocumentPermissionType,
  InvalidPermissionType,
  PatchDeploymentStatus,
  UnsupportedOperatingSystem,
  InstanceInformationFilterKey,
  PingStatus,
  ResourceType,
  SourceType,
  InvalidInstanceInformationFilterValue,
  PatchComplianceDataState,
  PatchOperationType,
  RebootOption,
  InstancePatchStateOperatorType,
  InstancePropertyFilterOperator,
  InstancePropertyFilterKey,
  InvalidInstancePropertyFilterValue,
  InventoryDeletionStatus,
  InvalidDeletionIdException,
  MaintenanceWindowExecutionStatus,
  MaintenanceWindowTaskType,
  CreateAssociationRequestFilterSensitiveLog,
  AssociationDescriptionFilterSensitiveLog,
  CreateAssociationResultFilterSensitiveLog,
  CreateAssociationBatchRequestEntryFilterSensitiveLog,
  CreateAssociationBatchRequestFilterSensitiveLog,
  FailedCreateAssociationFilterSensitiveLog,
  CreateAssociationBatchResultFilterSensitiveLog,
  CreateMaintenanceWindowRequestFilterSensitiveLog,
  PatchSourceFilterSensitiveLog,
  CreatePatchBaselineRequestFilterSensitiveLog,
  DescribeAssociationResultFilterSensitiveLog,
  InstanceInformationFilterSensitiveLog,
  DescribeInstanceInformationResultFilterSensitiveLog,
  InstancePatchStateFilterSensitiveLog,
  DescribeInstancePatchStatesResultFilterSensitiveLog,
  DescribeInstancePatchStatesForPatchGroupResultFilterSensitiveLog,
  InstancePropertyFilterSensitiveLog,
  DescribeInstancePropertiesResultFilterSensitiveLog,
  MaintenanceWindowExecutionTaskInvocationIdentityFilterSensitiveLog,
  DescribeMaintenanceWindowExecutionTaskInvocationsResultFilterSensitiveLog,
  MaintenanceWindowIdentityFilterSensitiveLog,
  MaintenanceWindowResourceType,
  MaintenanceWindowTaskCutoffBehavior,
  OpsItemFilterKey,
  OpsItemFilterOperator,
  OpsItemStatus,
  ParametersFilterKey,
  ParameterTier,
  ParameterType,
  InvalidFilterOption,
  PatchSet,
  PatchProperty,
  SessionFilterKey,
  SessionState,
  SessionStatus,
  OpsItemRelatedItemAssociationNotFoundException,
  ThrottlingException,
  ValidationException,
  CalendarState,
  InvalidDocumentType,
  UnsupportedCalendarException,
  CommandInvocationStatus,
  InvalidPluginName,
  InvocationDoesNotExist,
  ConnectionStatus,
  UnsupportedFeatureRequiredException,
  AttachmentHashType,
  ImpactType,
  ExecutionPreview,
  ExecutionPreviewStatus,
  InventoryQueryOperatorType,
  InvalidAggregatorException,
  InvalidInventoryGroupException,
  InvalidResultAttributeException,
  InventoryAttributeDataType,
  NotificationEvent,
  NotificationType,
  OpsFilterOperatorType,
  InvalidKeyId,
  ParameterVersionNotFound,
  ServiceSettingNotFound,
  ParameterVersionLabelLimitExceeded,
  AssociationFilterKey,
  CommandFilterKey,
  CommandPluginStatus,
  CommandStatus,
  ComplianceQueryOperatorType,
  ComplianceSeverity,
  ComplianceStatus,
  DocumentMetadataEnum,
  DocumentReviewCommentType,
  DocumentFilterKey,
  NodeFilterKey,
  NodeFilterOperatorType,
  ManagedStatus,
  NodeType,
  UnsupportedOperationException,
  NodeAggregatorType,
  NodeAttributeName,
  NodeTypeName,
  OpsItemEventFilterKey,
  OpsItemEventFilterOperator,
  OpsItemRelatedItemsFilterKey,
  OpsItemRelatedItemsFilterOperator,
  LastResourceDataSyncStatus,
  DocumentPermissionLimit,
  ComplianceTypeCountLimitExceededException,
  InvalidItemContentException,
  ItemSizeLimitExceededException,
  ComplianceUploadType,
  TotalSizeLimitExceededException,
  CustomSchemaCountLimitExceededException,
  InvalidInventoryItemContextException,
  ItemContentMismatchException,
  SubTypeCountLimitExceededException,
  UnsupportedInventoryItemContextException,
  UnsupportedInventorySchemaVersionException,
  HierarchyLevelLimitExceededException,
  HierarchyTypeMismatchException,
  IncompatiblePolicyException,
  InvalidAllowedPatternException,
  InvalidPolicyAttributeException,
  InvalidPolicyTypeException,
  ParameterAlreadyExists,
  ParameterLimitExceeded,
  ParameterMaxVersionLimitExceeded,
  ParameterPatternMismatchException,
  PoliciesLimitExceededException,
  UnsupportedParameterType,
  ResourcePolicyLimitExceededException,
  DescribeMaintenanceWindowsResultFilterSensitiveLog,
  MaintenanceWindowTargetFilterSensitiveLog,
  DescribeMaintenanceWindowTargetsResultFilterSensitiveLog,
  MaintenanceWindowTaskParameterValueExpressionFilterSensitiveLog,
  MaintenanceWindowTaskFilterSensitiveLog,
  DescribeMaintenanceWindowTasksResultFilterSensitiveLog,
  CredentialsFilterSensitiveLog,
  GetAccessTokenResponseFilterSensitiveLog,
  BaselineOverrideFilterSensitiveLog,
  GetDeployablePatchSnapshotForInstanceRequestFilterSensitiveLog,
  GetMaintenanceWindowResultFilterSensitiveLog,
  GetMaintenanceWindowExecutionTaskResultFilterSensitiveLog,
  GetMaintenanceWindowExecutionTaskInvocationResultFilterSensitiveLog,
  MaintenanceWindowLambdaParametersFilterSensitiveLog,
  MaintenanceWindowRunCommandParametersFilterSensitiveLog,
  MaintenanceWindowStepFunctionsParametersFilterSensitiveLog,
  MaintenanceWindowTaskInvocationParametersFilterSensitiveLog,
  GetMaintenanceWindowTaskResultFilterSensitiveLog,
  ParameterFilterSensitiveLog,
  GetParameterResultFilterSensitiveLog,
  ParameterHistoryFilterSensitiveLog,
  GetParameterHistoryResultFilterSensitiveLog,
  GetParametersResultFilterSensitiveLog,
  GetParametersByPathResultFilterSensitiveLog,
  GetPatchBaselineResultFilterSensitiveLog,
  AssociationVersionInfoFilterSensitiveLog,
  ListAssociationVersionsResultFilterSensitiveLog,
  CommandFilterSensitiveLog,
  ListCommandsResultFilterSensitiveLog,
  InstanceInfoFilterSensitiveLog,
  NodeTypeFilterSensitiveLog,
  NodeFilterSensitiveLog,
  ListNodesResultFilterSensitiveLog,
  PutParameterRequestFilterSensitiveLog,
  FeatureNotAvailableException,
  AutomationStepNotFoundException,
  InvalidAutomationSignalException,
  SignalType,
  InvalidNotificationConfig,
  InvalidOutputFolder,
  InvalidRole,
  ServiceQuotaExceededException,
  InvalidAssociation,
  AutomationDefinitionNotFoundException,
  AutomationDefinitionVersionNotFoundException,
  AutomationExecutionLimitExceededException,
  InvalidAutomationExecutionParametersException,
  AutomationDefinitionNotApprovedException,
  ExecutionInputs,
  TargetNotConnected,
  InvalidAutomationStatusUpdateException,
  StopType,
  AssociationVersionLimitExceeded,
  InvalidUpdate,
  StatusUnchanged,
  DocumentVersionLimitExceeded,
  DuplicateDocumentContent,
  DuplicateDocumentVersionName,
  DocumentReviewAction,
  OpsMetadataKeyLimitExceededException,
  ResourceDataSyncConflictException,
  RegisterTargetWithMaintenanceWindowRequestFilterSensitiveLog,
  RegisterTaskWithMaintenanceWindowRequestFilterSensitiveLog,
  SendCommandRequestFilterSensitiveLog,
  SendCommandResultFilterSensitiveLog,
  UpdateAssociationRequestFilterSensitiveLog,
  UpdateAssociationResultFilterSensitiveLog,
  UpdateAssociationStatusResultFilterSensitiveLog,
  UpdateMaintenanceWindowRequestFilterSensitiveLog,
  UpdateMaintenanceWindowResultFilterSensitiveLog,
  UpdateMaintenanceWindowTargetRequestFilterSensitiveLog,
  UpdateMaintenanceWindowTargetResultFilterSensitiveLog,
  UpdateMaintenanceWindowTaskRequestFilterSensitiveLog,
  UpdateMaintenanceWindowTaskResultFilterSensitiveLog,
  UpdatePatchBaselineRequestFilterSensitiveLog,
  UpdatePatchBaselineResultFilterSensitiveLog
});

