import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { CreateAssociationBatchRequestFilterSensitiveLog, CreateAssociationBatchResultFilterSensitiveLog, } from "../models/models_0";
import { de_CreateAssociationBatchCommand, se_CreateAssociationBatchCommand } from "../protocols/Aws_json1_1";
export { $Command };
export class CreateAssociationBatchCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonSSM", "CreateAssociationBatch", {})
    .n("SSMClient", "CreateAssociationBatchCommand")
    .f(CreateAssociationBatchRequestFilterSensitiveLog, CreateAssociationBatchResultFilterSensitiveLog)
    .ser(se_CreateAssociationBatchCommand)
    .de(de_CreateAssociationBatchCommand)
    .build() {
}
